/*
 * Decompiled with CFR 0.152.
 */
package com.cdnbye.core.nat;

import com.cdnbye.core.nat.StunChangeRequest;
import com.cdnbye.core.nat.StunErrorCode;
import com.cdnbye.core.nat.StunMessageType;
import java.net.InetSocketAddress;
import java.util.Random;

public class StunMessage {
    private byte[] transactionId;
    private StunMessageType type = StunMessageType.BindingRequest;
    private int magicCookie;
    private InetSocketAddress mappedAddress;
    private InetSocketAddress responseAddress;
    private InetSocketAddress sourceAddress;
    private InetSocketAddress changedAddress;
    private StunChangeRequest changeRequest;
    private StunErrorCode errorCode;

    public byte[] getTransactionId() {
        return this.transactionId;
    }

    public StunMessageType getType() {
        return this.type;
    }

    public int getMagicCookie() {
        return this.magicCookie;
    }

    public InetSocketAddress getMappedAddress() {
        return this.mappedAddress;
    }

    public InetSocketAddress getResponseAddress() {
        return this.responseAddress;
    }

    public InetSocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public InetSocketAddress getChangedAddress() {
        return this.changedAddress;
    }

    public StunChangeRequest getChangeRequest() {
        return this.changeRequest;
    }

    public StunErrorCode getErrorCode() {
        return this.errorCode;
    }

    public StunMessage() {
        this.transactionId = new byte[12];
        new Random().nextBytes(this.transactionId);
    }

    public StunMessage(StunMessageType type) {
        this();
        this.type = type;
    }

    public StunMessage(StunMessageType type, StunChangeRequest changeRequest) {
        this();
        this.type = type;
        this.changeRequest = changeRequest;
    }

    public void parse(byte[] data) {
        int messageType;
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (data.length < 20) {
            throw new IllegalArgumentException("Invalid STUN message value !");
        }
        int offset = 0;
        if ((messageType = data[offset++] << 8 | data[offset++]) == StunMessageType.BindingErrorResponse.value()) {
            this.type = StunMessageType.BindingErrorResponse;
        } else if (messageType == StunMessageType.BindingRequest.value()) {
            this.type = StunMessageType.BindingRequest;
        } else if (messageType == StunMessageType.BindingResponse.value()) {
            this.type = StunMessageType.BindingResponse;
        } else if (messageType == StunMessageType.SharedSecretErrorResponse.value()) {
            this.type = StunMessageType.SharedSecretErrorResponse;
        } else if (messageType == StunMessageType.SharedSecretRequest.value()) {
            this.type = StunMessageType.SharedSecretRequest;
        } else if (messageType == StunMessageType.SharedSecretResponse.value()) {
            this.type = StunMessageType.SharedSecretResponse;
        } else {
            throw new IllegalArgumentException("Invalid STUN message type value !");
        }
        int messageLength = data[offset++] << 8 | data[offset++];
        this.magicCookie = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
        this.transactionId = new byte[12];
        System.arraycopy(data, offset, this.transactionId, 0, 12);
        offset += 12;
        while (offset - 20 < messageLength) {
            AttributeType type = AttributeType.getTypeByValue((data[offset++] << 8 | data[offset++]) & 0xFFFF);
            int length = data[offset++] << 8 | data[offset++];
            if (type == AttributeType.MappedAddress) {
                this.mappedAddress = StunMessage.parseIPAddr(data, offset);
                offset += 8;
                continue;
            }
            if (type == AttributeType.ResponseAddress) {
                this.responseAddress = StunMessage.parseIPAddr(data, offset);
                offset += 8;
                continue;
            }
            if (type == AttributeType.ChangeRequest) {
                this.changeRequest = new StunChangeRequest((data[offset += 3] & 4) != 0, (data[offset] & 2) != 0);
                ++offset;
                continue;
            }
            if (type == AttributeType.SourceAddress) {
                this.sourceAddress = StunMessage.parseIPAddr(data, offset);
                offset += 8;
                continue;
            }
            if (type == AttributeType.ChangedAddress) {
                this.changedAddress = StunMessage.parseIPAddr(data, offset);
                offset += 8;
                continue;
            }
            if (type == AttributeType.MessageIntegrity) {
                offset += length;
                continue;
            }
            if (type == AttributeType.ErrorCode) {
                int code = (data[offset + 2] & 7) * 100 + (data[offset + 3] & 0xFF);
                this.errorCode = new StunErrorCode(code, new String(data, offset + 4, length - 4));
                offset += length;
                continue;
            }
            if (type == AttributeType.UnknownAttribute) {
                offset += length;
                continue;
            }
            offset += length;
        }
    }

    public byte[] toByteData() {
        byte[] msg = new byte[512];
        int offset = 0;
        msg[offset++] = (byte)(this.type.value() >> 8 & 0x3F);
        msg[offset++] = (byte)(this.type.value() & 0xFF);
        msg[offset++] = 0;
        msg[offset++] = 0;
        msg[offset++] = (byte)(this.magicCookie >> 24 & 0xFF);
        msg[offset++] = (byte)(this.magicCookie >> 16 & 0xFF);
        msg[offset++] = (byte)(this.magicCookie >> 8 & 0xFF);
        msg[offset++] = (byte)(this.magicCookie & 0xFF);
        System.arraycopy(this.transactionId, 0, msg, offset, 12);
        offset += 12;
        if (this.mappedAddress != null) {
            StunMessage.storeEndPoint(AttributeType.MappedAddress, this.mappedAddress, msg, offset);
            offset += 12;
        } else if (this.responseAddress != null) {
            StunMessage.storeEndPoint(AttributeType.ResponseAddress, this.responseAddress, msg, offset);
            offset += 12;
        } else if (this.changeRequest != null) {
            msg[offset++] = (byte)(AttributeType.ChangeRequest.value() >> 8);
            msg[offset++] = (byte)(AttributeType.ChangeRequest.value() & 0xFF);
            msg[offset++] = 0;
            msg[offset++] = 4;
            msg[offset++] = 0;
            msg[offset++] = 0;
            msg[offset++] = 0;
            msg[offset++] = (byte)((this.changeRequest.isChangeIp() ? 1 : 0) << 2 | (this.changeRequest.isChangePort() ? 1 : 0) << 1);
        } else if (this.sourceAddress != null) {
            StunMessage.storeEndPoint(AttributeType.SourceAddress, this.sourceAddress, msg, offset);
            offset += 12;
        } else if (this.changedAddress != null) {
            StunMessage.storeEndPoint(AttributeType.ChangedAddress, this.changedAddress, msg, offset);
            offset += 12;
        } else if (this.errorCode != null) {
            byte[] reasonBytes = this.errorCode.getReasonText().getBytes();
            msg[offset++] = 0;
            msg[offset++] = (byte)AttributeType.ErrorCode.value();
            msg[offset++] = 0;
            msg[offset++] = (byte)(4 + reasonBytes.length);
            msg[offset++] = 0;
            msg[offset++] = 0;
            msg[offset++] = (byte)Math.floor((double)this.errorCode.getCode() / 100.0);
            msg[offset++] = (byte)(this.errorCode.getCode() & 0xFF);
            System.arraycopy(reasonBytes, 0, msg, offset, reasonBytes.length);
            offset += reasonBytes.length;
        }
        msg[2] = (byte)(offset - 20 >> 8);
        msg[3] = (byte)(offset - 20 & 0xFF);
        byte[] retVal = new byte[offset];
        System.arraycopy(msg, 0, retVal, 0, retVal.length);
        return retVal;
    }

    private static InetSocketAddress parseIPAddr(byte[] data, int offset) {
        ++offset;
        byte[] byArray = new byte[2];
        int n = ++offset;
        byArray[0] = data[n];
        int n2 = ++offset;
        byArray[1] = data[n2];
        byte[] portBytes = byArray;
        int port = StunMessage.bytes2Int(portBytes);
        int n3 = ++offset;
        int n4 = ++offset;
        int n5 = ++offset;
        int n6 = ++offset;
        ++offset;
        String ip = StunMessage.byte2Int(data[n3]) + "." + StunMessage.byte2Int(data[n4]) + "." + StunMessage.byte2Int(data[n5]) + "." + StunMessage.byte2Int(data[n6]);
        return new InetSocketAddress(ip, port);
    }

    private static String conver2HexStr(byte b) {
        return Long.toString(b & 0xFF, 2);
    }

    private static int byte2Int(byte b) {
        return Integer.valueOf(StunMessage.conver2HexStr(b), 2);
    }

    private static int bytes2Int(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (byte value : b) {
            result.append(StunMessage.conver2HexStr(value));
        }
        return Integer.valueOf(result.toString(), 2);
    }

    private static void storeEndPoint(AttributeType type, InetSocketAddress endPoint, byte[] message, int offset) {
        message[offset++] = (byte)(type.value >> 8);
        message[offset++] = (byte)(type.value & 0xFF);
        message[offset++] = 0;
        message[offset++] = 8;
        message[offset++] = 0;
        message[offset++] = 1;
        message[offset++] = (byte)(endPoint.getPort() >> 8);
        message[offset++] = (byte)(endPoint.getPort() & 0xFF);
        byte[] ipBytes = endPoint.getAddress().getAddress();
        message[offset++] = ipBytes[0];
        message[offset++] = ipBytes[1];
        message[offset++] = ipBytes[2];
        message[offset++] = ipBytes[3];
    }

    private static enum AttributeType {
        MappedAddress(1),
        ResponseAddress(2),
        ChangeRequest(3),
        SourceAddress(4),
        ChangedAddress(5),
        Username(6),
        Password(7),
        MessageIntegrity(8),
        ErrorCode(9),
        UnknownAttribute(10),
        ReflectedFrom(11),
        XorMappedAddress(32800),
        XorOnly(33),
        ServerName(32802);

        private int value = 0;

        private AttributeType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static AttributeType getTypeByValue(int value) {
            for (AttributeType at : AttributeType.values()) {
                if (at.value != value) continue;
                return at;
            }
            return null;
        }
    }
}

