/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class HistoryDao
extends AbstractPBHDao<HistoryEntity, Long> {
    private final Pattern sqlSafePattern = Pattern.compile("^[A-Za-z0-9]+$");

    public HistoryDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, HistoryEntity.class);
    }

    public synchronized HistoryEntity createIfNotExists(HistoryEntity data) throws SQLException {
        List list = this.queryForMatchingArgs(data);
        if (list.isEmpty()) {
            return (HistoryEntity)super.createIfNotExists((Object)data);
        }
        return (HistoryEntity)list.getFirst();
    }

    public Page<PeerBanCount> getBannedIps(Pageable pageable, String filter) throws Exception {
        List<PeerBanCount> mapped;
        QueryBuilder builder = this.queryBuilder().selectRaw(new String[]{"ip, COUNT(*) AS count"}).groupBy("ip").orderByRaw("count DESC");
        String[] args = new String[]{};
        if (filter != null) {
            builder.setWhere(builder.where().like("ip", (Object)new SelectArg()));
            args = new String[]{filter + "%"};
        }
        QueryBuilder queryBuilder = builder.limit(Long.valueOf(pageable.getSize())).offset(Long.valueOf(pageable.getZeroBasedPage() * pageable.getSize()));
        try (GenericRawResults banLogs = this.queryRaw(queryBuilder.prepareStatementString(), args);){
            List results = banLogs.getResults();
            mapped = results.stream().map(arr -> new PeerBanCount(arr[0], Long.parseLong(arr[1]))).toList();
        }
        QueryBuilder countBuilder = this.queryBuilder().selectColumns(new String[]{"ip"});
        if (filter != null) {
            countBuilder.setWhere(countBuilder.where().like("ip", (Object)new SelectArg((Object)(filter + "%"))));
        }
        return new Page<PeerBanCount>(pageable, countBuilder.countOf("DISTINCT ip"), mapped);
    }

    public List<UniversalFieldNumResult> sumField(String field, double percentFilter, String downloader, Integer substringLength) throws Exception {
        if (!this.sqlSafePattern.matcher(field).matches()) {
            throw new IllegalArgumentException("Invalid field: " + field + ", only A-Z a-z 0-9 is allowed.");
        }
        ArrayList<UniversalFieldNumResult> results = new ArrayList<UniversalFieldNumResult>();
        String sql = "SELECT\n                                 \t%field% AS %fieldraw%,\n                                 \tSUM( %field% ) AS ct,\n                                 \tSUM( %field% ) * 1.0 / ( SELECT SUM( %field% ) FROM history WHERE downloader LIKE ? ) AS percent ,\n                                 \ttorrentName,\n                                 \ttorrentInfoHash,\n                                 \tmodule\n                                 FROM\n                                 \t(\n                                 \tSELECT\n                                 \t\t*,\n                                 \t\ttorrents.infoHash AS torrentInfoHash,\n                                 \t\ttorrents.name AS torrentName,\n                                 \t\tmodules.name AS module \n                                 \tFROM\n                                 \t\t(\n                                 \t\t\t( ( history INNER JOIN torrents ON history.torrent_id = torrents.id ) INNER JOIN rules ON history.rule_id = rules.id ) \n                                 \t\t)\n                                 \t\tINNER JOIN modules ON modules.id = rules.module_id \n                                 \tWHERE downloader LIKE ? \n                                 \t) \n                                 GROUP BY\n                                 \t%field% \n                                 HAVING\n                                 \tpercent > %percent% \n                                 ORDER BY\n                                 \tct DESC;\n";
        sql = sql.replace("%percent%", String.valueOf(percentFilter)).replace("%fieldraw%", MsgUtil.escapeSql(field));
        sql = substringLength != null ? sql.replace("%field%", "SUBSTRING(" + MsgUtil.escapeSql(field) + ", 1, " + substringLength + ")") : sql.replace("%field%", MsgUtil.escapeSql(field));
        try (GenericRawResults resultSet = this.queryRaw(sql, new String[]{downloader == null ? "%" : downloader, downloader == null ? "%" : downloader});){
            for (String[] result : resultSet.getResults()) {
                results.add(new UniversalFieldNumResult(result[0], Long.parseLong(result[1]), Double.parseDouble(result[2])));
            }
        }
        return results;
    }

    public List<UniversalFieldNumResult> countField(String field, double percentFilter, String downloader, Integer substringLength) throws Exception {
        if (!this.sqlSafePattern.matcher(field).matches()) {
            throw new IllegalArgumentException("Invalid field: " + field + ", only A-Z a-z 0-9 is allowed.");
        }
        ArrayList<UniversalFieldNumResult> results = new ArrayList<UniversalFieldNumResult>();
        String sql = "SELECT\n                                 \t%field% AS %fieldraw%,\n                                 \tCOUNT( %field% ) AS ct,\n                                 \tCOUNT( %field% ) * 1.0 / ( SELECT COUNT( * ) FROM history WHERE downloader LIKE ? ) AS percent ,\n                                 \ttorrentName,\n                                 \ttorrentInfoHash,\n                                 \tmodule\n                                 FROM\n                                 \t(\n                                 \tSELECT\n                                 \t\t*,\n                                 \t\ttorrents.infoHash AS torrentInfoHash,\n                                 \t\ttorrents.name AS torrentName,\n                                 \t\tmodules.name AS module \n                                 \tFROM\n                                 \t\t(\n                                 \t\t\t( ( history INNER JOIN torrents ON history.torrent_id = torrents.id ) INNER JOIN rules ON history.rule_id = rules.id ) \n                                 \t\t)\n                                 \t\tINNER JOIN modules ON modules.id = rules.module_id \n                                 \tWHERE downloader LIKE ? \n                                 \t) \n                                 GROUP BY\n                                 \t%field% \n                                 HAVING\n                                 \tpercent > %percent% \n                                 ORDER BY\n                                 \tct DESC;\n";
        sql = sql.replace("%percent%", String.valueOf(percentFilter)).replace("%fieldraw%", MsgUtil.escapeSql(field));
        sql = substringLength != null ? sql.replace("%field%", "SUBSTRING(" + MsgUtil.escapeSql(field) + ", 1, " + substringLength + ")") : sql.replace("%field%", MsgUtil.escapeSql(field));
        try (GenericRawResults resultSet = this.queryRaw(sql, new String[]{downloader == null ? "%" : downloader, downloader == null ? "%" : downloader});){
            for (String[] result : resultSet.getResults()) {
                results.add(new UniversalFieldNumResult(result[0], Long.parseLong(result[1]), Double.parseDouble(result[2])));
            }
        }
        return results;
    }

    public List<UniversalFieldDateResult> countDateField(long startAt, long endAt, Function<HistoryEntity, Timestamp> timestampGetter, Function<Calendar, Calendar> timestampTrimmer, double percentFilter) throws Exception {
        HashMap<Long, AtomicLong> counterMap = new HashMap<Long, AtomicLong>();
        try (CloseableIterator it = this.iterator();){
            while (it.hasNext()) {
                HistoryEntity row = (HistoryEntity)it.next();
                Timestamp field = timestampGetter.apply(row);
                long fieldT = field.getTime();
                if (fieldT < startAt || fieldT > endAt) continue;
                Calendar fuckCal = Calendar.getInstance();
                fuckCal.setTime(field);
                Calendar trimmed = timestampTrimmer.apply(fuckCal);
                long time = trimmed.getTime().getTime();
                AtomicLong atomicLong = counterMap.getOrDefault(time, new AtomicLong(0L));
                atomicLong.incrementAndGet();
                counterMap.put(time, atomicLong);
            }
        }
        long total = counterMap.values().stream().mapToLong(AtomicLong::get).sum();
        ArrayList<UniversalFieldDateResult> results = new ArrayList<UniversalFieldDateResult>();
        for (Map.Entry dateMappingAtomicLongEntry : counterMap.entrySet()) {
            results.add(new UniversalFieldDateResult((Long)dateMappingAtomicLongEntry.getKey(), ((AtomicLong)dateMappingAtomicLongEntry.getValue()).get(), (double)((AtomicLong)dateMappingAtomicLongEntry.getValue()).get() / (double)total));
        }
        results.removeIf(r -> r.percent() < percentFilter);
        return results;
    }

    public record UniversalFieldNumResult(String data, long count, double percent) {
    }

    public record UniversalFieldDateResult(long timestamp, long count, double percent) {
    }

    public static class PeerBanCount {
        private String peerIp;
        private long count;

        @Generated
        public PeerBanCount() {
        }

        @Generated
        public PeerBanCount(String peerIp, long count) {
            this.peerIp = peerIp;
            this.count = count;
        }

        @Generated
        public String getPeerIp() {
            return this.peerIp;
        }

        @Generated
        public long getCount() {
            return this.count;
        }

        @Generated
        public void setPeerIp(String peerIp) {
            this.peerIp = peerIp;
        }

        @Generated
        public void setCount(long count) {
            this.count = count;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PeerBanCount)) {
                return false;
            }
            PeerBanCount other = (PeerBanCount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            String this$peerIp = this.getPeerIp();
            String other$peerIp = other.getPeerIp();
            return !(this$peerIp == null ? other$peerIp != null : !this$peerIp.equals(other$peerIp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PeerBanCount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $count = this.getCount();
            result = result * 59 + (int)($count >>> 32 ^ $count);
            String $peerIp = this.getPeerIp();
            result = result * 59 + ($peerIp == null ? 43 : $peerIp.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HistoryDao.PeerBanCount(peerIp=" + this.getPeerIp() + ", count=" + this.getCount() + ")";
        }
    }
}

