/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.biglybt;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerImpl;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import com.ghostchu.peerbanhelper.bittorrent.tracker.TrackerImpl;
import com.ghostchu.peerbanhelper.downloader.AbstractDownloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.downloader.DownloaderStatistics;
import com.ghostchu.peerbanhelper.downloader.exception.DownloaderRequestException;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.BiglyBTTorrent;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.ConnectorData;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.bean.clientbound.BanBean;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.bean.clientbound.BanListReplacementBean;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.bean.clientbound.SetListenPort;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.bean.clientbound.SetSpeedLimiterBean;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.bean.serverbound.CurrentListenPort;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.bean.serverbound.CurrentSpeedLimiterBean;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.bean.serverbound.MetadataCallbackBean;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.wrapper.DownloadRecord;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.wrapper.PeerManagerRecord;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.wrapper.PeerRecord;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.network.wrapper.StatisticsRecord;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.ByteUtil;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.vdurmont.semver4j.Semver;
import inet.ipaddr.IPAddress;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiglyBT
extends AbstractDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BiglyBT.class);
    private final String apiEndpoint;
    private final OkHttpClient httpClient;
    private final Config config;
    private final String connectorPayload;
    private Semver semver = new Semver("0.0.0");

    public BiglyBT(String uuid, Config config, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        super(uuid, alertManager, natAddressProvider);
        this.config = config;
        this.apiEndpoint = config.getEndpoint();
        CookieManager cm = new CookieManager();
        cm.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        OkHttpClient.Builder builder = httpUtil.newBuilderForDownloader().connectionPool(new ConnectionPool(this.getMaxConcurrentPeerRequestSlots() + 10, 5L, TimeUnit.MINUTES)).addInterceptor(chain -> {
            Request originalRequest = chain.request();
            Request newRequest = originalRequest.newBuilder().header("Content-Type", "application/json").header("Authorization", "Bearer " + config.getToken()).build();
            return chain.proceed(newRequest);
        });
        httpUtil.disableSSLVerify(builder, !config.isVerifySsl());
        this.httpClient = builder.build();
        this.connectorPayload = JsonUtil.getGson().toJson((Object)new ConnectorData("PeerBanHelper", Main.getMeta().getVersion(), Main.getMeta().getAbbrev()));
    }

    @Override
    @NotNull
    public String getName() {
        return this.config.getName();
    }

    public static BiglyBT loadFromConfig(String id, JsonObject section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        Config config = (Config)JsonUtil.getGson().fromJson(section.toString(), Config.class);
        return new BiglyBT(id, config, alertManager, httpUtil, natAddressProvider);
    }

    public static BiglyBT loadFromConfig(String id, ConfigurationSection section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        Config config = Config.readFromYaml(section, id);
        return new BiglyBT(id, config, alertManager, httpUtil, natAddressProvider);
    }

    @Override
    @NotNull
    public List<DownloaderFeatureFlag> getFeatureFlags() {
        return List.of(DownloaderFeatureFlag.READ_PEER_PROTOCOLS, DownloaderFeatureFlag.UNBAN_IP, DownloaderFeatureFlag.TRAFFIC_STATS, DownloaderFeatureFlag.LIVE_UPDATE_BT_PROTOCOL_PORT);
    }

    @Override
    public DownloaderSpeedLimiter getSpeedLimiter() {
        DownloaderSpeedLimiter downloaderSpeedLimiter;
        block9: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/speedlimiter").get().build();
            Response resp = this.httpClient.newCall(request).execute();
            try {
                if (!resp.isSuccessful()) {
                    throw new DownloaderRequestException(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_SPEED_LIMITER, this.getName(), resp.code(), resp.body()));
                }
                CurrentSpeedLimiterBean currentSpeedLimit = (CurrentSpeedLimiterBean)JsonUtil.getGson().fromJson(resp.body().string(), CurrentSpeedLimiterBean.class);
                downloaderSpeedLimiter = new DownloaderSpeedLimiter(currentSpeedLimit.getUpload(), currentSpeedLimit.getDownload());
                if (resp == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DownloaderRequestException(e);
                }
            }
            resp.close();
        }
        return downloaderSpeedLimiter;
    }

    @Override
    public void setSpeedLimiter(@NotNull DownloaderSpeedLimiter speedLimiter) {
        SetSpeedLimiterBean bean = new SetSpeedLimiterBean(speedLimiter.upload(), speedLimiter.download());
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson((Object)bean), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + "/speedlimiter").post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SET_SPEED_LIMITER, this.getName(), response.code(), response.body().string()));
                throw new DownloaderRequestException("Save BiglyBT SpeedLimiter error: statusCode=" + response.code());
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SET_SPEED_LIMITER, this.getName(), "N/A", e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getBTProtocolPort() {
        int n;
        block9: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/listenport").get().build();
            Response resp = this.httpClient.newCall(request).execute();
            try {
                if (!resp.isSuccessful()) {
                    throw new DownloaderRequestException(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_SPEED_LIMITER, this.getName(), resp.code(), resp.body()));
                }
                CurrentListenPort listenPort = (CurrentListenPort)JsonUtil.getGson().fromJson(resp.body().string(), CurrentListenPort.class);
                n = listenPort.getPort();
                if (resp == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DownloaderRequestException(e);
                }
            }
            resp.close();
        }
        return n;
    }

    @Override
    public void setBTProtocolPort(int port) {
        SetListenPort bean = new SetListenPort(port);
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson((Object)bean), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + "/listenport").post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SET_SPEED_LIMITER, this.getName(), response.code(), response.body().string()));
                throw new DownloaderRequestException("Save BiglyBT ListenPort error: statusCode=" + response.code());
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SET_SPEED_LIMITER, this.getName(), "N/A", e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public JsonObject saveDownloaderJson() {
        return JsonUtil.getGson().toJsonTree((Object)this.config).getAsJsonObject();
    }

    @Override
    @NotNull
    public YamlConfiguration saveDownloader() {
        return this.config.saveToYaml();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DownloaderLoginResult login0() {
        try {
            Request request = new Request.Builder().url(this.apiEndpoint + "/metadata").get().build();
            try (Response resp = this.httpClient.newCall(request).execute();){
                if (resp.isSuccessful()) {
                    MetadataCallbackBean metadataCallbackBean = (MetadataCallbackBean)JsonUtil.standard().fromJson(resp.body().string(), MetadataCallbackBean.class);
                    String version = metadataCallbackBean.getPluginVersion();
                    this.semver = new Semver(version);
                    if (this.semver.isLowerThan("1.3.0")) {
                        DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.REQUIRE_TAKE_ACTIONS, new TranslationComponent(Lang.DOWNLOADER_BIGLYBT_INCORRECT_ADAPTER_VERSION, "1.2.9"));
                        return downloaderLoginResult;
                    }
                    RequestBody requestBody = RequestBody.create((String)this.connectorPayload, (MediaType)MediaType.get((String)"application/json"));
                    Request setConnectorRequest = new Request.Builder().url(this.apiEndpoint + "/setconnector").post(requestBody).build();
                    try {
                        this.httpClient.newCall(setConnectorRequest).enqueue(new Callback(this){
                            {
                                Objects.requireNonNull(this$0);
                            }

                            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                                log.warn("Unable to set connector for BiglyBT: {}", (Object)e.getMessage(), (Object)e);
                            }

                            public void onResponse(@NotNull Call call, @NotNull Response response) {
                                response.close();
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.SUCCESS, new TranslationComponent(Lang.STATUS_TEXT_OK));
                    return downloaderLoginResult;
                }
                if (resp.code() == 403) {
                    DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.INCORRECT_CREDENTIAL, new TranslationComponent(Lang.DOWNLOADER_LOGIN_INCORRECT_CRED));
                    return downloaderLoginResult;
                }
                DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_LOGIN_EXCEPTION, "statusCode=" + resp.code()));
                return downloaderLoginResult;
            }
        }
        catch (Exception e) {
            return new DownloaderLoginResult(DownloaderLoginResult.Status.NETWORK_ERROR, new TranslationComponent(Lang.DOWNLOADER_LOGIN_IO_EXCEPTION, e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    @NotNull
    public String getEndpoint() {
        return this.apiEndpoint;
    }

    @Override
    @NotNull
    public String getType() {
        return "BiglyBT";
    }

    @Override
    public boolean isPaused() {
        return this.config.isPaused();
    }

    @Override
    public void setPaused(boolean paused) {
        super.setPaused(paused);
        this.config.setPaused(paused);
    }

    @Override
    public void setBanList(@NotNull Collection<IPAddress> fullList, @Nullable Collection<BanMetadata> added, @Nullable Collection<BanMetadata> removed, boolean applyFullList) {
        if (removed != null && removed.isEmpty() && added != null && this.config.isIncrementBan() && !applyFullList) {
            this.setBanListIncrement(added);
        } else {
            this.setBanListFull(fullList);
        }
    }

    @Override
    @NotNull
    public List<Torrent> getTorrents() {
        return this.fetchTorrents(List.of(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(8)), !this.config.isIgnorePrivate());
    }

    @Override
    @NotNull
    public List<Torrent> getAllTorrents() {
        return this.fetchTorrents(Collections.emptyList(), true);
    }

    private List<Torrent> fetchTorrents(List<Object> filtersUrlEncoded, boolean includePrivate) {
        ArrayList<BiglyBTTorrent> arrayList;
        block11: {
            StringBuilder urlBuilder = new StringBuilder(this.apiEndpoint + "/downloads");
            if (!filtersUrlEncoded.isEmpty()) {
                urlBuilder.append("?filter=");
                urlBuilder.append(String.join((CharSequence)"&filter=", (CharSequence[])filtersUrlEncoded.stream().map(Object::toString).toArray(String[]::new)));
            }
            Request request = new Request.Builder().url(urlBuilder.toString()).get().build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_BIGLYBT_INCORRECT_RESPONSE, response.code(), response.body().string()));
                }
                List torrentDetail = (List)JsonUtil.getGson().fromJson(response.body().string(), new TypeToken<List<DownloadRecord>>(this){
                    {
                        Objects.requireNonNull(this$0);
                    }
                }.getType());
                ArrayList<BiglyBTTorrent> torrents = new ArrayList<BiglyBTTorrent>();
                for (DownloadRecord detail : torrentDetail) {
                    if (!includePrivate && detail.getTorrent().isPrivateTorrent()) continue;
                    torrents.add(new BiglyBTTorrent(detail.getTorrent().getInfoHash(), detail.getName(), detail.getTorrent().getInfoHash(), detail.getTorrent().getSize(), detail.getTorrent().getSize() - detail.getStats().getRemainingBytes(), (double)detail.getStats().getCompletedInThousandNotation() / 1000.0, detail.getStats().getRtUploadSpeed(), detail.getStats().getRtDownloadSpeed(), detail.getTorrent().isPrivateTorrent(), detail.getTrackers()));
                }
                arrayList = torrents;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DownloaderRequestException(e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    @Override
    public int getMaxConcurrentPeerRequestSlots() {
        return ExternalSwitch.parseInt("pbh.downloader.BiglyBT.maxConcurrentPeerRequestSlots", 128);
    }

    @Override
    @NotNull
    public List<Tracker> getTrackers(@NotNull Torrent torrent) {
        BiglyBTTorrent biglyBTTorrent = (BiglyBTTorrent)torrent;
        if (biglyBTTorrent.getTrackers() == null) {
            return Collections.emptyList();
        }
        return biglyBTTorrent.getTrackers().stream().map(t -> new TrackerImpl((List<String>)t)).toList();
    }

    @Override
    public void setTrackers(@NotNull Torrent torrent, @NotNull List<Tracker> trackers) {
        StringBuilder sb = new StringBuilder();
        for (Tracker tracker : trackers) {
            tracker.getTrackersInGroup().forEach(t -> sb.append((String)t).append("\n"));
            sb.append("\n");
        }
        RequestBody requestBody = RequestBody.create((String)sb.toString().trim(), (MediaType)MediaType.get((String)"text/plain"));
        Request request = new Request.Builder().url(this.apiEndpoint + "/download/" + torrent.getId() + "/trackers").patch(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new DownloaderRequestException(TextManager.tlUI(Lang.TRACKER_FAILED_TO_UPDATE_TRACKER, torrent.getHash(), response.code(), response.body().string()));
            }
        }
        catch (IOException e) {
            throw new DownloaderRequestException(e);
        }
    }

    @Override
    @NotNull
    public DownloaderStatistics getStatistics() {
        DownloaderStatistics downloaderStatistics;
        block9: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/statistics").get().build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_FAILED_REQUEST_STATISTICS, response.code(), response.body().string()));
                }
                StatisticsRecord statisticsRecord = (StatisticsRecord)JsonUtil.getGson().fromJson(response.body().string(), StatisticsRecord.class);
                downloaderStatistics = new DownloaderStatistics(statisticsRecord.getOverallDataBytesSent(), statisticsRecord.getOverallDataBytesReceived());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DownloaderRequestException(e);
                }
            }
            response.close();
        }
        return downloaderStatistics;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public List<Peer> getPeers(@NotNull Torrent torrent) {
        Request request = new Request.Builder().url(this.apiEndpoint + "/download/" + torrent.getId() + "/peers").get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.code() == 404) {
                ArrayList<Peer> arrayList2 = new ArrayList<Peer>();
                return arrayList2;
            }
            if (!response.isSuccessful()) {
                throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_BIGLYBT_FAILED_REQUEST_PEERS_LIST_IN_TORRENT, response.code(), response.body().string()));
            }
            PeerManagerRecord peerManagerRecord = (PeerManagerRecord)JsonUtil.getGson().fromJson(response.body().string(), PeerManagerRecord.class);
            ArrayList<PeerImpl> peersList = new ArrayList<PeerImpl>();
            for (PeerRecord peer : peerManagerRecord.getPeers()) {
                byte[] peerId = ByteUtil.hexToByteArray(peer.getPeerId());
                if (peer.getIp() == null || peer.getIp().isBlank()) continue;
                if (peer.getIp().startsWith("/")) {
                    peer.setIp(peer.getIp().substring(1));
                }
                peersList.add(new PeerImpl(this.natTranslate(new PeerAddress(peer.getIp(), peer.getPort(), peer.getIp())), peerId, peer.getClient(), peer.getStats().getRtDownloadSpeed(), peer.getStats().getTotalReceived(), peer.getStats().getRtUploadSpeed(), peer.getStats().getTotalSent(), (double)peer.getPercentDoneInThousandNotation() / 1000.0, this.parseFlag(peer), peer.getState() != 30 && peer.getState() != 40));
            }
            ArrayList<PeerImpl> arrayList = peersList;
            return arrayList;
        }
        catch (IOException e) {
            throw new DownloaderRequestException(e);
        }
    }

    @Nullable
    private PeerFlag parseFlag(PeerRecord peer) {
        try {
            return new PeerFlag(peer.isInteresting(), peer.isChoking(), peer.isInterested(), peer.isChoked(), false, !peer.isIncoming(), !peer.isIncoming(), peer.getState() == 20, peer.getState() == 10, false, peer.isSeed(), peer.isOptimisticUnchoke(), peer.isSnubbed(), false, false, peer.getPeerSource() != null && "HolePunch".equals(peer.getPeerSource()), peer.getIp() != null && peer.getIp().endsWith(".i2p"), "uTP".equals(peer.getProtocol()), false, peer.isUseCrypto(), false, peer.getPeerSource() != null && "Tracker".equals(peer.getPeerSource()), peer.getPeerSource() != null && "DHT".equals(peer.getPeerSource()), peer.getPeerSource() != null && "PeerExchange".equals(peer.getPeerSource()), false, false, peer.isIncoming());
        }
        catch (Exception e) {
            log.debug("Failed to parse peer flag for peer: {}:{}: {}", new Object[]{peer.getIp(), peer.getPort(), peer, e});
            return null;
        }
    }

    private void setBanListIncrement(Collection<BanMetadata> added) {
        BanBean bean = new BanBean(added.stream().map(b -> this.remapBanListAddress(b.getPeer().getAddress().getAddress()).toNormalizedString()).distinct().toList());
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson((Object)bean), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + "/bans").post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_BIGLYBT_INCREAMENT_BAN_FAILED, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR", response.body().string()));
                throw new IllegalStateException("Save BiglyBT banlist error: statusCode=" + response.code());
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_BIGLYBT_INCREAMENT_BAN_FAILED, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private void setBanListFull(Collection<IPAddress> peerAddresses) {
        BanListReplacementBean bean = new BanListReplacementBean(peerAddresses.stream().map(ipaddr -> this.remapBanListAddress((IPAddress)ipaddr).toNormalizedString()).distinct().toList(), false);
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson((Object)bean), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + "/bans").put(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_BIGLYBT_FAILED_SAVE_BANLIST, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR", response.body().string()));
                throw new IllegalStateException("Save BiglyBT banlist error: statusCode=" + response.code());
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_BIGLYBT_FAILED_SAVE_BANLIST, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
    }

    public static class Config {
        private String name;
        private String type;
        private String endpoint;
        private String token;
        private boolean incrementBan;
        private boolean verifySsl;
        private boolean ignorePrivate;
        private boolean paused;

        public static Config readFromYaml(ConfigurationSection section, String alternativeName) {
            Config config = new Config();
            config.setType("biglybt");
            config.setEndpoint(section.getString("endpoint"));
            if (config.getEndpoint().endsWith("/")) {
                config.setEndpoint(config.getEndpoint().substring(0, config.getEndpoint().length() - 1));
            }
            config.setName(section.getString("name", alternativeName));
            config.setToken(section.getString("token", ""));
            config.setIncrementBan(section.getBoolean("increment-ban", true));
            config.setVerifySsl(section.getBoolean("verify-ssl", true));
            config.setIgnorePrivate(section.getBoolean("ignore-private", false));
            config.setPaused(section.getBoolean("paused", false));
            return config;
        }

        public YamlConfiguration saveToYaml() {
            YamlConfiguration section = new YamlConfiguration();
            section.set("type", (Object)"biglybt");
            section.set("name", (Object)this.name);
            section.set("endpoint", (Object)this.endpoint);
            section.set("token", (Object)this.token);
            section.set("increment-ban", (Object)this.incrementBan);
            section.set("ignore-private", (Object)this.ignorePrivate);
            section.set("verify-ssl", (Object)this.verifySsl);
            section.set("paused", (Object)this.paused);
            return section;
        }

        @Generated
        public Config() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public boolean isIncrementBan() {
            return this.incrementBan;
        }

        @Generated
        public boolean isVerifySsl() {
            return this.verifySsl;
        }

        @Generated
        public boolean isIgnorePrivate() {
            return this.ignorePrivate;
        }

        @Generated
        public boolean isPaused() {
            return this.paused;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public void setIncrementBan(boolean incrementBan) {
            this.incrementBan = incrementBan;
        }

        @Generated
        public void setVerifySsl(boolean verifySsl) {
            this.verifySsl = verifySsl;
        }

        @Generated
        public void setIgnorePrivate(boolean ignorePrivate) {
            this.ignorePrivate = ignorePrivate;
        }

        @Generated
        public void setPaused(boolean paused) {
            this.paused = paused;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isIncrementBan() != other.isIncrementBan()) {
                return false;
            }
            if (this.isVerifySsl() != other.isVerifySsl()) {
                return false;
            }
            if (this.isIgnorePrivate() != other.isIgnorePrivate()) {
                return false;
            }
            if (this.isPaused() != other.isPaused()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isIncrementBan() ? 79 : 97);
            result = result * 59 + (this.isVerifySsl() ? 79 : 97);
            result = result * 59 + (this.isIgnorePrivate() ? 79 : 97);
            result = result * 59 + (this.isPaused() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BiglyBT.Config(name=" + this.getName() + ", type=" + this.getType() + ", endpoint=" + this.getEndpoint() + ", token=" + this.getToken() + ", incrementBan=" + this.isIncrementBan() + ", verifySsl=" + this.isVerifySsl() + ", ignorePrivate=" + this.isIgnorePrivate() + ", paused=" + this.isPaused() + ")";
        }
    }
}

