/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.metric.impl.persist;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.ModuleDao;
import com.ghostchu.peerbanhelper.database.dao.impl.RuleDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.database.table.ModuleEntity;
import com.ghostchu.peerbanhelper.database.table.RuleEntity;
import com.ghostchu.peerbanhelper.database.table.TorrentEntity;
import com.ghostchu.peerbanhelper.metric.BasicMetrics;
import com.ghostchu.peerbanhelper.metric.impl.inmemory.InMemoryMetrics;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.j256.ormlite.stmt.DeleteBuilder;
import inet.ipaddr.IPAddress;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="persistMetrics")
public final class PersistMetrics
implements BasicMetrics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersistMetrics.class);
    private final InMemoryMetrics inMemory;
    private final TorrentDao torrentDao;
    private final ModuleDao moduleDao;
    private final RuleDao ruleDao;
    private final HistoryDao historyDao;

    public PersistMetrics(HistoryDao historyDao, RuleDao ruleDao, ModuleDao moduleDao, TorrentDao torrentDao, InMemoryMetrics inMemory) {
        this.historyDao = historyDao;
        this.ruleDao = ruleDao;
        this.moduleDao = moduleDao;
        this.torrentDao = torrentDao;
        this.inMemory = inMemory;
        CommonUtil.getScheduler().scheduleWithFixedDelay(this::cleanup, 0L, 1L, TimeUnit.DAYS);
    }

    private void cleanup() {
        try {
            int keepDays = Main.getMainConfig().getInt("persist.ban-logs-keep-days");
            if (keepDays > 0) {
                try {
                    DeleteBuilder builder = this.historyDao.deleteBuilder();
                    builder.setWhere(builder.where().le("banAt", (Object)new Timestamp(LocalDateTime.now().minusDays(keepDays).toInstant(MiscUtil.getSystemZoneOffset()).toEpochMilli())));
                    log.info(TextManager.tlUI(Lang.CLEANED_BANLOGS, builder.delete()));
                }
                catch (Exception e) {
                    log.error("Unable to cleanup expired banlogs", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            log.error("Unable to complete scheduled tasks", throwable);
        }
    }

    @Override
    public long getCheckCounter() {
        return this.inMemory.getCheckCounter();
    }

    @Override
    public long getPeerBanCounter() {
        return this.inMemory.getPeerBanCounter();
    }

    @Override
    public long getPeerUnbanCounter() {
        return this.inMemory.getPeerUnbanCounter();
    }

    @Override
    public long getSavedTraffic() {
        return this.inMemory.getSavedTraffic();
    }

    @Override
    public long getWastedTraffic() {
        return this.inMemory.getWastedTraffic();
    }

    @Override
    public void recordCheck() {
        this.inMemory.recordCheck();
    }

    @Override
    public void recordPeerBan(@NotNull IPAddress address, @NotNull BanMetadata metadata) {
        if (metadata.isBanForDisconnect()) {
            return;
        }
        this.inMemory.recordPeerBan(address, metadata);
        try {
            TorrentEntity torrentEntity = this.torrentDao.createIfNotExists(new TorrentEntity(null, metadata.getTorrent().getHash(), metadata.getTorrent().getName(), metadata.getTorrent().getSize(), metadata.getTorrent().isPrivateTorrent()));
            ModuleEntity module = this.moduleDao.createIfNotExists(new ModuleEntity(null, metadata.getContext()));
            RuleEntity rule = this.ruleDao.createIfNotExists(new RuleEntity(null, module, metadata.getRule()));
            this.historyDao.create(new HistoryEntity(null, new Timestamp(metadata.getBanAt()), new Timestamp(metadata.getUnbanAt()), address.toNormalizedString(), metadata.getPeer().getAddress().getPort(), metadata.getPeer().getId(), metadata.getPeer().getClientName(), metadata.getPeer().getUploaded(), metadata.getPeer().getDownloaded(), metadata.getPeer().getProgress(), metadata.getTorrent().getProgress(), torrentEntity, rule, metadata.getDescription(), metadata.getPeer().getFlags() == null ? null : metadata.getPeer().getFlags(), metadata.getDownloader().id(), metadata.getStructuredData() == null ? null : JsonUtil.standard().toJson(metadata.getStructuredData())));
        }
        catch (SQLException e) {
            log.error(TextManager.tlUI(Lang.DATABASE_SAVE_BUFFER_FAILED, new Object[0]), (Throwable)e);
        }
    }

    @Override
    public void recordPeerUnban(@NotNull IPAddress address, @NotNull BanMetadata metadata) {
        if (metadata.isBanForDisconnect()) {
            return;
        }
        this.inMemory.recordPeerUnban(address, metadata);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.inMemory.close();
        this.flush();
    }
}

