/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.platform.impl.win32.amsi;

import com.ghostchu.peerbanhelper.platform.impl.win32.amsi.AmsiLib;
import com.ghostchu.peerbanhelper.platform.types.MalwareScanner;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmsiScanner
implements MalwareScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmsiScanner.class);
    private boolean available;
    private Pointer amsiContext;
    private Pointer amsiSession;

    public AmsiScanner(String appName) {
        try {
            PointerByReference ctxRef = new PointerByReference();
            int hr = AmsiLib.INSTANCE.AmsiInitialize(appName, ctxRef);
            if (hr != 0) {
                throw new IllegalStateException("Failed to initialize AMSI. HRESULT: " + hr);
            }
            this.amsiContext = ctxRef.getValue();
            PointerByReference sessRef = new PointerByReference();
            AmsiLib.INSTANCE.AmsiOpenSession(this.amsiContext, sessRef);
            this.amsiSession = sessRef.getValue();
            this.available = true;
        }
        catch (Exception e) {
            this.available = false;
            log.debug("Unable to initialize AMSI: {}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isMalicious(@NotNull File file) throws UnsupportedOperationException {
        if (!this.available) {
            throw new UnsupportedOperationException("AMSI is not available.");
        }
        String filePath = file.getAbsolutePath();
        try (RandomAccessFile raf = new RandomAccessFile(filePath, "r");){
            boolean bl;
            block14: {
                FileChannel channel = raf.getChannel();
                try {
                    long fileSize = channel.size();
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
                    Pointer pointer = Native.getDirectBufferPointer((Buffer)buffer);
                    int[] result = new int[1];
                    AmsiLib.INSTANCE.AmsiScanBuffer(this.amsiContext, pointer, (int)fileSize, new WString(filePath), this.amsiSession, result);
                    boolean bl2 = bl = result[0] >= 32768;
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return bl;
        }
        catch (Exception e) {
            log.debug("AMSI scan file failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isMalicious(@NotNull String content) throws UnsupportedOperationException {
        if (!this.available) {
            throw new UnsupportedOperationException("AMSI is not available.");
        }
        int[] result = new int[1];
        AmsiLib.INSTANCE.AmsiScanString(this.amsiContext, new WString(content), new WString("StringScan"), this.amsiSession, result);
        return result[0] >= 32768;
    }

    @Override
    public void close() {
        if (AmsiLib.INSTANCE != null && this.amsiContext != null) {
            if (this.amsiSession != null) {
                AmsiLib.INSTANCE.AmsiCloseSession(this.amsiContext, this.amsiSession);
            }
            AmsiLib.INSTANCE.AmsiUninitialize(this.amsiContext);
        }
    }
}

