/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.platform.impl.win32.workingset.jna;

import com.ghostchu.peerbanhelper.platform.impl.win32.common.Kernel32;
import com.ghostchu.peerbanhelper.platform.impl.win32.common.PSAPI;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsWorkingSetManager {
    private static final Logger logger = LoggerFactory.getLogger(WindowsWorkingSetManager.class);
    private static final long WORKING_SET_SIZE_AUTO = -1L;
    private final Kernel32 kernel32 = Kernel32.INSTANCE;
    private final PSAPI psapi = PSAPI.INSTANCE;
    private final WinNT.HANDLE currentProcessHandle = this.kernel32.GetCurrentProcess();

    public WindowsWorkingSetManager() {
        if (this.currentProcessHandle == null) {
            throw new RuntimeException("Unable to retrieve current process handle");
        }
    }

    public boolean emptyWorkingSet() {
        try {
            boolean result = this.psapi.EmptyWorkingSet(this.currentProcessHandle);
            if (!result) {
                int errorCode = this.kernel32.GetLastError();
                logger.warn("Unable to empty working set {}", (Object)errorCode);
            }
            return result;
        }
        catch (Exception e) {
            logger.error("Error while empty working set", (Throwable)e);
            return false;
        }
    }

    public boolean setWorkingSetSize(long minSizeBytes, long maxSizeBytes) {
        try {
            WinDef.DWORD minSize = new WinDef.DWORD(minSizeBytes);
            WinDef.DWORD maxSize = new WinDef.DWORD(maxSizeBytes);
            boolean result = this.kernel32.SetProcessWorkingSetSize(this.currentProcessHandle, minSize, maxSize);
            if (!result) {
                int errorCode = this.kernel32.GetLastError();
                logger.warn("Unable to set working set size: {}", (Object)errorCode);
            }
            return result;
        }
        catch (Exception e) {
            logger.error("Unable to set working set size", (Throwable)e);
            return false;
        }
    }

    public boolean setAutoManageWorkingSet() {
        return this.setWorkingSetSize(-1L, -1L);
    }

    public boolean compressMemory(long targetSizeBytes) {
        try {
            boolean overallResult;
            boolean setResult = this.setWorkingSetSize(targetSizeBytes, targetSizeBytes);
            if (!setResult) {
                logger.warn("Failed to set working set size to target size: {}", (Object)targetSizeBytes);
            }
            boolean emptyResult = this.emptyWorkingSet();
            boolean autoResult = this.setAutoManageWorkingSet();
            if (!autoResult) {
                logger.warn("Failed to restore working set to auto management");
            }
            if (!(overallResult = emptyResult)) {
                logger.warn("Failed to compress memory, empty working set failed");
            }
            return overallResult;
        }
        catch (Exception e) {
            logger.error("Failed to working set", (Throwable)e);
            return false;
        }
    }

    public boolean trimMemory() {
        return this.emptyWorkingSet();
    }
}

