/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    private static final ScheduledExecutorService GENERAL_SCHEDULER = Executors.newScheduledThreadPool(8, Thread.ofPlatform().name("CommonScheduler").factory());

    public static ScheduledExecutorService getScheduler() {
        return GENERAL_SCHEDULER;
    }

    public static void deleteFileOrDirectory(@NotNull File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        try (Stream<Path> stream = Files.walk(file.toPath(), new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    log.warn("Failed to delete file or directory: {}", path, (Object)e);
                }
            });
        }
        catch (IOException e) {
            log.warn("Failed to delete file or directory: {}", (Object)file, (Object)e);
        }
    }

    @NotNull
    public static String getClassPath(@NotNull Class<?> clazz) {
        String jarPath = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        jarPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8);
        return jarPath;
    }

    @NotNull
    public static File getAppJarFile(@NotNull Class<?> clazz) throws FileNotFoundException {
        String path = CommonUtil.getClassJarPath(clazz);
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + path);
        }
        return file;
    }

    @NotNull
    public static String getClassJarPath(@NotNull Class<?> clazz) {
        return CommonUtil.getClassPath(clazz);
    }
}

