/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import com.ghostchu.peerbanhelper.Main;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IPAddressUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IPAddressUtil.class);
    private static final IPAddress INVALID_ADDRESS_MISSINGNO = new IPAddressString("127.123.123.123").getAddress();

    @Contract(value="null -> null", pure=true)
    public static IPAddress getIPAddress(String ip) {
        if (ip == null) {
            return null;
        }
        if (ip.startsWith("[") && ip.endsWith("]")) {
            ip = ip.substring(1, ip.length() - 1);
        }
        String ipFinal = ip;
        try {
            IPAddress ipAddress = new IPAddressString(ipFinal).toAddress();
            if (ipAddress.isIPv4Convertible()) {
                ipAddress = ipAddress.toIPv4();
            }
            return ipAddress;
        }
        catch (AddressStringException e) {
            log.error("Unable to get ipaddress from ip {}", (Object)ipFinal, (Object)e);
            return INVALID_ADDRESS_MISSINGNO;
        }
        catch (Exception e) {
            log.error("Unable to get ipaddress from ip {} because an unknown error, returning default.", (Object)ipFinal, (Object)e);
            return INVALID_ADDRESS_MISSINGNO;
        }
    }

    @Nullable
    public static IPAddress getIPAddressNoAutoConversation(String ip) {
        try {
            return new IPAddressString(ip).toAddress();
        }
        catch (AddressStringException e) {
            log.error("Unable to get ipaddress from ip {}", (Object)ip, (Object)e);
            return INVALID_ADDRESS_MISSINGNO;
        }
    }

    @NotNull
    public static IPAddress toPrefixBlockAndZeroHost(IPAddress ipAddress, int length) {
        return ipAddress.withoutPrefixLength().toPrefixBlock(length).toZeroHost();
    }

    public static String adaptIP(byte[] localAddress) throws UnknownHostException {
        if (localAddress.length == 0) {
            return "127.0.0.1";
        }
        byte[] ipBytes = IPAddressUtil.normalizeAddress(localAddress);
        InetAddress inetAddress = InetAddress.getByAddress(ipBytes);
        if (inetAddress instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            if (inet4Address.isAnyLocalAddress()) {
                return "127.0.0.1";
            }
            return inetAddress.getHostAddress();
        }
        if (inetAddress instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            if (inet6Address.isAnyLocalAddress()) {
                return "127.0.0.1";
            }
            String hostAddress = inet6Address.getHostAddress();
            if (hostAddress.contains(":")) {
                return "[" + hostAddress + "]";
            }
            return hostAddress;
        }
        throw new IllegalStateException("Unreachable code");
    }

    public static byte[] normalizeAddress(byte[] localAddress) {
        if (localAddress.length == 4) {
            return localAddress;
        }
        if (localAddress.length <= 16) {
            byte[] fullAddress = new byte[16];
            System.arraycopy(localAddress, 0, fullAddress, 0, localAddress.length);
            return fullAddress;
        }
        throw new IllegalArgumentException("Invalid address length: " + localAddress.length);
    }

    @NotNull
    public static IPAddress remapBanListAddress(@NotNull IPAddress banAddress) {
        boolean ipv4RemappingEnabled = Main.getMainConfig().getBoolean("banlist-remapping.ipv4.enabled");
        boolean ipv6RemappingEnabled = Main.getMainConfig().getBoolean("banlist-remapping.ipv6.enabled");
        if (banAddress.isIPv4() && ipv4RemappingEnabled) {
            int remapRange = Main.getMainConfig().getInt("banlist-remapping.ipv4.remap-range");
            if (banAddress.getPrefixLength() != null && banAddress.getPrefixLength() >= remapRange) {
                return banAddress.toPrefixBlock();
            }
            return IPAddressUtil.toPrefixBlockAndZeroHost(banAddress, remapRange);
        }
        if (banAddress.isIPv6() && ipv6RemappingEnabled) {
            int remapRange = Main.getMainConfig().getInt("banlist-remapping.ipv6.remap-range");
            if (banAddress.getPrefixLength() != null && banAddress.getPrefixLength() >= remapRange) {
                return banAddress.toPrefixBlock();
            }
            return IPAddressUtil.toPrefixBlockAndZeroHost(banAddress, remapRange);
        }
        return banAddress.toPrefixBlock();
    }
}

