/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.geoip2.JsonSerializable;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.MaxMind;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Subdivision;
import com.maxmind.geoip2.record.Traits;
import java.util.ArrayList;
import java.util.List;

public record EnterpriseResponse(@JsonProperty(value="city") @MaxMindDbParameter(name="city") City city, @JsonProperty(value="continent") @MaxMindDbParameter(name="continent") Continent continent, @JsonProperty(value="country") @MaxMindDbParameter(name="country") Country country, @JsonProperty(value="location") @MaxMindDbParameter(name="location") Location location, @JsonProperty(value="maxmind") @MaxMindDbParameter(name="maxmind") MaxMind maxmind, @JsonProperty(value="postal") @MaxMindDbParameter(name="postal") Postal postal, @JsonProperty(value="registered_country") @MaxMindDbParameter(name="registered_country") Country registeredCountry, @JsonProperty(value="represented_country") @MaxMindDbParameter(name="represented_country") RepresentedCountry representedCountry, @JsonProperty(value="subdivisions") @MaxMindDbParameter(name="subdivisions") List<Subdivision> subdivisions, @JsonProperty(value="traits") @MaxMindDbParameter(name="traits") Traits traits) implements JsonSerializable
{
    public EnterpriseResponse {
        city = city != null ? city : new City();
        continent = continent != null ? continent : new Continent();
        country = country != null ? country : new Country();
        location = location != null ? location : new Location();
        maxmind = maxmind != null ? maxmind : new MaxMind();
        postal = postal != null ? postal : new Postal();
        registeredCountry = registeredCountry != null ? registeredCountry : new Country();
        representedCountry = representedCountry != null ? representedCountry : new RepresentedCountry();
        subdivisions = subdivisions != null ? List.copyOf(subdivisions) : List.of();
        traits = traits != null ? traits : new Traits();
    }

    public EnterpriseResponse(EnterpriseResponse response, List<String> locales) {
        this(new City(response.city(), locales), new Continent(response.continent(), locales), new Country(response.country(), locales), response.location(), response.maxmind(), response.postal(), new Country(response.registeredCountry(), locales), new RepresentedCountry(response.representedCountry(), locales), EnterpriseResponse.mapSubdivisions(response.subdivisions(), locales), response.traits());
    }

    private static ArrayList<Subdivision> mapSubdivisions(List<Subdivision> subdivisions, List<String> locales) {
        ArrayList<Subdivision> subdivisions2 = new ArrayList<Subdivision>(subdivisions.size());
        for (Subdivision subdivision : subdivisions) {
            subdivisions2.add(new Subdivision(subdivision, locales));
        }
        return subdivisions2;
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public City getCity() {
        return this.city();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Continent getContinent() {
        return this.continent();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Country getCountry() {
        return this.country();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Location getLocation() {
        return this.location();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="maxmind")
    public MaxMind getMaxMind() {
        return this.maxmind();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Postal getPostal() {
        return this.postal();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="registered_country")
    public Country getRegisteredCountry() {
        return this.registeredCountry();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="represented_country")
    public RepresentedCountry getRepresentedCountry() {
        return this.representedCountry();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public List<Subdivision> getSubdivisions() {
        return new ArrayList<Subdivision>(this.subdivisions());
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Traits getTraits() {
        return this.traits();
    }

    @JsonIgnore
    public Subdivision mostSpecificSubdivision() {
        if (this.subdivisions().isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions().get(this.subdivisions().size() - 1);
    }

    @JsonIgnore
    @Deprecated(since="5.0.0", forRemoval=true)
    public Subdivision getMostSpecificSubdivision() {
        return this.mostSpecificSubdivision();
    }

    @JsonIgnore
    public Subdivision leastSpecificSubdivision() {
        if (this.subdivisions().isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions().get(0);
    }

    @JsonIgnore
    @Deprecated(since="5.0.0", forRemoval=true)
    public Subdivision getLeastSpecificSubdivision() {
        return this.leastSpecificSubdivision();
    }
}

