/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.database.table.PeerConnectionMetricsTrackEntity;
import com.ghostchu.peerbanhelper.database.table.TorrentEntity;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PeerConnectionMetricsTrackDao
extends AbstractPBHDao<PeerConnectionMetricsTrackEntity, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerConnectionMetricsTrackDao.class);
    private final Cache<@NotNull CacheKey, @NotNull PeerConnectionMetricsTrackEntity> cache = CacheBuilder.newBuilder().maximumSize((long)ExternalSwitch.parseInt("pbh.module.session-analyse-service-module.cache-size", 1000)).expireAfterAccess(3L, TimeUnit.MINUTES).removalListener(notification -> {
        PeerConnectionMetricsTrackEntity v = (PeerConnectionMetricsTrackEntity)notification.getValue();
        try {
            this.createOrUpdate(v);
        }
        catch (SQLException e) {
            log.error("Unable flush back to database for sessionAnalyseServiceModule {}", (Object)v, (Object)e);
        }
    }).softValues().build();

    public PeerConnectionMetricsTrackDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, PeerConnectionMetricsTrackEntity.class);
    }

    public void flushAll() {
        try {
            this.callBatchTasks(() -> {
                for (PeerConnectionMetricsTrackEntity value : this.cache.asMap().values()) {
                    try {
                        this.createOrUpdate(value);
                    }
                    catch (SQLException e) {
                        log.error("Unable flush back to database for PeerConnectionMetricsTrack: {}", (Object)value, (Object)e);
                    }
                }
                return null;
            });
        }
        catch (SQLException e) {
            log.error("Unable to flush all tracked swarm cache to database", (Throwable)e);
        }
    }

    public int deleteEntries(@NotNull List<PeerConnectionMetricsTrackEntity> entities) throws SQLException {
        return this.callBatchTasks(() -> {
            int deleted = 0;
            for (PeerConnectionMetricsTrackEntity entity : entities) {
                deleted += this.delete(entity);
            }
            return deleted;
        });
    }

    public void syncPeers(@NotNull Downloader downloader, @NotNull Torrent torrent, @NotNull List<Peer> peers, TorrentDao torrentDao) throws SQLException, ExecutionException {
        TorrentEntity torrentEntity = torrentDao.createIfNotExists(new TorrentEntity(null, torrent.getHash(), torrent.getName(), torrent.getSize(), torrent.isPrivate()));
        for (Peer peer : peers) {
            if (peer.isHandshaking()) continue;
            CacheKey cacheKey = new CacheKey(new Timestamp(MiscUtil.getStartOfToday(System.currentTimeMillis())), downloader.getId(), torrentEntity.getId(), peer.getPeerAddress().getAddress().toNormalizedString(), peer.getPeerAddress().getPort());
            PeerConnectionMetricsTrackEntity trackEntity = (PeerConnectionMetricsTrackEntity)this.cache.get((Object)cacheKey, () -> {
                PeerConnectionMetricsTrackEntity entity = (PeerConnectionMetricsTrackEntity)this.queryBuilder().where().eq("timeframeAt", (Object)cacheKey.timeframeAt).and().eq("downloader", (Object)cacheKey.downloader).and().eq("torrent_id", (Object)cacheKey.torrentId).and().eq("address", (Object)cacheKey.address).and().eq("port", (Object)cacheKey.port).queryForFirst();
                if (entity == null) {
                    entity = new PeerConnectionMetricsTrackEntity();
                    entity.setTimeframeAt(cacheKey.timeframeAt);
                    entity.setDownloader(downloader.getId());
                    entity.setTorrent(torrentEntity);
                    entity.setAddress(peer.getPeerAddress().getAddress().toNormalizedString());
                    entity.setPort(peer.getPeerAddress().getPort());
                }
                return entity;
            });
            trackEntity.setPeerId(peer.getPeerId());
            trackEntity.setClientName(peer.getClientName());
            trackEntity.setLastFlags(peer.getFlags() == null ? null : peer.getFlags().getLtStdString());
        }
    }

    public record CacheKey(Timestamp timeframeAt, String downloader, long torrentId, String address, int port) {
    }
}

