/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerConnectionMetricDao;
import com.ghostchu.peerbanhelper.database.dao.impl.tmp.TrackedSwarmDao;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.metric.BasicMetrics;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.SimpleLongIntKVDTO;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.lang.runtime.SwitchBootstraps;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public final class PBHMetricsController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHMetricsController.class);
    @Autowired
    @Qualifier(value="persistMetrics")
    private BasicMetrics metrics;
    @Autowired
    private HistoryDao historyDao;
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private DownloaderServer downloaderServer;
    @Autowired
    private TrackedSwarmDao trackedSwarmDao;
    @Autowired
    private PeerConnectionMetricDao peerConnectionMetricDao;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/statistic/counter", this::handleBasicCounter, new RouteRole[]{Role.USER_READ})).get("/api/statistic/analysis/field", this::handleHistoryNumberAccess, new RouteRole[]{Role.USER_READ})).get("/api/statistic/analysis/banTrends", this::handleBanTrends, new RouteRole[]{Role.USER_READ})).get("/api/statistic/analysis/date", this::handleHistoryDateAccess, new RouteRole[]{Role.USER_READ});
    }

    private void handleBanTrends(Context ctx) throws Exception {
        String downloader = ctx.queryParam("downloader");
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        ConcurrentHashMap<Long, AtomicInteger> bannedPeerTrends = new ConcurrentHashMap<Long, AtomicInteger>();
        Where queryBanned = this.historyDao.queryBuilder().selectColumns(new String[]{"id", "banAt"}).where().ge("banAt", (Object)timeQueryModel.startAt()).and().le("banAt", (Object)timeQueryModel.endAt());
        if (downloader != null && !downloader.isBlank()) {
            queryBanned.and().eq("downloader", (Object)new SelectArg((Object)downloader));
        }
        try (CloseableIterator it = queryBanned.iterator();){
            while (it.hasNext()) {
                long startOfDay = MiscUtil.getStartOfToday(((HistoryEntity)it.next()).getBanAt().getTime());
                bannedPeerTrends.computeIfAbsent(startOfDay, k -> new AtomicInteger()).addAndGet(1);
            }
        }
        ctx.json((Object)new StdResp(true, null, bannedPeerTrends.entrySet().stream().map(e -> new SimpleLongIntKVDTO((Long)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted(Comparator.comparingLong(SimpleLongIntKVDTO::key)).toList()));
    }

    private void handleHistoryDateAccess(Context ctx) throws Exception {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String filter = Objects.requireNonNullElse(ctx.queryParam("filter"), "0.0");
        String type = ctx.queryParam("type");
        String field = ctx.queryParam("field");
        if (field == null) {
            throw new IllegalArgumentException("startAt cannot be null");
        }
        if (field.equalsIgnoreCase("banAt") && "day".equals(type)) {
            this.handlePeerBans(ctx);
            return;
        }
        String string = type;
        int n = 0;
        Function<Calendar, Calendar> trimmer = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"year", "month", "day", "hour", "minute", "second"}, (String)string, n)) {
            case 0 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                return calendar;
            };
            case 1 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                return calendar;
            };
            case 2 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                calendar.set(5, time.get(5));
                return calendar;
            };
            case 3 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                calendar.set(5, time.get(5));
                calendar.set(11, time.get(11));
                return calendar;
            };
            case 4 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                calendar.set(5, time.get(5));
                calendar.set(11, time.get(11));
                calendar.set(12, time.get(12));
                return calendar;
            };
            case 5 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                calendar.set(5, time.get(5));
                calendar.set(11, time.get(11));
                calendar.set(12, time.get(12));
                calendar.set(13, time.get(13));
                return calendar;
            };
            default -> throw new IllegalArgumentException("Unexpected value: " + type);
        };
        String string2 = field;
        int n2 = 0;
        Function<HistoryEntity, Timestamp> timestampGetter = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"banAt", "unbanAt"}, (String)string2, n2)) {
            case 0 -> HistoryEntity::getBanAt;
            case 1 -> HistoryEntity::getUnbanAt;
            default -> throw new IllegalArgumentException("Unexpected value: " + field);
        };
        long startAt = timeQueryModel.startAt().getTime();
        long endAt = timeQueryModel.endAt().getTime();
        double pctFilter = Double.parseDouble(filter);
        List<HistoryDao.UniversalFieldDateResult> results = this.historyDao.countDateField(startAt, endAt, timestampGetter, trimmer, pctFilter);
        ctx.json((Object)new StdResp(true, null, results));
    }

    private Calendar getZeroCalender() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private void handleHistoryNumberAccess(Context ctx) throws Exception {
        String type = ctx.queryParam("type");
        String field = ctx.queryParam("field");
        double filter = Double.parseDouble(Objects.requireNonNullElse(ctx.queryParam("filter"), "0.0"));
        String downloader = ctx.queryParam("downloader");
        Integer substringLength = null;
        if ("peerId".equalsIgnoreCase(field)) {
            substringLength = 8;
        }
        String string = type;
        int n = 0;
        List<HistoryDao.UniversalFieldNumResult> results = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"count", "sum"}, (String)string, n)) {
            case 0 -> this.historyDao.countField(field, filter, downloader, substringLength);
            case 1 -> this.historyDao.sumField(field, filter, downloader, substringLength);
            default -> throw new IllegalArgumentException("type invalid");
        };
        ctx.json((Object)new StdResp(true, null, results));
    }

    private void handlePeerBans(Context ctx) throws Exception {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        ConcurrentHashMap<Long, AtomicInteger> bannedPeerTrends = new ConcurrentHashMap<Long, AtomicInteger>();
        try (CloseableIterator it = this.historyDao.queryBuilder().selectColumns(new String[]{"id", "banAt"}).where().ge("banAt", (Object)timeQueryModel.startAt()).and().le("banAt", (Object)timeQueryModel.endAt()).iterator();){
            while (it.hasNext()) {
                long startOfDay = MiscUtil.getStartOfToday(((HistoryEntity)it.next()).getBanAt().getTime());
                bannedPeerTrends.computeIfAbsent(startOfDay, k -> new AtomicInteger()).addAndGet(1);
            }
        }
        ctx.json((Object)new StdResp(true, null, bannedPeerTrends.entrySet().stream().map(e -> new HistoryDao.UniversalFieldDateResult((Long)e.getKey(), ((AtomicInteger)e.getValue()).intValue(), 0.0)).toList()));
    }

    private void handleBasicCounter(Context ctx) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("checkCounter", this.metrics.getCheckCounter());
        map.put("peerBanCounter", this.metrics.getPeerBanCounter());
        map.put("peerUnbanCounter", this.metrics.getPeerUnbanCounter());
        map.put("banlistCounter", this.downloaderServer.getBanList().size());
        map.put("bannedIpCounter", this.downloaderServer.getBanList().copyKeySet().stream().distinct().count());
        map.put("wastedTraffic", this.metrics.getWastedTraffic());
        try {
            long trackedPeers = this.trackedSwarmDao.countOf();
            map.put("trackedSwarmCount", trackedPeers);
            if (trackedPeers > 0L) {
                map.put("peersBlockRate", (double)this.metrics.getPeerBanCounter() / (double)trackedPeers);
            } else {
                map.put("peersBlockRate", 0.0);
            }
        }
        catch (SQLException e) {
            map.put("peersBlockRate", 0.0);
            log.error("Unable to query tracked swarm count", (Throwable)e);
        }
        map.put("weeklySessions", this.peerConnectionMetricDao.getGlobalTotalConnectionsCount(new Timestamp(MiscUtil.getStartOfToday(System.currentTimeMillis() - 604800000L)), new Timestamp(MiscUtil.getStartOfToday(System.currentTimeMillis()))));
        ctx.json((Object)new StdResp(true, null, map));
    }

    @Override
    public void onDisable() {
        this.metrics = null;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Metrics";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-metrics";
    }
}

