/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.platform.impl.win32.workingset.jna;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class MemoryMonitor {
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();

    public MemoryUsage getHeapMemoryUsage() {
        return this.memoryBean.getHeapMemoryUsage();
    }

    public MemoryUsage getNonHeapMemoryUsage() {
        return this.memoryBean.getNonHeapMemoryUsage();
    }

    public String getMemorySummary() {
        MemoryUsage heap = this.getHeapMemoryUsage();
        MemoryUsage nonHeap = this.getNonHeapMemoryUsage();
        String sb = "\u5185\u5b58\u4f7f\u7528\u60c5\u51b5:\n  \u5806\u5185\u5b58: " + this.formatMemoryUsage(heap) + "\n  \u975e\u5806\u5185\u5b58: " + this.formatMemoryUsage(nonHeap);
        return sb;
    }

    private String formatMemoryUsage(MemoryUsage usage) {
        return String.format("\u5df2\u7528: %s, \u5df2\u63d0\u4ea4: %s, \u6700\u5927: %s", MemoryMonitor.formatBytes(usage.getUsed()), MemoryMonitor.formatBytes(usage.getCommitted()), usage.getMax() == -1L ? "\u65e0\u9650\u5236" : MemoryMonitor.formatBytes(usage.getMax()));
    }

    public static String formatBytes(long bytes) {
        double size;
        if (bytes < 1024L) {
            return bytes + " B";
        }
        String[] units = new String[]{"KB", "MB", "GB", "TB"};
        int unitIndex = 0;
        for (size = (double)bytes; size >= 1024.0 && unitIndex < units.length - 1; size /= 1024.0, ++unitIndex) {
        }
        return String.format("%.2f %s", size, units[unitIndex]);
    }

    public long getEstimatedWorkingSetSize() {
        MemoryUsage heap = this.getHeapMemoryUsage();
        MemoryUsage nonHeap = this.getNonHeapMemoryUsage();
        return heap.getUsed() + nonHeap.getUsed() + 0x2000000L;
    }

    public boolean isMemoryUsageHigh(double thresholdRatio) {
        MemoryUsage heap = this.getHeapMemoryUsage();
        if (heap.getMax() == -1L) {
            return (double)heap.getUsed() / (double)heap.getCommitted() > thresholdRatio;
        }
        return (double)heap.getUsed() / (double)heap.getMax() > thresholdRatio;
    }

    public boolean shouldTrimMemory() {
        return this.isMemoryUsageHigh(0.7);
    }
}

