/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BeanCreationTimeMonitor
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BeanCreationTimeMonitor.class);
    private final Map<String, Long> startTimes = new HashMap<String, Long>();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.startTimes.put(beanName, System.currentTimeMillis());
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Long startTime = this.startTimes.remove(beanName);
        if (startTime != null) {
            long initializationTime = System.currentTimeMillis() - startTime;
            log.debug("Bean '{}' initialized in {}ms", (Object)beanName, (Object)initializationTime);
        }
        return bean;
    }
}

