/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.asynctask;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.asynctask.AsyncTaskLoggerListener;
import com.ghostchu.peerbanhelper.util.asynctask.AsyncTaskManager;
import com.ghostchu.peerbanhelper.util.asynctask.AsyncTaskUtil;
import com.ghostchu.peerbanhelper.util.asynctask.wrap.AsyncTaskWrappedInputStream;
import com.ghostchu.peerbanhelper.util.asynctask.wrap.AsyncTaskWrappedIterable;
import com.ghostchu.peerbanhelper.util.asynctask.wrap.AsyncTaskWrappedIterator;
import com.ghostchu.peerbanhelper.util.asynctask.wrap.AsyncTaskWrappedOutputStream;
import com.ghostchu.peerbanhelper.util.asynctask.wrap.AsyncTaskWrappedReader;
import com.ghostchu.peerbanhelper.util.asynctask.wrap.AsyncTaskWrappedSpliterator;
import com.ghostchu.peerbanhelper.util.asynctask.wrap.AsyncTaskWrappedWriter;
import com.google.common.collect.EvictingQueue;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class AsyncTask
implements AutoCloseable {
    private final String taskId = UUID.randomUUID().toString();
    private TranslationComponent title = new TranslationComponent(Lang.BGTASK_TITLE_EMPTY);
    private TranslationComponent description;
    private final EvictingQueue<String> ringDeque = EvictingQueue.create((int)ExternalSwitch.parseInt("pbh.logger.ringDeque.size", 100));
    private final AtomicLong current = new AtomicLong(0L);
    private final AtomicLong max = new AtomicLong(-1L);
    private final List<WeakReference<AsyncTaskLoggerListener>> loggerListeners = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public AsyncTask() {
        AsyncTaskManager.registerTask(this);
    }

    public void log(String text) {
        this.ringDeque.add((Object)text);
        Iterator<WeakReference<AsyncTaskLoggerListener>> it = this.loggerListeners.iterator();
        while (it.hasNext()) {
            WeakReference<AsyncTaskLoggerListener> ref = it.next();
            AsyncTaskLoggerListener listener = (AsyncTaskLoggerListener)ref.get();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.onLog(this, text);
        }
    }

    public List<String> getLogs() {
        return List.copyOf(this.ringDeque);
    }

    public TranslationComponent getTitle() {
        return this.title;
    }

    public AsyncTask setTitle(TranslationComponent title) {
        this.title = title;
        return this;
    }

    public TranslationComponent getDescription() {
        return this.description;
    }

    public AsyncTask setDescription(TranslationComponent description) {
        this.description = description;
        return this;
    }

    public long getCurrent() {
        return this.current.longValue();
    }

    public long getMax() {
        return this.max.longValue();
    }

    public AsyncTask setMax(long max) {
        this.max.set(max);
        return this;
    }

    public AsyncTask setCurrent(long current) {
        this.current.set(current);
        return this;
    }

    public AsyncTask increment(long increment) {
        this.current.addAndGet(increment);
        return this;
    }

    public AsyncTask increment() {
        this.current.incrementAndGet();
        return this;
    }

    public AsyncTask decrement(long decrement) {
        this.current.getAndUpdate(l -> l - decrement);
        return this;
    }

    public AsyncTask decrement() {
        this.current.getAndUpdate(l -> l - 1L);
        return this;
    }

    public double getProgress() {
        long max = this.max.get();
        if (max <= 0L) {
            return -1.0;
        }
        return (double)this.current.get() / (double)max;
    }

    public boolean isIndeterminate() {
        return this.max.get() < 0L;
    }

    public static AsyncTask create() {
        return AsyncTask.create(null);
    }

    public static AsyncTask create(TranslationComponent title) {
        AsyncTask task = new AsyncTask();
        if (title != null) {
            task.setTitle(title);
        }
        return task;
    }

    public AsyncTask addLoggerListener(AsyncTaskLoggerListener listener) {
        this.loggerListeners.add(new WeakReference<AsyncTaskLoggerListener>(listener));
        return this;
    }

    @NotNull
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void close() {
        Iterator<WeakReference<AsyncTaskLoggerListener>> it = this.loggerListeners.iterator();
        while (it.hasNext()) {
            WeakReference<AsyncTaskLoggerListener> ref = it.next();
            AsyncTaskLoggerListener listener = (AsyncTaskLoggerListener)ref.get();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.onTaskClose(this);
        }
        this.loggerListeners.clear();
        AsyncTaskManager.unregisterTask(this);
        this.closed.set(true);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, TranslationComponent title) {
        return AsyncTask.wrap(it, AsyncTask.create(title).setMax(-1L));
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, AsyncTask asyncTask) {
        return new AsyncTaskWrappedIterator<T>(it, asyncTask);
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, TranslationComponent title) {
        return AsyncTask.wrap(ts, AsyncTask.create(title));
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, AsyncTask asyncTask) {
        asyncTask.setMax(AsyncTaskUtil.getSpliteratorSize(ts.spliterator()));
        return new AsyncTaskWrappedIterable<T>(ts, asyncTask);
    }

    public static InputStream wrap(InputStream is, TranslationComponent title) {
        return AsyncTask.wrap(is, AsyncTask.create(title));
    }

    public static InputStream wrap(InputStream is, AsyncTask asyncTask) {
        asyncTask.setMax(AsyncTaskUtil.getInputStreamSize(is));
        return new AsyncTaskWrappedInputStream(is, asyncTask);
    }

    public static OutputStream wrap(OutputStream os, TranslationComponent title) {
        return AsyncTask.wrap(os, AsyncTask.create(title));
    }

    public static OutputStream wrap(OutputStream os, AsyncTask asyncTask) {
        return new AsyncTaskWrappedOutputStream(os, asyncTask);
    }

    public static Reader wrap(Reader reader, TranslationComponent title) {
        return AsyncTask.wrap(reader, AsyncTask.create(title));
    }

    public static Reader wrap(Reader reader, AsyncTask pbb) {
        return new AsyncTaskWrappedReader(reader, pbb);
    }

    public static Writer wrap(Writer writer, TranslationComponent title) {
        return AsyncTask.wrap(writer, AsyncTask.create(title));
    }

    public static Writer wrap(Writer writer, AsyncTask asyncTask) {
        return new AsyncTaskWrappedWriter(writer, asyncTask);
    }

    public static <T> Spliterator<T> wrap(Spliterator<T> sp, TranslationComponent title) {
        return AsyncTask.wrap(sp, AsyncTask.create(title));
    }

    public static <T> Spliterator<T> wrap(Spliterator<T> sp, AsyncTask asyncTask) {
        asyncTask.setMax(AsyncTaskUtil.getSpliteratorSize(sp));
        return new AsyncTaskWrappedSpliterator<T>(sp, asyncTask);
    }

    public static <T, S extends BaseStream<T, S>> Stream<T> wrap(S stream, TranslationComponent title) {
        return AsyncTask.wrap(stream, AsyncTask.create(title));
    }

    public static <T, S extends BaseStream<T, S>> Stream<T> wrap(S stream, AsyncTask asyncTask) {
        Spliterator<T> sp = AsyncTask.wrap(stream.spliterator(), asyncTask);
        return StreamSupport.stream(sp, stream.isParallel());
    }

    public static <T> Stream<T> wrap(T[] array, TranslationComponent title) {
        return AsyncTask.wrap(array, AsyncTask.create(title));
    }

    public static <T> Stream<T> wrap(T[] array, AsyncTask asyncTask) {
        asyncTask.setMax(array.length);
        return AsyncTask.wrap(Arrays.stream(array), asyncTask);
    }

    public EvictingQueue<String> getRingDeque() {
        return this.ringDeque;
    }
}

