/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.asynctask.wrap;

import com.ghostchu.peerbanhelper.util.asynctask.AsyncTask;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class AsyncTaskWrappedInputStream
extends FilterInputStream {
    private final AsyncTask asyncTask;
    private long mark = 0L;

    public AsyncTaskWrappedInputStream(InputStream in, AsyncTask asyncTask) {
        super(in);
        this.asyncTask = asyncTask;
    }

    public AsyncTask getBgTask() {
        return this.asyncTask;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r != -1) {
            this.asyncTask.increment();
        }
        return r;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        int r = this.in.read(b);
        if (r != -1) {
            this.asyncTask.increment(r);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r != -1) {
            this.asyncTask.increment(r);
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.in.skip(n);
        this.asyncTask.increment(r);
        return r;
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.asyncTask.getCurrent();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.asyncTask.setCurrent(this.mark);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.asyncTask.close();
    }
}

