/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.json;

import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class TranslationComponentTypeAdapter
extends TypeAdapter<TranslationComponent> {
    public static final TranslationComponentTypeAdapter INSTANCE = new TranslationComponentTypeAdapter();

    public void write(JsonWriter out, TranslationComponent value) throws IOException {
        out.beginObject();
        out.name("key").value(value.getKey());
        out.name("params");
        out.beginArray();
        for (Object param : value.getParams()) {
            if (param instanceof TranslationComponent) {
                INSTANCE.write(out, (TranslationComponent)param);
                continue;
            }
            out.value(param.toString());
        }
        out.endArray();
        out.endObject();
    }

    public TranslationComponent read(JsonReader in) throws IOException {
        String key = null;
        ArrayList<Object> params = new ArrayList<Object>();
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if ("key".equals(name)) {
                key = in.nextString();
                continue;
            }
            if ("params".equals(name)) {
                in.beginArray();
                while (in.hasNext()) {
                    if (in.peek() == JsonToken.STRING) {
                        params.add(in.nextString());
                        continue;
                    }
                    if (in.peek() == JsonToken.BEGIN_OBJECT) {
                        params.add(INSTANCE.read(in));
                        continue;
                    }
                    in.skipValue();
                }
                in.endArray();
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return new TranslationComponent(key, params.toArray(new Object[0]));
    }
}

