from eth_typing import (
    Hash32,
)

UINT256_MIN = 0
UINT256_MAX = 2**256 - 1
UINT64_MAX = 2**64 - 1
UINT8_MAX = 2**8 - 1
UINT2048_MAX = 2**2048 - 1


ZERO_ADDRESS_HEX = "0x0000000000000000000000000000000000000000"
BURN_ADDRESS = "0xdead000000000000000000000000000000000000"

BLANK_ROOT_HASH = b"V\xe8\x1f\x17\x1b\xccU\xa6\xff\x83E\xe6\x92\xc0\xf8n\x5bH\xe0\x1b\x99l\xad\xc0\x01b/\xb5\xe3c\xb4!"  # noqa: E501
EMPTY_UNCLE_HASH = b"\x1d\xccM\xe8\xde\xc7]z\xab\x85\xb5g\xb6\xcc\xd4\x1a\xd3\x12E\x1b\x94\x8at\x13\xf0\xa1B\xfd@\xd4\x93G"  # noqa: E501
EMPTY_SHA256 = b"\xe3\xb0\xc4B\x98\xfc\x1c\x14\x9a\xfb\xf4\xc8\x99o\xb9$'\xaeA\xe4d\x9b\x93L\xa4\x95\x99\x1bxR\xb8U"  # noqa: E501
POST_MERGE_DIFFICULTY = 0
POST_MERGE_MIX_HASH = Hash32(32 * b"\x00")
POST_MERGE_NONCE = b"\x00\x00\x00\x00\x00\x00\x00\x00"


FORK_HOMESTEAD = "FORK_HOMESTEAD"
FORK_DAO = "FORK_DAO"
FORK_SPURIOUS_DRAGON = "FORK_SPURIOUS_DRAGON"
FORK_TANGERINE_WHISTLE = "FORK_TANGERINE_WHISTLE"
FORK_BYZANTIUM = "FORK_BYZANTIUM"
FORK_PETERSBURG = "FORK_PETERSBURG"
FORK_ISTANBUL = "FORK_ISTANBUL"
FORK_MUIR_GLACIER = "FORK_MUIR_GLACIER"
FORK_BERLIN = "FORK_BERLIN"
FORK_LONDON = "FORK_LONDON"
FORK_ARROW_GLACIER = "FORK_ARROW_GLACIER"
FORK_GRAY_GLACIER = "FORK_GRAY_GLACIER"
FORK_PARIS = "FORK_PARIS"

KNOWN_FORKS = {
    FORK_HOMESTEAD,
    FORK_DAO,
    FORK_SPURIOUS_DRAGON,
    FORK_TANGERINE_WHISTLE,
    FORK_BYZANTIUM,
    FORK_PETERSBURG,
    FORK_ISTANBUL,
    FORK_MUIR_GLACIER,
    FORK_BERLIN,
    FORK_LONDON,
    FORK_ARROW_GLACIER,
    FORK_GRAY_GLACIER,
    FORK_PARIS,
}


LATEST = "latest"
EARLIEST = "earliest"
PENDING = "pending"
SAFE = "safe"
FINALIZED = "finalized"
BLOCK_NUMBER_META_VALUES = {
    LATEST,
    EARLIEST,
    PENDING,
    SAFE,
    FINALIZED,
}

#
# SECPK1N
#
SECPK1_P = 2**256 - 2**32 - 977
SECPK1_N = (
    115792089237316195423570985008687907852837564279074904382605163141518161494337
)
SECPK1_A = 0
SECPK1_B = 7
SECPK1_Gx = (
    55066263022277343669578718895168534326250603453777594175500187360389116729240
)
SECPK1_Gy = (
    32670510020758816978083085130507043184471273380659243275938904335757337482424
)
SECPK1_G = (SECPK1_Gx, SECPK1_Gy)


# -- KNOWN TRANSACTION TYPES -- #
LEGACY_TX_TYPE = 0
ACCESS_LIST_TX_TYPE = 1
DYNAMIC_FEE_TX_TYPE = 2
BLOB_TX_TYPE = 3
SET_CODE_TX_TYPE = 4


# -- EIP CONSTANTS -- #

# EIP-1559
DYNAMIC_FEE_TRANSACTION_PARAMS = ("max_fee_per_gas", "max_priority_fee_per_gas")

# EIP-4844
BLOB_TRANSACTION_PARAMS = ("max_fee_per_blob_gas", "blob_versioned_hashes")
GAS_PER_BLOB = 2**17
