(function() {
    var type_impls = Object.fromEntries([["std",[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1887-1890\">Source</a></span><a href=\"#impl-Clone-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,\n    E: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1893\">Source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h4></section></summary><div class='docblock'>Returns a duplicate of the value. <a href=\"std/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1901\">Source</a><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: &amp;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"std/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#552\">Source</a></span><a href=\"#impl-Debug-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a>,\n    E: <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#552\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"std/fmt/struct.Formatter.html\" title=\"struct std::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"std/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"std/fmt/struct.Error.html\" title=\"struct std::fmt::Error\">Error</a>&gt;</h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"std/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromIterator%3CResult%3CA,+E%3E%3E-for-Result%3CV,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#2111\">Source</a></span><a href=\"#impl-FromIterator%3CResult%3CA,+E%3E%3E-for-Result%3CV,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;A, E, V&gt; <a class=\"trait\" href=\"std/iter/trait.FromIterator.html\" title=\"trait std::iter::FromIterator\">FromIterator</a>&lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;A, E&gt;&gt; for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;V, E&gt;<div class=\"where\">where\n    V: <a class=\"trait\" href=\"std/iter/trait.FromIterator.html\" title=\"trait std::iter::FromIterator\">FromIterator</a>&lt;A&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2155\">Source</a><a href=\"#method.from_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.FromIterator.html#tymethod.from_iter\" class=\"fn\">from_iter</a>&lt;I&gt;(iter: I) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;V, E&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a>&lt;Item = <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;A, E&gt;&gt;,</div></h4></section></summary><div class=\"docblock\"><p>Takes each element in the <code>Iterator</code>: if it is an <code>Err</code>, no further\nelements are taken, and the <code>Err</code> is returned. Should no <code>Err</code> occur, a\ncontainer with the values of each <code>Result</code> is returned.</p>\n<p>Here is an example which increments every integer in a vector,\nchecking for overflow:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">'static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32|\n    x.checked_add(<span class=\"number\">1</span>).ok_or(<span class=\"string\">\"Overflow!\"</span>)\n).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Ok</span>(<span class=\"macro\">vec!</span>[<span class=\"number\">2</span>, <span class=\"number\">3</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+v+=+vec!%5B1,+2%5D;%0A++++let+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C%0A++++++++x.checked_add(1).ok_or(%22Overflow!%22)%0A++++).collect();%0A++++assert_eq!(res,+Ok(vec!%5B2,+3%5D));%0A%7D&amp;edition=2024\"></a></div>\n<p>Here is another example that tries to subtract one from another list\nof integers, this time checking for underflow:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">0</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">'static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32|\n    x.checked_sub(<span class=\"number\">1</span>).ok_or(<span class=\"string\">\"Underflow!\"</span>)\n).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Underflow!\"</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+v+=+vec!%5B1,+2,+0%5D;%0A++++let+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C%0A++++++++x.checked_sub(1).ok_or(%22Underflow!%22)%0A++++).collect();%0A++++assert_eq!(res,+Err(%22Underflow!%22));%0A%7D&amp;edition=2024\"></a></div>\n<p>Here is a variation on the previous example, showing that no\nfurther elements are taken from <code>iter</code> after the first <code>Err</code>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">3</span>, <span class=\"number\">2</span>, <span class=\"number\">1</span>, <span class=\"number\">10</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>shared = <span class=\"number\">0</span>;\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">'static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32| {\n    shared += x;\n    x.checked_sub(<span class=\"number\">2</span>).ok_or(<span class=\"string\">\"Underflow!\"</span>)\n}).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Underflow!\"</span>));\n<span class=\"macro\">assert_eq!</span>(shared, <span class=\"number\">6</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+v+=+vec!%5B3,+2,+1,+10%5D;%0A++++let+mut+shared+=+0;%0A++++let+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C+%7B%0A++++++++shared+%2B=+x;%0A++++++++x.checked_sub(2).ok_or(%22Underflow!%22)%0A++++%7D).collect();%0A++++assert_eq!(res,+Err(%22Underflow!%22));%0A++++assert_eq!(shared,+6);%0A%7D&amp;edition=2024\"></a></div>\n<p>Since the third element caused an underflow, no further elements were taken,\nso the final value of <code>shared</code> is 6 (= <code>3 + 2 + 1</code>), not 16.</p>\n</div></details></div></details>","FromIterator<Result<A, E>>","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromResidual%3CResult%3CInfallible,+E%3E%3E-for-Result%3CT,+F%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2182-2183\">Source</a><a href=\"#impl-FromResidual%3CResult%3CInfallible,+E%3E%3E-for-Result%3CT,+F%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E, F&gt; <a class=\"trait\" href=\"std/ops/trait.FromResidual.html\" title=\"trait std::ops::FromResidual\">FromResidual</a>&lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"std/convert/enum.Infallible.html\" title=\"enum std::convert::Infallible\">Infallible</a>, E&gt;&gt; for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;E&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_residual\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2187\">Source</a><a href=\"#method.from_residual\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.FromResidual.html#tymethod.from_residual\" class=\"fn\">from_residual</a>(residual: <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"std/convert/enum.Infallible.html\" title=\"enum std::convert::Infallible\">Infallible</a>, E&gt;) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from a compatible <code>Residual</code> type. <a href=\"std/ops/trait.FromResidual.html#tymethod.from_residual\">Read more</a></div></details></div></details>","FromResidual<Result<Infallible, E>>","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromResidual%3CYeet%3CE%3E%3E-for-Result%3CT,+F%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2196\">Source</a><a href=\"#impl-FromResidual%3CYeet%3CE%3E%3E-for-Result%3CT,+F%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E, F&gt; <a class=\"trait\" href=\"std/ops/trait.FromResidual.html\" title=\"trait std::ops::FromResidual\">FromResidual</a>&lt;<a class=\"struct\" href=\"std/ops/struct.Yeet.html\" title=\"struct std::ops::Yeet\">Yeet</a>&lt;E&gt;&gt; for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;E&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_residual\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2198\">Source</a><a href=\"#method.from_residual\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.FromResidual.html#tymethod.from_residual\" class=\"fn\">from_residual</a>(_: <a class=\"struct\" href=\"std/ops/struct.Yeet.html\" title=\"struct std::ops::Yeet\">Yeet</a>&lt;E&gt;) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from a compatible <code>Residual</code> type. <a href=\"std/ops/trait.FromResidual.html#tymethod.from_residual\">Read more</a></div></details></div></details>","FromResidual<Yeet<E>>","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Hash-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#552\">Source</a></span><a href=\"#impl-Hash-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/hash/trait.Hash.html\" title=\"trait std::hash::Hash\">Hash</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/hash/trait.Hash.html\" title=\"trait std::hash::Hash\">Hash</a>,\n    E: <a class=\"trait\" href=\"std/hash/trait.Hash.html\" title=\"trait std::hash::Hash\">Hash</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#552\">Source</a><a href=\"#method.hash\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/hash/trait.Hash.html#tymethod.hash\" class=\"fn\">hash</a>&lt;__H&gt;(&amp;self, state: <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;mut __H</a>)<div class=\"where\">where\n    __H: <a class=\"trait\" href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\">Hasher</a>,</div></h4></section></summary><div class='docblock'>Feeds this value into the given <a href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\"><code>Hasher</code></a>. <a href=\"std/hash/trait.Hash.html#tymethod.hash\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash_slice\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.3.0\">1.3.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#235-237\">Source</a></span><a href=\"#method.hash_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/hash/trait.Hash.html#method.hash_slice\" class=\"fn\">hash_slice</a>&lt;H&gt;(data: &amp;[Self], state: <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;mut H</a>)<div class=\"where\">where\n    H: <a class=\"trait\" href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\">Hasher</a>,\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Feeds a slice of this type into the given <a href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\"><code>Hasher</code></a>. <a href=\"std/hash/trait.Hash.html#method.hash_slice\">Read more</a></div></details></div></details>","Hash","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-IntoIterator-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1919\">Source</a></span><a href=\"#impl-IntoIterator-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1939\">Source</a><a href=\"#method.into_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.IntoIterator.html#tymethod.into_iter\" class=\"fn\">into_iter</a>(self) -&gt; <a class=\"struct\" href=\"std/result/struct.IntoIter.html\" title=\"struct std::result::IntoIter\">IntoIter</a>&lt;T&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"IntoIter&lt;T&gt;\">ⓘ</a></h4></section></summary><div class=\"docblock\"><p>Returns a consuming iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">5</span>);\n<span class=\"kw\">let </span>v: Vec&lt;u32&gt; = x.into_iter().collect();\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"number\">5</span>]);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"nothing!\"</span>);\n<span class=\"kw\">let </span>v: Vec&lt;u32&gt; = x.into_iter().collect();\n<span class=\"macro\">assert_eq!</span>(v, []);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(5);%0A++++let+v:+Vec%3Cu32%3E+=+x.into_iter().collect();%0A++++assert_eq!(v,+%5B5%5D);%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0A++++let+v:+Vec%3Cu32%3E+=+x.into_iter().collect();%0A++++assert_eq!(v,+%5B%5D);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Item\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1920\">Source</a><a href=\"#associatedtype.Item\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/iter/trait.IntoIterator.html#associatedtype.Item\" class=\"associatedtype\">Item</a> = T</h4></section></summary><div class='docblock'>The type of the elements being iterated over.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.IntoIter\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1921\">Source</a><a href=\"#associatedtype.IntoIter\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/iter/trait.IntoIterator.html#associatedtype.IntoIter\" class=\"associatedtype\">IntoIter</a> = <a class=\"struct\" href=\"std/result/struct.IntoIter.html\" title=\"struct std::result::IntoIter\">IntoIter</a>&lt;T&gt;</h4></section></summary><div class='docblock'>Which kind of iterator are we turning this into?</div></details></div></details>","IntoIterator","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/118304\" title=\"Tracking issue for derive_const\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#553\">Source</a></span><a href=\"#impl-Ord-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/cmp/trait.Ord.html\" title=\"trait std::cmp::Ord\">Ord</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/cmp/trait.Ord.html\" title=\"trait std::cmp::Ord\">Ord</a>,\n    E: <a class=\"trait\" href=\"std/cmp/trait.Ord.html\" title=\"trait std::cmp::Ord\">Ord</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#553\">Source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"std/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1021-1023\">Source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"std/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1060-1062\">Source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"std/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1086-1088\">Source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"std/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/118304\" title=\"Tracking issue for derive_const\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#553\">Source</a></span><a href=\"#impl-PartialEq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>,\n    E: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#553\">Source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>self</code> and <code>other</code> values to be equal, and is used by <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#264\">Source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>!=</code>. The default implementation is almost always sufficient,\nand should not be overridden without very good reason.</div></details></div></details>","PartialEq","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/118304\" title=\"Tracking issue for derive_const\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#553\">Source</a></span><a href=\"#impl-PartialOrd-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>,\n    E: <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#553\">Source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1398\">Source</a></span><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1416\">Source</a></span><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the\n<code>&lt;=</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1434\">Source</a></span><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1452\">Source</a></span><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by\nthe <code>&gt;=</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/core/iter/traits/accum.rs.html#240-242\">Source</a></span><a href=\"#impl-Product%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, E&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;&gt; for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;U&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter/traits/accum.rs.html#261-263\">Source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;&gt;,</div></h4></section></summary><div class=\"docblock\"><p>Takes each element in the <a href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\"><code>Iterator</code></a>: if it is an <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>, no further\nelements are taken, and the <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> is returned. Should no <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>\noccur, the product of all elements is returned.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<p>This multiplies each number in a vector of strings,\nif a string could not be parsed the operation returns <code>Err</code>:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>nums = <span class=\"macro\">vec!</span>[<span class=\"string\">\"5\"</span>, <span class=\"string\">\"10\"</span>, <span class=\"string\">\"1\"</span>, <span class=\"string\">\"2\"</span>];\n<span class=\"kw\">let </span>total: <span class=\"prelude-ty\">Result</span>&lt;usize, <span class=\"kw\">_</span>&gt; = nums.iter().map(|w| w.parse::&lt;usize&gt;()).product();\n<span class=\"macro\">assert_eq!</span>(total, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">100</span>));\n<span class=\"kw\">let </span>nums = <span class=\"macro\">vec!</span>[<span class=\"string\">\"5\"</span>, <span class=\"string\">\"10\"</span>, <span class=\"string\">\"one\"</span>, <span class=\"string\">\"2\"</span>];\n<span class=\"kw\">let </span>total: <span class=\"prelude-ty\">Result</span>&lt;usize, <span class=\"kw\">_</span>&gt; = nums.iter().map(|w| w.parse::&lt;usize&gt;()).product();\n<span class=\"macro\">assert!</span>(total.is_err());</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+nums+=+vec!%5B%225%22,+%2210%22,+%221%22,+%222%22%5D;%0A++++let+total:+Result%3Cusize,+_%3E+=+nums.iter().map(%7Cw%7C+w.parse::%3Cusize%3E()).product();%0A++++assert_eq!(total,+Ok(100));%0A++++let+nums+=+vec!%5B%225%22,+%2210%22,+%22one%22,+%222%22%5D;%0A++++let+total:+Result%3Cusize,+_%3E+=+nums.iter().map(%7Cw%7C+w.parse::%3Cusize%3E()).product();%0A++++assert!(total.is_err());%0A%7D&amp;edition=2024\"></a></div></div></details></div></details>","Product<Result<U, E>>","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Residual%3CT%3E-for-Result%3CInfallible,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2205\">Source</a><a href=\"#impl-Residual%3CT%3E-for-Result%3CInfallible,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/ops/trait.Residual.html\" title=\"trait std::ops::Residual\">Residual</a>&lt;T&gt; for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"std/convert/enum.Infallible.html\" title=\"enum std::convert::Infallible\">Infallible</a>, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.TryType\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2206\">Source</a><a href=\"#associatedtype.TryType\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Residual.html#associatedtype.TryType\" class=\"associatedtype\">TryType</a> = <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2_residual</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91285\">#91285</a>)</span></div></span><div class='docblock'>The “return” type of this meta-function.</div></details></div></details>","Residual<T>","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Result%3C%26T,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1694\">Source</a><a href=\"#impl-Result%3C%26T,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;T</a>, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.copied\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.59.0, const since 1.83.0\">1.59.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1711-1713\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.copied\" class=\"fn\">copied</a>(self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/marker/trait.Copy.html\" title=\"trait std::marker::Copy\">Copy</a>,</div></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;&amp;T, E&gt;</code> to a <code>Result&lt;T, E&gt;</code> by copying the contents of the\n<code>Ok</code> part.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>val = <span class=\"number\">12</span>;\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>i32, i32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;</span>val);\n<span class=\"macro\">assert_eq!</span>(x, <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">12</span>));\n<span class=\"kw\">let </span>copied = x.copied();\n<span class=\"macro\">assert_eq!</span>(copied, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">12</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+val+=+12;%0A++++let+x:+Result%3C%26i32,+i32%3E+=+Ok(%26val);%0A++++assert_eq!(x,+Ok(%2612));%0A++++let+copied+=+x.copied();%0A++++assert_eq!(copied,+Ok(12));%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cloned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.59.0\">1.59.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1737-1739\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.cloned\" class=\"fn\">cloned</a>(self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</div></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;&amp;T, E&gt;</code> to a <code>Result&lt;T, E&gt;</code> by cloning the contents of the\n<code>Ok</code> part.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>val = <span class=\"number\">12</span>;\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>i32, i32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;</span>val);\n<span class=\"macro\">assert_eq!</span>(x, <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">12</span>));\n<span class=\"kw\">let </span>cloned = x.cloned();\n<span class=\"macro\">assert_eq!</span>(cloned, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">12</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+val+=+12;%0A++++let+x:+Result%3C%26i32,+i32%3E+=+Ok(%26val);%0A++++assert_eq!(x,+Ok(%2612));%0A++++let+cloned+=+x.cloned();%0A++++assert_eq!(cloned,+Ok(12));%0A%7D&amp;edition=2024\"></a></div></div></details></div></details>",0,"std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Result%3C%26mut+T,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1745\">Source</a><a href=\"#impl-Result%3C%26mut+T,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;mut T</a>, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.copied\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.59.0, const since 1.83.0\">1.59.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1762-1764\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.copied\" class=\"fn\">copied</a>(self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/marker/trait.Copy.html\" title=\"trait std::marker::Copy\">Copy</a>,</div></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;&amp;mut T, E&gt;</code> to a <code>Result&lt;T, E&gt;</code> by copying the contents of the\n<code>Ok</code> part.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>val = <span class=\"number\">12</span>;\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;mut </span>i32, i32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;mut </span>val);\n<span class=\"macro\">assert_eq!</span>(x, <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;mut </span><span class=\"number\">12</span>));\n<span class=\"kw\">let </span>copied = x.copied();\n<span class=\"macro\">assert_eq!</span>(copied, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">12</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+val+=+12;%0A++++let+x:+Result%3C%26mut+i32,+i32%3E+=+Ok(%26mut+val);%0A++++assert_eq!(x,+Ok(%26mut+12));%0A++++let+copied+=+x.copied();%0A++++assert_eq!(copied,+Ok(12));%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cloned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.59.0\">1.59.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1788-1790\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.cloned\" class=\"fn\">cloned</a>(self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</div></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;&amp;mut T, E&gt;</code> to a <code>Result&lt;T, E&gt;</code> by cloning the contents of the\n<code>Ok</code> part.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>val = <span class=\"number\">12</span>;\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;mut </span>i32, i32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;mut </span>val);\n<span class=\"macro\">assert_eq!</span>(x, <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;mut </span><span class=\"number\">12</span>));\n<span class=\"kw\">let </span>cloned = x.cloned();\n<span class=\"macro\">assert_eq!</span>(cloned, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">12</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+val+=+12;%0A++++let+x:+Result%3C%26mut+i32,+i32%3E+=+Ok(%26mut+val);%0A++++assert_eq!(x,+Ok(%26mut+12));%0A++++let+cloned+=+x.cloned();%0A++++assert_eq!(cloned,+Ok(12));%0A%7D&amp;edition=2024\"></a></div></div></details></div></details>",0,"std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Result%3COption%3CT%3E,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1796\">Source</a><a href=\"#impl-Result%3COption%3CT%3E,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;T&gt;, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.transpose\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.33.0, const since 1.83.0\">1.33.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1816\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.transpose\" class=\"fn\">transpose</a>(self) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;&gt;</h4></section></summary><div class=\"docblock\"><p>Transposes a <code>Result</code> of an <code>Option</code> into an <code>Option</code> of a <code>Result</code>.</p>\n<p><code>Ok(None)</code> will be mapped to <code>None</code>.\n<code>Ok(Some(_))</code> and <code>Err(_)</code> will be mapped to <code>Some(Ok(_))</code> and <code>Some(Err(_))</code>.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#[derive(Debug, Eq, PartialEq)]\n</span><span class=\"kw\">struct </span>SomeErr;\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"prelude-ty\">Option</span>&lt;i32&gt;, SomeErr&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"prelude-val\">Some</span>(<span class=\"number\">5</span>));\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Option</span>&lt;<span class=\"prelude-ty\">Result</span>&lt;i32, SomeErr&gt;&gt; = <span class=\"prelude-val\">Some</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">5</span>));\n<span class=\"macro\">assert_eq!</span>(x.transpose(), y);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++%23%5Bderive(Debug,+Eq,+PartialEq)%5D%0A++++struct+SomeErr;%0A++++%0A++++let+x:+Result%3COption%3Ci32%3E,+SomeErr%3E+=+Ok(Some(5));%0A++++let+y:+Option%3CResult%3Ci32,+SomeErr%3E%3E+=+Some(Ok(5));%0A++++assert_eq!(x.transpose(),+y);%0A%7D&amp;edition=2024\"></a></div></div></details></div></details>",0,"std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Result%3CResult%3CT,+E%3E,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1825\">Source</a><a href=\"#impl-Result%3CResult%3CT,+E%3E,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.flatten\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.89.0, const since 1.89.0\">1.89.0 (const: 1.89.0)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1852\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.flatten\" class=\"fn\">flatten</a>(self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;Result&lt;T, E&gt;, E&gt;</code> to <code>Result&lt;T, E&gt;</code></p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span><span class=\"lifetime\">'static </span>str, u32&gt;, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"hello\"</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"hello\"</span>), x.flatten());\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span><span class=\"lifetime\">'static </span>str, u32&gt;, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">6</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">6</span>), x.flatten());\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span><span class=\"lifetime\">'static </span>str, u32&gt;, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">6</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">6</span>), x.flatten());</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3CResult%3C%26'static+str,+u32%3E,+u32%3E+=+Ok(Ok(%22hello%22));%0A++++assert_eq!(Ok(%22hello%22),+x.flatten());%0A++++%0A++++let+x:+Result%3CResult%3C%26'static+str,+u32%3E,+u32%3E+=+Ok(Err(6));%0A++++assert_eq!(Err(6),+x.flatten());%0A++++%0A++++let+x:+Result%3CResult%3C%26'static+str,+u32%3E,+u32%3E+=+Err(6);%0A++++assert_eq!(Err(6),+x.flatten());%0A%7D&amp;edition=2024\"></a></div>\n<p>Flattening only removes one level of nesting at a time:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"prelude-ty\">Result</span>&lt;<span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span><span class=\"lifetime\">'static </span>str, u32&gt;, u32&gt;, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"hello\"</span>)));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"hello\"</span>)), x.flatten());\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"hello\"</span>), x.flatten().flatten());</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3CResult%3CResult%3C%26'static+str,+u32%3E,+u32%3E,+u32%3E+=+Ok(Ok(Ok(%22hello%22)));%0A++++assert_eq!(Ok(Ok(%22hello%22)),+x.flatten());%0A++++assert_eq!(Ok(%22hello%22),+x.flatten().flatten());%0A%7D&amp;edition=2024\"></a></div></div></details></div></details>",0,"std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#573\">Source</a><a href=\"#impl-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_ok\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const since 1.48.0\">1.0.0 (const: 1.48.0)</span> · <a class=\"src\" href=\"src/core/result.rs.html#593\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.is_ok\" class=\"fn\">is_ok</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(-<span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok(), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Some error message\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok(), <span class=\"bool-val\">false</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Ci32,+%26str%3E+=+Ok(-3);%0A++++assert_eq!(x.is_ok(),+true);%0A++++%0A++++let+x:+Result%3Ci32,+%26str%3E+=+Err(%22Some+error+message%22);%0A++++assert_eq!(x.is_ok(),+false);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_ok_and\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0, const unstable\">1.70.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#619-623\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.is_ok_and\" class=\"fn\">is_ok_and</a>&lt;F&gt;(self, f: F) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a><div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(T) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a>,</div></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> and the value inside of it matches a predicate.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"hey\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"ownership\"</span>.to_string());\n<span class=\"macro\">assert_eq!</span>(x.as_ref().is_ok_and(|x| x.len() &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">true</span>);\n<span class=\"macro\">println!</span>(<span class=\"string\">\"still alive {:?}\"</span>, x);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++assert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+true);%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(0);%0A++++assert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+false);%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22hey%22);%0A++++assert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+false);%0A++++%0A++++let+x:+Result%3CString,+%26str%3E+=+Ok(%22ownership%22.to_string());%0A++++assert_eq!(x.as_ref().is_ok_and(%7Cx%7C+x.len()+%3E+1),+true);%0A++++println!(%22still+alive+%7B:?%7D%22,+x);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const since 1.48.0\">1.0.0 (const: 1.48.0)</span> · <a class=\"src\" href=\"src/core/result.rs.html#646\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.is_err\" class=\"fn\">is_err</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"examples-2\"><a class=\"doc-anchor\" href=\"#examples-2\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(-<span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err(), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Some error message\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err(), <span class=\"bool-val\">true</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Ci32,+%26str%3E+=+Ok(-3);%0A++++assert_eq!(x.is_err(),+false);%0A++++%0A++++let+x:+Result%3Ci32,+%26str%3E+=+Err(%22Some+error+message%22);%0A++++assert_eq!(x.is_err(),+true);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_err_and\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0, const unstable\">1.70.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#674-678\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.is_err_and\" class=\"fn\">is_err_and</a>&lt;F&gt;(self, f: F) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a><div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(E) -&gt; <a class=\"primitive\" href=\"std/primitive.bool.html\">bool</a>,</div></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> and the value inside of it matches a predicate.</p>\n<h5 id=\"examples-3\"><a class=\"doc-anchor\" href=\"#examples-3\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::io::{Error, ErrorKind};\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Err</span>(Error::new(ErrorKind::NotFound, <span class=\"string\">\"!\"</span>));\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Err</span>(Error::new(ErrorKind::PermissionDenied, <span class=\"string\">\"!\"</span>));\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">123</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, String&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"ownership\"</span>.to_string());\n<span class=\"macro\">assert_eq!</span>(x.as_ref().is_err_and(|x| x.len() &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">true</span>);\n<span class=\"macro\">println!</span>(<span class=\"string\">\"still alive {:?}\"</span>, x);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++use+std::io::%7BError,+ErrorKind%7D;%0A++++%0A++++let+x:+Result%3Cu32,+Error%3E+=+Err(Error::new(ErrorKind::NotFound,+%22!%22));%0A++++assert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+true);%0A++++%0A++++let+x:+Result%3Cu32,+Error%3E+=+Err(Error::new(ErrorKind::PermissionDenied,+%22!%22));%0A++++assert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+false);%0A++++%0A++++let+x:+Result%3Cu32,+Error%3E+=+Ok(123);%0A++++assert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+false);%0A++++%0A++++let+x:+Result%3Cu32,+String%3E+=+Err(%22ownership%22.to_string());%0A++++assert_eq!(x.as_ref().is_err_and(%7Cx%7C+x.len()+%3E+1),+true);%0A++++println!(%22still+alive+%7B:?%7D%22,+x);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ok\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#708-711\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.ok\" class=\"fn\">ok</a>(self) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> to <a href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\"><code>Option&lt;T&gt;</code></a>.</p>\n<p>Converts <code>self</code> into an <a href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\"><code>Option&lt;T&gt;</code></a>, consuming <code>self</code>,\nand discarding the error, if any.</p>\n<h5 id=\"examples-4\"><a class=\"doc-anchor\" href=\"#examples-4\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.ok(), <span class=\"prelude-val\">Some</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Nothing here\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.ok(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++assert_eq!(x.ok(),+Some(2));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22Nothing+here%22);%0A++++assert_eq!(x.ok(),+None);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#736-739\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.err\" class=\"fn\">err</a>(self) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;E&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> to <a href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\"><code>Option&lt;E&gt;</code></a>.</p>\n<p>Converts <code>self</code> into an <a href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\"><code>Option&lt;E&gt;</code></a>, consuming <code>self</code>,\nand discarding the success value, if any.</p>\n<h5 id=\"examples-5\"><a class=\"doc-anchor\" href=\"#examples-5\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.err(), <span class=\"prelude-val\">None</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Nothing here\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.err(), <span class=\"prelude-val\">Some</span>(<span class=\"string\">\"Nothing here\"</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++assert_eq!(x.err(),+None);%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22Nothing+here%22);%0A++++assert_eq!(x.err(),+Some(%22Nothing+here%22));%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const since 1.48.0\">1.0.0 (const: 1.48.0)</span> · <a class=\"src\" href=\"src/core/result.rs.html#768\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.as_ref\" class=\"fn\">as_ref</a>(&amp;self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;T</a>, <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;E</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>&amp;Result&lt;T, E&gt;</code> to <code>Result&lt;&amp;T, &amp;E&gt;</code>.</p>\n<p>Produces a new <code>Result</code>, containing a reference\ninto the original, leaving the original in place.</p>\n<h5 id=\"examples-6\"><a class=\"doc-anchor\" href=\"#examples-6\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_ref(), <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Error\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_ref(), <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;</span><span class=\"string\">\"Error\"</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++assert_eq!(x.as_ref(),+Ok(%262));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22Error%22);%0A++++assert_eq!(x.as_ref(),+Err(%26%22Error%22));%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const since 1.83.0\">1.0.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/result.rs.html#798\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.as_mut\" class=\"fn\">as_mut</a>(&amp;mut self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;mut T</a>, <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;mut E</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>&amp;mut Result&lt;T, E&gt;</code> to <code>Result&lt;&amp;mut T, &amp;mut E&gt;</code>.</p>\n<h5 id=\"examples-7\"><a class=\"doc-anchor\" href=\"#examples-7\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>mutate(r: <span class=\"kw-2\">&amp;mut </span><span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt;) {\n    <span class=\"kw\">match </span>r.as_mut() {\n        <span class=\"prelude-val\">Ok</span>(v) =&gt; <span class=\"kw-2\">*</span>v = <span class=\"number\">42</span>,\n        <span class=\"prelude-val\">Err</span>(e) =&gt; <span class=\"kw-2\">*</span>e = <span class=\"number\">0</span>,\n    }\n}\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\nmutate(<span class=\"kw-2\">&amp;mut </span>x);\n<span class=\"macro\">assert_eq!</span>(x.unwrap(), <span class=\"number\">42</span>);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">13</span>);\nmutate(<span class=\"kw-2\">&amp;mut </span>x);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_err(), <span class=\"number\">0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++fn+mutate(r:+%26mut+Result%3Ci32,+i32%3E)+%7B%0A++++++++match+r.as_mut()+%7B%0A++++++++++++Ok(v)+=%3E+*v+=+42,%0A++++++++++++Err(e)+=%3E+*e+=+0,%0A++++++++%7D%0A++++%7D%0A++++%0A++++let+mut+x:+Result%3Ci32,+i32%3E+=+Ok(2);%0A++++mutate(%26mut+x);%0A++++assert_eq!(x.unwrap(),+42);%0A++++%0A++++let+mut+x:+Result%3Ci32,+i32%3E+=+Err(13);%0A++++mutate(%26mut+x);%0A++++assert_eq!(x.unwrap_err(),+0);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#831-833\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.map\" class=\"fn\">map</a>&lt;U, F&gt;(self, op: F) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(T) -&gt; U,</div></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>Result&lt;U, E&gt;</code> by applying a function to a\ncontained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value, leaving an <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value untouched.</p>\n<p>This function can be used to compose the results of two functions.</p>\n<h5 id=\"examples-8\"><a class=\"doc-anchor\" href=\"#examples-8\">§</a>Examples</h5>\n<p>Print the numbers on each line of a string multiplied by two.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>line = <span class=\"string\">\"1\\n2\\n3\\n4\\n\"</span>;\n\n<span class=\"kw\">for </span>num <span class=\"kw\">in </span>line.lines() {\n    <span class=\"kw\">match </span>num.parse::&lt;i32&gt;().map(|i| i * <span class=\"number\">2</span>) {\n        <span class=\"prelude-val\">Ok</span>(n) =&gt; <span class=\"macro\">println!</span>(<span class=\"string\">\"{n}\"</span>),\n        <span class=\"prelude-val\">Err</span>(..) =&gt; {}\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+line+=+%221%5Cn2%5Cn3%5Cn4%5Cn%22;%0A++++%0A++++for+num+in+line.lines()+%7B%0A++++++++match+num.parse::%3Ci32%3E().map(%7Ci%7C+i+*+2)+%7B%0A++++++++++++Ok(n)+=%3E+println!(%22%7Bn%7D%22),%0A++++++++++++Err(..)+=%3E+%7B%7D%0A++++++++%7D%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_or\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.41.0, const unstable\">1.41.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#863-868\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.map_or\" class=\"fn\">map_or</a>&lt;U, F&gt;(self, default: U, f: F) -&gt; U<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(T) -&gt; U,</div></h4></section></summary><div class=\"docblock\"><p>Returns the provided default (if <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>), or\napplies a function to the contained value (if <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>).</p>\n<p>Arguments passed to <code>map_or</code> are eagerly evaluated; if you are passing\nthe result of a function call, it is recommended to use <a href=\"std/result/enum.Result.html#method.map_or_else\" title=\"method std::result::Result::map_or_else\"><code>map_or_else</code></a>,\nwhich is lazily evaluated.</p>\n<h5 id=\"examples-9\"><a class=\"doc-anchor\" href=\"#examples-9\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw\">_</span>, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"foo\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or(<span class=\"number\">42</span>, |v| v.len()), <span class=\"number\">3</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw\">_</span>&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"bar\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or(<span class=\"number\">42</span>, |v| v.len()), <span class=\"number\">42</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3C_,+%26str%3E+=+Ok(%22foo%22);%0A++++assert_eq!(x.map_or(42,+%7Cv%7C+v.len()),+3);%0A++++%0A++++let+x:+Result%3C%26str,+_%3E+=+Err(%22bar%22);%0A++++assert_eq!(x.map_or(42,+%7Cv%7C+v.len()),+42);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_or_else\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.41.0, const unstable\">1.41.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#897-900\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.map_or_else\" class=\"fn\">map_or_else</a>&lt;U, D, F&gt;(self, default: D, f: F) -&gt; U<div class=\"where\">where\n    D: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(E) -&gt; U,\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(T) -&gt; U,</div></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>U</code> by applying fallback function <code>default</code> to\na contained <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value, or function <code>f</code> to a contained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value.</p>\n<p>This function can be used to unpack a successful result\nwhile handling an error.</p>\n<h5 id=\"examples-10\"><a class=\"doc-anchor\" href=\"#examples-10\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>k = <span class=\"number\">21</span>;\n\n<span class=\"kw\">let </span>x : <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw\">_</span>, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"foo\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or_else(|e| k * <span class=\"number\">2</span>, |v| v.len()), <span class=\"number\">3</span>);\n\n<span class=\"kw\">let </span>x : <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw\">_</span>&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"bar\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or_else(|e| k * <span class=\"number\">2</span>, |v| v.len()), <span class=\"number\">42</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+k+=+21;%0A++++%0A++++let+x+:+Result%3C_,+%26str%3E+=+Ok(%22foo%22);%0A++++assert_eq!(x.map_or_else(%7Ce%7C+k+*+2,+%7Cv%7C+v.len()),+3);%0A++++%0A++++let+x+:+Result%3C%26str,+_%3E+=+Err(%22bar%22);%0A++++assert_eq!(x.map_or_else(%7Ce%7C+k+*+2,+%7Cv%7C+v.len()),+42);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_or_default\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#928-933\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.map_or_default\" class=\"fn\">map_or_default</a>&lt;U, F&gt;(self, f: F) -&gt; U<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(T) -&gt; U,\n    U: <a class=\"trait\" href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\">Default</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>result_option_map_or_default</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/138099\">#138099</a>)</span></div></span></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to a <code>U</code> by applying function <code>f</code> to the contained\nvalue if the result is <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>, otherwise if <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>, returns the\n<a href=\"std/default/trait.Default.html#tymethod.default\" title=\"associated function std::default::Default::default\">default value</a> for the type <code>U</code>.</p>\n<h5 id=\"examples-11\"><a class=\"doc-anchor\" href=\"#examples-11\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(result_option_map_or_default)]\n\n</span><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw\">_</span>, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"foo\"</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw\">_</span>&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"bar\"</span>);\n\n<span class=\"macro\">assert_eq!</span>(x.map_or_default(|x| x.len()), <span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(y.map_or_default(|y| y.len()), <span class=\"number\">0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(result_option_map_or_default)%5D%0A%0A%0Afn+main()+%7B%0A++++let+x:+Result%3C_,+%26str%3E+=+Ok(%22foo%22);%0A++++let+y:+Result%3C%26str,+_%3E+=+Err(%22bar%22);%0A++++%0A++++assert_eq!(x.map_or_default(%7Cx%7C+x.len()),+3);%0A++++assert_eq!(y.map_or_default(%7Cy%7C+y.len()),+0);%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#962-964\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.map_err\" class=\"fn\">map_err</a>&lt;F, O&gt;(self, op: O) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;<div class=\"where\">where\n    O: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(E) -&gt; F,</div></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>Result&lt;T, F&gt;</code> by applying a function to a\ncontained <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value, leaving an <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value untouched.</p>\n<p>This function can be used to pass through a successful result while handling\nan error.</p>\n<h5 id=\"examples-12\"><a class=\"doc-anchor\" href=\"#examples-12\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>stringify(x: u32) -&gt; String { <span class=\"macro\">format!</span>(<span class=\"string\">\"error code: {x}\"</span>) }\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_err(stringify), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">13</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_err(stringify), <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"error code: 13\"</span>.to_string()));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++fn+stringify(x:+u32)+-%3E+String+%7B+format!(%22error+code:+%7Bx%7D%22)+%7D%0A++++%0A++++let+x:+Result%3Cu32,+u32%3E+=+Ok(2);%0A++++assert_eq!(x.map_err(stringify),+Ok(2));%0A++++%0A++++let+x:+Result%3Cu32,+u32%3E+=+Err(13);%0A++++assert_eq!(x.map_err(stringify),+Err(%22error+code:+13%22.to_string()));%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.inspect\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.76.0, const unstable\">1.76.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#988-990\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.inspect\" class=\"fn\">inspect</a>&lt;F&gt;(self, f: F) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(<a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;T</a>),</div></h4></section></summary><div class=\"docblock\"><p>Calls a function with a reference to the contained value if <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>.</p>\n<p>Returns the original result.</p>\n<h5 id=\"examples-13\"><a class=\"doc-anchor\" href=\"#examples-13\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: u8 = <span class=\"string\">\"4\"\n    </span>.parse::&lt;u8&gt;()\n    .inspect(|x| <span class=\"macro\">println!</span>(<span class=\"string\">\"original: {x}\"</span>))\n    .map(|x| x.pow(<span class=\"number\">3</span>))\n    .expect(<span class=\"string\">\"failed to parse number\"</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+u8+=+%224%22%0A++++++++.parse::%3Cu8%3E()%0A++++++++.inspect(%7Cx%7C+println!(%22original:+%7Bx%7D%22))%0A++++++++.map(%7Cx%7C+x.pow(3))%0A++++++++.expect(%22failed+to+parse+number%22);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.inspect_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.76.0, const unstable\">1.76.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1016-1018\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.inspect_err\" class=\"fn\">inspect_err</a>&lt;F&gt;(self, f: F) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(<a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;E</a>),</div></h4></section></summary><div class=\"docblock\"><p>Calls a function with a reference to the contained value if <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>.</p>\n<p>Returns the original result.</p>\n<h5 id=\"examples-14\"><a class=\"doc-anchor\" href=\"#examples-14\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::{fs, io};\n\n<span class=\"kw\">fn </span>read() -&gt; io::Result&lt;String&gt; {\n    fs::read_to_string(<span class=\"string\">\"address.txt\"</span>)\n        .inspect_err(|e| <span class=\"macro\">eprintln!</span>(<span class=\"string\">\"failed to read file: {e}\"</span>))\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++use+std::%7Bfs,+io%7D;%0A++++%0A++++fn+read()+-%3E+io::Result%3CString%3E+%7B%0A++++++++fs::read_to_string(%22address.txt%22)%0A++++++++++++.inspect_err(%7Ce%7C+eprintln!(%22failed+to+read+file:+%7Be%7D%22))%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_deref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0, const unstable\">1.47.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/143773\" title=\"Tracking issue for const_convert\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1046-1048\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.as_deref\" class=\"fn\">as_deref</a>(&amp;self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;&amp;&lt;T as <a class=\"trait\" href=\"std/ops/trait.Deref.html\" title=\"trait std::ops::Deref\">Deref</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Deref.html#associatedtype.Target\" title=\"type std::ops::Deref::Target\">Target</a>, <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;E</a>&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/ops/trait.Deref.html\" title=\"trait std::ops::Deref\">Deref</a>,</div></h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> (or <code>&amp;Result&lt;T, E&gt;</code>) to <code>Result&lt;&amp;&lt;T as Deref&gt;::Target, &amp;E&gt;</code>.</p>\n<p>Coerces the <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> variant of the original <a href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\"><code>Result</code></a> via <a href=\"std/ops/trait.Deref.html\" title=\"trait std::ops::Deref\"><code>Deref</code></a>\nand returns the new <a href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\"><code>Result</code></a>.</p>\n<h5 id=\"examples-15\"><a class=\"doc-anchor\" href=\"#examples-15\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"hello\"</span>.to_string());\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"hello\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_deref(), y);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">42</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_deref(), y);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3CString,+u32%3E+=+Ok(%22hello%22.to_string());%0A++++let+y:+Result%3C%26str,+%26u32%3E+=+Ok(%22hello%22);%0A++++assert_eq!(x.as_deref(),+y);%0A++++%0A++++let+x:+Result%3CString,+u32%3E+=+Err(42);%0A++++let+y:+Result%3C%26str,+%26u32%3E+=+Err(%2642);%0A++++assert_eq!(x.as_deref(),+y);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_deref_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0, const unstable\">1.47.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/143773\" title=\"Tracking issue for const_convert\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1074-1076\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.as_deref_mut\" class=\"fn\">as_deref_mut</a>(&amp;mut self) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;&amp;mut &lt;T as <a class=\"trait\" href=\"std/ops/trait.Deref.html\" title=\"trait std::ops::Deref\">Deref</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Deref.html#associatedtype.Target\" title=\"type std::ops::Deref::Target\">Target</a>, <a class=\"primitive\" href=\"std/primitive.reference.html\">&amp;mut E</a>&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/ops/trait.DerefMut.html\" title=\"trait std::ops::DerefMut\">DerefMut</a>,</div></h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> (or <code>&amp;mut Result&lt;T, E&gt;</code>) to <code>Result&lt;&amp;mut &lt;T as DerefMut&gt;::Target, &amp;mut E&gt;</code>.</p>\n<p>Coerces the <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> variant of the original <a href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\"><code>Result</code></a> via <a href=\"std/ops/trait.DerefMut.html\" title=\"trait std::ops::DerefMut\"><code>DerefMut</code></a>\nand returns the new <a href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\"><code>Result</code></a>.</p>\n<h5 id=\"examples-16\"><a class=\"doc-anchor\" href=\"#examples-16\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = <span class=\"string\">\"HELLO\"</span>.to_string();\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"hello\"</span>.to_string());\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;mut </span>str, <span class=\"kw-2\">&amp;mut </span>u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;mut </span>s);\n<span class=\"macro\">assert_eq!</span>(x.as_deref_mut().map(|x| { x.make_ascii_uppercase(); x }), y);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>i = <span class=\"number\">42</span>;\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;mut </span>str, <span class=\"kw-2\">&amp;mut </span>u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;mut </span>i);\n<span class=\"macro\">assert_eq!</span>(x.as_deref_mut().map(|x| { x.make_ascii_uppercase(); x }), y);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+s+=+%22HELLO%22.to_string();%0A++++let+mut+x:+Result%3CString,+u32%3E+=+Ok(%22hello%22.to_string());%0A++++let+y:+Result%3C%26mut+str,+%26mut+u32%3E+=+Ok(%26mut+s);%0A++++assert_eq!(x.as_deref_mut().map(%7Cx%7C+%7B+x.make_ascii_uppercase();+x+%7D),+y);%0A++++%0A++++let+mut+i+=+42;%0A++++let+mut+x:+Result%3CString,+u32%3E+=+Err(42);%0A++++let+y:+Result%3C%26mut+str,+%26mut+u32%3E+=+Err(%26mut+i);%0A++++assert_eq!(x.as_deref_mut().map(%7Cx%7C+%7B+x.make_ascii_uppercase();+x+%7D),+y);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.iter\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1101\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.iter\" class=\"fn\">iter</a>(&amp;self) -&gt; <a class=\"struct\" href=\"std/result/struct.Iter.html\" title=\"struct std::result::Iter\">Iter</a>&lt;'_, T&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"Iter&lt;&#39;_, T&gt;\">ⓘ</a></h4></section></summary><div class=\"docblock\"><p>Returns an iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples-17\"><a class=\"doc-anchor\" href=\"#examples-17\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">7</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter().next(), <span class=\"prelude-val\">Some</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">7</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"nothing!\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter().next(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(7);%0A++++assert_eq!(x.iter().next(),+Some(%267));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0A++++assert_eq!(x.iter().next(),+None);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.iter_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1125\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.iter_mut\" class=\"fn\">iter_mut</a>(&amp;mut self) -&gt; <a class=\"struct\" href=\"std/result/struct.IterMut.html\" title=\"struct std::result::IterMut\">IterMut</a>&lt;'_, T&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"IterMut&lt;&#39;_, T&gt;\">ⓘ</a></h4></section></summary><div class=\"docblock\"><p>Returns a mutable iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples-18\"><a class=\"doc-anchor\" href=\"#examples-18\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">7</span>);\n<span class=\"kw\">match </span>x.iter_mut().next() {\n    <span class=\"prelude-val\">Some</span>(v) =&gt; <span class=\"kw-2\">*</span>v = <span class=\"number\">40</span>,\n    <span class=\"prelude-val\">None </span>=&gt; {},\n}\n<span class=\"macro\">assert_eq!</span>(x, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">40</span>));\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"nothing!\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter_mut().next(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+x:+Result%3Cu32,+%26str%3E+=+Ok(7);%0A++++match+x.iter_mut().next()+%7B%0A++++++++Some(v)+=%3E+*v+=+40,%0A++++++++None+=%3E+%7B%7D,%0A++++%7D%0A++++assert_eq!(x,+Ok(40));%0A++++%0A++++let+mut+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0A++++assert_eq!(x.iter_mut().next(),+None);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.expect\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.4.0\">1.4.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1179-1181\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.expect\" class=\"fn\">expect</a>(self, msg: &amp;<a class=\"primitive\" href=\"std/primitive.str.html\">str</a>) -&gt; T<div class=\"where\">where\n    E: <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a>,</div></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value.</p>\n<p>Because this function may panic, its use is generally discouraged.\nInstead, prefer to use pattern matching and handle the <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>\ncase explicitly, or call <a href=\"std/result/enum.Result.html#method.unwrap_or\" title=\"method std::result::Result::unwrap_or\"><code>unwrap_or</code></a>, <a href=\"std/result/enum.Result.html#method.unwrap_or_else\" title=\"method std::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>, or\n<a href=\"std/result/enum.Result.html#method.unwrap_or_default\" title=\"method std::result::Result::unwrap_or_default\"><code>unwrap_or_default</code></a>.</p>\n<h5 id=\"panics\"><a class=\"doc-anchor\" href=\"#panics\">§</a>Panics</h5>\n<p>Panics if the value is an <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>, with a panic message including the\npassed message, and the content of the <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"examples-19\"><a class=\"doc-anchor\" href=\"#examples-19\">§</a>Examples</h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"emergency failure\"</span>);\nx.expect(<span class=\"string\">\"Testing expect\"</span>); <span class=\"comment\">// panics with `Testing expect: emergency failure`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0A++++x.expect(%22Testing+expect%22);%0A%7D&amp;edition=2024\"></a></div><h5 id=\"recommended-message-style\"><a class=\"doc-anchor\" href=\"#recommended-message-style\">§</a>Recommended Message Style</h5>\n<p>We recommend that <code>expect</code> messages are used to describe the reason you\n<em>expect</em> the <code>Result</code> should be <code>Ok</code>.</p>\n\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>path = std::env::var(<span class=\"string\">\"IMPORTANT_PATH\"</span>)\n    .expect(<span class=\"string\">\"env variable `IMPORTANT_PATH` should be set by `wrapper_script.sh`\"</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+path+=+std::env::var(%22IMPORTANT_PATH%22)%0A++++++++.expect(%22env+variable+%60IMPORTANT_PATH%60+should+be+set+by+%60wrapper_script.sh%60%22);%0A%7D&amp;edition=2024\"></a></div>\n<p><strong>Hint</strong>: If you’re having trouble remembering how to phrase expect\nerror messages remember to focus on the word “should” as in “env\nvariable should be set by blah” or “the given binary should be available\nand executable by the current user”.</p>\n<p>For more detail on expect message styles and the reasoning behind our recommendation please\nrefer to the section on <a href=\"../../std/error/index.html#common-message-styles\">“Common Message\nStyles”</a> in the\n<a href=\"../../std/error/index.html\"><code>std::error</code></a> module docs.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1227-1229\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.unwrap\" class=\"fn\">unwrap</a>(self) -&gt; T<div class=\"where\">where\n    E: <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a>,</div></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value.</p>\n<p>Because this function may panic, its use is generally discouraged.\nPanics are meant for unrecoverable errors, and\n<a href=\"https://doc.rust-lang.org/book/ch09-01-unrecoverable-errors-with-panic.html\">may abort the entire program</a>.</p>\n<p>Instead, prefer to use <a href=\"https://doc.rust-lang.org/book/ch09-02-recoverable-errors-with-result.html#a-shortcut-for-propagating-errors-the--operator\">the <code>?</code> (try) operator</a>, or pattern matching\nto handle the <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> case explicitly, or call <a href=\"std/result/enum.Result.html#method.unwrap_or\" title=\"method std::result::Result::unwrap_or\"><code>unwrap_or</code></a>,\n<a href=\"std/result/enum.Result.html#method.unwrap_or_else\" title=\"method std::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>, or <a href=\"std/result/enum.Result.html#method.unwrap_or_default\" title=\"method std::result::Result::unwrap_or_default\"><code>unwrap_or_default</code></a>.</p>\n<h5 id=\"panics-1\"><a class=\"doc-anchor\" href=\"#panics-1\">§</a>Panics</h5>\n<p>Panics if the value is an <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>, with a panic message provided by the\n<a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>’s value.</p>\n<h5 id=\"examples-20\"><a class=\"doc-anchor\" href=\"#examples-20\">§</a>Examples</h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap(), <span class=\"number\">2</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++assert_eq!(x.unwrap(),+2);%0A%7D&amp;edition=2024\"></a></div>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"emergency failure\"</span>);\nx.unwrap(); <span class=\"comment\">// panics with `emergency failure`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0A++++x.unwrap();%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or_default\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0, const unstable\">1.16.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1265-1268\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.unwrap_or_default\" class=\"fn\">unwrap_or_default</a>(self) -&gt; T<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\">Default</a>,</div></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value or a default</p>\n<p>Consumes the <code>self</code> argument then, if <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>, returns the contained\nvalue, otherwise if <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>, returns the default value for that\ntype.</p>\n<h5 id=\"examples-21\"><a class=\"doc-anchor\" href=\"#examples-21\">§</a>Examples</h5>\n<p>Converts a string to an integer, turning poorly-formed strings\ninto 0 (the default value for integers). <a href=\"std/primitive.str.html#method.parse\" title=\"method str::parse\"><code>parse</code></a> converts\na string to any other type that implements <a href=\"std/str/trait.FromStr.html\" title=\"trait std::str::FromStr\"><code>FromStr</code></a>, returning an\n<a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> on error.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>good_year_from_input = <span class=\"string\">\"1909\"</span>;\n<span class=\"kw\">let </span>bad_year_from_input = <span class=\"string\">\"190blarg\"</span>;\n<span class=\"kw\">let </span>good_year = good_year_from_input.parse().unwrap_or_default();\n<span class=\"kw\">let </span>bad_year = bad_year_from_input.parse().unwrap_or_default();\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"number\">1909</span>, good_year);\n<span class=\"macro\">assert_eq!</span>(<span class=\"number\">0</span>, bad_year);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+good_year_from_input+=+%221909%22;%0A++++let+bad_year_from_input+=+%22190blarg%22;%0A++++let+good_year+=+good_year_from_input.parse().unwrap_or_default();%0A++++let+bad_year+=+bad_year_from_input.parse().unwrap_or_default();%0A++++%0A++++assert_eq!(1909,+good_year);%0A++++assert_eq!(0,+bad_year);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.expect_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.17.0\">1.17.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1293-1295\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.expect_err\" class=\"fn\">expect_err</a>(self, msg: &amp;<a class=\"primitive\" href=\"std/primitive.str.html\">str</a>) -&gt; E<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a>,</div></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value.</p>\n<h5 id=\"panics-2\"><a class=\"doc-anchor\" href=\"#panics-2\">§</a>Panics</h5>\n<p>Panics if the value is an <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>, with a panic message including the\npassed message, and the content of the <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"examples-22\"><a class=\"doc-anchor\" href=\"#examples-22\">§</a>Examples</h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">10</span>);\nx.expect_err(<span class=\"string\">\"Testing expect_err\"</span>); <span class=\"comment\">// panics with `Testing expect_err: 10`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(10);%0A++++x.expect_err(%22Testing+expect_err%22);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1324-1326\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.unwrap_err\" class=\"fn\">unwrap_err</a>(self) -&gt; E<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a>,</div></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value.</p>\n<h5 id=\"panics-3\"><a class=\"doc-anchor\" href=\"#panics-3\">§</a>Panics</h5>\n<p>Panics if the value is an <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>, with a custom panic message provided\nby the <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>’s value.</p>\n<h5 id=\"examples-23\"><a class=\"doc-anchor\" href=\"#examples-23\">§</a>Examples</h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\nx.unwrap_err(); <span class=\"comment\">// panics with `2`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++x.unwrap_err();%0A%7D&amp;edition=2024\"></a></div>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"emergency failure\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_err(), <span class=\"string\">\"emergency failure\"</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0A++++assert_eq!(x.unwrap_err(),+%22emergency+failure%22);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_ok\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1361-1363\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.into_ok\" class=\"fn\">into_ok</a>(self) -&gt; T<div class=\"where\">where\n    E: <a class=\"trait\" href=\"std/convert/trait.Into.html\" title=\"trait std::convert::Into\">Into</a>&lt;<a class=\"primitive\" href=\"std/primitive.never.html\">!</a>&gt;,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>unwrap_infallible</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/61695\">#61695</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value, but never panics.</p>\n<p>Unlike <a href=\"std/result/enum.Result.html#method.unwrap\" title=\"method std::result::Result::unwrap\"><code>unwrap</code></a>, this method is known to never panic on the\nresult types it is implemented for. Therefore, it can be used\ninstead of <code>unwrap</code> as a maintainability safeguard that will fail\nto compile if the error type of the <code>Result</code> is later changed\nto an error that can actually occur.</p>\n<h5 id=\"examples-24\"><a class=\"doc-anchor\" href=\"#examples-24\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">fn </span>only_good_news() -&gt; <span class=\"prelude-ty\">Result</span>&lt;String, !&gt; {\n    <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"this is fine\"</span>.into())\n}\n\n<span class=\"kw\">let </span>s: String = only_good_news().into_ok();\n<span class=\"macro\">println!</span>(<span class=\"string\">\"{s}\"</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(never_type)%5D%0A%23!%5Bfeature(unwrap_infallible)%5D%0A%0A%0Afn+main()+%7B%0A++++fn+only_good_news()+-%3E+Result%3CString,+!%3E+%7B%0A++++++++Ok(%22this+is+fine%22.into())%0A++++%7D%0A++++%0A++++let+s:+String+=+only_good_news().into_ok();%0A++++println!(%22%7Bs%7D%22);%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1398-1400\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.into_err\" class=\"fn\">into_err</a>(self) -&gt; E<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/convert/trait.Into.html\" title=\"trait std::convert::Into\">Into</a>&lt;<a class=\"primitive\" href=\"std/primitive.never.html\">!</a>&gt;,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>unwrap_infallible</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/61695\">#61695</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value, but never panics.</p>\n<p>Unlike <a href=\"std/result/enum.Result.html#method.unwrap_err\" title=\"method std::result::Result::unwrap_err\"><code>unwrap_err</code></a>, this method is known to never panic on the\nresult types it is implemented for. Therefore, it can be used\ninstead of <code>unwrap_err</code> as a maintainability safeguard that will fail\nto compile if the ok type of the <code>Result</code> is later changed\nto a type that can actually occur.</p>\n<h5 id=\"examples-25\"><a class=\"doc-anchor\" href=\"#examples-25\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">fn </span>only_bad_news() -&gt; <span class=\"prelude-ty\">Result</span>&lt;!, String&gt; {\n    <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Oops, it failed\"</span>.into())\n}\n\n<span class=\"kw\">let </span>error: String = only_bad_news().into_err();\n<span class=\"macro\">println!</span>(<span class=\"string\">\"{error}\"</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(never_type)%5D%0A%23!%5Bfeature(unwrap_infallible)%5D%0A%0A%0Afn+main()+%7B%0A++++fn+only_bad_news()+-%3E+Result%3C!,+String%3E+%7B%0A++++++++Err(%22Oops,+it+failed%22.into())%0A++++%7D%0A++++%0A++++let+error:+String+=+only_bad_news().into_err();%0A++++println!(%22%7Berror%7D%22);%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.and\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1442-1446\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.and\" class=\"fn\">and</a>&lt;U&gt;(self, res: <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>res</code> if the result is <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>, otherwise returns the <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value of <code>self</code>.</p>\n<p>Arguments passed to <code>and</code> are eagerly evaluated; if you are passing the\nresult of a function call, it is recommended to use <a href=\"std/result/enum.Result.html#method.and_then\" title=\"method std::result::Result::and_then\"><code>and_then</code></a>, which is\nlazily evaluated.</p>\n<h5 id=\"examples-26\"><a class=\"doc-anchor\" href=\"#examples-26\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"late error\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"late error\"</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"early error\"</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"foo\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"early error\"</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"not a 2\"</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"late error\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"not a 2\"</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"different result type\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Ok</span>(<span class=\"string\">\"different result type\"</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++let+y:+Result%3C%26str,+%26str%3E+=+Err(%22late+error%22);%0A++++assert_eq!(x.and(y),+Err(%22late+error%22));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22early+error%22);%0A++++let+y:+Result%3C%26str,+%26str%3E+=+Ok(%22foo%22);%0A++++assert_eq!(x.and(y),+Err(%22early+error%22));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22not+a+2%22);%0A++++let+y:+Result%3C%26str,+%26str%3E+=+Err(%22late+error%22);%0A++++assert_eq!(x.and(y),+Err(%22not+a+2%22));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++let+y:+Result%3C%26str,+%26str%3E+=+Ok(%22different+result+type%22);%0A++++assert_eq!(x.and(y),+Ok(%22different+result+type%22));%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.and_then\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1488-1490\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.and_then\" class=\"fn\">and_then</a>&lt;U, F&gt;(self, op: F) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(T) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;,</div></h4></section></summary><div class=\"docblock\"><p>Calls <code>op</code> if the result is <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>, otherwise returns the <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value of <code>self</code>.</p>\n<p>This function can be used for control flow based on <code>Result</code> values.</p>\n<h5 id=\"examples-27\"><a class=\"doc-anchor\" href=\"#examples-27\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>sq_then_to_string(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;String, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">'static </span>str&gt; {\n    x.checked_mul(x).map(|sq| sq.to_string()).ok_or(<span class=\"string\">\"overflowed\"</span>)\n}\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">4</span>.to_string()));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">1_000_000</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"overflowed\"</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"string\">\"not a number\"</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"not a number\"</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++fn+sq_then_to_string(x:+u32)+-%3E+Result%3CString,+%26'static+str%3E+%7B%0A++++++++x.checked_mul(x).map(%7Csq%7C+sq.to_string()).ok_or(%22overflowed%22)%0A++++%7D%0A++++%0A++++assert_eq!(Ok(2).and_then(sq_then_to_string),+Ok(4.to_string()));%0A++++assert_eq!(Ok(1_000_000).and_then(sq_then_to_string),+Err(%22overflowed%22));%0A++++assert_eq!(Err(%22not+a+number%22).and_then(sq_then_to_string),+Err(%22not+a+number%22));%0A%7D&amp;edition=2024\"></a></div>\n<p>Often used to chain fallible operations that may return <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::{io::ErrorKind, path::Path};\n\n<span class=\"comment\">// Note: on Windows \"/\" maps to \"C:\\\"\n</span><span class=\"kw\">let </span>root_modified_time = Path::new(<span class=\"string\">\"/\"</span>).metadata().and_then(|md| md.modified());\n<span class=\"macro\">assert!</span>(root_modified_time.is_ok());\n\n<span class=\"kw\">let </span>should_fail = Path::new(<span class=\"string\">\"/bad/path\"</span>).metadata().and_then(|md| md.modified());\n<span class=\"macro\">assert!</span>(should_fail.is_err());\n<span class=\"macro\">assert_eq!</span>(should_fail.unwrap_err().kind(), ErrorKind::NotFound);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++use+std::%7Bio::ErrorKind,+path::Path%7D;%0A++++%0A++++//+Note:+on+Windows+%22/%22+maps+to+%22C:%5C%22%0A++++let+root_modified_time+=+Path::new(%22/%22).metadata().and_then(%7Cmd%7C+md.modified());%0A++++assert!(root_modified_time.is_ok());%0A++++%0A++++let+should_fail+=+Path::new(%22/bad/path%22).metadata().and_then(%7Cmd%7C+md.modified());%0A++++assert!(should_fail.is_err());%0A++++assert_eq!(should_fail.unwrap_err().kind(),+ErrorKind::NotFound);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.or\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1528-1532\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.or\" class=\"fn\">or</a>&lt;F&gt;(self, res: <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>res</code> if the result is <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>, otherwise returns the <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value of <code>self</code>.</p>\n<p>Arguments passed to <code>or</code> are eagerly evaluated; if you are passing the\nresult of a function call, it is recommended to use <a href=\"std/result/enum.Result.html#method.or_else\" title=\"method std::result::Result::or_else\"><code>or_else</code></a>, which is\nlazily evaluated.</p>\n<h5 id=\"examples-28\"><a class=\"doc-anchor\" href=\"#examples-28\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"late error\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"early error\"</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"not a 2\"</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"late error\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"late error\"</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">100</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++let+y:+Result%3Cu32,+%26str%3E+=+Err(%22late+error%22);%0A++++assert_eq!(x.or(y),+Ok(2));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22early+error%22);%0A++++let+y:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++assert_eq!(x.or(y),+Ok(2));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22not+a+2%22);%0A++++let+y:+Result%3Cu32,+%26str%3E+=+Err(%22late+error%22);%0A++++assert_eq!(x.or(y),+Err(%22late+error%22));%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++let+y:+Result%3Cu32,+%26str%3E+=+Ok(100);%0A++++assert_eq!(x.or(y),+Ok(2));%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.or_else\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1559-1561\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.or_else\" class=\"fn\">or_else</a>&lt;F, O&gt;(self, op: O) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;<div class=\"where\">where\n    O: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(E) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, F&gt;,</div></h4></section></summary><div class=\"docblock\"><p>Calls <code>op</code> if the result is <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>, otherwise returns the <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value of <code>self</code>.</p>\n<p>This function can be used for control flow based on result values.</p>\n<h5 id=\"examples-29\"><a class=\"doc-anchor\" href=\"#examples-29\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>sq(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; { <span class=\"prelude-val\">Ok</span>(x * x) }\n<span class=\"kw\">fn </span>err(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; { <span class=\"prelude-val\">Err</span>(x) }\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).or_else(sq).or_else(sq), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).or_else(err).or_else(sq), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>).or_else(sq).or_else(err), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">9</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>).or_else(err).or_else(err), <span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++fn+sq(x:+u32)+-%3E+Result%3Cu32,+u32%3E+%7B+Ok(x+*+x)+%7D%0A++++fn+err(x:+u32)+-%3E+Result%3Cu32,+u32%3E+%7B+Err(x)+%7D%0A++++%0A++++assert_eq!(Ok(2).or_else(sq).or_else(sq),+Ok(2));%0A++++assert_eq!(Ok(2).or_else(err).or_else(sq),+Ok(2));%0A++++assert_eq!(Err(3).or_else(sq).or_else(err),+Ok(9));%0A++++assert_eq!(Err(3).or_else(err).or_else(err),+Err(3));%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1590-1593\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.unwrap_or\" class=\"fn\">unwrap_or</a>(self, default: T) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value or a provided default.</p>\n<p>Arguments passed to <code>unwrap_or</code> are eagerly evaluated; if you are passing\nthe result of a function call, it is recommended to use <a href=\"std/result/enum.Result.html#method.unwrap_or_else\" title=\"method std::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>,\nwhich is lazily evaluated.</p>\n<h5 id=\"examples-30\"><a class=\"doc-anchor\" href=\"#examples-30\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>default = <span class=\"number\">2</span>;\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">9</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_or(default), <span class=\"number\">9</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"error\"</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_or(default), default);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+default+=+2;%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(9);%0A++++assert_eq!(x.unwrap_or(default),+9);%0A++++%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22error%22);%0A++++assert_eq!(x.unwrap_or(default),+default);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or_else\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/144211\" title=\"Tracking issue for const_result_trait_fn\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1616-1618\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.unwrap_or_else\" class=\"fn\">unwrap_or_else</a>&lt;F&gt;(self, op: F) -&gt; T<div class=\"where\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(E) -&gt; T,</div></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value or computes it from a closure.</p>\n<h5 id=\"examples-31\"><a class=\"doc-anchor\" href=\"#examples-31\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>count(x: <span class=\"kw-2\">&amp;</span>str) -&gt; usize { x.len() }\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).unwrap_or_else(count), <span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"string\">\"foo\"</span>).unwrap_or_else(count), <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++fn+count(x:+%26str)+-%3E+usize+%7B+x.len()+%7D%0A++++%0A++++assert_eq!(Ok(2).unwrap_or_else(count),+2);%0A++++assert_eq!(Err(%22foo%22).unwrap_or_else(count),+3);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.58.0, const unstable\">1.58.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/148714\" title=\"Tracking issue for const_result_unwrap_unchecked\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#1650\">Source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"#method.unwrap_unchecked\" class=\"fn\">unwrap_unchecked</a>(self) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value,\nwithout checking that the value is not an <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>Calling this method on an <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>.</p>\n<h5 id=\"examples-32\"><a class=\"doc-anchor\" href=\"#examples-32\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw\">unsafe </span>{ x.unwrap_unchecked() }, <span class=\"number\">2</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++assert_eq!(unsafe+%7B+x.unwrap_unchecked()+%7D,+2);%0A%7D&amp;edition=2024\"></a></div>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"emergency failure\"</span>);\n<span class=\"kw\">unsafe </span>{ x.unwrap_unchecked() }; <span class=\"comment\">// Undefined behavior!</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0A++++unsafe+%7B+x.unwrap_unchecked()+%7D;%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_err_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.58.0\">1.58.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1685\">Source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"#method.unwrap_err_unchecked\" class=\"fn\">unwrap_err_unchecked</a>(self) -&gt; E</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value,\nwithout checking that the value is not an <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"safety-1\"><a class=\"doc-anchor\" href=\"#safety-1\">§</a>Safety</h5>\n<p>Calling this method on an <a href=\"std/result/enum.Result.html#variant.Ok\" title=\"variant std::result::Result::Ok\"><code>Ok</code></a> is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>.</p>\n<h5 id=\"examples-33\"><a class=\"doc-anchor\" href=\"#examples-33\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">unsafe </span>{ x.unwrap_err_unchecked() }; <span class=\"comment\">// Undefined behavior!</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0A++++unsafe+%7B+x.unwrap_err_unchecked()+%7D;%0A%7D&amp;edition=2024\"></a></div>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"emergency failure\"</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw\">unsafe </span>{ x.unwrap_err_unchecked() }, <span class=\"string\">\"emergency failure\"</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0A++++assert_eq!(unsafe+%7B+x.unwrap_err_unchecked()+%7D,+%22emergency+failure%22);%0A%7D&amp;edition=2024\"></a></div></div></details></div></details>",0,"std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/core/iter/traits/accum.rs.html#209-211\">Source</a></span><a href=\"#impl-Sum%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, E&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;&gt; for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;U&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter/traits/accum.rs.html#231-233\">Source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;U, E&gt;&gt;,</div></h4></section></summary><div class=\"docblock\"><p>Takes each element in the <a href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\"><code>Iterator</code></a>: if it is an <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>, no further\nelements are taken, and the <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a> is returned. Should no <a href=\"std/result/enum.Result.html#variant.Err\" title=\"variant std::result::Result::Err\"><code>Err</code></a>\noccur, the sum of all elements is returned.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<p>This sums up every integer in a vector, rejecting the sum if a negative\nelement is encountered:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>f = |<span class=\"kw-2\">&amp;</span>x: <span class=\"kw-2\">&amp;</span>i32| <span class=\"kw\">if </span>x &lt; <span class=\"number\">0 </span>{ <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Negative element found\"</span>) } <span class=\"kw\">else </span>{ <span class=\"prelude-val\">Ok</span>(x) };\n<span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw\">_</span>&gt; = v.iter().map(f).sum();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">3</span>));\n<span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, -<span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw\">_</span>&gt; = v.iter().map(f).sum();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">\"Negative element found\"</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+f+=+%7C%26x:+%26i32%7C+if+x+%3C+0+%7B+Err(%22Negative+element+found%22)+%7D+else+%7B+Ok(x)+%7D;%0A++++let+v+=+vec!%5B1,+2%5D;%0A++++let+res:+Result%3Ci32,+_%3E+=+v.iter().map(f).sum();%0A++++assert_eq!(res,+Ok(3));%0A++++let+v+=+vec!%5B1,+-2%5D;%0A++++let+res:+Result%3Ci32,+_%3E+=+v.iter().map(f).sum();%0A++++assert_eq!(res,+Err(%22Negative+element+found%22));%0A%7D&amp;edition=2024\"></a></div></div></details></div></details>","Sum<Result<U, E>>","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Termination-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.61.0\">1.61.0</span> · <a class=\"src\" href=\"src/std/process.rs.html#2609-2619\">Source</a></span><a href=\"#impl-Termination-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"std/process/trait.Termination.html\" title=\"trait std::process::Termination\">Termination</a>, E: <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a>&gt; <a class=\"trait\" href=\"std/process/trait.Termination.html\" title=\"trait std::process::Termination\">Termination</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.report\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/std/process.rs.html#2610-2618\">Source</a><a href=\"#method.report\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/process/trait.Termination.html#tymethod.report\" class=\"fn\">report</a>(self) -&gt; <a class=\"struct\" href=\"std/process/struct.ExitCode.html\" title=\"struct std::process::ExitCode\">ExitCode</a></h4></section></summary><div class='docblock'>Is called to get the representation of the value as status code.\nThis status code is returned to the operating system.</div></details></div></details>","Termination","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Try-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2162\">Source</a><a href=\"#impl-Try-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/ops/trait.Try.html\" title=\"trait std::ops::Try\">Try</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2163\">Source</a><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Try.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = T</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>The type of the value produced by <code>?</code> when <em>not</em> short-circuiting.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Residual\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2164\">Source</a><a href=\"#associatedtype.Residual\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Try.html#associatedtype.Residual\" class=\"associatedtype\">Residual</a> = <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"std/convert/enum.Infallible.html\" title=\"enum std::convert::Infallible\">Infallible</a>, E&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>The type of the value passed to <a href=\"std/ops/trait.FromResidual.html#tymethod.from_residual\" title=\"associated function std::ops::FromResidual::from_residual\"><code>FromResidual::from_residual</code></a>\nas part of <code>?</code> when short-circuiting. <a href=\"std/ops/trait.Try.html#associatedtype.Residual\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_output\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2167\">Source</a><a href=\"#method.from_output\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Try.html#tymethod.from_output\" class=\"fn\">from_output</a>(output: &lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt; as <a class=\"trait\" href=\"std/ops/trait.Try.html\" title=\"trait std::ops::Try\">Try</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Try.html#associatedtype.Output\" title=\"type std::ops::Try::Output\">Output</a>) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from its <code>Output</code> type. <a href=\"std/ops/trait.Try.html#tymethod.from_output\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.branch\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#2172\">Source</a><a href=\"#method.branch\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Try.html#tymethod.branch\" class=\"fn\">branch</a>(\n    self,\n) -&gt; <a class=\"enum\" href=\"std/ops/enum.ControlFlow.html\" title=\"enum std::ops::ControlFlow\">ControlFlow</a>&lt;&lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt; as <a class=\"trait\" href=\"std/ops/trait.Try.html\" title=\"trait std::ops::Try\">Try</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Try.html#associatedtype.Residual\" title=\"type std::ops::Try::Residual\">Residual</a>, &lt;<a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt; as <a class=\"trait\" href=\"std/ops/trait.Try.html\" title=\"trait std::ops::Try\">Try</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Try.html#associatedtype.Output\" title=\"type std::ops::Try::Output\">Output</a>&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Used in <code>?</code> to decide whether the operator should produce a value\n(because this returned <a href=\"std/ops/enum.ControlFlow.html#variant.Continue\" title=\"variant std::ops::ControlFlow::Continue\"><code>ControlFlow::Continue</code></a>)\nor propagate a value back to the caller\n(because this returned <a href=\"std/ops/enum.ControlFlow.html#variant.Break\" title=\"variant std::ops::ControlFlow::Break\"><code>ControlFlow::Break</code></a>). <a href=\"std/ops/trait.Try.html#tymethod.branch\">Read more</a></div></details></div></details>","Try","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<section id=\"impl-CloneFromCell-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/cell.rs.html#786\">Source</a><a href=\"#impl-CloneFromCell-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/cell/trait.CloneFromCell.html\" title=\"trait std::cell::CloneFromCell\">CloneFromCell</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/cell/trait.CloneFromCell.html\" title=\"trait std::cell::CloneFromCell\">CloneFromCell</a>,\n    E: <a class=\"trait\" href=\"std/cell/trait.CloneFromCell.html\" title=\"trait std::cell::CloneFromCell\">CloneFromCell</a>,</div></h3></section>","CloneFromCell","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<section id=\"impl-Copy-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#552\">Source</a></span><a href=\"#impl-Copy-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/marker/trait.Copy.html\" title=\"trait std::marker::Copy\">Copy</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/marker/trait.Copy.html\" title=\"trait std::marker::Copy\">Copy</a>,\n    E: <a class=\"trait\" href=\"std/marker/trait.Copy.html\" title=\"trait std::marker::Copy\">Copy</a>,</div></h3></section>","Copy","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<section id=\"impl-Eq-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/118304\" title=\"Tracking issue for derive_const\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/result.rs.html#553\">Source</a></span><a href=\"#impl-Eq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/cmp/trait.Eq.html\" title=\"trait std::cmp::Eq\">Eq</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/cmp/trait.Eq.html\" title=\"trait std::cmp::Eq\">Eq</a>,\n    E: <a class=\"trait\" href=\"std/cmp/trait.Eq.html\" title=\"trait std::cmp::Eq\">Eq</a>,</div></h3></section>","Eq","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<section id=\"impl-StructuralPartialEq-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#553\">Source</a></span><a href=\"#impl-StructuralPartialEq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/marker/trait.StructuralPartialEq.html\" title=\"trait std::marker::StructuralPartialEq\">StructuralPartialEq</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;</h3></section>","StructuralPartialEq","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"],["<section id=\"impl-UseCloned-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1911-1914\">Source</a><a href=\"#impl-UseCloned-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"std/clone/trait.UseCloned.html\" title=\"trait std::clone::UseCloned\">UseCloned</a> for <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;T, E&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.UseCloned.html\" title=\"trait std::clone::UseCloned\">UseCloned</a>,\n    E: <a class=\"trait\" href=\"std/clone/trait.UseCloned.html\" title=\"trait std::clone::UseCloned\">UseCloned</a>,</div></h3></section>","UseCloned","std::thread::Result","std::io::error::Result","std::sync::nonpoison::TryLockResult","std::sync::poison::LockResult","std::sync::poison::TryLockResult","std::fmt::Result"]]]]);
    if (window.register_type_impls) {
        window.register_type_impls(type_impls);
    } else {
        window.pending_type_impls = type_impls;
    }
})()
//{"start":55,"fragment_lengths":[176858]}