// This code is automatically generated. DO NOT MODIFY.
// See crates/stdarch-gen-loongarch/README.md

use crate::{
    core_arch::{loongarch64::*, simd::*},
    mem::transmute,
};
use stdarch_test::simd_test;

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsll_b() {
    let a = i8x32::new(
        -111, -98, 47, -106, -82, -72, -70, 0, 110, -61, -20, 36, 41, -103, 42, 95, 15, -11,
        -25, -5, 40, -63, 56, -39, 43, 127, 86, 75, -48, -32, 72, 69,
    );
    let b = i8x32::new(
        64, -127, -78, 84, -102, -98, 45, 43, -78, -108, 25, 29, -65, 91, 36, 33, 61, 47, 69,
        -59, -10, 108, 121, -25, -125, 62, -69, 74, 121, -89, -57, 75,
    );
    let r = i64x4::new(
        18015190406413457,
        -4710544755986517832,
        -9191829245651812128,
        2882304449461665880,
    );

    assert_eq!(r, transmute(lasx_xvsll_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsll_h() {
    let a = i16x16::new(
        4856, -12188, 28154, -30840, -28949, 18688, -15524, 15161, 5118, 9078, -28997, 27522,
        32276, -26448, -5994, -10720,
    );
    let b = i16x16::new(
        -489, 29679, -21849, 9497, -19660, -26644, 7745, 5176, 4522, 9574, -4384, 20128, 7874,
        -19019, -3312, -26556,
    );
    let r = i64x4::new(
        1153199681048706048,
        4107430984994057904,
        7746911246556919808,
        7061899947028838480,
    );

    assert_eq!(r, transmute(lasx_xvsll_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsll_w() {
    let a = i32x8::new(
        1510216636,
        213576479,
        1189254660,
        -1355467453,
        1294786218,
        -1710122153,
        -615586704,
        -1571284743,
    );
    let b = i32x8::new(
        -529192780,
        352003269,
        -770638911,
        706076772,
        -1938691801,
        -1503291372,
        -471620902,
        769195345,
    );
    let r = i64x4::new(
        -7539760386422079488,
        -913293731912406008,
        -5372794352929123072,
        3598939055443673088,
    );

    assert_eq!(r, transmute(lasx_xvsll_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsll_d() {
    let a = i64x4::new(
        5587460212497087617,
        8474749651444529729,
        1738438059605040390,
        -4067680789859467618,
    );
    let b = i64x4::new(
        6741938213225194797,
        5195523862780666814,
        -3609057746391313602,
        4479859630248272682,
    );
    let r = i64x4::new(
        -8101940545267433472,
        4611686018427387904,
        -9223372036854775808,
        -289787284616642560,
    );

    assert_eq!(r, transmute(lasx_xvsll_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslli_b() {
    let a = i8x32::new(
        -94, -3, -119, 48, 100, -37, 40, -38, -29, -51, 88, 4, -25, -114, 55, 88, 100, 38, 83,
        104, -128, 126, -102, 105, 5, -72, 101, 124, 38, -108, 10, -44,
    );
    let r = i64x4::new(
        7539145145172948104,
        6979515765458220172,
        -6599752572338399088,
        5775955139904200724,
    );

    assert_eq!(r, transmute(lasx_xvslli_b::<2>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslli_h() {
    let a = i16x16::new(
        -28940, -25950, 22837, -4210, -14698, -22498, 27809, 10311, -17231, 19306, 6966, 1632,
        -29260, 23078, 2703, -10254,
    );
    let r = i64x4::new(
        -9223301665963114496,
        -4611615647535693824,
        140739635855360,
        -9223160928474759168,
    );

    assert_eq!(r, transmute(lasx_xvslli_h::<14>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslli_w() {
    let a = i32x8::new(
        1994019050,
        -2143307169,
        -1465670605,
        -1894478348,
        307662278,
        836483069,
        412058602,
        -1025645846,
    );
    let r = i64x4::new(
        6845471437529022464,
        -864691127599497216,
        -216172778791895040,
        -1585267064908546048,
    );

    assert_eq!(r, transmute(lasx_xvslli_w::<24>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslli_d() {
    let a = i64x4::new(
        4336457422713836724,
        8560628373228459557,
        7599406461945619908,
        -8194824695476258169,
    );
    let r = i64x4::new(
        -9223372036854775808,
        -6917529027641081856,
        -9223372036854775808,
        -2305843009213693952,
    );

    assert_eq!(r, transmute(lasx_xvslli_d::<61>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsra_b() {
    let a = i8x32::new(
        52, 91, -50, -85, -69, -95, -127, 8, 86, -4, -99, 72, 8, -14, 107, -97, -44, 105, 87,
        -117, -90, 118, 127, -106, 77, -92, -40, -82, -12, -112, -67, -118,
    );
    let b = i8x32::new(
        27, 13, -111, 16, -29, 45, -40, 67, -68, 121, -101, -38, 25, -121, 103, 74, 99, 16,
        -21, 6, 56, -24, 30, -89, 114, -108, -46, 9, 2, 53, 100, -76,
    );
    let r = i64x4::new(
        108647106216395270,
        -1801159457985266171,
        -71645659462473222,
        -505532365968836077,
    );

    assert_eq!(r, transmute(lasx_xvsra_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsra_h() {
    let a = i16x16::new(
        -13251, -24270, -27793, -1924, -989, 12103, 27324, 24449, 18911, 19481, -8980, 16617,
        28550, -13690, -1971, 3939,
    );
    let b = i16x16::new(
        -21726, 27818, 27200, -20739, -19045, -6458, 30141, -312, -15113, -30000, 21700, 17092,
        14409, 3061, -14681, 20631,
    );
    let r = i64x4::new(
        -119365732601073,
        26740135684866047,
        292450088307458195,
        8725659825471543,
    );

    assert_eq!(r, transmute(lasx_xvsra_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsra_w() {
    let a = i32x8::new(
        -1962976084,
        -1947195007,
        -955995895,
        -845185028,
        679708613,
        -1609457592,
        2012287263,
        -279940829,
    );
    let b = i32x8::new(
        763303798,
        231194360,
        470062549,
        -1292464267,
        -359409273,
        1320465704,
        -1970959884,
        -137912049,
    );
    let r = i64x4::new(
        -498216206805,
        -1730871820744,
        -27002218866473201,
        -36696200575105,
    );

    assert_eq!(r, transmute(lasx_xvsra_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsra_d() {
    let a = i64x4::new(
        1051630801678824769,
        -4354070504513252833,
        -43346970620111970,
        8876173186758680051,
    );
    let b = i64x4::new(
        3011489794605089083,
        -9183865802690171879,
        1530248905177224378,
        -4896156283978786540,
    );
    let r = i64x4::new(1, -129761412875, -1, 8464978396185);

    assert_eq!(r, transmute(lasx_xvsra_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrai_b() {
    let a = i8x32::new(
        46, 37, 112, -119, 96, -75, 53, -50, 100, 120, 90, 18, 32, 73, 63, 27, 73, 42, 111,
        -33, 12, 3, 108, 70, -108, 97, 15, -88, -9, 32, -126, -58,
    );
    let r = i64x4::new(
        -287109943871995390,
        72906425621612294,
        289919230257005060,
        -218421283493247239,
    );

    assert_eq!(r, transmute(lasx_xvsrai_b::<4>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrai_h() {
    let a = i16x16::new(
        -30922, -13998, -8176, -18755, 11883, -28383, 17428, 4209, 30936, -20707, -28809,
        -5893, 6072, 26622, -29177, 17463,
    );
    let r = i64x4::new(-281474976710658, 8589803520, -4295098367, 562941363552256);

    assert_eq!(r, transmute(lasx_xvsrai_h::<14>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrai_w() {
    let a = i32x8::new(
        -751445431,
        2057508448,
        -2111778568,
        -33537291,
        -1895386689,
        499743663,
        521751715,
        -784629424,
    );
    let r = i64x4::new(68719476730, -16, 17179869169, -25769803773);

    assert_eq!(r, transmute(lasx_xvsrai_w::<27>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrai_d() {
    let a = i64x4::new(
        -1330027126485395847,
        2853839147873904128,
        -6472260273666122769,
        -8461705224280067242,
    );
    let r = i64x4::new(-2, 2, -6, -8);

    assert_eq!(r, transmute(lasx_xvsrai_d::<60>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrar_b() {
    let a = i8x32::new(
        -45, 43, -69, -26, -38, 7, -79, 41, -6, -94, 1, 62, -82, -97, -39, 124, -99, 0, -23,
        12, 74, 16, -39, -15, -15, 31, -87, -124, -112, -39, 102, 7,
    );
    let b = i8x32::new(
        7, 68, -10, -95, -30, 74, -78, -17, -99, 98, 98, 80, -128, -62, 119, -13, 7, 92, -80,
        88, -70, -115, 81, 99, 110, 14, 7, -60, -89, -109, 97, 81,
    );
    let r = i64x4::new(
        66431358477468416,
        1153177339669047552,
        -77404437262827265,
        302862676776648704,
    );

    assert_eq!(r, transmute(lasx_xvsrar_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrar_h() {
    let a = i16x16::new(
        9840, 12527, -16657, 1341, 1073, -31572, -646, 17766, -16172, -9625, -27578, -20296,
        -9439, 19781, 4269, -7939,
    );
    let b = i16x16::new(
        29495, 11395, -1796, 26363, 26559, -12537, -23906, 29853, -17327, 20486, -24193, 16816,
        -26916, 11389, 8615, 25146,
    );
    let r = i64x4::new(
        562932876181581,
        562954232201216,
        -5712534652352536470,
        -2251658079567874,
    );

    assert_eq!(r, transmute(lasx_xvsrar_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrar_w() {
    let a = i32x8::new(
        1944832391,
        -1034950307,
        -1451047471,
        1427692017,
        -938846690,
        1764815474,
        -1610593481,
        -198860459,
    );
    let b = i32x8::new(
        -1327964835,
        1934527229,
        -13271412,
        1797333888,
        1389622833,
        -155405641,
        -1581591786,
        335424649,
    );
    let r = i64x4::new(
        -8589934588,
        6131890526069889068,
        906238092293,
        -1668156707832192,
    );

    assert_eq!(r, transmute(lasx_xvsrar_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrar_d() {
    let a = i64x4::new(
        5484150993813900402,
        9102605893479197027,
        -7628992365150862705,
        407230793930236127,
    );
    let b = i64x4::new(
        5977319318978215334,
        4512528532199919670,
        6381392913686620354,
        5222959627777138290,
    );
    let r = i64x4::new(19951225, 505, -1907248091287715676, 362);

    assert_eq!(r, transmute(lasx_xvsrar_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrari_b() {
    let a = i8x32::new(
        109, 3, -113, -66, 80, 8, -16, -45, 106, 9, 96, 53, 102, 6, -51, -120, -121, -94, -127,
        -109, 70, 112, 57, -43, -72, 63, -113, -113, 93, 124, -71, 81,
    );
    let r = i64x4::new(
        -360849773505150962,
        -1010494010926825203,
        -358302209459292943,
        790117907428411639,
    );

    assert_eq!(r, transmute(lasx_xvsrari_b::<3>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrari_h() {
    let a = i16x16::new(
        10070, -32733, -17965, 31244, -29243, 6071, -3241, 7927, -285, 21152, -3903, 3660,
        13839, -14765, -18197, -22466,
    );
    let r = i64x4::new(
        34621125774278695,
        9007143421804430,
        4222060231655423,
        -24488623625338826,
    );

    assert_eq!(r, transmute(lasx_xvsrari_h::<8>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrari_w() {
    let a = i32x8::new(
        -500433597,
        -325248258,
        -1000460213,
        209976326,
        -903490350,
        -314707005,
        -503879914,
        -356101505,
    );
    let r = i64x4::new(-1, 4294967294, -2, -1);

    assert_eq!(r, transmute(lasx_xvsrari_w::<29>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrari_d() {
    let a = i64x4::new(
        -3633983878249405921,
        5383874963092799521,
        -4872778697398942371,
        -2386944079627506318,
    );
    let r = i64x4::new(-3228, 4782, -4328, -2120);

    assert_eq!(r, transmute(lasx_xvsrari_d::<50>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrl_b() {
    let a = i8x32::new(
        -118, -38, -124, -54, 98, -128, 79, -36, 103, -128, -88, -49, -98, 60, 2, -59, -16, -4,
        27, 59, 105, 95, -37, -72, -110, 11, 75, 114, -49, 90, -21, -35,
    );
    let b = i8x32::new(
        98, -9, -55, 119, -93, -49, 14, 102, 104, -92, 48, 65, 46, 102, -33, -36, -80, -60, -4,
        56, 90, -121, 20, -53, -94, -28, -92, 39, 83, -100, -7, 114,
    );
    let r = i64x4::new(
        216455408162832674,
        864691138784135271,
        1660983950228656112,
        3996105849293766692,
    );

    assert_eq!(r, transmute(lasx_xvsrl_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrl_h() {
    let a = i16x16::new(
        10972, 24562, -12521, 26207, -104, -22440, -71, 23995, 14056, -10640, 15949, -18599,
        29813, -7756, 7950, -20154,
    );
    let b = i16x16::new(
        7336, 20691, 12756, -11763, -7124, -20665, 2106, -26250, -26129, 24711, -15979, 11749,
        -21358, -26257, -4616, 7882,
    );
    let r = i64x4::new(
        858654357979178,
        105271911894745103,
        412644454779584512,
        12385032119328029,
    );

    assert_eq!(r, transmute(lasx_xvsrl_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrl_w() {
    let a = i32x8::new(
        -1772037605,
        -1212681339,
        176585315,
        -732660743,
        -1822623484,
        992734189,
        1682031435,
        1636125097,
    );
    let b = i32x8::new(
        -938134804,
        -1078907146,
        -307437339,
        -1035019720,
        338751406,
        1059144383,
        -1414917923,
        -363001284,
    );
    let r = i64x4::new(3152506611213, 910538585043, 150899, 25769803779);

    assert_eq!(r, transmute(lasx_xvsrl_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrl_d() {
    let a = i64x4::new(
        6435451644778058510,
        -9196847159082085602,
        -5149048879671131155,
        1388424134264678769,
    );
    let b = i64x4::new(
        -6322302375543819270,
        -4446153186867162446,
        -4228232340343120478,
        228185722174108108,
    );
    let r = i64x4::new(22, 8215, 774027732, 338970735904462);

    assert_eq!(r, transmute(lasx_xvsrl_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrli_b() {
    let a = i8x32::new(
        66, -19, -15, 83, -53, -81, -93, -68, -103, 77, 25, 65, 20, 104, -81, 127, -82, -32,
        -11, 48, -83, -94, -74, 5, -117, -34, -28, 19, 13, -40, 68, 51,
    );
    let r = i64x4::new(
        -4853842685553676990,
        9200686999942024601,
        411695280685441198,
        3694315145030590091,
    );

    assert_eq!(r, transmute(lasx_xvsrli_b::<0>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrli_h() {
    let a = i16x16::new(
        -5451, -9527, 6137, -13536, -13439, 10877, -29799, 719, -28662, 31471, 20011, 1521,
        1386, -27895, 10040, 24311,
    );
    let r = i64x4::new(7036883009470493, 73014771737, 38655688722, 3096241924866048);

    assert_eq!(r, transmute(lasx_xvsrli_h::<11>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrli_w() {
    let a = i32x8::new(
        -1988432857,
        -1485450469,
        -951392465,
        -21616344,
        741104373,
        -605174159,
        -393417893,
        356142399,
    );
    let r = i64x4::new(
        92058329040061,
        140028818776997,
        120903329388054,
        11669426172998,
    );

    assert_eq!(r, transmute(lasx_xvsrli_w::<17>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrli_d() {
    let a = i64x4::new(
        8921700513621232732,
        1019177465435556626,
        2713436842570698733,
        -3430716780195672879,
    );
    let r = i64x4::new(16617962184, 1898365962, 5054169972, 27969530398);

    assert_eq!(r, transmute(lasx_xvsrli_d::<29>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlr_b() {
    let a = i8x32::new(
        -109, 126, -8, -44, -19, -72, -121, -116, 21, 24, -60, 73, 76, 95, -106, -89, 56, -82,
        -93, 112, -38, -24, -39, -57, -106, -17, -14, 31, 116, 16, 47, 122,
    );
    let b = i8x32::new(
        50, -60, 62, 57, -113, -30, -127, -21, -61, -84, -32, -113, -114, 1, 55, -73, 71, -95,
        8, -8, 28, 55, -59, -118, 89, 87, -10, 63, 2, 67, 25, 62,
    );
    let r = i64x4::new(
        1316227579002488869,
        72391849897361923,
        3604852287775921920,
        150872911094481483,
    );

    assert_eq!(r, transmute(lasx_xvsrlr_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlr_h() {
    let a = i16x16::new(
        -18779, 7604, 13987, 29727, 8545, 14399, -23049, 5564, 17277, 27629, -24885, 8060,
        -12999, 4495, 32293, -31802,
    );
    let b = i16x16::new(
        -19412, 3296, -29433, -25702, 19528, -23288, 18964, -13600, -11805, -27841, 14324,
        17650, -2, 18151, -24330, -10882,
    );
    let r = i64x4::new(
        8163242974380043,
        1566138173559930913,
        567182991583938672,
        565118914199555,
    );

    assert_eq!(r, transmute(lasx_xvsrlr_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlr_w() {
    let a = i32x8::new(
        -1025998507,
        -796106787,
        2021600494,
        398315156,
        965338474,
        -828271652,
        -102077533,
        -995359010,
    );
    let b = i32x8::new(
        -2089285463,
        264222581,
        -1942623583,
        -928385941,
        -1125618647,
        -149370823,
        -1786649473,
        -1080417791,
    );
    let r = i64x4::new(
        7164011834433,
        835329200199287,
        442383516915,
        7085854838990307330,
    );

    assert_eq!(r, transmute(lasx_xvsrlr_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlr_d() {
    let a = i64x4::new(
        2027979514153200323,
        4238639346117886861,
        -2310491845939102950,
        -4959482478857813602,
    );
    let b = i64x4::new(
        965489361978698802,
        4289858003677505067,
        -4742704455438896809,
        -8773295883299999969,
    );
    let r = i64x4::new(1801, 481878, 1923591164085, 6280495597);

    assert_eq!(r, transmute(lasx_xvsrlr_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlri_b() {
    let a = i8x32::new(
        -73, -25, 49, -12, -91, -46, 0, -44, 48, -66, 31, -39, 50, -103, -78, -38, -126, -47,
        -3, 84, 54, 112, -106, -46, 71, 28, 47, 27, -56, -119, -101, -95,
    );
    let r = i64x4::new(
        3819110935244323374,
        3975875884220952588,
        3829779379936769057,
        2893318883870770962,
    );

    assert_eq!(r, transmute(lasx_xvsrlri_b::<2>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlri_h() {
    let a = i16x16::new(
        6309, -29611, -25831, -4246, 15159, 10847, 16953, 29221, 6201, 24789, -30798, -15953,
        15706, -1900, 10475, -5507,
    );
    let r = i64x4::new(
        33777332217315340,
        16044215407804446,
        27303364801855500,
        32932658182619167,
    );

    assert_eq!(r, transmute(lasx_xvsrlri_h::<9>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlri_w() {
    let a = i32x8::new(
        828273676,
        -644812120,
        -857187805,
        -176164509,
        981336800,
        1382840349,
        -1522792930,
        -176015403,
    );
    let r = i64x4::new(8589934592, 8589934594, 4294967296, 8589934593);

    assert_eq!(r, transmute(lasx_xvsrlri_w::<31>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlri_d() {
    let a = i64x4::new(
        -5793930330848080801,
        3293244781940700302,
        1069657060216154101,
        -5794364669081104952,
    );
    let r = i64x4::new(
        197700214732210481,
        51456949717823442,
        16713391565877408,
        197693428197319479,
    );

    assert_eq!(r, transmute(lasx_xvsrlri_d::<6>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitclr_b() {
    let a = u8x32::new(
        190, 161, 30, 161, 194, 88, 175, 219, 144, 202, 22, 193, 212, 153, 191, 196, 137, 221,
        106, 10, 16, 144, 31, 238, 61, 152, 213, 196, 195, 243, 50, 92,
    );
    let b = u8x32::new(
        11, 9, 78, 66, 137, 176, 138, 254, 176, 67, 163, 134, 131, 97, 153, 72, 134, 128, 41,
        58, 184, 249, 6, 26, 185, 60, 185, 181, 44, 38, 89, 238,
    );
    let r = i64x4::new(
        -7229587192453094986,
        -4270087733699493232,
        -1576382945987863415,
        2031321085346416701,
    );

    assert_eq!(r, transmute(lasx_xvbitclr_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitclr_h() {
    let a = u16x16::new(
        7799, 9627, 56384, 27998, 4661, 64335, 54264, 6382, 47409, 49178, 38272, 57390, 35004,
        32388, 62552, 35760,
    );
    let b = u16x16::new(
        5291, 30357, 59434, 46615, 64011, 9844, 17102, 63063, 12386, 31313, 20554, 38159,
        54802, 37529, 18767, 51367,
    );
    let r = i64x4::new(
        7880974167965374071,
        1760507201925878325,
        6930636858734459185,
        -8417099780160452424,
    );

    assert_eq!(r, transmute(lasx_xvbitclr_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitclr_w() {
    let a = u32x8::new(
        4257127193, 1617538994, 1062231453, 1690763623, 2766967375, 2604092619, 3654495562,
        101565771,
    );
    let b = u32x8::new(
        1233687892, 2875139141, 3243465390, 3012934629, 2446741029, 1858096423, 3334422766,
        437336695,
    );
    let r = i64x4::new(
        6947276946051865369,
        7261774329674735005,
        -7262251986338409905,
        436221668492520778,
    );

    assert_eq!(r, transmute(lasx_xvbitclr_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitclr_d() {
    let a = u64x4::new(
        16927321994427904653,
        2683926075985226749,
        16958486450995068185,
        3668272799860716893,
    );
    let b = u64x4::new(
        15133760811038045272,
        12911195625023626617,
        15656282835364509484,
        1632666566472745103,
    );
    let r = i64x4::new(
        -1519422079281646963,
        2683926075985226749,
        -1488257622714483431,
        3668272799860684125,
    );

    assert_eq!(r, transmute(lasx_xvbitclr_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitclri_b() {
    let a = u8x32::new(
        141, 68, 55, 244, 88, 222, 227, 17, 167, 11, 144, 254, 176, 224, 143, 139, 254, 1, 83,
        117, 181, 160, 142, 4, 179, 103, 107, 27, 186, 98, 203, 106,
    );
    let r = i64x4::new(
        1271033348788520077,
        -8390310899796145241,
        328376522984587710,
        3065582154070828979,
    );

    assert_eq!(r, transmute(lasx_xvbitclri_b::<6>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitclri_h() {
    let a = u16x16::new(
        38228, 2400, 61493, 22229, 35926, 42301, 55100, 57087, 23321, 21128, 18634, 59029,
        56405, 24055, 11367, 27455,
    );
    let r = i64x4::new(
        6257171367882429780,
        -2378508372711469996,
        -1831477648240911591,
        7727381349517352021,
    );

    assert_eq!(r, transmute(lasx_xvbitclri_h::<1>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitclri_w() {
    let a = u32x8::new(
        4093464829, 3397035519, 3710215001, 425447773, 2028980386, 1200168081, 1687167090,
        2988462494,
    );
    let r = i64x4::new(
        -8468273631661829891,
        1827284273827504985,
        542996640125929634,
        -5611395396043530126,
    );

    assert_eq!(r, transmute(lasx_xvbitclri_w::<30>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitclri_d() {
    let a = u64x4::new(
        11636830919927548139,
        10182450295979110848,
        14581196067604683625,
        18383675221698776393,
    );
    let r = i64x4::new(
        -6809983522526181141,
        -8264364146474618432,
        -3865618374849045655,
        -63139220754952887,
    );

    assert_eq!(r, transmute(lasx_xvbitclri_d::<46>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitset_b() {
    let a = u8x32::new(
        225, 92, 109, 112, 17, 10, 26, 83, 15, 81, 108, 14, 45, 110, 122, 43, 4, 150, 103, 97,
        111, 130, 134, 212, 62, 58, 9, 2, 56, 158, 26, 145,
    );
    let b = u8x32::new(
        52, 116, 92, 53, 153, 232, 239, 116, 224, 124, 185, 146, 220, 6, 151, 66, 61, 170, 93,
        190, 38, 252, 85, 37, 106, 174, 206, 83, 194, 190, 144, 114,
    );
    let r = i64x4::new(
        6024139629681007857,
        3457196872474448143,
        -817805275247962588,
        -7702318388235109826,
    );

    assert_eq!(r, transmute(lasx_xvbitset_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitset_h() {
    let a = u16x16::new(
        17259, 49211, 15974, 6099, 8663, 62383, 26831, 38552, 3409, 2195, 20043, 5352, 3983,
        31516, 6274, 5947,
    );
    let b = u16x16::new(
        53731, 18053, 52835, 11975, 35791, 12348, 45618, 26117, 33156, 26353, 49938, 43656,
        36487, 64856, 49663, 56384,
    );
    let r = i64x4::new(
        1716784528350724971,
        -7586198329949707817,
        1578597770746596689,
        1674099372676878223,
    );

    assert_eq!(r, transmute(lasx_xvbitset_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitset_w() {
    let a = u32x8::new(
        2021234591, 3371814330, 3553513799, 494005311, 250094477, 2516669349, 1444421180,
        3141613342,
    );
    let b = u32x8::new(
        3030677440, 3512547286, 2983366759, 1926382844, 3455887892, 2988190229, 2851051202,
        575886239,
    );
    let r = i64x4::new(
        -3964911796154165345,
        2121736658348822983,
        -7628724325403057267,
        -4953617511697867204,
    );

    assert_eq!(r, transmute(lasx_xvbitset_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitset_d() {
    let a = u64x4::new(
        13787459408145721576,
        16595537902770630413,
        7409136402519495190,
        8641001130845153939,
    );
    let b = u64x4::new(
        5192067677796360406,
        648800965073738257,
        18042109477292491586,
        15371630372089390212,
    );
    let r = i64x4::new(
        -4659284665559635736,
        -1851206170938790131,
        7409136402519495190,
        8641001130845153939,
    );

    assert_eq!(r, transmute(lasx_xvbitset_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitseti_b() {
    let a = u8x32::new(
        119, 80, 249, 199, 113, 106, 84, 111, 190, 194, 53, 9, 139, 230, 49, 32, 150, 255, 16,
        235, 219, 105, 54, 143, 119, 37, 74, 94, 47, 119, 97, 78,
    );
    let r = i64x4::new(
        -1165048079419059977,
        -6867454469778062658,
        -8091022549765259370,
        -3539275497407339017,
    );

    assert_eq!(r, transmute(lasx_xvbitseti_b::<7>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitseti_h() {
    let a = u16x16::new(
        3428, 49184, 29775, 38443, 2320, 51224, 40616, 46501, 26758, 21099, 57944, 43971,
        47859, 19503, 41964, 61802,
    );
    let r = i64x4::new(
        -5320030648396665500,
        -5357666549029656304,
        -6069759003260655482,
        -1050847327214912781,
    );

    assert_eq!(r, transmute(lasx_xvbitseti_h::<13>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitseti_w() {
    let a = u32x8::new(
        3638204102, 2069373672, 3681483208, 2380952857, 3881087295, 2378927021, 1601131765,
        3307909931,
    );
    let r = i64x4::new(
        8887892248618505926,
        -5914786406144738872,
        -5923487305849065153,
        -1933536090599238411,
    );

    assert_eq!(r, transmute(lasx_xvbitseti_w::<29>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitseti_d() {
    let a = u64x4::new(
        9060047554002173201,
        464447178838056277,
        7020364402684265679,
        7640056937583456779,
    );
    let r = i64x4::new(
        9060047554002173201,
        464447178838056277,
        7020364402684265679,
        7640056937583456779,
    );

    assert_eq!(r, transmute(lasx_xvbitseti_d::<17>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitrev_b() {
    let a = u8x32::new(
        86, 45, 120, 26, 67, 111, 181, 110, 186, 247, 233, 56, 217, 245, 220, 182, 112, 159,
        77, 122, 167, 75, 37, 185, 177, 18, 190, 215, 60, 13, 253, 99,
    );
    let b = u8x32::new(
        147, 78, 169, 66, 243, 63, 20, 253, 87, 88, 137, 49, 21, 0, 154, 117, 112, 42, 28, 48,
        22, 139, 165, 183, 96, 228, 17, 98, 218, 192, 92, 92,
    );
    let r = i64x4::new(
        5667198812028562782,
        -7577037021778282950,
        4108764896531684209,
        8353346322052154032,
    );

    assert_eq!(r, transmute(lasx_xvbitrev_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitrev_h() {
    let a = u16x16::new(
        44834, 48985, 47421, 26123, 36975, 54201, 35400, 17963, 44073, 49622, 17677, 24094,
        34507, 53208, 48965, 4380,
    );
    let b = u16x16::new(
        3119, 5355, 43390, 6709, 8036, 22161, 7944, 37786, 31676, 17612, 21999, 1550, 37643,
        51935, 23672, 51448,
    );
    let r = i64x4::new(
        7362252059331604258,
        4768057775407992959,
        2170388733584915497,
        1161012008856358603,
    );

    assert_eq!(r, transmute(lasx_xvbitrev_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitrev_w() {
    let a = u32x8::new(
        1780458127, 1583179777, 1403171735, 3038008548, 1551651469, 1192480700, 40883360,
        521408888,
    );
    let b = u32x8::new(
        2551625282, 692446886, 1507542621, 1654251513, 25012964, 1671838513, 1315668038,
        3268446736,
    );
    let r = i64x4::new(
        6799705642561938059,
        -5254481525065206889,
        5121102659209417373,
        2239715596821320928,
    );

    assert_eq!(r, transmute(lasx_xvbitrev_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitrev_d() {
    let a = u64x4::new(
        3534178575908999157,
        3435592769216332161,
        6355029412175758040,
        10622443384676276507,
    );
    let b = u64x4::new(
        765862270911233836,
        2594415241338312820,
        11114879593910781230,
        15091508809743360642,
    );
    let r = i64x4::new(
        3534196168095043573,
        3440096368843702657,
        6355099780919935704,
        -7824300689033275105,
    );

    assert_eq!(r, transmute(lasx_xvbitrev_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitrevi_b() {
    let a = u8x32::new(
        112, 47, 201, 157, 172, 239, 255, 219, 200, 1, 134, 120, 144, 4, 15, 114, 35, 84, 237,
        118, 244, 43, 132, 135, 32, 116, 216, 122, 83, 233, 95, 217,
    );
    let r = i64x4::new(
        -297290846994624688,
        5921992374835618280,
        -6366950966577761277,
        -468434338938596352,
    );

    assert_eq!(r, transmute(lasx_xvbitrevi_b::<5>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitrevi_h() {
    let a = u16x16::new(
        32769, 5307, 42421, 62367, 28539, 63062, 1989, 15130, 7026, 1542, 27332, 53533, 17199,
        28761, 1428, 12804,
    );
    let r = i64x4::new(
        -315342455509907455,
        3682272988378851195,
        -2801974798966189198,
        4180481285432101679,
    );

    assert_eq!(r, transmute(lasx_xvbitrevi_h::<11>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitrevi_w() {
    let a = u32x8::new(
        4260813560, 2237147704, 787609405, 2632090994, 1944569031, 3636389111, 844354358,
        3691914548,
    );
    let r = i64x4::new(
        -4226581827093603592,
        -2530313314094680259,
        -7440257783990598457,
        -7201777846932221130,
    );

    assert_eq!(r, transmute(lasx_xvbitrevi_w::<30>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitrevi_d() {
    let a = u64x4::new(
        5820240183830393881,
        7908556960014755456,
        17094377170254219540,
        17105994065815884924,
    );
    let r = i64x4::new(
        5820240183863948313,
        7908556959981201024,
        -1352366903421777644,
        -1340750007927221124,
    );

    assert_eq!(r, transmute(lasx_xvbitrevi_d::<25>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadd_b() {
    let a = i8x32::new(
        -63, 97, -109, 57, -109, 103, -19, 65, 57, -37, 32, 5, -97, -108, 12, -61, -91, 104,
        -2, 65, -41, -85, -54, 104, 40, -13, 78, 80, 75, -33, -121, -67,
    );
    let b = i8x32::new(
        -32, -51, 9, 94, 98, 84, -101, -90, -24, -111, 104, -25, 112, -85, 87, -10, -90, -59,
        96, -43, -67, 16, -8, 83, 126, -13, 58, 116, 73, -90, 6, 67,
    );
    let r = i64x4::new(
        -1762952590630572383,
        -5088153816373105631,
        -4917161598430335669,
        39834845715162790,
    );

    assert_eq!(r, transmute(lasx_xvadd_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadd_h() {
    let a = i16x16::new(
        19227, 23953, -4654, -5363, 31202, 4004, -2636, 15810, -18448, 29154, -23642, -23324,
        23716, 21938, -17499, -1447,
    );
    let b = i16x16::new(
        10023, 12046, -30915, -30883, 29754, 22142, -11854, 5774, 8790, 19058, -32113, 4500,
        17933, 13821, 19847, 13830,
    );
    let r = i64x4::new(
        8244530777499333186,
        6075575139936955932,
        -5298442949366588858,
        3485514723534807729,
    );

    assert_eq!(r, transmute(lasx_xvadd_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadd_w() {
    let a = i32x8::new(
        130061221,
        1238983557,
        1050069092,
        -1831874224,
        -377156607,
        1147824901,
        -1862271997,
        91173942,
    );
    let b = i32x8::new(
        683768234,
        -1042445407,
        -327184682,
        -1513884019,
        347904368,
        886761024,
        -1570339601,
        13462118,
    );
    let r = i64x4::new(
        844124927480171855,
        4076821840425015098,
        8738480013042623857,
        449408456544649458,
    );

    assert_eq!(r, transmute(lasx_xvadd_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadd_d() {
    let a = i64x4::new(
        -3908230933439843201,
        -2965012514388925511,
        -336128270114892540,
        -637330020659137335,
    );
    let b = i64x4::new(
        -7034299759176626990,
        -361127056732231567,
        4052152376745196186,
        -2695706064065117364,
    );
    let r = i64x4::new(
        7504213381093081425,
        -3326139571121157078,
        3716024106630303646,
        -3333036084724254699,
    );

    assert_eq!(r, transmute(lasx_xvadd_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddi_bu() {
    let a = i8x32::new(
        97, -53, -62, 74, 99, 103, 85, -62, 12, -18, -65, 32, 19, -86, 65, -26, -98, 56, -9,
        -49, 4, 57, -22, 9, 93, 38, 124, -2, -121, 70, 125, 21,
    );
    let r = i64x4::new(
        -4226511262663192988,
        -1637994053855153905,
        931466702237612961,
        1765491911008659808,
    );

    assert_eq!(r, transmute(lasx_xvaddi_bu::<3>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddi_hu() {
    let a = i16x16::new(
        28186, 30980, -18298, 10584, -13771, -23924, -28546, 30222, -16145, -32706, -20261,
        19828, 22395, -2057, 5657, 15125,
    );
    let r = i64x4::new(
        2979615520472788507,
        8507177098988603958,
        5581561774286553328,
        4257614802810591100,
    );

    assert_eq!(r, transmute(lasx_xvaddi_hu::<1>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddi_wu() {
    let a = i32x8::new(
        832142867,
        -97637134,
        470208227,
        -904606685,
        -2133615997,
        -538764334,
        627855087,
        2056153787,
    );
    let r = i64x4::new(
        -419348219263615451,
        -3885256050038354187,
        -2313975115310458219,
        8831113348648816385,
    );

    assert_eq!(r, transmute(lasx_xvaddi_wu::<18>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddi_du() {
    let a = i64x4::new(
        2524418528961435407,
        -8855335564236661523,
        -6695152760024429972,
        -4546559236496052098,
    );
    let r = i64x4::new(
        2524418528961435431,
        -8855335564236661499,
        -6695152760024429948,
        -4546559236496052074,
    );

    assert_eq!(r, transmute(lasx_xvaddi_du::<24>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsub_b() {
    let a = i8x32::new(
        69, 68, 89, -122, -10, 4, 91, -20, -104, 41, -2, 28, -58, 89, 8, 71, 46, 82, -101, 51,
        -88, -102, -124, -9, 40, -59, -102, -16, 3, 103, 85, -97,
    );
    let b = i8x32::new(
        -65, -118, -63, 106, 15, -103, -19, -85, -42, 55, -34, -9, 15, 86, 74, 4, -118, -124,
        43, 2, 17, -82, 112, -28, 76, -58, 103, -48, -26, 27, -97, 14,
    );
    let r = i64x4::new(
        4714824500264876678,
        4881343131253011138,
        1374983920368537252,
        -7947080804470620196,
    );

    assert_eq!(r, transmute(lasx_xvsub_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsub_h() {
    let a = i16x16::new(
        13861, -12177, -9887, -27491, 3957, -5779, -6788, 4221, -12561, 4789, -8335, -24637,
        660, -11584, -22855, 31170,
    );
    let b = i16x16::new(
        -10247, 15942, -17883, -32294, -13460, -6485, 4553, 25005, -26816, -11045, 312, 22201,
        12797, -7932, -13605, -24793,
    );
    let r = i64x4::new(
        1351958658151964204,
        -5849943150155381751,
        5263263451968059311,
        -2694318201466204009,
    );

    assert_eq!(r, transmute(lasx_xvsub_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsub_w() {
    let a = i32x8::new(
        178703054,
        -696864732,
        212849982,
        -285846503,
        -1117046518,
        705292054,
        739892078,
        504545429,
    );
    let b = i32x8::new(
        1845948974,
        513755820,
        -260175909,
        -530928548,
        1413787975,
        -1421495822,
        1424414367,
        1652017030,
    );
    let r = i64x4::new(
        -5199575676077746016,
        1052619368584826211,
        9134484374713436099,
        -4928352995773315889,
    );

    assert_eq!(r, transmute(lasx_xvsub_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsub_d() {
    let a = i64x4::new(
        -7646834273082474631,
        -3919573082038908840,
        1242665522125115913,
        -7118090461806523548,
    );
    let b = i64x4::new(
        8536740478963669238,
        -5376035241109169794,
        -2919045115911617717,
        -5820964252152272230,
    );
    let r = i64x4::new(
        2263169321663407747,
        1456462159070260954,
        4161710638036733630,
        -1297126209654251318,
    );

    assert_eq!(r, transmute(lasx_xvsub_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubi_bu() {
    let a = i8x32::new(
        -110, 82, -20, -84, 15, -27, -19, -10, 74, -11, 10, -87, 103, -61, 21, -98, -92, -49,
        78, 102, -11, -49, -45, 65, 12, 93, 109, -99, -11, -82, -27, 98,
    );
    let r = i64x4::new(
        -1594036762305411707,
        -7995940638099118019,
        3802941238546645655,
        6185872108420092159,
    );

    assert_eq!(r, transmute(lasx_xvsubi_bu::<13>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubi_hu() {
    let a = i16x16::new(
        20553, 24028, -32247, -8607, 12622, -11323, -26896, -27740, -12003, -16731, 2560,
        -6936, -6669, -11254, -12625, 5415,
    );
    let r = i64x4::new(
        -2424482502709784510,
        -7809920247766568633,
        -1954269795052498666,
        1522443898558080492,
    );

    assert_eq!(r, transmute(lasx_xvsubi_hu::<7>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubi_wu() {
    let a = i32x8::new(
        755271012,
        658180721,
        -240702681,
        -573588257,
        -869840064,
        -1735073421,
        798270655,
        299197982,
    );
    let r = i64x4::new(
        2826864560638821706,
        -2463542912799528179,
        -7452083707597862106,
        1285045436848317605,
    );

    assert_eq!(r, transmute(lasx_xvsubi_wu::<26>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubi_du() {
    let a = i64x4::new(
        -6314492083383377124,
        -2455352880818468995,
        4567295273188684508,
        4145748346670499022,
    );
    let r = i64x4::new(
        -6314492083383377136,
        -2455352880818469007,
        4567295273188684496,
        4145748346670499010,
    );

    assert_eq!(r, transmute(lasx_xvsubi_du::<12>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmax_b() {
    let a = i8x32::new(
        25, 6, 107, -17, 0, 0, -33, -126, -67, -110, -28, -71, 103, -104, 76, -67, -63, 109,
        -111, 21, -117, 23, 0, 127, 97, 55, -124, -87, -49, -29, -50, 33,
    );
    let b = i8x32::new(
        -9, 89, -54, -48, -35, 107, -21, 85, -105, -19, -97, -119, 110, -49, -29, 38, 88, 38,
        43, 117, -99, -12, -56, 125, -117, 87, 98, -75, 64, 37, 116, 118,
    );
    let r = i64x4::new(
        6191159764511840537,
        2759808746143411645,
        9151340407859932504,
        8535488153625188193,
    );

    assert_eq!(r, transmute(lasx_xvmax_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmax_h() {
    let a = i16x16::new(
        30763, 3415, 26324, -7315, -21080, 18524, -4450, 24816, -15714, -28542, -635, -31873,
        -26693, 15869, -3002, -24310,
    );
    let b = i16x16::new(
        -31234, 12467, 15235, -27825, 27576, -30308, 5780, 15439, 5332, -17912, 27099, -21207,
        26461, -8845, 28810, -15394,
    );
    let r = i64x4::new(
        -2058876393102280661,
        6985107848176626616,
        -5969123438663035692,
        -4332902052436023459,
    );

    assert_eq!(r, transmute(lasx_xvmax_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmax_w() {
    let a = i32x8::new(
        1577861415,
        918171955,
        -750433312,
        187580904,
        2059773788,
        -1443991497,
        -1216535607,
        1560471573,
    );
    let b = i32x8::new(
        -1945753238,
        -891888859,
        -78561680,
        1374400928,
        -70918058,
        1356405224,
        -371800255,
        -244516818,
    );
    let r = i64x4::new(
        3943518520407245095,
        5903007041568456304,
        5825716079263328092,
        6702174376295843649,
    );

    assert_eq!(r, transmute(lasx_xvmax_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmax_d() {
    let a = i64x4::new(
        -2766896964461117900,
        -5078071472767258214,
        9065828085534222331,
        -6500758532071144491,
    );
    let b = i64x4::new(
        -22138921162050098,
        -8125932019434035875,
        -7840786109368633952,
        -880822478913123851,
    );
    let r = i64x4::new(
        -22138921162050098,
        -5078071472767258214,
        9065828085534222331,
        -880822478913123851,
    );

    assert_eq!(r, transmute(lasx_xvmax_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaxi_b() {
    let a = i8x32::new(
        -125, -85, -100, -36, 78, -85, 8, -111, -4, 10, -124, -8, 85, 25, -92, 61, 61, -45, 68,
        58, -5, 10, 121, 74, -100, 75, 78, 36, -81, 0, 21, 82,
    );
    let r = i64x4::new(
        -790112015120730635,
        4464502462647438076,
        5366332505119323453,
        5914634738497113077,
    );

    assert_eq!(r, transmute(lasx_xvmaxi_b::<-11>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaxi_h() {
    let a = i16x16::new(
        10159, 11019, -527, 25779, 18814, -6803, -7822, -21020, 17899, -30211, -21703, -32203,
        -17678, -31762, -12745, 15653,
    );
    let r = i64x4::new(
        7256424853078222767,
        -2814792717481602,
        -2814792717482517,
        4406209242478280693,
    );

    assert_eq!(r, transmute(lasx_xvmaxi_h::<-11>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaxi_w() {
    let a = i32x8::new(
        -1902781562,
        -701262116,
        1050694797,
        1927374994,
        2034319488,
        1270402141,
        1507027857,
        -2022667122,
    );
    let r = i64x4::new(
        21474836485,
        8278012567408891021,
        5456335650397700224,
        22981864337,
    );

    assert_eq!(r, transmute(lasx_xvmaxi_w::<5>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaxi_d() {
    let a = i64x4::new(
        1922310852027675403,
        1444112415686500862,
        -2217486151251900264,
        2429249725865673045,
    );
    let r = i64x4::new(
        1922310852027675403,
        1444112415686500862,
        -3,
        2429249725865673045,
    );

    assert_eq!(r, transmute(lasx_xvmaxi_d::<-3>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmax_bu() {
    let a = u8x32::new(
        85, 114, 198, 232, 2, 92, 134, 60, 6, 73, 97, 135, 118, 147, 202, 24, 163, 26, 22, 241,
        100, 118, 187, 179, 231, 20, 8, 232, 203, 101, 192, 9,
    );
    let b = u8x32::new(
        53, 108, 137, 217, 144, 216, 90, 50, 81, 196, 11, 85, 124, 110, 245, 183, 35, 166, 114,
        134, 174, 222, 3, 134, 149, 130, 39, 166, 182, 16, 44, 58,
    );
    let r = i64x4::new(
        4361411406047113813,
        -5191080832418069423,
        -5495554077319059805,
        4233495576175936231,
    );

    assert_eq!(r, transmute(lasx_xvmax_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmax_hu() {
    let a = u16x16::new(
        5749, 55167, 53819, 29245, 38403, 35505, 59653, 25124, 35403, 58917, 5938, 9735, 59292,
        13480, 10576, 54135,
    );
    let b = u16x16::new(
        5035, 18828, 58275, 53640, 3989, 38318, 53531, 14719, 27606, 5401, 62928, 12836, 16867,
        7709, 62726, 59945,
    );
    let r = i64x4::new(
        -3348176030115359115,
        7072033525073876483,
        3613283078621203019,
        -1573457187787184228,
    );

    assert_eq!(r, transmute(lasx_xvmax_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmax_wu() {
    let a = u32x8::new(
        1479333943, 2676167483, 3836141683, 1561090643, 2383304043, 4050203265, 880499204,
        1213140090,
    );
    let b = u32x8::new(
        3319622969, 1208019942, 2301441769, 3536726941, 665528183, 2671171581, 1912772755,
        2591579616,
    );
    let r = i64x4::new(
        -6952692252286292679,
        -3256617523396288397,
        -1051253505998826133,
        -7315994376096540525,
    );

    assert_eq!(r, transmute(lasx_xvmax_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmax_du() {
    let a = u64x4::new(
        15606303230109259264,
        8116571215893940866,
        8029178663488389518,
        1343606515742555302,
    );
    let b = u64x4::new(
        12474736035319899163,
        7894892261694004420,
        3771675238777573447,
        5141420152487342561,
    );
    let r = i64x4::new(
        -2840440843600292352,
        8116571215893940866,
        8029178663488389518,
        5141420152487342561,
    );

    assert_eq!(r, transmute(lasx_xvmax_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaxi_bu() {
    let a = u8x32::new(
        5, 31, 107, 171, 93, 98, 60, 232, 147, 171, 189, 163, 227, 182, 246, 12, 186, 67, 84,
        153, 12, 95, 0, 34, 84, 166, 191, 25, 19, 211, 84, 138,
    );
    let r = i64x4::new(
        -1712385603860226294,
        934135061546904467,
        2452877454773339066,
        -8478920119441971628,
    );

    assert_eq!(r, transmute(lasx_xvmaxi_bu::<10>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaxi_hu() {
    let a = u16x16::new(
        48338, 4001, 46491, 35597, 23103, 58140, 58650, 37062, 44161, 23848, 12302, 18312,
        7294, 3406, 24569, 9169,
    );
    let r = i64x4::new(
        -8426879650153513774,
        -8014466583217022401,
        5154422611776154753,
        2580949584734723198,
    );

    assert_eq!(r, transmute(lasx_xvmaxi_hu::<15>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaxi_wu() {
    let a = u32x8::new(
        3721611043, 1077683923, 3718582126, 906645810, 3702930805, 3185396072, 3048402980,
        1473444340,
    );
    let r = i64x4::new(
        4628617208431593251,
        3894014106724011886,
        -4765572115959759499,
        6328395255824707620,
    );

    assert_eq!(r, transmute(lasx_xvmaxi_wu::<12>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaxi_du() {
    let a = u64x4::new(
        6545420797271239625,
        14656235662490779697,
        8085422797121321277,
        3280369825537805033,
    );
    let r = i64x4::new(
        6545420797271239625,
        -3790508411218771919,
        8085422797121321277,
        3280369825537805033,
    );

    assert_eq!(r, transmute(lasx_xvmaxi_du::<18>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmin_b() {
    let a = i8x32::new(
        60, -51, 1, -10, 118, -28, -35, 82, -26, -121, -72, 104, 120, -114, -89, 101, -21,
        -122, 65, -87, -82, 111, -120, 76, 3, -76, 9, 56, -41, -101, -3, 66,
    );
    let b = i8x32::new(
        -95, -1, -42, 28, 90, -13, 93, 39, -93, -126, -63, 119, -82, -11, -1, 28, 58, -54, 83,
        -38, 50, 121, 99, -78, -10, 115, 116, 63, 20, -24, 81, -7,
    );
    let r = i64x4::new(
        2872703216671706529,
        2064775833905037987,
        -5582088942171093269,
        -433018640497265418,
    );

    assert_eq!(r, transmute(lasx_xvmin_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmin_h() {
    let a = i16x16::new(
        -11212, 17053, 31831, -17088, -26082, -20339, -29027, -7113, -12378, 23981, -6343,
        -15884, -7455, -31741, -26691, 26033,
    );
    let b = i16x16::new(
        -3990, -653, 31824, -8429, -13156, 20074, -32658, 26465, -31268, -28012, 12849, 11972,
        -8106, 16341, 14932, -6230,
    );
    let r = i64x4::new(
        -4809707714740235212,
        -2001990296446068194,
        -4470694295613700644,
        -1753422264687927210,
    );

    assert_eq!(r, transmute(lasx_xvmin_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmin_w() {
    let a = i32x8::new(
        545076841,
        427733287,
        -1694168270,
        454215425,
        1619909203,
        1120598019,
        1819961244,
        -165320673,
    );
    let b = i32x8::new(
        440778392, -880154888, 659189867, -948070867, 303440078, 2084920396, -670807717,
        1250241,
    );
    let r = i64x4::new(
        -3780236458933764456,
        -4071933365454566606,
        4812931843870826702,
        -710046880263550629,
    );

    assert_eq!(r, transmute(lasx_xvmin_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmin_d() {
    let a = i64x4::new(
        2741334847700576739,
        -5405962583790843561,
        8459180020282222757,
        -1572925480949669194,
    );
    let b = i64x4::new(
        -5261141090878992044,
        -1222006182046777526,
        4309148539181077305,
        -3792381296290037631,
    );
    let r = i64x4::new(
        -5261141090878992044,
        -5405962583790843561,
        4309148539181077305,
        -3792381296290037631,
    );

    assert_eq!(r, transmute(lasx_xvmin_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmini_b() {
    let a = i8x32::new(
        -85, 86, -102, -46, -93, 29, -46, 15, 36, -49, 80, -47, -57, 0, 17, 89, 60, 93, 100,
        -34, 49, -3, -48, 22, -95, 29, -77, -48, 44, -92, -27, 74,
    );
    let r = i64x4::new(
        -1093547173093904213,
        -1085102769184911376,
        -1094109792127880976,
        -1088282380739546975,
    );

    assert_eq!(r, transmute(lasx_xvmini_b::<-16>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmini_h() {
    let a = i16x16::new(
        29579, 25294, -26291, 17601, 19548, -1571, -3670, -17609, 15721, 11767, 5051, -4718,
        14977, -104, -21933, 11733,
    );
    let r = i64x4::new(
        2420355805741064,
        -4956227148259196920,
        -1327998905760612344,
        2439077560844296,
    );

    assert_eq!(r, transmute(lasx_xvmini_h::<8>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmini_w() {
    let a = i32x8::new(
        938211063,
        1582718046,
        -710671495,
        -1169124073,
        71125607,
        1365032606,
        -1290216030,
        -736436725,
    );
    let r = i64x4::new(
        -64424509456,
        -5021349654917020807,
        -64424509456,
        -3162971646443594334,
    );

    assert_eq!(r, transmute(lasx_xvmini_w::<-16>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmini_d() {
    let a = i64x4::new(
        6621191429364538735,
        8224746792719035443,
        4688148425230961784,
        823273303261270164,
    );
    let r = i64x4::new(-8, -8, -8, -8);

    assert_eq!(r, transmute(lasx_xvmini_d::<-8>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmin_bu() {
    let a = u8x32::new(
        21, 215, 240, 12, 207, 254, 97, 176, 94, 73, 182, 18, 231, 216, 171, 39, 221, 31, 171,
        24, 170, 126, 78, 115, 189, 104, 30, 71, 73, 13, 173, 124,
    );
    let b = u8x32::new(
        156, 34, 210, 157, 237, 204, 11, 176, 14, 3, 254, 148, 151, 143, 59, 162, 24, 238, 63,
        85, 169, 120, 197, 108, 204, 8, 244, 238, 23, 109, 248, 6,
    );
    let r = i64x4::new(
        -5761286108645023211,
        2827011070121870094,
        7804307871931244312,
        481055128827070653,
    );

    assert_eq!(r, transmute(lasx_xvmin_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmin_hu() {
    let a = u16x16::new(
        38440, 49714, 29557, 49236, 1896, 30340, 23067, 13106, 50372, 7988, 45184, 3030, 64318,
        11696, 24753, 38944,
    );
    let b = u16x16::new(
        37782, 2130, 14692, 21829, 22760, 43371, 63045, 45289, 2584, 36405, 12186, 43636, 1930,
        62345, 57746, 16665,
    );
    let r = i64x4::new(
        6144380368416052118,
        3689110118768838504,
        852921518428260888,
        4690886800975071114,
    );

    assert_eq!(r, transmute(lasx_xvmin_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmin_wu() {
    let a = u32x8::new(
        2388959959, 3753576755, 2396056833, 1264941814, 1407811024, 4062547104, 3162258102,
        2894799861,
    );
    let b = u32x8::new(
        1131111124, 1117231814, 2238242135, 3549614188, 791311618, 4010634425, 445826884,
        195885173,
    );
    let r = i64x4::new(
        4798474104311866068,
        5432883724711157079,
        -1221200381331475198,
        841320412252129092,
    );

    assert_eq!(r, transmute(lasx_xvmin_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmin_du() {
    let a = u64x4::new(
        16262575865555500950,
        9397610354038464998,
        11047831233023881635,
        168959420679376173,
    );
    let b = u64x4::new(
        5191113397333195233,
        15218861976244884079,
        15362510705177390571,
        3583188655927147541,
    );
    let r = i64x4::new(
        5191113397333195233,
        -9049133719671086618,
        -7398912840685669981,
        168959420679376173,
    );

    assert_eq!(r, transmute(lasx_xvmin_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmini_bu() {
    let a = u8x32::new(
        89, 194, 153, 118, 89, 237, 7, 106, 114, 216, 237, 232, 42, 35, 243, 48, 137, 126, 222,
        196, 191, 34, 53, 34, 63, 196, 193, 56, 2, 174, 6, 34,
    );
    let r = i64x4::new(
        1803437771371125017,
        1808504320951916825,
        1808504320951916825,
        1803156197610166553,
    );

    assert_eq!(r, transmute(lasx_xvmini_bu::<25>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmini_hu() {
    let a = u16x16::new(
        22785, 53436, 15467, 7600, 19970, 32791, 46922, 27359, 3030, 22997, 38845, 6828, 50455,
        53714, 5069, 34493,
    );
    let r = i64x4::new(
        7881419608817692,
        7881419608817692,
        7881419608817692,
        7881419608817692,
    );

    assert_eq!(r, transmute(lasx_xvmini_hu::<28>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmini_wu() {
    let a = u32x8::new(
        2549040097, 380059779, 106274074, 1242619380, 2422816304, 2036217770, 2017469655,
        192110697,
    );
    let r = i64x4::new(94489280534, 94489280534, 94489280534, 94489280534);

    assert_eq!(r, transmute(lasx_xvmini_wu::<22>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmini_du() {
    let a = u64x4::new(
        2554982158549964334,
        5946824623239713063,
        1554570220268300262,
        16460909687025642884,
    );
    let r = i64x4::new(18, 18, 18, 18);

    assert_eq!(r, transmute(lasx_xvmini_du::<18>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvseq_b() {
    let a = i8x32::new(
        -76, -8, 108, 108, 76, 13, -20, -73, -55, 105, 67, -14, 50, 11, -128, 38, -48, 61, -45,
        0, -31, 68, 108, 17, 86, 59, -124, 71, 118, -60, -119, 53,
    );
    let b = i8x32::new(
        67, 97, 92, 3, -94, -47, 103, 58, 78, 108, 121, -13, -27, -20, -58, -75, -64, 121, 8,
        -31, 56, -8, -43, 119, 10, -100, 50, 122, 34, 124, -65, -92,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvseq_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvseq_h() {
    let a = i16x16::new(
        5587, -19681, -31618, -9619, 10724, 19984, 15759, -19212, -10822, 2437, -7916, -32319,
        8472, 25354, -32596, 17629,
    );
    let b = i16x16::new(
        -14248, 23765, 17541, -22426, -2225, 29478, -18012, -13943, 12940, 20394, 19156, -4063,
        -17913, -12088, 8465, -31204,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvseq_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvseq_w() {
    let a = i32x8::new(
        884869290,
        -2032301802,
        1693636022,
        1594721776,
        2082937065,
        -1159093260,
        -1590139557,
        -1882875192,
    );
    let b = i32x8::new(
        186525406,
        -1399001207,
        -1514443895,
        -1051577172,
        1585652521,
        90050345,
        -1674322849,
        2124996559,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvseq_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvseq_d() {
    let a = i64x4::new(
        2669611874067870445,
        1365590924683817055,
        2596664035622609827,
        -5919289436914592027,
    );
    let b = i64x4::new(
        -7435987568868960430,
        -3618747286388594676,
        1852961913881539893,
        158448424073614869,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvseq_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvseqi_b() {
    let a = i8x32::new(
        8, -28, 17, -71, 11, 26, -79, 95, 102, 106, -100, -83, 116, -105, -72, 60, -64, -39,
        -65, -93, -52, 80, 126, 38, 46, 91, -15, 42, -119, -109, 10, 70,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvseqi_b::<-14>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvseqi_h() {
    let a = i16x16::new(
        31558, 20053, 8868, 28957, 9939, -14167, 15718, -32625, 24920, 19118, 27698, -19776,
        -15714, 14099, 21403, 13371,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvseqi_h::<-8>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvseqi_w() {
    let a = i32x8::new(
        1596885720,
        1682548012,
        -1583429372,
        1961831515,
        -1312514367,
        263282180,
        -1647205143,
        409452108,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvseqi_w::<-11>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvseqi_d() {
    let a = i64x4::new(
        4860385404364618706,
        -866096761684413508,
        -6886759413716464738,
        -1240694713477982808,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvseqi_d::<-2>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslt_b() {
    let a = i8x32::new(
        29, -4, -38, -40, -57, -127, 6, 23, -51, 12, 91, -49, 33, -64, 42, -82, 110, 44, -44,
        -115, 78, -111, -13, -67, 97, -30, -44, 35, 108, 49, -20, -60,
    );
    let b = i8x32::new(
        120, -26, -121, 12, 72, 65, -5, 75, 16, -1, 116, 18, -94, -26, -104, -66, -38, 101,
        -92, 71, -74, 2, 17, -84, 102, 49, -4, -87, 30, -83, -9, -81,
    );
    let r = i64x4::new(
        -71776119077994241,
        -71777214277943041,
        72056498804555520,
        71776119077994495,
    );

    assert_eq!(r, transmute(lasx_xvslt_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslt_h() {
    let a = i16x16::new(
        -26246, 12525, 27206, -1022, 22747, 18600, -9895, -30775, -29586, 24084, -27504, -8187,
        -18487, 5560, 18096, -17473,
    );
    let b = i16x16::new(
        -25007, 1947, 11331, 32443, 1338, 4043, 6432, 22428, -5023, -29819, -32277, 19148,
        -4421, 17327, -30689, 4545,
    );
    let r = i64x4::new(
        -281474976645121,
        -4294967296,
        -281474976645121,
        -281470681743361,
    );

    assert_eq!(r, transmute(lasx_xvslt_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslt_w() {
    let a = i32x8::new(
        -343022897,
        2023876173,
        564434564,
        1237034632,
        563192717,
        -1067626766,
        2022145749,
        1215921380,
    );
    let b = i32x8::new(
        -319278722,
        -804141589,
        -453029596,
        -1367666903,
        1987558200,
        1387908488,
        705912447,
        -1635535899,
    );
    let r = i64x4::new(4294967295, 0, -1, 0);

    assert_eq!(r, transmute(lasx_xvslt_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslt_d() {
    let a = i64x4::new(
        8053537017603706522,
        8148317798642968933,
        661692989904488737,
        5141151145278580641,
    );
    let b = i64x4::new(
        6944929519578764358,
        -3223671261003932077,
        8970791908210514994,
        -3152991651421490245,
    );
    let r = i64x4::new(0, 0, -1, 0);

    assert_eq!(r, transmute(lasx_xvslt_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslti_b() {
    let a = i8x32::new(
        -60, -44, 123, -31, 39, 115, -8, -17, 10, -6, 68, 82, -123, 86, -95, -108, -78, 45, 88,
        -6, -82, 69, 96, 13, 79, 14, 43, -72, -35, 27, -30, 54,
    );
    let r = i64x4::new(
        -72057589759672321,
        -280379760050176,
        1095216660735,
        71777218556067840,
    );

    assert_eq!(r, transmute(lasx_xvslti_b::<-16>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslti_h() {
    let a = i16x16::new(
        -5839, -18013, 17630, 18447, -5550, -28050, -30597, -14016, -985, -1930, 10497, -28472,
        -15481, 29582, 19157, 5547,
    );
    let r = i64x4::new(4294967295, -1, -281470681743361, 65535);

    assert_eq!(r, transmute(lasx_xvslti_h::<-4>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslti_w() {
    let a = i32x8::new(
        -1407512371,
        -898959054,
        572699307,
        1642426185,
        797353241,
        -259466597,
        -1199389426,
        -1398642331,
    );
    let r = i64x4::new(-1, 0, -4294967296, -1);

    assert_eq!(r, transmute(lasx_xvslti_w::<-4>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslti_d() {
    let a = i64x4::new(
        -2819395691046139625,
        5088541563771000132,
        8992157267117868445,
        3707348005090466869,
    );
    let r = i64x4::new(-1, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvslti_d::<1>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslt_bu() {
    let a = u8x32::new(
        25, 12, 175, 147, 216, 93, 84, 21, 98, 182, 199, 128, 107, 68, 249, 142, 59, 204, 118,
        136, 201, 137, 11, 155, 238, 201, 130, 187, 247, 151, 109, 109,
    );
    let b = u8x32::new(
        231, 122, 213, 181, 40, 150, 168, 103, 114, 67, 58, 96, 9, 131, 109, 87, 228, 98, 233,
        122, 32, 208, 212, 193, 69, 197, 199, 67, 125, 145, 103, 17,
    );
    let r = i64x4::new(-1095216660481, 280375465083135, -1099494915841, 16711680);

    assert_eq!(r, transmute(lasx_xvslt_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslt_hu() {
    let a = u16x16::new(
        52525, 2955, 54772, 12603, 44380, 34508, 12576, 61085, 25504, 9162, 5951, 6485, 30570,
        47057, 5871, 54003,
    );
    let b = u16x16::new(
        40432, 50345, 37115, 20747, 38363, 42964, 2046, 26895, 7013, 23222, 19013, 43373,
        50793, 25948, 61295, 35633,
    );
    let r = i64x4::new(-281470681808896, 4294901760, -65536, 281470681808895);

    assert_eq!(r, transmute(lasx_xvslt_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslt_wu() {
    let a = u32x8::new(
        645248129, 159156202, 442053255, 3539240300, 2212555000, 3589590552, 594555403,
        303909752,
    );
    let b = u32x8::new(
        3201000514, 1412178107, 2697992684, 4141300489, 840057459, 3810448458, 959312926,
        2834332590,
    );
    let r = i64x4::new(-1, -1, -4294967296, -1);

    assert_eq!(r, transmute(lasx_xvslt_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslt_du() {
    let a = u64x4::new(
        9001861276662418785,
        11243806946003621417,
        16522311710011399892,
        3265452243993188662,
    );
    let b = u64x4::new(
        12075582354920739274,
        16153578604538879596,
        2722606569672017936,
        5142428655769651710,
    );
    let r = i64x4::new(-1, -1, 0, -1);

    assert_eq!(r, transmute(lasx_xvslt_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslti_bu() {
    let a = u8x32::new(
        68, 117, 2, 67, 233, 205, 12, 99, 127, 21, 171, 71, 18, 146, 167, 76, 141, 21, 234,
        150, 135, 213, 231, 122, 22, 117, 124, 46, 149, 74, 11, 213,
    );
    let r = i64x4::new(16711680, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvslti_bu::<7>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslti_hu() {
    let a = u16x16::new(
        45362, 8378, 15038, 64046, 51883, 25813, 52028, 8730, 1255, 3100, 9043, 37803, 61269,
        5418, 42755, 28604,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvslti_hu::<13>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslti_wu() {
    let a = u32x8::new(
        1740233903, 2267221026, 574370304, 3294215750, 3920854673, 2171367380, 3811836140,
        671324390,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvslti_wu::<8>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslti_du() {
    let a = u64x4::new(
        7794944984440982613,
        6781669147121119045,
        9839484777866727672,
        2217716842113203908,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvslti_du::<2>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsle_b() {
    let a = i8x32::new(
        -20, -44, 90, -101, -69, -3, -5, 99, -59, -13, 35, 125, 64, 21, 66, -2, 57, 4, 60, -35,
        57, 37, -74, 54, -55, -125, -28, 64, -60, -10, 111, 91,
    );
    let b = i8x32::new(
        -44, 127, 36, 48, 36, 79, 56, 54, -123, 29, -105, -117, -46, -9, -30, 97, 3, -5, -10,
        118, -64, -118, -31, -42, 120, -84, -77, 40, 69, -80, 104, 61,
    );
    let r = i64x4::new(
        72057594021216000,
        -72057594037862656,
        71776123339407360,
        1095216726015,
    );

    assert_eq!(r, transmute(lasx_xvsle_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsle_h() {
    let a = i16x16::new(
        -22122, -10270, -26549, -14589, 15764, 15351, -8429, 14898, -20819, -8483, -1055,
        -5229, -21058, -26881, 1568, -1544,
    );
    let b = i16x16::new(
        27196, -6538, 20190, -14481, 4568, 31469, -13818, -16230, -26411, 20205, -4192, -29119,
        11920, 25504, -19817, -370,
    );
    let r = i64x4::new(-1, 4294901760, 4294901760, -281470681743361);

    assert_eq!(r, transmute(lasx_xvsle_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsle_w() {
    let a = i32x8::new(
        -44465502,
        -1482288791,
        1430386258,
        -837657585,
        -294092640,
        -1581080100,
        -558275350,
        -217520013,
    );
    let b = i32x8::new(
        -251270550,
        1931207536,
        -1348623461,
        -961792969,
        845442346,
        1529991774,
        -2079565201,
        2051352953,
    );
    let r = i64x4::new(-4294967296, 0, -1, -4294967296);

    assert_eq!(r, transmute(lasx_xvsle_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsle_d() {
    let a = i64x4::new(
        -3700065874729391328,
        3324167660406962127,
        -431069737981318264,
        4685397384184188250,
    );
    let b = i64x4::new(
        3966484960661616600,
        2732585182508661538,
        -1886887956095472452,
        3407078622354590260,
    );
    let r = i64x4::new(-1, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvsle_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslei_b() {
    let a = i8x32::new(
        -34, 34, -112, 113, 77, 45, 109, -125, 31, -88, -1, -53, 72, 39, 39, -99, -47, -45, 4,
        17, -100, -96, 41, -62, -56, -88, 37, 8, 68, -53, 52, 61,
    );
    let r = i64x4::new(
        -72057594021216001,
        -72057589759672576,
        -71776123356119041,
        280375465148415,
    );

    assert_eq!(r, transmute(lasx_xvslei_b::<-14>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslei_h() {
    let a = i16x16::new(
        11585, -30889, -24807, -28938, -11929, -7, -8205, -24769, -12225, -7956, -26751, 11963,
        30916, -25385, -28797, -6515,
    );
    let r = i64x4::new(-65536, -4294901761, 281474976710655, -65536);

    assert_eq!(r, transmute(lasx_xvslei_h::<-15>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslei_w() {
    let a = i32x8::new(
        98083171, -839282918, 950280284, 1423312628, -74628250, -400513137, 1893412843,
        1627152567,
    );
    let r = i64x4::new(-4294967296, 0, -1, 0);

    assert_eq!(r, transmute(lasx_xvslei_w::<-3>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslei_d() {
    let a = i64x4::new(
        -4859364474358523407,
        5515090293678524269,
        -8825168226110066470,
        -1006722941532041773,
    );
    let r = i64x4::new(-1, 0, -1, -1);

    assert_eq!(r, transmute(lasx_xvslei_d::<6>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsle_bu() {
    let a = u8x32::new(
        158, 49, 59, 206, 238, 37, 129, 237, 128, 170, 238, 175, 10, 110, 43, 210, 223, 144,
        115, 87, 183, 177, 226, 216, 74, 40, 36, 142, 76, 48, 213, 148,
    );
    let b = u8x32::new(
        10, 235, 145, 113, 48, 119, 124, 22, 154, 225, 240, 6, 37, 126, 38, 233, 129, 30, 90,
        103, 109, 14, 51, 10, 128, 242, 103, 199, 215, 228, 164, 115,
    );
    let r = i64x4::new(
        280375481859840,
        -71776123339407361,
        4278190080,
        281474976710655,
    );

    assert_eq!(r, transmute(lasx_xvsle_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsle_hu() {
    let a = u16x16::new(
        61722, 23067, 57576, 43934, 56523, 22563, 45126, 9681, 5860, 62938, 40464, 22653,
        53470, 26636, 64060, 22853,
    );
    let b = u16x16::new(
        61426, 33539, 62959, 2501, 21021, 20564, 64705, 12707, 6875, 56968, 45402, 15505,
        50807, 25207, 42588, 21407,
    );
    let r = i64x4::new(281474976645120, -4294967296, 281470681808895, 0);

    assert_eq!(r, transmute(lasx_xvsle_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsle_wu() {
    let a = u32x8::new(
        3492865309, 1162904456, 1212423957, 2856547492, 4084218464, 1751333879, 3162347846,
        990759844,
    );
    let b = u32x8::new(
        525215252, 3081836083, 3319970808, 3111004663, 2712599486, 1206390980, 1598064821,
        440769207,
    );
    let r = i64x4::new(-4294967296, -1, 0, 0);

    assert_eq!(r, transmute(lasx_xvsle_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsle_du() {
    let a = u64x4::new(
        2621502387249005267,
        2893454517032185854,
        7681654086665024795,
        5020934994941644473,
    );
    let b = u64x4::new(
        2069393685367888462,
        16283420533139074356,
        5426371663235070936,
        6959847307032735963,
    );
    let r = i64x4::new(0, -1, 0, -1);

    assert_eq!(r, transmute(lasx_xvsle_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslei_bu() {
    let a = u8x32::new(
        31, 26, 96, 32, 50, 17, 14, 211, 51, 145, 198, 89, 217, 16, 184, 197, 220, 224, 23,
        208, 243, 188, 17, 240, 237, 207, 250, 185, 88, 127, 104, 96,
    );
    let r = i64x4::new(72056494526365440, 280375465082880, 71776119077928960, 0);

    assert_eq!(r, transmute(lasx_xvslei_bu::<29>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslei_hu() {
    let a = u16x16::new(
        43587, 14195, 3048, 63749, 62756, 59029, 53861, 44436, 63820, 31431, 3098, 39702,
        37252, 60430, 367, 9201,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvslei_hu::<30>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslei_wu() {
    let a = u32x8::new(
        2210674294, 4169142079, 3945251466, 1311516675, 2977874622, 3173129893, 3425645958,
        2905333026,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvslei_wu::<31>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvslei_du() {
    let a = u64x4::new(
        16014799523010103844,
        8709196257349731516,
        16077124464953821716,
        14402865276083654462,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvslei_du::<5>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsat_b() {
    let a = i8x32::new(
        72, 84, 50, -112, -54, -10, 114, 37, -37, -9, 56, -1, -39, -51, 16, 88, -107, -47, -66,
        -81, 83, 50, -69, 103, -46, 17, 121, 43, 8, -121, -113, 27,
    );
    let r = i64x4::new(
        2698490476611392584,
        6345798211138549723,
        7474623341563662741,
        1985954429852520914,
    );

    assert_eq!(r, transmute(lasx_xvsat_b::<7>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsat_h() {
    let a = i16x16::new(
        -22224, 6834, -23483, -28336, -15236, 8349, -30647, -16818, -27867, 17449, -7303,
        -20496, -3398, 17074, -14188, 16934,
    );
    let r = i64x4::new(
        -1152657621547749376,
        -1152657621547749376,
        -1152657621547749376,
        1152903912689234618,
    );

    assert_eq!(r, transmute(lasx_xvsat_h::<12>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsat_w() {
    let a = i32x8::new(
        970917085,
        -759322255,
        -332118787,
        127481445,
        -925804081,
        -2116293410,
        240264455,
        -1921693726,
    );
    let r = i64x4::new(-34359738361, 34359738360, -30064771080, -34359738361);

    assert_eq!(r, transmute(lasx_xvsat_w::<3>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsat_d() {
    let a = i64x4::new(
        -7987623316798584571,
        -7247559336295709650,
        -5048248303955768218,
        6102033771404793023,
    );
    let r = i64x4::new(
        -7987623316798584571,
        -7247559336295709650,
        -5048248303955768218,
        6102033771404793023,
    );

    assert_eq!(r, transmute(lasx_xvsat_d::<63>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsat_bu() {
    let a = u8x32::new(
        25, 84, 86, 237, 15, 25, 247, 37, 97, 77, 124, 211, 71, 31, 112, 78, 71, 3, 68, 103,
        56, 251, 164, 254, 198, 72, 14, 7, 154, 42, 226, 35,
    );
    let r = i64x4::new(
        2683891456212418329,
        4557395704426741567,
        4557430858734043967,
        2539795165049929535,
    );

    assert_eq!(r, transmute(lasx_xvsat_bu::<5>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsat_hu() {
    let a = u16x16::new(
        50818, 7191, 19885, 24886, 23947, 902, 63438, 16327, 21304, 41986, 6658, 26825, 35878,
        54181, 37442, 24336,
    );
    let r = i64x4::new(
        1970354902204423,
        1970354902204423,
        1970354902204423,
        1970354902204423,
    );

    assert_eq!(r, transmute(lasx_xvsat_hu::<2>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsat_wu() {
    let a = u32x8::new(
        2643833778, 2163840459, 3648859312, 2300494776, 1210790323, 4241633778, 1830707970,
        1058612721,
    );
    let r = i64x4::new(270582939711, 270582939711, 270582939711, 270582939711);

    assert_eq!(r, transmute(lasx_xvsat_wu::<5>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsat_du() {
    let a = u64x4::new(
        8558995131692178872,
        17439570087619166841,
        9621706324971219491,
        6096695286958361953,
    );
    let r = i64x4::new(8796093022207, 8796093022207, 8796093022207, 8796093022207);

    assert_eq!(r, transmute(lasx_xvsat_du::<42>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadda_b() {
    let a = i8x32::new(
        25, 59, -110, -62, -36, -22, 27, -104, 32, 127, 92, 19, -127, -111, 2, 41, 37, 108,
        -111, 108, -101, 89, -53, -16, 87, -111, 66, 68, 95, -47, 125, 105,
    );
    let b = i8x32::new(
        -121, 110, -17, 74, 16, -33, -80, 48, -69, 114, 9, -63, -38, 6, -82, -112, -105, 5, 61,
        119, 9, -72, 69, -21, 109, -14, -103, 72, -126, 41, -34, 60,
    );
    let r = i64x4::new(
        -7463811258668570222,
        -7398158934950416027,
        2700648424200237454,
        -6512388827583513148,
    );

    assert_eq!(r, transmute(lasx_xvadda_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadda_h() {
    let a = i16x16::new(
        -7007, 10506, -11262, 28686, 22120, 22431, 1054, -2239, -28418, 24459, -8927, -15512,
        9064, 22935, 26563, 2466,
    );
    let b = i16x16::new(
        -1992, -19568, 12795, -27246, 14193, 19953, -3803, -27680, 2139, 30064, -7379, -12284,
        5720, -19123, 21658, -12768,
    );
    let r = i64x4::new(
        -2703182350329961689,
        8421470691639987673,
        7823948489959372637,
        4288196905584441792,
    );

    assert_eq!(r, transmute(lasx_xvadda_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadda_w() {
    let a = i32x8::new(
        1265529071,
        -1075977129,
        -583802219,
        -13912299,
        -172400466,
        -972042514,
        -260823873,
        -1620748450,
    );
    let b = i32x8::new(
        489335551, 1611173717, -476611840, -751628752, -192801793, 1467389657, -374333972,
        35803655,
    );
    let r = i64x4::new(
        -6905519068965954578,
        3287973778850882155,
        -7969462678089069741,
        7114837115730115925,
    );

    assert_eq!(r, transmute(lasx_xvadda_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadda_d() {
    let a = i64x4::new(
        7814609303075513348,
        -7772522798724755627,
        -1147865382247844592,
        -7562711493144146696,
    );
    let b = i64x4::new(
        3766721551761496817,
        8105329332137326997,
        -9194637465570314907,
        7351062589763608413,
    );
    let r = i64x4::new(
        -6865413218872541451,
        -2568891942847468992,
        -8104241225891392117,
        -3532969990801796507,
    );

    assert_eq!(r, transmute(lasx_xvadda_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsadd_b() {
    let a = i8x32::new(
        95, 7, -14, -94, -86, -102, -123, 76, -40, 78, -16, 71, -122, 75, 8, -59, 43, 71, -16,
        -38, -67, -40, 97, 101, -45, -28, -58, -99, 48, -111, -128, 118,
    );
    let b = i8x32::new(
        -86, 59, 75, 107, -90, -1, 114, 4, -60, 20, -8, -67, 58, 47, 100, 122, -75, -106, -118,
        -95, -44, 22, 76, 54, 90, 108, 113, 21, -92, -53, 125, -70,
    );
    let r = i64x4::new(
        5834300617538748937,
        4570162687008858780,
        9187324073552698848,
        3530119333939728429,
    );

    assert_eq!(r, transmute(lasx_xvsadd_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsadd_h() {
    let a = i16x16::new(
        21287, 1075, 1515, 13634, 27666, -29218, 10797, -29531, -16877, -31125, 29749, 23913,
        -6583, -15233, 14925, 1745,
    );
    let b = i16x16::new(
        9900, -26262, -15712, 25834, 18751, -9376, 8538, -1589, -21802, 18049, 18837, -21370,
        -11718, 2110, -13829, -19996,
    );
    let r = i64x4::new(
        9223311063848417747,
        -8759418229895430145,
        715931602406637568,
        -5137195089227040637,
    );

    assert_eq!(r, transmute(lasx_xvsadd_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsadd_w() {
    let a = i32x8::new(
        192209429,
        -2001895259,
        1526351324,
        940020268,
        -971929246,
        -265649149,
        126711930,
        1060927451,
    );
    let b = i32x8::new(
        -1362410074,
        17289452,
        1453224925,
        -157303455,
        -1002635563,
        -153598928,
        1744530306,
        450932350,
    );
    let r = i64x4::new(
        -8523817033391921221,
        3361743116011831295,
        -1800656777305487305,
        6493388403303310332,
    );

    assert_eq!(r, transmute(lasx_xvsadd_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsadd_d() {
    let a = i64x4::new(
        7784983044177669725,
        8101097656675707195,
        5701949277844824642,
        -9115087610184891150,
    );
    let b = i64x4::new(
        -7435730805386005247,
        -2620412598612541303,
        -7972576523543653821,
        7444842305858583495,
    );
    let r = i64x4::new(
        349252238791664478,
        5480685058063165892,
        -2270627245698829179,
        -1670245304326307655,
    );

    assert_eq!(r, transmute(lasx_xvsadd_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsadd_bu() {
    let a = u8x32::new(
        25, 97, 235, 222, 176, 210, 161, 94, 48, 209, 231, 48, 45, 90, 187, 6, 29, 48, 193,
        158, 240, 147, 240, 248, 228, 195, 131, 114, 9, 239, 172, 211,
    );
    let b = u8x32::new(
        156, 230, 197, 50, 226, 217, 198, 2, 133, 7, 31, 251, 185, 83, 103, 173, 4, 107, 100,
        3, 81, 209, 161, 88, 169, 211, 90, 7, 158, 153, 112, 221,
    );
    let r = i64x4::new(
        6989586621679009717,
        -5476467414210193227,
        -1577084127,
        -380207497217,
    );

    assert_eq!(r, transmute(lasx_xvsadd_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsadd_hu() {
    let a = u16x16::new(
        18927, 31835, 27291, 15842, 30595, 45554, 31277, 2570, 50726, 18451, 33555, 31286,
        37571, 1090, 50630, 36004,
    );
    let b = u16x16::new(
        51573, 3134, 27346, 11433, 45605, 6834, 26138, 61459, 26540, 3859, 63747, 9497, 47455,
        22235, 55919, 64188,
    );
    let r = i64x4::new(
        7677464656203087871,
        -423936190922293249,
        -6967068626374950913,
        -2766274561,
    );

    assert_eq!(r, transmute(lasx_xvsadd_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsadd_wu() {
    let a = u32x8::new(
        2641259570, 2413939116, 2244295016, 1265788506, 4032439236, 2078944785, 2529147076,
        1095977188,
    );
    let b = u32x8::new(
        1074491620, 785068578, 441575896, 2827260071, 654541549, 2711155200, 2667914280,
        1025335263,
    );
    let r = i64x4::new(
        -4707110644611425002,
        -867234291869342912,
        -1,
        9110967605937569791,
    );

    assert_eq!(r, transmute(lasx_xvsadd_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsadd_du() {
    let a = u64x4::new(
        14430626347567901108,
        8966103699466030320,
        15088600594909856287,
        4617508821066205697,
    );
    let b = u64x4::new(
        9949819222347987503,
        1797352673890553460,
        93407820607851767,
        16329185982288463052,
    );
    let r = i64x4::new(-1, -7683287700352967836, -3264735658191843562, -1);

    assert_eq!(r, transmute(lasx_xvsadd_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavg_b() {
    let a = i8x32::new(
        1, -7, 51, 121, -46, 91, 117, 56, -128, -103, 77, -124, 47, -81, 71, -97, 9, -22, -45,
        81, 64, -36, 18, -57, 53, -23, -56, -113, 55, -76, -98, -89,
    );
    let b = i8x32::new(
        116, 40, 94, 32, 108, -83, -72, 62, 118, 3, 75, 51, -64, 117, 106, -76, 98, 102, -74,
        83, -104, -25, 103, 87, -99, -120, 40, -83, -51, 73, 88, 19,
    );
    let r = i64x4::new(
        4257595030195671098,
        -6244220027603726597,
        1098000814288676917,
        -2451086284962613015,
    );

    assert_eq!(r, transmute(lasx_xvavg_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavg_h() {
    let a = i16x16::new(
        22420, 2514, -1496, 12197, 18773, 25141, -11922, 14759, 28272, 9957, -8329, -18095,
        14119, 4453, 29447, -17743,
    );
    let b = i16x16::new(
        -23665, 8821, -12487, 30493, -29228, -14701, 16266, 5372, 21222, 5396, -495, -4093,
        8979, 15419, 24369, -25475,
    );
    let r = i64x4::new(
        6008334822825786769,
        2833054969603877780,
        -3122420865543937877,
        -6082277202109387491,
    );

    assert_eq!(r, transmute(lasx_xvavg_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavg_w() {
    let a = i32x8::new(
        264220248,
        1806183666,
        -744175589,
        1149257464,
        649257353,
        1343192175,
        -1646288099,
        1777956369,
    );
    let b = i32x8::new(
        -490550100,
        1650015069,
        602037366,
        -115507354,
        -1351815309,
        -919786860,
        1796894888,
        -1823377644,
    );
    let r = i64x4::new(
        7422130269685104002,
        2219961461567099464,
        909255992234993790,
        -97541447405991454,
    );

    assert_eq!(r, transmute(lasx_xvavg_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavg_d() {
    let a = i64x4::new(
        -5353831456328489109,
        1116026769917166857,
        -6482325223661420741,
        4644114914180465662,
    );
    let b = i64x4::new(
        -8278784043739101899,
        8898944017823987194,
        162737312931734425,
        -3156875890654220898,
    );
    let r = i64x4::new(
        -6816307750033795504,
        5007485393870577025,
        -3159793955364843158,
        743619511763122382,
    );

    assert_eq!(r, transmute(lasx_xvavg_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavg_bu() {
    let a = u8x32::new(
        222, 174, 254, 188, 116, 111, 1, 67, 236, 108, 184, 99, 34, 41, 62, 74, 228, 117, 143,
        190, 202, 68, 177, 5, 102, 26, 144, 229, 66, 185, 137, 73,
    );
    let b = u8x32::new(
        9, 86, 55, 74, 146, 206, 99, 36, 206, 46, 174, 95, 25, 21, 140, 91, 99, 120, 100, 243,
        231, 197, 230, 158, 188, 38, 162, 58, 130, 77, 72, 87,
    );
    let r = i64x4::new(
        3689185332455703155,
        5937185894811520477,
        5893950604224067235,
        5794025379951354001,
    );

    assert_eq!(r, transmute(lasx_xvavg_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavg_hu() {
    let a = u16x16::new(
        59347, 14794, 56762, 36383, 41235, 53425, 15726, 15850, 6947, 17893, 10811, 18470,
        35860, 14001, 21530, 58912,
    );
    let b = u16x16::new(
        45476, 48517, 33041, 8160, 7865, 37717, 29068, 45168, 12673, 29576, 21, 26212, 20245,
        43416, 16626, 44166,
    );
    let r = i64x4::new(
        6268922056724171963,
        8587616261834498022,
        6288455717791082066,
        -3939723307751543404,
    );

    assert_eq!(r, transmute(lasx_xvavg_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavg_wu() {
    let a = u32x8::new(
        1600834277, 4196831994, 2108873255, 518030497, 3166298163, 3812054340, 3824732684,
        1900211486,
    );
    let b = u32x8::new(
        1499894424, 568816404, 3212845718, 500610814, 585554707, 2609103780, 7570780, 977655961,
    );
    let r = i64x4::new(
        -8212592065336791362,
        2187515559063158366,
        -4657412007911203421,
        6180173283312674740,
    );

    assert_eq!(r, transmute(lasx_xvavg_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavg_du() {
    let a = u64x4::new(
        16716089796022894912,
        10136836254171396504,
        5055029870739857077,
        1722276628667681589,
    );
    let b = u64x4::new(
        2981839357822260236,
        4395528145348260085,
        9124113278861486873,
        17073319773492299474,
    );
    let r = i64x4::new(
        -8597779496786974042,
        7266182199759828294,
        7089571574800671975,
        -9048945872629561085,
    );

    assert_eq!(r, transmute(lasx_xvavg_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavgr_b() {
    let a = i8x32::new(
        70, 49, 125, -63, -42, -19, 98, -71, -39, -43, 62, -91, -109, -76, -2, 73, -82, -26,
        31, -13, -19, 61, -64, -122, -66, -36, 15, 102, 72, 18, -9, -30,
    );
    let b = i8x32::new(
        -101, 91, 109, 12, 107, -108, -99, 124, -72, -12, -23, -93, 0, -21, -65, 51, -90, -9,
        94, -109, -17, -42, -4, 45, -18, 41, 13, 6, 79, 39, 60, -14,
    );
    let r = i64x4::new(
        1945767390385358577,
        4530569318912812489,
        -2675689108017254486,
        -1577916506278329386,
    );

    assert_eq!(r, transmute(lasx_xvavgr_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavgr_h() {
    let a = i16x16::new(
        -23160, -26916, 22577, 3623, -22521, -16865, 13203, 26275, -20646, 12156, -26885,
        -1419, -20243, 28347, -3617, -21473,
    );
    let b = i16x16::new(
        23255, 16173, -15467, -21396, 14626, -27747, 22216, -25899, 14208, 23641, 23787, 27175,
        -6255, -22851, -20976, 28894,
    );
    let r = i64x4::new(
        -2501171370499178448,
        52993362325598357,
        3625109573325288301,
        1044782302812228671,
    );

    assert_eq!(r, transmute(lasx_xvavgr_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavgr_w() {
    let a = i32x8::new(
        -500594887,
        -775813621,
        -892322315,
        -1910111140,
        573941213,
        1978372579,
        765765621,
        1237953660,
    );
    let b = i32x8::new(
        -541556784,
        538719952,
        -1163583489,
        56482881,
        -978953184,
        -804071754,
        1958602350,
        1082613894,
    );
    let r = i64x4::new(
        -509154771300449403,
        -3980636370258710790,
        2521791825760354559,
        4983380877656540978,
    );

    assert_eq!(r, transmute(lasx_xvavgr_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavgr_d() {
    let a = i64x4::new(
        -560846199430459987,
        -6913595054902211026,
        1018627982636790344,
        -4796205388927403814,
    );
    let b = i64x4::new(
        -1503583177859445318,
        2269985815924150324,
        8892159546918356586,
        5254840197509918769,
    );
    let r = i64x4::new(
        -1032214688644952652,
        -2321804619489030351,
        4955393764777573465,
        229317404291257478,
    );

    assert_eq!(r, transmute(lasx_xvavgr_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavgr_bu() {
    let a = u8x32::new(
        173, 186, 248, 144, 15, 66, 150, 226, 30, 14, 68, 38, 255, 233, 148, 172, 133, 29, 57,
        83, 110, 70, 253, 31, 175, 67, 167, 162, 54, 221, 53, 188,
    );
    let b = u8x32::new(
        73, 42, 164, 127, 251, 107, 243, 43, 224, 179, 219, 9, 103, 205, 153, 157, 108, 89, 40,
        102, 99, 142, 142, 155, 155, 170, 95, 233, 116, 68, 9, 47,
    );
    let r = i64x4::new(
        -8663422077139783045,
        -6514496773710388865,
        6757205291683625849,
        8511681618342279077,
    );

    assert_eq!(r, transmute(lasx_xvavgr_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavgr_hu() {
    let a = u16x16::new(
        748, 52495, 35014, 19986, 51280, 1137, 33343, 41113, 44125, 44938, 39033, 4840, 8926,
        20195, 61480, 38149,
    );
    let b = u16x16::new(
        49450, 21694, 20295, 62811, 50314, 20597, 51590, 51120, 20909, 7005, 34026, 24886,
        1353, 12358, 20971, 58564,
    );
    let r = i64x4::new(
        -6793842733113449973,
        -5465780177655839123,
        4183719475707936517,
        -4835281559523879916,
    );

    assert_eq!(r, transmute(lasx_xvavgr_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavgr_wu() {
    let a = u32x8::new(
        725985028, 2564620547, 4042355808, 1169637821, 2193709333, 848280370, 2882464312,
        222274907,
    );
    let b = u32x8::new(
        3005308642, 568881719, 1868204939, 3839859286, 1155339100, 2594656893, 1645672275,
        936913519,
    );
    let r = i64x4::new(
        6729144879071593203,
        -7688930946620981258,
        7393651477204383289,
        2489338192049926342,
    );

    assert_eq!(r, transmute(lasx_xvavgr_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvavgr_du() {
    let a = u64x4::new(
        2554728288465437854,
        11449711494451353492,
        3273645684131385521,
        10253723919691993285,
    );
    let b = u64x4::new(
        7302091036247388883,
        15155026503610587821,
        2157260177986334855,
        2575722548058380647,
    );
    let r = i64x4::new(
        4928409662356413369,
        -5144375074678580959,
        2715452931058860188,
        6414723233875186966,
    );

    assert_eq!(r, transmute(lasx_xvavgr_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssub_b() {
    let a = i8x32::new(
        73, 33, 105, 6, 76, 22, -108, 53, 0, 81, 98, 121, -77, 54, 85, 86, 22, 5, -91, 107,
        -24, 31, -120, 60, -115, 78, 110, 39, -112, 112, -39, 29,
    );
    let b = i8x32::new(
        -83, -99, 27, 4, -80, 31, 26, -29, -50, 39, -93, 6, 26, 105, -109, -36, 65, -14, -120,
        103, -50, -109, -38, -78, -38, 70, -79, -27, 61, 12, 39, 93,
    );
    let r = i64x4::new(
        5945023633000660863,
        8826999853620865586,
        9200430838479393749,
        -4561472970538678093,
    );

    assert_eq!(r, transmute(lasx_xvssub_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssub_h() {
    let a = i16x16::new(
        30107, 16338, 20726, 3737, -28092, -2792, 11304, -3451, 32157, 18332, 16586, 2662,
        17942, -23482, 23033, -833,
    );
    let b = i16x16::new(
        -212, 2969, -3923, -10268, -14795, -2019, 863, -28427, -5609, 18395, -17614, -2870,
        -1551, 14381, 1242, -29426,
    );
    let r = i64x4::new(
        3942162916357797487,
        7030163866323241999,
        1557260308647608319,
        8048307602867637285,
    );

    assert_eq!(r, transmute(lasx_xvssub_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssub_w() {
    let a = i32x8::new(
        -638701442,
        124032353,
        -1177957330,
        1822772002,
        -624208464,
        -690157477,
        -752614768,
        1017525230,
    );
    let b = i32x8::new(
        932721978,
        -1730383729,
        2006657743,
        -1118024603,
        1361667737,
        -932072815,
        -1709865093,
        -66403119,
    );
    let r = i64x4::new(
        7964656428089998148,
        9223372034707292160,
        1039018467419877143,
        4655436811119524629,
    );

    assert_eq!(r, transmute(lasx_xvssub_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssub_d() {
    let a = i64x4::new(
        8715609043439660533,
        6520891714816295946,
        -9200207215764087611,
        -4552769804861861814,
    );
    let b = i64x4::new(
        8369052152539855925,
        2070139234200116232,
        -8565613288638792421,
        6969198225778950763,
    );
    let r = i64x4::new(
        346556890899804608,
        4450752480616179714,
        -634593927125295190,
        -9223372036854775808,
    );

    assert_eq!(r, transmute(lasx_xvssub_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssub_bu() {
    let a = u8x32::new(
        194, 170, 115, 69, 137, 47, 83, 232, 208, 7, 239, 24, 252, 237, 181, 153, 99, 109, 110,
        137, 12, 246, 132, 6, 201, 93, 177, 189, 98, 6, 85, 252,
    );
    let b = u8x32::new(
        192, 185, 64, 8, 157, 119, 247, 72, 81, 33, 0, 242, 154, 190, 235, 167, 199, 215, 118,
        14, 79, 208, 68, 149, 8, 111, 58, 97, 85, 219, 178, 240,
    );
    let r = i64x4::new(
        -6917529026614329342,
        52097968963711,
        18056182014935040,
        864691185841012929,
    );

    assert_eq!(r, transmute(lasx_xvssub_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssub_hu() {
    let a = u16x16::new(
        32377, 48753, 23359, 60048, 51933, 60261, 16706, 5683, 42654, 19286, 27115, 5230,
        25323, 3004, 59060, 28377,
    );
    let b = u16x16::new(
        20524, 46292, 39370, 44869, 11104, 28817, 18216, 21295, 15477, 23627, 5697, 53043,
        24168, 62463, 15113, 55444,
    );
    let r = i64x4::new(
        4272508671652343373,
        2060754813,
        91989609572905,
        188750927758467,
    );

    assert_eq!(r, transmute(lasx_xvssub_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssub_wu() {
    let a = u32x8::new(
        1657277873, 1330142084, 2851707029, 329302965, 4012116382, 3796717712, 1394210702,
        3853566063,
    );
    let b = u32x8::new(
        3002534878, 3166207065, 1567450925, 39925211, 2740035937, 1015422746, 235666751,
        2928176588,
    );
    let r = i64x4::new(
        0,
        1242867990904189288,
        -6501173152938039235,
        3974517532346153551,
    );

    assert_eq!(r, transmute(lasx_xvssub_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssub_du() {
    let a = u64x4::new(
        15530474406792892207,
        11041265010582297193,
        12958884950634485683,
        10554031950250935627,
    );
    let b = u64x4::new(
        14455090273467103742,
        13018023957546859856,
        4721944463560386324,
        13428322516292168868,
    );
    let r = i64x4::new(1075384133325788465, 0, 8236940487074099359, 0);

    assert_eq!(r, transmute(lasx_xvssub_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvabsd_b() {
    let a = i8x32::new(
        77, 34, -55, -6, -27, 106, -19, 107, 7, -43, -15, 64, 88, -60, 98, 5, 123, -72, -69,
        -120, -106, -29, -62, 112, -78, -24, 105, -79, 74, 24, -122, -33,
    );
    let b = i8x32::new(
        70, -55, 105, 62, 94, -15, 120, -122, -62, 75, -50, -61, -74, -125, 109, 53, -51, -35,
        -29, -26, 66, 19, -98, 51, 50, 111, 106, 64, 24, 86, -114, -90,
    );
    let r = i64x4::new(
        -1906296455511910137,
        3461932904704341573,
        4405699852347385262,
        4109603046844106624,
    );

    assert_eq!(r, transmute(lasx_xvabsd_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvabsd_h() {
    let a = i16x16::new(
        -3523, -20106, 11040, 6484, 22611, -2497, 28408, 18680, 14501, -17999, -17051, 5091,
        17047, -23076, 3361, 4856,
    );
    let b = i16x16::new(
        15765, 31104, 9632, 30835, -6611, 20000, -27189, 15641, 6191, 28248, 28092, 28462,
        -4315, -1294, -14727, 24445,
    );
    let r = i64x4::new(
        6854203208551254872,
        855641242994831910,
        6578545571444236406,
        5513891007581016946,
    );

    assert_eq!(r, transmute(lasx_xvabsd_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvabsd_w() {
    let a = i32x8::new(
        -516201776,
        -1265475612,
        -789611388,
        -170081681,
        903632669,
        -211238418,
        -1863976799,
        639146993,
    );
    let b = i32x8::new(
        1884052123,
        -78957215,
        260861474,
        -2114421033,
        -1460646598,
        -1379633816,
        1900992494,
        -2022565365,
    );
    let r = i64x4::new(
        5096057713617598411,
        8350873930216305054,
        5018220025571183075,
        -7014776540975538355,
    );

    assert_eq!(r, transmute(lasx_xvabsd_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvabsd_d() {
    let a = i64x4::new(
        -391271937360884965,
        -20808483467978826,
        2531375025191050735,
        -2026665653248710281,
    );
    let b = i64x4::new(
        716104320672255601,
        -518451966573772136,
        3032418447389694341,
        -6748971658539956270,
    );
    let r = i64x4::new(
        1107376258033140566,
        497643483105793310,
        501043422198643606,
        4722306005291245989,
    );

    assert_eq!(r, transmute(lasx_xvabsd_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvabsd_bu() {
    let a = u8x32::new(
        167, 63, 182, 73, 179, 226, 126, 48, 51, 89, 114, 98, 233, 151, 164, 141, 121, 82, 125,
        131, 94, 231, 83, 187, 111, 196, 18, 11, 152, 164, 19, 164,
    );
    let b = u8x32::new(
        204, 191, 64, 88, 65, 66, 113, 230, 140, 89, 240, 41, 98, 215, 60, 243, 232, 132, 39,
        170, 30, 165, 206, 56, 230, 91, 235, 13, 185, 191, 68, 138,
    );
    let r = i64x4::new(
        -5328426372363288539,
        7379218938975879257,
        -8972504989300280721,
        1887319547440621943,
    );

    assert_eq!(r, transmute(lasx_xvabsd_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvabsd_hu() {
    let a = u16x16::new(
        3423, 48528, 56740, 39409, 50360, 13926, 57000, 4567, 4452, 31543, 58373, 9298, 48132,
        51688, 31647, 52056,
    );
    let b = u16x16::new(
        4223, 51844, 62479, 1974, 39743, 1068, 23170, 3816, 24418, 43609, 63727, 13263, 6596,
        17773, 11934, 45434,
    );
    let r = i64x4::new(
        -7909703671511514336,
        211533007095998841,
        1116071278703431166,
        1864011964690965056,
    );

    assert_eq!(r, transmute(lasx_xvabsd_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvabsd_wu() {
    let a = u32x8::new(
        596511673, 1656018177, 862222472, 3855869253, 1555502903, 50646434, 688234186,
        2814498786,
    );
    let b = u32x8::new(
        2976814235, 296937998, 3274139740, 128554952, 227946291, 3566260080, 3443244200,
        2459204000,
    );
    let r = i64x4::new(
        5837204923827128546,
        -2438051046589534252,
        -3347298437440673788,
        1525979489064328670,
    );

    assert_eq!(r, transmute(lasx_xvabsd_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvabsd_du() {
    let a = u64x4::new(
        12734602602054551239,
        14766664927105746582,
        15860998294904895250,
        6219187986984895141,
    );
    let b = u64x4::new(
        14337911389010813068,
        18082222857282413983,
        12137634856997955567,
        8346674176989823087,
    );
    let r = i64x4::new(
        1603308786956261829,
        3315557930176667401,
        3723363437906939683,
        2127486190004927946,
    );

    assert_eq!(r, transmute(lasx_xvabsd_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmul_b() {
    let a = i8x32::new(
        79, -96, -64, -1, -115, -89, -42, 81, 83, -94, 126, -51, 60, -90, -52, 65, 113, 30,
        -64, -32, -115, 18, -120, -103, 68, -52, -106, 124, -90, 23, 39, 46,
    );
    let b = i8x32::new(
        -85, 53, -41, 89, -85, -87, -95, 98, 86, 91, 64, 121, -108, 74, 124, 103, 27, -110, 66,
        -68, -29, -83, -3, -62, 124, 30, -91, 77, -28, 116, -27, 64,
    );
    let r = i64x4::new(
        186405908484464837,
        2869070799329859298,
        -979486707244065557,
        -9159357540886189840,
    );

    assert_eq!(r, transmute(lasx_xvmul_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmul_h() {
    let a = i16x16::new(
        -4021, 8043, -7726, -25122, -30015, -30658, -18708, -10900, 3772, -3578, -17492,
        -13851, -17265, 32476, -4087, 27743,
    );
    let b = i16x16::new(
        -2689, -26491, 4625, 17707, 7226, 23738, 2364, -25740, 1919, 17707, 29523, -15101,
        -9498, -8760, 352, -20751,
    );
    let r = i64x4::new(
        6506226959995370549,
        1796983875076656058,
        -7588815217799040188,
        -7534790044979024262,
    );

    assert_eq!(r, transmute(lasx_xvmul_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmul_w() {
    let a = i32x8::new(
        1226983252,
        1810325729,
        -263694346,
        -895831021,
        -666287351,
        1386398263,
        -1628946240,
        -76075817,
    );
    let b = i32x8::new(
        268813984,
        1729713250,
        -1600000134,
        160164970,
        1783576517,
        -2129626845,
        307974730,
        -511240490,
    );
    let r = i64x4::new(
        3987350480567897216,
        -909423805039995588,
        1476209283271918829,
        1142495638330554240,
    );

    assert_eq!(r, transmute(lasx_xvmul_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmul_d() {
    let a = i64x4::new(
        7081580607883685997,
        8110222974893566630,
        -8608830426521534350,
        590950945391337126,
    );
    let b = i64x4::new(
        5261749457268646376,
        -3861654047048473926,
        2264171061650339978,
        -2049567854949213368,
    );
    let r = i64x4::new(
        -9157092306373316664,
        -1248560416451753828,
        7374339937678077300,
        -3668010491661410128,
    );

    assert_eq!(r, transmute(lasx_xvmul_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmadd_b() {
    let a = i8x32::new(
        -80, 6, -31, 32, -90, -72, 112, 83, 57, 119, -115, 85, -124, 56, 112, 8, 55, -29, -86,
        -43, -88, 94, 98, -85, 111, -93, -82, 53, 79, -43, 14, -67,
    );
    let b = i8x32::new(
        86, -88, -20, -70, -85, 89, -29, -112, -123, -89, 29, 42, -11, -125, -93, -49, -27, -7,
        99, 68, 125, -84, -21, -114, 79, -118, 99, -23, 69, 9, -20, -112,
    );
    let c = i8x32::new(
        -63, 26, 78, 67, 81, 21, 10, -51, 114, -15, 89, -83, 83, -69, -105, -86, 92, 63, -57,
        -19, 3, 118, -24, 53, 17, 70, 49, 96, -75, -120, -92, -112,
    );
    let r = i64x4::new(
        -6679394867387754874,
        9121453853276024435,
        1250494502005582467,
        -4810234623069954130,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmadd_b(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmadd_h() {
    let a = i16x16::new(
        -18216, 6658, -25854, 27669, 16377, -14455, 1886, -6575, 31234, 14625, 26195, -12640,
        24030, -29160, 29917, -29533,
    );
    let b = i16x16::new(
        -3405, 23202, -23415, -21889, -9055, -26344, -21723, -29614, -15925, -27403, -3911,
        -6313, 18640, 2098, 7776, 25873,
    );
    let c = i16x16::new(
        -28853, -6876, -18951, -29568, 17346, 756, -1848, -28084, -18031, -29179, -17665, 5467,
        -7564, -24294, -5418, -17877,
    );
    let r = i64x4::new(
        2275867314736517193,
        5956455014341383419,
        3282447490748182781,
        -2270208808738554850,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmadd_h(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmadd_w() {
    let a = i32x8::new(
        631333548,
        -711233206,
        -373490054,
        -1088004305,
        1976762993,
        -1387656422,
        -955329396,
        -154134074,
    );
    let b = i32x8::new(
        -1871585382,
        1805289828,
        -855267305,
        -1685758538,
        1205523204,
        -199185288,
        1115810744,
        -1091019827,
    );
    let c = i32x8::new(
        -1280005623,
        719575493,
        -616783227,
        1851306944,
        1226448706,
        -1988503778,
        998289127,
        -1282400946,
    );
    let r = i64x4::new(
        -2474464942478687466,
        1027640603165319277,
        8552064293631354233,
        4842015271998822292,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmadd_w(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmadd_d() {
    let a = i64x4::new(
        -8550317712350613337,
        8202606384933985240,
        5087434227784990050,
        -1267807070683885625,
    );
    let b = i64x4::new(
        802127189675314302,
        3753081308686166762,
        -8729512035384580104,
        -6163460252766523953,
    );
    let c = i64x4::new(
        9117516500379534748,
        7040045067230881407,
        -6924119543016236368,
        -3601551888108100797,
    );
    let r = i64x4::new(
        74735811180856175,
        -6992817346463866386,
        -821701661344765982,
        -5913164195617334796,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmadd_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmsub_b() {
    let a = i8x32::new(
        41, 66, 49, 41, -31, 101, 127, 22, -98, 62, 39, -62, -91, 97, 100, 46, 4, 17, 71, 25,
        127, 34, 34, -64, 56, -11, 109, -98, 39, -34, -124, -56,
    );
    let b = i8x32::new(
        -126, 107, 108, -102, -4, -15, -17, -100, 43, 106, -14, -106, -108, 12, 54, 116, -15,
        -102, 74, 95, -5, -115, 63, 100, -47, -1, 43, -111, 18, -6, -33, -59,
    );
    let c = i8x32::new(
        -12, -61, 80, 77, 76, 74, -19, -82, 43, -87, 110, -104, 33, -78, -99, -79, 24, -83, -6,
        122, -25, -80, -114, 88, 127, -19, 122, -59, 54, 43, 103, 122,
    );
    let r = i64x4::new(
        1025900500437025089,
        -412631794493733787,
        6931094814234771308,
        -1816111343100501367,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmsub_b(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmsub_h() {
    let a = i16x16::new(
        26038, 237, 16351, -25337, -23596, 9950, 32416, -11130, -4158, -30128, 4774, -23969,
        18009, 9294, -3126, -30265,
    );
    let b = i16x16::new(
        -31480, 9797, -14893, 24037, 11613, 4212, 22821, 26358, -744, -21778, -26335, 25179,
        -6708, -1235, -24224, 19814,
    );
    let c = i16x16::new(
        -26405, -560, -18771, -10193, -26133, 18220, 11977, 15766, 19965, 5097, 6382, -14160,
        17216, 29647, -20172, -31904,
    );
    let r = i64x4::new(
        2881334304583833566,
        -2133902947871987083,
        -1454770464836380918,
        5874888860683169625,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmsub_h(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmsub_w() {
    let a = i32x8::new(
        -1934260879,
        1181160590,
        -1986745,
        -225146926,
        599588188,
        1708212146,
        -1981989107,
        1701829445,
    );
    let b = i32x8::new(
        -763566835,
        214100032,
        -67293570,
        1596390731,
        -1705509662,
        -1061894423,
        -18782985,
        1095295438,
    );
    let c = i32x8::new(
        333156491,
        -310224012,
        -1373786280,
        699045355,
        681377550,
        -1946631976,
        1564749118,
        996805551,
    );
    let r = i64x4::new(
        362284194097715042,
        -5652196781102231049,
        243945460745636608,
        -6224637193866223557,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmsub_w(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmsub_d() {
    let a = i64x4::new(
        -3841665993514658557,
        6022894223412086471,
        -8518556207745298564,
        -1430476343179717412,
    );
    let b = i64x4::new(
        7897629235985733517,
        228540188827833305,
        -8463927364436887671,
        -8371521766374880332,
    );
    let c = i64x4::new(
        -4481659901844799958,
        -4869069543228428543,
        -327735423889799522,
        -3356219160756661306,
    );
    let r = i64x4::new(
        7809193441161400801,
        2981175878869326830,
        2247972583277073134,
        -8100971496301761628,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmsub_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvdiv_b() {
    let a = i8x32::new(
        2, 48, -45, 96, 6, -14, 2, -26, -29, 13, -116, -94, -82, 97, -85, 21, -74, -3, -122,
        -75, -114, -79, -14, -42, -40, -66, 107, 72, 117, -23, 55, 11,
    );
    let b = i8x32::new(
        -113, -102, -25, 23, 113, -81, -87, 61, -8, 115, 14, -87, -39, -62, -33, 117, -111,
        123, 30, 85, -119, -89, 37, 68, 93, 36, 94, 79, -50, 110, -128, -128,
    );
    let r = i64x4::new(67174400, 843334041468931, 16515072, 1090921824000);

    assert_eq!(r, transmute(lasx_xvdiv_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvdiv_h() {
    let a = i16x16::new(
        -12734, -9855, -5625, -19685, -5760, 20073, -4828, 32152, -17118, -23694, 12801,
        -32702, -21927, 29064, -255, 24493,
    );
    let b = i16x16::new(
        5202, -19363, -28050, 14286, -31733, 14009, 1475, 5279, -16963, -26208, -32414, 583,
        -21866, -8394, -11158, -24288,
    );
    let r = i64x4::new(
        -281474976645122,
        1970311952138240,
        -15762598695796735,
        -281470681939967,
    );

    assert_eq!(r, transmute(lasx_xvdiv_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvdiv_w() {
    let a = i32x8::new(
        -1639036870,
        1679737548,
        -1853446119,
        1425169187,
        709689254,
        1564169372,
        -368472440,
        754854064,
    );
    let b = i32x8::new(
        809279458,
        -211299601,
        1005342056,
        1721341232,
        -194511872,
        199704853,
        -196761589,
        -1316660885,
    );
    let r = i64x4::new(-25769803778, 4294967295, 34359738365, 1);

    assert_eq!(r, transmute(lasx_xvdiv_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvdiv_d() {
    let a = i64x4::new(
        -7822845930831810797,
        4993735058150674767,
        7948083854887733828,
        -5125159230108645154,
    );
    let b = i64x4::new(
        2343656432981471704,
        -7268480484218017416,
        -2152977508876073544,
        -6907442353788163718,
    );
    let r = i64x4::new(-3, 0, -3, 0);

    assert_eq!(r, transmute(lasx_xvdiv_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvdiv_bu() {
    let a = u8x32::new(
        40, 120, 155, 70, 202, 73, 51, 248, 122, 27, 98, 122, 31, 221, 63, 177, 129, 222, 159,
        41, 95, 74, 144, 15, 252, 14, 101, 220, 155, 209, 168, 214,
    );
    let b = u8x32::new(
        105, 3, 186, 90, 103, 16, 157, 200, 195, 15, 101, 16, 92, 118, 205, 221, 131, 139, 234,
        115, 14, 110, 40, 173, 4, 100, 228, 49, 164, 68, 238, 100,
    );
    let r = i64x4::new(
        72061996379416576,
        1099629068544,
        844450699936000,
        144118486677848127,
    );

    assert_eq!(r, transmute(lasx_xvdiv_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvdiv_hu() {
    let a = u16x16::new(
        50698, 15156, 21232, 20163, 45596, 12286, 58595, 95, 55092, 17141, 32523, 54385, 48523,
        48676, 43699, 52279,
    );
    let b = u16x16::new(
        11498, 6508, 15832, 27488, 24369, 64684, 6317, 20994, 2748, 14521, 46887, 35685, 40979,
        25137, 94, 32966,
    );
    let r = i64x4::new(4295098372, 38654705665, 281474976776212, 283467841601537);

    assert_eq!(r, transmute(lasx_xvdiv_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvdiv_wu() {
    let a = u32x8::new(
        2271275962, 1878803191, 1899241851, 435455463, 2545672438, 1798262264, 2100509405,
        2360750144,
    );
    let b = u32x8::new(
        4032427811, 1883431317, 1741576561, 2070639342, 54934516, 2950464411, 621309259,
        1280987465,
    );
    let r = i64x4::new(0, 1, 46, 4294967299);

    assert_eq!(r, transmute(lasx_xvdiv_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvdiv_du() {
    let a = u64x4::new(
        275328165009035219,
        4227696010240224586,
        8090530403053432892,
        18434063998903182990,
    );
    let b = u64x4::new(
        5339394187150320758,
        10250881649499684594,
        7311272300344996355,
        2859467035949281895,
    );
    let r = i64x4::new(0, 0, 1, 6);

    assert_eq!(r, transmute(lasx_xvdiv_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhaddw_h_b() {
    let a = i8x32::new(
        -5, 56, 50, 120, 77, -103, 42, -127, 8, 14, 21, 38, 52, -56, 89, 77, 35, -121, 96,
        -122, -68, 11, 79, -97, 3, 75, -125, 100, -38, 16, 97, -27,
    );
    let b = i8x32::new(
        111, -97, -90, 28, -46, -48, -5, -21, -82, -34, 99, 31, -37, -82, 19, -57, -101, 13,
        47, 8, 125, 38, 118, -109, -122, -71, 47, -65, -74, -3, -41, 82,
    );
    let r = i64x4::new(
        -36873861897256793,
        27302673318019004,
        5911562916593442,
        -18859072538017839,
    );

    assert_eq!(r, transmute(lasx_xvhaddw_h_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhaddw_w_h() {
    let a = i16x16::new(
        503, 16837, 17816, -5134, -2110, 16197, 4755, 25985, 3954, -31560, 16582, 19389,
        -15163, 24197, -23773, -18386,
    );
    let b = i16x16::new(
        -23093, -2745, 8695, 3948, 29248, 22668, 15341, -17908, 18023, -1280, 5749, -6270,
        2684, 12529, 9865, -12718,
    );
    let r = i64x4::new(
        15298673502096,
        177493818519941,
        107971182840607,
        -36597416302335,
    );

    assert_eq!(r, transmute(lasx_xvhaddw_w_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhaddw_d_w() {
    let a = i32x8::new(
        1750963922,
        584909082,
        1421536823,
        -1912125255,
        -1415675154,
        -950003373,
        85319168,
        -762670446,
    );
    let b = i32x8::new(
        459045461,
        -2028594364,
        1976546319,
        -755242326,
        -53664060,
        861552329,
        642848731,
        -407580162,
    );
    let r = i64x4::new(1043954543, 64421064, -1003667433, -119821715);

    assert_eq!(r, transmute(lasx_xvhaddw_d_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhaddw_hu_bu() {
    let a = u8x32::new(
        38, 74, 29, 69, 140, 185, 4, 140, 17, 27, 252, 79, 243, 186, 145, 220, 13, 122, 179,
        16, 98, 184, 199, 160, 74, 126, 80, 155, 7, 140, 148, 161,
    );
    let b = u8x32::new(
        133, 115, 144, 226, 30, 38, 232, 188, 154, 67, 7, 165, 19, 149, 99, 178, 168, 65, 209,
        54, 133, 14, 77, 82, 70, 34, 115, 197, 56, 192, 38, 122,
    );
    let r = i64x4::new(
        104709614768292047,
        89791398044631221,
        66710930999804194,
        56014362196705476,
    );

    assert_eq!(r, transmute(lasx_xvhaddw_hu_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhaddw_wu_hu() {
    let a = u16x16::new(
        63778, 40631, 16392, 22225, 8863, 7513, 8207, 22318, 52096, 47974, 5062, 54405, 51728,
        26552, 52537, 29064,
    );
    let b = u16x16::new(
        13712, 64264, 56403, 59007, 46671, 35207, 62888, 11353, 49037, 2930, 56459, 32449,
        28370, 14428, 62265, 12050,
    );
    let r = i64x4::new(
        337704688604231,
        365956983477160,
        476157254400755,
        392255068231306,
    );

    assert_eq!(r, transmute(lasx_xvhaddw_wu_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhaddw_du_wu() {
    let a = u32x8::new(
        3700951359, 1340423021, 2816770908, 613522875, 1598890202, 536370888, 825435814,
        1465472531,
    );
    let b = u32x8::new(
        1643146315, 730247298, 3900765507, 744547675, 1943326068, 179507092, 214959309,
        1444692790,
    );
    let r = i64x4::new(2983569336, 4514288382, 2479696956, 1680431840);

    assert_eq!(r, transmute(lasx_xvhaddw_du_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhsubw_h_b() {
    let a = i8x32::new(
        -110, 85, -53, -96, -5, 14, -71, 50, -128, -83, 57, -86, 65, 24, 32, -119, 59, -41,
        -85, 22, -67, -124, -126, -18, 54, -36, 103, 81, 116, -79, -55, -52,
    );
    let b = i8x32::new(
        -15, -92, 68, 76, -101, -42, -21, -32, -36, 23, -114, -76, 40, 19, 111, -124, -29,
        -110, -123, -123, 24, 35, 126, 25, -14, 6, -91, 78, 49, -69, 27, -22,
    );
    let r = i64x4::new(
        19985221551915108,
        -64457838384316463,
        -40251557315215372,
        -21955597927907350,
    );

    assert_eq!(r, transmute(lasx_xvhsubw_h_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhsubw_w_h() {
    let a = i16x16::new(
        32475, -17580, 4965, -21648, -16988, -15947, 18483, -27381, -26195, 19027, 19784,
        -13358, -6180, 27442, 23283, 1155,
    );
    let b = i16x16::new(
        7640, 26084, 32525, 1062, -7851, 17013, -8159, 21593, 32263, -22862, 17816, 30577,
        -11674, 14875, 26487, -22021,
    );
    let r = i64x4::new(
        -232666968384132,
        -82553566404512,
        -133887015531444,
        -108800111503156,
    );

    assert_eq!(r, transmute(lasx_xvhsubw_w_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhsubw_d_w() {
    let a = i32x8::new(
        1120555405, 606416783, 1862962829, 65716515, -720291245, 1995296165, 1877873639,
        383778576,
    );
    let b = i32x8::new(
        -2142481365,
        -2015795383,
        110862808,
        1067722925,
        1036379333,
        1746215780,
        -901547317,
        -304263170,
    );
    let r = i64x4::new(2748898148, -45146293, 958916832, 1285325893);

    assert_eq!(r, transmute(lasx_xvhsubw_d_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhsubw_hu_bu() {
    let a = u8x32::new(
        113, 29, 201, 242, 134, 250, 176, 112, 14, 192, 71, 63, 59, 39, 230, 197, 232, 110, 2,
        134, 244, 44, 110, 200, 209, 99, 15, 169, 39, 126, 139, 207,
    );
    let b = u8x32::new(
        235, 233, 194, 214, 34, 190, 122, 157, 241, 119, 67, 242, 183, 26, 163, 208, 6, 32,
        249, 49, 62, 56, 64, 107, 68, 140, 184, 157, 27, 232, 174, 226,
    );
    let r = i64x4::new(
        -2813822050959566,
        9851010004352975,
        38561998787379304,
        9289103727198239,
    );

    assert_eq!(r, transmute(lasx_xvhsubw_hu_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhsubw_wu_hu() {
    let a = u16x16::new(
        24627, 1925, 40631, 41120, 48598, 56441, 57360, 63413, 60803, 9134, 1910, 34890, 8361,
        20497, 16343, 44260,
    );
    let b = u16x16::new(
        63771, 7054, 62761, 8243, 13185, 3930, 52006, 48295, 37094, 2357, 31496, 1199, 13321,
        56020, 36805, 30263,
    );
    let r = i64x4::new(
        -92943092347286,
        48992691988728,
        14581413941960,
        32018981198856,
    );

    assert_eq!(r, transmute(lasx_xvhsubw_wu_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhsubw_du_wu() {
    let a = u32x8::new(
        1851655538, 2991049929, 4109504012, 1371213815, 2264711690, 1359668665, 2742473455,
        1279993359,
    );
    let b = u32x8::new(
        4047783060, 556492643, 3984363807, 4250070195, 975052988, 1299555592, 2868269900,
        2929723348,
    );
    let r = i64x4::new(-1056733131, -2613149992, 384615677, -1588276541);

    assert_eq!(r, transmute(lasx_xvhsubw_du_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmod_b() {
    let a = i8x32::new(
        -14, -64, -81, 32, -14, -85, 120, 64, 95, 126, -11, 38, 2, -53, 40, 54, -35, 41, 58,
        -60, 86, -9, 57, -11, 34, -17, -81, 89, -55, 25, 84, -101,
    );
    let b = i8x32::new(
        -98, -114, 25, 100, -111, 71, 35, 63, -23, 3, 93, -41, -3, -48, 91, 95, 98, 92, -113,
        -82, -81, 121, -35, 73, -83, -95, 75, 65, 26, 60, -124, -5,
    );
    let r = i64x4::new(
        76546840437899506,
        3902645063778631683,
        -786169480790529571,
        -48385121157714142,
    );

    assert_eq!(r, transmute(lasx_xvmod_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmod_h() {
    let a = i16x16::new(
        13568, -26495, 27958, 11226, -17868, -9288, -10627, -29659, -16286, -27756, 22645,
        -14990, 1109, 782, 5976, -13268,
    );
    let b = i16x16::new(
        22907, -30762, -26890, -2623, -3889, -8952, 27558, -27225, -1007, -2649, -19000, -1212,
        3583, -14136, -1124, 6289,
    );
    let r = i64x4::new(
        206607222489298176,
        -684874256681470216,
        -125522180245094574,
        -194216204870745003,
    );

    assert_eq!(r, transmute(lasx_xvmod_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmod_w() {
    let a = i32x8::new(
        1309045772,
        -1137265851,
        -1474148809,
        -826641461,
        517262391,
        -454945903,
        -2059227752,
        1033836629,
    );
    let b = i32x8::new(
        1742453362, -859625876, 711512169, 963835525, 1823286802, 1062091570, 1215420851,
        -845753957,
    );
    let r = i64x4::new(
        -1192454611378211828,
        -3550398036268816631,
        -1953977774316925897,
        807808928635455307,
    );

    assert_eq!(r, transmute(lasx_xvmod_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmod_d() {
    let a = i64x4::new(
        1878041523555568774,
        1556025246870009445,
        8042729508142516845,
        -3048989907394276239,
    );
    let b = i64x4::new(
        4139731099187900579,
        -5256541293724606275,
        -289001035147795771,
        -6358290177153594057,
    );
    let r = i64x4::new(
        1878041523555568774,
        1556025246870009445,
        239701559152031028,
        -3048989907394276239,
    );

    assert_eq!(r, transmute(lasx_xvmod_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmod_bu() {
    let a = u8x32::new(
        124, 195, 23, 51, 29, 150, 162, 114, 37, 233, 71, 130, 185, 243, 82, 178, 55, 114, 198,
        194, 51, 128, 183, 135, 254, 147, 93, 254, 157, 231, 225, 75,
    );
    let b = u8x32::new(
        4, 234, 86, 5, 151, 127, 208, 171, 229, 154, 21, 203, 87, 142, 153, 152, 109, 75, 195,
        182, 135, 251, 242, 45, 15, 229, 168, 223, 89, 83, 178, 220,
    );
    let r = i64x4::new(
        8260190079890735872,
        1896689493177028389,
        51650877471270711,
        5417620637589803790,
    );

    assert_eq!(r, transmute(lasx_xvmod_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmod_hu() {
    let a = u16x16::new(
        59302, 64062, 17665, 34634, 39674, 40771, 56476, 39054, 20128, 46806, 28975, 5092,
        32039, 65514, 52991, 10995,
    );
    let b = u16x16::new(
        30365, 10559, 8088, 37622, 54157, 864, 21095, 43558, 39181, 49555, 45853, 63130, 49482,
        1077, 5568, 1505,
    );
    let r = i64x4::new(
        -8698133335059959543,
        -7453958975338079494,
        1433395031155560096,
        129490854556368167,
    );

    assert_eq!(r, transmute(lasx_xvmod_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmod_wu() {
    let a = u32x8::new(
        2536195964, 1025991305, 145727133, 1179968501, 2535376324, 2624321769, 500804646,
        3445505165,
    );
    let b = u32x8::new(
        4283722185, 726568518, 2648066980, 2591107739, 3836915245, 1768721904, 1082904228,
        128214904,
    );
    let r = i64x4::new(
        1286011080378369916,
        5067926122250870429,
        3674773441172391364,
        480682694340619302,
    );

    assert_eq!(r, transmute(lasx_xvmod_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmod_du() {
    let a = u64x4::new(
        3050922509882516945,
        14221067967600195195,
        8310753426098198776,
        150087784552479859,
    );
    let b = u64x4::new(
        9108987739022803721,
        14892726191598876390,
        10175125705243076843,
        8880022576671073801,
    );
    let r = i64x4::new(
        3050922509882516945,
        -4225676106109356421,
        8310753426098198776,
        150087784552479859,
    );

    assert_eq!(r, transmute(lasx_xvmod_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrepl128vei_b() {
    let a = i8x32::new(
        14, 7, 83, 99, -72, -90, 66, -53, 33, 27, -21, 110, -96, -58, -96, 54, -73, 74, -33,
        51, -15, -108, -39, 124, 124, -74, -17, -17, -41, 84, 46, -73,
    );
    let r = i64x4::new(
        2387225703656530209,
        2387225703656530209,
        8970181431921507452,
        8970181431921507452,
    );

    assert_eq!(r, transmute(lasx_xvrepl128vei_b::<8>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrepl128vei_h() {
    let a = i16x16::new(
        2674, -3702, -21458, 12674, 26270, 949, -26647, 9913, 30933, 30654, -32697, -13873,
        16165, -5608, 18102, -20233,
    );
    let r = i64x4::new(
        3567468290076979586,
        3567468290076979586,
        -3904680457625679409,
        -3904680457625679409,
    );

    assert_eq!(r, transmute(lasx_xvrepl128vei_h::<3>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrepl128vei_w() {
    let a = i32x8::new(
        -64196701,
        1709481199,
        -1911955655,
        1777845271,
        1233260806,
        -309058551,
        -557473503,
        -1179212061,
    );
    let r = i64x4::new(
        7342165844541349103,
        7342165844541349103,
        -1327396365108239351,
        -1327396365108239351,
    );

    assert_eq!(r, transmute(lasx_xvrepl128vei_w::<1>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrepl128vei_d() {
    let a = i64x4::new(
        5505097689447100650,
        -5456987454315761481,
        4427502889722976813,
        8082072270131265608,
    );
    let r = i64x4::new(
        5505097689447100650,
        5505097689447100650,
        4427502889722976813,
        4427502889722976813,
    );

    assert_eq!(r, transmute(lasx_xvrepl128vei_d::<0>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickev_b() {
    let a = i8x32::new(
        68, 32, 62, -48, -57, 81, -17, -49, 89, 83, 84, -17, -84, 27, 125, 34, 45, 22, -76,
        -126, -58, -15, 52, 46, -101, -120, -128, -63, 125, -119, 62, -25,
    );
    let b = i8x32::new(
        -18, 6, -55, 4, 74, 5, 59, 34, 92, 70, 29, -38, 91, 22, 15, 54, 5, -31, -103, -121,
        -83, 48, -87, -100, 69, 89, -111, -61, 66, 85, 5, 122,
    );
    let r = i64x4::new(
        1106510415418542574,
        9055705695986859588,
        379025047038040325,
        4502896606534087725,
    );

    assert_eq!(r, transmute(lasx_xvpickev_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickev_h() {
    let a = i16x16::new(
        13779, -9769, -21673, -32164, -29136, -24643, -35, -10237, -15874, -1630, -366, -22027,
        -18176, 10211, -7522, 20788,
    );
    let b = i16x16::new(
        16573, -27194, 21452, -4952, 10891, -6280, -31016, -14088, -21903, -8934, 20641, 23162,
        -12223, 6236, -15855, -20126,
    );
    let r = i64x4::new(
        -8730181099762990915,
        -9695284500679213,
        -4462556776803227023,
        -2117051360895385090,
    );

    assert_eq!(r, transmute(lasx_xvpickev_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickev_w() {
    let a = i32x8::new(
        -946752951,
        -207147822,
        -193366329,
        -1481453777,
        -750923229,
        -575660669,
        -1037215364,
        1221718353,
    );
    let b = i32x8::new(
        -1468110932,
        -1007107613,
        1371137124,
        1715394094,
        -920814431,
        907354058,
        597912747,
        1796030124,
    );
    let r = i64x4::new(
        5888989108738353068,
        -830502055854362039,
        2568015697600674977,
        -4454806063744691677,
    );

    assert_eq!(r, transmute(lasx_xvpickev_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickev_d() {
    let a = i64x4::new(
        -94428288198650872,
        4107006669052123351,
        1952973857169882715,
        -3468095864189526981,
    );
    let b = i64x4::new(
        -2104254403922616194,
        -5215534061403539132,
        4917599455110663395,
        -3171208575864229825,
    );
    let r = i64x4::new(
        -2104254403922616194,
        -94428288198650872,
        4917599455110663395,
        1952973857169882715,
    );

    assert_eq!(r, transmute(lasx_xvpickev_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickod_b() {
    let a = i8x32::new(
        -56, -8, -6, -10, 108, -8, 122, 120, -75, -26, -47, 2, -35, -87, -61, 70, -24, -48,
        125, 19, -66, 42, -2, -49, -94, -84, -63, 74, -45, -54, -120, 56,
    );
    let b = i8x32::new(
        -65, -120, -46, -90, -108, -41, -28, -32, -125, -114, -59, 122, -3, 76, -67, -50, -59,
        -94, 83, 122, -100, 12, -81, -57, 6, 29, 6, 85, -94, -36, -30, -43,
    );
    let r = i64x4::new(
        -3581352849590212984,
        5091604042614372088,
        -3036458462372660574,
        4092165317489988560,
    );

    assert_eq!(r, transmute(lasx_xvpickod_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickod_h() {
    let a = i16x16::new(
        -31000, 26625, -24749, -26219, 27675, -16099, 12139, 4936, 17198, 8639, 15258, 14842,
        -6785, 3344, 2053, 21006,
    );
    let b = i16x16::new(
        -1278, -30287, -424, 21484, 7821, 21393, 23139, -7886, 2473, 16757, -29424, 14324,
        15035, 18736, -9314, 7772,
    );
    let r = i64x4::new(
        -2219619782696859215,
        1389572817918715905,
        2187703990441230709,
        5912677724127371711,
    );

    assert_eq!(r, transmute(lasx_xvpickod_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickod_w() {
    let a = i32x8::new(
        2143199982,
        -991627533,
        1630737785,
        -175139906,
        -976073052,
        -1793301951,
        -834831207,
        3306425,
    );
    let b = i32x8::new(
        1564508527,
        626529718,
        264606833,
        -1943354886,
        1166719003,
        -869473680,
        1896581238,
        -1078061273,
    );
    let r = i64x4::new(
        -8346645679265278538,
        -752220165191174413,
        -4630237907193634192,
        14200989743342145,
    );

    assert_eq!(r, transmute(lasx_xvpickod_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickod_d() {
    let a = i64x4::new(
        4767160600123418734,
        8001080746285135394,
        -2817760190229042067,
        3923084493864153244,
    );
    let b = i64x4::new(
        -3317389585990069371,
        8793937455278562227,
        7703929803523851571,
        5524330706927878132,
    );
    let r = i64x4::new(
        8793937455278562227,
        8001080746285135394,
        5524330706927878132,
        3923084493864153244,
    );

    assert_eq!(r, transmute(lasx_xvpickod_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvilvh_b() {
    let a = i8x32::new(
        -72, 73, -43, 126, -52, 83, 85, -79, -99, 67, 27, 28, 39, -21, -74, -30, 61, 83, 80,
        -18, 48, 18, 55, 82, 107, -26, -7, 17, 91, -87, 97, 84,
    );
    let b = i8x32::new(
        -3, -33, -12, -52, 73, 87, -102, -3, -114, -95, -78, 65, -102, 36, 40, 102, 102, 115,
        48, -41, 109, -110, -6, 9, -8, 86, 119, -37, 25, 96, 23, 62,
    );
    let r = i64x4::new(
        2035938959000968590,
        -2132817086653388902,
        1286896411905256440,
        6070396101995813657,
    );

    assert_eq!(r, transmute(lasx_xvilvh_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvilvh_h() {
    let a = i16x16::new(
        -28753, 23947, 10110, -8166, 18168, -1619, 12029, 10309, 22060, -11658, 8123, 22354,
        23552, 27450, -16412, 24672,
    );
    let b = i16x16::new(
        -31442, 23864, 15251, -12304, -23752, -1685, -10720, 21446, 19318, 27618, 10892, -9393,
        -29179, 13870, 16716, 10233,
    );
    let r = i64x4::new(
        -455433748147035336,
        2901817645567170080,
        7726547683447442949,
        6944594579025051980,
    );

    assert_eq!(r, transmute(lasx_xvilvh_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvilvh_w() {
    let a = i32x8::new(
        678797694,
        -1852295486,
        -632882964,
        -375269950,
        1655683337,
        562516909,
        -759600517,
        595568887,
    );
    let b = i32x8::new(
        -2114925053,
        1623015448,
        -398485927,
        -271020427,
        -284878929,
        -1558239614,
        -902548533,
        1778292534,
    );
    let r = i64x4::new(
        -2718211628679063975,
        -1611772158397608331,
        -3262459375147273269,
        2557948893958412086,
    );

    assert_eq!(r, transmute(lasx_xvilvh_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvilvh_d() {
    let a = i64x4::new(
        -5521345585808929096,
        -2494281556296927351,
        2989419257337371241,
        -1576924492614617443,
    );
    let b = i64x4::new(
        -7666029279891695247,
        -1067545656448973211,
        7271996920619620214,
        -3924745280397255469,
    );
    let r = i64x4::new(
        -1067545656448973211,
        -2494281556296927351,
        -3924745280397255469,
        -1576924492614617443,
    );

    assert_eq!(r, transmute(lasx_xvilvh_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvilvl_b() {
    let a = i8x32::new(
        -79, -60, -80, 23, 8, 83, -52, -72, 18, 98, 69, -81, -15, -95, 68, -38, 108, -9, -95,
        110, 63, -24, -106, -24, 78, -109, 117, 10, 36, 13, -9, -70,
    );
    let b = i8x32::new(
        -4, -37, -54, -19, 91, 52, 111, -6, 23, 24, 50, 18, 58, 109, 35, -89, -55, -31, 21,
        -28, 76, 16, -53, -16, 73, 97, -99, 70, 75, -124, 75, 70,
    );
    let r = i64x4::new(
        1724228617285382652,
        -5117553248043792293,
        7990688754587233481,
        -1661662459983806644,
    );

    assert_eq!(r, transmute(lasx_xvilvl_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvilvl_h() {
    let a = i16x16::new(
        16116, 7715, 3432, 24398, -2759, -24490, -19436, 8863, -24282, 23416, -26870, -3179,
        -23599, -9862, 20524, 10277,
    );
    let b = i16x16::new(
        -29120, 15023, -2814, 7040, -19198, -5516, 30715, 18311, -1346, 32030, -17709, -30250,
        21978, 26007, -6093, 28687,
    );
    let r = i64x4::new(
        2171643969672613440,
        6867456718581331202,
        6591155625162898110,
        -894657396213105965,
    );

    assert_eq!(r, transmute(lasx_xvilvl_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvilvl_w() {
    let a = i32x8::new(
        1489997232,
        1342252220,
        136381167,
        288285197,
        -1772559171,
        1615944068,
        1604328217,
        -70958228,
    );
    let b = i32x8::new(
        -794555105,
        44816804,
        2089609888,
        313909292,
        2017363432,
        -1414750261,
        1773836405,
        138829633,
    );
    let r = i64x4::new(
        6399489386070936863,
        5764929387928213924,
        -7613083667652508184,
        6940426927105417163,
    );

    assert_eq!(r, transmute(lasx_xvilvl_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvilvl_d() {
    let a = i64x4::new(
        2785967349713819381,
        4295622653064831557,
        -2688716944239585727,
        1495201372757695383,
    );
    let b = i64x4::new(
        -6882080563044023861,
        8040350606767129885,
        9211364387423765025,
        -7760991016985753125,
    );
    let r = i64x4::new(
        -6882080563044023861,
        2785967349713819381,
        9211364387423765025,
        -2688716944239585727,
    );

    assert_eq!(r, transmute(lasx_xvilvl_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpackev_b() {
    let a = i8x32::new(
        34, -14, -37, 93, 107, -43, -84, 47, -2, 72, -44, -4, -21, -45, 91, 44, -67, 47, 78,
        -88, -77, 54, -48, -4, -115, 28, 45, -112, -16, -93, -125, 86,
    );
    let b = i8x32::new(
        45, -46, 115, 63, -60, -89, 34, 1, -32, 96, -41, -112, 72, 24, 68, 64, 65, -60, 104,
        -83, -54, 125, -86, 98, -18, -128, 68, -66, -17, 92, 8, 64,
    );
    let r = i64x4::new(
        -6043149256738266579,
        6576640053908864736,
        -3410716086299476671,
        -9004682544879989266,
    );

    assert_eq!(r, transmute(lasx_xvpackev_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpackev_h() {
    let a = i16x16::new(
        -31926, 14925, 3993, -25807, -28395, 26414, 8241, 24589, -2983, -24679, 19318, 9614,
        10323, 27545, -18762, -18536,
    );
    let b = i16x16::new(
        -7985, 4641, -22978, 7805, 3248, 14824, -30918, 8002, 2172, -19190, -6029, 4840, 24125,
        16864, 9543, -919,
    );
    let r = i64x4::new(
        1124112369426555087,
        2319783968684444848,
        5437789184814811260,
        -5280992525495869891,
    );

    assert_eq!(r, transmute(lasx_xvpackev_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpackev_w() {
    let a = i32x8::new(
        -332151772,
        1303690878,
        1282065842,
        -1700272560,
        -443102472,
        2142454870,
        78857966,
        -1548128347,
    );
    let b = i32x8::new(
        -804493639,
        452785364,
        -1917157806,
        -914796730,
        -2002581887,
        -390090579,
        927546388,
        154785025,
    );
    let r = i64x4::new(
        -1426580994557974855,
        5506430865086512722,
        -1903110623724370303,
        338692385926626324,
    );

    assert_eq!(r, transmute(lasx_xvpackev_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpackev_d() {
    let a = i64x4::new(
        6553071732696091666,
        6908931613033995721,
        -3601691172781761847,
        -4565881074922016381,
    );
    let b = i64x4::new(
        -4424638855877852796,
        -3616236802390284562,
        -8253892234265412575,
        6668303162003192752,
    );
    let r = i64x4::new(
        -4424638855877852796,
        6553071732696091666,
        -8253892234265412575,
        -3601691172781761847,
    );

    assert_eq!(r, transmute(lasx_xvpackev_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpackod_b() {
    let a = i8x32::new(
        62, -60, -127, 84, -107, -106, -66, -119, -110, 28, 57, 97, 19, 34, -37, -7, -42, -117,
        104, -27, 81, 106, -19, 80, -20, 127, -104, 54, -37, 108, -37, 51,
    );
    let b = i8x32::new(
        -126, 96, -65, -4, 53, 69, -10, -33, 102, 21, -35, 115, -63, 15, -13, -3, 25, 100, 22,
        -95, -81, 17, -18, 101, -67, -115, 82, 4, 123, -94, 98, 91,
    );
    let r = i64x4::new(
        -8511919546184186784,
        -433152539702911979,
        5793153120781568868,
        3700670962761760653,
    );

    assert_eq!(r, transmute(lasx_xvpackod_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpackod_h() {
    let a = i16x16::new(
        -15659, -944, 746, -2159, -14115, 32333, 7687, 7300, 16484, -5418, 17483, -23753,
        -11433, 8096, 6365, -19623,
    );
    let b = i16x16::new(
        -16063, 24227, 15870, -31985, -14423, 10575, -5597, -29174, 8408, 3527, 9997, 27250,
        16855, -32478, -12854, 24292,
    );
    let r = i64x4::new(
        -607560370037432669,
        2054923505707592015,
        -6685758080009499193,
        -5523279134117035742,
    );

    assert_eq!(r, transmute(lasx_xvpackod_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpackod_w() {
    let a = i32x8::new(
        -842203551,
        -1271389188,
        -2068525802,
        -1822181077,
        -986051686,
        -837897746,
        37690010,
        -1697819510,
    );
    let b = i32x8::new(
        224471764,
        -768842241,
        -1859806928,
        1498474664,
        -223957810,
        2079941216,
        -338745357,
        -2090020855,
    );
    let r = i64x4::new(
        -5460574979421870593,
        -7826208131606583128,
        -3598743414382173600,
        -7292079267755798519,
    );

    assert_eq!(r, transmute(lasx_xvpackod_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpackod_d() {
    let a = i64x4::new(
        -7495668983396862169,
        8274812346114337628,
        4379006400301575850,
        -8628096693516187272,
    );
    let b = i64x4::new(
        -8614497367106654999,
        -7004520942966577002,
        5232114663469258860,
        5306174777811604017,
    );
    let r = i64x4::new(
        -7004520942966577002,
        8274812346114337628,
        5306174777811604017,
        -8628096693516187272,
    );

    assert_eq!(r, transmute(lasx_xvpackod_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvshuf_b() {
    let a = i8x32::new(
        39, -115, -21, 29, -109, -123, 49, 7, 120, 96, 121, 123, -87, 122, -27, 5, -103, -90,
        -93, 98, -37, -100, 93, 27, -86, 15, -22, -80, -5, -16, 124, 124,
    );
    let b = i8x32::new(
        -102, 106, 26, -77, 48, 65, 21, -98, 122, -73, 124, -79, 94, 69, 52, -84, -21, -99,
        -41, 63, -91, 26, -63, 44, -37, -5, -99, 53, -126, -109, -61, -55,
    );
    let c = i8x32::new(
        0, 27, 12, 22, 17, 20, 12, 27, 24, 7, 29, 9, 30, 3, 21, 25, 25, 15, 16, 11, 11, 12, 9,
        11, 29, 16, 7, 30, 18, 12, 8, 10,
    );
    let r = i64x4::new(
        8889704949103885210,
        6955162998750748280,
        3889845868208703759,
        -7071915151180654096,
    );

    assert_eq!(
        r,
        transmute(lasx_xvshuf_b(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvshuf_h() {
    let a = i16x16::new(14, 0, 11, 10, 2, 6, 5, 1, 3, 12, 4, 7, 10, 8, 10, 4);
    let b = i16x16::new(
        -21254, 15426, -9904, -9348, 19843, 4700, -18790, 16378, -12463, 13093, 1534, -947,
        -22603, -31524, -24301, -13577,
    );
    let c = i16x16::new(
        -6824, -21705, 6609, -73, 752, 8612, -13615, 29408, 31778, -1056, 20474, 23005, -10590,
        8605, -3153, 16014,
    );
    let r = i64x4::new(
        -2787486839872112998,
        -6109377377843734063,
        4507776271131171293,
        -2980813411407821314,
    );

    assert_eq!(
        r,
        transmute(lasx_xvshuf_h(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvshuf_w() {
    let a = i32x8::new(6, 4, 1, 5, 3, 0, 3, 2);
    let b = i32x8::new(
        112260284,
        143215906,
        -519532509,
        2126848278,
        -1874926296,
        888441697,
        -716493665,
        -1989603791,
    );
    let c = i32x8::new(
        174486498,
        1186503117,
        -1753459384,
        1078106035,
        -2055158107,
        2071085725,
        1120609144,
        -109951450,
    );
    let r = i64x4::new(
        482154252195106851,
        615107633723513293,
        -8826836853489252826,
        4812979629263570470,
    );

    assert_eq!(
        r,
        transmute(lasx_xvshuf_w(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvshuf_d() {
    let a = i64x4::new(0, 1, 2, 3);
    let b = i64x4::new(
        -4818789571452434899,
        -1419914372991806078,
        -1036924962456047190,
        5694315469710360861,
    );
    let c = i64x4::new(
        6580926913588532380,
        -6246203397488305553,
        -6030997396381573391,
        -9089767205636240503,
    );
    let r = i64x4::new(
        6580926913588532380,
        -6246203397488305553,
        -1036924962456047190,
        5694315469710360861,
    );

    assert_eq!(
        r,
        transmute(lasx_xvshuf_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvand_v() {
    let a = u8x32::new(
        90, 203, 15, 155, 63, 105, 53, 48, 190, 209, 178, 76, 210, 20, 95, 140, 100, 15, 124,
        254, 188, 84, 233, 191, 139, 236, 35, 122, 198, 9, 3, 147,
    );
    let b = u8x32::new(
        213, 245, 251, 19, 199, 6, 225, 234, 198, 129, 17, 8, 53, 155, 124, 177, 193, 194, 146,
        194, 233, 18, 7, 81, 49, 91, 33, 177, 131, 65, 221, 245,
    );
    let r = i64x4::new(
        2315131713829454160,
        -9197458677956574842,
        1225278890617864768,
        -7998109804568426495,
    );

    assert_eq!(r, transmute(lasx_xvand_v(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvandi_b() {
    let a = u8x32::new(
        76, 191, 179, 169, 134, 148, 220, 33, 48, 114, 218, 175, 149, 53, 89, 64, 173, 218,
        209, 46, 131, 153, 196, 101, 69, 5, 138, 207, 219, 29, 3, 11,
    );
    let r = i64x4::new(
        2381282727478636300,
        2573978984653344,
        2667266788571548205,
        793492300495455493,
    );

    assert_eq!(r, transmute(lasx_xvandi_b::<47>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvor_v() {
    let a = u8x32::new(
        125, 60, 243, 199, 224, 172, 254, 103, 105, 229, 245, 138, 160, 89, 141, 68, 218, 162,
        229, 242, 225, 91, 142, 124, 4, 158, 13, 29, 31, 24, 19, 236,
    );
    let b = u8x32::new(
        61, 24, 19, 82, 93, 44, 145, 86, 125, 230, 60, 205, 17, 204, 228, 220, 145, 189, 138,
        34, 184, 52, 178, 93, 142, 223, 59, 0, 197, 149, 61, 209,
    );
    let r = i64x4::new(
        8646820015824387197,
        -2527120060116506755,
        9060820211815399387,
        -198266276987019378,
    );

    assert_eq!(r, transmute(lasx_xvor_v(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvori_b() {
    let a = u8x32::new(
        224, 64, 88, 211, 150, 151, 191, 121, 45, 29, 78, 44, 95, 182, 208, 27, 245, 89, 219,
        195, 171, 1, 240, 194, 102, 138, 54, 60, 40, 239, 106, 1,
    );
    let r = i64x4::new(
        9079248013888353524,
        9220265364544191869,
        -651766303824052747,
        8466485259632311926,
    );

    assert_eq!(r, transmute(lasx_xvori_b::<116>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvnor_v() {
    let a = u8x32::new(
        76, 54, 61, 63, 251, 146, 243, 33, 217, 111, 210, 198, 26, 170, 74, 175, 96, 81, 208,
        187, 214, 194, 59, 158, 142, 191, 224, 234, 79, 178, 30, 115,
    );
    let b = u8x32::new(
        188, 24, 29, 204, 122, 22, 58, 38, 82, 168, 2, 213, 73, 48, 85, 251, 211, 186, 195, 15,
        123, 225, 156, 253, 77, 213, 172, 132, 177, 163, 80, 23,
    );
    let r = i64x4::new(
        -2881062395696725757,
        45112567624699940,
        18045185911686156,
        -8601510250130767824,
    );

    assert_eq!(r, transmute(lasx_xvnor_v(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvnori_b() {
    let a = u8x32::new(
        111, 178, 133, 23, 105, 149, 64, 248, 248, 8, 96, 98, 70, 20, 213, 175, 56, 216, 223,
        118, 46, 113, 0, 12, 209, 39, 73, 77, 16, 194, 218, 171,
    );
    let r = i64x4::new(
        440871273092500496,
        5767503740212762118,
        5935197095815284294,
        6053994920729270286,
    );

    assert_eq!(r, transmute(lasx_xvnori_b::<161>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvxor_v() {
    let a = u8x32::new(
        126, 139, 80, 168, 116, 128, 183, 120, 15, 152, 183, 62, 51, 179, 32, 150, 207, 108,
        88, 207, 22, 73, 189, 112, 204, 236, 216, 24, 10, 70, 249, 168,
    );
    let b = u8x32::new(
        3, 89, 57, 121, 152, 63, 89, 15, 254, 77, 130, 223, 192, 140, 229, 207, 202, 154, 208,
        62, 3, 30, 110, 85, 8, 137, 208, 97, 40, 65, 148, 234,
    );
    let r = i64x4::new(
        8642055758817120893,
        6468646756475590129,
        2725617951247496709,
        4786489823605581252,
    );

    assert_eq!(r, transmute(lasx_xvxor_v(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvxori_b() {
    let a = u8x32::new(
        36, 245, 58, 172, 188, 20, 51, 56, 127, 7, 39, 87, 209, 54, 137, 206, 217, 81, 137, 48,
        141, 135, 84, 138, 252, 157, 45, 234, 89, 34, 196, 168,
    );
    let r = i64x4::new(
        -8394526022023166313,
        9023671463178450124,
        4172361022876344938,
        1979210996964535887,
    );

    assert_eq!(r, transmute(lasx_xvxori_b::<179>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitsel_v() {
    let a = u8x32::new(
        69, 119, 244, 57, 103, 127, 203, 220, 144, 88, 221, 99, 13, 153, 253, 10, 8, 78, 153,
        186, 144, 233, 66, 26, 137, 170, 201, 216, 251, 59, 188, 201,
    );
    let b = u8x32::new(
        58, 118, 243, 153, 246, 176, 29, 116, 177, 226, 235, 9, 57, 218, 185, 77, 171, 107,
        162, 224, 75, 59, 187, 183, 56, 33, 90, 30, 188, 49, 190, 107,
    );
    let c = u8x32::new(
        8, 253, 144, 97, 31, 113, 95, 153, 184, 212, 7, 183, 120, 52, 43, 202, 55, 34, 46, 82,
        88, 35, 171, 65, 101, 142, 107, 208, 15, 137, 143, 201,
    );
    let r = i64x4::new(
        6097098147492034125,
        5259528428215584944,
        2011960906681118251,
        5313741768184438952,
    );

    assert_eq!(
        r,
        transmute(lasx_xvbitsel_v(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbitseli_b() {
    let a = u8x32::new(
        178, 71, 136, 149, 190, 92, 86, 87, 135, 81, 18, 106, 61, 240, 71, 242, 187, 166, 218,
        183, 12, 80, 244, 242, 232, 140, 161, 227, 35, 23, 225, 97,
    );
    let b = u8x32::new(
        173, 155, 189, 0, 17, 102, 85, 215, 175, 177, 175, 162, 203, 4, 46, 80, 41, 131, 12,
        130, 254, 191, 191, 230, 198, 211, 197, 37, 29, 13, 108, 138,
    );
    let r = i64x4::new(
        -7776240335059051363,
        -8057901949774876500,
        -7737254534663338600,
        -8463358690923847794,
    );

    assert_eq!(
        r,
        transmute(lasx_xvbitseli_b::<156>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvshuf4i_b() {
    let a = i8x32::new(
        108, -102, 33, -112, -6, -76, 115, -16, 40, -100, -76, 37, -61, -55, -102, 17, 25, 99,
        89, -78, 55, -35, 116, 64, 75, 14, -106, 67, -49, 18, -91, -41,
    );
    let r = i64x4::new(
        -5408624464691684710,
        -3958160729736635236,
        -2503757449887849629,
        1357573681433480718,
    );

    assert_eq!(r, transmute(lasx_xvshuf4i_b::<117>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvshuf4i_h() {
    let a = i16x16::new(
        -6971, -14860, 30437, 17998, 739, 5931, -29626, 13221, 14940, -31006, -17153, -20574,
        19219, 15653, -6222, 26534,
    );
    let r = i64x4::new(
        -4182640851919387148,
        1669484871499978539,
        -8727220014624373022,
        4406041774853078309,
    );

    assert_eq!(r, transmute(lasx_xvshuf4i_h::<125>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvshuf4i_w() {
    let a = i32x8::new(
        -1698591186,
        -189845668,
        1075366445,
        -1020663141,
        -48015581,
        913540401,
        -1408537529,
        218710667,
    );
    let r = i64x4::new(
        4618663713566149165,
        -7295393590547476946,
        -6049622619357221817,
        -206225345846487261,
    );

    assert_eq!(r, transmute(lasx_xvshuf4i_w::<10>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplgr2vr_b() {
    let r = i64x4::new(
        8463800222054970741,
        8463800222054970741,
        8463800222054970741,
        8463800222054970741,
    );

    assert_eq!(r, transmute(lasx_xvreplgr2vr_b(-139770763)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplgr2vr_h() {
    let r = i64x4::new(
        -1100020993973555013,
        -1100020993973555013,
        -1100020993973555013,
        -1100020993973555013,
    );

    assert_eq!(r, transmute(lasx_xvreplgr2vr_h(-111546181)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplgr2vr_w() {
    let r = i64x4::new(
        -8112237653938959659,
        -8112237653938959659,
        -8112237653938959659,
        -8112237653938959659,
    );

    assert_eq!(r, transmute(lasx_xvreplgr2vr_w(-1888777515)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplgr2vr_d() {
    let r = i64x4::new(
        -1472556476011894783,
        -1472556476011894783,
        -1472556476011894783,
        -1472556476011894783,
    );

    assert_eq!(r, transmute(lasx_xvreplgr2vr_d(-1472556476011894783)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpcnt_b() {
    let a = i8x32::new(
        -78, -95, 2, -80, -45, 8, -113, 34, -100, -34, 69, 126, -9, -4, -51, 89, -32, 120, 99,
        84, 74, -26, -84, 118, -104, -104, -2, -10, 56, 17, 66, 116,
    );
    let r = i64x4::new(
        145523683996271364,
        289644378270664196,
        361419380590117891,
        288795538114413315,
    );

    assert_eq!(r, transmute(lasx_xvpcnt_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpcnt_h() {
    let a = i16x16::new(
        11626, 5283, -7476, -20299, -21862, -7933, -26579, 26723, -24113, 8952, 15751, -20804,
        3834, 23833, -21664, 23370,
    );
    let r = i64x4::new(
        2251834173816840,
        1970354902138888,
        2814788422270985,
        2251829878980617,
    );

    assert_eq!(r, transmute(lasx_xvpcnt_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpcnt_w() {
    let a = i32x8::new(
        769725316,
        1329443403,
        3455051,
        -1024015807,
        1113804345,
        533788195,
        1478448269,
        663132689,
    );
    let r = i64x4::new(77309411341, 60129542155, 73014444046, 55834574863);

    assert_eq!(r, transmute(lasx_xvpcnt_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpcnt_d() {
    let a = i64x4::new(
        -1195667126994002745,
        574485287218873120,
        4359670550805993357,
        -166544779870738672,
    );
    let r = i64x4::new(33, 31, 29, 33);

    assert_eq!(r, transmute(lasx_xvpcnt_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvclo_b() {
    let a = i8x32::new(
        -87, -42, 123, 30, -64, -61, 45, 65, 116, 65, 36, 53, -53, 107, 76, 11, -15, -38, -46,
        88, -114, -107, 55, 53, -61, -70, -103, -62, 21, -29, 40, 95,
    );
    let r = i64x4::new(2207613190657, 8589934592, 1103806726660, 3298568503554);

    assert_eq!(r, transmute(lasx_xvclo_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvclo_h() {
    let a = i16x16::new(
        -4880, 19940, -15012, -1377, -9664, 29017, 15571, -20185, -11621, 32665, -31110, 32554,
        -31842, 20391, -23474, -18820,
    );
    let r = i64x4::new(
        1407383473487875,
        281474976710658,
        4294967298,
        281479271677953,
    );

    assert_eq!(r, transmute(lasx_xvclo_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvclo_w() {
    let a = i32x8::new(
        -472837395,
        -2135587215,
        -2000467762,
        411236038,
        -1457849736,
        1672236706,
        -1251091450,
        -777023005,
    );
    let r = i64x4::new(4294967299, 1, 1, 8589934593);

    assert_eq!(r, transmute(lasx_xvclo_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvclo_d() {
    let a = i64x4::new(
        -2662002076602604283,
        1069611961163112747,
        -5322946916564324351,
        7672935739349466106,
    );
    let r = i64x4::new(2, 0, 1, 0);

    assert_eq!(r, transmute(lasx_xvclo_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvclz_b() {
    let a = i8x32::new(
        48, -6, 70, -124, -16, -25, -31, -91, -16, -19, -117, -25, -17, 92, 40, 116, -123, 91,
        22, -73, 100, 103, -72, 27, 14, -67, 118, 82, 90, 31, -83, -15,
    );
    let r = i64x4::new(65538, 72621643502977024, 216173885920575744, 3302846693380);

    assert_eq!(r, transmute(lasx_xvclz_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvclz_h() {
    let a = i16x16::new(
        -11088, -2624, 9587, 10227, -21358, -32061, -32593, 20863, -13412, -5184, -28388,
        12581, 27368, 29494, 2214, -12445,
    );
    let r = i64x4::new(
        562958543355904,
        281474976710656,
        562949953421312,
        17179934721,
    );

    assert_eq!(r, transmute(lasx_xvclz_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvclz_w() {
    let a = i32x8::new(
        -1816955803,
        631623303,
        -844798554,
        -571080345,
        439698339,
        -377278351,
        -2011143491,
        1645796965,
    );
    let r = i64x4::new(8589934592, 0, 3, 4294967296);

    assert_eq!(r, transmute(lasx_xvclz_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvclz_d() {
    let a = i64x4::new(
        -3450263516250458188,
        -4779789731770767580,
        -2256592148267722054,
        4713387490250241941,
    );
    let r = i64x4::new(0, 0, 0, 1);

    assert_eq!(r, transmute(lasx_xvclz_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfadd_s() {
    let a = u32x8::new(
        1058561863, 1064952952, 1049344074, 1062702316, 1057792746, 1062620339, 1060506486,
        1055219670,
    );
    let b = u32x8::new(
        1058369685, 1062538381, 1060953918, 1045575432, 1041469388, 993916160, 1061165480,
        1040806504,
    );
    let r = i64x4::new(
        4604781644817557486,
        4577360739647446450,
        4564128465094280925,
        4545553165339792015,
    );

    assert_eq!(r, transmute(lasx_xvfadd_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfadd_d() {
    let a = u64x4::new(
        4604104186982846811,
        4594101328742252424,
        4601686809902104562,
        4591010495556540480,
    );
    let b = u64x4::new(
        4599295489329742538,
        4597621922535438280,
        4568770145289685248,
        4606509170156045614,
    );
    let r = i64x4::new(
        4606916121688765120,
        4600365225266215848,
        4601738557736193412,
        4607242424158867483,
    );

    assert_eq!(r, transmute(lasx_xvfadd_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfsub_s() {
    let a = u32x8::new(
        1051284612, 1063062529, 1065074933, 1061303845, 1040445544, 1065277127, 1050456038,
        1028474080,
    );
    let b = u32x8::new(
        1061323418, 1047742504, 1041252032, 1046362676, 1058536139, 1062234929, 1060266892,
        1051059318,
    );
    let r = i64x4::new(
        4548699359865974960,
        4542627446496145733,
        4483806600207662434,
        -4716328899074058446,
    );

    assert_eq!(r, transmute(lasx_xvfsub_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfsub_d() {
    let a = u64x4::new(
        4600171060344923522,
        4605546915627674696,
        4592595361373027936,
        4605218827740699453,
    );
    let b = u64x4::new(
        4605618236610286151,
        4595024973508085836,
        4603596942845220543,
        4598338803059870948,
    );
    let r = i64x4::new(
        -4621313823233868020,
        4604082677323287093,
        -4620839705514447386,
        4602885236169716939,
    );

    assert_eq!(r, transmute(lasx_xvfsub_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmul_s() {
    let a = u32x8::new(
        1052320864, 1047132356, 1062268100, 1046708728, 1041045324, 1063314176, 1059310073,
        1049796536,
    );
    let b = u32x8::new(
        1064358048, 1061515003, 1057528231, 1058432998, 1063900744, 1052241494, 1052600868,
        1042517172,
    );
    let r = i64x4::new(
        4482332724193798395,
        4469165660137518684,
        4513050635226112077,
        4412217640780718091,
    );

    assert_eq!(r, transmute(lasx_xvfmul_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmul_d() {
    let a = u64x4::new(
        4606629864418855094,
        4605003539487786257,
        4590479879446676128,
        4606513106899913084,
    );
    let b = u64x4::new(
        4605920112889960858,
        4598179153756612874,
        4606290518673084028,
        4605164664361830142,
    );
    let r = i64x4::new(
        4605444995749970010,
        4596002305251241714,
        4589904028032657573,
        4604645288864682176,
    );

    assert_eq!(r, transmute(lasx_xvfmul_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfdiv_s() {
    let a = u32x8::new(
        1057794250, 1042162504, 1058563973, 1059452123, 1050358290, 1044764232, 1058075458,
        1044755920,
    );
    let b = u32x8::new(
        1059441919, 1061487805, 1048043892, 1042438684, 1061822186, 1057796721, 1060121466,
        1051587390,
    );
    let r = i64x4::new(
        4489379395443175003,
        4648514715526194553,
        4518231675762938086,
        4544549637634302505,
    );

    assert_eq!(r, transmute(lasx_xvfdiv_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfdiv_d() {
    let a = u64x4::new(
        4599185246498765334,
        4599944651523203368,
        4605116834688397287,
        4604853047950220214,
    );
    let b = u64x4::new(
        4564176709757936128,
        4602766877113246240,
        4596205261335386636,
        4603651841724508284,
    );
    let r = i64x4::new(
        4641804750140101849,
        4604327948136618660,
        4616067223277414565,
        4608170208670026319,
    );

    assert_eq!(r, transmute(lasx_xvfdiv_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcvt_h_s() {
    let a = u32x8::new(
        1058469229, 1050453282, 1035903176, 1054073088, 1063294292, 1008492480, 1057298766,
        1061246000,
    );
    let b = u32x8::new(
        1023462464, 1060058935, 1063991271, 1051666694, 1026891648, 1059128978, 1040948004,
        1063761400,
    );
    let r = i64x4::new(
        3853176214889572358,
        3935915130522777784,
        4268902673740736937,
        4182498428240214789,
    );

    assert_eq!(r, transmute(lasx_xvfcvt_h_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcvt_s_d() {
    let a = u64x4::new(
        4597447768952621592,
        4604521658660448767,
        4602704275491810917,
        4598917842979840742,
    );
    let b = u64x4::new(
        4599553378754216492,
        4584512794443142976,
        4602292684825622938,
        4600582838384043714,
    );
    let r = i64x4::new(
        4394300226931207022,
        4554371141198369562,
        4522860581064345217,
        4509540616169896248,
    );

    assert_eq!(r, transmute(lasx_xvfcvt_s_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmin_s() {
    let a = u32x8::new(
        1055713836, 1054644052, 1049275150, 1057289061, 1061461229, 1041818012, 1060715063,
        1040785036,
    );
    let b = u32x8::new(
        1048823100, 1053139848, 1065067350, 1058425698, 1057910475, 1058359832, 1051231814,
        1042813160,
    );
    let r = i64x4::new(
        4523201206323234108,
        4541021940462824206,
        4474574290981646027,
        4470137692837414470,
    );

    assert_eq!(r, transmute(lasx_xvfmin_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmin_d() {
    let a = u64x4::new(
        4594570070884899116,
        4601942383326036568,
        4603863714261060635,
        4604069842204647079,
    );
    let b = u64x4::new(
        4597923907797027300,
        4602734374246572404,
        4583371218452703040,
        4596668800324369880,
    );
    let r = i64x4::new(
        4594570070884899116,
        4601942383326036568,
        4583371218452703040,
        4596668800324369880,
    );

    assert_eq!(r, transmute(lasx_xvfmin_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmina_s() {
    let a = u32x8::new(
        1051583574, 1048334100, 1008901056, 1048010844, 1058048126, 1046481300, 1034708664,
        1062424645,
    );
    let b = u32x8::new(
        1057050977, 1054905968, 1057610003, 1058883162, 1036134312, 1020267520, 1059621961,
        1062129138,
    );
    let r = i64x4::new(
        4502560675833177174,
        4501172301842258880,
        4382015632607160232,
        4561809912873379512,
    );

    assert_eq!(r, transmute(lasx_xvfmina_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmina_d() {
    let a = u64x4::new(
        4600343614636459278,
        4586078532026713744,
        4605522001302794605,
        4604680104437291828,
    );
    let b = u64x4::new(
        4606967369913508220,
        4606214846243616482,
        4587216688083732016,
        4597161583916257152,
    );
    let r = i64x4::new(
        4600343614636459278,
        4586078532026713744,
        4587216688083732016,
        4597161583916257152,
    );

    assert_eq!(r, transmute(lasx_xvfmina_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmax_s() {
    let a = u32x8::new(
        1040557328, 1056374346, 1061211328, 1043258760, 1036675480, 1065222105, 1042177632,
        1023489024,
    );
    let b = u32x8::new(
        1030428272, 1047669536, 1035741736, 1064496616, 1062615049, 1064308633, 1058514955,
        1065140306,
    );
    let r = i64x4::new(
        4537093269443945744,
        4571978153483881664,
        4575094105013893129,
        4574742780979947531,
    );

    assert_eq!(r, transmute(lasx_xvfmax_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmax_d() {
    let a = u64x4::new(
        4598455083545818248,
        4600184556479215682,
        4605785336194907924,
        4595051938027720488,
    );
    let b = u64x4::new(
        4598044308154343000,
        4602111953345143140,
        4606540384570465960,
        4602928137069840177,
    );
    let r = i64x4::new(
        4598455083545818248,
        4602111953345143140,
        4606540384570465960,
        4602928137069840177,
    );

    assert_eq!(r, transmute(lasx_xvfmax_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmaxa_s() {
    let a = u32x8::new(
        1029731152, 1046633312, 1057699093, 1057848545, 1056015154, 1053369950, 1043177732,
        1054203026,
    );
    let b = u32x8::new(
        1056523808, 1057137213, 1057627244, 1053365006, 1056989330, 1060333719, 1061877148,
        1001482496,
    );
    let r = i64x4::new(
        4540369758276109856,
        4543424905953883413,
        4554098647008043154,
        4527767521076114844,
    );

    assert_eq!(r, transmute(lasx_xvfmaxa_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmaxa_d() {
    let a = u64x4::new(
        4607057953546777183,
        4598029803916303580,
        4606768199731078735,
        4577576246859464512,
    );
    let b = u64x4::new(
        4602769751297399272,
        4606575139730018588,
        4600779924965638822,
        4596362093665607644,
    );
    let r = i64x4::new(
        4607057953546777183,
        4606575139730018588,
        4606768199731078735,
        4596362093665607644,
    );

    assert_eq!(r, transmute(lasx_xvfmaxa_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfclass_s() {
    let a = u32x8::new(
        1055311824, 1052041740, 1046016912, 1053948390, 1064758783, 1058940353, 1054333862,
        1048790772,
    );
    let r = i64x4::new(549755814016, 549755814016, 549755814016, 549755814016);

    assert_eq!(r, transmute(lasx_xvfclass_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfclass_d() {
    let a = u64x4::new(
        4601866312729243692,
        4603727160924846294,
        4581175864218244800,
        4596173124127472804,
    );
    let r = i64x4::new(128, 128, 128, 128);

    assert_eq!(r, transmute(lasx_xvfclass_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfsqrt_s() {
    let a = u32x8::new(
        1065040686, 1045332480, 1058748054, 1041454996, 1045312756, 1048325884, 1051863384,
        1061201844,
    );
    let r = i64x4::new(
        4532289266943630008,
        4522237574588618202,
        4539089286789972523,
        4566109703441416989,
    );

    assert_eq!(r, transmute(lasx_xvfsqrt_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfsqrt_d() {
    let a = u64x4::new(
        4604266936093488453,
        4603635094556032126,
        4604345755115950647,
        4595358066919885688,
    );
    let r = i64x4::new(
        4605582601319773315,
        4605187935290824484,
        4605630368329407402,
        4601138545884238765,
    );

    assert_eq!(r, transmute(lasx_xvfsqrt_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrecip_s() {
    let a = u32x8::new(
        1060913758, 1057137592, 1056500078, 1053365486, 1052072368, 1058849416, 1061191779,
        1061827646,
    );
    let r = i64x4::new(
        4610230120071696079,
        4621525987145000223,
        4598466002793312350,
        4585242601638738136,
    );

    assert_eq!(r, transmute(lasx_xvfrecip_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrecip_d() {
    let a = u64x4::new(
        4600818034032403792,
        4605811415521276862,
        4603750608638111426,
        4602783159858591242,
    );
    let r = i64x4::new(
        4612858666853570563,
        4607990995462358858,
        4609954512138978824,
        4611482062367896141,
    );

    assert_eq!(r, transmute(lasx_xvfrecip_d(transmute(a))));
}

#[simd_test(enable = "lasx,frecipe")]
unsafe fn test_lasx_xvfrecipe_s() {
    let a = u32x8::new(
        1061538089, 1009467584, 1043164316, 1030910448, 1059062619, 1048927856, 1064915194,
        1028524176,
    );
    let r = i64x4::new(
        4809660548434472067,
        4721787188318892829,
        4644815739361740708,
        4728509413412007938,
    );

    assert_eq!(r, transmute(lasx_xvfrecipe_s(transmute(a))));
}

#[simd_test(enable = "lasx,frecipe")]
unsafe fn test_lasx_xvfrecipe_d() {
    let a = u64x4::new(
        4599514006383746620,
        4607114589130093485,
        4603063439897885463,
        4602774413388259784,
    );
    let r = i64x4::new(
        4614125529786744832,
        4607216711966392320,
        4610977572161847296,
        4611499011256352768,
    );

    assert_eq!(r, transmute(lasx_xvfrecipe_d(transmute(a))));
}

#[simd_test(enable = "lasx,frecipe")]
unsafe fn test_lasx_xvfrsqrte_s() {
    let a = u32x8::new(
        1042369896, 1033402040, 1063640659, 1061099374, 1064617699, 1050687308, 1049602990,
        1047907124,
    );
    let r = i64x4::new(
        4641680627989561881,
        4581330281566770462,
        4604034110053345047,
        4612427253546066334,
    );

    assert_eq!(r, transmute(lasx_xvfrsqrte_s(transmute(a))));
}

#[simd_test(enable = "lasx,frecipe")]
unsafe fn test_lasx_xvfrsqrte_d() {
    let a = u64x4::new(
        4601640737224225970,
        4602882853441572005,
        4594899837086694432,
        4596019513190087348,
    );
    let r = i64x4::new(
        4609450077243572224,
        4608908592999825408,
        4612828109287194624,
        4612346183891812352,
    );

    assert_eq!(r, transmute(lasx_xvfrsqrte_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrint_s() {
    let a = u32x8::new(
        1043178464, 1038460040, 1061848728, 1058680620, 1058193187, 1046712064, 1061839389,
        1062791786,
    );
    let r = i64x4::new(0, 4575657222473777152, 1065353216, 4575657222473777152);

    assert_eq!(r, transmute(lasx_xvfrint_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrint_d() {
    let a = u64x4::new(
        4602995275079155807,
        4605303966018459675,
        4604656441302899118,
        4598894354395850360,
    );
    let r = i64x4::new(
        4607182418800017408,
        4607182418800017408,
        4607182418800017408,
        0,
    );

    assert_eq!(r, transmute(lasx_xvfrint_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrsqrt_s() {
    let a = u32x8::new(
        1061523868, 1058283912, 1058667997, 1055761106, 1039496312, 1051937612, 1064817002,
        1028487648,
    );
    let r = i64x4::new(
        4586992255349404714,
        4592512950478375290,
        4600512219702681066,
        4651901116840286347,
    );

    assert_eq!(r, transmute(lasx_xvfrsqrt_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrsqrt_d() {
    let a = u64x4::new(
        4605274633765138187,
        4606739923803408012,
        4600049100582648664,
        4595639907624537812,
    );
    let r = i64x4::new(
        4607751568495560074,
        4607297292863467031,
        4610247933797877877,
        4612495411087822923,
    );

    assert_eq!(r, transmute(lasx_xvfrsqrt_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvflogb_s() {
    let a = u32x8::new(
        1060538931, 1046083924, 1058790721, 1059749771, 1051275772, 1063729353, 1063250692,
        1040020680,
    );
    let r = i64x4::new(
        -4593671616705069056,
        -4647714812233515008,
        -4647714812225126400,
        -4575657218195587072,
    );

    assert_eq!(r, transmute(lasx_xvflogb_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvflogb_d() {
    let a = u64x4::new(
        4595455049368719724,
        4604388813668624941,
        4600944141083734502,
        4606323839843915451,
    );
    let r = i64x4::new(
        -4609434218613702656,
        -4616189618054758400,
        -4611686018427387904,
        -4616189618054758400,
    );

    assert_eq!(r, transmute(lasx_xvflogb_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcvth_s_h() {
    let a = i16x16::new(
        1011, -3094, -23967, -2302, -29675, 24707, 31603, 27606, -10030, -23722, -4960, 8886,
        4716, -14999, -10137, 25474,
    );
    let r = i64x4::new(
        4904525550435082240,
        5006525043206676480,
        -4562955662106198016,
        4931511963987271680,
    );

    assert_eq!(r, transmute(lasx_xvfcvth_s_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcvth_d_s() {
    let a = u32x8::new(
        1060080295, 1063430965, 1058931094, 1057151472, 1062318208, 1041069740, 1040628608,
        1062563894,
    );
    let r = i64x4::new(
        4603734568304902144,
        4602779141018746880,
        4593908495954214912,
        4605684912954015744,
    );

    assert_eq!(r, transmute(lasx_xvfcvth_d_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcvtl_s_h() {
    let a = i16x16::new(
        -18572, -3633, 26136, -30442, 5487, 21033, 2005, -18343, 32598, 19034, -13880, 19435,
        17289, 6097, -12500, -28967,
    );
    let r = i64x4::new(
        -4163050086719389696,
        -5106307920098557952,
        4704924606608883712,
        4719033540912152576,
    );

    assert_eq!(r, transmute(lasx_xvfcvtl_s_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcvtl_d_s() {
    let a = u32x8::new(
        1059008236, 1026243936, 1059912059, 1060873661, 1059957992, 1049687936, 1054458174,
        1049339368,
    );
    let r = i64x4::new(
        4603775983600795648,
        4586185783978754048,
        4604285879970693120,
        4598772185639682048,
    );

    assert_eq!(r, transmute(lasx_xvfcvtl_d_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftint_w_s() {
    let a = u32x8::new(
        1052778524, 1039011152, 1033877208, 1049693252, 1062408118, 1030474672, 1042423356,
        1038564616,
    );
    let r = i64x4::new(0, 0, 1, 0);

    assert_eq!(r, transmute(lasx_xvftint_w_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftint_l_d() {
    let a = u64x4::new(
        4592491724896152048,
        4600509745735788044,
        4603560565683465563,
        4606886496010904906,
    );
    let r = i64x4::new(0, 0, 1, 1);

    assert_eq!(r, transmute(lasx_xvftint_l_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftint_wu_s() {
    let a = u32x8::new(
        1063402225, 1023548352, 1060204123, 1061208993, 1059244058, 1039466608, 1058287960,
        1058024007,
    );
    let r = i64x4::new(1, 4294967297, 1, 4294967297);

    assert_eq!(r, transmute(lasx_xvftint_wu_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftint_lu_d() {
    let a = u64x4::new(
        4601437466420634120,
        4585269234107004032,
        4602560385055197892,
        4595388119831910552,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftint_lu_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrz_w_s() {
    let a = u32x8::new(
        1045143016, 1048815390, 1047014848, 1055489924, 1060619700, 1055895842, 1061091259,
        1052720902,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrz_w_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrz_l_d() {
    let a = u64x4::new(
        4603359584605772664,
        4597259202045947564,
        4606604696181460379,
        4590200021857252112,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrz_l_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrz_wu_s() {
    let a = u32x8::new(
        1063820452, 1055661474, 1056124138, 1058294578, 1014656512, 1017634272, 1061863649,
        1032276584,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrz_wu_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrz_lu_d() {
    let a = u64x4::new(
        4593109369482747112,
        4606352005652581516,
        4604267331764801794,
        4603828603416455704,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrz_lu_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvffint_s_w() {
    let a = i32x8::new(
        -1936685818,
        -292241542,
        -386041592,
        -1489663378,
        1127778163,
        -365070454,
        -1830468239,
        1453047639,
    );
    let r = i64x4::new(
        -3635713297473937674,
        -3552894890528992200,
        -3625938366378905329,
        5669248528000103797,
    );

    assert_eq!(r, transmute(lasx_xvffint_s_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvffint_d_l() {
    let a = i64x4::new(
        -3627358051950006798,
        3291026422392521824,
        9114456262655749128,
        -101300809730113961,
    );
    let r = i64x4::new(
        -4338888956717313783,
        4883826182423482562,
        4890802832263617419,
        -4362160337941248997,
    );

    assert_eq!(r, transmute(lasx_xvffint_d_l(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvffint_s_wu() {
    let a = u32x8::new(
        1942522276, 3012872942, 4057450175, 3500418877, 3140467966, 1802049055, 2479355692,
        3991791589,
    );
    let r = i64x4::new(
        5707068753731621139,
        5715248415876700103,
        5680959067724132285,
        5723492283472660471,
    );

    assert_eq!(r, transmute(lasx_xvffint_s_wu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvffint_d_lu() {
    let a = u64x4::new(
        10285239871254038779,
        10585860489684064217,
        15302850682570301194,
        12001223008770454391,
    );
    let r = i64x4::new(
        4891427685477873921,
        4891574472889216707,
        4893877690756836940,
        4892265567869239358,
    );

    assert_eq!(r, transmute(lasx_xvffint_d_lu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve_b() {
    let a = i8x32::new(
        -75, -65, 124, 6, 28, -41, 60, 12, -41, 91, 81, -114, 54, 98, -78, -94, 13, 26, 36,
        112, -41, -74, -94, -71, 43, 54, 17, 60, -27, -89, 98, -78,
    );
    let r = i64x4::new(
        -2893606913523066921,
        -2893606913523066921,
        -5280832617179597130,
        -5280832617179597130,
    );

    assert_eq!(r, transmute(lasx_xvreplve_b(transmute(a), 5)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve_h() {
    let a = i16x16::new(
        10589, 16925, 2072, 2556, -20735, 27162, -30076, -21408, 26095, 24700, 11691, -31646,
        14016, 23092, 1827, 2108,
    );
    let r = i64x4::new(
        719461018576357884,
        719461018576357884,
        -8907411554322709406,
        -8907411554322709406,
    );

    assert_eq!(r, transmute(lasx_xvreplve_h(transmute(a), -5)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve_w() {
    let a = i32x8::new(
        -1943637254,
        265328695,
        1624811313,
        -907897952,
        733901407,
        -598309268,
        -2022404353,
        -945690723,
    );
    let r = i64x4::new(
        1139578067980687415,
        1139578067980687415,
        -2569718735257041300,
        -2569718735257041300,
    );

    assert_eq!(r, transmute(lasx_xvreplve_w(transmute(a), 1)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve_d() {
    let a = i64x4::new(
        8108160509866679259,
        2816226171091081324,
        -7945890434069746992,
        7527726914374549897,
    );
    let r = i64x4::new(
        8108160509866679259,
        8108160509866679259,
        -7945890434069746992,
        -7945890434069746992,
    );

    assert_eq!(r, transmute(lasx_xvreplve_d(transmute(a), -6)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpermi_w() {
    let a = i32x8::new(
        1434116256,
        1142162281,
        -1871700525,
        -394957889,
        382419347,
        -785097055,
        -1928161383,
        -401992430,
    );
    let b = i32x8::new(
        -1595257764,
        1089333930,
        -235320537,
        -1276032758,
        -803245169,
        -82420548,
        -1649409266,
        665022456,
    );
    let r = i64x4::new(
        -1010694009402824022,
        -1696331215410035863,
        -7084158850976817988,
        -1726544336579699039,
    );

    assert_eq!(
        r,
        transmute(lasx_xvpermi_w::<217>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvandn_v() {
    let a = u8x32::new(
        174, 130, 100, 230, 117, 190, 128, 90, 135, 70, 67, 190, 102, 177, 131, 213, 116, 200,
        40, 62, 198, 99, 109, 141, 122, 251, 83, 215, 87, 248, 140, 29,
    );
    let b = u8x32::new(
        146, 145, 124, 157, 66, 158, 147, 40, 44, 251, 68, 171, 189, 227, 212, 251, 56, 131,
        99, 225, 136, 245, 154, 179, 245, 155, 220, 217, 4, 18, 19, 17,
    );
    let r = i64x4::new(
        2311191042782138640,
        3050136072551184680,
        3644137813819196168,
        5350223724150917,
    );

    assert_eq!(r, transmute(lasx_xvandn_v(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvneg_b() {
    let a = i8x32::new(
        -41, -111, 119, -69, 55, 67, 126, -127, -123, 59, 34, -93, -12, -33, -35, -11, 89, -72,
        -52, 6, 106, 79, 77, 58, -123, -99, 44, 27, 96, -32, -57, 75,
    );
    let r = i64x4::new(
        9188114861941944105,
        802521495600285051,
        -4128761171367671641,
        -5388239603749330053,
    );

    assert_eq!(r, transmute(lasx_xvneg_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvneg_h() {
    let a = i16x16::new(
        -4516, 26216, -27554, -11408, 20653, 18328, -4198, -15292, 23460, 9679, -8566, 23542,
        -2503, 31678, 9261, -19575,
    );
    let r = i64x4::new(
        3211184880420917668,
        4304333377225928531,
        -6626447107371719588,
        5510114370614593991,
    );

    assert_eq!(r, transmute(lasx_xvneg_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvneg_w() {
    let a = i32x8::new(
        740574678,
        2076342027,
        968647939,
        130194259,
        1872650231,
        -1690505081,
        -594724042,
        1453048102,
    );
    let r = i64x4::new(
        -8917821097720956374,
        -559180081205634307,
        7260664039039148041,
        -6240794077010148150,
    );

    assert_eq!(r, transmute(lasx_xvneg_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvneg_d() {
    let a = i64x4::new(
        -5535082554430398173,
        7802847596802572188,
        -4410306127860279470,
        906750919774206543,
    );
    let r = i64x4::new(
        5535082554430398173,
        -7802847596802572188,
        4410306127860279470,
        -906750919774206543,
    );

    assert_eq!(r, transmute(lasx_xvneg_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmuh_b() {
    let a = i8x32::new(
        -1, 124, 20, 57, 41, 122, 83, 77, 119, 119, 127, 45, 107, 51, 67, 89, 59, 88, 71, -124,
        62, 101, -53, -37, 2, 102, 69, 72, -83, 115, -102, 5,
    );
    let b = i8x32::new(
        108, -29, 45, -93, 78, -21, 19, 10, 52, 107, 104, 75, 31, -9, -27, 72, -68, -20, -102,
        95, 106, 38, -79, -7, 42, -112, -7, -41, 40, 124, 115, 91,
    );
    let r = i64x4::new(
        218131067805364735,
        1871524972886962456,
        76576697723648496,
        131228860074087168,
    );

    assert_eq!(r, transmute(lasx_xvmuh_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmuh_h() {
    let a = i16x16::new(
        16678, 11413, -27848, -7978, -31217, -4869, 11843, 2166, -13263, -23440, 16372, 27675,
        23654, 25588, -21093, 1464,
    );
    let b = i16x16::new(
        -20021, -19612, 828, 8516, 14133, -5487, -7596, 26880, -23795, 2896, 7031, 19513,
        -6376, 6003, -19930, -2328,
    );
    let r = i64x4::new(
        -291609583629571048,
        250225357332407731,
        2319361354285454031,
        -14890625691814142,
    );

    assert_eq!(r, transmute(lasx_xvmuh_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmuh_w() {
    let a = i32x8::new(
        -833159784,
        -1689012066,
        1138643536,
        1201390084,
        -1615224698,
        -984104182,
        -991848752,
        -18112020,
    );
    let b = i32x8::new(
        -846972528,
        -848270332,
        -2071563046,
        -1685604813,
        2085038950,
        696813713,
        2076492369,
        -867396671,
    );
    let r = i64x4::new(
        1432738825969009962,
        -2025068907290430086,
        -685737288172100118,
        15710306989437773,
    );

    assert_eq!(r, transmute(lasx_xvmuh_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmuh_d() {
    let a = i64x4::new(
        -3091297468664313081,
        -4254143725647386536,
        -6994439148056979459,
        878201001794537760,
    );
    let b = i64x4::new(
        -2819683255232823594,
        272893378245750433,
        -2696341058713804350,
        5752544304986593708,
    );
    let r = i64x4::new(
        472521311864415951,
        -62934014165103622,
        1022369767923424239,
        273863514955286020,
    );

    assert_eq!(r, transmute(lasx_xvmuh_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmuh_bu() {
    let a = u8x32::new(
        252, 82, 157, 236, 123, 56, 117, 92, 87, 103, 53, 123, 55, 40, 186, 21, 199, 125, 151,
        2, 152, 104, 145, 142, 138, 222, 115, 99, 79, 43, 91, 11,
    );
    let b = u8x32::new(
        106, 138, 241, 29, 35, 19, 100, 212, 48, 52, 216, 195, 63, 32, 226, 9, 68, 212, 1, 104,
        22, 101, 248, 114, 169, 245, 173, 78, 68, 135, 101, 145,
    );
    let r = i64x4::new(
        5489047988046343272,
        46167451136431120,
        4579080056940291892,
        442221464076014683,
    );

    assert_eq!(r, transmute(lasx_xvmuh_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmuh_hu() {
    let a = u16x16::new(
        63486, 10379, 4610, 59627, 39525, 8192, 13999, 30090, 39838, 4996, 62860, 23112, 32783,
        45419, 34018, 15191,
    );
    let b = u16x16::new(
        50083, 9034, 31705, 24116, 14858, 32357, 59501, 26719, 43788, 29210, 55002, 25980,
        7566, 49006, 61645, 1668,
    );
    let r = i64x4::new(
        6175852041879338372,
        3452908124314018560,
        2579100322063607801,
        108786773599653576,
    );

    assert_eq!(r, transmute(lasx_xvmuh_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmuh_wu() {
    let a = u32x8::new(
        604375860, 434631772, 87186606, 1568632560, 3782451787, 1385975439, 3741892279,
        2636678075,
    );
    let b = u32x8::new(
        2866028752, 733937737, 283660427, 1865216280, 1246451636, 3799448094, 3234768261,
        1243610100,
    );
    let r = i64x4::new(
        318992658905816335,
        2925838984554208529,
        5265941737799272199,
        3278999485098399815,
    );

    assert_eq!(r, transmute(lasx_xvmuh_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmuh_du() {
    let a = u64x4::new(
        9309142847278954140,
        11105915746381107654,
        776831405492317725,
        7350193390691079752,
    );
    let b = u64x4::new(
        6484084708453170899,
        12483776948923073243,
        16553528344993857967,
        3939779038690448735,
    );
    let r = i64x4::new(
        3272191045945883120,
        7515894102360886861,
        697104087242456940,
        1569823798457591419,
    );

    assert_eq!(r, transmute(lasx_xvmuh_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsllwil_h_b() {
    let a = i8x32::new(
        -80, -11, 36, -88, -14, -123, -124, -15, -73, 95, -109, 108, -41, -128, 74, 81, 42, 54,
        -105, 1, -17, -78, 85, 63, -18, 22, -37, 78, -116, -76, -104, -80,
    );
    let r = i64x4::new(
        -396314289023943936,
        -67281036482904288,
        4777859115647648,
        283732621893107440,
    );

    assert_eq!(r, transmute(lasx_xvsllwil_h_b::<4>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsllwil_w_h() {
    let a = i16x16::new(
        -26490, -6081, 17297, 4860, -12591, -12327, -8532, -26767, -1364, 8756, 17192, -2170,
        -9517, -24859, -20497, 19179,
    );
    let r = i64x4::new(
        -53489037427331072,
        42749012123355136,
        77018594794627072,
        -19087521822982144,
    );

    assert_eq!(r, transmute(lasx_xvsllwil_w_h::<11>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsllwil_d_w() {
    let a = i32x8::new(
        -279919227,
        1520692612,
        58332548,
        -1055411175,
        -1879666532,
        -1328702681,
        2013268804,
        1780320808,
    );
    let r = i64x4::new(
        -4586196615168,
        24915027755008,
        -30796456460288,
        -21769464725504,
    );

    assert_eq!(r, transmute(lasx_xvsllwil_d_w::<14>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsllwil_hu_bu() {
    let a = u8x32::new(
        166, 242, 65, 29, 16, 173, 110, 19, 218, 174, 141, 254, 161, 96, 39, 227, 221, 101,
        204, 143, 26, 87, 89, 20, 72, 61, 5, 44, 62, 179, 22, 150,
    );
    let r = i64x4::new(
        261217712426980544,
        171151904487768576,
        1288057531186289568,
        180156217344131904,
    );

    assert_eq!(r, transmute(lasx_xvsllwil_hu_bu::<5>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsllwil_wu_hu() {
    let a = u16x16::new(
        28185, 27375, 29501, 18099, 10709, 55262, 57183, 25962, 46284, 59737, 9967, 49646,
        20816, 18431, 34014, 61614,
    );
    let r = i64x4::new(
        1926344372325335040,
        1273603901354885120,
        4203617671699431424,
        3493526673607606272,
    );

    assert_eq!(r, transmute(lasx_xvsllwil_wu_hu::<14>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsllwil_du_wu() {
    let a = u32x8::new(
        3871859378, 2804433615, 2931671754, 4116141862, 2330569940, 549563545, 2423689534,
        763790591,
    );
    let r = i64x4::new(
        1039344337701306368,
        752809416264253440,
        625607604583792640,
        147522340803051520,
    );

    assert_eq!(r, transmute(lasx_xvsllwil_du_wu::<28>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsran_b_h() {
    let a = i16x16::new(
        -3209, -6235, 10611, -108, -9326, 31718, 21536, 23681, -6783, -12443, -19057, 16054,
        30697, -5640, -15815, -16666,
    );
    let b = i16x16::new(
        -29110, -4589, 15031, -23437, 23404, 22985, -4128, -14921, 3799, -12876, -14071,
        -20170, -30663, -21093, 2493, -19963,
    );
    let r = i64x4::new(-5107013816536599300, 0, -576745268203292981, 0);

    assert_eq!(r, transmute(lasx_xvsran_b_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsran_h_w() {
    let a = i32x8::new(
        596228330,
        -1214659999,
        1365164495,
        -1509876796,
        191976733,
        887390545,
        1777692712,
        -916491986,
    );
    let b = i32x8::new(
        325990384,
        675640582,
        253768478,
        -874708050,
        -1204136396,
        185722351,
        -1391425532,
        -614583871,
    );
    let r = i64x4::new(-7492863874014043255, 0, -5145548381371170633, 0);

    assert_eq!(r, transmute(lasx_xvsran_h_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsran_w_d() {
    let a = i64x4::new(
        8440735619768910515,
        3831375747389155813,
        -7157949860071951471,
        8075321479849390902,
    );
    let b = i64x4::new(
        -4836402813541090096,
        -5722420231286296070,
        -8822340179414145626,
        7458838578211487240,
    );
    let r = i64x4::new(58054624080, 0, 1863787881113495402, 0);

    assert_eq!(r, transmute(lasx_xvsran_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssran_b_h() {
    let a = i16x16::new(
        27446, 31312, 14232, -17034, -2200, 9528, 17283, 22858, -16583, -20644, -19786, -30210,
        -15134, -5982, 7374, -10469,
    );
    let b = i16x16::new(
        32393, 13397, -26656, -25817, -11729, -3876, 5367, 32237, -5363, 14821, 8454, -2793,
        30922, -19145, -25237, 355,
    );
    let r = i64x4::new(179865806513864501, 0, -9222296776751415043, 0);

    assert_eq!(r, transmute(lasx_xvssran_b_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssran_h_w() {
    let a = i32x8::new(
        1069406291,
        -421683701,
        -1805581192,
        775037443,
        2123240059,
        1014398272,
        -968236564,
        1181957260,
    );
    let b = i32x8::new(
        -313676516,
        794950557,
        -1459200584,
        -1233298689,
        310419478,
        2115419690,
        370441503,
        353523551,
    );
    let r = i64x4::new(281015415144451, 0, 281472829161978, 0);

    assert_eq!(r, transmute(lasx_xvssran_h_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssran_w_d() {
    let a = i64x4::new(
        -3959032103812617007,
        -6999276452061988148,
        4785867104307053316,
        -5846301556546422840,
    );
    let b = i64x4::new(
        -9038176721428294357,
        -7430682151090141786,
        3023804747709575069,
        -4263412213075666259,
    );
    let r = i64x4::new(-109363692856335914, 0, -713658208354305, 0);

    assert_eq!(r, transmute(lasx_xvssran_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssran_bu_h() {
    let a = u16x16::new(
        15557, 60840, 1956, 59995, 38025, 11411, 47465, 2661, 64580, 57024, 5440, 30131, 5746,
        43753, 23484, 38540,
    );
    let b = u16x16::new(
        22970, 29096, 60132, 33800, 43597, 36861, 5794, 9818, 31709, 42253, 40665, 26755,
        45611, 14534, 22385, 24914,
    );
    let r = i64x4::new(144116287595479055, 0, 71776131929997312, 0);

    assert_eq!(r, transmute(lasx_xvssran_bu_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssran_hu_w() {
    let a = u32x8::new(
        2082097075, 1270167653, 972125472, 2358850873, 720341052, 2316145162, 1290262192,
        3046238320,
    );
    let b = u32x8::new(
        2086901452, 208185378, 3688640302, 858280348, 2470849871, 2168901411, 1405490695,
        3256489998,
    );
    let r = i64x4::new(254837589540863, 0, 281470681765343, 0);

    assert_eq!(r, transmute(lasx_xvssran_hu_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssran_wu_d() {
    let a = u64x4::new(
        12808251596834061909,
        18221436405775299246,
        16388143564854988150,
        17532454272773126756,
    );
    let b = u64x4::new(
        5233973111979334474,
        11067258236306167045,
        5186189126720253469,
        15129384477845142857,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvssran_wu_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrarn_b_h() {
    let a = i16x16::new(
        13316, 16982, 17373, -4234, 12579, 29238, 26519, -27768, 29243, -28641, -6034, -30599,
        7597, 22800, -24346, -21360,
    );
    let b = i16x16::new(
        2182, -26731, -7280, -21775, 13607, -10194, -26196, 2085, 14341, 30747, 19786, -15409,
        13019, 31558, 333, -15416,
    );
    let r = i64x4::new(-7204067930850651184, 0, -5909457163402939758, 0);

    assert_eq!(r, transmute(lasx_xvsrarn_b_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrarn_h_w() {
    let a = i32x8::new(
        1424546002,
        -1218125754,
        2040047341,
        -1355580190,
        957370543,
        -1800756932,
        -244296865,
        -324211997,
    );
    let b = i32x8::new(
        -873611939,
        -646116137,
        -2104124404,
        269272004,
        -873453569,
        -222623147,
        -1684845205,
        1120133990,
    );
    let r = i64x4::new(4021320339558432771, 0, -5499970420202995712, 0);

    assert_eq!(r, transmute(lasx_xvsrarn_h_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrarn_w_d() {
    let a = i64x4::new(
        8313795273655551715,
        -4571575745587141829,
        3452416880072805381,
        -3498451052052081526,
    );
    let b = i64x4::new(
        1902594917407971969,
        7038774598204297904,
        1354840157561429239,
        9153650925323248775,
    );
    let r = i64x4::new(-69752906595470, 0, -7240468610764767136, 0);

    assert_eq!(r, transmute(lasx_xvsrarn_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarn_b_h() {
    let a = i16x16::new(
        30268, -30574, -1837, 13767, -29475, -25587, -27160, 25225, 4600, 30417, 28, -6434,
        -6579, 16114, -5281, -15339,
    );
    let b = i16x16::new(
        -29433, 6019, 25218, 19636, -20124, 25723, 21788, 20831, 32007, 16431, -14025, 1630,
        -8234, 9749, 12924, 11326,
    );
    let r = i64x4::new(142413695971000447, 0, -141179869986524, 0);

    assert_eq!(r, transmute(lasx_xvssrarn_b_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarn_h_w() {
    let a = i32x8::new(
        170943894,
        -1558232070,
        1056252926,
        -626239215,
        -1035289292,
        -1714887456,
        869374752,
        1218167748,
    );
    let b = i32x8::new(
        -541237538,
        -280182861,
        655685335,
        1285042104,
        -1042547864,
        -1616713045,
        901223026,
        -913984956,
    );
    let r = i64x4::new(-10414028872220672, 0, 9223104806137135104, 0);

    assert_eq!(r, transmute(lasx_xvssrarn_h_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarn_w_d() {
    let a = i64x4::new(
        -7095223716985142210,
        -1864464750390939278,
        3939082291268576295,
        652125571964745491,
    );
    let b = i64x4::new(
        -3290989318705091519,
        -1709619047887212993,
        6583279263353400787,
        -8657326507673774559,
    );
    let r = i64x4::new(2147483648, 0, 326062786704572415, 0);

    assert_eq!(r, transmute(lasx_xvssrarn_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarn_bu_h() {
    let a = u16x16::new(
        26678, 38033, 32719, 23307, 55563, 49876, 43497, 48918, 15082, 47368, 47490, 13865,
        14066, 28158, 29325, 39432,
    );
    let b = u16x16::new(
        14063, 62353, 26936, 63778, 59375, 39648, 62782, 47347, 52496, 47247, 21846, 59427,
        51935, 24463, 38090, 55890,
    );
    let r = i64x4::new(4286578689, 0, 8163878114427135, 0);

    assert_eq!(r, transmute(lasx_xvssrarn_bu_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarn_hu_w() {
    let a = u32x8::new(
        2720431924, 4147079016, 3167137960, 1370790237, 4041948877, 3496440502, 1072767482,
        2933895593,
    );
    let b = u32x8::new(
        747428871, 338187819, 2081920183, 3557659142, 2646673999, 138734404, 3410962197,
        3574237192,
    );
    let r = i64x4::new(-281474976710656, 0, 2199023255552, 0);

    assert_eq!(r, transmute(lasx_xvssrarn_hu_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarn_wu_d() {
    let a = u64x4::new(
        6490501207978917237,
        8209259321665773339,
        14187940483119607818,
        18034167934937299566,
    );
    let b = u64x4::new(
        16181569100899671009,
        7894668117654109960,
        16341906792341189640,
        4752425178296070145,
    );
    let r = i64x4::new(-3539373509, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvssrarn_wu_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrln_b_h() {
    let a = i16x16::new(
        -8859, -11711, 4363, -9439, -25357, 1884, 29173, -24389, 21528, -30451, -30750, -2629,
        -22379, -10965, 22026, 4187,
    );
    let b = i16x16::new(
        21400, -30654, 29959, 14320, 6060, -24401, -522, -8436, 27927, -10967, 11921, 19837,
        3224, 2334, 27694, -1779,
    );
    let r = i64x4::new(776589499955319005, 0, 285495199351976, 0);

    assert_eq!(r, transmute(lasx_xvsrln_b_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrln_h_w() {
    let a = i32x8::new(
        -741337180,
        -1087033752,
        1206017450,
        -177254878,
        -1655113328,
        -889941782,
        -267978430,
        1844637616,
    );
    let b = i32x8::new(
        196728630,
        -568667475,
        -273820408,
        -1204576979,
        -639636375,
        889717098,
        93317070,
        -1535736032,
    );
    let r = i64x4::new(-6090306652816735409, 0, -1175228277373752196, 0);

    assert_eq!(r, transmute(lasx_xvsrln_h_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrln_w_d() {
    let a = i64x4::new(
        -9145728687467639594,
        8409501532987558867,
        4702360266572413762,
        -3159959081500746646,
    );
    let b = i64x4::new(
        8658043654634750665,
        -5736940948870912859,
        -8385798465328465883,
        -3467766742630042131,
    );
    let r = i64x4::new(262796920316080678, 0, 1866060245111069, 0);

    assert_eq!(r, transmute(lasx_xvsrln_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrln_bu_h() {
    let a = u16x16::new(
        11222, 49369, 51083, 11755, 50527, 33895, 45751, 48397, 60912, 8893, 53498, 37814,
        34588, 16791, 58737, 47927,
    );
    let b = u16x16::new(
        44696, 19424, 49640, 20286, 46891, 46704, 50673, 49527, 19154, 6152, 25954, 33988,
        37143, 16014, 63839, 56839,
    );
    let r = i64x4::new(-996419305685, 0, -71773920038018305, 0);

    assert_eq!(r, transmute(lasx_xvssrln_bu_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrln_hu_w() {
    let a = u32x8::new(
        2345037823, 2695836952, 4130802340, 2404297034, 295813801, 2039155670, 3495629229,
        1556296817,
    );
    let b = u32x8::new(
        294807188, 58363281, 19412242, 562851868, 1581507437, 3738447960, 1843096024, 195940565,
    );
    let r = i64x4::new(2319476961249468, 0, 208855326080470286, 0);

    assert_eq!(r, transmute(lasx_xvssrln_hu_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrln_wu_d() {
    let a = u64x4::new(
        1202535702403380748,
        15707874870216391550,
        13668879554311196884,
        12302928023198114227,
    );
    let b = u64x4::new(
        1500625420116916625,
        18438653662202195541,
        12192242821332678016,
        6891738943843097628,
    );
    let r = i64x4::new(-1, 0, -1, 0);

    assert_eq!(r, transmute(lasx_xvssrln_wu_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlrn_b_h() {
    let a = i16x16::new(
        -12342, 30454, 25730, 6015, 26316, -10548, -7973, -11903, 14548, -7939, 27317, -22987,
        -25067, -26999, 30994, -21757,
    );
    let b = i16x16::new(
        31424, 29919, 27640, 2377, -27671, 6812, -24773, -17881, -24476, -13065, 24935, 4284,
        4227, 20246, -28660, -22488,
    );
    let r = i64x4::new(-6693460433276960310, 0, -6122543899663285619, 0);

    assert_eq!(r, transmute(lasx_xvsrlrn_b_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlrn_h_w() {
    let a = i32x8::new(
        48275673,
        2044228048,
        2011304917,
        727641203,
        711821092,
        1084745670,
        -1100065176,
        1918073576,
    );
    let b = i32x8::new(
        -609574414,
        559467902,
        -1150013148,
        -2027938157,
        -294433871,
        -690493396,
        1585922176,
        1450222536,
    );
    let r = i64x4::new(390723813551243448, 0, 6015496732136052023, 0);

    assert_eq!(r, transmute(lasx_xvsrlrn_h_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlrn_w_d() {
    let a = i64x4::new(
        -2014408193554501338,
        -6765353383424633305,
        5967977535334656496,
        3402886661353956602,
    );
    let b = i64x4::new(
        5950007641993014960,
        2150696278963909567,
        -4878722002685010440,
        7186750387494925249,
    );
    let r = i64x4::new(4295025675, 0, -3281590872273059757, 0);

    assert_eq!(r, transmute(lasx_xvsrlrn_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrn_bu_h() {
    let a = u16x16::new(
        4000, 26692, 55377, 5068, 29863, 20111, 65511, 27422, 7702, 63753, 34415, 139, 25413,
        7385, 60703, 6991,
    );
    let b = u16x16::new(
        60293, 44656, 25351, 5858, 32033, 34410, 41111, 15552, 22567, 60279, 27841, 635, 63102,
        61738, 21315, 12439,
    );
    let r = i64x4::new(-258385232527491, 0, 4034951496335359804, 0);

    assert_eq!(r, transmute(lasx_xvssrlrn_bu_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrn_hu_w() {
    let a = u32x8::new(
        1512713352, 3525452897, 3680819492, 4269631286, 1077814176, 4243464555, 472893356,
        2300045605,
    );
    let b = u32x8::new(
        677817847, 3453937427, 172488718, 1972766946, 1046876255, 486725940, 1920931524,
        3626282368,
    );
    let r = i64x4::new(-3854303052, 0, -4029743103, 0);

    assert_eq!(r, transmute(lasx_xvssrlrn_hu_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrn_wu_d() {
    let a = u64x4::new(
        4599848732973711922,
        15463958724268349352,
        4237045593978887151,
        9203743234400791071,
    );
    let b = u64x4::new(
        15971018346755767904,
        235976279705162838,
        15093271767346221587,
        12421981949945891560,
    );
    let r = i64x4::new(-3223981555, 0, 35952127557763071, 0);

    assert_eq!(r, transmute(lasx_xvssrlrn_wu_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrstpi_b() {
    let a = i8x32::new(
        -16, -22, -111, -51, 76, 5, -7, -91, 99, -21, 88, -22, 39, 49, 5, -92, 64, -124, 62,
        98, 108, -72, 96, -71, 50, 121, -20, -59, 69, 86, -45, -4,
    );
    let b = i8x32::new(
        34, 105, -73, 60, 0, 99, -75, -90, -92, -86, 97, 72, 28, -72, 89, 120, 9, -116, 91, 83,
        -104, 9, -13, -69, -74, 11, 0, -65, -1, -29, -117, -97,
    );
    let r = i64x4::new(
        -6487147960825943312,
        -6627837229100635390,
        -5088864803284417472,
        -228744298392422143,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfrstpi_b::<24>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrstpi_h() {
    let a = i16x16::new(
        20931, 3906, -9803, -1590, 13500, -5932, 24528, -5092, 5805, 13930, 18709, -29274,
        -4438, -28349, -16792, -12293,
    );
    let b = i16x16::new(
        25543, -11013, -16650, -29925, 4461, 18433, 13374, 9428, 26865, -4164, -13533, -10962,
        -8190, -12396, 472, 9930,
    );
    let r = i64x4::new(
        -447545208418971197,
        -1433165230546602820,
        -8239898463019854163,
        -3459962532381069654,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfrstpi_h::<10>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrstp_b() {
    let a = i8x32::new(
        -104, -22, 61, 22, 9, -98, -4, 16, 115, -71, 58, 60, -74, 82, 83, 120, 120, -76, 92,
        -20, 37, 35, -57, -10, 47, -90, -97, -3, 27, -117, 77, 75,
    );
    let b = i8x32::new(
        29, 125, -59, -37, -90, 2, -50, -85, -72, 9, 38, 58, -122, 62, 66, -25, 27, 108, -84,
        1, -6, 9, -62, 80, 77, 16, 68, 121, -110, -117, -33, 90,
    );
    let c = i8x32::new(
        122, -19, -9, 106, -21, 115, -78, 36, -91, -76, 31, -109, -81, -42, 64, 54, -42, 104,
        -10, 41, 36, -38, 119, 49, -46, 79, -83, 96, -51, 113, -126, 105,
    );
    let r = i64x4::new(
        1224026960602983064,
        8670364650262673779,
        -719974344639597448,
        5426146078386791983,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfrstp_b(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrstp_h() {
    let a = i16x16::new(
        -9233, 24063, -20305, -23399, -22605, 11453, -986, -31974, 19489, -22401, -5866,
        -32108, -8271, 27096, -1449, -1571,
    );
    let b = i16x16::new(
        -27552, -7496, 14541, 20848, -24250, -18305, -23029, -15273, -2721, -22998, 32468,
        11610, -23627, -30946, 1373, -6292,
    );
    let c = i16x16::new(
        -14010, 12802, 15942, 32257, 32320, 28150, 20653, -9131, 4498, -8203, 4826, 11234,
        -20272, 17945, -15074, 28179,
    );
    let r = i64x4::new(
        -6586038712809825297,
        -8999880904595888205,
        -9037598549398827999,
        -441921935067521103,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfrstp_h(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvshuf4i_d() {
    let a = i64x4::new(
        -8852874241090285557,
        -6166977094442369600,
        3546810114463111685,
        2862787957781039790,
    );
    let b = i64x4::new(
        7077230945960720129,
        -5857643695380455375,
        -8499609572374301387,
        9199878426816461564,
    );
    let r = i64x4::new(
        -5857643695380455375,
        -8852874241090285557,
        9199878426816461564,
        3546810114463111685,
    );

    assert_eq!(
        r,
        transmute(lasx_xvshuf4i_d::<115>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbsrl_v() {
    let a = i8x32::new(
        79, 63, 116, -13, 32, -126, 102, -10, -64, 71, -81, -118, -128, -14, 21, 13, 75, 38, 6,
        30, -2, 62, 83, 84, 37, -74, -123, 97, -18, -91, -74, 122,
    );
    let r = i64x4::new(
        -691722414719746225,
        942926330900465600,
        6076269583399265867,
        8842437361645499941,
    );

    assert_eq!(r, transmute(lasx_xvbsrl_v::<0>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvbsll_v() {
    let a = i8x32::new(
        -101, -112, 50, 67, 51, 4, 101, -35, 34, 44, 17, -5, -113, 12, 52, 63, -61, 11, -55,
        12, -55, 6, -98, -116, -104, -58, -93, -35, -18, 109, -49, 69,
    );
    let r = i64x4::new(
        -2493582200462471013,
        4554278935710477346,
        -8314200401506661437,
        5030360181484275352,
    );

    assert_eq!(r, transmute(lasx_xvbsll_v::<0>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvextrins_b() {
    let a = i8x32::new(
        17, -80, 64, 44, -72, 82, -2, 38, -55, -73, 25, 31, 4, -29, -17, -48, 104, -21, -34,
        -20, -21, 70, -35, 46, 99, -119, -21, 1, -57, -91, -18, 20,
    );
    let b = i8x32::new(
        -77, -46, -33, 123, 16, 123, -111, 58, 36, -70, 57, -6, -59, 45, -77, -82, -98, -91,
        -44, -27, -123, 108, -117, 80, 118, -39, -48, -95, 85, -53, 92, 73,
    );
    let r = i64x4::new(
        2809773906502660113,
        -3391242387545540663,
        3376932729242184552,
        1508325199364983139,
    );

    assert_eq!(
        r,
        transmute(lasx_xvextrins_b::<69>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvextrins_h() {
    let a = i16x16::new(
        -10446, -20013, -2609, -3677, 25411, -15077, 11399, 31407, -25336, 8187, 17545, 4284,
        14539, -25105, -16568, -899,
    );
    let b = i16x16::new(
        -17598, -13358, 1810, -11305, -19139, 20824, 10197, 16587, 27552, -14288, 10157,
        -25428, -25392, -10580, -28041, 20313,
    );
    let r = i64x4::new(
        2870470609909045042,
        8840333555190686531,
        -7892764466205713144,
        -252835685454628661,
    );

    assert_eq!(
        r,
        transmute(lasx_xvextrins_h::<190>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvextrins_w() {
    let a = i32x8::new(
        538640697,
        -1247440870,
        2006632382,
        -1215324238,
        -1411224161,
        -1343292937,
        -407107379,
        -1849972197,
    );
    let b = i32x8::new(
        1928001842,
        817819193,
        -1886180706,
        -2057556111,
        -1558391607,
        1824082297,
        -341759024,
        147045346,
    );
    let r = i64x4::new(
        -5357717739525968327,
        -5219777854239488066,
        -5769399231538706055,
        -7945570080736409395,
    );

    assert_eq!(
        r,
        transmute(lasx_xvextrins_w::<133>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvextrins_d() {
    let a = i64x4::new(
        -7415577103741432638,
        9028147385060226899,
        3806483413885303329,
        -8139040440396540849,
    );
    let b = i64x4::new(
        -7025567873801693340,
        8074885789654734557,
        -9150208635842546941,
        -6790202101278745327,
    );
    let r = i64x4::new(
        -7415577103741432638,
        -7025567873801693340,
        3806483413885303329,
        -9150208635842546941,
    );

    assert_eq!(
        r,
        transmute(lasx_xvextrins_d::<210>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmskltz_b() {
    let a = i8x32::new(
        123, 97, -46, 106, -84, -121, 69, 50, 76, -32, -42, 117, -89, 121, 85, 101, 103, 26,
        -117, 20, -90, 44, 126, -128, -120, 12, -28, -18, 45, 77, 45, -59,
    );
    let r = i64x4::new(5684, 0, 36244, 0);

    assert_eq!(r, transmute(lasx_xvmskltz_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmskltz_h() {
    let a = i16x16::new(
        -9300, 15427, 23501, 8110, 29557, -8385, -18123, -869, 19048, 30280, 32130, 6792, 3533,
        -19264, -7144, 21429,
    );
    let r = i64x4::new(225, 0, 96, 0);

    assert_eq!(r, transmute(lasx_xvmskltz_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmskltz_w() {
    let a = i32x8::new(
        -1225647162,
        786607282,
        -476336095,
        -591696091,
        1992561919,
        -832745020,
        1971757146,
        -1595190261,
    );
    let r = i64x4::new(13, 0, 10, 0);

    assert_eq!(r, transmute(lasx_xvmskltz_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmskltz_d() {
    let a = i64x4::new(
        1070935900765754723,
        8590124656098588796,
        2469446778159209649,
        5778474674811894997,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvmskltz_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsigncov_b() {
    let a = i8x32::new(
        88, -3, -96, 121, 86, -94, 40, 5, -55, -8, 84, 31, -93, -72, -28, 58, -87, 56, 8, 94,
        97, -72, 116, 71, 73, -21, -109, 123, 81, 125, 24, -23,
    );
    let b = i8x32::new(
        92, -37, 80, 100, 79, -105, -24, 16, -113, -66, -48, 32, 107, 11, -100, -43, 7, 99, 24,
        38, 84, -40, 55, -73, -112, 84, 59, -88, -102, 83, -65, 87,
    );
    let r = i64x4::new(
        1218339488916317532,
        -3070059025110384015,
        -5244678899168156679,
        -6215157037026399088,
    );

    assert_eq!(r, transmute(lasx_xvsigncov_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsigncov_h() {
    let a = i16x16::new(
        14096, 7677, -14561, -21692, 19661, -15938, 19461, 3041, -31532, 19690, -2669, -20964,
        -23817, -21867, 16694, -15396,
    );
    let b = i16x16::new(
        -15034, -7726, 181, 30057, -22414, -21472, 21361, 4765, -12995, -32566, 7068, -18429,
        -22953, -7497, 14762, -10184,
    );
    let r = i64x4::new(
        -8460012673615870650,
        1341320010229917810,
        5187553466109276867,
        2866604565619890601,
    );

    assert_eq!(r, transmute(lasx_xvsigncov_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsigncov_w() {
    let a = i32x8::new(
        -1256172687,
        1338321047,
        354406336,
        -462763275,
        187721986,
        -940691165,
        -1179299422,
        -1424929206,
    );
    let b = i32x8::new(
        -118338197,
        331139357,
        644951541,
        -1931633026,
        -3454036,
        -520396646,
        1909538523,
        41991994,
    );
    let r = i64x4::new(
        1422232708851806869,
        8296300675188469237,
        2235086579809602476,
        -180354238538399451,
    );

    assert_eq!(r, transmute(lasx_xvsigncov_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsigncov_d() {
    let a = i64x4::new(
        3750427451628106019,
        -1382697069711266350,
        -503292598450220754,
        -2919664281580184898,
    );
    let b = i64x4::new(
        -1642478899758371170,
        4653675866380276086,
        -6612106063359352920,
        -293290471183495768,
    );
    let r = i64x4::new(
        -1642478899758371170,
        -4653675866380276086,
        6612106063359352920,
        293290471183495768,
    );

    assert_eq!(r, transmute(lasx_xvsigncov_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmadd_s() {
    let a = u32x8::new(
        1062320727, 1052840336, 1056978973, 1021320864, 1047491708, 1057181752, 1065099904,
        1057641824,
    );
    let b = u32x8::new(
        1031536608, 1056182872, 1060915258, 1049713234, 1050950720, 1059791774, 1059318083,
        1051234082,
    );
    let c = u32x8::new(
        1061252634, 1060194113, 1034936984, 1061661636, 1060064922, 1006614016, 1059417135,
        1050039034,
    );
    let r = i64x4::new(
        4566451999453631823,
        4560361667101758314,
        4518113787508851321,
        4535521032267853298,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfmadd_s(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmadd_d() {
    let a = u64x4::new(
        4602842753634531585,
        4595402401334175048,
        4601214875019142940,
        4604030967498454410,
    );
    let b = u64x4::new(
        4598948128295145186,
        4601733706721520294,
        4603769303486824150,
        4604117155996961650,
    );
    let c = u64x4::new(
        4580452284864657312,
        4600663302047027414,
        4606609389472923777,
        4596161355449103520,
    );
    let r = i64x4::new(
        4595235980529776159,
        4602058356150948088,
        4608067122875931060,
        4603786516863404306,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfmadd_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmsub_s() {
    let a = u32x8::new(
        1053706718, 1064190592, 1065194002, 1049204796, 1058065270, 1054990514, 1052198782,
        1061344475,
    );
    let b = u32x8::new(
        1052072326, 1062946662, 1062413428, 1054564788, 1064477491, 1062331484, 1058685254,
        1048115308,
    );
    let c = u32x8::new(
        1051545776, 1052538894, 1034162080, 1012676672, 1042769032, 1060397176, 1036487208,
        1047947488,
    );
    let r = i64x4::new(
        4529410253708099330,
        4454144102220210572,
        -4706385850068449532,
        -4799792193244875572,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfmsub_s(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfmsub_d() {
    let a = u64x4::new(
        4600920645370262278,
        4606351881217070920,
        4605318237650453082,
        4606278590304909259,
    );
    let b = u64x4::new(
        4587150424227513280,
        4605394922115166652,
        4600659107885415374,
        4603309679459912257,
    );
    let c = u64x4::new(
        4599568550479871818,
        4607122878168983077,
        4594751414351299244,
        4606268515473003992,
    );
    let r = i64x4::new(
        -4624155064942819898,
        -4624913073348173037,
        4594667261719455656,
        -4622752308912416305,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfmsub_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfnmadd_s() {
    let a = u32x8::new(
        1039663832, 1061072453, 1059429769, 1055008244, 1064943875, 1031669664, 1057273263,
        1059384715,
    );
    let b = u32x8::new(
        1048864374, 1058998841, 1057533884, 1058902812, 1062707313, 1041334952, 1042897040,
        1049077472,
    );
    let c = u32x8::new(
        1059665677, 1057796240, 1060649005, 1032551792, 1054598086, 1052603136, 1052306030,
        1040847308,
    );
    let r = i64x4::new(
        -4647271481419416743,
        -4706804117592845625,
        -4701205915483756606,
        -4711770517136945317,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfnmadd_s(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfnmadd_d() {
    let a = u64x4::new(
        4604608697786889945,
        4602612366462296312,
        4601635234875928748,
        4605244074506891174,
    );
    let b = u64x4::new(
        4589783027170388200,
        4605787546878420832,
        4591185942485517728,
        4604114400983891746,
    );
    let c = u64x4::new(
        4606499207929193159,
        4602090155238640016,
        4605981237511158859,
        4603473909221104351,
    );
    let r = i64x4::new(
        -4616415827217001188,
        -4617209466841496233,
        -4617030428660783542,
        -4615713336403701073,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfnmadd_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfnmsub_s() {
    let a = u32x8::new(
        1064224098, 1059043256, 1061588698, 1059572349, 1061959798, 1042453224, 1036562968,
        1056461556,
    );
    let b = u32x8::new(
        1061205590, 1049560178, 1059192066, 1061005027, 1054917726, 1061034231, 1058796762,
        1061794461,
    );
    let c = u32x8::new(
        1025067264, 1063481799, 1058824148, 1061822410, 1057397992, 1059256144, 1059389703,
        1052234474,
    );
    let r = i64x4::new(
        4555061808459295114,
        4511379579414633985,
        4540975425961318277,
        -4846656492652873586,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfnmsub_s(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfnmsub_d() {
    let a = u64x4::new(
        4585643461608569024,
        4605011746261589541,
        4602843862374894962,
        4596919096453581616,
    );
    let b = u64x4::new(
        4603616678040017345,
        4599749349009999872,
        4603258706135001603,
        4603783118222515934,
    );
    let c = u64x4::new(
        4605444602262387771,
        4593682097024038340,
        4599004459823205548,
        4595599337151422272,
    );
    let r = i64x4::new(
        4605237590347011909,
        -4629492016214849095,
        4570217977506301115,
        4586582751878211231,
    );

    assert_eq!(
        r,
        transmute(lasx_xvfnmsub_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrne_w_s() {
    let a = u32x8::new(
        1064249874, 1024076480, 1048811302, 1045498088, 1062853975, 1050962974, 1062155621,
        1062916560,
    );
    let r = i64x4::new(1, 0, 1, 4294967297);

    assert_eq!(r, transmute(lasx_xvftintrne_w_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrne_l_d() {
    let a = u64x4::new(
        4591358556337662184,
        4604590073262881231,
        4606169601365380521,
        4596710878897869904,
    );
    let r = i64x4::new(0, 1, 1, 0);

    assert_eq!(r, transmute(lasx_xvftintrne_l_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrp_w_s() {
    let a = u32x8::new(
        1036136200, 1059809120, 1051167120, 1057100667, 1042968648, 1063707411, 1063195788,
        1061888439,
    );
    let r = i64x4::new(4294967297, 4294967297, 4294967297, 4294967297);

    assert_eq!(r, transmute(lasx_xvftintrp_w_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrp_l_d() {
    let a = u64x4::new(
        4585505041718488768,
        4601087510575360504,
        4599806583262831052,
        4595165936320641380,
    );
    let r = i64x4::new(1, 1, 1, 1);

    assert_eq!(r, transmute(lasx_xvftintrp_l_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrm_w_s() {
    let a = u32x8::new(
        1057789434, 1054177120, 1060875884, 1015620960, 1056089726, 1050746790, 1022621568,
        1056386214,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrm_w_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrm_l_d() {
    let a = u64x4::new(
        4603222821759326038,
        4603232821889844771,
        4606305215983768062,
        4597476035020392948,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrm_l_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftint_w_d() {
    let a = u64x4::new(
        4590993770331821784,
        4601838197892262822,
        4578381772647210176,
        4602974423286505396,
    );
    let b = u64x4::new(
        4598764447835256340,
        4585609299219476064,
        4605520309365062132,
        4604323432136071446,
    );
    let r = i64x4::new(0, 0, 4294967297, 4294967296);

    assert_eq!(r, transmute(lasx_xvftint_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvffint_s_l() {
    let a = i64x4::new(
        -4594969696763236122,
        -6690984686308779928,
        4592510749553568480,
        -8490928078748263946,
    );
    let b = i64x4::new(
        7654740714754719601,
        4897940113865969438,
        5957877121068211806,
        -7012236593339611923,
    );
    let r = i64x4::new(
        6811678997581428276,
        -2397684876741504398,
        -2395175097567191741,
        -2383622820954443903,
    );

    assert_eq!(r, transmute(lasx_xvffint_s_l(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrz_w_d() {
    let a = u64x4::new(
        4596886727296090208,
        4602058111141126830,
        4582692816602031424,
        4600921050551730962,
    );
    let b = u64x4::new(
        4594050684390877628,
        4605818316975650567,
        4606490477487570572,
        4599704434038566766,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrz_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrp_w_d() {
    let a = u64x4::new(
        4589404978031986168,
        4606941481982333029,
        4594924203912769356,
        4597184562267174648,
    );
    let b = u64x4::new(
        4604805957576412467,
        4605348751714663856,
        4603064242276236026,
        4597541345541924472,
    );
    let r = i64x4::new(4294967297, 4294967297, 4294967297, 4294967297);

    assert_eq!(r, transmute(lasx_xvftintrp_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrm_w_d() {
    let a = u64x4::new(
        4606666486099429909,
        4601456430561276036,
        4591400719822715992,
        4601150269438174040,
    );
    let b = u64x4::new(
        4601898131328640396,
        4603752803994862807,
        4602971578268526784,
        4607166074459830797,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrm_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrne_w_d() {
    let a = u64x4::new(
        4603578020825687150,
        4602331063342270938,
        4607074154698712999,
        4606049262608662240,
    );
    let b = u64x4::new(
        4604303573618654118,
        4605305650790770757,
        4594624155139674016,
        4597424226611516804,
    );
    let r = i64x4::new(4294967297, 1, 0, 4294967297);

    assert_eq!(
        r,
        transmute(lasx_xvftintrne_w_d(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftinth_l_s() {
    let a = u32x8::new(
        1060793948, 1047845056, 1008256256, 1062225417, 1052160478, 1061682279, 1017836000,
        1061679812,
    );
    let r = i64x4::new(0, 1, 0, 1);

    assert_eq!(r, transmute(lasx_xvftinth_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintl_l_s() {
    let a = u32x8::new(
        1049069272, 1055517436, 1058463365, 1060600954, 1053028452, 1058398899, 1062375625,
        1064635140,
    );
    let r = i64x4::new(0, 0, 0, 1);

    assert_eq!(r, transmute(lasx_xvftintl_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvffinth_d_w() {
    let a = i32x8::new(
        -158173087,
        -27800957,
        1158068870,
        278371207,
        106487733,
        -1801338365,
        -1891310322,
        -527557220,
    );
    let r = i64x4::new(
        4742644100887478272,
        4733449902607040512,
        -4477652498412208128,
        -4485741486683455488,
    );

    assert_eq!(r, transmute(lasx_xvffinth_d_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvffintl_d_w() {
    let a = i32x8::new(
        -1977997193,
        -1979528264,
        836984862,
        -201390618,
        1072540196,
        -288815065,
        -387961600,
        -174426466,
    );
    let r = i64x4::new(
        -4477288907322425344,
        -4477282485545205760,
        4742280327634878464,
        -4489746915386195968,
    );

    assert_eq!(r, transmute(lasx_xvffintl_d_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrzh_l_s() {
    let a = u32x8::new(
        1056351604, 1063464564, 1064583750, 1057296352, 1041896748, 1045603520, 1056628952,
        1057862380,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrzh_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrzl_l_s() {
    let a = u32x8::new(
        1037928632, 1054629686, 1054996640, 1060820265, 1056507210, 1065161891, 1061180536,
        1053528304,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrzl_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrph_l_s() {
    let a = u32x8::new(
        1059417377, 1040833844, 1045894588, 1063338397, 1056670958, 1064221427, 1042275464,
        1040737828,
    );
    let r = i64x4::new(1, 1, 1, 1);

    assert_eq!(r, transmute(lasx_xvftintrph_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrpl_l_s() {
    let a = u32x8::new(
        1050993336, 1043212320, 1055353974, 1052104546, 1049173258, 1052001038, 1062670733,
        1064792601,
    );
    let r = i64x4::new(1, 1, 1, 1);

    assert_eq!(r, transmute(lasx_xvftintrpl_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrmh_l_s() {
    let a = u32x8::new(
        1050100898, 1059826813, 1064587005, 1060468211, 1054982654, 1058930731, 1048352436,
        1059136196,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrmh_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrml_l_s() {
    let a = u32x8::new(
        1064932806, 1062327525, 1041996288, 1056298428, 1055943822, 1051470160, 1059582897,
        1054164774,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvftintrml_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrneh_l_s() {
    let a = u32x8::new(
        1064823377, 1059036914, 1061655628, 1036637816, 1061056914, 1057581036, 1048480136,
        1057425421,
    );
    let r = i64x4::new(1, 0, 0, 1);

    assert_eq!(r, transmute(lasx_xvftintrneh_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvftintrnel_l_s() {
    let a = u32x8::new(
        1051117486, 1064733813, 1057650292, 1054601720, 1060065354, 1042171252, 1055495904,
        1060965253,
    );
    let r = i64x4::new(0, 1, 1, 0);

    assert_eq!(r, transmute(lasx_xvftintrnel_l_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrintrne_s() {
    let a = u32x8::new(
        1042191636, 1057149553, 1054208692, 1059070307, 1043946500, 1058368204, 1065187361,
        1055502338,
    );
    let r = i64x4::new(
        4575657221408423936,
        4575657221408423936,
        4575657221408423936,
        1065353216,
    );

    assert_eq!(r, transmute(lasx_xvfrintrne_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrintrne_d() {
    let a = u64x4::new(
        4595948761324680740,
        4599917619990044612,
        4603982357523822254,
        4602664966963180606,
    );
    let r = i64x4::new(0, 0, 4607182418800017408, 0);

    assert_eq!(r, transmute(lasx_xvfrintrne_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrintrz_s() {
    let a = u32x8::new(
        1058076241, 1061463006, 1057120056, 1053378848, 1048357040, 1060603738, 1014341632,
        1064059317,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfrintrz_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrintrz_d() {
    let a = u64x4::new(
        4601618692275492658,
        4600007493587145094,
        4605876890989719085,
        4600499427656278116,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfrintrz_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrintrp_s() {
    let a = u32x8::new(
        1061637682, 1060303004, 1048139028, 1064254459, 1060496485, 1063015260, 1050062098,
        1060031891,
    );
    let r = i64x4::new(
        4575657222473777152,
        4575657222473777152,
        4575657222473777152,
        4575657222473777152,
    );

    assert_eq!(r, transmute(lasx_xvfrintrp_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrintrp_d() {
    let a = u64x4::new(
        4596277205079353652,
        4602920367780564368,
        4605931026619472063,
        4600342272679781386,
    );
    let r = i64x4::new(
        4607182418800017408,
        4607182418800017408,
        4607182418800017408,
        4607182418800017408,
    );

    assert_eq!(r, transmute(lasx_xvfrintrp_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrintrm_s() {
    let a = u32x8::new(
        1052396158, 1055096688, 1056860582, 1050315636, 1062873063, 1057089721, 1060819485,
        1031018704,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfrintrm_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfrintrm_d() {
    let a = u64x4::new(
        4593814259274657568,
        4602367426014166064,
        4595326936223928604,
        4605375676692406871,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfrintrm_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvld() {
    let a: [i8; 32] = [
        86, 26, -5, 19, -6, -100, -44, 108, -106, 70, -118, 126, 31, -112, -39, -11, -120, -25,
        -62, -45, 43, 83, 3, -116, 87, -28, -69, -91, -68, -126, -96, -88,
    ];
    let r = i64x4::new(
        7842065449049856598,
        -731394999529617770,
        -8357745035768043640,
        -6295888532317936553,
    );

    assert_eq!(r, transmute(lasx_xvld::<0>(a.as_ptr())));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvst() {
    let a = i8x32::new(
        88, 98, -23, 115, 114, -11, 37, 91, -109, 37, -83, 109, -95, -96, -38, 5, -13, 112,
        113, -80, 90, -37, -112, -76, 57, -113, -52, -109, -125, -124, -52, -18,
    );
    let mut o: [i8; 32] = [
        52, -18, -107, -17, 53, 34, 71, -16, 7, -75, -38, -105, -114, 37, 36, 62, -91, 104, 87,
        85, 74, -94, -53, -98, -77, -7, -17, 107, -9, -78, -64, -68,
    ];
    let r = i64x4::new(
        6567925503509488216,
        421826130302805395,
        -5435603567682424589,
        -1239470096778490055,
    );

    lasx_xvst::<0>(transmute(a), o.as_mut_ptr());
    assert_eq!(r, transmute(o));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvstelm_b() {
    let a = i8x32::new(
        -5, -21, 65, 59, 32, 48, -6, 103, 97, 7, 43, -113, -102, 30, -32, -75, 71, 80, 71, -83,
        73, -113, -77, 110, -111, -85, 8, 101, -41, 127, -20, 92,
    );
    let mut o: [i8; 32] = [
        -29, -20, -68, -24, 64, 3, -46, 0, -51, -114, 2, 12, 120, -127, -52, 114, -102, -91,
        -118, 57, 124, 0, -68, -77, -33, 18, -124, -23, -108, 127, -65, -18,
    ];
    let r = i64x4::new(
        59113322426723335,
        8272128968170311373,
        -5495516911757515366,
        -1243134694581333281,
    );

    lasx_xvstelm_b::<0, 9>(transmute(a), o.as_mut_ptr());
    assert_eq!(r, transmute(o));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvstelm_h() {
    let a = i16x16::new(
        -11648, -19047, -15513, 1973, 24885, -9476, 7637, 28480, 13018, 7333, -12654, 16215,
        26055, 26861, -1163, 20219,
    );
    let mut o: [i8; 32] = [
        23, 88, -111, 29, 32, 115, 1, -69, 82, 35, 2, 27, 44, -48, 117, -60, 88, 72, 106, -42,
        73, 79, 56, -63, 58, 55, -84, -49, 124, 26, -123, 64,
    ];
    let r = i64x4::new(
        -4971565931868119595,
        -4290294182150266030,
        -4523778647145166760,
        4649151313692342074,
    );

    lasx_xvstelm_h::<0, 6>(transmute(a), o.as_mut_ptr());
    assert_eq!(r, transmute(o));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvstelm_w() {
    let a = i32x8::new(
        -1636077495,
        -1913212378,
        402520069,
        1598923340,
        -615956201,
        -719313542,
        -1002278595,
        -1955360887,
    );
    let mut o: [i8; 32] = [
        -111, 55, 4, 18, 52, 121, -113, 36, -50, 17, -101, 124, -119, -45, -16, 64, 57, -59,
        -31, 29, -24, 92, 56, -72, 60, 90, 23, -26, -15, -40, -18, 75,
    ];
    let r = i64x4::new(
        2634457572879213132,
        4679472600292463054,
        -5172282020031511239,
        5471549130760739388,
    );

    lasx_xvstelm_w::<0, 3>(transmute(a), o.as_mut_ptr());
    assert_eq!(r, transmute(o));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvstelm_d() {
    let a = i64x4::new(
        -7526664681033668234,
        9215683190885160466,
        -7392730922884510993,
        8273081902285331784,
    );
    let mut o: [i8; 32] = [
        -19, -84, 7, -70, 72, -73, -100, -123, 14, -16, 82, 9, -66, -78, -112, -3, 124, 110,
        103, -66, -1, 109, 69, 70, 103, 8, -6, 99, -125, -94, 100, -56,
    ];
    let r = i64x4::new(
        -7526664681033668234,
        -175443856197488626,
        5063574301226528380,
        -4006899083251152793,
    );

    lasx_xvstelm_d::<0, 0>(transmute(a), o.as_mut_ptr());
    assert_eq!(r, transmute(o));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvinsve0_w() {
    let a = i32x8::new(
        -1106154721,
        634412656,
        -1100544436,
        -1769767887,
        -1012647261,
        2136829593,
        1072879419,
        -1993022923,
    );
    let b = i32x8::new(
        -2041359214,
        -474600924,
        276373021,
        687517976,
        -1931658504,
        392817806,
        -1316466623,
        736368242,
    );
    let r = i64x4::new(
        2724781612877310751,
        -7601095192981600692,
        -8767571060235945309,
        -8559968273390446789,
    );

    assert_eq!(
        r,
        transmute(lasx_xvinsve0_w::<5>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvinsve0_d() {
    let a = i64x4::new(
        -3740248607430046939,
        1767794107206960110,
        -9137064168958473066,
        -7852825851844941424,
    );
    let b = i64x4::new(
        431855113748835185,
        3288039304988384340,
        -5708126726787922006,
        4289161164888851504,
    );
    let r = i64x4::new(
        -3740248607430046939,
        1767794107206960110,
        -9137064168958473066,
        431855113748835185,
    );

    assert_eq!(
        r,
        transmute(lasx_xvinsve0_d::<3>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickve_w() {
    let a = i32x8::new(
        -1564826515,
        -458927896,
        1138467779,
        1659848021,
        -885088458,
        -737326650,
        -47750787,
        -414548426,
    );
    let r = i64x4::new(1138467779, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvpickve_w::<2>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickve_d() {
    let a = i64x4::new(
        8402618222187512066,
        -7057900739934826301,
        -6839567064019939265,
        8714541331515896284,
    );
    let r = i64x4::new(8402618222187512066, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvpickve_d::<0>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrn_b_h() {
    let a = i16x16::new(
        -798, 1398, -623, -4797, -18857, 26443, 16384, -16263, 21881, -27973, -23498, -9777,
        26657, -16754, 19690, 951,
    );
    let b = i16x16::new(
        -3568, 18618, 18284, -20348, 30931, -13978, -28022, 30586, 8502, -29737, 27777, 2457,
        -24560, 7519, 9137, 13151,
    );
    let r = i64x4::new(3463408299017240959, 0, 35748968851799935, 0);

    assert_eq!(r, transmute(lasx_xvssrlrn_b_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrn_h_w() {
    let a = i32x8::new(
        -709437285,
        1569944173,
        840839991,
        1276120983,
        -1380474679,
        1717565103,
        1662438257,
        41628460,
    );
    let b = i32x8::new(
        1222449199,
        -859865335,
        -1646420307,
        2051326847,
        -1328302771,
        -2115559725,
        275103578,
        95546356,
    );
    let r = i64x4::new(422210317549567, 0, 11259106657337343, 0);

    assert_eq!(r, transmute(lasx_xvssrlrn_h_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrn_w_d() {
    let a = i64x4::new(
        6389812745870818755,
        8763001741694997752,
        -1562866978917178065,
        9133752987191586761,
    );
    let b = i64x4::new(
        -7467566672980641247,
        -2330366242646492110,
        7828472137399229278,
        5811058912891800907,
    );
    let r = i64x4::new(33428474336875, 0, 9223372034707292159, 0);

    assert_eq!(r, transmute(lasx_xvssrlrn_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrln_b_h() {
    let a = i16x16::new(
        1623, -14920, 1170, 12351, -25346, 8330, 32675, 4619, -31613, -16397, 9976, -5234,
        20684, 31015, -27130, 426,
    );
    let b = i16x16::new(
        20578, -6736, -13719, -3491, 28139, 17968, -30166, 24185, -29828, 6212, 17476, 15478,
        -21520, -14119, -3397, 14549,
    );
    let r = i64x4::new(657383790217428863, 0, 941881790371430152, 0);

    assert_eq!(r, transmute(lasx_xvssrln_b_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrln_h_w() {
    let a = i32x8::new(
        -1842464126,
        -1331342000,
        -1187112242,
        453446042,
        960156121,
        -1968872136,
        -603223901,
        -1134334019,
    );
    let b = i32x8::new(
        -592357508,
        969628508,
        2062627988,
        -1366484086,
        -1901031633,
        1742501272,
        -1277076789,
        2022930291,
    );
    let r = i64x4::new(9223103287866884105, 0, 1696871892814295669, 0);

    assert_eq!(r, transmute(lasx_xvssrln_h_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrln_w_d() {
    let a = i64x4::new(
        6056280160463852946,
        3937140140114293823,
        -6849002485680852776,
        8030598250493987596,
    );
    let b = i64x4::new(
        7030461610430840286,
        3499193251729970464,
        1325445643267409553,
        -1126160333119085812,
    );
    let r = i64x4::new(3937140138060021759, 0, 9223372034707292159, 0);

    assert_eq!(r, transmute(lasx_xvssrln_w_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvorn_v() {
    let a = i8x32::new(
        -112, -60, -62, -15, 46, 34, 52, -37, 122, -78, -19, 95, -80, -17, -47, -38, 49, -4,
        -92, -111, 17, 38, 13, -58, -51, -39, -94, -58, -123, -32, 27, -12,
    );
    let b = i8x32::new(
        79, -128, 107, 13, 36, -50, 69, -31, 63, 17, -79, 95, -58, 12, 0, 94, -33, -112, -46,
        80, 57, 78, 40, 71, -44, 127, 1, 41, -79, -109, -55, 5,
    );
    let r = i64x4::new(
        -2324363183275966544,
        -288230676800471302,
        -81144131007676623,
        -126121887133672977,
    );

    assert_eq!(r, transmute(lasx_xvorn_v(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvldi() {
    let r = i64x4::new(
        -1679332213128,
        -1679332213128,
        -1679332213128,
        -1679332213128,
    );

    assert_eq!(r, transmute(lasx_xvldi::<2680>()));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvldx() {
    let a: [i8; 32] = [
        108, -99, 50, 65, 4, -113, -105, 42, 11, 14, 121, -66, -35, -37, -126, -77, -17, 83,
        -77, 28, -33, -105, -107, 20, 119, 103, 51, 7, -108, 37, -15, -93,
    ];
    let r = i64x4::new(
        3069078919512759660,
        -5511601248518205941,
        1483258636803462127,
        -6633479458433833097,
    );

    assert_eq!(r, transmute(lasx_xvldx(a.as_ptr(), 0)));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvstx() {
    let a = i8x32::new(
        -124, -113, -93, 99, -114, 45, -113, 30, 80, -29, 126, 12, -88, -106, -117, -12, 63,
        -56, -65, -120, -128, -93, -97, 117, -23, 30, -14, -37, 30, -3, 60, -58,
    );
    let mut o: [i8; 32] = [
        31, -103, -100, 104, 70, 123, -86, -93, -10, 88, 2, 88, 45, -4, 120, -23, -4, 71, -56,
        100, 122, -46, 113, 113, -106, -127, -49, 31, -4, -85, 85, -37,
    ];
    let r = i64x4::new(
        2202028832387731332,
        -825400458184039600,
        8475672796179974207,
        -4162173646616256791,
    );

    lasx_xvstx(transmute(a), o.as_mut_ptr(), 0);
    assert_eq!(r, transmute(o));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvextl_qu_du() {
    let a = u64x4::new(
        13363392893058409879,
        13062266778638186908,
        4121325568380818738,
        16525525054189099432,
    );
    let r = i64x4::new(-5083351180651141737, 0, 4121325568380818738, 0);

    assert_eq!(r, transmute(lasx_xvextl_qu_du(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvinsgr2vr_w() {
    let a = i32x8::new(
        37894851,
        6792754,
        -1258538001,
        -1755752185,
        45667801,
        270850755,
        -1397420984,
        -643296765,
    );
    let r = i64x4::new(
        29174656317668035,
        -7540898211419112465,
        1163295138520418131,
        -2762938564400051128,
    );

    assert_eq!(
        r,
        transmute(lasx_xvinsgr2vr_w::<4>(transmute(a), -596457645))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvinsgr2vr_d() {
    let a = i64x4::new(
        -8759780246633869569,
        7376911929131157332,
        8748197595361481626,
        15419583081814202,
    );
    let r = i64x4::new(
        -8759780246633869569,
        7376911929131157332,
        8748197595361481626,
        -1262509914,
    );

    assert_eq!(
        r,
        transmute(lasx_xvinsgr2vr_d::<3>(transmute(a), -1262509914))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve0_b() {
    let a = i8x32::new(
        48, -8, -123, 35, -50, -64, 25, -100, -19, -112, 93, 46, -80, 59, 28, 42, -47, -52, 18,
        -55, 50, -48, -25, -127, 97, 19, 71, -24, -71, -21, -114, -110,
    );
    let r = i64x4::new(
        3472328296227680304,
        3472328296227680304,
        3472328296227680304,
        3472328296227680304,
    );

    assert_eq!(r, transmute(lasx_xvreplve0_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve0_h() {
    let a = i16x16::new(
        412, 15338, 12582, -13132, -4679, 11713, 23076, 26826, 14471, -7190, 2282, 29936,
        25689, 11463, -14855, 18183,
    );
    let r = i64x4::new(
        115969459958317468,
        115969459958317468,
        115969459958317468,
        115969459958317468,
    );

    assert_eq!(r, transmute(lasx_xvreplve0_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve0_w() {
    let a = i32x8::new(
        1243734577,
        1718395406,
        -1635863561,
        863207308,
        71140354,
        1238191531,
        -785900261,
        -1886172704,
    );
    let r = i64x4::new(
        5341799334363128369,
        5341799334363128369,
        5341799334363128369,
        5341799334363128369,
    );

    assert_eq!(r, transmute(lasx_xvreplve0_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve0_d() {
    let a = i64x4::new(
        -7669512117913941619,
        3607794435492173678,
        6416911432565038933,
        7089802970627232981,
    );
    let r = i64x4::new(
        -7669512117913941619,
        -7669512117913941619,
        -7669512117913941619,
        -7669512117913941619,
    );

    assert_eq!(r, transmute(lasx_xvreplve0_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvreplve0_q() {
    let a = i8x32::new(
        38, -64, -93, 68, 35, 91, 48, -77, 11, -127, -113, -96, -101, 2, -106, -104, 66, 3,
        -45, 82, 95, 100, -99, 112, -127, 125, 100, 20, 17, -9, 77, -6,
    );
    let r = i64x4::new(
        -5534823735004774362,
        -7451765666000961269,
        -5534823735004774362,
        -7451765666000961269,
    );

    assert_eq!(r, transmute(lasx_xvreplve0_q(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_h_b() {
    let a = i8x32::new(
        -114, -31, -50, -82, -63, -45, 61, -97, -121, 119, 25, 112, 43, 80, 70, 86, -80, 101,
        109, -126, 58, 103, 8, -108, 124, -29, 93, -96, 26, -11, -63, 58,
    );
    let r = i64x4::new(
        -22799683568926834,
        -27302806455844927,
        31525304773640071,
        24207148650070059,
    );

    assert_eq!(r, transmute(lasx_vext2xv_h_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_w_h() {
    let a = i16x16::new(
        24818, 30826, -26283, -18137, -18647, -30298, 9378, -8000, 3374, -6396, 3703, 19569,
        25155, 17959, 16236, 26635,
    );
    let r = i64x4::new(
        132396661891314,
        -77893526906539,
        -130124624185559,
        -34359738358622,
    );

    assert_eq!(r, transmute(lasx_vext2xv_w_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_d_w() {
    let a = i32x8::new(
        -585251458,
        -2113345963,
        -1846838006,
        -474453663,
        -1394782646,
        229470412,
        1572845627,
        -904846098,
    );
    let r = i64x4::new(-585251458, -2113345963, -1846838006, -474453663);

    assert_eq!(r, transmute(lasx_vext2xv_d_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_w_b() {
    let a = i8x32::new(
        36, -56, 126, -123, -107, 6, 4, -114, -114, 112, -98, -14, 4, -112, 83, -33, 94, -20,
        -123, 85, -34, -65, -73, -33, -84, -29, 9, 42, -76, -59, -84, -18,
    );
    let r = i64x4::new(-240518168540, -528280977282, 30064770965, -489626271740);

    assert_eq!(r, transmute(lasx_vext2xv_w_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_d_h() {
    let a = i16x16::new(
        28568, -25911, 12053, -2728, -19449, -11747, -4351, 8975, -18854, 29749, -13852, 32702,
        6750, 21089, -15985, 20408,
    );
    let r = i64x4::new(28568, -25911, 12053, -2728);

    assert_eq!(r, transmute(lasx_vext2xv_d_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_d_b() {
    let a = i8x32::new(
        18, 112, -36, -67, -20, 76, -103, -91, -114, 14, -121, 115, 35, -36, -123, 13, -107,
        -52, 82, 36, 90, 43, -21, 13, -61, -84, 21, -59, 59, -116, -79, -65,
    );
    let r = i64x4::new(18, 112, -36, -67);

    assert_eq!(r, transmute(lasx_vext2xv_d_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_hu_bu() {
    let a = i8x32::new(
        38, -47, -21, -14, 36, 120, -8, -12, 76, 36, 42, 41, -54, 103, 93, 60, -6, -1, 68, -86,
        49, 60, 6, -17, -118, -56, -71, 7, 1, 79, 68, 95,
    );
    let r = i64x4::new(
        68117953694990374,
        68680959477153828,
        11540654436122700,
        16888898041348298,
    );

    assert_eq!(r, transmute(lasx_vext2xv_hu_bu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_wu_hu() {
    let a = i16x16::new(
        -31465, -19962, 4074, 27214, -1117, 19026, -8469, -13109, 19316, 5127, 15001, -32657,
        4699, 24472, 1480, -18381,
    );
    let r = i64x4::new(
        195738839581975,
        116883239997418,
        81716047838115,
        225172250484459,
    );

    assert_eq!(r, transmute(lasx_vext2xv_wu_hu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_du_wu() {
    let a = i32x8::new(
        -267466250,
        -936328606,
        -1799333696,
        1035808674,
        -2072455456,
        239819000,
        1616827243,
        740798354,
    );
    let r = i64x4::new(4027501046, 3358638690, 2495633600, 1035808674);

    assert_eq!(r, transmute(lasx_vext2xv_du_wu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_wu_bu() {
    let a = i8x32::new(
        54, -26, 32, 112, -121, 62, -95, -28, -103, -110, -103, 110, 127, -48, 101, -81, 35,
        -54, -116, 14, -97, 97, -45, 85, -18, 126, 31, 115, -59, 10, -16, -71,
    );
    let r = i64x4::new(987842478134, 481036337184, 266287972487, 979252543649);

    assert_eq!(r, transmute(lasx_vext2xv_wu_bu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_du_hu() {
    let a = i16x16::new(
        -4235, -24126, -30181, 19598, -24220, 19618, -8899, 20393, 31336, -6256, 3392, -18554,
        -31864, -32356, -15170, 18814,
    );
    let r = i64x4::new(61301, 41410, 35355, 19598);

    assert_eq!(r, transmute(lasx_vext2xv_du_hu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_vext2xv_du_bu() {
    let a = i8x32::new(
        69, 25, 36, -52, -55, 23, -66, 10, 23, 74, 121, 113, 82, 22, 49, -96, -124, 46, -78,
        72, -37, 113, 126, -115, 79, -105, -39, -110, -96, 77, -54, -35,
    );
    let r = i64x4::new(69, 25, 36, 204);

    assert_eq!(r, transmute(lasx_vext2xv_du_bu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpermi_q() {
    let a = i8x32::new(
        53, 32, -81, -96, 38, -39, 42, -111, -82, -104, -58, 101, 92, -89, -77, 71, -121, -110,
        -125, -48, 97, 91, 90, -120, 44, -98, -107, 3, -85, 64, -45, -14,
    );
    let b = i8x32::new(
        23, -5, 51, 85, 46, -5, -102, 2, -73, -121, 18, -2, 113, -122, -117, -20, -47, 84, 117,
        -17, -21, -78, -91, 69, 6, 34, -115, 73, -21, 9, -36, 92,
    );
    let r = i64x4::new(
        5018614086178788561,
        6691234052521665030,
        -8621478060979154297,
        -949343993201320404,
    );

    assert_eq!(
        r,
        transmute(lasx_xvpermi_q::<49>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpermi_d() {
    let a = i64x4::new(
        539162827834580224,
        7362188367992869351,
        1609032298240495217,
        1788653247091024267,
    );
    let r = i64x4::new(
        7362188367992869351,
        1609032298240495217,
        539162827834580224,
        1609032298240495217,
    );

    assert_eq!(r, transmute(lasx_xvpermi_d::<137>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvperm_w() {
    let a = i32x8::new(
        -708303872,
        -376964930,
        -1808535729,
        -2054828055,
        71139817,
        -306901690,
        -1914618818,
        -1977032311,
    );
    let b = i32x8::new(
        1288050919, 621948080, 1756136778, 1515604090, 408174564, 1809111645, 451808315,
        1595060072,
    );
    let r = i64x4::new(
        -3042141963552235127,
        -7767601807216087217,
        -1318132721565990423,
        -3042141963630030871,
    );

    assert_eq!(r, transmute(lasx_xvperm_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvldrepl_b() {
    let a: [i8; 32] = [
        -37, -75, -9, 68, 120, 101, -40, 41, -16, -103, 89, 95, 83, 50, -109, 30, 72, -8, 21,
        -41, -5, -67, -60, -85, 111, 105, 122, -69, -33, -5, 118, -114,
    ];
    let r = i64x4::new(
        -2604246222170760229,
        -2604246222170760229,
        -2604246222170760229,
        -2604246222170760229,
    );

    assert_eq!(r, transmute(lasx_xvldrepl_b::<0>(a.as_ptr())));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvldrepl_h() {
    let a: [i8; 32] = [
        9, 11, -106, 72, -118, -25, 63, -96, -91, -77, -71, 41, -74, -21, -12, 79, -78, -66,
        -20, -66, 5, -116, -88, 0, 7, -59, 7, 36, -83, -122, -42, -71,
    ];
    let r = i64x4::new(
        795178942675356425,
        795178942675356425,
        795178942675356425,
        795178942675356425,
    );

    assert_eq!(r, transmute(lasx_xvldrepl_h::<0>(a.as_ptr())));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvldrepl_w() {
    let a: [i8; 32] = [
        42, 19, -74, -120, -24, 115, 114, 79, 108, 51, 109, 64, -123, 115, 4, 60, -127, 78,
        -103, 44, 28, 14, 75, 19, 126, 86, -22, -55, -66, 32, -11, 112,
    ];
    let r = i64x4::new(
        -8595661765386824918,
        -8595661765386824918,
        -8595661765386824918,
        -8595661765386824918,
    );

    assert_eq!(r, transmute(lasx_xvldrepl_w::<0>(a.as_ptr())));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvldrepl_d() {
    let a: [i8; 32] = [
        -58, -81, 9, -23, -6, 105, 110, 81, 123, -99, -71, 23, 21, 18, 21, -94, 123, 120, -87,
        -27, 43, 83, 12, -68, 80, 26, 14, 64, 61, 4, -104, -45,
    ];
    let r = i64x4::new(
        5867743890882801606,
        5867743890882801606,
        5867743890882801606,
        5867743890882801606,
    );

    assert_eq!(r, transmute(lasx_xvldrepl_d::<0>(a.as_ptr())));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickve2gr_w() {
    let a = i32x8::new(
        -171617667,
        1234499290,
        -496270783,
        916647463,
        1367768596,
        -1156952470,
        172419522,
        -1633257882,
    );
    let r: i32 = 1367768596;

    assert_eq!(r, transmute(lasx_xvpickve2gr_w::<4>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickve2gr_wu() {
    let a = i32x8::new(
        -547854042,
        1057749415,
        -1081569551,
        -1895010720,
        -1615052351,
        -472405371,
        1482004122,
        -1099972589,
    );
    let r: u32 = 3194994707;

    assert_eq!(r, transmute(lasx_xvpickve2gr_wu::<7>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickve2gr_d() {
    let a = i64x4::new(
        5494820280860382649,
        -235896250341393106,
        6739870851682505277,
        -2213972721378902369,
    );
    let r: i64 = 6739870851682505277;

    assert_eq!(r, transmute(lasx_xvpickve2gr_d::<2>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickve2gr_du() {
    let a = i64x4::new(
        -3274379179178335548,
        -1748909263142723978,
        -4272175049937479582,
        -8920910898336101981,
    );
    let r: u64 = 9525833175373449635;

    assert_eq!(r, transmute(lasx_xvpickve2gr_du::<3>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_q_d() {
    let a = i64x4::new(
        -1487944422194570539,
        6635250509470966842,
        -5056614467208325955,
        -6125778217946781600,
    );
    let b = i64x4::new(
        -5984805769944216142,
        5786714665975619996,
        -2702111374414975767,
        -5035182099645850808,
    );
    let r = i64x4::new(-7472750192138786681, -1, -7758725841623301722, -1);

    assert_eq!(r, transmute(lasx_xvaddwev_q_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_d_w() {
    let a = i32x8::new(
        675098803,
        -75093512,
        -81250247,
        -121202336,
        -1671001294,
        -285443775,
        1247275542,
        1556903730,
    );
    let b = i32x8::new(
        -60118452,
        780831551,
        -1865678894,
        -1327225627,
        -1638401313,
        1476017431,
        -1866352749,
        -523966227,
    );
    let r = i64x4::new(614980351, -1946929141, -3309402607, -619077207);

    assert_eq!(r, transmute(lasx_xvaddwev_d_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_w_h() {
    let a = i16x16::new(
        22608, -32211, 15906, -27286, -31014, -22869, -2185, 30553, 0, 12445, 343, -20393,
        -7421, 12619, -32283, 25803,
    );
    let b = i16x16::new(
        -922, 25119, -27975, 3966, 7351, -30447, -29386, 20153, -8260, -10355, 15526, -17976,
        30119, 32034, -21917, 30756,
    );
    let r = i64x4::new(
        -51835960273738,
        -135592117558383,
        68161130979260,
        -232787227420502,
    );

    assert_eq!(r, transmute(lasx_xvaddwev_w_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_h_b() {
    let a = i8x32::new(
        101, 34, 41, -107, -36, -117, 4, -53, -1, -113, 85, 83, 24, -54, -19, -128, 34, 37,
        -45, 11, -78, -60, -13, 10, -97, -34, -128, 8, 88, 107, 65, -45,
    );
    let b = i8x32::new(
        -117, -119, -45, -12, -81, 85, -5, -43, 118, 117, 123, -107, 55, -109, 18, 96, -89,
        -92, -16, -107, 64, 123, 12, -1, 110, 18, -96, 77, -60, -100, -102, -47,
    );
    let r = i64x4::new(
        -498216402960,
        -281135660662667,
        -55838507063,
        -10414449598922739,
    );

    assert_eq!(r, transmute(lasx_xvaddwev_h_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_q_du() {
    let a = u64x4::new(
        10116771403081209132,
        4409447541453417390,
        898338891308675373,
        2921491360808722992,
    );
    let b = u64x4::new(
        13196093984731278668,
        13568223424734996564,
        18446645167103959087,
        1830481894073719508,
    );
    let r = i64x4::new(4866121314102936184, 1, 898239984703082844, 1);

    assert_eq!(r, transmute(lasx_xvaddwev_q_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_d_wu() {
    let a = u32x8::new(
        1198556156, 4098846235, 136525854, 1406990253, 2217403106, 390213570, 1993119836,
        1839111140,
    );
    let b = u32x8::new(
        2802853372, 1144229232, 3262242038, 3483335391, 3804489865, 583269177, 2356229233,
        699141534,
    );
    let r = i64x4::new(4001409528, 3398767892, 6021892971, 4349349069);

    assert_eq!(r, transmute(lasx_xvaddwev_d_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_w_hu() {
    let a = u16x16::new(
        6322, 31121, 27313, 37809, 33019, 46908, 8254, 44176, 58710, 48196, 24711, 20406,
        18042, 38301, 32766, 13444,
    );
    let b = u16x16::new(
        14794, 51570, 1750, 49106, 762, 47300, 64778, 26934, 42322, 39382, 42708, 58300, 788,
        59906, 54890, 41392,
    );
    let r = i64x4::new(
        124824634544764,
        313670051595253,
        289562400230056,
        376479653317006,
    );

    assert_eq!(r, transmute(lasx_xvaddwev_w_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_h_bu() {
    let a = u8x32::new(
        161, 193, 11, 51, 139, 70, 76, 148, 89, 35, 229, 97, 137, 39, 176, 219, 87, 90, 7, 151,
        124, 135, 127, 143, 231, 76, 225, 208, 193, 51, 197, 27,
    );
    let b = u8x32::new(
        60, 218, 230, 194, 245, 20, 179, 100, 21, 163, 236, 184, 84, 87, 122, 61, 25, 209, 185,
        207, 241, 56, 216, 245, 230, 103, 251, 152, 157, 115, 48, 190,
    );
    let r = i64x4::new(
        71777768344453341,
        83880492278022254,
        96547484687401072,
        68962872563859917,
    );

    assert_eq!(r, transmute(lasx_xvaddwev_h_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwev_q_d() {
    let a = i64x4::new(
        -7742993219420546326,
        -101212755683599810,
        -6868163898247798277,
        -8375244535493076926,
    );
    let b = i64x4::new(
        2520168195081268699,
        9108054891736382097,
        6081995959065773172,
        -7633503910634037993,
    );
    let r = i64x4::new(8183582659207736591, -1, 5496584216395980167, -1);

    assert_eq!(r, transmute(lasx_xvsubwev_q_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwev_d_w() {
    let a = i32x8::new(
        -331902539,
        -410274173,
        61822184,
        -21356706,
        -1286351195,
        1770474991,
        -682957064,
        -1751781451,
    );
    let b = i32x8::new(
        1613863191,
        982997422,
        -1638727663,
        -849407734,
        -68285193,
        822007285,
        144325628,
        1766216748,
    );
    let r = i64x4::new(-1945765730, 1700549847, -1218066002, -827282692);

    assert_eq!(r, transmute(lasx_xvsubwev_d_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwev_w_h() {
    let a = i16x16::new(
        28743, 20624, 20703, 30472, -4294, 10753, -24932, 2990, 15363, 6155, 32468, -23754,
        -2447, 26852, 22688, -14794,
    );
    let b = i16x16::new(
        23978, -18333, -16768, 15041, 16101, -22819, -5374, -14505, -14490, -28486, 31912,
        -14640, 9360, -7613, -27955, 24096,
    );
    let r = i64x4::new(
        160936719553181,
        -83996675428267,
        2388001846429,
        217514323726817,
    );

    assert_eq!(r, transmute(lasx_xvsubwev_w_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwev_h_b() {
    let a = i8x32::new(
        -15, -3, 45, 48, -83, -44, 39, -105, -84, -28, 100, 105, 92, -27, -25, -10, -66, 81,
        -107, 86, -125, 111, 23, -60, -67, -7, -53, 26, 114, -11, -82, -3,
    );
    let b = i8x32::new(
        -3, -39, 34, -41, 12, -46, 111, -59, 120, -86, -90, -16, -80, 110, 115, -3, 124, 93,
        -42, 74, 52, 126, -65, 28, 109, 69, -64, 67, -69, -62, -61, 39,
    );
    let r = i64x4::new(
        -19985131367563276,
        -39405757992599756,
        25050517008809794,
        -5910188531122352,
    );

    assert_eq!(r, transmute(lasx_xvsubwev_h_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwev_q_du() {
    let a = u64x4::new(
        4097334132097570986,
        3004224617145960419,
        6567223884870023457,
        342771278501784235,
    );
    let b = u64x4::new(
        11278175901218237219,
        17453302179390276683,
        10469031865427428464,
        13567003215182256574,
    );
    let r = i64x4::new(-7180841769120666233, -1, -3901807980557405007, -1);

    assert_eq!(r, transmute(lasx_xvsubwev_q_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwev_d_wu() {
    let a = u32x8::new(
        1172933923, 3561590261, 603333963, 754041205, 663327014, 1707091866, 2563659074,
        2321081680,
    );
    let b = u32x8::new(
        3703975407, 3067249102, 1688677432, 1970014868, 2563703919, 3474073919, 962829505,
        706481691,
    );
    let r = i64x4::new(-2531041484, -1085343469, -1900376905, 1600829569);

    assert_eq!(r, transmute(lasx_xvsubwev_d_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwev_w_hu() {
    let a = u16x16::new(
        59679, 17198, 28545, 44644, 31522, 21827, 19256, 56166, 8797, 57585, 50535, 47800,
        56204, 43584, 6516, 57953,
    );
    let b = u16x16::new(
        12708, 41280, 57347, 58871, 47516, 27619, 53764, 58057, 32314, 65212, 64025, 62782,
        47743, 20389, 33764, 7173,
    );
    let r = i64x4::new(
        -123703648012421,
        -148206436499066,
        -57934813879261,
        -117029268872947,
    );

    assert_eq!(r, transmute(lasx_xvsubwev_w_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwev_h_bu() {
    let a = u8x32::new(
        56, 244, 182, 253, 193, 214, 55, 239, 186, 251, 78, 32, 93, 2, 4, 132, 53, 6, 173, 35,
        84, 227, 58, 79, 196, 41, 163, 128, 246, 219, 120, 87,
    );
    let b = u8x32::new(
        90, 193, 215, 114, 199, 50, 46, 90, 225, 253, 111, 26, 28, 238, 131, 245, 47, 87, 30,
        95, 33, 50, 192, 132, 14, 240, 47, 254, 29, 155, 145, 45,
    );
    let r = i64x4::new(
        2814728290172894,
        -35747038576508967,
        -37717427826524154,
        -7035942402260810,
    );

    assert_eq!(r, transmute(lasx_xvsubwev_h_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_q_d() {
    let a = i64x4::new(
        -683494492458261228,
        -5241422472417437680,
        6650370058493421125,
        4779596395103551457,
    );
    let b = i64x4::new(
        -1623383963768224463,
        6756255500546970238,
        -7555682488592816357,
        -7648860611106928873,
    );
    let r = i64x4::new(
        5539873801618144468,
        60150126978886031,
        3692294931598396487,
        -2723954123981949807,
    );

    assert_eq!(r, transmute(lasx_xvmulwev_q_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_d_w() {
    let a = i32x8::new(
        2140792624,
        1544321576,
        1549060875,
        -630248052,
        -1129263074,
        -73878937,
        521128826,
        22556670,
    );
    let b = i32x8::new(
        -346749156,
        1202859377,
        1486656968,
        370617591,
        1270867102,
        -810144613,
        1735249190,
        -1555085961,
    );
    let r = i64x4::new(
        -742318035543025344,
        2302922143674927000,
        -1435143290249991548,
        904288373202150940,
    );

    assert_eq!(r, transmute(lasx_xvmulwev_d_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_w_h() {
    let a = i16x16::new(
        14750, -29841, -17709, -8196, 31466, 7862, -25367, -12539, 9353, 10914, -12320, -17148,
        -6831, -498, 2288, 29204,
    );
    let b = i16x16::new(
        -12026, 22388, -5312, 184, 18130, -7473, -25877, 31312, -9813, 24876, 26780, -7436,
        -15441, 11581, -22259, 14954,
    );
    let r = i64x4::new(
        404028471005501364,
        2819310417355001844,
        -1417036837779175293,
        -218736636965849761,
    );

    assert_eq!(r, transmute(lasx_xvmulwev_w_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_h_b() {
    let a = i8x32::new(
        -32, 93, 5, -3, -61, -113, 57, 15, -19, 95, 84, 13, 85, -84, 23, 37, -74, -33, -40, 52,
        9, -63, 21, 55, 68, -20, -70, -53, 117, 50, -31, 80,
    );
    let b = i8x32::new(
        7, 32, 85, -70, -87, -72, -87, 1, 26, -19, -128, 116, -6, -98, -11, -79, -19, 4, 90,
        47, 88, 112, -37, -100, -119, -82, 7, 77, -62, 76, 61, -120,
    );
    let r = i64x4::new(
        -1395811616088785120,
        -70933880974017006,
        -218702651231042178,
        -532018857412992924,
    );

    assert_eq!(r, transmute(lasx_xvmulwev_h_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_q_du() {
    let a = u64x4::new(
        3072820657428859233,
        11609640493721306675,
        12008349959063387869,
        5948138397283294636,
    );
    let b = u64x4::new(
        10527245875383164815,
        7916669328935928828,
        3031495739290315758,
        13060234924687571269,
    );
    let r = i64x4::new(
        -1534093344768443345,
        1753606948871441014,
        -1876472381986713482,
        1973424773030267173,
    );

    assert_eq!(r, transmute(lasx_xvmulwev_q_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_d_wu() {
    let a = u32x8::new(
        2949007290, 703271383, 711423165, 1456866992, 3752229871, 2536591346, 2389736494,
        3966991514,
    );
    let b = u32x8::new(
        196315048, 1279932854, 2296087324, 1350671471, 2200714021, 3470805434, 130970026,
        3503786742,
    );
    let r = i64x4::new(
        578934507688699920,
        1633489711156460460,
        8257584887124721291,
        312983850752328844,
    );

    assert_eq!(r, transmute(lasx_xvmulwev_d_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_w_hu() {
    let a = u16x16::new(
        47934, 48824, 8863, 27185, 38746, 3540, 44988, 31735, 10219, 30176, 19749, 47625, 9605,
        42752, 51816, 20943,
    );
    let b = u16x16::new(
        1352, 35948, 33502, 40543, 34675, 10670, 35261, 56591, 28340, 28503, 7709, 11425,
        35242, 32021, 61306, 37078,
    );
    let r = i64x4::new(
        1275297019994103664,
        6813200545333146478,
        653887472362785596,
        -4803214827614038190,
    );

    assert_eq!(r, transmute(lasx_xvmulwev_w_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_h_bu() {
    let a = u8x32::new(
        181, 7, 169, 169, 172, 103, 102, 36, 203, 92, 62, 74, 182, 211, 40, 13, 241, 11, 168,
        240, 139, 224, 217, 76, 58, 133, 28, 147, 22, 142, 180, 136,
    );
    let b = u8x32::new(
        247, 29, 191, 188, 209, 191, 193, 157, 228, 251, 166, 237, 216, 180, 183, 151, 51, 82,
        28, 3, 146, 77, 65, 127, 70, 150, 194, 49, 235, 0, 88, 29,
    );
    let r = i64x4::new(
        5541270789125811875,
        2060565673950885068,
        3970291708878401539,
        4458585836433706972,
    );

    assert_eq!(r, transmute(lasx_xvmulwev_h_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_q_d() {
    let a = i64x4::new(
        -4400532975246140561,
        6103963578734860361,
        6538041862964443552,
        9150349465675238484,
    );
    let b = i64x4::new(
        8731574776501689511,
        8529056615916614298,
        -5177328656834536965,
        -8950246356268516094,
    );
    let r = i64x4::new(-3813723879058076957, 0, 200103109406722390, 0);

    assert_eq!(r, transmute(lasx_xvaddwod_q_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_d_w() {
    let a = i32x8::new(
        107177346,
        1165229099,
        -1855482949,
        -1506158220,
        -530530472,
        -1932018412,
        1027697605,
        -653089829,
    );
    let b = i32x8::new(
        605852783,
        1977495085,
        71767549,
        -1079077108,
        -1117877219,
        1146297949,
        -89842401,
        1580029832,
    );
    let r = i64x4::new(3142724184, -2585235328, -785720463, 926940003);

    assert_eq!(r, transmute(lasx_xvaddwod_d_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_w_h() {
    let a = i16x16::new(
        8333, 3159, -8340, 2860, -10086, -10705, -22151, 9693, -10758, 24078, -6146, -22105,
        -9685, -11464, 1434, -10313,
    );
    let b = i16x16::new(
        24703, 26602, -11086, -20999, -31901, 27136, 3427, -26885, 13303, 12337, 32133, 9869,
        13049, -11935, 7268, -24263,
    );
    let r = i64x4::new(
        -77906411752383,
        -73839077736401,
        -52553219797441,
        -148498494282599,
    );

    assert_eq!(r, transmute(lasx_xvaddwod_w_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_h_b() {
    let a = i8x32::new(
        84, -26, 37, -73, 68, -16, -46, 83, -36, 80, -20, 61, 84, -41, 48, 23, 117, 43, -82,
        -1, -6, -5, -88, -59, -24, 126, -122, -29, -30, 41, 88, -82,
    );
    let b = i8x32::new(
        101, -60, -48, 109, 26, -30, -114, -67, 36, -33, -1, -26, 102, 46, 10, -96, 122, -84,
        121, -64, 14, -41, -110, -120, 7, -54, 69, -95, 24, -112, -75, 47,
    );
    let r = i64x4::new(
        4784877038010282,
        -20547651822747601,
        -50102739132219433,
        -9570449863999416,
    );

    assert_eq!(r, transmute(lasx_xvaddwod_h_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_q_du() {
    let a = u64x4::new(
        5678527968265482955,
        15561833412025074700,
        6604122729549136851,
        2064090124976043119,
    );
    let b = u64x4::new(
        17348958871868652420,
        3636555885647953059,
        13556112850172780139,
        15106752613120000479,
    );
    let r = i64x4::new(751645223963476143, 1, -1275901335613508018, 0);

    assert_eq!(r, transmute(lasx_xvaddwod_q_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_d_wu() {
    let a = u32x8::new(
        1981196003, 503742005, 890731178, 1132725820, 1082789967, 1773388022, 3687035574,
        2761826754,
    );
    let b = u32x8::new(
        239559029, 4254142036, 2675411124, 540730773, 3579454499, 389539593, 2282534290,
        2381309647,
    );
    let r = i64x4::new(4757884041, 1673456593, 2162927615, 5143136401);

    assert_eq!(r, transmute(lasx_xvaddwod_d_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_w_hu() {
    let a = u16x16::new(
        2281, 18176, 25719, 13571, 60992, 4744, 29330, 13668, 8334, 51018, 34330, 25476, 39478,
        10512, 18653, 36146,
    );
    let b = u16x16::new(
        12509, 23819, 52059, 39413, 59587, 22877, 24693, 50088, 16716, 29478, 46962, 20510,
        63245, 56365, 48918, 21693,
    );
    let r = i64x4::new(
        227564547253259,
        273829934951397,
        197508366154352,
        248416613500221,
    );

    assert_eq!(r, transmute(lasx_xvaddwod_w_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_h_bu() {
    let a = u8x32::new(
        60, 80, 117, 71, 182, 90, 20, 252, 34, 80, 102, 107, 49, 1, 75, 51, 175, 113, 29, 130,
        107, 245, 172, 220, 129, 144, 11, 136, 248, 112, 109, 250,
    );
    let b = u8x32::new(
        138, 100, 21, 101, 14, 54, 118, 39, 31, 118, 184, 186, 69, 89, 154, 138, 240, 210, 94,
        39, 11, 71, 157, 238, 181, 78, 88, 102, 165, 50, 235, 48,
    );
    let r = i64x4::new(
        81909836709363892,
        53199157164572870,
        128916896554221891,
        83880238860075230,
    );

    assert_eq!(r, transmute(lasx_xvaddwod_h_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwod_q_d() {
    let a = i64x4::new(
        -3945435774433072696,
        -5580639112190912700,
        -8147998114407044390,
        -4275535762638580926,
    );
    let b = i64x4::new(
        4407006886911950173,
        -7345495209927165189,
        -2920599937444079395,
        6487551432709971357,
    );
    let r = i64x4::new(1764856097736252489, 0, 7683656878360999333, -1);

    assert_eq!(r, transmute(lasx_xvsubwod_q_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwod_d_w() {
    let a = i32x8::new(
        1480945437,
        -383133422,
        -450202465,
        -1667474532,
        425467038,
        483856367,
        397851792,
        2047398851,
    );
    let b = i32x8::new(
        -1994579383,
        576791476,
        -807849214,
        -1675047435,
        1888930513,
        -1622703443,
        1826948151,
        -1929022406,
    );
    let r = i64x4::new(-959924898, 7572903, 2106559810, 3976421257);

    assert_eq!(r, transmute(lasx_xvsubwod_d_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwod_w_h() {
    let a = i16x16::new(
        17856, 7337, -32600, -17170, 20316, -23074, 3419, 31841, -19556, 25126, 32449, -4845,
        -4101, -15325, -15552, -29507,
    );
    let b = i16x16::new(
        -5321, -4306, 7409, -32016, -5351, 21871, 12529, 25151, -16361, 17466, 24705, 14901,
        -30601, 20878, 16678, -25393,
    );
    let r = i64x4::new(
        63763084488059,
        28737626132591,
        -84808424219156,
        -17665200524651,
    );

    assert_eq!(r, transmute(lasx_xvsubwod_w_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwod_h_b() {
    let a = i8x32::new(
        18, -21, -84, 117, -114, 12, 106, -85, -51, -119, -70, -63, 118, -92, 124, 114, -40,
        -12, 116, 97, 61, 0, 121, 33, 123, 85, 26, -89, 30, 99, 21, 25,
    );
    let b = i8x32::new(
        23, 122, -99, -17, -36, -51, -64, 99, 20, -7, 85, 1, 65, -15, -45, 43, -82, 77, 103,
        57, -10, 27, 105, -78, 78, 69, 75, 65, 94, -116, 22, 39,
    );
    let r = i64x4::new(
        -51791125122973839,
        20265871901523856,
        31525081430163367,
        -3939721971105776,
    );

    assert_eq!(r, transmute(lasx_xvsubwod_h_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwod_q_du() {
    let a = u64x4::new(
        14173893774454482457,
        3810444305251451895,
        11573438380633440776,
        14010021571042449665,
    );
    let b = u64x4::new(
        3850106411190823856,
        9879970351878579373,
        18286343935048656427,
        15814090293156005950,
    );
    let r = i64x4::new(-6069526046627127478, -1, -1804068722113556285, -1);

    assert_eq!(r, transmute(lasx_xvsubwod_q_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwod_d_wu() {
    let a = u32x8::new(
        3407590693, 1202785013, 1220235957, 847407948, 1753366487, 1588252312, 949725107,
        660365194,
    );
    let b = u32x8::new(
        3894489434, 440627342, 2074663244, 1619627426, 1047192238, 3243399158, 5736380,
        2062766786,
    );
    let r = i64x4::new(762157671, -772219478, -1655146846, -1402401592);

    assert_eq!(r, transmute(lasx_xvsubwod_d_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwod_w_hu() {
    let a = u16x16::new(
        5666, 61402, 18774, 63704, 5634, 763, 10164, 61056, 3316, 2644, 36526, 37166, 39369,
        62637, 25134, 63401,
    );
    let b = u16x16::new(
        42490, 58823, 51099, 26297, 14231, 33107, 29618, 35846, 40233, 15170, 7280, 21532,
        43600, 42150, 29384, 25015,
    );
    let r = i64x4::new(
        160661841644051,
        108280420467112,
        67151813660434,
        164866614644743,
    );

    assert_eq!(r, transmute(lasx_xvsubwod_w_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsubwod_h_bu() {
    let a = u8x32::new(
        52, 64, 145, 201, 179, 240, 245, 105, 232, 134, 159, 238, 112, 26, 116, 151, 98, 187,
        75, 8, 123, 231, 244, 249, 2, 61, 252, 18, 221, 229, 97, 180,
    );
    let b = u8x32::new(
        161, 161, 97, 228, 198, 212, 5, 77, 243, 42, 221, 12, 112, 20, 43, 195, 186, 156, 232,
        81, 76, 136, 175, 151, 238, 192, 18, 14, 227, 58, 213, 181,
    );
    let r = i64x4::new(
        7881423900245919,
        -12384873190653860,
        27584960029720607,
        -280740536975491,
    );

    assert_eq!(r, transmute(lasx_xvsubwod_h_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_q_d() {
    let a = i64x4::new(
        -4810434630060465465,
        4688732257687902806,
        -4456839103181700987,
        -8917453762606400882,
    );
    let b = i64x4::new(
        6208173123158669961,
        -127816522776177372,
        1052866109299034740,
        233879409784875239,
    );
    let r = i64x4::new(
        -5178962405540445672,
        -32487980047399636,
        -4213378220890601950,
        -113061080830775254,
    );

    assert_eq!(r, transmute(lasx_xvmulwod_q_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_d_w() {
    let a = i32x8::new(
        -2055655783,
        -830862243,
        -847861086,
        -336854390,
        -1217543653,
        -1512465773,
        -1029760180,
        696500116,
    );
    let b = i32x8::new(
        1867516505,
        -867512649,
        533129786,
        1783687399,
        -1192533976,
        1399910380,
        -1289839662,
        -1915471625,
    );
    let r = i64x4::new(
        720783505379011707,
        -600842930740831610,
        -2117316535017423740,
        -1334126209007208500,
    );

    assert_eq!(r, transmute(lasx_xvmulwod_d_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_w_h() {
    let a = i16x16::new(
        -11721, 24971, -11669, 16270, -6825, 11583, 26517, -2001, -9346, -14979, 6799, -913,
        32665, 19801, 21245, 3779,
    );
    let b = i16x16::new(
        -22224, -12256, 16952, -4627, -11217, 527, 18001, -14755, -27194, 17253, -12454,
        -27169, 32549, 32431, 24685, 20780,
    );
    let r = i64x4::new(
        -323330674561769120,
        126807857153516721,
        106537943419101521,
        337273560374881751,
    );

    assert_eq!(r, transmute(lasx_xvmulwod_w_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_h_b() {
    let a = i8x32::new(
        95, 23, -127, -44, -50, -2, -107, -94, 28, -90, 111, -51, -6, 84, -14, 63, 28, 31,
        -120, 33, -68, -22, 49, 85, -42, 36, -99, -60, 119, -39, 55, -81,
    );
    let b = i8x32::new(
        -76, -123, 85, -8, 61, 68, -54, 35, 75, 25, -10, 41, -88, 30, 106, 13, -47, 51, 14, 52,
        -61, 53, -114, -91, -69, 3, -27, -105, -56, 89, -97, 35,
    );
    let r = i64x4::new(
        -925771782493768461,
        230538833401607990,
        -2176932477699619283,
        -797714991416606612,
    );

    assert_eq!(r, transmute(lasx_xvmulwod_h_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_q_du() {
    let a = u64x4::new(
        7091632338891003648,
        3739044658401562681,
        17715177360220060439,
        15881729055260995184,
    );
    let b = u64x4::new(
        3957896596496566926,
        14072319404382751448,
        8435476695188152907,
        13452684919273724788,
    );
    let r = i64x4::new(
        6176011447065373208,
        2852374949748893805,
        5535184026733238976,
        -6864651532066967840,
    );

    assert_eq!(r, transmute(lasx_xvmulwod_q_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_d_wu() {
    let a = u32x8::new(
        2766740249, 1667577703, 3569036313, 1579235215, 3396253061, 2456107502, 1991409426,
        75424938,
    );
    let b = u32x8::new(
        3618661585, 2352411935, 3028582487, 1023986068, 3092028317, 3835802450, 3486468402,
        2263667528,
    );
    let r = i64x4::new(
        3922829691077085305,
        1617114858254984620,
        -9025600900074571716,
        170736982952013264,
    );

    assert_eq!(r, transmute(lasx_xvmulwod_d_wu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_w_hu() {
    let a = u16x16::new(
        55236, 28771, 53988, 52341, 33854, 22292, 10394, 61333, 4522, 48545, 32239, 37616,
        60335, 27122, 32053, 14922,
    );
    let b = u16x16::new(
        64490, 59642, 2029, 25643, 55072, 32592, 44282, 23992, 17266, 4336, 3878, 44058, 48161,
        63520, 51113, 10126,
    );
    let r = i64x4::new(
        5764620336637638830,
        6320050114866848320,
        7117988002098042608,
        648970298882764352,
    );

    assert_eq!(r, transmute(lasx_xvmulwod_w_hu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_h_bu() {
    let a = u8x32::new(
        34, 239, 30, 169, 91, 195, 107, 97, 212, 207, 110, 55, 238, 210, 149, 21, 238, 150, 4,
        49, 158, 137, 81, 246, 145, 164, 238, 229, 151, 250, 105, 19,
    );
    let b = u8x32::new(
        109, 186, 165, 193, 216, 121, 71, 232, 9, 233, 215, 188, 234, 112, 250, 183, 159, 61,
        140, 67, 64, 225, 148, 142, 58, 178, 120, 106, 37, 216, 186, 161,
    );
    let r = i64x4::new(
        6334414217787583910,
        1081809353807543399,
        -8614127794670853186,
        861263883582730760,
    );

    assert_eq!(r, transmute(lasx_xvmulwod_h_bu(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_d_wu_w() {
    let a = u32x8::new(
        1465537318, 1382340624, 1603365560, 1355400303, 145165353, 3595116789, 4194509835,
        314900647,
    );
    let b = i32x8::new(
        -2079155596,
        -637150629,
        -1781445929,
        -2000249885,
        1523945572,
        -1514431741,
        -1149336021,
        1501805778,
    );
    let r = i64x4::new(-613618278, -178080369, 1669110925, 3045173814);

    assert_eq!(
        r,
        transmute(lasx_xvaddwev_d_wu_w(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_w_hu_h() {
    let a = u16x16::new(
        748, 28718, 22726, 4135, 23777, 12746, 33222, 13229, 5619, 33293, 48512, 19489, 24736,
        5690, 53405, 55687,
    );
    let b = i16x16::new(
        8622, -30951, -14339, -27770, -7815, -8146, 31809, -9126, -16637, 3437, 23015, 376,
        -964, 9550, -5336, -25533,
    );
    let r = i64x4::new(
        36021890720922,
        279306018242138,
        307210420737270,
        206454782975196,
    );

    assert_eq!(
        r,
        transmute(lasx_xvaddwev_w_hu_h(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_h_bu_b() {
    let a = u8x32::new(
        88, 218, 182, 176, 220, 158, 136, 109, 143, 78, 151, 35, 3, 38, 106, 192, 31, 178, 127,
        52, 28, 247, 210, 133, 22, 228, 225, 177, 65, 2, 28, 171,
    );
    let b = i8x32::new(
        -1, 67, 111, 96, 125, 14, -82, -67, -93, -127, 85, -72, 20, -47, 83, -13, -87, -111,
        27, -75, 125, 39, 93, 89, 25, 66, -76, -14, -52, -50, 43, -81,
    );
    let r = i64x4::new(
        15201130525294679,
        53198869398028338,
        85287575083483080,
        19984779190796335,
    );

    assert_eq!(
        r,
        transmute(lasx_xvaddwev_h_bu_b(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_d_wu_w() {
    let a = u32x8::new(
        1117566668, 2171866262, 3863150800, 2917715295, 3911708395, 1228484642, 2321269874,
        4261467450,
    );
    let b = i32x8::new(
        298065186,
        1000727430,
        -1974818719,
        -2115019739,
        1124007321,
        786270369,
        -898501534,
        600072896,
    );
    let r = i64x4::new(
        333107716764820248,
        -7629022514159825200,
        4396788873597159795,
        -2085664542616986716,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmulwev_d_wu_w(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_w_hu_h() {
    let a = u16x16::new(
        22502, 13622, 44730, 46411, 64382, 64178, 62884, 38859, 27367, 39034, 18915, 47916,
        24716, 55834, 5119, 58864,
    );
    let b = i16x16::new(
        21292, -10920, 292, 28750, -26856, 28754, -1172, -21835, 20852, -32278, -12338, 25813,
        -10142, -19321, -22247, 30137,
    );
    let r = i64x4::new(
        56097255526935944,
        -316539293307705904,
        -1002330561839921236,
        -489121149480921704,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmulwev_w_hu_h(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_h_bu_b() {
    let a = u8x32::new(
        64, 87, 43, 223, 59, 110, 8, 116, 204, 242, 108, 218, 63, 128, 143, 210, 147, 184, 202,
        200, 78, 84, 158, 241, 147, 241, 17, 99, 53, 113, 83, 131,
    );
    let b = i8x32::new(
        59, 34, 117, 84, 8, -46, -24, -51, 38, -14, -14, 47, -52, 32, -19, -121, 65, 44, 108,
        -40, -89, 15, -31, 88, -51, 75, 71, -50, -15, -77, -11, -98,
    );
    let r = i64x4::new(
        -54041167974166848,
        -764500102863118776,
        -1378412775185308333,
        -256708593179958601,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmulwev_h_bu_b(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_d_wu_w() {
    let a = u32x8::new(
        2842977577, 726151833, 3624948328, 3635170403, 2399571401, 2980175388, 1959530649,
        2789073224,
    );
    let b = i32x8::new(
        1477701582,
        -1440126406,
        -1077662088,
        60551123,
        287903770,
        -1406443306,
        1729475940,
        1185250387,
    );
    let r = i64x4::new(-713974573, 3695721526, 1573732082, 3974323611);

    assert_eq!(
        r,
        transmute(lasx_xvaddwod_d_wu_w(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_w_hu_h() {
    let a = u16x16::new(
        15858, 62454, 8143, 63292, 12915, 37488, 58571, 3762, 9835, 37317, 31941, 1155, 43404,
        17532, 22889, 49328,
    );
    let b = i16x16::new(
        -10821, -16732, 3696, -6656, 20270, 19108, -9737, 3921, -19713, 14465, -4985, 8060,
        19692, -13193, -8849, 8523,
    );
    let r = i64x4::new(
        243249767821978,
        32998233791764,
        39578123684422,
        248468153045235,
    );

    assert_eq!(
        r,
        transmute(lasx_xvaddwod_w_hu_h(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_h_bu_b() {
    let a = u8x32::new(
        207, 56, 245, 126, 208, 205, 19, 229, 182, 28, 85, 188, 132, 80, 149, 101, 93, 95, 56,
        213, 181, 220, 90, 139, 206, 87, 97, 213, 245, 152, 219, 209,
    );
    let b = i8x32::new(
        30, -46, -91, 101, 47, -13, 3, -11, -106, 65, 62, 83, 92, -28, -71, 122, 15, -84, -19,
        -97, -128, -82, 28, -105, 111, -73, 119, -25, 7, 76, 54, 72,
    );
    let r = i64x4::new(
        61362369571520522,
        62769143162536029,
        9570741921251339,
        79095447720558606,
    );

    assert_eq!(
        r,
        transmute(lasx_xvaddwod_h_bu_b(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_d_wu_w() {
    let a = u32x8::new(
        3988094295, 3678296912, 2524886697, 507830363, 60676336, 2042142864, 911246321,
        2627081751,
    );
    let b = i32x8::new(
        -1423964992,
        -300941917,
        -1300830690,
        301547719,
        -728801849,
        1812067428,
        -1853372246,
        1459690332,
    );
    let r = i64x4::new(
        -1106953723992460304,
        153135087601591997,
        3700500567177033792,
        3834725833308331332,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmulwod_d_wu_w(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_w_hu_h() {
    let a = u16x16::new(
        22867, 24578, 38420, 43680, 56323, 53684, 33271, 54214, 382, 37378, 51385, 11786, 9873,
        685, 59607, 7054,
    );
    let b = i16x16::new(
        14263, 1867, -4762, 7093, 9219, 14229, 23256, -2657, -24665, -648, 14592, -26979,
        12560, 28471, -30607, 30723,
    );
    let r = i64x4::new(
        1330676388419350166,
        -618675426746189372,
        -1365690048421401872,
        930805492797249067,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmulwod_w_hu_h(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_h_bu_b() {
    let a = u8x32::new(
        106, 63, 35, 106, 240, 140, 62, 226, 24, 172, 209, 236, 201, 120, 85, 107, 133, 48,
        166, 220, 124, 12, 206, 73, 77, 93, 122, 44, 170, 245, 79, 125,
    );
    let b = i8x32::new(
        49, -59, 51, -69, -83, 90, 118, 66, -127, -31, -92, -123, 22, -96, 127, -91, 103, 27,
        111, -67, 79, 32, 36, 51, -18, -108, -123, -57, -30, 14, -66, -118,
    );
    let r = i64x4::new(
        4198534873019773307,
        -2740489848885548244,
        1047932990890181904,
        -4151741170613692220,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmulwod_h_bu_b(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhaddw_q_d() {
    let a = i64x4::new(
        7195063412416833019,
        -7198414538777237107,
        3618874101468146190,
        5075453792844537994,
    );
    let b = i64x4::new(
        -4177888634615683669,
        159708792916303045,
        -493012886919538920,
        -3327952250593224264,
    );
    let r = i64x4::new(7070440900316630840, -1, 4582440905924999074, 0);

    assert_eq!(r, transmute(lasx_xvhaddw_q_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhaddw_qu_du() {
    let a = u64x4::new(
        14174115972304041760,
        11184692435390355059,
        6036753630285484734,
        16987794702390801127,
    );
    let b = u64x4::new(
        919078441558396978,
        520168700921507198,
        13672733098019829533,
        11854214779067813220,
    );
    let r = i64x4::new(-6342973196760799579, 0, -6232960347008472572, 1);

    assert_eq!(r, transmute(lasx_xvhaddw_qu_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhsubw_q_d() {
    let a = i64x4::new(
        671584889846600733,
        8179701147067091777,
        8820752382384406910,
        -8816577614727005023,
    );
    let b = i64x4::new(
        2862152648469207935,
        4714581857093657849,
        3474818266521795377,
        -2843283552126606269,
    );
    let r = i64x4::new(5317548498597883842, 0, 6155348192460751216, -1);

    assert_eq!(r, transmute(lasx_xvhsubw_q_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvhsubw_qu_du() {
    let a = u64x4::new(
        15891261469744917624,
        6124172835044839452,
        13470444488722494141,
        514760401991858000,
    );
    let b = u64x4::new(
        6113118953514320833,
        14909065838985392334,
        1730613981074135290,
        11653977149369645375,
    );
    let r = i64x4::new(11053881530518619, 0, -1215853579082277290, -1);

    assert_eq!(r, transmute(lasx_xvhsubw_qu_du(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_q_d() {
    let a = i64x4::new(
        6851852253375557634,
        -687859074247996461,
        -2847020890783636723,
        -3396011480229435207,
    );
    let b = i64x4::new(
        4881265308617523092,
        -6946920457192015262,
        2620975855235645060,
        -3109202070840153061,
    );
    let c = i64x4::new(
        8576064979838144125,
        4734381367362523796,
        1223742651533162362,
        -6069819910741619678,
    );
    let r = i64x4::new(
        -8703171595748273338,
        1581487120574302805,
        942353693594667509,
        -3222137980934690913,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_q_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_d_w() {
    let a = i64x4::new(
        4283476221971713520,
        5997311160552489534,
        -7461538125080812198,
        584666845411625444,
    );
    let b = i32x8::new(
        -1699017988,
        -1597461813,
        1949179714,
        -22329469,
        -25282868,
        -1833476595,
        -712935020,
        -1228584225,
    );
    let c = i32x8::new(
        1933742369,
        -902774021,
        1152039469,
        -966950160,
        -2014121439,
        -847909444,
        205263209,
        533619002,
    );
    let r = i64x4::new(
        998013152882979948,
        8242843123254621400,
        -7410615358602605146,
        438327515397946264,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_d_w(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_w_h() {
    let a = i32x8::new(
        -497197979,
        2128466895,
        1827806706,
        -1515704287,
        1900959403,
        -10679846,
        1566686168,
        -747997169,
    );
    let b = i16x16::new(
        13631, 27024, -7774, -32582, 29199, 15396, -401, -17852, 10337, 15890, -26044, 11510,
        10732, 3619, 18520, -7838,
    );
    let c = i16x16::new(
        24759, -9415, -26783, -18619, 13757, -17352, 16725, -25610, 14981, 21116, 23650,
        -18473, 13862, 20053, 3522, -18723,
    );
    let r = i64x4::new(
        -8410788748874544018,
        -6538705505380766203,
        -2691314320519116016,
        -2932473655038329632,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_w_h(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_h_b() {
    let a = i16x16::new(
        -2623, -5568, -5250, 8004, 12247, 20872, 32727, 17906, -11062, -13097, -29604, 32623,
        -13541, 1792, -32288, 28892,
    );
    let b = i8x32::new(
        -8, 40, -69, 8, -104, 45, -81, 60, -52, -13, -3, -37, 77, 20, 76, -82, -102, 112, 71,
        -10, -62, 75, 112, 96, 49, -67, 98, 67, -118, -51, -77, 67,
    );
    let c = i8x32::new(
        -40, 23, 23, 75, -24, -86, -52, -98, 74, -106, -3, -8, -40, 43, 31, -7, -120, -68,
        -122, -119, 103, 59, 49, -2, -77, 113, 119, 80, 101, -6, 116, 33,
    );
    let r = i64x4::new(
        3438767965960271617,
        5703373312375201999,
        -7719324334317042534,
        5618332147678887006,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_h_b(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_q_du() {
    let a = u64x4::new(
        11023906961007219829,
        13619495672295375563,
        7572980537071490433,
        10145709682911964133,
    );
    let b = u64x4::new(
        1145103061481704635,
        2210139848484195129,
        8860436254952346498,
        12573896192036293152,
    );
    let c = u64x4::new(
        17650249419725637273,
        9888846271395867734,
        14715851951823475494,
        14739680783109267384,
    );
    let r = i64x4::new(
        -6602489221663665608,
        -3731588670586723767,
        4220731810419531981,
        -1232639684640242354,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_q_du(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_d_wu() {
    let a = u64x4::new(
        8055198384779363938,
        9925260815913558465,
        6835430604549063591,
        15441192025398831710,
    );
    let b = u32x8::new(
        1867493599, 3245935582, 1629087126, 1061202312, 3389402698, 3034357496, 1394979327,
        2925040328,
    );
    let c = u32x8::new(
        1765089209, 2899492783, 2529172711, 2742597877, 1149322351, 3557681406, 3462656435,
        2152082771,
    );
    let r = i64x4::new(
        -7095252889458714487,
        -4401240554875374565,
        -7715797191809385027,
        1824782095017799339,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_d_wu(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_w_hu() {
    let a = u32x8::new(
        4068171594, 513777862, 1662628135, 150786756, 3404482708, 1100545508, 1296617840,
        2568385675,
    );
    let b = u16x16::new(
        9976, 32227, 62018, 53049, 21882, 59596, 30529, 48620, 19006, 49187, 50174, 12259,
        3616, 50420, 60433, 40578,
    );
    let c = u16x16::new(
        34105, 44006, 33269, 34929, 41783, 55207, 10361, 3583, 20219, 63815, 58487, 18415,
        9646, 27639, 14059, 7949,
    );
    let r = i64x4::new(
        -7378378399913155454,
        2006169455487925341,
        -1116240736353519778,
        -3766489066592466128,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_w_hu(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_h_bu() {
    let a = u16x16::new(
        54677, 20231, 5485, 25733, 3289, 32970, 11379, 23649, 29852, 32207, 10148, 12942,
        13168, 40138, 12570, 48782,
    );
    let b = u8x32::new(
        83, 24, 36, 206, 232, 251, 52, 50, 21, 26, 144, 30, 118, 81, 232, 118, 197, 143, 213,
        244, 155, 125, 186, 64, 225, 178, 192, 14, 230, 216, 201, 105,
    );
    let c = u8x32::new(
        66, 75, 68, 238, 158, 103, 71, 149, 162, 2, 116, 125, 70, 2, 36, 29, 7, 16, 38, 243,
        166, 196, 122, 253, 77, 64, 67, 156, 8, 203, 49, 225,
    );
    let r = i64x4::new(
        8282582185414224635,
        9007565081835870755,
        -8416510656124192257,
        -1943522820234774755,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_h_bu(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_q_d() {
    let a = i64x4::new(
        9157238656205642393,
        -8031082356106754985,
        -4372970903210999763,
        -8400782536501424126,
    );
    let b = i64x4::new(
        -2947828926389048030,
        286858961466620958,
        -7198913950768528345,
        -4558524846284502477,
    );
    let c = i64x4::new(
        -8966978539573787816,
        5965781064088812819,
        6785842876481166596,
        8957716835940181125,
    );
    let r = i64x4::new(
        8877886904970852051,
        -7938310550223636451,
        -7469536578939176788,
        7832347329765892515,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_q_d(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_d_w() {
    let a = i64x4::new(
        3501241531332783035,
        968696574349111989,
        1223338638204507697,
        5231578199334978816,
    );
    let b = i32x8::new(
        1210545902,
        706290701,
        -1971714524,
        2103465668,
        -305785715,
        -218897263,
        280223963,
        -838568119,
    );
    let c = i32x8::new(
        -949605894,
        -1724400178,
        172821226,
        2123929230,
        -909785648,
        1230257751,
        620207705,
        1402502047,
    );
    let r = i64x4::new(
        2283313720808638257,
        5436308790915787629,
        954038583726072184,
        4055484695888539223,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_d_w(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_w_h() {
    let a = i32x8::new(
        -598204125,
        -531177195,
        1076911560,
        259752194,
        -1069455958,
        -916568789,
        -1193369377,
        1159492541,
    );
    let b = i16x16::new(
        10650, -5211, -12808, -28115, -27527, 6937, -16741, 16285, -6142, -7067, -10826, -6660,
        -22889, -25629, -3527, -6119,
    );
    let c = i16x16::new(
        16852, -6030, -13801, 9261, 24273, 26563, 11733, -28445, 25099, 14402, -23168, -31577,
        25012, 1004, -19731, -30323,
    );
    let r = i64x4::new(
        -3399682261363746659,
        -873916884449488685,
        -3033389236009017420,
        5776898425431129891,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_w_h(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_h_b() {
    let a = i16x16::new(
        -2829, -7831, 1134, 23799, 31864, -8205, -20884, 2782, -724, -8414, 10611, 31362,
        15971, -25563, 3175, -6328,
    );
    let b = i8x32::new(
        112, 116, -120, 74, -42, 25, 1, 19, 51, 102, -40, -73, -28, 14, -45, -57, -17, -77,
        -111, -98, -9, 114, -32, -69, 45, -122, -65, 56, -78, 21, 111, -19,
    );
    let c = i8x32::new(
        59, 63, -124, -50, -52, 12, 38, 62, 77, -127, 76, -78, 64, -80, -5, 28, 110, -44, -100,
        45, -43, 62, 66, 112, -49, -120, 123, -18, 34, -119, -20, -74,
    );
    let r = i64x4::new(
        7030406655824433535,
        334016295025592798,
        6652455533761006184,
        -1385416929418315885,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_h_b(transmute(a), transmute(b), transmute(c)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_q_du() {
    let a = u64x4::new(
        1898209592653721751,
        10926860906964806867,
        18361012878168580252,
        14644115162811948975,
    );
    let b = u64x4::new(
        1945372576834807415,
        5117230234174825110,
        14390591298317442216,
        9089518245930555118,
    );
    let c = u64x4::new(
        17504435078500289086,
        15243444480193333955,
        7810225885258468877,
        13257884975254190749,
    );
    let r = i64x4::new(
        1757588433868711129,
        -3291266200231780782,
        95766916559772818,
        2730111333315477935,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_q_du(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_d_wu() {
    let a = u64x4::new(
        2715769757208659525,
        2216806074012029777,
        6525838187075271506,
        15876394068735907698,
    );
    let b = u32x8::new(
        3928005420, 3020795031, 3881759315, 3226709793, 1296481505, 1362116053, 1131484424,
        3814393787,
    );
    let c = u32x8::new(
        2745998525, 4219603367, 1735962907, 3082063756, 2410634838, 3360953922, 2094521244,
        1329875844,
    );
    let r = i64x4::new(
        -2984417432676422714,
        -6285012695561959331,
        -7342896596084770244,
        2502320151861337310,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_d_wu(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_w_hu() {
    let a = u32x8::new(
        2005770472, 418747954, 1467912967, 68663314, 284343496, 1733214400, 2615496661,
        3890476135,
    );
    let b = u16x16::new(
        58498, 2430, 4588, 20804, 7171, 26934, 39619, 36043, 59802, 43896, 1388, 64198, 49922,
        4660, 8826, 1254,
    );
    let c = u16x16::new(
        17893, 61614, 2263, 35439, 2530, 16965, 34585, 18123, 54862, 61539, 38281, 59547,
        42561, 50393, 65080, 29977,
    );
    let r = i64x4::new(
        4965072004097651852,
        3100410633753647765,
        5416148797706570800,
        -1575823510936973847,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_w_hu(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_h_bu() {
    let a = u16x16::new(
        36194, 9930, 14883, 39417, 2438, 15023, 58620, 33090, 16572, 36810, 21479, 35773,
        33259, 56285, 62068, 46564,
    );
    let b = u8x32::new(
        34, 125, 103, 16, 211, 122, 70, 50, 215, 127, 193, 64, 67, 238, 249, 121, 154, 248, 31,
        26, 187, 25, 188, 191, 248, 214, 207, 40, 155, 190, 91, 127,
    );
    let c = u8x32::new(
        67, 32, 89, 53, 76, 235, 37, 230, 178, 122, 2, 56, 126, 94, 210, 6, 69, 2, 54, 188, 23,
        253, 185, 113, 97, 190, 149, 34, 20, 7, 214, 32,
    );
    let r = i64x4::new(
        -4114695625116050174,
        -8928319877028035060,
        -2302345889489730900,
        -4195956656687996737,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_h_bu(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_q_du_d() {
    let a = i64x4::new(
        7904206285198314726,
        -1225358394899025904,
        5806604712820367446,
        -4659173034171397511,
    );
    let b = u64x4::new(
        6100446525668817642,
        10688882673264876757,
        1423085255226033079,
        13938405669196411480,
    );
    let c = i64x4::new(
        -8389902415543029131,
        -8632894406175228839,
        2642929561135509190,
        -3267299416902109004,
    );
    let r = i64x4::new(
        6198441987982339544,
        -3999948362488217274,
        7993947555517161952,
        -4455282630855544942,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_q_du_d(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_d_wu_w() {
    let a = i64x4::new(
        -3676091534899840180,
        -2004073272115093645,
        5676581346203765904,
        8270698864684440208,
    );
    let b = u32x8::new(
        397399052, 3551436848, 2738656943, 743389966, 3499899009, 2260562895, 1875038063,
        133906470,
    );
    let c = i32x8::new(
        512699397,
        -586471006,
        -81269365,
        -1769533728,
        2120410562,
        -2111545843,
        -1045820519,
        -2113967596,
    );
    let r = i64x4::new(
        -3472345280571068536,
        -2226642182825544840,
        -5348939902888852654,
        6309745584493025511,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_d_wu_w(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_w_hu_h() {
    let a = i32x8::new(
        -1456024465,
        1292205813,
        -1759432335,
        -548381486,
        1089611198,
        478189353,
        -1368461698,
        -1240728243,
    );
    let b = u16x16::new(
        65391, 50824, 24841, 10069, 30833, 20379, 53070, 4097, 15307, 38738, 30453, 47989,
        55589, 23759, 34121, 44875,
    );
    let c = i16x16::new(
        -28613, 8390, 29884, 18408, -17696, -3658, 16755, 18613, 24281, -18, -26803, 16674,
        -7826, -21398, -12825, 21830,
    );
    let r = i64x4::new(
        8738343996720489220,
        1463752189638585937,
        -1451881076969873711,
        -7208372751461990044,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_w_hu_h(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwev_h_bu_b() {
    let a = i16x16::new(
        -2899, -28885, 21233, 25414, 18986, 27436, 5272, 11999, -21932, -7709, -1809, -22022,
        19152, 6809, 3926, 23920,
    );
    let b = u8x32::new(
        60, 166, 243, 60, 101, 145, 58, 139, 11, 119, 37, 242, 205, 208, 21, 14, 69, 216, 114,
        226, 255, 0, 96, 241, 247, 89, 59, 46, 160, 208, 252, 246,
    );
    let c = i8x32::new(
        -37, 73, -80, 20, 87, 34, -43, -125, -37, -126, -19, -52, -10, 38, -55, -26, 4, 79,
        -59, 3, -48, -97, 73, -126, -122, 84, -108, 90, -73, 123, 53, 51,
    );
    let r = i64x4::new(
        6451535402254461953,
        3052328487586973843,
        -4225844162003621016,
        -7954234670014147302,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwev_h_bu_b(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_q_du_d() {
    let a = i64x4::new(
        5040785179692297413,
        -5698968703706500445,
        -731068043920228861,
        3965235820245190976,
    );
    let b = u64x4::new(
        10854493275645220911,
        16138982903185851834,
        5339741244155318123,
        14666659343881516356,
    );
    let c = i64x4::new(
        3608705967944035653,
        2602681461334264776,
        2583771862194956886,
        -8807004962159335926,
    );
    let r = i64x4::new(
        2112387857800094741,
        -3421893061573111304,
        -7025246865660777813,
        -3037048219893810668,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_q_du_d(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_d_wu_w() {
    let a = i64x4::new(
        -6548782426860122444,
        -5512378810555054389,
        -8313251399158871596,
        -2631108805874731030,
    );
    let b = u32x8::new(
        3411181446, 4063156506, 4162056821, 1798829201, 223212533, 2591023005, 958942780,
        723906610,
    );
    let c = i32x8::new(
        -1601726534,
        -337872632,
        396528058,
        691753867,
        2049925652,
        -947032016,
        -1272465465,
        -802105137,
    );
    let r = i64x4::new(
        -7921611809770266236,
        -4268031754690784122,
        7679710934623151940,
        -3211758016463986600,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_d_wu_w(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_w_hu_h() {
    let a = i32x8::new(
        29411709, -487241679, -445814375, -898026796, 1702472835, 1332407325, 428234819,
        36330620,
    );
    let b = u16x16::new(
        6115, 7084, 54578, 41741, 10808, 9353, 62741, 13372, 25833, 45511, 2751, 162, 49362,
        49913, 10572, 63054,
    );
    let c = i16x16::new(
        -4084, 19702, -31174, 24313, 27489, -17948, -4193, -6492, -20772, 11511, 15075, -18053,
        -30409, 25187, -9190, -5069,
    );
    let r = i64x4::new(
        2266055901231345861,
        -4229846225082649443,
        5710084886827853700,
        -1216721738864979826,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_w_hu_h(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmaddwod_h_bu_b() {
    let a = i16x16::new(
        -31362, 19310, 4398, 21644, -18947, -19503, 21298, 6464, -22249, 24001, 29448, 11657,
        -25193, -16348, 5631, 18801,
    );
    let b = u8x32::new(
        255, 169, 91, 69, 97, 249, 150, 91, 30, 132, 219, 186, 87, 159, 227, 164, 250, 45, 9,
        167, 101, 32, 191, 101, 124, 84, 2, 10, 146, 179, 65, 134,
    );
    let c = i8x32::new(
        -69, 4, -26, 80, -124, 33, 78, -58, -13, -100, 88, -23, 70, 18, 48, -30, -81, 4, 29,
        -53, 118, 123, 7, 51, 27, 62, -41, -75, 114, 101, -44, 93,
    );
    let r = i64x4::new(
        4606673651486328866,
        434701133187613293,
        4731174792733829579,
        8799854033754305007,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmaddwod_h_bu_b(
            transmute(a),
            transmute(b),
            transmute(c)
        ))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrotr_b() {
    let a = i8x32::new(
        -76, -66, -50, 116, 83, -40, -66, 16, 118, -125, 54, 31, 77, -105, -66, 96, 81, -86,
        -10, 31, -90, 37, 33, -20, 68, -9, -69, -76, -120, 95, 49, -94,
    );
    let b = i8x32::new(
        91, -91, -119, -120, 66, -54, 8, -3, -118, -6, -52, -20, 13, 106, -107, -104, -59, -50,
        31, 106, -25, -35, 115, 62, -31, 120, 59, -89, 7, 35, -100, -87,
    );
    let r = i64x4::new(
        -9169831505165814378,
        6986742644414341277,
        -5538256227715405174,
        5842271601646106402,
    );

    assert_eq!(r, transmute(lasx_xvrotr_b(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrotr_h() {
    let a = i16x16::new(
        -391, -26680, -19180, 8374, -10657, 16157, 18976, -9288, -10450, 9732, 26117, 31925,
        20483, -14847, -1605, 8796,
    );
    let b = i16x16::new(
        -24978, -7031, 20444, 9930, -18507, -2797, 10351, -20863, 2342, -7299, 397, -8738,
        -6411, 11173, 25086, -9162,
    );
    let r = i64x4::new(
        3280961714933987815,
        7916365250426044082,
        -948799184442377380,
        8109266518466894464,
    );

    assert_eq!(r, transmute(lasx_xvrotr_h(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrotr_w() {
    let a = i32x8::new(
        807443288, 659305929, 215715568, 461653638, 1156975794, -140043152, 572930522,
        -305210344,
    );
    let b = i32x8::new(
        425095120, 2007398487, 1779876326, 867842254, -355714240, 1021676577, 2008058921,
        -149962463,
    );
    let r = i64x4::new(
        -7463711091125112800,
        1880373866945277499,
        8922631659077373106,
        8567937817891640092,
    );

    assert_eq!(r, transmute(lasx_xvrotr_w(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrotr_d() {
    let a = i64x4::new(
        1798291896688439472,
        -8678294225084614636,
        -3360425612013625394,
        6141382649032010789,
    );
    let b = i64x4::new(
        -4687895735595482806,
        7366925603772764024,
        113747709542135138,
        -4369447114926223278,
    );
    let r = i64x4::new(
        3172290282099188988,
        -8034032776515152761,
        8319107233083774893,
        4254025119287920211,
    );

    assert_eq!(r, transmute(lasx_xvrotr_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvadd_q() {
    let a = i64x4::new(
        -2609166907920397576,
        4277631384595295751,
        -6908798269010317006,
        5982715628809494048,
    );
    let b = i64x4::new(
        -8390221664220170851,
        5630840603034329774,
        -482468290988389688,
        -4276184844647827597,
    );
    let r = i64x4::new(
        7447355501568983189,
        -8538272086079926090,
        -7391266559998706694,
        1706530784161666452,
    );

    assert_eq!(r, transmute(lasx_xvadd_q(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsub_q() {
    let a = i64x4::new(
        5635628360514667431,
        8563800808356171400,
        -8195308523117763518,
        3653510787018366900,
    );
    let b = i64x4::new(
        2471979813421155001,
        4980523206404219656,
        5227116936323454967,
        2410762289023585517,
    );
    let r = i64x4::new(
        3163648547093512430,
        3583277601951951744,
        5024318614268333131,
        1242748497994781383,
    );

    assert_eq!(r, transmute(lasx_xvsub_q(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwev_q_du_d() {
    let a = u64x4::new(
        11512774700636858764,
        3877920437650491653,
        5348767768447622976,
        10610828160678410847,
    );
    let b = i64x4::new(
        4538357695196601706,
        962354258063947537,
        461386020283085419,
        -3214659782190620189,
    );
    let r = i64x4::new(-2395611677876091146, 0, 5810153788730708395, 0);

    assert_eq!(
        r,
        transmute(lasx_xvaddwev_q_du_d(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvaddwod_q_du_d() {
    let a = u64x4::new(
        2811249209376266688,
        65866753992142741,
        10134352057937866409,
        17378632901315704999,
    );
    let b = i64x4::new(
        771717384571916075,
        -6276542900978063061,
        -782791668238120654,
        -4337892955900394734,
    );
    let r = i64x4::new(-6210676146985920320, -1, -5406004128294241351, 0);

    assert_eq!(
        r,
        transmute(lasx_xvaddwod_q_du_d(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwev_q_du_d() {
    let a = u64x4::new(
        1631079386587456680,
        4565265601922112419,
        5351621054404189773,
        12518175210587903555,
    );
    let b = i64x4::new(
        7907402685955854803,
        -6034016436240875818,
        -1692667855436677787,
        857071248435905820,
    );
    let r = i64x4::new(
        -9215090926608146824,
        699180379527824028,
        8322461491295210849,
        -491063186927300825,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmulwev_q_du_d(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmulwod_q_du_d() {
    let a = u64x4::new(
        16516519389168658270,
        11550123424719201061,
        18023411584703351911,
        5733925898426927381,
    );
    let b = i64x4::new(
        -1630542181497141953,
        -8299748862195853267,
        -3768558747736596235,
        -8223031783298003100,
    );
    let r = i64x4::new(
        8208983644526863745,
        -5196750351687252927,
        2416926856050984756,
        -2556020440107861891,
    );

    assert_eq!(
        r,
        transmute(lasx_xvmulwod_q_du_d(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmskgez_b() {
    let a = i8x32::new(
        3, -116, -122, 1, -82, 30, 73, 60, 22, 102, -51, -22, 59, 125, -61, -78, 89, 25, 31,
        107, 111, 27, -119, -90, 119, 49, -86, -82, 1, -113, -8, -40,
    );
    let r = i64x4::new(13289, 0, 4927, 0);

    assert_eq!(r, transmute(lasx_xvmskgez_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvmsknz_b() {
    let a = i8x32::new(
        52, -33, -37, -47, -126, -26, -42, -37, -96, 90, -32, 25, 62, -95, 114, 53, -88, -66,
        -49, -31, -126, -89, -92, 127, -113, -43, 41, 40, -79, 108, -63, -57,
    );
    let r = i64x4::new(65535, 0, 65535, 0);

    assert_eq!(r, transmute(lasx_xvmsknz_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvexth_h_b() {
    let a = i8x32::new(
        86, 82, -64, 55, 99, -98, 18, 55, 53, -101, -88, -23, 101, -32, -7, -69, -92, 77, 92,
        -110, 99, 46, 88, -36, 84, 42, 42, -1, -24, -95, -48, -7,
    );
    let r = i64x4::new(
        -6192823156408267,
        -19140324188225435,
        -281294585331628,
        -1689051729887256,
    );

    assert_eq!(r, transmute(lasx_xvexth_h_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvexth_w_h() {
    let a = i16x16::new(
        -22892, -26139, 11053, 11772, -13928, 20772, 16551, -20590, -10608, 9266, 29842,
        -10111, -3519, 29175, 10737, -27281,
    );
    let r = i64x4::new(
        89219355625880,
        -88433376608089,
        125309965824577,
        -117171002791439,
    );

    assert_eq!(r, transmute(lasx_xvexth_w_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvexth_d_w() {
    let a = i32x8::new(
        -825627036,
        -1996938691,
        78514216,
        -1063299454,
        257564527,
        -138481584,
        -1487536177,
        1875317589,
    );
    let r = i64x4::new(78514216, -1063299454, -1487536177, 1875317589);

    assert_eq!(r, transmute(lasx_xvexth_d_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvexth_q_d() {
    let a = i64x4::new(
        5979507577341197552,
        5196480214883180720,
        -8000060569264941491,
        7776492634988202392,
    );
    let r = i64x4::new(5196480214883180720, 0, 7776492634988202392, 0);

    assert_eq!(r, transmute(lasx_xvexth_q_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvexth_hu_bu() {
    let a = u8x32::new(
        47, 59, 186, 7, 161, 218, 234, 101, 186, 179, 42, 250, 253, 76, 169, 142, 127, 7, 4,
        56, 123, 5, 152, 53, 224, 98, 177, 197, 49, 13, 16, 40,
    );
    let r = i64x4::new(
        70368924578021562,
        39970172547367165,
        55451330627633376,
        11259067788754993,
    );

    assert_eq!(r, transmute(lasx_xvexth_hu_bu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvexth_wu_hu() {
    let a = u16x16::new(
        11201, 3109, 64518, 58951, 32582, 32792, 2605, 46256, 28808, 30095, 54960, 26138,
        39952, 56608, 20537, 49215,
    );
    let r = i64x4::new(
        140840567603014,
        198668007246381,
        243129508731920,
        211376815493177,
    );

    assert_eq!(r, transmute(lasx_xvexth_wu_hu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvexth_du_wu() {
    let a = u32x8::new(
        1580507769, 1550554068, 3486710391, 717721410, 434913819, 742461632, 1954296323,
        1406265475,
    );
    let r = i64x4::new(3486710391, 717721410, 1954296323, 1406265475);

    assert_eq!(r, transmute(lasx_xvexth_du_wu(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvexth_qu_du() {
    let a = u64x4::new(
        15671254659731561180,
        6305760528044738869,
        3619266805555730982,
        3857202168052068182,
    );
    let r = i64x4::new(6305760528044738869, 0, 3857202168052068182, 0);

    assert_eq!(r, transmute(lasx_xvexth_qu_du(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrotri_b() {
    let a = i8x32::new(
        37, 16, -44, -97, 31, 23, 58, -46, 3, -22, 31, -79, 59, -102, -113, 89, -12, 97, -16,
        -83, -69, -115, 127, -110, -107, -36, -16, -51, 26, 48, -58, -4,
    );
    let r = i64x4::new(
        3288597436994224466,
        -7640170181100982736,
        3024123976131483215,
        -3500418816657076903,
    );

    assert_eq!(r, transmute(lasx_xvrotri_b::<4>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrotri_h() {
    let a = i16x16::new(
        8999, -7250, -4236, 2845, 21265, -24726, -14769, -11915, -12193, 28179, 16866, -23983,
        -11259, 31467, -30522, 8490,
    );
    let r = i64x4::new(
        1601837713137157710,
        -6707112604456344030,
        4945941697313284287,
        4779464405959485451,
    );

    assert_eq!(r, transmute(lasx_xvrotri_h::<15>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrotri_w() {
    let a = i32x8::new(
        1273906952,
        1323123989,
        -1657206810,
        -758313569,
        30529353,
        -1084318195,
        470709136,
        -1831448763,
    );
    let r = i64x4::new(
        -6725603050124640824,
        -5477967444476451040,
        -4487859208269579718,
        -1679179889808014898,
    );

    assert_eq!(r, transmute(lasx_xvrotri_w::<11>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrotri_d() {
    let a = i64x4::new(
        -6269890993217399490,
        4900582678319344510,
        4744796290155065976,
        7326839228001128846,
    );
    let r = i64x4::new(
        1530846727385147611,
        3134017167653815720,
        -5586642937907364280,
        -7958311692822812825,
    );

    assert_eq!(r, transmute(lasx_xvrotri_d::<16>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvextl_q_d() {
    let a = i64x4::new(
        -4167783494125842132,
        -8818287186975390348,
        7476993593286219399,
        362651956781912161,
    );
    let r = i64x4::new(-4167783494125842132, -1, 7476993593286219399, 0);

    assert_eq!(r, transmute(lasx_xvextl_q_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlni_b_h() {
    let a = i8x32::new(
        -122, -57, 103, 68, 81, 117, 10, -11, 85, 78, 51, -68, 17, 5, 57, 15, 82, -13, -58, 32,
        -126, -109, -28, -108, -90, -102, -13, -26, 80, 87, 44, 12,
    );
    let b = i8x32::new(
        107, 49, -98, -36, -98, 81, 126, -15, 96, 112, 83, 75, 70, 12, -92, -96, 119, -26, -75,
        9, -68, 107, 80, 126, -58, 38, -112, 85, 36, -27, 17, -109,
    );
    let r = i64x4::new(
        775944073576565014,
        -913733859716807048,
        3554001380194360167,
        -4434515480828965835,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrlni_b_h::<4>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlni_h_w() {
    let a = i16x16::new(
        7707, -22772, -29741, -9919, -14059, 17567, -31900, -30801, -21839, 26160, 23241,
        -17751, 11400, 21178, -10087, -1621,
    );
    let b = i16x16::new(
        26329, -6694, -20485, 30132, 26844, -6674, 8539, 29251, -25304, -9125, -8199, 29075,
        25395, -30076, -29212, -25696,
    );
    let r = i64x4::new(
        8233677356103165402,
        -8669635304329468148,
        -7232628700111184805,
        -456179975298914768,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrlni_h_w::<16>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlni_w_d() {
    let a = i32x8::new(
        -406185034,
        -895467686,
        -717037773,
        -469050531,
        -1539233593,
        -1778247886,
        -1546187185,
        -2026338244,
    );
    let b = i32x8::new(
        -446056064,
        -1691954961,
        -981213165,
        -458936270,
        -1860231155,
        2056121344,
        1905674092,
        45485615,
    );
    let r = i64x4::new(
        2975767411517832185,
        195580534167951033,
        -5943753303447109596,
        -3593292886058873687,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrlni_w_d::<26>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlni_d_q() {
    let a = i64x4::new(
        7597626924148193039,
        8987414085353164021,
        -3181901883582161412,
        -5484978136186304133,
    );
    let b = i64x4::new(
        3950632511964740415,
        1415609115522181708,
        3151552885247761103,
        -4372710870967542224,
    );
    let r = i64x4::new(5149955, 32696021, 51201034, 47154629);

    assert_eq!(
        r,
        transmute(lasx_xvsrlni_d_q::<102>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlrni_b_h() {
    let a = i8x32::new(
        34, -7, -78, 100, -21, -1, 17, 9, -61, -37, -34, -101, 35, -116, 122, -18, -81, -45,
        109, -42, 100, -92, -112, -23, -31, 5, -113, 35, 49, 53, 114, -92,
    );
    let b = i8x32::new(
        112, 121, 80, 76, -7, 100, 61, 66, 108, 0, 80, -24, -2, 119, -19, 70, -14, -70, -100,
        -17, -108, -13, -85, 119, -8, -115, -56, -35, 14, -83, -84, 17,
    );
    let r = i64x4::new(
        5150121261709741177,
        -1257457727085451783,
        1345976567149686971,
        -6614340865598630188,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrlrni_b_h::<8>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlrni_h_w() {
    let a = i16x16::new(
        27342, -1239, 27928, 29682, 26896, -14508, -15889, 28618, 8114, -5723, 6531, 16489,
        9888, 9809, 24468, -17705,
    );
    let b = i16x16::new(
        -4757, 26542, -29532, 16718, -14266, 32474, -3741, 20715, -3284, 22232, -12159, 12153,
        9095, 12312, -9885, 15691,
    );
    let r = i64x4::new(
        6884832036274927467,
        6201354748313553750,
        6830765589305542553,
        -4972667551599548162,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrlrni_h_w::<5>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlrni_w_d() {
    let a = i32x8::new(
        289756682,
        172661920,
        1612205654,
        1151400165,
        -170063304,
        -1551308632,
        700728065,
        -2116148576,
    );
    let b = i32x8::new(
        -2050725054,
        1576856049,
        1261747784,
        550730851,
        956136959,
        -2117291501,
        333722873,
        1623097423,
    );
    let r = i64x4::new(
        1154968246271901,
        2414660678666580,
        3403881842227606,
        4569312628338973,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrlrni_w_d::<43>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrlrni_d_q() {
    let a = i64x4::new(
        3267303445176803893,
        -4716941928717011909,
        -2526932137083513614,
        895449181781228437,
    );
    let b = i64x4::new(
        2365189083440669290,
        -2671456009299896653,
        -5051789062015102943,
        8552962343526201846,
    );
    let r = i64x4::new(3, 3, 2, 0);

    assert_eq!(
        r,
        transmute(lasx_xvsrlrni_d_q::<126>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlni_b_h() {
    let a = i8x32::new(
        -107, 64, -59, -36, -40, 105, -55, -99, -41, 36, -103, -12, -28, -101, 45, 100, 73,
        -21, -30, -52, 105, 47, 41, -81, -123, -14, -118, 97, -35, 59, 106, 86,
    );
    let b = i8x32::new(
        -73, 37, -91, -37, 7, -55, -86, -122, 88, 17, 59, 126, -32, -53, 61, -110, 23, 50,
        -108, -47, 85, 64, -55, -30, 95, 76, -30, -4, -20, 62, 101, 45,
    );
    let r = i64x4::new(
        9187201950435737471,
        9187201950435737471,
        9187201950435737471,
        9187201950435737471,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlni_b_h::<4>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlni_h_w() {
    let a = i16x16::new(
        5930, 18178, 9007, -17010, -26714, -2479, 7566, 5590, 16536, 7100, -23266, -11745,
        -13529, 4421, -4886, -13565,
    );
    let b = i16x16::new(
        -24390, 15351, 27329, 19807, 29414, -20147, 32425, 16919, -13702, 24649, 12504, 19625,
        -21621, -18266, -9493, 32188,
    );
    let r = i64x4::new(4294967296, 4295032832, 4294967296, 281474976776192);

    assert_eq!(
        r,
        transmute(lasx_xvssrlni_h_w::<31>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlni_w_d() {
    let a = i32x8::new(
        1916052008,
        -1597654810,
        -1773664899,
        -1047601895,
        1186726373,
        -322280569,
        -1340612407,
        -1064828410,
    );
    let b = i32x8::new(
        962275142,
        367045968,
        -1148735443,
        -1235460518,
        1290051946,
        -1409071527,
        -1206112029,
        -438247212,
    );
    let r = i64x4::new(
        9223372034707292159,
        9223372034707292159,
        9223372034707292159,
        9223372034707292159,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlni_w_d::<14>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlni_d_q() {
    let a = i64x4::new(
        8566260488262197161,
        7230026431777616732,
        5171247138929999763,
        7672209083386018537,
    );
    let b = i64x4::new(
        7413144581871225401,
        1963917804351928008,
        4461413294595322647,
        -319568179542390733,
    );
    let r = i64x4::new(
        9223372036854775807,
        9223372036854775807,
        9223372036854775807,
        9223372036854775807,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlni_d_q::<35>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlni_bu_h() {
    let a = u8x32::new(
        63, 110, 160, 217, 255, 151, 31, 161, 90, 119, 205, 201, 53, 121, 107, 243, 140, 191,
        5, 109, 173, 46, 21, 136, 126, 162, 107, 116, 221, 46, 104, 127,
    );
    let b = i8x32::new(
        -19, -66, 94, -50, 114, -125, 71, -72, 91, -112, -36, -97, 0, -113, 63, 124, 21, 67,
        -17, 63, -30, -100, -64, 42, 84, 106, 81, 119, 26, 105, -15, 93,
    );
    let r = i64x4::new(
        1085669953590270231,
        2165977494045465357,
        796308158196942600,
        1082286764800150807,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlni_bu_h::<11>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlni_hu_w() {
    let a = u16x16::new(
        6179, 35983, 31969, 1127, 39823, 7636, 13877, 49933, 49881, 18256, 23272, 43743, 14779,
        42488, 11284, 24455,
    );
    let b = i16x16::new(
        -2976, 3715, -23929, -18386, 13544, -26884, -14757, 9675, -17650, 8814, 4366, 2063,
        1167, -30247, -25786, 9281,
    );
    let r = i64x4::new(4295032832, 281474976710657, 4294967296, 4295032832);

    assert_eq!(
        r,
        transmute(lasx_xvssrlni_hu_w::<31>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlni_wu_d() {
    let a = u32x8::new(
        1435242449, 2536238660, 3898848008, 4040623161, 743412748, 1784708443, 2900988959,
        1523459155,
    );
    let b = i32x8::new(
        -1925581805,
        -241685045,
        745827979,
        -811389509,
        834544392,
        1909578565,
        2098160602,
        -1160686393,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(
        r,
        transmute(lasx_xvssrlni_wu_d::<24>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlni_du_q() {
    let a = u64x4::new(
        4906311251686769180,
        5252105969529596252,
        3036147848110573085,
        6245591556930524613,
    );
    let b = i64x4::new(
        -1139822228972687264,
        -3655945315912724740,
        6046255801009758548,
        -8615916243772089902,
    );
    let r = i64x4::new(420379, 149273, 279408, 177510);

    assert_eq!(
        r,
        transmute(lasx_xvssrlni_du_q::<109>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrni_b_h() {
    let a = i8x32::new(
        -47, 51, -118, -97, 65, -7, -102, 38, -97, -64, 87, -87, -10, 84, -105, -80, -8, 81,
        -112, -40, -15, 20, -72, -108, -23, -18, 93, -125, -55, 33, 12, -21,
    );
    let b = i8x32::new(
        92, 106, -122, -65, -16, 86, 50, -59, 59, -29, -92, -41, 101, 10, 35, 106, -53, 112,
        79, 78, -52, 18, 62, 29, -78, -65, -73, 122, -105, -105, -27, -72,
    );
    let r = i64x4::new(
        9157365602904407935,
        9187201949596876648,
        9187201949272276863,
        9170594926804238207,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlrni_b_h::<7>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrni_h_w() {
    let a = i16x16::new(
        27571, 10886, 30311, -21575, -21376, -15868, 15443, -27608, -9760, 16249, 24860, -3987,
        25742, 25311, 2125, -1676,
    );
    let b = i16x16::new(
        20889, 11322, -17186, 17589, 10767, 165, 25424, -3527, -16029, -18830, -3174, -27403,
        20745, 19828, 7102, 10767,
    );
    let r = i64x4::new(
        9223113262927675391,
        9223231297218904063,
        9223231297218904063,
        9223231297218904063,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlrni_h_w::<11>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrni_w_d() {
    let a = i32x8::new(
        13685129,
        -1250749430,
        -1392632470,
        -496387445,
        -859105657,
        -188800497,
        1260867999,
        -2071975844,
    );
    let b = i32x8::new(
        -2147085485,
        -1138150986,
        1740486083,
        129550606,
        761255804,
        107768592,
        -897233831,
        2135540054,
    );
    let r = i64x4::new(
        9223372034707292159,
        9223372034707292159,
        9223372034707292159,
        9223372034707292159,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlrni_w_d::<27>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrni_d_q() {
    let a = i64x4::new(
        2126435331828238132,
        2988359539712387032,
        2606687986635590409,
        -5337426820831497192,
    );
    let b = i64x4::new(
        5599657380360976171,
        1936278255544613151,
        4350470739273890826,
        4020807834764701096,
    );
    let r = i64x4::new(1803299650, 2783126700, 3744669105, 12209003095);

    assert_eq!(
        r,
        transmute(lasx_xvssrlrni_d_q::<94>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrni_bu_h() {
    let a = u8x32::new(
        10, 53, 247, 169, 200, 197, 15, 35, 40, 63, 25, 238, 115, 150, 127, 27, 72, 180, 151,
        194, 68, 16, 94, 145, 159, 31, 157, 147, 248, 155, 228, 94,
    );
    let b = i8x32::new(
        28, 76, -8, 123, -45, -21, 72, -114, -80, -30, 52, -17, -86, 92, 41, -102, 69, 7, 126,
        112, 93, 90, 52, 3, 85, -11, 40, 64, -22, -54, 38, 100,
    );
    let r = i64x4::new(-1, -1, -3422552204, -1);

    assert_eq!(
        r,
        transmute(lasx_xvssrlrni_bu_h::<4>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrni_hu_w() {
    let a = u16x16::new(
        46345, 65470, 38947, 23932, 57842, 4833, 48042, 40409, 15235, 53592, 48941, 4323, 7891,
        47087, 8916, 53135,
    );
    let b = i16x16::new(
        -10645, 13954, 25607, -15109, -23253, 24216, -29088, 13185, 29191, -11398, -4777,
        -18744, -9822, -25345, 19767, -4882,
    );
    let r = i64x4::new(
        3711633057434515075,
        -7072319501391495233,
        -1373988209909181574,
        -3490368948780347048,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlrni_hu_w::<16>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrni_wu_d() {
    let a = u32x8::new(
        2556609468, 306738319, 398886007, 1398704761, 4256553589, 1589981150, 4133102348,
        1371421151,
    );
    let b = i32x8::new(
        1653381194,
        1981734587,
        -1912314738,
        1375487329,
        900885316,
        -1157483971,
        1097724788,
        -1431477856,
    );
    let r = i64x4::new(
        22535693409672,
        22917945492626,
        46913927786177,
        22471268898737,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrlrni_wu_d::<50>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrlrni_du_q() {
    let a = u64x4::new(
        10427296977042877275,
        11482184389991123309,
        17526981944466620659,
        4352829566336418219,
    );
    let b = i64x4::new(
        -2649024960844804464,
        -4562273421517696438,
        -4420539680558072379,
        3588904051642804143,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(
        r,
        transmute(lasx_xvssrlrni_du_q::<53>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrani_b_h() {
    let a = i8x32::new(
        -75, 121, -21, -15, 41, -7, 35, 38, -68, -73, -76, -71, 96, 43, -94, 56, -117, -109,
        -28, -15, -125, 90, -42, -48, -12, -96, -55, 4, 32, 81, 64, -29,
    );
    let b = i8x32::new(
        -57, -25, -35, -108, 14, 83, 114, -49, -48, 1, -109, 103, 36, -56, 111, 36, 126, 67,
        32, 11, -52, 28, -69, -5, -2, 118, -85, -104, -45, 106, 32, -56,
    );
    let r = i64x4::new(
        2650481638178526439,
        4047532886406590841,
        -4005221281806152893,
        -2066865665249447533,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrani_b_h::<8>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrani_h_w() {
    let a = i16x16::new(
        -18891, 1637, 13894, -632, 7479, -28444, -346, -630, -10322, -16816, 24786, -20705,
        25886, -25922, 2142, 28477,
    );
    let b = i16x16::new(
        21255, -8544, -16076, 8180, -16685, -4813, 15309, -18986, 11259, -27708, -15696, 2064,
        -27273, -24407, -22250, 31561,
    );
    let r = i64x4::new(
        4309310235152241415,
        -97358218970876363,
        -6262653890212123653,
        603030581262079918,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrani_h_w::<0>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrani_w_d() {
    let a = i32x8::new(
        495374215,
        -1163373413,
        976054174,
        1739213032,
        -1526300426,
        -1390196250,
        1721157436,
        191851664,
    );
    let b = i32x8::new(
        -250032972,
        -1792143742,
        873982753,
        1073657849,
        -422789767,
        -119562076,
        282475947,
        -868496874,
    );
    let r = i64x4::new(
        -5770703783532497,
        8837345064960477617,
        -4342418500326127026,
        -5262798083402195350,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrani_w_d::<28>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrani_d_q() {
    let a = i64x4::new(
        -5439693678259807595,
        -4580626123248901724,
        2865305240006228264,
        -8764287857747577448,
    );
    let b = i64x4::new(
        -5465329153910229449,
        -6398397336342204188,
        -6140402929126091639,
        -227294431853722285,
    );
    let r = i64x4::new(
        -1599599334085551047,
        -1145156530812225431,
        -56823607963430572,
        -2191071964436894362,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrani_d_q::<66>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrarni_b_h() {
    let a = i8x32::new(
        -127, 9, 115, 3, -36, -14, 60, 5, -69, -24, 124, -51, 64, -85, 106, -22, -9, -70, 26,
        -34, 108, 46, 86, 1, -82, -103, 79, 112, -121, 40, 36, 4,
    );
    let b = i8x32::new(
        7, 107, -33, 86, -95, -124, 35, 9, -27, 101, -64, 109, 34, 39, 38, -48, 20, 118, -95,
        127, 77, -88, 31, 76, 81, 10, 73, -32, -72, 121, 97, 83,
    );
    let r = i64x4::new(
        176445634160258736,
        -6362222276348332136,
        3935026383906273889,
        4794087966981481135,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrarni_b_h::<4>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrarni_h_w() {
    let a = i16x16::new(
        72, 17107, 2659, -22852, 13209, -19338, 29569, 8828, -14716, 1062, 26914, 1211, 14641,
        462, -8884, 7159,
    );
    let b = i16x16::new(
        -17232, 10103, 3681, -11092, 29619, 422, -25692, 26710, 4183, 27520, 31478, -21569,
        -7123, 10033, 12272, -5070,
    );
    let r = i64x4::new(
        3120663839319243742,
        4483961363433351552,
        1808363419292516360,
        -292761337443576989,
    );

    assert_eq!(
        r,
        transmute(lasx_xvsrarni_h_w::<9>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrarni_w_d() {
    let a = i32x8::new(
        1755618482, 374523356, -792192312, 1238002187, -327197280, 1104823907, 1830966401,
        1692510686,
    );
    let b = i32x8::new(
        -918051703,
        -2012887920,
        1331552048,
        -1402691916,
        1043562559,
        2068236941,
        -2026755109,
        267314745,
    );
    let r = i64x4::new(-1, 4294967296, 1, 4294967297);

    assert_eq!(
        r,
        transmute(lasx_xvsrarni_w_d::<63>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvsrarni_d_q() {
    let a = i64x4::new(
        567870545843316755,
        -8340148388286757707,
        5574111920016803397,
        4080639718254229578,
    );
    let b = i64x4::new(
        2101950651821444783,
        -8893233216031885881,
        -1626396509648873280,
        -8228614332001484946,
    );
    let r = i64x4::new(-32353394, -30341283, -29935525, 14845281);

    assert_eq!(
        r,
        transmute(lasx_xvsrarni_d_q::<102>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrani_b_h() {
    let a = i8x32::new(
        -9, 79, -25, 24, 113, 13, 74, -64, -92, 21, 94, -9, -20, -54, -92, 20, 108, 43, 104,
        -53, 111, -89, -71, -19, 63, 98, -15, 42, 22, 34, -71, -122,
    );
    let b = i8x32::new(
        89, 71, -128, -8, -83, 115, -7, -12, 45, -29, 1, 28, 32, 14, -93, 78, 52, -30, -13, 38,
        -28, -8, -119, -64, 67, 107, -11, 52, 25, -112, 40, 98,
    );
    let r = i64x4::new(
        9183261305727861887,
        9187548296613953407,
        9187483425433943936,
        -9187484529219043201,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrani_b_h::<5>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrani_h_w() {
    let a = i16x16::new(
        22159, -17585, 27907, -32059, 19510, -6875, -20701, -10302, -10451, 21878, 24873,
        29927, 15505, -6217, -18330, 22702,
    );
    let b = i16x16::new(
        -29049, -3742, -27686, -18440, 8738, 8686, 29608, -1629, -4626, 5557, -6248, 23821,
        29245, 14976, -6969, 13087,
    );
    let r = i64x4::new(
        -9223231301513871360,
        -9223231297218904064,
        9223231297218904063,
        9223231301513871359,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrani_h_w::<0>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrani_w_d() {
    let a = i32x8::new(
        1147593201,
        1099386066,
        1235877455,
        692249820,
        -2135577276,
        -886668236,
        -2044672723,
        1727555657,
    );
    let b = i32x8::new(
        -1064236617,
        1620556139,
        1782308008,
        -1034014776,
        1536995212,
        533284065,
        -1618986886,
        1843302450,
    );
    let r = i64x4::new(
        -542123656805187,
        362937621548090,
        966419181272650,
        905739883141428,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrani_w_d::<45>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrani_d_q() {
    let a = i64x4::new(
        1412208151721093534,
        -7916875471977804537,
        -1917411313405122179,
        -2235840015390028939,
    );
    let b = i64x4::new(
        1186137621302436836,
        759241008247506430,
        -5558106622572300047,
        -7286741001002884564,
    );
    let r = i64x4::new(
        1482892594233410,
        -15462647406206650,
        -14231916017583759,
        -4366875030058651,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrani_d_q::<73>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrani_bu_h() {
    let a = u8x32::new(
        1, 205, 104, 217, 117, 189, 143, 23, 134, 233, 247, 251, 129, 173, 74, 226, 108, 34,
        242, 113, 228, 183, 247, 66, 58, 69, 232, 3, 194, 209, 216, 161,
    );
    let b = i8x32::new(
        83, 63, -94, -103, -40, -9, 26, 104, 112, -91, 71, 32, 61, 29, 79, -128, 112, -4, -66,
        -40, -90, -40, 49, 54, -61, 120, 6, -48, 10, -33, -13, 10,
    );
    let r = i64x4::new(283674100629507, 16777216, 30115102720, 17246979842);

    assert_eq!(
        r,
        transmute(lasx_xvssrani_bu_h::<12>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrani_hu_w() {
    let a = u16x16::new(
        19110, 42732, 10660, 61644, 61010, 42962, 42748, 16931, 50634, 1738, 45781, 12001,
        56715, 59669, 23910, 35943,
    );
    let b = i16x16::new(
        12924, 5630, 2751, 7961, 14757, 29792, -8632, 13429, -3048, -12501, -25328, 421, 20048,
        -3741, -20350, 17918,
    );
    let r = i64x4::new(-1, -281474976710656, -281471439994880, 4294967295);

    assert_eq!(
        r,
        transmute(lasx_xvssrani_hu_w::<9>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrani_wu_d() {
    let a = u32x8::new(
        790410016, 1846446414, 17060282, 4137690011, 4225559886, 456167206, 2038191803,
        3549679132,
    );
    let b = i32x8::new(
        1124175113,
        194327297,
        1714613,
        1768781089,
        1565600638,
        -239088013,
        -1330211045,
        -142923536,
    );
    let r = i64x4::new(7418804384752972, 1803170, 0, 445475);

    assert_eq!(
        r,
        transmute(lasx_xvssrani_wu_d::<42>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrani_du_q() {
    let a = u64x4::new(
        4439635547532985516,
        2617773814700322397,
        11329239143202498931,
        5215941649340885573,
    );
    let b = i64x4::new(
        4456285459677935774,
        -4219123236529314050,
        2135308934637733797,
        -2097442597384769114,
    );
    let r = i64x4::new(0, 1162, 0, 2316);

    assert_eq!(
        r,
        transmute(lasx_xvssrani_du_q::<115>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarni_b_h() {
    let a = i8x32::new(
        37, 100, -16, 92, 65, -5, 44, -80, 109, -99, -15, -22, -16, -48, -109, 81, -4, -31,
        -48, -58, 103, -92, -51, -109, 32, -112, 36, 90, 79, 79, 66, -50,
    );
    let b = i8x32::new(
        -17, 23, 25, -46, 124, -97, -58, -51, -68, -108, -48, 69, -126, 115, 46, 13, 66, 54,
        114, 115, -18, -123, 98, 118, -7, -56, -122, -103, -94, -100, 112, 77,
    );
    let r = i64x4::new(
        3854939995940880480,
        9187532907754651519,
        9187484529219108735,
        -9187484524924075896,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrarni_b_h::<6>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarni_h_w() {
    let a = i16x16::new(
        -2373, -24512, -6581, 18622, -28242, 12319, -8850, -19323, 12925, -6513, -5054, 31054,
        6907, -16683, -29917, 16639,
    );
    let b = i16x16::new(
        30767, -4399, -21574, -27342, 15257, -2000, -28741, 6286, -10858, -32114, -2565, 11901,
        -815, -13930, 31355, 23314,
    );
    let r = i64x4::new(
        3659161808928759,
        -10695946033365040,
        13229207942856641,
        9288532501594099,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrarni_h_w::<25>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarni_w_d() {
    let a = i32x8::new(
        -409627486,
        1892097986,
        -1750910325,
        -1547433679,
        -1884419017,
        1579223214,
        1151303281,
        -1571586603,
    );
    let b = i32x8::new(
        364285131,
        2006347587,
        155571363,
        -1533032556,
        -1176543806,
        163000547,
        557435884,
        -1610070779,
    );
    let r = i64x4::new(-12884901884, -12884901884, -12884901888, -12884901885);

    assert_eq!(
        r,
        transmute(lasx_xvssrarni_w_d::<61>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarni_d_q() {
    let a = i64x4::new(
        -3977765823996238174,
        7327308686384468121,
        6534356875603597306,
        -6213176538981319905,
    );
    let b = i64x4::new(
        3336126315622887836,
        -1421822040970831870,
        -3632342560101816908,
        6607031745644833811,
    );
    let r = i64x4::new(-2, 13, 11, -11);

    assert_eq!(
        r,
        transmute(lasx_xvssrarni_d_q::<123>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarni_bu_h() {
    let a = u8x32::new(
        193, 242, 89, 76, 29, 42, 190, 17, 62, 209, 26, 45, 231, 78, 123, 125, 177, 121, 30,
        205, 85, 184, 30, 54, 64, 91, 228, 123, 242, 32, 245, 116,
    );
    let b = i8x32::new(
        5, 94, 72, 83, 78, 23, 5, 51, 110, -86, 74, 70, -99, 111, -112, -94, -89, 1, -14, -17,
        116, -105, 29, 34, -52, 15, 45, 47, -121, -106, 28, 37,
    );
    let r = i64x4::new(
        7901090775700760,
        2239427009405719296,
        648531557811748864,
        2091956210793185310,
    );

    assert_eq!(
        r,
        transmute(lasx_xvssrarni_bu_h::<10>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarni_hu_w() {
    let a = u16x16::new(
        51760, 63593, 22275, 32531, 40741, 58073, 26835, 39742, 8352, 44544, 27074, 30619,
        37450, 62701, 34849, 52300,
    );
    let b = i16x16::new(
        4460, -2173, 9587, -13951, -27036, 22540, -29433, 21420, 8161, -13247, -22431, -17918,
        14542, -22571, 29221, -25316,
    );
    let r = i64x4::new(281479271677952, 131072, 0, 131072);

    assert_eq!(
        r,
        transmute(lasx_xvssrarni_hu_w::<30>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarni_wu_d() {
    let a = u32x8::new(
        3607104991, 1691528601, 1646387994, 3297780207, 1308777898, 2787161654, 1384884119,
        2469722276,
    );
    let b = i32x8::new(
        1057151305,
        1547571989,
        -1438179575,
        -674675006,
        -1782337903,
        -1886071573,
        1398821536,
        -842047108,
    );
    let r = i64x4::new(3, 3, 0, 0);

    assert_eq!(
        r,
        transmute(lasx_xvssrarni_wu_d::<61>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvssrarni_du_q() {
    let a = u64x4::new(
        17745120891134780613,
        17495926160423737090,
        17172121380293899495,
        9650615204759187347,
    );
    let b = i64x4::new(
        -1697356653875036425,
        8295898722167744374,
        3345487212441260159,
        -6164422872274135032,
    );
    let r = i64x4::new(-1, 0, 0, 0);

    assert_eq!(
        r,
        transmute(lasx_xvssrarni_du_q::<15>(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbnz_b() {
    let a = u8x32::new(
        52, 144, 253, 233, 192, 255, 120, 244, 63, 161, 189, 203, 12, 208, 233, 255, 43, 119,
        120, 82, 121, 194, 249, 47, 211, 41, 120, 204, 13, 67, 208, 223,
    );
    let r: i32 = 1;

    assert_eq!(r, transmute(lasx_xbnz_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbnz_d() {
    let a = u64x4::new(
        1072041358626911785,
        13770317343519767693,
        7609734988530058463,
        15151929908370022007,
    );
    let r: i32 = 1;

    assert_eq!(r, transmute(lasx_xbnz_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbnz_h() {
    let a = u16x16::new(
        19391, 20489, 16878, 56279, 52740, 3527, 27948, 60443, 25278, 61969, 6762, 35448,
        28924, 34327, 22427, 5444,
    );
    let r: i32 = 1;

    assert_eq!(r, transmute(lasx_xbnz_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbnz_v() {
    let a = u8x32::new(
        137, 127, 48, 118, 43, 194, 48, 37, 231, 38, 31, 50, 240, 208, 254, 90, 200, 158, 40,
        38, 192, 180, 105, 245, 102, 149, 53, 213, 112, 215, 100, 152,
    );
    let r: i32 = 1;

    assert_eq!(r, transmute(lasx_xbnz_v(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbnz_w() {
    let a = u32x8::new(
        1332660055, 2747714226, 143160005, 119041189, 2584280725, 894305940, 2774463674,
        2502507106,
    );
    let r: i32 = 1;

    assert_eq!(r, transmute(lasx_xbnz_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbz_b() {
    let a = u8x32::new(
        156, 147, 147, 177, 127, 216, 32, 152, 55, 208, 206, 60, 244, 31, 57, 39, 72, 181, 147,
        141, 238, 33, 32, 5, 231, 1, 227, 42, 133, 202, 103, 67,
    );
    let r: i32 = 0;

    assert_eq!(r, transmute(lasx_xbz_b(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbz_d() {
    let a = u64x4::new(
        6400818938894159638,
        10728379594538160633,
        1581126190179348917,
        18400090329472768228,
    );
    let r: i32 = 0;

    assert_eq!(r, transmute(lasx_xbz_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbz_h() {
    let a = u16x16::new(
        34066, 39412, 64746, 3863, 50032, 22525, 9079, 56473, 53585, 42778, 58380, 52817,
        62358, 53187, 65430, 56633,
    );
    let r: i32 = 0;

    assert_eq!(r, transmute(lasx_xbz_h(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbz_v() {
    let a = u8x32::new(
        163, 229, 46, 44, 39, 89, 56, 38, 233, 178, 116, 135, 122, 191, 3, 141, 240, 213, 178,
        12, 81, 195, 113, 34, 100, 51, 70, 4, 238, 90, 144, 128,
    );
    let r: i32 = 0;

    assert_eq!(r, transmute(lasx_xbz_v(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xbz_w() {
    let a = u32x8::new(
        1201964702, 3804322072, 2566580464, 1047038968, 3180983430, 3379242404, 4047354705,
        444599201,
    );
    let r: i32 = 0;

    assert_eq!(r, transmute(lasx_xbz_w(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_caf_d() {
    let a = u64x4::new(
        4606839356548580067,
        4597657891815152040,
        4603435215712027397,
        4604372277177725810,
    );
    let b = u64x4::new(
        4603866787258734895,
        4605750987205548493,
        4594271025112584476,
        4604044410019184426,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_caf_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_caf_s() {
    let a = u32x8::new(
        1027122768, 1048202064, 1061996851, 1056399152, 1053612728, 1059134546, 1058685361,
        1059303636,
    );
    let b = u32x8::new(
        1052329028, 1041170924, 1053459178, 1051113546, 1055408428, 1052614588, 1059435003,
        1062279267,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_caf_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_ceq_d() {
    let a = u64x4::new(
        4604351168364659876,
        4598833803415332886,
        4605119133668748091,
        4606763866461983079,
    );
    let b = u64x4::new(
        4604789538755812401,
        4598766034813670762,
        4594451263359797256,
        4601380068795295764,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_ceq_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_ceq_s() {
    let a = u32x8::new(
        1064654513, 1047582960, 1060336644, 1065079996, 1052824856, 1061207347, 1063892428,
        1001614208,
    );
    let b = u32x8::new(
        1044141476, 1021192768, 1060376772, 1050417278, 1061038362, 1056139396, 1057149355,
        1055333616,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_ceq_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cle_d() {
    let a = u64x4::new(
        4595367725174333184,
        4596790595174909884,
        4593132764781967144,
        4599038464418852978,
    );
    let b = u64x4::new(
        4602705386887165787,
        4606260944252637140,
        4599015506541096164,
        4595819902199976812,
    );
    let r = i64x4::new(-1, -1, -1, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_cle_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cle_s() {
    let a = u32x8::new(
        1062033024, 1059343465, 1055578206, 1041885056, 1044779744, 1062731853, 1043491496,
        1049977384,
    );
    let b = u32x8::new(
        1056391070, 1056787090, 1064058770, 1062459426, 1064795941, 1064011655, 1031362688,
        1057735956,
    );
    let r = i64x4::new(0, -1, -1, -4294967296);

    assert_eq!(r, transmute(lasx_xvfcmp_cle_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_clt_d() {
    let a = u64x4::new(
        4604242319890507255,
        4600980435115810514,
        4605419716078684891,
        4599564622270556718,
    );
    let b = u64x4::new(
        4589220872256482592,
        4602715102780925632,
        4604097858141367250,
        4605812683073652447,
    );
    let r = i64x4::new(0, -1, 0, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_clt_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_clt_s() {
    let a = u32x8::new(
        1051323696, 1049201802, 1005628672, 1056692360, 1044683352, 1052201626, 1058314596,
        1020000992,
    );
    let b = u32x8::new(
        1055411522, 1059584260, 1046257332, 1041146612, 1064440240, 1064500639, 1062809438,
        1064342005,
    );
    let r = i64x4::new(-1, 4294967295, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_clt_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cne_d() {
    let a = u64x4::new(
        4598267260722064680,
        4605603034614740670,
        4604843132364965720,
        4595126942010545664,
    );
    let b = u64x4::new(
        4606134769367779594,
        4605453748913122312,
        4599415837069158138,
        4601771367817563314,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_cne_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cne_s() {
    let a = u32x8::new(
        1042659128, 1065350244, 1032310576, 1061728337, 1062313491, 1063903497, 1063781692,
        1057998506,
    );
    let b = u32x8::new(
        1041065828, 1061625246, 1045204740, 1054328432, 1036315496, 1061417737, 1047548872,
        1049890404,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_cne_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cor_d() {
    let a = u64x4::new(
        4603862490470319449,
        4601565668275439290,
        4606067119428218406,
        4606327024345603527,
    );
    let b = u64x4::new(
        4605708081396913008,
        4604379998889664770,
        4584756849579116944,
        4604755606278723296,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_cor_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cor_s() {
    let a = u32x8::new(
        1058610981, 1045033144, 1052398652, 1063724666, 1043910192, 1059183076, 1058489697,
        1040176728,
    );
    let b = u32x8::new(
        1032397784, 1054938542, 1057767324, 1054806424, 1055680194, 1057342938, 1060622406,
        1055092632,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_cor_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cueq_d() {
    let a = u64x4::new(
        4603200339689238557,
        4602812037576416711,
        4606851174908484583,
        4606385521842539189,
    );
    let b = u64x4::new(
        4603085364717668671,
        4606853743461984788,
        4585080339878261296,
        4606053791400332699,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_cueq_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cueq_s() {
    let a = u32x8::new(
        1057425562, 1063555579, 1046256744, 1022920160, 1065220069, 1052327026, 1014579968,
        1048239780,
    );
    let b = u32x8::new(
        1049557526, 1053332678, 1051191726, 1064421754, 1057629639, 1060344219, 1035702088,
        1050028150,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_cueq_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cule_d() {
    let a = u64x4::new(
        4604971750650888499,
        4593662226049896016,
        4595869612440915848,
        4601748250340185114,
    );
    let b = u64x4::new(
        4591931242171514960,
        4603997046544929558,
        4604974910786711097,
        4594297721205202168,
    );
    let r = i64x4::new(0, -1, -1, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_cule_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cule_s() {
    let a = u32x8::new(
        1052434396, 1026804576, 1041964148, 1063157036, 1048709802, 1060293833, 1047340196,
        1024531168,
    );
    let b = u32x8::new(
        1047645820, 1057293405, 1052020188, 1057942586, 1063407758, 1049107470, 1057298442,
        1048069496,
    );
    let r = i64x4::new(-4294967296, 4294967295, 4294967295, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_cule_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cult_d() {
    let a = u64x4::new(
        4606775288794066380,
        4598808693757211694,
        4606790379429412870,
        4605939949509363873,
    );
    let b = u64x4::new(
        4603717006707963555,
        4603504390160152243,
        4603259926905419449,
        4601857582598168522,
    );
    let r = i64x4::new(0, -1, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_cult_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cult_s() {
    let a = u32x8::new(
        1040152456, 1054570724, 1057645741, 1059637215, 1036822376, 1036413584, 1003370880,
        1061729841,
    );
    let b = u32x8::new(
        1060169565, 1056061318, 1052047112, 1053313212, 1044605328, 1064898859, 1050643938,
        1064626494,
    );
    let r = i64x4::new(-1, 0, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_cult_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cun_d() {
    let a = u64x4::new(
        4601926997709293092,
        4595132289995141556,
        4600980852994617218,
        4594388740429843072,
    );
    let b = u64x4::new(
        4600518403789793172,
        4603476024215184625,
        4605134822967030979,
        4602608048300777812,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_cun_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cune_d() {
    let a = u64x4::new(
        4592724877670260624,
        4603613641675881288,
        4597286359527586476,
        4601708681880094032,
    );
    let b = u64x4::new(
        4598966797677485150,
        4587297906823272784,
        4604035321505064646,
        4604260243109134356,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_cune_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cune_s() {
    let a = u32x8::new(
        1064210263, 1059501406, 1055862424, 1054523594, 1059174050, 1050594182, 1052822848,
        1051372950,
    );
    let b = u32x8::new(
        1032533328, 1051044268, 1051967492, 1051754540, 1059816024, 1063426731, 1052204618,
        1064439988,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_cune_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_cun_s() {
    let a = u32x8::new(
        1062241044, 1056379734, 1063223413, 1034390344, 1044998176, 1057590594, 1059237612,
        1057447940,
    );
    let b = u32x8::new(
        1058046704, 1055331758, 1057614999, 1063039091, 1058229285, 1058774306, 1059987402,
        1033042696,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_cun_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_saf_d() {
    let a = u64x4::new(
        4594182209901295828,
        4581464082173647264,
        4590099234403759840,
        4604004273369365130,
    );
    let b = u64x4::new(
        4606819328552123016,
        4604091229052796023,
        4604586834115148931,
        4605037320947641934,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_saf_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_saf_s() {
    let a = u32x8::new(
        1060812428, 1061245324, 1063578557, 1030594672, 1059247505, 1044611124, 1052152258,
        1054967010,
    );
    let b = u32x8::new(
        1036948656, 1051225988, 1058720867, 1032456856, 1051436132, 1041087636, 1047267492,
        1051250362,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_saf_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_seq_d() {
    let a = u64x4::new(
        4604294705496916441,
        4593686918662327792,
        4605517303678922516,
        4604494135015023007,
    );
    let b = u64x4::new(
        4606394023713761400,
        4604455367892895376,
        4599018364404818718,
        4605980286735586821,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_seq_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_seq_s() {
    let a = u32x8::new(
        1044265248, 1058937550, 1056790200, 1052048406, 1059868687, 1051483336, 1046520332,
        1043191144,
    );
    let b = u32x8::new(
        1063109529, 1055603330, 1062415892, 1040213636, 1058253673, 1058703239, 1061796632,
        1061413795,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_seq_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sle_d() {
    let a = u64x4::new(
        4602408684767598022,
        4594250615798987092,
        4604963756353006013,
        4606163211162118467,
    );
    let b = u64x4::new(
        4601947900990812282,
        4593344345788988968,
        4593039683552237328,
        4589469470804985856,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sle_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sle_s() {
    let a = u32x8::new(
        1058066838, 1064865582, 1052694366, 1057408270, 1045092236, 1055900780, 1062509444,
        1031929176,
    );
    let b = u32x8::new(
        1034008560, 1055354624, 1065161513, 1050271030, 1063181654, 1057764124, 1061600359,
        1025107040,
    );
    let r = i64x4::new(0, 4294967295, -1, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sle_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_slt_d() {
    let a = u64x4::new(
        4604369883332347358,
        4591650558117088944,
        4596580563429877336,
        4602996385956780830,
    );
    let b = u64x4::new(
        4600043432599191356,
        4605816405801305324,
        4604195043424640949,
        4599985899346669220,
    );
    let r = i64x4::new(0, -1, -1, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_slt_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_slt_s() {
    let a = u32x8::new(
        1059565142, 1057830491, 1052849564, 1049794018, 1063910487, 1059818709, 1027439600,
        1057381646,
    );
    let b = u32x8::new(
        1040414724, 1040288116, 1043374880, 1056311634, 1065024654, 1056424062, 1057720509,
        1063111390,
    );
    let r = i64x4::new(0, -4294967296, 4294967295, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_slt_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sne_d() {
    let a = u64x4::new(
        4593560649779963032,
        4604654429289647502,
        4603296524089071766,
        4600835325257043198,
    );
    let b = u64x4::new(
        4605487761864572918,
        4605408876521930103,
        4598422649694782656,
        4592189012823412008,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_sne_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sne_s() {
    let a = u32x8::new(
        1042871300, 1062745184, 1064937837, 1040277356, 1057066266, 1018600128, 1059841200,
        1051941856,
    );
    let b = u32x8::new(
        1061164420, 1056972365, 1057052091, 1057171641, 1057154275, 1064004148, 1053173190,
        1062872949,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_sne_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sor_d() {
    let a = u64x4::new(
        4600032844669681944,
        4594463383805270076,
        4592958727948323240,
        4598474090378898318,
    );
    let b = u64x4::new(
        4602979608704078034,
        4606565228276935378,
        4604003678580242406,
        4604391192007326981,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_sor_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sor_s() {
    let a = u32x8::new(
        1061014415, 1062349523, 1051726058, 1055193302, 1042014376, 1060862292, 1049178518,
        1057703558,
    );
    let b = u32x8::new(
        1049131624, 1041520484, 1065237143, 1062513527, 1050805196, 1050889556, 1064403532,
        1054988022,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_sor_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sueq_d() {
    let a = u64x4::new(
        4603806425689581476,
        4602719352745602774,
        4594235151654053920,
        4598585482869376160,
    );
    let b = u64x4::new(
        4597192397006933792,
        4602801475688800384,
        4599539096838817414,
        4603943496423544517,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sueq_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sueq_s() {
    let a = u32x8::new(
        1063023580, 1064528754, 1050308238, 1037288408, 1040252868, 1052571256, 1054474094,
        1060927468,
    );
    let b = u32x8::new(
        1046997360, 1061154107, 1053281976, 1040631584, 1047759184, 1060702185, 1058969574,
        1055588604,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sueq_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sule_d() {
    let a = u64x4::new(
        4603957166332235709,
        4606383957649489661,
        4606330328898957118,
        4604578658311008992,
    );
    let b = u64x4::new(
        4603539942547513158,
        4603598897708702396,
        4606250921023174648,
        4592187933910963896,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sule_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sule_s() {
    let a = u32x8::new(
        1048433556, 1057438072, 1054557166, 1065240380, 1060486424, 1064222633, 1065198422,
        1034306768,
    );
    let b = u32x8::new(
        1041928380, 1018285056, 1055996038, 1059481010, 1024438512, 1052197062, 1055194940,
        1033264360,
    );
    let r = i64x4::new(0, 4294967295, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sule_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sult_d() {
    let a = u64x4::new(
        4605366058991696696,
        4601232121105121062,
        4601996581218373232,
        4602266745451684294,
    );
    let b = u64x4::new(
        4599548937774345734,
        4604614363604787867,
        4593970533267593656,
        4605031421622352277,
    );
    let r = i64x4::new(0, -1, 0, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_sult_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sult_s() {
    let a = u32x8::new(
        1044761596, 1015684704, 1049105674, 1061214845, 1031561696, 1055360952, 1060420352,
        1063461022,
    );
    let b = u32x8::new(
        1063585876, 1063262278, 1062673201, 1059017275, 1032877328, 1063558131, 1057454077,
        1062968413,
    );
    let r = i64x4::new(-1, 4294967295, -1, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sult_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sun_d() {
    let a = u64x4::new(
        4581684619237043552,
        4604681260167973492,
        4602321601943005466,
        4605768364153053538,
    );
    let b = u64x4::new(
        4604919109359715487,
        4606713834219051412,
        4601813019181652070,
        4598024963761131488,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sun_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sune_d() {
    let a = u64x4::new(
        4602842520488526831,
        4586377859926895520,
        4595797380069114560,
        4597668933134490352,
    );
    let b = u64x4::new(
        4603719292253049421,
        4601306102929155814,
        4606447272167981658,
        4595752422326832136,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_sune_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sune_s() {
    let a = u32x8::new(
        1060627725, 1063145029, 1064291001, 1058025149, 1037522088, 1059097656, 1041307400,
        1059437048,
    );
    let b = u32x8::new(
        1048507540, 1059109210, 1029412928, 1063377178, 1059646047, 1061716080, 1057060099,
        1040743680,
    );
    let r = i64x4::new(-1, -1, -1, -1);

    assert_eq!(r, transmute(lasx_xvfcmp_sune_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvfcmp_sun_s() {
    let a = u32x8::new(
        1062269194, 1017878048, 1020862944, 1063553320, 1052587356, 1041348304, 1063597708,
        1046660292,
    );
    let b = u32x8::new(
        1053486118, 1028652080, 1057647183, 1051605726, 987074560, 1053988970, 1063915975,
        1039720984,
    );
    let r = i64x4::new(0, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvfcmp_sun_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickve_d_f() {
    let a = u64x4::new(
        4601462012634722388,
        4605596490350167974,
        4589580703778483496,
        4590176684263748456,
    );
    let r = i64x4::new(4605596490350167974, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvpickve_d_f::<1>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvpickve_w_f() {
    let a = u32x8::new(
        1050978982, 1040565756, 1052944866, 1048054444, 1050714578, 1048632290, 1064399621,
        1049634380,
    );
    let r = i64x4::new(1040565756, 0, 0, 0);

    assert_eq!(r, transmute(lasx_xvpickve_w_f::<1>(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrepli_b() {
    let r = i64x4::new(
        -940422246894996750,
        -940422246894996750,
        -940422246894996750,
        -940422246894996750,
    );

    assert_eq!(r, transmute(lasx_xvrepli_b::<498>()));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrepli_d() {
    let r = i64x4::new(169, 169, 169, 169);

    assert_eq!(r, transmute(lasx_xvrepli_d::<169>()));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrepli_h() {
    let r = i64x4::new(
        -108650998892986755,
        -108650998892986755,
        -108650998892986755,
        -108650998892986755,
    );

    assert_eq!(r, transmute(lasx_xvrepli_h::<-387>()));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_xvrepli_w() {
    let r = i64x4::new(
        -1662152343940,
        -1662152343940,
        -1662152343940,
        -1662152343940,
    );

    assert_eq!(r, transmute(lasx_xvrepli_w::<-388>()));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_cast_128_s() {
    let a = u32x4::new(1031165056, 1051966120, 1060984374, 1062536919);
    let r = i64x4::new(4518160082931176576, 4563561318958585398, 1966080, 1966080);

    assert_eq!(
        r.as_array()[0..2],
        transmute::<_, i64x4>(lasx_cast_128_s(transmute(a))).as_array()[0..2]
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_cast_128_d() {
    let a = u64x2::new(4604694967937271251, 4600904075476555984);
    let r = i64x4::new(
        4604694967937271251,
        4600904075476555984,
        2910860781861170785,
        8314045306847701346,
    );

    assert_eq!(
        r.as_array()[0..2],
        transmute::<_, i64x4>(lasx_cast_128_d(transmute(a))).as_array()[0..2]
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_cast_128() {
    let a = i64x2::new(-5333716211868108402, 2442107533729495827);
    let r = i64x4::new(
        -5333716211868108402,
        2442107533729495827,
        -1115824375586394527,
        8314045306157170687,
    );

    assert_eq!(
        r.as_array()[0..2],
        transmute::<_, i64x4>(lasx_cast_128(transmute(a))).as_array()[0..2]
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_concat_128_s() {
    let a = u32x4::new(1032255272, 1059413818, 1058434362, 1041454056);
    let b = u32x4::new(1047296252, 1059191602, 1051282752, 1026847376);
    let r = i64x4::new(
        4550147702272751400,
        4473011111864986938,
        4549193291835144444,
        4410275898954698048,
    );

    assert_eq!(r, transmute(lasx_concat_128_s(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_concat_128_d() {
    let a = u64x2::new(4602341404117999960, 4599751584045405722);
    let b = u64x2::new(4595947342927040984, 4600308396523102002);
    let r = i64x4::new(
        4602341404117999960,
        4599751584045405722,
        4595947342927040984,
        4600308396523102002,
    );

    assert_eq!(r, transmute(lasx_concat_128_d(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_concat_128() {
    let a = i64x2::new(3302609705743394573, 8438855426868306143);
    let b = i64x2::new(8632034656150002181, 7751541408133090748);
    let r = i64x4::new(
        3302609705743394573,
        8438855426868306143,
        8632034656150002181,
        7751541408133090748,
    );

    assert_eq!(r, transmute(lasx_concat_128(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_extract_128_lo_s() {
    let a = u32x8::new(
        1038279272, 1053426270, 1062315532, 1055361088, 1061380448, 1052007748, 1063816577,
        1061671114,
    );
    let r = i64x2::new(4524431379435545192, 4532741359493293580);

    assert_eq!(r, transmute(lasx_extract_128_lo_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_extract_128_hi_s() {
    let a = u32x8::new(
        1059517342, 1052723820, 1053176244, 1060336354, 1058221022, 1064684502, 1061072013,
        1059238420,
    );
    let r = i64x2::new(4572785117706267614, 4549394373627784333);

    assert_eq!(r, transmute(lasx_extract_128_hi_s(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_extract_128_lo_d() {
    let a = u64x4::new(
        4606487981487128637,
        4592443779247846248,
        4605637448543526041,
        4604126872543611047,
    );
    let r = i64x2::new(4606487981487128637, 4592443779247846248);

    assert_eq!(r, transmute(lasx_extract_128_lo_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_extract_128_hi_d() {
    let a = u64x4::new(
        4595075050683709816,
        4603388454656549851,
        4603881047625519227,
        4604218419306666352,
    );
    let r = i64x2::new(4603881047625519227, 4604218419306666352);

    assert_eq!(r, transmute(lasx_extract_128_hi_d(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_extract_128_lo() {
    let a = i64x4::new(
        1690990426210778543,
        -1056924033489771427,
        1791197928200737608,
        2648792885519901423,
    );
    let r = i64x2::new(1690990426210778543, -1056924033489771427);

    assert_eq!(r, transmute(lasx_extract_128_lo(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_extract_128_hi() {
    let a = i64x4::new(
        1400282616691463341,
        6677577875527300174,
        -1903780563362068813,
        -7449796170151383489,
    );
    let r = i64x2::new(-1903780563362068813, -7449796170151383489);

    assert_eq!(r, transmute(lasx_extract_128_hi(transmute(a))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_insert_128_lo_s() {
    let a = u32x8::new(
        1063338913, 1017815328, 1065051130, 1040694156, 1059596680, 1048796526, 1058020845,
        1057822131,
    );
    let b = u32x4::new(1052930766, 1021556992, 1050709482, 1059704809);
    let r = i64x4::new(
        4387553872693064398,
        4551397499119635946,
        4504546780388010376,
        4543311458688048621,
    );

    assert_eq!(
        r,
        transmute(lasx_insert_128_lo_s(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_insert_128_hi_s() {
    let a = u32x8::new(
        1018863744, 1064221149, 1048659080, 1057450774, 1049935896, 1034170664, 1059759433,
        1057849762,
    );
    let b = u32x4::new(1060332648, 1063149600, 1051087106, 1060582348);
    let r = i64x4::new(
        4570795031685406848,
        4541716492508546184,
        4566192763815814248,
        4555166500425978114,
    );

    assert_eq!(
        r,
        transmute(lasx_insert_128_hi_s(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_insert_128_lo_d() {
    let a = u64x4::new(
        4601319519422109044,
        4601506273633970188,
        4605118087882201940,
        4605125059076454256,
    );
    let b = u64x2::new(4587489919640425888, 4591909120489567808);
    let r = i64x4::new(
        4587489919640425888,
        4591909120489567808,
        4605118087882201940,
        4605125059076454256,
    );

    assert_eq!(
        r,
        transmute(lasx_insert_128_lo_d(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_insert_128_hi_d() {
    let a = u64x4::new(
        4604690660177752777,
        4593824994203592700,
        4599958775071728504,
        4604125324674373728,
    );
    let b = u64x2::new(4601718173474385938, 4591758028383494760);
    let r = i64x4::new(
        4604690660177752777,
        4593824994203592700,
        4601718173474385938,
        4591758028383494760,
    );

    assert_eq!(
        r,
        transmute(lasx_insert_128_hi_d(transmute(a), transmute(b)))
    );
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_insert_128_lo() {
    let a = i64x4::new(
        8159968186698006293,
        5648210958959948409,
        603295919044368378,
        -4396186135186039276,
    );
    let b = i64x2::new(-6258666140812668387, 5822982556977506382);
    let r = i64x4::new(
        -6258666140812668387,
        5822982556977506382,
        603295919044368378,
        -4396186135186039276,
    );

    assert_eq!(r, transmute(lasx_insert_128_lo(transmute(a), transmute(b))));
}

#[simd_test(enable = "lasx")]
unsafe fn test_lasx_insert_128_hi() {
    let a = i64x4::new(
        2981835982487038158,
        5258378092714202875,
        5115371338527125146,
        -6993491475145500537,
    );
    let b = i64x2::new(1176776599938765863, -7502655081590988207);
    let r = i64x4::new(
        2981835982487038158,
        5258378092714202875,
        1176776599938765863,
        -7502655081590988207,
    );

    assert_eq!(r, transmute(lasx_insert_128_hi(transmute(a), transmute(b))));
}
