CREATE TABLE IF NOT EXISTS LDAPConfig (cfg_group VARCHAR(255) NOT NULL, cfg_key VARCHAR(255) NOT NULL, value VARCHAR(255), property INTEGER) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS GroupStructure (id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT, group_id INTEGER, path VARCHAR(1024), UNIQUE INDEX(group_id))ENGINE=INNODB;

alter table `Group` add column parent_group_id INTEGER default 0;  -- Replace `Group` if you configured table `Group` to another name.

ALTER TABLE Binding ADD id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;

ALTER TABLE LDAPConfig ADD id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;

ALTER TABLE OrgUser DROP primary key;
ALTER TABLE OrgUser ADD id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;
ALTER TABLE OrgUser ADD UNIQUE (org_id, email);

ALTER TABLE OrgGroup DROP primary key;
ALTER TABLE OrgGroup ADD id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;
ALTER TABLE OrgGroup ADD UNIQUE (org_id, group_id);

ALTER TABLE GroupUser DROP primary key;
ALTER TABLE GroupUser ADD id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;
ALTER TABLE GroupUser ADD UNIQUE (group_id, user_name);

ALTER TABLE GroupDNPair ADD id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;

