
'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = (n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3);
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(If left blank, owner will be admin)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)",
    "(at least {placeholder} characters)": "(at least {placeholder} characters)",
    "(current notification)": "(current notification)",
    "(current version)": "(trenutna razli\u010dica)",
    "1 cell copied": "1 cell copied",
    "1 filter": "1 filtriraj",
    "1 hidden property": "1 hidden property",
    "1 month ago": "pred 1 mesecem",
    "1 preset hidden property": "1 preset hidden property",
    "1 record selected": "1 record selected",
    "1 row is copied.": "1 row is copied.",
    "1 sort": "1 razvrstitev",
    "1 week ago": "pred 1 tednom",
    "3 days ago": "pred 3 dnevi",
    "A file is being uploaded. Are you sure you want to leave this page?": "Datoteka se nalagajo. Ali ste prepri\u010dani, da \u017eelite zapustiti to stran?",
    "A file named {upload_file_link} is uploaded to {uploaded_link}.": "A file named {upload_file_link} is uploaded to {uploaded_link}.",
    "A file named {upload_file_link} is uploaded.": "A file named {upload_file_link} is uploaded.",
    "A file with the same name already exists in this folder.": "Datoteka s tem imenom \u017ee obstaja v tej mapi.",
    "A folder named {upload_folder_link} is uploaded to {uploaded_link}.": "A folder named {upload_folder_link} is uploaded to {uploaded_link}.",
    "A folder named {upload_folder_link} is uploaded.": "A folder named {upload_folder_link} is uploaded.",
    "API Token": "API Token",
    "API token is copied to the clipboard.": "API token is copied to the clipboard.",
    "About Us": "O nas",
    "Abuse Content": "Abuse Content",
    "Abuse Reports": "Abuse Reports",
    "Abuse Type": "Abuse Type",
    "Abuse report added": "Abuse report added",
    "Accept": "Accept",
    "Accepted": "Accepted",
    "Accepted at": "Accepted at",
    "Accepter": "Accepter",
    "Access Log": "Dnevnik dostopov",
    "Accurate to minute": "Accurate to minute",
    "Action": "Action",
    "Actions": "Actions",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email",
    "Activated": "Activated",
    "Activated Users": "Activated Users",
    "Active": "Aktiven",
    "Active Users": "Aktivni uporabniki",
    "Activities": "Aktivnosti",
    "Add": "Dodaj",
    "Add Admin": "Add Admin",
    "Add Library": "Dodaj knji\u017enico",
    "Add Member": "Add Member",
    "Add Organization": "Add Organization",
    "Add Terms and Conditions": "Add Terms and Conditions",
    "Add User": "Add User",
    "Add Wiki": "Add Wiki",
    "Add admin": "Dodaj admina",
    "Add auto expiration": "Dodaj avtomatski \u010das veljavnosti",
    "Add cover": "Add cover",
    "Add custom permission": "Add custom permission",
    "Add filter": "Dodaj filtriraj",
    "Add group": "Add group",
    "Add group member": "Add group member",
    "Add icon": "Add icon",
    "Add institution": "Add institution",
    "Add members": "Dodaj \u010dlane",
    "Add new notification": "Dodaj novo obvestilo",
    "Add option": "Add option",
    "Add password protection": "Dodaj za\u0161\u010dito z geslom",
    "Add permission": "Add permission",
    "Add sort": "Dodaj razvrstitev",
    "Add user": "Dodaj uporabnika",
    "Add view": "Add view",
    "Added": "Dodan",
    "Added user {user}": "Added user {user}",
    "Admin": "Admin",
    "Admin Login Logs": "Admin Login Logs",
    "Admin Operation Logs": "Admin Operation Logs",
    "Admin access": "Admin access",
    "Admins": "Administratorji",
    "Advanced": "Advanced",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "Po omogo\u010deni raz\u0161irjenih lastnosti za datoteke lahko dodate razli\u010dne lastnosti, kot so sodelavci, datum poteka datoteke, opis datoteke. Tudi ustvarite razli\u010dne pogledi za datoteke na podlagi raz\u0161irjenih lastnosti.",
    "All": "Vse",
    "All Groups": "Vse skupine",
    "All Notifications": "Vsa obvestila",
    "All Public Links": "Vse javne povezave",
    "All comments": "Vsi komentarji",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.",
    "An integer that is greater than 0 or equal to -2.": "An integer that is greater than 0 or equal to -2.",
    "An integer that is greater than or equal to 0.": "An integer that is greater than or equal to 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Opis interne povezave",
    "And": "In",
    "Anonymous User": "Anonimni uporabnik",
    "Another property has this property type": "Another property has this property type",
    "Another user is editing this file!": "Another user is editing this file!",
    "Anyone with the link": "Anyone with the link",
    "Are you sure to change group {placeholder} to department ?": "Ali ste prepri\u010dani, da \u017eelite spremeniti skupino {placeholder} v oddelku?",
    "Are you sure to delete": "Ali ste prepri\u010dani, da \u017eelite izbrisati?",
    "Are you sure to delete ": "Ali ste prepri\u010dani, da \u017eelite izbrisati?",
    "Are you sure to delete this comment?": "Ali ste prepri\u010dani, da \u017eelite izbrisati ta komentar?",
    "Are you sure to delete this reply?": "Ali ste prepri\u010dani, da \u017eelite izbrisati ta odgovor?",
    "Are you sure to revoke access of user {placeholder} ?": "Ali ste prepri\u010dani, da \u017eelite preklicati dovoljenje uporabnika {placeholder}?",
    "Are you sure you want to clean invalid share links?": "Ali ste prepri\u010dani, da \u017eelite izbrisati neveljavne povezave za deljenje?",
    "Are you sure you want to clean invalid upload links?": "Ali ste prepri\u010dani, da \u017eelite izbrisati neveljavne povezave za prenos?",
    "Are you sure you want to clear trash?": "Ali ste prepri\u010dani, da \u017eelite sprazniti smeti?",
    "Are you sure you want to delete": "Ali ste prepri\u010dani, da \u017eelite izbrisati?",
    "Are you sure you want to delete WebDAV password?": "Ali ste prepri\u010dani, da \u017eelite izbrisati geslo za WebDAV?",
    "Are you sure you want to delete Wiki": "Ali ste prepri\u010dani, da \u017eelite izbrisati Wiki?",
    "Are you sure you want to delete the notification ?": "Ali ste prepri\u010dani, da \u017eelite izbrisati obvestilo?",
    "Are you sure you want to delete the selected share link(s) ?": "Ali ste prepri\u010dani, da \u017eelite odstraniti izbrane deljene povezave?",
    "Are you sure you want to delete the selected upload link(s) ?": "Ali ste prepri\u010dani, da \u017eelite izbrisati izbrane povezave za prenos?",
    "Are you sure you want to delete the selected user(s) ?": "Ali ste prepri\u010dani, da \u017eelite izbrisati izbrane uporabnike?",
    "Are you sure you want to delete the share link?": "Ali ste prepri\u010dani, da \u017eelite izbrisati povezavo za deljenje?",
    "Are you sure you want to delete this option?": "Ali ste prepri\u010dani, da \u017eelite izbrisati to mo\u017enost?",
    "Are you sure you want to delete this page?": "Ali si prepri\u010dan/a, da \u017eeli\u0161 odstraniti to stran?",
    "Are you sure you want to delete {placeholder} ?": "Ali ste prepri\u010dani, da \u017eelite izbrisati {placeholder}?",
    "Are you sure you want to delete {placeholder} completely?": "Ali ste prepri\u010dani, da \u017eelite izbrisati {placeholder} popolnoma?",
    "Are you sure you want to disconnect?": "Ali ste prepri\u010dani, da \u017eelite prekiniti povezavo?",
    "Are you sure you want to leave share Wiki": "Ali ste prepri\u010dani, da \u017eelite zapustiti deljenje Wiki?",
    "Are you sure you want to remove {placeholder} ?": "Ali ste prepri\u010dani, da \u017eelite odstraniti {placeholder}?",
    "Are you sure you want to reset the password of {placeholder} ?": "Ali ste prepri\u010dani, da \u017eelite ponastaviti geslo za {placeholder}?",
    "Are you sure you want to restore this library?": "Ali ste prepri\u010dani da \u017eelite obnoviti to knji\u017enico?",
    "Are you sure you want to restore {placeholder}?": "Ali ste prepri\u010dani, da \u017eelite obnoviti {placeholder}?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "Ali ste prepri\u010dani, da \u017eelite nastaviti {placeholder} kot skrbnika?",
    "Are you sure you want to set {placeholder} as Admin?": "Ali ste prepri\u010dani, da \u017eelite nastaviti {placeholder} kot skrbnika?",
    "Are you sure you want to set {user_placeholder} inactive?": "Ali ste prepri\u010dani, da \u017eelite nastaviti {user_placeholder} kot neaktiven?",
    "Are you sure you want to unlink this device?": "Ali ste prepri\u010dani, da \u017eelite razvezati to napravo?",
    "Are you sure you want to unpublish Wiki": "Ali ste prepri\u010dani, da \u017eelite neobjaviti Wiki?",
    "Are you sure you want to unshare {placeholder} ?": "Ali ste prepri\u010dani, da \u017eelite preklicati dovoljenje za skrbnika za {placeholder}?",
    "At server": "At server",
    "Audio": "Audio",
    "Auth Token created": "Auth Token created",
    "Auth Token deleted": "Auth Token deleted",
    "Auto deletion": "Auto deletion",
    "Automatically delete files that are not modified within certain days:": "Automatically delete files that are not modified within certain days:",
    "Avatar": "Prikazna slika",
    "Avatar updated": "Avatar updated",
    "Avatar:": "Slika:",
    "Back": "Back",
    "Basic": "Basic",
    "Bell Icon": "Bell Icon",
    "Besides Write permission, user can also share the library.": "Besides Write permission, user can also share the library.",
    "Branding": "Branding",
    "By day": "By day",
    "By month": "By month",
    "By name ascending": "By name ascending",
    "By name descending": "By name descending",
    "By quarter": "By quarter",
    "By size ascending": "By size ascending",
    "By size descending": "By size descending",
    "By time ascending": "By time ascending",
    "By time descending": "By time descending",
    "By week": "By week",
    "By year": "By year",
    "Can not copy folder %(src)s to its subfolder %(des)s": "Can not copy folder %(src)s to its subfolder %(des)s",
    "Can not move folder %(src)s to its subfolder %(des)s": "Can not move folder %(src)s to its subfolder %(des)s",
    "Cancel": "Prekli\u010di",
    "Cancel All": "Prekli\u010di vse",
    "Cannot move parent page to child page": "Cannot move parent page to child page",
    "Capture information": "Capture information",
    "Capture time": "Capture time",
    "Card": "Karta",
    "Certificate": "Certificate",
    "Change": "Spremeni",
    "Change Password": "Spremeni geslo",
    "Change Password of Library {placeholder}": "Change Password of Library {placeholder}",
    "Change cover": "Change cover",
    "Change group to department": "Change group to department",
    "Change to department": "Change to department",
    "Changes": "Spremembe",
    "Checkbox": "Checkbox",
    "Choose date": "Choose date",
    "Clean": "Po\u010disti",
    "Clean succeeded.": "Clean succeeded.",
    "Cleaned trash": "Cleaned trash",
    "Clear": "Po\u010disti",
    "Clear Trash": "Sprazni ko\u0161",
    "Clear files in trash and history\uff1a": "Po\u010disti datoteke v ko\u0161u in zgodovino:",
    "Clear selected": "Clear selected",
    "Clients": "Klient",
    "Close": "Zapri",
    "Close (Esc)": "Zapri (Esc)",
    "Code": "Vmesni kodo",
    "Collaborator": "Collaborator",
    "Collaborators": "Pridobniki",
    "Collapse all": "Collapse all",
    "Color space": "Color space",
    "Comment": "Komentar",
    "Comment details": "Detalji komentarja",
    "Comments": "Komentarji",
    "Community Edition": "Community Edition",
    "Compressed": "Compressed",
    "Configure Seafile": "Configure Seafile",
    "Configure your Identity Provider": "Configure your Identity Provider",
    "Confirm": "Potrdi",
    "Confirm Password": "Potrdite geslo",
    "Confirm password": "Confirm password",
    "Connect": "Connect",
    "Contact Email": "Contact Email",
    "Contact Email:": "Kontaknti email naslov:",
    "Contact Information": "Contact Information",
    "Contact information is required.": "Zahtevane so kontaktne informacije.",
    "Content Scan Records": "Content Scan Records",
    "Convert & Export": "Convert & Export",
    "Convert Wiki": "Convert Wiki",
    "Convert to Markdown": "Convert to Markdown",
    "Convert to docx": "Convert to docx",
    "Convert to sdoc": "Convert to sdoc",
    "Convert with ONLYOFFICE": "Convert with ONLYOFFICE",
    "Converting, please wait...": "Converting, please wait...",
    "Copied": "Kopirano",
    "Copied link to clipboard": "Copied link to clipboard",
    "Copy": "Kopiraj",
    "Copy failed": "Copy failed",
    "Copy link": "Copy link",
    "Copy selected": "Copy selected",
    "Copy selected item(s) to:": "Copy selected item(s) to:",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "Copy the IdP's certificate and paste it here. The certificate format is as follows:",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.",
    "Copy {num} items": "Copy {num} items",
    "Copy {placeholder} to": "Copy {placeholder} to",
    "Copyright Infringement": "Copyright Infringement",
    "Count": "\u0160tetje",
    "Cover": "Cover",
    "Create": "Ustvari",
    "Create At": "Ustvaril ob",
    "Create Group": "Create Group",
    "Create Library": "Create Library",
    "Create Report": "Create Report",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Create a DNS TXT record to confirm the ownership of your Email Domain.",
    "Create a new tag": "Dodaj mo\u017enost",
    "Created": "Created",
    "Created At": "Ustvarjeno ob",
    "Created Files": "Created Files",
    "Created draft": "Created draft",
    "Created file": "Created file",
    "Created folder": "Created folder",
    "Created group {group_name}": "Created group {group_name}",
    "Created library": "Ustvarjena knji\u017enica",
    "Created library {library_name} with {owner} as its owner": "Created library {library_name} with {owner} as its owner",
    "Created time": "Ustvarjeno",
    "Created {n} files": "Created {n} files",
    "Creator": "Ustvaril",
    "Current Connected Devices": "Current Connected Devices",
    "Current Library": "Trenutna knji\u017enica",
    "Current Path: ": "Trenutna pot:",
    "Current Version": "Trenutna razli\u010dica",
    "Current page": "Current page",
    "Current password": "Current password",
    "Current password cannot be blank": "Trenutno geslo ne more biti prazno",
    "Current path: ": "Trenutna pot:",
    "Custom CSS": "Custom CSS",
    "Custom properties": "Custom properties",
    "Custom sharing permissions": "Custom sharing permissions",
    "Customer Portal": "Portal strank",
    "Customize URL": "Customize URL",
    "DNS TXT Value": "DNS TXT Value",
    "Date": "Datum",
    "Date Invalid.": "Date Invalid.",
    "Day": "Day",
    "Default": "Prednastavljeno",
    "Delete": "Izbri\u0161i",
    "Delete Account": "Izbri\u0161i ra\u010dun",
    "Delete Department": "Delete Department",
    "Delete Expired Invitations": "Delete Expired Invitations",
    "Delete File": "Delete File",
    "Delete Folder": "Delete Folder",
    "Delete Group": "Odstranitev skupine",
    "Delete Library": "Izbri\u0161i knji\u017enico",
    "Delete Member": "Izbri\u0161i \u010dlana",
    "Delete Notification": "Izbri\u0161i obvestilo",
    "Delete Organization": "Odstranitev organizacije",
    "Delete Password": "Delete Password",
    "Delete T&C": "Delete T&C",
    "Delete User": "Izbri\u0161i uporabnika",
    "Delete Users": "Delete Users",
    "Delete WebDAV Password": "Delete WebDAV Password",
    "Delete file": "Delete file",
    "Delete files from this device the next time it comes online.": "Delete files from this device the next time it comes online.",
    "Delete folder": "Delete folder",
    "Delete group": "Delete group",
    "Delete page": "Delete page",
    "Delete property": "Delete property",
    "Delete selected": "Delete selected",
    "Delete share links": "Delete share links",
    "Deleted": "Izbrisan",
    "Deleted Libraries": "Deleted Libraries",
    "Deleted Time": "\u010cas izbrisa",
    "Deleted directories": "Izbrisane mape",
    "Deleted draft": "Deleted draft",
    "Deleted file": "Deleted file",
    "Deleted files": "Izbrisane datoteke",
    "Deleted folder": "Deleted folder",
    "Deleted group {group_name}": "Deleted group {group_name}",
    "Deleted library": "Izbrisana knji\u017enica",
    "Deleted library {library_name}": "Deleted library {library_name}",
    "Deleted option": "Deleted option",
    "Deleted user %s": "Deleted user %s",
    "Deleted user {user}": "Deleted user {user}",
    "Department renamed": "Department renamed",
    "Departments": "Departments",
    "Description": "Opis",
    "Description is required": "Opis je zahtevan",
    "Desktop": "Desktop",
    "Detail": "Podrobnosti",
    "Details": "Podrobnosti",
    "Device": "Device",
    "Device Name": "Naziv naprave",
    "Device make": "Device make",
    "Device model": "Device model",
    "Devices": "Naprave",
    "Dimensions": "Dimensions",
    "Direct download link": "Direct download link",
    "Direct download link is copied to the clipboard.": "Direct download link is copied to the clipboard.",
    "Disconnect": "Disconnect",
    "Discussion": "Razprave",
    "Display files": "Display files",
    "Do not automatically delete files": "Do not automatically delete files",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "Do you really want to turn off extended properties? Existing properties will all be deleted.",
    "Document": "Document",
    "Document conversion failed.": "Document conversion failed.",
    "Document keywords": "Document keywords",
    "Domain verified": "Domain verified",
    "Don't ignore": "Don't ignore",
    "Don't keep history": "Ne obdr\u017ei zgodovine",
    "Don't replace": "Don't replace",
    "Don't send emails": "Don't send emails",
    "Done": "Done",
    "Down": "Navzdol",
    "Download": "Prenos",
    "Download and upload": "Download and upload",
    "Duplicate": "Duplicate",
    "Duplicate page": "Duplicate page",
    "Edit": "Uredi",
    "Edit format settings": "Edit format settings",
    "Edit labels": "Edit labels",
    "Edit metadata properties": "Edit metadata properties",
    "Edit multiple select": "Edit multiple select",
    "Edit on cloud and download": "Edit on cloud and download",
    "Edit on cloud only": "Edit on cloud only",
    "Edit permission": "Edit permission",
    "Edit single select": "Edit single select",
    "Edit succeeded": "Urejanje uspe\u0161no",
    "Edit succeeded.": "Edit succeeded.",
    "Email": "Email",
    "Email Domain": "Email Domain",
    "Email Notification": "Email Notification",
    "Email is invalid.": "Email is invalid.",
    "Email notification updated": "Email notification updated",
    "Emails": "Emails",
    "Emails, separated by ','": "Emails, separated by ','",
    "Emojis": "Emojis",
    "Empty": "Prazno",
    "Enable Two-Factor Authentication": "Omogo\u010di dvo\u010drkovno verifikacijo",
    "Enable branding CSS": "Omogo\u010di branding CSS",
    "Enable departments feature": "Omogo\u010di funkcijo oddelkov",
    "Enable extended properties": "Omogo\u010di raz\u0161irjene lastnosti",
    "Enable face recognition to identify people in your photos.": "Omogo\u010di prepoznavo ljudi v va\u0161ih slikah.",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Omogo\u010di sistemskemu skrbniku dodajanje Pogojev uporabe in vsi uporabniki morajo sprejeti pogoje.",
    "Enable tags to add tags to files and search files by tags.": "Omogo\u010di ozna\u010devanje z oznakami, da dodate oznake datotekam in poi\u0161\u010de datoteke po oznakah.",
    "Enable terms and conditions": "Omogo\u010di pogoje uporabe",
    "Enable two factor authentication": "Omogo\u010di dvo\u010drkovno overjanje",
    "Enable users to clean trash": "Omogo\u010di uporabnikom \u010di\u0161\u010denje ko\u0161a",
    "Enable users to share libraries to any groups in the system.": "Omogo\u010di uporabnikom, da delijo knji\u017enice na vse skupine v sistemu.",
    "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups": "Omogo\u010di deli na vse skupine",
    "Encrypt": "Zakriptiraj",
    "Encrypted library": "Encrypted library",
    "End date": "End date",
    "Enter characters to start searching": "Enter characters to start searching",
    "Error": "Napaka",
    "Errors": "Errors",
    "European": "European",
    "Exact date": "Exact date",
    "Exit Institution Admin": "Skrbnik izstopne institucije",
    "Exit Organization Admin": "Skrbnik za izhod iz organizacije",
    "Exit System Admin": "Izhod iz sistemske admin",
    "Expand all": "Expand all",
    "Expiration": "\u010cas veljavnosti",
    "Expiration days": "Expiration days",
    "Expiration time": "Expiration time",
    "Expired": "Expired",
    "Expired at": "Expired at",
    "Export": "Export",
    "Export Excel": "Izvozi v Excel",
    "Export as docx": "Export as docx",
    "Export as zip": "Export as zip",
    "Export tags": "Export tags",
    "Exporting": "Exporting",
    "Exporting...": "Exporting...",
    "Exposure time": "Exposure time",
    "Extended properties": "Extended properties",
    "Extension Prompts": "Extension Prompts",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Extensions of text files that can be online previewed, each suffix is separated by a comma.",
    "Extract file detail": "Extract file detail",
    "Extract file details": "Extract file details",
    "F number": "F number",
    "Face recognition": "Face recognition",
    "Failed": "Neuspe\u0161no",
    "Failed imported options": "Failed imported options",
    "Failed to convert {name}.": "Failed to convert {name}.",
    "Failed to copy %(name)s": "Failed to copy %(name)s",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Failed to copy %(name)s and %(amount)s other item(s).",
    "Failed to copy %(name)s.": "Failed to copy %(name)s.",
    "Failed to copy files to another library.": "Failed to copy files to another library.",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Failed to delete %(virus_file) from library %(library): %(error_msg)",
    "Failed to delete property": "Failed to delete property",
    "Failed to delete records": "Failed to delete records",
    "Failed to delete {name}": "Failed to delete {name}",
    "Failed to delete {name} and {n} other items.": "Failed to delete {name} and {n} other items.",
    "Failed to delete {name}.": "Failed to delete {name}.",
    "Failed to download. The total size of the files exceeded the limit.": "Failed to download. The total size of the files exceeded the limit.",
    "Failed to duplicate page": "Failed to duplicate page",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "Failed to export. Please check whether the size of table attachments exceeds the limit.",
    "Failed to extract file details": "Failed to extract file details",
    "Failed to generate description": "Failed to generate description",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Failed to ignore %(virus_file) from library %(library): %(error_msg)",
    "Failed to insert property": "Failed to insert property",
    "Failed to modify filter": "Failed to modify filter",
    "Failed to modify group": "Failed to modify group",
    "Failed to modify hidden properties": "Failed to modify hidden properties",
    "Failed to modify people name": "Failed to modify people name",
    "Failed to modify property data": "Failed to modify property data",
    "Failed to modify property order": "Failed to modify property order",
    "Failed to modify records": "Failed to modify records",
    "Failed to modify sort": "Failed to modify sort",
    "Failed to move %(name)s and %(amount)s other item(s).": "Failed to move %(name)s and %(amount)s other item(s).",
    "Failed to move %(name)s.": "Failed to move %(name)s.",
    "Failed to move files to another library.": "Failed to move files to another library.",
    "Failed to move {name}.": "Failed to move {name}.",
    "Failed to rename property": "Failed to rename property",
    "Failed to restore records": "Failed to restore records",
    "Failed to restore {name}": "Failed to restore {name}",
    "Failed to restore {name} and {n} other items": "Failed to restore {name} and {n} other items",
    "Failed to save": "Failed to save",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "Failed to send to {email_placeholder}: {errorMsg_placeholder}",
    "Failed to unshare {name}": "Failed to unshare {name}",
    "Failed to upload {file_name}.": "Failed to upload {file_name}.",
    "Failed. Please check the network.": "Neuspe\u0161no. Prosimo, preverite povezavo.",
    "File": "Datoteka",
    "File Access": "File Access",
    "File Operations": "File Operations",
    "File Update": "File Update",
    "File Upload": "Nalo\u017ei datoteko",
    "File Uploading...": "Nalaganje datoteke...",
    "File already exists.": "File already exists.",
    "File collaborators": "File collaborators",
    "File details": "File details",
    "File download is disabled: the share link traffic of owner is used up.": "Prenos datotek je onemogo\u010deno: dovoljena koli\u010dina prenosa datotek uporabnika je prese\u017eena",
    "File expire time": "File expire time",
    "File extension white list": "File extension white list",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.",
    "File extensions can only be {placeholder}.": "File extensions can only be {placeholder}.",
    "File is locked by others.": "File is locked by others.",
    "File name": "File name",
    "File owner": "File owner",
    "File reviewer": "File reviewer",
    "File size is too large.": "File size is too large.",
    "File status": "File status",
    "File too large": "File too large",
    "File type": "File type",
    "Files": "Datoteke",
    "Files and folders": "Files and folders",
    "Filter": "Filtriraj",
    "Filters": "Filters",
    "Find a tag": "Find a tag",
    "Find modifiers": "Find modifiers",
    "Focal length": "Focal length",
    "Folder": "Mapa",
    "Folder Permission": "Pravice mape",
    "Folder does not exist.": "Folder does not exist.",
    "Folders": "Mape",
    "Force user to change password when account is newly added or reset by admin": "Force user to change password when account is newly added or reset by admin",
    "Force user to use a strong password when sign up or change password.": "Force user to use a strong password when sign up or change password.",
    "Format": "Format",
    "Freeze Document": "Freeze Document",
    "Freeze user account when failed login attempts exceed limit.": "Freeze user account when failed login attempts exceed limit.",
    "Frozen by {name}": "Frozen by {name}",
    "Full screen": "Prikaz v celotni zaslon",
    "Gallery": "Gallery",
    "General information": "General information",
    "Generate": "Ustvari",
    "Generate Link": "Generate Link",
    "Generate description": "Generate description",
    "Generate links in batch": "Generate links in batch",
    "Generate share link": "Ustvari povezavo za skupno rabo",
    "Germany Russia etc": "Germany Russia etc",
    "Global Address Book": "Global Address Book",
    "Greater than or equal to {minDays_placeholder} days": "Greater than or equal to {minDays_placeholder} days",
    "Grid view": "Grid view",
    "Group": "Skupine",
    "Group Permission": "Pravice skupine",
    "Group Shares": "Group Shares",
    "Group by": "Group by",
    "Group members": "Group members",
    "Grouped by 1 property": "Grouped by 1 property",
    "Groups": "Skupine",
    "Guest": "Gost",
    "Handled": "Handled",
    "Help": "Pomo\u010d",
    "Hide": "Skrij",
    "Hide all": "Sakri vse",
    "Hide properties": "Hide properties",
    "History": "Zgodovina",
    "History Versions": "History Versions",
    "IP": "IP",
    "ISO": "ISO",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "If notifications have not been read within one hour, they will be sent to your mailbox.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.",
    "Ignore": "Ignore",
    "Ignored": "Ignored",
    "Import Users": "Import Users",
    "Import members": "Import members",
    "Import members from a .xlsx file": "Import members from a .xlsx file",
    "Import options": "Import options",
    "Import sdoc": "Import sdoc",
    "Import tags": "Import tags",
    "Import users": "Uvozi uporabnike",
    "Import users from a .xlsx file": "Import users from a .xlsx file",
    "In progress": "In progress",
    "In review": "In review",
    "Inactive": "Neaktiven",
    "Info": "Info",
    "Institution Admin": "Upravnik institucije",
    "Internal Link": "Internal Link",
    "Internal Server Error": "Notranja napaka stre\u017enika",
    "Internal link has been copied to clipboard": "Kopiraj interni povezavo",
    "Invalid destination path": "Neveljavna kon\u010dna pot",
    "Invalid filename.": "Invalid filename.",
    "Invalid filter": "Napa\u010den filtriraj",
    "Invalid month, should be yyyymm.": "Invalid month, should be yyyymm.",
    "Invalid regular expression": "Invalid regular expression",
    "Invisible": "Invisible",
    "Invitations": "Invitations",
    "Invite Guest": "Invite Guest",
    "Invite Time": "Invite Time",
    "Invite users": "Invite users",
    "Invited at": "Invited at",
    "Inviter": "Inviter",
    "Is expired": "Is expired",
    "It is required.": "Je zahtevano.",
    "It may take some time, please wait.": "It may take some time, please wait.",
    "Keep full history": "Obdr\u017ei vso zgodovino",
    "Keep sharing": "Keep sharing",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP(imported)",
    "Label": "Label",
    "Label Current State": "Label Current State",
    "Labels": "Labels",
    "Language": "Jezik",
    "Language Setting": "Nastavitev jezika",
    "Last Access": "Zadnji\u010d dostopano",
    "Last Login": "Zadnja prijava",
    "Last Update": "Posodobljeno",
    "Last modification": "Zadnja sprememba",
    "Last modified by": "Last modified by",
    "Last modified time": "Last modified time",
    "Last modifier": "Last modifier",
    "Leave": "Leave",
    "Leave Group": "Leave Group",
    "Leave Share": "Zapusti deljeno",
    "Leave group": "Zapusti skupino",
    "Leave this page? The system may not save your changes.": "Leave this page? The system may not save your changes.",
    "Less than or equal to {maxDays_placeholder} days": "Less than or equal to {maxDays_placeholder} days",
    "Libraries": "Knji\u017enice",
    "Library": "Knji\u017enica",
    "Library Type": "Library Type",
    "Library does not exist": "Knji\u017enica ne obstaja",
    "Limits": "Omejitve",
    "Link": "Povezava",
    "Link has been copied to clipboard": "Link has been copied to clipboard",
    "Linked Devices": "Linked Devices",
    "Links": "Povezave",
    "List view": "List view",
    "List your account in global address book, so that others can find you by typing your name.": "List your account in global address book, so that others can find you by typing your name.",
    "Load all": "Load all",
    "Loading": "Loading",
    "Loading...": "Nalagam...",
    "Location": "Lokacija",
    "Lock": "Zakleni",
    "Log out": "Odjava",
    "Login": "Login",
    "Login ID": "Login ID",
    "Logo updated": "Logo updated",
    "Logs": "Dnevniki",
    "Long text": "Long text",
    "Manage group members": "Manage group members",
    "Manage members": "Manage members",
    "Mark all as read": "Ozna\u010di vse kot prebrane",
    "Mark all read": "Ozna\u010di kot prebrano",
    "Mark as resolved": "Ozna\u010di kot re\u0161eno",
    "Max": "Max",
    "Max number of members": "Max number of members",
    "Member": "\u010clan",
    "Members": "\u010clani",
    "Message": "Sporo\u010dilo",
    "Message (optional):": "Sporo\u010dilo (opcijsko):",
    "Migrate User": "Migrate User",
    "Mobile": "Mobile",
    "Modification Details": "Podrobnosti sprememb",
    "Modified": "Spremenjen",
    "Modified by": "Modified by",
    "Modified by:": "Modified by:",
    "Modified files": "Spremenjene datoteke",
    "Modifier": "Urejal",
    "Modify": "Modify",
    "Modify includes modify file, move/rename file and folder": "Modify includes modify file, move/rename file and folder",
    "Modify name": "Modify name",
    "Month": "Month",
    "Month:": "Mesec:",
    "Monthly User Traffic": "Monthly User Traffic",
    "More": "Ve\u010d",
    "More operations": "Ve\u010d operacij",
    "Move": "Premakni",
    "Move selected item(s) to:": "Move selected item(s) to:",
    "Move {num} items": "Move {num} items",
    "Move {placeholder} to": "Move {placeholder} to",
    "Moved file": "Moved file",
    "Moved folder": "Moved folder",
    "Multiple select": "Multiple select",
    "My Libraries": "My Libraries",
    "My Wikis": "My Wikis",
    "Name": "Ime",
    "Name already exists": "Name already exists",
    "Name cannot be double dots": "Name cannot be double dots",
    "Name cannot be empty": "Name cannot be empty",
    "Name cannot contain backslash": "Name cannot contain backslash",
    "Name cannot contain backtick": "Name cannot contain backtick",
    "Name cannot contain curly braces": "Name cannot contain curly braces",
    "Name cannot contain dots": "Name cannot contain dots",
    "Name cannot contain slash": "Name cannot contain slash",
    "Name is required": "Naziv je zahtevan",
    "Name is required.": "Ime je zahtevano.",
    "Name or ID": "Name or ID",
    "Name should be string": "Name should be string",
    "Name should not include '/'.": "Ime ne sme vsebovati znaka '/'.",
    "Name updated": "Name updated",
    "Name(optional)": "Ime (opcija)",
    "Network error": "Network error",
    "New": "Nova",
    "New Department": "New Department",
    "New Department Library": "New Department Library",
    "New Excel File": "New Excel File",
    "New File": "Nova datoteka",
    "New Folder": "Nova mapa",
    "New Group": "Nova skupina",
    "New Library": "Nova knji\u017enica",
    "New Markdown File": "New Markdown File",
    "New Password": "Novo geslo",
    "New Password Again": "Ponovitev novega gesla",
    "New PowerPoint File": "New PowerPoint File",
    "New SeaDoc File": "New SeaDoc File",
    "New Sub-department": "New Sub-department",
    "New Word File": "New Word File",
    "New directories": "Nove mape",
    "New file name": "New file name",
    "New files": "Nove datoteke",
    "New folder name": "New folder name",
    "New page": "Nova stran",
    "New password": "Novo geslo",
    "New password cannot be the same as old password": "New password cannot be the same as old password",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.",
    "New password is too short": "Novo geslo je prekratko",
    "New passwords don't match": "Novi gesli se ne ujemata",
    "New view": "New view",
    "Next": "Naslednja",
    "Next (Right arrow key)": "Naprej (Desna pu\u0161\u010dica)",
    "Next modification": "Naslednja sprememba",
    "No Admin login logs": "No Admin login logs",
    "No Admin operation logs": "No Admin operation logs",
    "No Wikis": "No Wikis",
    "No changes": "Ni sprememb",
    "No collaborators": "No collaborators",
    "No collaborators available": "No collaborators available",
    "No comment yet.": "Trenutno \u0161e ni noben komentar",
    "No connected devices": "No connected devices",
    "No deleted libraries": "No deleted libraries",
    "No favorites": "No favorites",
    "No file": "No file",
    "No file access logs": "No file access logs",
    "No file update logs": "No file update logs",
    "No filters": "Ni filtrov",
    "No folders shared": "No folders shared",
    "No groupings applied to this view.": "No groupings applied to this view.",
    "No groups": "No groups",
    "No guest invitations": "No guest invitations",
    "No invitations": "No invitations",
    "No libraries": "No libraries",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.",
    "No libraries have been shared with you": "No libraries have been shared with you",
    "No libraries have been shared with you from other servers.": "No libraries have been shared with you from other servers.",
    "No libraries shared": "No libraries shared",
    "No libraries shared with this group": "No libraries shared with this group",
    "No linked devices": "No linked devices",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.",
    "No login logs": "No login logs",
    "No members": "No members",
    "No more activities": "No more activities",
    "No notifications": "No notifications",
    "No option": "No option",
    "No options": "No options",
    "No options available": "Ni mo\u017enosti",
    "No permission logs": "No permission logs",
    "No properties available to be hidden": "No properties available to be hidden",
    "No record": "No record",
    "No result": "Brez zadetka",
    "No results": "Ni rezultata",
    "No results matching": "No results matching",
    "No share links": "No share links",
    "No sorts": "Ni razvrstitev",
    "No sync errors": "No sync errors",
    "No tags": "Noben oznaka",
    "No terms and conditions": "No terms and conditions",
    "No upload links": "No upload links",
    "No version history": "No version history",
    "None": "Brez",
    "Not allow user to clean library trash": "Not allow user to clean library trash",
    "Not allow user to create encrypted libraries": "Not allow user to create encrypted libraries",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.",
    "Notification": "Obvestilo",
    "Notification Detail": "Podrobnosti obvestila",
    "Notifications": "Obvestila",
    "Notifications of file changes": "Notifications of file changes",
    "Number": "Number",
    "Number of days ago": "Number of days ago",
    "Number of days from now": "Number of days from now",
    "Number of days that keep user sign in.": "Number of days that keep user sign in.",
    "Number of groups": "\u0160tevilo skupin",
    "Number of links": "Number of links",
    "Number of members": "\u0160tevilo uporabnikov",
    "Off": "Off",
    "Old Password": "Staro geslo",
    "Old Wikis": "Old Wikis",
    "On": "On",
    "One month ago": "One month ago",
    "One month from now": "One month from now",
    "One week ago": "One week ago",
    "One week from now": "One week from now",
    "Online Preview": "Online Preview",
    "Online Read-Only": "Online Read-Only",
    "Online Read-Only folder": "Online Read-Only folder",
    "Online Read-Only library": "Online Read-Only library",
    "Online Read-Write": "Online Read-Write",
    "Online Read-Write folder": "Online Read-Write folder",
    "Online Read-Write library": "Online Read-Write library",
    "Online view is not applicable to this file format": "Online view is not applicable to this file format",
    "Only Show": "Only Show",
    "Only files": "Only files",
    "Only folders": "Only folders",
    "Only keep a period of history:": "Obdr\u017ei zgodovino samo dolo\u010deno obdobje:",
    "Only pictures": "Only pictures",
    "Only videos": "Only videos",
    "Open file": "Open file",
    "Open file in new tab": "Open file in new tab",
    "Open folder": "Open folder",
    "Open folder in new tab": "Open folder in new tab",
    "Open in new tab": "Open in new tab",
    "Open parent folder": "Odpri nadrejeno mapo",
    "Open via Client": "Odpri s klientom",
    "Operation": "Mo\u017enosti",
    "Operation succeeded.": "Operacija uspe\u0161no izvedena.",
    "Operations": "Operacije",
    "Optional": "Izbirno",
    "Options imported": "Options imported",
    "Or": "Ali",
    "Organization": "Organizacija",
    "Organization Admin": "Skrbnik organizacije",
    "Organizations": "Organizacija",
    "Original path": "Original path",
    "Other": "Other",
    "Other Libraries": "Ostale knji\u017enice",
    "Others": "Others",
    "Out of quota.": "Out of quota.",
    "Outdated": "Outdated",
    "Outline": "Navodilo",
    "Owned Libraries": "Owned Libraries",
    "Owner": "Lastnik",
    "Owner can use admin panel in an organization, must be a new account.": "Lastnik lahko uporabi nadzorno plo\u0161\u010do v organizaciji, mora biti nov ra\u010dun.",
    "Packaging...": "Packaging...",
    "Page name": "Page name",
    "Pages": "Strani",
    "Parent folder": "Parent folder",
    "Password": "Geslo",
    "Password again": "Ponovno geslo",
    "Password cannot be blank": "Geslo ne more biti prazno",
    "Password is too short": "Geslo je prekratko",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols",
    "Password removed": "Password removed",
    "Password reset": "Password reset",
    "Password set": "Password set",
    "Password strength": "Password strength",
    "Password updated": "Password updated",
    "Passwords do not match.": "Passwords do not match.",
    "Passwords don't match": "Gesli se ne ujemata",
    "Path": "Path",
    "Per 4 hours": "Per 4 hours",
    "Per day": "Per day",
    "Per hour": "Per hour",
    "Per week": "Per week",
    "Permission": "Dovoljenja",
    "Permission denied": "Dostop zavrnjen",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Permission denied. Please try {placeholder-left}login again.{placeholder-right}",
    "Permission name": "Permission name",
    "Person image": "Person image",
    "Picture": "Picture",
    "Pictures and videos": "Pictures and videos",
    "Platform": "Os",
    "Please check the network.": "Prosimo, preverite povezavo.",
    "Please choose a .xlsx file.": "Please choose a .xlsx file.",
    "Please choose an image file.": "Please choose an image file.",
    "Please enter 1 or more character": "Prosimo, vpi\u0161i 1 ali ve\u010d znakov",
    "Please enter a new password": "Please enter a new password",
    "Please enter a non-negative integer": "Prosimo, vnesite nenegativno celo \u0161tevilo",
    "Please enter a password.": "Please enter a password.",
    "Please enter a positive integer": "Please enter a positive integer",
    "Please enter an integer bigger than 1 as number of links.": "Please enter an integer bigger than 1 as number of links.",
    "Please enter an integer not bigger than {max_number} as number of links.": "Please enter an integer not bigger than {max_number} as number of links.",
    "Please enter days": "Prosimo, vnesite \u0161tevilo dni",
    "Please enter password": "Prosimo vnesite geslo",
    "Please enter the new password again": "Prosimo vnesite ponovno novo geslo",
    "Please enter the old password": "Prosimo vnesite novo geslo",
    "Please enter the password again": "Prosimo ponovno vnesite geslo",
    "Please input at least an email.": "Prismo vnesite najmanj en email.",
    "Please select a file": "Please select a file",
    "Please select a library to share.": "Please select a library to share.",
    "Please select an expiration time": "Please select an expiration time",
    "Please upload no more than {maxFiles} files at a time.": "Please upload no more than {maxFiles} files at a time.",
    "Preset hide properties": "Preset hide properties",
    "Preview and download": "Pregledaj in preveri",
    "Preview online": "Preview online",
    "Preview only": "Pregledaj le",
    "Previous": "Prej\u0161nja",
    "Previous (Left arrow key)": "Prej\u0161nji (Leva pu\u0161\u010dica)",
    "Print": "Natisni",
    "Professional Edition": "Professional Edition",
    "Profile": "Profil",
    "Profile Setting": "Nastavitve profila",
    "Properties": "Properties",
    "Property name": "Property name",
    "Publish": "Objavi",
    "Publish Wiki": "Publish Wiki",
    "Published": "Objavljeno",
    "Quota": "Quota",
    "Quota is invalid.": "Quota is invalid.",
    "Rate": "Rate",
    "Read-Only": "Samo branje",
    "Read-Only folder": "Read-Only folder",
    "Read-Only library": "Read-Only library",
    "Read-Write": "Branje-pisanje",
    "Read-Write folder": "Read-Write folder",
    "Read-Write library": "Read-Write library",
    "Really want to delete this group?": "Really want to delete this group?",
    "Really want to delete your account?": "Ali res \u017eelite odstraniti svoj ra\u010dun?",
    "Really want to leave this group?": "Really want to leave this group?",
    "Recognizing portraits. Please refresh the page later.": "Recognizing portraits. Please refresh the page later.",
    "Refresh": "Ponovno nalo\u017ei",
    "Remove": "Odstrani",
    "Rename": "Preimenuj",
    "Rename Department": "Rename Department",
    "Rename File": "Preimenuj datoteko",
    "Rename Folder": "Rename Folder",
    "Rename Group": "Rename Group",
    "Rename Wiki": "Rename Wiki",
    "Rename file": "Rename file",
    "Rename folder": "Rename folder",
    "Rename group to": "Rename group to",
    "Rename property": "Rename property",
    "Renamed file": "Renamed file",
    "Renamed folder": "Renamed folder",
    "Renamed library": "Renamed library",
    "Renamed or Moved files": "Preimenovane ali premaknjene datoteke",
    "Renaming {name} failed": "Renaming {name} failed",
    "Replace": "Zamenjaj",
    "Replace file {filename}?": "Replace file {filename}?",
    "Replacing it will overwrite its content.": "Replacing it will overwrite its content.",
    "Report Abuse": "Report Abuse",
    "Reporter": "Reporter",
    "Reports": "Reports",
    "Required at least three letters.": "Zahtevanih je vsaj tri \u010drke.",
    "Reset": "Reset",
    "Reset Password": "Ponastavitev gesla",
    "Reset WebDAV Password": "Reset WebDAV Password",
    "Reset library password": "Reset library password",
    "ResetPwd": "Spremen.Geslo",
    "Resetting user's password, please wait for a moment.": "Resetting user's password, please wait for a moment.",
    "Resolved comments": "Risoljeni komentarji",
    "Restore": "Obnovi",
    "Restore Library": "Obnovi knji\u017enico",
    "Restored file": "Restored file",
    "Restored folder": "Restored folder",
    "Restored library": "Restored library",
    "Restored {name}": "Restored {name}",
    "Restored {name} and {n} other items": "Restored {name} and {n} other items",
    "Resubmit": "Ponovi potrditev",
    "Result": "Rezultat",
    "Revoke Access": "Revoke Access",
    "Revoke Admin": "Odstrani iz admin",
    "Role": "Vloga",
    "SAML config": "SAML config",
    "SAML config updated": "SAML config updated",
    "Save": "Shrani",
    "Save Selected Items": "Save Selected Items",
    "Save to:": "Save to:",
    "Saving...": "Shranjujem\u2026.",
    "Scan the QR code to view the shared content directly": "Skenirajte QR kodo za neposredno ogled vsebine v skupni rabi",
    "SeaTable integration": "SeaTable integration",
    "Seafile": "Seafile",
    "Search": "Iskanje",
    "Search Groups": "Search Groups",
    "Search Libraries": "Search Libraries",
    "Search Organizations": "Search Organizations",
    "Search Users": "Search Users",
    "Search collaborator": "Iskanje pridobnika",
    "Search collaborators": "Search collaborators",
    "Search department": "Iskanje oddelkov",
    "Search files": "Search files",
    "Search files in this library": "Iskanje datotek v tej knji\u017enici",
    "Search groups": "Search groups",
    "Search groups by name": "Search groups by name",
    "Search libraries by name or ID": "Search libraries by name or ID",
    "Search libraries by owner": "Search libraries by owner",
    "Search option": "Iskanje mo\u017enosti",
    "Search organizations": "Search organizations",
    "Search property": "Search property",
    "Search users": "Search users",
    "Search users...": "Iskanje uporabnikov...",
    "Searching...": "Iskanje...",
    "Select File": "Select File",
    "Select a department": "Izberi oddelek",
    "Select a user": "Select a user",
    "Select a user as admin": "Select a user as admin",
    "Select all": "Select all",
    "Select an option": "Izberi mo\u017enost",
    "Select collaborators": "Select collaborators",
    "Select libraries to share": "Izberi knji\u017enice za skupno rabo",
    "Select option(s)": "Izberi mo\u017enost(je)",
    "Select up to 50 files": "Select up to 50 files",
    "Send": "Po\u0161lji",
    "Send activation Email after user registration.": "Send activation Email after user registration.",
    "Send to:": "Po\u0161lji za:",
    "Sending new password...": "Sending new password...",
    "Sending...": "Po\u0161iljam...",
    "Server Version: ": "Verzija stre\u017enika:",
    "Set Admin": "Nastavi za admin",
    "Set Contact Email": "Set Contact Email",
    "Set Download Rate Limit": "Set Download Rate Limit",
    "Set Login ID": "Set Login ID",
    "Set Name": "Set Name",
    "Set Password": "Set Password",
    "Set Quota": "Nastavi kvoto",
    "Set Upload Rate Limit": "Set Upload Rate Limit",
    "Set WebDAV Password": "Set WebDAV Password",
    "Set max number of members": "Set max number of members",
    "Set password": "Set password",
    "Set permission": "Ustavi dovoljenja",
    "Set permission of {placeholder}": "Set permission of {placeholder}",
    "Set to current": "Nastavi na trenutno",
    "Set user contact email": "Set user contact email",
    "Set user default quota": "Set user default quota",
    "Set user name": "Set user name",
    "Set user quota": "Set user quota",
    "Setting library history is disabled by Admin.": "Setting library history is disabled by Admin.",
    "Settings": "Nastavitve",
    "Share": "Deli",
    "Share Admin": "Deljeno/Javno",
    "Share From": "Deljeno od",
    "Share Link": "Deli povezavo",
    "Share Links": "Deljene povezave",
    "Share To": "Deljeno z",
    "Share To:": "Share To:",
    "Share existing libraries": "Deli obstoje\u010de knji\u017enice",
    "Share link download": "Share link download",
    "Share link is copied to the clipboard.": "Share link is copied to the clipboard.",
    "Share link upload": "Share link upload",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.",
    "Share to group": "Deli s skupino",
    "Share to other server": "Deli z zunanjim stre\u017enikom",
    "Share to user": "Deli z uporabnikom",
    "Shared By": "V skupni rabi z",
    "Shared Libraries": "Deljene knji\u017enice",
    "Shared Links": "Skupne povezave",
    "Shared by: ": "Deljil:",
    "Shared with all": "Deljeno z vsemi",
    "Shared with me": "Deljeno z mano",
    "Show": "Prika\u017ei",
    "Show all": "Prika\u017ei vse",
    "Show changes": "Show changes",
    "Side Nav Menu": "Side Nav Menu",
    "Single select": "Single select",
    "Site name used in email sending": "Site name used in email sending",
    "Site title shown in a browser tab": "Site title shown in a browser tab",
    "Size": "Velikost",
    "Sort": "Razvrsti",
    "Sort ascending": "Sort ascending",
    "Sort descending": "Sort descending",
    "Space Used": "Poraba prostora",
    "Space Used / Quota": "Space Used / Quota",
    "Specific people with email address": "Specific people with email address",
    "Specific users in the team": "Specific users in the team",
    "Star": "Pomembno",
    "Start date": "Start date",
    "Status": "Stanje",
    "Status: enabled": "Status: omogo\u010deno",
    "Storage": "Storage",
    "Storage Backend": "Storage Backend",
    "Storage Used": "Storage Used",
    "Style": "Stil",
    "Submit": "Potrdi",
    "Success": "Uspeh",
    "Successfully added label(s) for library {placeholder}": "Successfully added label(s) for library {placeholder}",
    "Successfully change the group": "Successfully change the group",
    "Successfully changed library password.": "Successfully changed library password.",
    "Successfully cleared trash.": "Successfully cleared trash.",
    "Successfully converted the file.": "Successfully converted the file.",
    "Successfully copied %(name)s and %(amount)s other items.": "Uspe\u0161no kopirana %(name)s in %(amount)s ostalih datotek.",
    "Successfully copied %(name)s and 1 other item.": "Uspe\u0161no kopirana %(name)s in 1 dodatna datoteka.",
    "Successfully copied %(name)s.": "Uspe\u0161no kopirano %(name)s.",
    "Successfully copied files to another library.": "Successfully copied files to another library.",
    "Successfully deleted 1 item.": "Successfully deleted 1 item.",
    "Successfully deleted 1 share link": "Successfully deleted 1 share link",
    "Successfully deleted 1 user.": "Successfully deleted 1 user.",
    "Successfully deleted {name}": "Successfully deleted {name}",
    "Successfully deleted {name} and {n} other items": "Successfully deleted {name} and {n} other items",
    "Successfully deleted {name} and {n} other items.": "Successfully deleted {name} and {n} other items.",
    "Successfully deleted {name}.": "Successfully deleted {name}.",
    "Successfully deleted {number_placeholder} share links": "Successfully deleted {number_placeholder} share links",
    "Successfully deleted {user_number_placeholder} users.": "Successfully deleted {user_number_placeholder} users.",
    "Successfully edited labels.": "Successfully edited labels.",
    "Successfully invited %(email) and %(num) other people.": "Successfully invited %(email) and %(num) other people.",
    "Successfully invited %(email).": "Successfully invited %(email).",
    "Successfully moved %(name)s and %(amount)s other items.": "Supe\u0161no prestavljeno %(name)s in %(amount)s ostalih datotek.",
    "Successfully moved %(name)s and 1 other item.": "Uspe\u0161no prestavljeno %(name)s in 1 druga datoteka.",
    "Successfully moved %(name)s.": "Uspe\u0161no prestavljeno %(name)s.",
    "Successfully moved files to another library.": "Successfully moved files to another library.",
    "Successfully moved {name}.": "Successfully moved {name}.",
    "Successfully restored the library {library_name}.": "Successfully restored the library {library_name}.",
    "Successfully restored the library.": "Uspe\u0161no obnovljena knji\u017enica.",
    "Successfully restored.": "Successfully restored.",
    "Successfully revoke the admin permission of %s": "Uspe\u0161no preklicane pravice administratorja za %s",
    "Successfully revoked access of user {placeholder}.": "Successfully revoked access of user {placeholder}.",
    "Successfully revoked the admin permission of {placeholder}.": "Successfully revoked the admin permission of {placeholder}.",
    "Successfully saved": "Successfully saved",
    "Successfully sent to {placeholder}": "Uspe\u0161no poslano {placeholder}",
    "Successfully set %s as admin.": "Uspe\u0161no nastavljen %s kot admin.",
    "Successfully set it.": "Successfully set it.",
    "Successfully set library history.": "Successfully set library history.",
    "Successfully starred {library_name_placeholder}.": "Successfully starred {library_name_placeholder}.",
    "Successfully transferred the group.": "Successfully transferred the group.",
    "Successfully transferred the library.": "Successfully transferred the library.",
    "Successfully unlinked the device.": "Successfully unlinked the device.",
    "Successfully unshared {name}": "Successfully unshared {name}",
    "Successfully unstarred {library_name_placeholder}.": "Successfully unstarred {library_name_placeholder}.",
    "Suggestion": "Pristop",
    "Switch sort mode": "Switch sort mode",
    "Switch to plain text editor": "Preklopi v besedilni urejevalnik",
    "Switch to rich text editor": "Preklopi v virete urejevalnik",
    "Switch view mode": "Switch view mode",
    "Sync": "Sync",
    "Sync Download": "Sync Download",
    "Sync Upload": "Sync Upload",
    "System": "Sistem",
    "System Admin": "Sistemski admin",
    "System Info": "Informacije o sistemu",
    "System settings updated": "System settings updated",
    "Table": "Tabela",
    "Tag not found": "Oznaka ni bila najdena.",
    "Tagged Files": "Tagged Files",
    "Tags": "Oznake",
    "Team name": "Team name",
    "Template": "Template",
    "Terms": "Terms",
    "Terms and Conditions": "Terms and Conditions",
    "Text": "Text",
    "Text is required.": "Besedilo je zahtevano.",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.",
    "The file is too large. Allowed maximum size is 1MB.": "The file is too large. Allowed maximum size is 1MB.",
    "The imported options are invalid": "The imported options are invalid",
    "The least number of characters a share/upload link password should include.": "The least number of characters a share/upload link password should include.",
    "The least number of characters an encrypted library password should include.": "The least number of characters an encrypted library password should include.",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols",
    "The link is copied to the clipboard.": "The link is copied to the clipboard.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "The list of added, deleted and modified files will be sent to your mailbox.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "The maximum number of failed login attempts before showing CAPTCHA.",
    "The name \"{name}\" is already taken. Please choose a different name.": "The name \"{name}\" is already taken. Please choose a different name.",
    "The next month": "The next month",
    "The next numbers of days": "The next numbers of days",
    "The next week": "The next week",
    "The next year": "The next year",
    "The owner of this library has run out of space.": "Lastnik te knji\u017enice nima ve\u010d prostora.",
    "The password is too short.": "The password is too short.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.",
    "The password will be kept in the server for only 1 hour.": "Geslo bo hranjeno na stre\u017eniku za samo 1 uro.",
    "The past month": "The past month",
    "The past numbers of days": "The past numbers of days",
    "The past week": "The past week",
    "The past year": "The past year",
    "There is another option with this name": "There is another option with this name",
    "There is another property with this name": "There is another property with this name",
    "There is no information to display.": "There is no information to display.",
    "This file has been updated.": "Datoteka je posodobljena",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).",
    "This folder has no content at this time.": "This folder has no content at this time.",
    "This is a special group representing a department.": "This is a special group representing a department.",
    "This is required": "To je zahtevano",
    "This library has been set to read-only by admin and cannot be updated.": "This library has been set to read-only by admin and cannot be updated.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "This library has been shared to {user_amount} user(s) and {group_amount} group(s).",
    "This library is password protected": "Knji\u017enica je varovana z geslom",
    "This month": "This month",
    "This operation will not be reverted. Please think twice!": "Te operacije ni mogo\u010de povrniti. Prosimo premislite dvakrat!",
    "This property can not be deleted": "This property can not be deleted",
    "This property does not support sorting": "This property does not support sorting",
    "This property is not editable": "This property is not editable",
    "This user has not created or joined any groups": "Ta uporabnik ni ustvaril ali se pridru\u017eil nobeni skupini",
    "This week": "This week",
    "This year": "This year",
    "Thumbnail": "Thumbnail",
    "Time": "\u010cas",
    "Tip: -2 means no limit.": "Tip: -2 means no limit.",
    "Tip: 0 means default limit": "Namig: 0 pomeni prednastavljeno kvoto",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Nasvet: po spremembah bo ustvarjen trenutni posnetek, ki zabele\u017ei stanje knji\u017enice po spremembah.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.",
    "Tip: you can search by keyword in name or ID.": "Tip: you can search by keyword in name or ID.",
    "Tip: you can search by keyword in name.": "Tip: you can search by keyword in name.",
    "Today": "Today",
    "Token": "Token",
    "Token:": "Token:",
    "Tomorrow": "Tomorrow",
    "Too many requests": "Too many requests",
    "Total Devices": "Total Devices",
    "Total Storage": "Total Storage",
    "Total Users": "Vsi uporabniki",
    "Traffic": "Promet",
    "Transfer": "Prenesi",
    "Transfer Group": "Transfer Group",
    "Transfer Group {placeholder} to": "Transfer Group {placeholder} to",
    "Transfer Library": "Prenos knji\u017enice",
    "Transfer Library {library_name}": "Transfer Library {library_name}",
    "Transfer group to": "Transfer group to",
    "Transfer to department": "Transfer to department",
    "Transfer to user": "Transfer to user",
    "Transferred group {group_name} from {user_from} to {user_to}": "Transferred group {group_name} from {user_from} to {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "Transferred library {library_name} from {user_from} to {user_to}",
    "Trash": "Ko\u0161",
    "Turn off": "Turn off",
    "Turn off extended properties": "Turn off extended properties",
    "Turn on extensible properties and views to experience a new way of managing files": "Turn on extensible properties and views to experience a new way of managing files",
    "Two-Factor Authentication": "Two-Factor Authentication",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "Dvo\u010drkovna verifikacija ni omogo\u010dena za va\u0161 ra\u010dun. Omogo\u010dite dvo\u010drkovno verifikacijo za izbolj\u0161anje varnosti ra\u010duna.",
    "Type": "Tip",
    "Type characters to start search": "Type characters to start search",
    "URL is copied to the clipboard": "URL is copied to the clipboard",
    "URL is required": "URL je zahtevan",
    "US": "US",
    "Undo": "Undo",
    "Unfreeze Document": "Unfreeze Document",
    "Unhandled": "Unhandled",
    "Unknown": "Neznan",
    "Unlink": "Odstrani",
    "Unlink device": "Unlink device",
    "Unlock": "Odkleni",
    "Unresolved comments": "Nerisoljeni komentarji",
    "Unselect": "Unselect",
    "Unshare": "Odstrani deljenje",
    "Unshare Library": "Odstrani knji\u017enico iz deljenja",
    "Unstar": "Odstrani pomembno",
    "Untitled": "Untitled",
    "Unwatch File Changes": "Unwatch File Changes",
    "Up": "Navzgor",
    "Update": "Posodobi",
    "Update Terms and Conditions": "Update Terms and Conditions",
    "Update password": "Update password",
    "Update succeeded.": "Update succeeded.",
    "Updated draft": "Updated draft",
    "Updated file": "Updated file",
    "Upgrade to Pro Edition": "Nadgradite na Pro verzijo",
    "Upload": "Nalo\u017ei",
    "Upload Files": "Nalo\u017ei datoteke",
    "Upload Folder": "Mapa za nalaganje",
    "Upload Link": "URL nalaganje",
    "Upload Links": "Povezave za nalaganje",
    "Upload file": "Nalo\u017ei datoteko",
    "Upload license": "Upload license",
    "Upload link is copied to the clipboard.": "Upload link is copied to the clipboard.",
    "Uploading...": "Uploading...",
    "Use custom CSS": "Use custom CSS",
    "Use information from your Identity Provider to configure Seafile": "Use information from your Identity Provider to configure Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.",
    "Use these values to configure your Identity Provider": "Use these values to configure your Identity Provider",
    "Used:": "Poraba:",
    "User": "Uporabnik",
    "User Permission": "Pravice uporabnika",
    "User Shares": "User Shares",
    "User Storage": "User Storage",
    "User can not see this folder.": "User can not see this folder.",
    "User can only view files online via browser. Files can't be downloaded.": "User can only view files online via browser. Files can't be downloaded.",
    "User can read, download and sync files.": "User can read, download and sync files.",
    "User can read, write, upload, download and sync files.": "User can read, write, upload, download and sync files.",
    "User can view and edit file online via browser. Files can't be downloaded.": "User can view and edit file online via browser. Files can't be downloaded.",
    "User info updated": "User info updated",
    "User migrate from {user_from} to {user_to}": "User migrate from {user_from} to {user_to}",
    "User not found": "User not found",
    "User {user_link} has added you to {group_link}": "User {user_link} has added you to {group_link}",
    "Username:": "Uporabni\u0161ko ime:",
    "Users": "Uporabniki",
    "Verified": "Verified",
    "Verify": "Verify",
    "Verify Domain": "Verify Domain",
    "Version": "Version",
    "Version Number": "Version Number",
    "Version Number is required.": "Zahtevana je \u0161tevilka razli\u010dice.",
    "Version Number must be a number.": "Version Number must be a number.",
    "Video": "Video",
    "View": "Ogled",
    "View Link": "View Link",
    "View Related Snapshot": "View Related Snapshot",
    "View Snapshot": "Ogled postneka",
    "View all notifications": "Ogled vseh obvestil",
    "View profile and more": "Oglejte si profil in \u0161e ve\u010d",
    "Views": "Views",
    "Virus": "Virus",
    "Virus File": "Virus File",
    "Virus Scan": "Protivirusni pregled",
    "Visit count": "Visit count",
    "Visit old version page": "Visit old version page",
    "Visited": "Visited",
    "Visits": "Obiski",
    "Watch File Changes": "Watch File Changes",
    "Web API Auth Token": "Web API Auth Token",
    "Web Download": "Web Download",
    "Web Upload": "Web Upload",
    "WebDAV Access": "WebDAV Access",
    "WebDAV password:": "WebDAV password:",
    "WebDAV username:": "WebDAV username:",
    "Wiki custom URL deleted": "Wiki custom URL deleted",
    "Wiki owner": "Wiki owner",
    "Wiki published": "Wiki published",
    "Wikis": "Wikis",
    "Wrong password": "Napa\u010dno geslo",
    "Year": "Year",
    "Yesterday": "Yesterday",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Uporabnike lahko dodate tudi kot goste, ne bo jim dovoljeno ustvariti knji\u017enice in skupine.",
    "You can create files quickly": "You can create files quickly",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "You can enter multiple emails. An invitation link will be sent to each of them.",
    "You can use this field at login.": "To polje lahko uporabi\u0161 pri prijavi.",
    "You do not have permission": "You do not have permission",
    "You don't have any favorite items yet": "You don't have any favorite items yet",
    "You don't have any share links": "You don't have any share links",
    "You don't have any upload links": "You don't have any upload links",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.",
    "You have not shared any folders": "You have not shared any folders",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".",
    "Your notifications will be sent to this email.": "Tvoja obvestila bodo poslana na ta email naslov.",
    "ZIP": "ZIP",
    "all": "skupaj",
    "all members": "vsi \u010dlani",
    "contains": " vsebuje",
    "days": "dni",
    "deleted": "deleted",
    "deleted option": "deleted option",
    "details": "details",
    "does not contain": " ne vsebuje",
    "email is required": "E-po\u0161ta je zahtevana",
    "freezed": "freezed",
    "has all of...": "has all of...",
    "has any of...": "has any of...",
    "has none of...": "has none of...",
    "icon": "ikona",
    "in all libraries": "in all libraries",
    "include the current user": "vklju\u010dite me",
    "is": " je",
    "is after...": "is after...",
    "is any of...": "is any of...",
    "is before...": "is before...",
    "is current user's ID": " je ID trenutnega uporabnika",
    "is empty": " je prazno",
    "is exactly...": "is exactly...",
    "is none of...": "is none of...",
    "is not": " ni",
    "is not empty": " ni prazno",
    "is on or after...": "is on or after...",
    "is on or before...": "is on or before...",
    "is within...": "is within...",
    "items": "items",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}",
    "locked": "zaklenjeno",
    "locked by {name}": "locked by {name}",
    "mm": "mm",
    "name": "naziv",
    "not set": "not set",
    "only show {placeholder}": "only show {placeholder}",
    "s": "s",
    "selected": "selected",
    "show more": "show more",
    "sorts": "Razvrstitev",
    "starred": "pomembno",
    "successfully added user %s.": "successfully added user %s.",
    "successfully sent email to %s.": "successfully sent email to %s.",
    "unstarred": "odstrani pomembno",
    "xxx cells copied": "xxx cells copied",
    "xxx cells selected": "xxx cells selected",
    "xxx record": "xxx record",
    "xxx records": "xxx records",
    "xxx records selected": "xxx records selected",
    "xxx rows are copied.": "xxx rows are copied.",
    "you can also press \u2192": "you can also press \u2192",
    "{failed_files_num} file(s) failed to upload": "{failed_files_num} file(s) failed to upload",
    "{file} and {n} other files": "{file} and {n} other files",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} days",
    "{number_placeholder} / Page": "{number_placeholder} / Page",
    "{placeholder} Access Log": "{placeholder} Access Log",
    "{placeholder} Folder Permission": "{placeholder} Folder Permission",
    "{placeholder} History Setting": "{placeholder} History Setting",
    "{placeholder} Modification History": "{placeholder} Modification History",
    "{placeholder} Share Admin": "{placeholder} Share Admin",
    "{placeholder} Snapshot": "{placeholder} Snapshot",
    "{placeholder} Trash": "{placeholder} Trash",
    "{placeholder} Wiki Trash": "{placeholder} Wiki Trash",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} has cancelled the sharing of folder {repo_name}.",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} has cancelled the sharing of library {repo_name}.",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} has changed the permission of folder {repo_link} to {permission}.",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} has changed the permission of library {repo_link} to {permission}.",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} has shared a folder named {repo_link} to group {group_link}.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} has shared a folder named {repo_link} to you.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} has shared a library named {repo_link} to group {group_link}.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} has shared a library named {repo_link} to you.",
    "{uploaded_files_num}/{all_files_num} Files": "{uploaded_files_num}/{all_files_num} Files",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} created file {fileName} in library {libraryName}.": "{user} created file {fileName} in library {libraryName}.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} created folder {folderName} in library {libraryName}.": "{user} created folder {folderName} in library {libraryName}.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} deleted file {fileName} in library {libraryName}.": "{user} deleted file {fileName} in library {libraryName}.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} deleted folder {folderName} in library {libraryName}.": "{user} deleted folder {folderName} in library {libraryName}.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} moved file {fileName} in library {libraryName}.": "{user} moved file {fileName} in library {libraryName}.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} moved folder {folderName} in library {libraryName}.": "{user} moved folder {folderName} in library {libraryName}.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "{user} renamed file {oldFileName} {fileName} in library {libraryName}.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.",
    "{user} restored file {fileName} in library {libraryName}.": "{user} restored file {fileName} in library {libraryName}.",
    "{user} restored folder {folderName} in library {libraryName}.": "{user} restored folder {folderName} in library {libraryName}.",
    "{user} updated file {fileName} in library {libraryName}.": "{user} updated file {fileName} in library {libraryName}."
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "j. F Y. H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S",
      "%d.%m.%Y %H:%M:%S.%f",
      "%d.%m.%Y %H:%M",
      "%d.%m.%y %H:%M:%S",
      "%d.%m.%y %H:%M:%S.%f",
      "%d.%m.%y %H:%M",
      "%d-%m-%Y %H:%M:%S",
      "%d-%m-%Y %H:%M:%S.%f",
      "%d-%m-%Y %H:%M",
      "%d. %m. %Y %H:%M:%S",
      "%d. %m. %Y %H:%M:%S.%f",
      "%d. %m. %Y %H:%M",
      "%d. %m. %y %H:%M:%S",
      "%d. %m. %y %H:%M:%S.%f",
      "%d. %m. %y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "d. F Y",
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y",
      "%d.%m.%y",
      "%d-%m-%Y",
      "%d. %m. %Y",
      "%d. %m. %y",
      "%Y-%m-%d"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 0,
    "MONTH_DAY_FORMAT": "j. F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "j.n.Y. H:i",
    "SHORT_DATE_FORMAT": "j. M. Y",
    "THOUSAND_SEPARATOR": ".",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

