/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Null;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static void copyStream(InputStream input2, OutputStream output2) throws IOException {
        StreamUtils.copyStream(input2, output2, new byte[4096]);
    }

    public static void copyStream(InputStream input2, OutputStream output2, int bufferSize) throws IOException {
        StreamUtils.copyStream(input2, output2, new byte[bufferSize]);
    }

    public static void copyStream(InputStream input2, OutputStream output2, byte[] buffer) throws IOException {
        int bytesRead;
        while ((bytesRead = input2.read(buffer)) != -1) {
            output2.write(buffer, 0, bytesRead);
        }
    }

    public static void copyStream(InputStream input2, ByteBuffer output2) throws IOException {
        StreamUtils.copyStream(input2, output2, new byte[4096]);
    }

    public static void copyStream(InputStream input2, ByteBuffer output2, int bufferSize) throws IOException {
        StreamUtils.copyStream(input2, output2, new byte[bufferSize]);
    }

    public static int copyStream(InputStream input2, ByteBuffer output2, byte[] buffer) throws IOException {
        int bytesRead;
        int startPosition = output2.position();
        int total = 0;
        while ((bytesRead = input2.read(buffer)) != -1) {
            BufferUtils.copy(buffer, 0, (Buffer)output2, bytesRead);
            ((Buffer)output2).position(startPosition + (total += bytesRead));
        }
        ((Buffer)output2).position(startPosition);
        return total;
    }

    public static byte[] copyStreamToByteArray(InputStream input2) throws IOException {
        return StreamUtils.copyStreamToByteArray(input2, input2.available());
    }

    public static byte[] copyStreamToByteArray(InputStream input2, int estimatedSize) throws IOException {
        OptimizedByteArrayOutputStream baos = new OptimizedByteArrayOutputStream(Math.max(0, estimatedSize));
        StreamUtils.copyStream(input2, baos);
        return ((ByteArrayOutputStream)baos).toByteArray();
    }

    public static String copyStreamToString(InputStream input2) throws IOException {
        return StreamUtils.copyStreamToString(input2, input2.available(), null);
    }

    public static String copyStreamToString(InputStream input2, int estimatedSize) throws IOException {
        return StreamUtils.copyStreamToString(input2, estimatedSize, null);
    }

    public static String copyStreamToString(InputStream input2, int estimatedSize, @Null String charset) throws IOException {
        int charsRead;
        InputStreamReader reader2 = charset == null ? new InputStreamReader(input2) : new InputStreamReader(input2, charset);
        StringWriter writer2 = new StringWriter(Math.max(0, estimatedSize));
        char[] buffer = new char[4096];
        while ((charsRead = reader2.read(buffer)) != -1) {
            writer2.write(buffer, 0, charsRead);
        }
        return writer2.toString();
    }

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class OptimizedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public OptimizedByteArrayOutputStream(int initialSize) {
            super(initialSize);
        }

        @Override
        public synchronized byte[] toByteArray() {
            if (this.count == this.buf.length) {
                return this.buf;
            }
            return super.toByteArray();
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

