/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.city;

import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.unit.WorkerAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.CityAction;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.Personality;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001SB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J0\u00109\u001a\u00020:2\u0016\u0010;\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020.H\u0002J\"\u0010>\u001a\b\u0012\u0004\u0012\u0002H?0\u0017\"\b\b\u0000\u0010?*\u00020@*\b\u0012\u0004\u0012\u0002H?0\u0017H\u0002J\u0006\u0010A\u001a\u00020:J\b\u0010B\u001a\u00020:H\u0002J\b\u0010C\u001a\u00020:H\u0002J\b\u0010D\u001a\u00020:H\u0002J\b\u0010E\u001a\u00020:H\u0002J\b\u0010F\u001a\u00020:H\u0002J\u0018\u0010G\u001a\u00020.2\u0006\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020.2\u0006\u0010H\u001a\u00020$H\u0003J\u0010\u0010L\u001a\u00020.2\u0006\u0010H\u001a\u00020$H\u0003J\u0010\u0010M\u001a\u00020.2\u0006\u0010H\u001a\u00020$H\u0003J\u0018\u0010N\u001a\u00020.2\u0006\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020JH\u0002J\u0018\u0010O\u001a\u00020P2\u0006\u0010H\u001a\u00020\u00182\u0006\u0010I\u001a\u00020JH\u0002J\u0018\u0010Q\u001a\u00020P2\u0006\u0010H\u001a\u00020$2\u0006\u0010R\u001a\u00020PH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001a0 j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001a`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001a0 j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001a`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010#\u001a\r\u0012\t\u0012\u00070$\u00a2\u0006\u0002\b%0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010&\u001a\r\u0012\t\u0012\u00070$\u00a2\u0006\u0002\b%0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010'\u001a\r\u0012\t\u0012\u00070(\u00a2\u0006\u0002\b%0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u001803X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u001805X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/unciv/logic/automation/city/ConstructionAutomation;", "", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "<init>", "(Lcom/unciv/logic/city/CityConstructions;)V", "getCityConstructions", "()Lcom/unciv/logic/city/CityConstructions;", "city", "Lcom/unciv/logic/city/City;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "relativeCostEffectiveness", "Ljava/util/ArrayList;", "Lcom/unciv/logic/automation/city/ConstructionAutomation$ConstructionChoice;", "Lkotlin/collections/ArrayList;", "cityState", "Lcom/unciv/models/ruleset/unique/GameContext;", "cityStats", "Lcom/unciv/logic/city/CityStats;", "personality", "Lcom/unciv/models/ruleset/nation/Personality;", "constructionsToAvoid", "Lkotlin/sequences/Sequence;", "", "shouldAvoidConstruction", "", "construction", "Lcom/unciv/models/ruleset/IConstruction;", "disabledAutoAssignConstructions", "", "buildableBuildings", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "buildableUnits", "buildings", "Lcom/unciv/models/ruleset/Building;", "Lkotlin/jvm/internal/EnhancedNullability;", "nonWonders", "units", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "civUnits", "Lcom/unciv/logic/map/mapunit/MapUnit;", "militaryUnits", "", "workers", "", "cities", "allTechsAreResearched", "isAtWar", "buildingsForVictory", "", "spaceshipParts", "Ljava/util/HashSet;", "averageProduction", "", "cityIsOverAverageProduction", "addChoice", "", "choices", "choice", "choiceModifier", "filterBuildable", "T", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "chooseNextConstruction", "addMilitaryUnitChoice", "addWorkBoatChoice", "addWorkerChoice", "addSpaceshipPartChoice", "addBuildingChoices", "getValueOfBuilding", "building", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "getOnetimeUniqueBonuses", "getVictoryBuildingValue", "getMilitaryBuildingValue", "applyBuildingStats", "getStatDifferenceFromBuilding", "Lcom/unciv/models/stats/Stats;", "getBuildingStatsFromUniques", "buildingStats", "ConstructionChoice", "core"})
@SourceDebugExtension(value={"SMAP\nConstructionAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructionAutomation.kt\ncom/unciv/logic/automation/city/ConstructionAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1276#2,3:404\n1276#2,3:407\n2275#2,2:448\n1255#2,2:451\n1891#2,14:467\n1255#2,2:482\n1617#3,9:410\n1869#3:419\n1870#3:421\n1626#3:422\n774#3:423\n865#3,2:424\n1563#3:426\n1634#3,3:427\n1563#3:430\n1634#3,3:431\n1969#3,14:434\n2393#3,14:453\n1068#3:481\n1#4:420\n1#4:450\n*S KotlinDebug\n*F\n+ 1 ConstructionAutomation.kt\ncom/unciv/logic/automation/city/ConstructionAutomation\n*L\n76#1:404,3\n77#1:407,3\n178#1:448,2\n202#1:451,2\n249#1:467,14\n328#1:482,2\n83#1:410,9\n83#1:419\n83#1:421\n83#1:422\n84#1:423\n84#1:424,2\n85#1:426\n85#1:427,3\n90#1:430\n90#1:431,3\n138#1:434,14\n233#1:453,14\n286#1:481\n83#1:420\n*E\n"})
public final class ConstructionAutomation {
    @NotNull
    private final CityConstructions cityConstructions;
    @NotNull
    private final City city;
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final ArrayList<ConstructionChoice> relativeCostEffectiveness;
    @NotNull
    private final GameContext cityState;
    @NotNull
    private final CityStats cityStats;
    @NotNull
    private final Personality personality;
    @NotNull
    private final Sequence<String> constructionsToAvoid;
    @NotNull
    private final Set<String> disabledAutoAssignConstructions;
    @NotNull
    private final HashMap<String, Boolean> buildableBuildings;
    @NotNull
    private final HashMap<String, Boolean> buildableUnits;
    @NotNull
    private final Sequence<Building> buildings;
    @NotNull
    private final Sequence<Building> nonWonders;
    @NotNull
    private final Sequence<BaseUnit> units;
    @NotNull
    private final Sequence<MapUnit> civUnits;
    private final int militaryUnits;
    private final float workers;
    private final int cities;
    private final boolean allTechsAreResearched;
    private final boolean isAtWar;
    @NotNull
    private final List<String> buildingsForVictory;
    @NotNull
    private final HashSet<String> spaceshipParts;
    private final double averageProduction;
    private final boolean cityIsOverAverageProduction;

    /*
     * WARNING - void declaration
     */
    public ConstructionAutomation(@NotNull CityConstructions cityConstructions) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        int n;
        MapUnit it2;
        Object element$iv;
        Object $this$count$iv;
        Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
        this.cityConstructions = cityConstructions;
        this.city = this.cityConstructions.getCity();
        this.civInfo = this.city.getCiv();
        this.relativeCostEffectiveness = new ArrayList();
        this.cityState = this.city.getState();
        this.cityStats = this.city.getCityStats();
        this.personality = this.civInfo.getPersonality();
        this.constructionsToAvoid = SequencesKt.map(this.personality.getMatchingUniques(UniqueType.WillNotBuild, this.cityState), ConstructionAutomation::constructionsToAvoid$lambda$0);
        this.disabledAutoAssignConstructions = this.civInfo.isHuman() ? (Set)GUI.INSTANCE.getSettings().getDisabledAutoAssignConstructions() : SetsKt.emptySet();
        this.buildableBuildings = new HashMap();
        this.buildableUnits = new HashMap();
        Collection<Building> collection = this.city.getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        this.buildings = SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)collection), arg_0 -> ConstructionAutomation.buildings$lambda$0(this, arg_0));
        this.nonWonders = SequencesKt.filterNot(SequencesKt.filterNot(this.buildings, ConstructionAutomation::nonWonders$lambda$0), arg_0 -> ConstructionAutomation.nonWonders$lambda$1(this, arg_0));
        Collection<BaseUnit> collection2 = this.city.getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        this.units = SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)collection2), arg_0 -> ConstructionAutomation.units$lambda$0(this, arg_0));
        Sequence<MapUnit> sequence = this.civUnits = this.civInfo.getUnits().getCivUnits();
        ConstructionAutomation constructionAutomation = this;
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Object> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it2 = (MapUnit)element$iv;
            boolean bl = false;
            if (!it2.getBaseUnit().isMilitary() || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        constructionAutomation.militaryUnits = n = count$iv;
        $this$count$iv = this.civUnits;
        constructionAutomation = this;
        $i$f$count = false;
        count$iv = 0;
        iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it2 = (MapUnit)element$iv;
            boolean bl = false;
            if (!it2.getCache().getHasUniqueToBuildImprovements() || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        n = count$iv;
        constructionAutomation.workers = n;
        this.cities = this.civInfo.getCities().size();
        this.allTechsAreResearched = this.civInfo.getTech().allTechsAreResearched();
        this.isAtWar = this.civInfo.isAtWar();
        $this$count$iv = this.civInfo.getGameInfo().getEnabledVictories().values();
        constructionAutomation = this;
        boolean $i$f$mapNotNull = false;
        void count$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Milestone it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            Victory it3 = (Victory)element$iv$iv;
            boolean bl2 = false;
            if (this.civInfo.getVictoryManager().getNextMilestone(it3) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Milestone)element$iv$iv;
            boolean bl = false;
            if (!(((Milestone)it).getType() == MilestoneType.BuiltBuilding || ((Milestone)it).getType() == MilestoneType.BuildingBuiltGlobally)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Milestone)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(((Milestone)it).getParams().get(0));
        }
        constructionAutomation.buildingsForVictory = (List)destination$iv$iv;
        this.spaceshipParts = this.civInfo.getGameInfo().getSpaceResources();
        $this$map$iv = this.civInfo.getCities();
        constructionAutomation = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (City)item$iv$iv;
            Collection collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(Float.valueOf(((City)it).getCityStats().getCurrentCityStats().getProduction()));
        }
        constructionAutomation.averageProduction = CollectionsKt.averageOfFloat((List)destination$iv$iv);
        this.cityIsOverAverageProduction = (double)this.city.getCityStats().getCurrentCityStats().getProduction() >= this.averageProduction;
    }

    @NotNull
    public final CityConstructions getCityConstructions() {
        return this.cityConstructions;
    }

    @Readonly
    private final boolean shouldAvoidConstruction(IConstruction construction) {
        GameContext stateForConditionals = this.cityState;
        Iterator<String> iterator2 = this.constructionsToAvoid.iterator();
        while (iterator2.hasNext()) {
            String toAvoid = iterator2.next();
            if (construction instanceof Building && ((Building)construction).matchesFilter(toAvoid, stateForConditionals)) {
                return true;
            }
            if (!(construction instanceof BaseUnit) || !BaseUnit.matchesFilter$default((BaseUnit)construction, toAvoid, stateForConditionals, false, 4, null)) continue;
            return true;
        }
        return false;
    }

    private final void addChoice(ArrayList<ConstructionChoice> choices, IConstruction choice, float choiceModifier) {
        float extraAiModifier = this.civInfo.isAI() && choice instanceof INonPerpetualConstruction ? ((INonPerpetualConstruction)choice).getWeightForAiDecision(new GameContext(this.civInfo, this.city, null, null, null, null, null, null, null, null, false, 2044, null)) : 1.0f;
        choices.add(new ConstructionChoice(choice, choiceModifier * extraAiModifier, CityConstructions.getRemainingWork$default(this.cityConstructions, choice.getName(), false, 2, null), this.cityConstructions.productionForConstruction(choice.getName())));
    }

    private final <T extends INonPerpetualConstruction> Sequence<T> filterBuildable(Sequence<? extends T> $this$filterBuildable) {
        return SequencesKt.filter($this$filterBuildable, arg_0 -> ConstructionAutomation.filterBuildable$lambda$0(this, arg_0));
    }

    public final void chooseNextConstruction() {
        IConstruction iConstruction;
        if (!(this.cityConstructions.getCurrentConstruction() instanceof PerpetualConstruction)) {
            return;
        }
        this.addBuildingChoices();
        if (!this.city.isPuppet()) {
            this.addSpaceshipPartChoice();
            this.addWorkerChoice();
            this.addWorkBoatChoice();
            this.addMilitaryUnitChoice();
        }
        if (this.relativeCostEffectiveness.isEmpty()) {
            iConstruction = PerpetualConstruction.Companion.getScience().isBuildable(this.cityConstructions) && !this.allTechsAreResearched ? (PerpetualConstruction)PerpetualConstruction.Companion.getScience() : (PerpetualConstruction.Companion.getGold().isBuildable(this.cityConstructions) ? (PerpetualConstruction)PerpetualConstruction.Companion.getGold() : (PerpetualConstruction.Companion.getCulture().isBuildable(this.cityConstructions) && !this.civInfo.getPolicies().allPoliciesAdopted(true) ? (PerpetualConstruction)PerpetualConstruction.Companion.getCulture() : (PerpetualConstruction.Companion.getFaith().isBuildable(this.cityConstructions) ? (PerpetualConstruction)PerpetualConstruction.Companion.getFaith() : PerpetualConstruction.Companion.getIdle())));
        } else {
            Object t;
            Iterable $this$maxBy$iv = this.relativeCostEffectiveness;
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                ConstructionChoice it = (ConstructionChoice)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = RangesKt.coerceAtLeast(it.getChoiceModifier() / (float)RangesKt.coerceAtLeast(it.getRemainingWork(), 1), 0.0f);
                do {
                    Object e$iv = iterator$iv.next();
                    ConstructionChoice it2 = (ConstructionChoice)e$iv;
                    $i$a$-maxByOrThrow-ConstructionAutomation$chooseNextConstruction$chosenConstruction$1 = false;
                    float v$iv = RangesKt.coerceAtLeast(it2.getChoiceModifier() / (float)RangesKt.coerceAtLeast(it2.getRemainingWork(), 1), 0.0f);
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            iConstruction = ((ConstructionChoice)t).getChoice();
        }
        IConstruction chosenConstruction = iConstruction;
        boolean noNotification = this.city.isInResistance() || this.civInfo.isAI() || Intrinsics.areEqual(this.cityConstructions.currentConstructionName(), chosenConstruction.getName()) || UncivGame.Companion.getCurrent().getScreen() instanceof CityScreen;
        this.cityConstructions.setCurrentConstruction(chosenConstruction.getName());
        if (noNotification) {
            return;
        }
        String[] stringArray = new String[]{"StatIcons/Production"};
        this.civInfo.addNotification('[' + this.city.getName() + "] has started working on [" + chosenConstruction.getName() + ']', (Iterable<? extends NotificationAction>)CityAction.Companion.withLocation(this.city), Notification.NotificationCategory.Production, stringArray);
    }

    private final void addMilitaryUnitChoice() {
        MapUnit civilianUnit;
        if (!this.isAtWar && !this.cityIsOverAverageProduction) {
            return;
        }
        if (this.civInfo.getStats().getUnitSupplyDeficit() > 0) {
            return;
        }
        if (!this.isAtWar && (this.civInfo.getStats().getStatsForNextTurn().getGold() < 0.0f || this.militaryUnits > Math.max(7, this.cities * 5))) {
            return;
        }
        if (this.civInfo.getGold() < -50) {
            return;
        }
        BaseUnit baseUnit = Automation.INSTANCE.chooseMilitaryUnit(this.city, this.units);
        if (baseUnit == null) {
            return;
        }
        BaseUnit militaryUnit = baseUnit;
        float unitsToCitiesRatio = (float)this.cities / (float)(this.militaryUnits + 1);
        float modifier = 1.0f + (float)Math.sqrt(unitsToCitiesRatio) / (float)2;
        if (this.isAtWar) {
            modifier *= (float)2;
        }
        if (Automation.INSTANCE.afraidOfBarbarians(this.civInfo)) {
            modifier = 2.0f;
        }
        if (!this.cityIsOverAverageProduction) {
            modifier /= (float)5;
        }
        if ((civilianUnit = this.city.getCenterTile().getCivilianUnit()) != null && MapUnit.hasUnique$default(civilianUnit, UniqueType.FoundCity, null, false, 6, null)) {
            boolean bl;
            block12: {
                Sequence<Tile> $this$none$iv = this.city.getCenterTile().getTilesInDistance(this.city.getExpandRange());
                boolean $i$f$none = false;
                Iterator<Tile> iterator2 = $this$none$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    MapUnit mapUnit = it.getMilitaryUnit();
                    if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, this.civInfo)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
            if (bl) {
                modifier = 5.0f;
            }
        }
        if (!this.civInfo.isAIOrAutoPlaying()) {
            modifier /= (float)2;
        }
        this.addChoice(this.relativeCostEffectiveness, militaryUnit, modifier *= this.personality.modifierFocus(PersonalityValue.Military, 0.3f));
    }

    /*
     * WARNING - void declaration
     */
    private final void addWorkBoatChoice() {
        Object t;
        Object t2;
        void $this$minBy$iv;
        boolean alreadyHasWorkBoat;
        Set<BaseUnit> buildableWorkboatUnits;
        block10: {
            boolean bl;
            void $this$any$iv;
            buildableWorkboatUnits = SequencesKt.toSet(this.filterBuildable(SequencesKt.filter(this.units, arg_0 -> ConstructionAutomation.addWorkBoatChoice$lambda$0(this, arg_0))));
            if (buildableWorkboatUnits.isEmpty()) {
                return;
            }
            Iterator iterator2 = ((Iterable)buildableWorkboatUnits).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            BaseUnit it22 = (BaseUnit)iterator2.next();
            boolean bl2 = false;
            int it22 = it22.getMovement();
            while (iterator2.hasNext()) {
                BaseUnit it32 = (BaseUnit)iterator2.next();
                $i$a$-maxOf-ConstructionAutomation$addWorkBoatChoice$twoTurnsMovement$1 = false;
                int it32 = it32.getMovement();
                if (it22 >= it32) continue;
                it22 = it32;
            }
            int twoTurnsMovement = it22 * 2;
            iterator2 = this.city.getCenterTile().getTilesInDistance(twoTurnsMovement);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Tile it = (Tile)element$iv;
                boolean bl3 = false;
                MapUnit mapUnit = it.getCivilianUnit();
                boolean bl4 = mapUnit != null ? ConstructionAutomation.addWorkBoatChoice$isOurWorkBoat(mapUnit, this) : false;
                if (!bl4) continue;
                bl = true;
                break block10;
            }
            bl = alreadyHasWorkBoat = false;
        }
        if (alreadyHasWorkBoat) {
            return;
        }
        if (!ConstructionAutomation.addWorkBoatChoice$findTileWorthImproving(this)) {
            return;
        }
        Iterable $i$f$any = buildableWorkboatUnits;
        ArrayList<ConstructionChoice> arrayList = this.relativeCostEffectiveness;
        ConstructionAutomation constructionAutomation = this;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t2 = minElem$iv;
        } else {
            BaseUnit it = (BaseUnit)minElem$iv;
            boolean bl = false;
            int minValue$iv = it.getCost();
            do {
                Object e$iv = iterator$iv.next();
                BaseUnit it2 = (BaseUnit)e$iv;
                $i$a$-minByOrThrow-ConstructionAutomation$addWorkBoatChoice$1 = false;
                int v$iv = it2.getCost();
                if (minValue$iv <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t2 = minElem$iv;
        }
        Object t3 = t = t2;
        Intrinsics.checkNotNullExpressionValue(t3, "minBy(...)");
        constructionAutomation.addChoice(arrayList, (IConstruction)t3, 6.0f);
    }

    /*
     * WARNING - void declaration
     */
    private final void addWorkerChoice() {
        float numberOfWorkersWeWant;
        Sequence<BaseUnit> workerEquivalents = this.filterBuildable(SequencesKt.filter(this.units, arg_0 -> ConstructionAutomation.addWorkerChoice$lambda$0(this, arg_0)));
        if (SequencesKt.none(workerEquivalents)) {
            return;
        }
        float f = this.cities <= 1 ? 1.0f : (numberOfWorkersWeWant = this.cities <= 5 ? (float)this.cities * 1.8f : 9.0f + 1.3f * (float)(this.cities - 5));
        if (this.workers < numberOfWorkersWeWant) {
            Object t;
            Object t2;
            void $this$minBy$iv;
            float modifier = numberOfWorkersWeWant / (this.workers + 0.17f);
            Sequence<BaseUnit> sequence = workerEquivalents;
            ArrayList<ConstructionChoice> arrayList = this.relativeCostEffectiveness;
            ConstructionAutomation constructionAutomation = this;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t2 = minElem$iv;
            } else {
                BaseUnit it = (BaseUnit)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCost();
                do {
                    Object e$iv = iterator$iv.next();
                    BaseUnit it2 = (BaseUnit)e$iv;
                    $i$a$-minByOrThrow-ConstructionAutomation$addWorkerChoice$1 = false;
                    int v$iv = it2.getCost();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t2 = minElem$iv;
            }
            Object t3 = t = t2;
            Intrinsics.checkNotNullExpressionValue(t3, "minBy(...)");
            constructionAutomation.addChoice(arrayList, (IConstruction)t3, modifier);
        }
    }

    private final void addSpaceshipPartChoice() {
        if (!this.cityIsOverAverageProduction) {
            return;
        }
        if (!Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null)) {
            return;
        }
        INonPerpetualConstruction iNonPerpetualConstruction = (INonPerpetualConstruction)SequencesKt.firstOrNull(this.filterBuildable(SequencesKt.filter(SequencesKt.plus(this.nonWonders, this.units), arg_0 -> ConstructionAutomation.addSpaceshipPartChoice$lambda$0(this, arg_0))));
        if (iNonPerpetualConstruction == null) {
            return;
        }
        IHasUniques spaceshipPart = iNonPerpetualConstruction;
        float modifier = 20.0f;
        this.addChoice(this.relativeCostEffectiveness, (IConstruction)((Object)spaceshipPart), modifier);
    }

    /*
     * WARNING - void declaration
     */
    private final void addBuildingChoices() {
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Iterator<Building> iterator2 = this.filterBuildable(this.buildings).iterator();
        while (iterator2.hasNext()) {
            Building building;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (building.isWonder() && this.city.isPuppet()) continue;
            if (building.isWonder()) {
                if (!this.cityIsOverAverageProduction) continue;
                Iterable iterable = this.civInfo.getCities();
                int n = 0;
                for (Object t : iterable) {
                    void it;
                    City city = (City)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = it.getPopulation().getPopulation();
                    n = n2 + n3;
                }
                if (n < 12) continue;
            }
            this.addChoice(this.relativeCostEffectiveness, building, this.getValueOfBuilding(building, localUniqueCache));
        }
    }

    private final float getValueOfBuilding(Building building, LocalUniqueCache localUniqueCache) {
        float value = 0.0f;
        value += this.applyBuildingStats(building, localUniqueCache);
        value += this.getMilitaryBuildingValue(building);
        value += this.getVictoryBuildingValue(building);
        return value += this.getOnetimeUniqueBonuses(building);
    }

    @Readonly
    private final float getOnetimeUniqueBonuses(Building building) {
        float value = 0.0f;
        if (building.isWonder()) {
            if (!building.isNationalWonder()) {
                Iterable $this$sortedByDescending$iv = this.civInfo.getGameInfo().getAliveMajorCivs();
                boolean $i$f$sortedByDescending = false;
                value -= (float)CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Civilization it = (Civilization)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStatForRanking(RankingType.Technologies));
                        it = (Civilization)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getStatForRanking(RankingType.Technologies));
                    }
                }).indexOf(this.civInfo);
            }
            value += IHasUniques.hasUnique$default(building, UniqueType.OneTimeFreePolicy, null, 2, null) || IHasUniques.hasUnique$default(building, UniqueType.OneTimeAmountFreePolicies, null, 2, null) ? this.civInfo.getPersonality().getCulture() : (IHasUniques.hasUnique$default(building, UniqueType.OneTimeFreeTech, null, 2, null) || IHasUniques.hasUnique$default(building, UniqueType.OneTimeAmountFreeTechs, null, 2, null) ? this.civInfo.getPersonality().getScience() : (IHasUniques.hasUnique$default(building, UniqueType.OneTimeAmountFreeUnits, null, 2, null) || IHasUniques.hasUnique$default(building, UniqueType.OneTimeFreeUnit, null, 2, null) ? this.civInfo.getPersonality().getProduction() : (IHasUniques.hasUnique$default(building, UniqueType.OneTimeFreeGreatPerson, null, 2, null) ? this.civInfo.getPersonality().getScience() : (IHasUniques.hasUnique$default(building, UniqueType.OneTimeEnterGoldenAge, null, 2, null) || IHasUniques.hasUnique$default(building, UniqueType.GoldenAgeLength, null, 2, null) || IHasUniques.hasUnique$default(building, UniqueType.OneTimeEnterGoldenAgeTurns, null, 2, null) ? this.civInfo.getPersonality().getExpansion() : (IHasUniques.hasUnique$default(building, UniqueType.EnemyUnitsSpendExtraMovement, null, 2, null) ? this.civInfo.getPersonality().getDeclareWar() : (IHasUniques.hasUnique$default(building, UniqueType.OneTimeGainPopulation, null, 2, null) || IHasUniques.hasUnique$default(building, UniqueType.OneTimeGainPopulationRandomCity, null, 2, null) ? this.civInfo.getPersonality().getFood() : (IHasUniques.hasUnique$default(building, UniqueType.StatPercentFromTradeRoutes, null, 2, null) ? this.civInfo.getPersonality().getGold() : (IHasUniques.hasUnique$default(building, UniqueType.Strength, null, 2, null) ? this.civInfo.getPersonality().getMilitary() : (IHasUniques.hasUnique$default(building, UniqueType.StatPercentBonusCities, null, 2, null) ? this.civInfo.getPersonality().getCulture() : 0.0f)))))))));
        } else {
            value += IHasUniques.hasUnique$default(building, UniqueType.CreatesOneImprovement, null, 2, null) ? 5.0f : (IHasUniques.hasUnique$default(building, UniqueType.ProvidesResources, null, 2, null) ? 3.0f : (IHasUniques.hasUnique$default(building, UniqueType.StatPercentFromObjectToResource, null, 2, null) ? 1.5f : (building.getRequiredResource() != null && CollectionsKt.contains((Iterable)this.civInfo.getGameInfo().getSpaceResources(), building.getRequiredResource()) ? -4.0f : 0.0f)));
        }
        return value;
    }

    @Readonly
    private final float getVictoryBuildingValue(Building building) {
        float value = 0.0f;
        if (!this.cityIsOverAverageProduction) {
            return value;
        }
        if (IHasUniques.hasUnique$default(building, UniqueType.TriggersCulturalVictory, null, 2, null) || IHasUniques.hasUnique$default(building, UniqueType.TriggersVictory, null, 2, null)) {
            value += 20.0f;
        }
        if (IHasUniques.hasUnique$default(building, UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null)) {
            value += 10.0f * this.personality.modifierFocus(PersonalityValue.Science, 0.3f);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final float getMilitaryBuildingValue(Building building) {
        boolean bl;
        Object object;
        float warModifier;
        float value;
        block4: {
            void $this$any$iv;
            value = 0.0f;
            warModifier = this.isAtWar ? 1.0f : 0.5f;
            object = SequencesKt.mapNotNull(this.civInfo.getKnownCivs(), arg_0 -> ConstructionAutomation.getMilitaryBuildingValue$lambda$0(this, arg_0));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                NextTurnAutomation.CityDistance it = (NextTurnAutomation.CityDistance)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getCity(), this.city)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            warModifier *= 2.0f;
        }
        value += warModifier * (float)building.getCityHealth() / (float)this.city.getMaxHealth$core() * this.personality.inverseModifierFocus(PersonalityValue.Aggressive, 0.3f);
        value += warModifier * (float)building.getCityStrength() / (this.city.getStrength() + (float)3) * this.personality.inverseModifierFocus(PersonalityValue.Aggressive, 0.3f);
        object = building.getMatchingUniques(UniqueType.UnitStartingExperience, this.cityState).iterator();
        while (object.hasNext()) {
            Unique experienceUnique = (Unique)object.next();
            float modifier = Float.parseFloat(experienceUnique.getParams().get(1)) / (float)5;
            modifier *= this.cityIsOverAverageProduction ? 1.0f : 0.2f;
            modifier *= this.personality.modifierFocus(PersonalityValue.Military, 0.3f);
            value += (modifier *= RangesKt.coerceAtLeast(this.personality.modifierFocus(PersonalityValue.Aggressive, 0.2f), 1.0f));
        }
        if (IHasUniques.hasUnique$default(building, UniqueType.EnablesNuclearWeapons, null, 2, null) && !Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesNuclearWeapons, null, 2, null)) {
            value += 10.0f * this.personality.modifierFocus(PersonalityValue.Military, 0.3f);
        }
        return value;
    }

    private final float applyBuildingStats(Building building, LocalUniqueCache localUniqueCache) {
        Stats buildingStats = this.getStatDifferenceFromBuilding(building.getName(), localUniqueCache);
        buildingStats.add(this.getBuildingStatsFromUniques(building, buildingStats));
        buildingStats.setFood(buildingStats.getFood() * (float)3);
        buildingStats.setProduction(buildingStats.getProduction() * (float)2);
        buildingStats.setGold(buildingStats.getGold() * (float)2);
        if (this.civInfo.getHappiness() < 10 || this.civInfo.getHappiness() < this.civInfo.getCities().size()) {
            buildingStats.setHappiness(buildingStats.getHappiness() * (float)3);
        }
        if (this.city.getCityStats().getCurrentCityStats().getCulture() < 2.0f) {
            buildingStats.setCulture(buildingStats.getCulture() * (float)2);
        }
        for (Stat stat : Stat.getEntries()) {
            buildingStats.set(stat, buildingStats.get(stat) * this.personality.scaledFocus(PersonalityValue.Companion.get(stat)));
        }
        return Automation.INSTANCE.rankStatsValue(buildingStats.clone(), this.civInfo);
    }

    private final Stats getStatDifferenceFromBuilding(String building, LocalUniqueCache localUniqueCache) {
        City newCity = this.city.clone();
        newCity.setTransients(this.city.getCiv());
        CityStats.update$default(newCity.getCityStats(), null, false, false, localUniqueCache, false, 3, null);
        Stats oldStats = newCity.getCityStats().getCurrentCityStats();
        newCity.getCityConstructions().getBuiltBuildings().add(building);
        newCity.getCityConstructions().setTransients();
        CityStats.update$default(newCity.getCityStats(), null, false, false, new LocalUniqueCache(false, 1, null), false, 3, null);
        this.city.getExpansion().setTransients();
        return newCity.getCityStats().getCurrentCityStats().minus(oldStats);
    }

    @Readonly
    private final Stats getBuildingStatsFromUniques(Building building, Stats buildingStats) {
        float relativeAmount;
        Unique unique;
        Stats stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Iterator<Unique> iterator2 = building.getMatchingUniques(UniqueType.StatPercentBonusCities, this.cityState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            Stat statType = Stat.valueOf(unique.getParams().get(1));
            relativeAmount = Float.parseFloat(unique.getParams().get(0)) / 100.0f;
            float amount = this.civInfo.getStats().getStatsForNextTurn().get(statType) * relativeAmount;
            stats.set(statType, stats.get(statType) + amount);
        }
        iterator2 = building.getMatchingUniques(UniqueType.CarryOverFood, this.cityState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, false, 6, null) || Integer.parseInt(unique.getParams().get(0)) == 0) continue;
            float foodGain = this.cityStats.getCurrentCityStats().getFood() + buildingStats.getFood();
            relativeAmount = Float.parseFloat(unique.getParams().get(0)) / 100.0f;
            Stat stat = Stat.Food;
            stats.set(stat, stats.get(stat) + foodGain * relativeAmount);
        }
        return stats;
    }

    private static final String constructionsToAvoid$lambda$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParams().get(0);
    }

    private static final boolean buildings$lambda$0(ConstructionAutomation this$0, Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.disabledAutoAssignConstructions.contains(it.getName()) || this$0.shouldAvoidConstruction(it);
    }

    private static final boolean nonWonders$lambda$0(Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAnyWonder();
    }

    private static final boolean nonWonders$lambda$1(ConstructionAutomation this$0, Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(this$0.buildableBuildings.get(it.getName()), false);
    }

    private static final boolean units$lambda$0(ConstructionAutomation this$0, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(this$0.buildableUnits.get(it.getName()), false) || this$0.disabledAutoAssignConstructions.contains(it.getName()) || this$0.shouldAvoidConstruction(it);
    }

    private static final boolean filterBuildable$lambda$0(ConstructionAutomation this$0, INonPerpetualConstruction it) {
        HashMap<String, Boolean> cache2;
        Intrinsics.checkNotNullParameter(it, "it");
        HashMap<String, Boolean> hashMap = cache2 = it instanceof Building ? this$0.buildableBuildings : this$0.buildableUnits;
        if (cache2.get(((INamed)it).getName()) == null) {
            ((Map)cache2).put(((INamed)it).getName(), ((IConstruction)it).isBuildable(this$0.cityConstructions));
        }
        Boolean bl = cache2.get(((INamed)it).getName());
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    private static final boolean addWorkBoatChoice$lambda$0(ConstructionAutomation this$0, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return IHasUniques.hasUnique$default(it, UniqueType.CreateWaterImprovements, null, 2, null) && Automation.INSTANCE.allowAutomatedConstruction(this$0.civInfo, this$0.city, it);
    }

    @Readonly
    private static final boolean addWorkBoatChoice$isOurWorkBoat(MapUnit $this$addWorkBoatChoice_u24isOurWorkBoat, ConstructionAutomation this$0) {
        return $this$addWorkBoatChoice_u24isOurWorkBoat.getCache().getHasUniqueToCreateWaterImprovements() && Intrinsics.areEqual($this$addWorkBoatChoice_u24isOurWorkBoat.getCiv(), this$0.civInfo);
    }

    @Readonly
    private static final boolean addWorkBoatChoice$isWorthImproving(Tile $this$addWorkBoatChoice_u24isWorthImproving, ConstructionAutomation this$0) {
        if (!Intrinsics.areEqual($this$addWorkBoatChoice_u24isWorthImproving.getOwner(), this$0.civInfo)) {
            return false;
        }
        if (!WorkerAutomation.Companion.hasWorkableSeaResource($this$addWorkBoatChoice_u24isWorthImproving, this$0.civInfo)) {
            return false;
        }
        return WorkerAutomation.Companion.isNotBonusResourceOrWorkable($this$addWorkBoatChoice_u24isWorthImproving, this$0.civInfo);
    }

    @Readonly
    private static final boolean addWorkBoatChoice$findTileWorthImproving(ConstructionAutomation this$0) {
        int searchMaxTiles = this$0.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getWorkboatAutomationSearchMaxTiles();
        BFS bfs = new BFS(this$0.city.getCenterTile(), arg_0 -> ConstructionAutomation.addWorkBoatChoice$findTileWorthImproving$lambda$3(this$0, arg_0));
        while (bfs.nextStep() != null) {
            Tile tile;
            if (ConstructionAutomation.addWorkBoatChoice$isWorthImproving(tile, this$0)) {
                return true;
            }
            if (bfs.size() < searchMaxTiles) continue;
        }
        return false;
    }

    private static final boolean addWorkBoatChoice$findTileWorthImproving$lambda$3(ConstructionAutomation this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !(!it.isWater() && !it.isCityCenter() || it.getOwner() != null && !it.isFriendlyTerritory(this$0.civInfo) || !it.isExplored(this$0.civInfo));
    }

    private static final boolean addWorkerChoice$lambda$0(ConstructionAutomation this$0, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return IHasUniques.hasUnique$default(it, UniqueType.BuildImprovements, null, 2, null) && Automation.INSTANCE.allowAutomatedConstruction(this$0.civInfo, this$0.city, it);
    }

    private static final boolean addSpaceshipPartChoice$lambda$0(ConstructionAutomation this$0, IHasUniques it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.spaceshipParts.contains(((INamed)it).getName());
    }

    private static final NextTurnAutomation.CityDistance getMilitaryBuildingValue$lambda$0(ConstructionAutomation this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return NextTurnAutomation.INSTANCE.getForeignCityNearCapital(Civilization.getCapital$default(it, false, 1, null), this$0.civInfo);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/unciv/logic/automation/city/ConstructionAutomation$ConstructionChoice;", "", "choice", "Lcom/unciv/models/ruleset/IConstruction;", "choiceModifier", "", "remainingWork", "", "production", "<init>", "(Lcom/unciv/models/ruleset/IConstruction;FII)V", "getChoice", "()Lcom/unciv/models/ruleset/IConstruction;", "getChoiceModifier", "()F", "setChoiceModifier", "(F)V", "getRemainingWork", "()I", "getProduction", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class ConstructionChoice {
        @NotNull
        private final IConstruction choice;
        private float choiceModifier;
        private final int remainingWork;
        private final int production;

        public ConstructionChoice(@NotNull IConstruction choice, float choiceModifier, int remainingWork, int production) {
            Intrinsics.checkNotNullParameter(choice, "choice");
            this.choice = choice;
            this.choiceModifier = choiceModifier;
            this.remainingWork = remainingWork;
            this.production = production;
        }

        @NotNull
        public final IConstruction getChoice() {
            return this.choice;
        }

        public final float getChoiceModifier() {
            return this.choiceModifier;
        }

        public final void setChoiceModifier(float f) {
            this.choiceModifier = f;
        }

        public final int getRemainingWork() {
            return this.remainingWork;
        }

        public final int getProduction() {
            return this.production;
        }

        @NotNull
        public final IConstruction component1() {
            return this.choice;
        }

        public final float component2() {
            return this.choiceModifier;
        }

        public final int component3() {
            return this.remainingWork;
        }

        public final int component4() {
            return this.production;
        }

        @NotNull
        public final ConstructionChoice copy(@NotNull IConstruction choice, float choiceModifier, int remainingWork, int production) {
            Intrinsics.checkNotNullParameter(choice, "choice");
            return new ConstructionChoice(choice, choiceModifier, remainingWork, production);
        }

        public static /* synthetic */ ConstructionChoice copy$default(ConstructionChoice constructionChoice, IConstruction iConstruction, float f, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                iConstruction = constructionChoice.choice;
            }
            if ((n3 & 2) != 0) {
                f = constructionChoice.choiceModifier;
            }
            if ((n3 & 4) != 0) {
                n = constructionChoice.remainingWork;
            }
            if ((n3 & 8) != 0) {
                n2 = constructionChoice.production;
            }
            return constructionChoice.copy(iConstruction, f, n, n2);
        }

        @NotNull
        public String toString() {
            return "ConstructionChoice(choice=" + this.choice + ", choiceModifier=" + this.choiceModifier + ", remainingWork=" + this.remainingWork + ", production=" + this.production + ')';
        }

        public int hashCode() {
            int result2 = this.choice.hashCode();
            result2 = result2 * 31 + Float.hashCode(this.choiceModifier);
            result2 = result2 * 31 + Integer.hashCode(this.remainingWork);
            result2 = result2 * 31 + Integer.hashCode(this.production);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConstructionChoice)) {
                return false;
            }
            ConstructionChoice constructionChoice = (ConstructionChoice)other;
            if (!Intrinsics.areEqual(this.choice, constructionChoice.choice)) {
                return false;
            }
            if (Float.compare(this.choiceModifier, constructionChoice.choiceModifier) != 0) {
                return false;
            }
            if (this.remainingWork != constructionChoice.remainingWork) {
                return false;
            }
            return this.production == constructionChoice.production;
        }
    }
}

