/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0006\u0010\u001f\u001a\u00020\u0000J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u0006\u0010#\u001a\u00020!J\b\u0010$\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014H\u0002J\b\u0010'\u001a\u00020!H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020\u0014H\u0003J\b\u0010*\u001a\u00020!H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lcom/unciv/logic/automation/civilization/Encampment;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "position", "Lcom/unciv/logic/map/HexCoord;", "(Lcom/unciv/logic/map/HexCoord;)V", "getPosition", "()Lcom/unciv/logic/map/HexCoord;", "setPosition", "countdown", "", "getCountdown", "()I", "setCountdown", "(I)V", "spawnedUnits", "getSpawnedUnits", "setSpawnedUnits", "destroyed", "", "getDestroyed", "()Z", "setDestroyed", "(Z)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "setGameInfo", "(Lcom/unciv/logic/GameInfo;)V", "clone", "update", "", "wasAttacked", "wasDestroyed", "spawnBarbarian", "spawnUnit", "naval", "updateBarbarianTech", "chooseBarbarianUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "resetCountdown", "core"})
@SourceDebugExtension(value={"SMAP\nBarbarianManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarbarianManager.kt\ncom/unciv/logic/automation/civilization/Encampment\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n1276#2,3:301\n827#3:304\n855#3,2:305\n774#3:307\n865#3,2:308\n774#3:310\n865#3,2:311\n1563#3:313\n1634#3,3:314\n*S KotlinDebug\n*F\n+ 1 BarbarianManager.kt\ncom/unciv/logic/automation/civilization/Encampment\n*L\n231#1:301,3\n235#1:304\n235#1:305,2\n258#1:307\n258#1:308,2\n270#1:310\n270#1:311,2\n280#1:313\n280#1:314,3\n*E\n"})
public final class Encampment
implements IsPartOfGameInfoSerialization {
    @NotNull
    private HexCoord position;
    private int countdown;
    private int spawnedUnits;
    private boolean destroyed;
    public transient GameInfo gameInfo;

    public Encampment() {
        this.position = new HexCoord(0, 0, 3, null);
        this.spawnedUnits = -1;
    }

    @NotNull
    public final HexCoord getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "<set-?>");
        this.position = hexCoord;
    }

    public final int getCountdown() {
        return this.countdown;
    }

    public final void setCountdown(int n) {
        this.countdown = n;
    }

    public final int getSpawnedUnits() {
        return this.spawnedUnits;
    }

    public final void setSpawnedUnits(int n) {
        this.spawnedUnits = n;
    }

    public final boolean getDestroyed() {
        return this.destroyed;
    }

    public final void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    @NotNull
    public final GameInfo getGameInfo() {
        GameInfo gameInfo = this.gameInfo;
        if (gameInfo != null) {
            return gameInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
        return null;
    }

    public final void setGameInfo(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "<set-?>");
        this.gameInfo = gameInfo;
    }

    public Encampment(@NotNull HexCoord position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this();
        this.position = position;
    }

    @NotNull
    public final Encampment clone() {
        Encampment toReturn = new Encampment(this.position);
        toReturn.countdown = this.countdown;
        toReturn.spawnedUnits = this.spawnedUnits;
        toReturn.destroyed = this.destroyed;
        return toReturn;
    }

    public final void update() {
        if (this.countdown > 0) {
            int n = this.countdown;
            this.countdown = n + -1;
        } else if (!this.destroyed && this.spawnBarbarian()) {
            int n = this.spawnedUnits;
            this.spawnedUnits = n + 1;
            this.resetCountdown();
        }
    }

    public final void wasAttacked() {
        if (!this.destroyed) {
            this.countdown /= 2;
        }
    }

    public final void wasDestroyed() {
        if (!this.destroyed) {
            this.countdown = 15;
            this.destroyed = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean spawnBarbarian() {
        void $this$filterNotTo$iv$iv;
        Object element$iv;
        Tile tile = this.getGameInfo().getTileMap().get(this.position);
        if (tile.getMilitaryUnit() == null) {
            return this.spawnUnit(false);
        }
        if (this.getGameInfo().getTurns() < 10) {
            return false;
        }
        Civilization barbarianCiv = this.getGameInfo().getBarbarianCivilization();
        Sequence<Tile> $this$count$iv = tile.getTilesInDistance(4);
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Tile> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            Tile it = element$iv;
            boolean bl = false;
            MapUnit mapUnit = it.getMilitaryUnit();
            if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, barbarianCiv) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        if (count$iv > 2) {
            return false;
        }
        boolean canSpawnBoats = this.getGameInfo().getTurns() > 30;
        Iterable $this$filterNot$iv = SequencesKt.toList(tile.getNeighbors());
        boolean $i$f$filterNot = false;
        element$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            if (it.isImpassible() || it.isCityCenter() || it.getFirstUnit() != null || it.isWater() && !canSpawnBoats || Tile.terrainHasUnique$default(it, UniqueType.FreshWater, null, 2, null) && it.isWater()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validTiles = (List)destination$iv$iv;
        if (validTiles.isEmpty()) {
            return false;
        }
        return this.spawnUnit(((Tile)CollectionsKt.random(validTiles, Random.Default)).isWater());
    }

    private final boolean spawnUnit(boolean naval) {
        this.updateBarbarianTech();
        BaseUnit baseUnit = this.chooseBarbarianUnit(naval);
        if (baseUnit == null) {
            return false;
        }
        BaseUnit unitToSpawn = baseUnit;
        MapUnit spawnedUnit = TileMap.placeUnitNearTile$default(this.getGameInfo().getTileMap(), this.position.toHexCoord(), unitToSpawn, this.getGameInfo().getBarbarianCivilization(), null, 8, null);
        return spawnedUnit != null;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateBarbarianTech() {
        void $this$filterTo$iv$iv;
        Civilization barbarianCiv = this.getGameInfo().getBarbarianCivilization();
        Set<String> set = this.getGameInfo().getRuleset().getTechnologies().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        List allResearchedTechs = CollectionsKt.toMutableList((Collection)set);
        Iterable $this$filter$iv = this.getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian() && !it.isDefeated())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv) {
            allResearchedTechs.retainAll((Collection)civ.getTech().getTechsResearched());
        }
        barbarianCiv.getTech().setTechsResearched(CollectionsKt.toHashSet(allResearchedTechs));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Readonly
    private final BaseUnit chooseBarbarianUnit(boolean naval) {
        barbarianCiv = this.getGameInfo().getBarbarianCivilization();
        v0 = this.getGameInfo().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        var4_3 = v0;
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (BaseUnit)element$iv$iv;
            $i$a$-filter-Encampment$chooseBarbarianUnit$unitList$1 = false;
            if (!it.isMilitary()) ** GOTO lbl-1000
            Intrinsics.checkNotNull(it);
            if (!IHasUniques.hasUnique$default(it, UniqueType.CannotAttack, null, 2, null) && !IHasUniques.hasUnique$default(it, UniqueType.CannotBeBarbarian, null, 2, null) && (naval != false ? it.isWaterUnit() : it.isLandUnit()) && it.isBuildable(barbarianCiv)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv /* !! */ .add(element$iv$iv);
        }
        unitList = (List)destination$iv$iv /* !! */ ;
        if (unitList.isEmpty()) {
            return null;
        }
        $this$map$iv = unitList;
        $i$f$map = false;
        destination$iv$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-Encampment$chooseBarbarianUnit$unitList$1 = (BaseUnit)item$iv$iv;
            var14_19 = destination$iv$iv;
            $i$a$-map-Encampment$chooseBarbarianUnit$weightings$1 = false;
            var14_19.add(Float.valueOf(it.getForceEvaluation()));
        }
        weightings = (List)destination$iv$iv;
        return (BaseUnit)CollectionExtensionsKt.randomWeighted$default(unitList, weightings, null, 2, null);
    }

    private final void resetCountdown() {
        this.countdown = 8 + Random.Default.nextInt(5);
        if (this.getGameInfo().getGameParameters().getRagingBarbarians()) {
            this.countdown /= 2;
        }
        Difficulty difficulty = this.getGameInfo().getRuleset().getDifficulties().get(this.getGameInfo().getGameParameters().getDifficulty());
        Intrinsics.checkNotNull(difficulty);
        this.countdown += difficulty.getBarbarianSpawnDelay();
        this.countdown -= Math.min(3, this.spawnedUnits);
        this.countdown = (int)((float)this.countdown * this.getGameInfo().getSpeed().getBarbarianModifier());
    }
}

