/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001b\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/civilization/DiplomacyAction;", "Lcom/unciv/logic/civilization/NotificationAction;", "<init>", "()V", "otherCivName", "", "showTrade", "", "(Ljava/lang/String;Z)V", "otherCiv", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;Z)V", "execute", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "core"})
public final class DiplomacyAction
implements NotificationAction {
    @NotNull
    private final String otherCivName;
    private boolean showTrade;
    private transient Civilization otherCiv;

    public DiplomacyAction() {
        this("", false);
    }

    public DiplomacyAction(@NotNull String otherCivName, boolean showTrade) {
        Intrinsics.checkNotNullParameter(otherCivName, "otherCivName");
        this.otherCivName = otherCivName;
        this.showTrade = showTrade;
    }

    public /* synthetic */ DiplomacyAction(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    public DiplomacyAction(@NotNull Civilization otherCiv, boolean showTrade) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        this.otherCiv = otherCiv;
        this.otherCivName = otherCiv.getCivID();
        this.showTrade = showTrade;
    }

    public /* synthetic */ DiplomacyAction(Civilization civilization, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(civilization, bl);
    }

    @Override
    public void execute(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Civilization currentCiv = worldScreen.getSelectedCiv();
        if (this.otherCiv == null) {
            this.otherCiv = worldScreen.getGameInfo().getCivilization(this.otherCivName);
        }
        if (this.showTrade) {
            Civilization civilization = this.otherCiv;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("otherCiv");
                civilization = null;
            }
            if (Intrinsics.areEqual(civilization, currentCiv)) {
                return;
            }
        }
        if (this.showTrade) {
            Civilization civilization = this.otherCiv;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("otherCiv");
                civilization = null;
            }
            if (civilization.isCityState() || currentCiv.isCityState()) {
                this.showTrade = false;
            }
        }
        if (this.showTrade) {
            Civilization civilization = this.otherCiv;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("otherCiv");
                civilization = null;
            }
            if (currentCiv.isAtWarWith(civilization)) {
                this.showTrade = false;
            }
        }
        UncivGame uncivGame = worldScreen.getGame();
        Civilization civilization = this.otherCiv;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("otherCiv");
            civilization = null;
        }
        uncivGame.pushScreen(new DiplomacyScreen(currentCiv, civilization, null, this.showTrade, 4, null));
    }
}

