/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0000H\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0003J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001dH\u0003J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dR\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/unciv/logic/civilization/managers/RuinsManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "lastChosenRewards", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "<init>", "(Ljava/util/ArrayList;)V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "validRewards", "", "Lcom/unciv/models/ruleset/RuinReward;", "getValidRewards", "()Ljava/util/Collection;", "setValidRewards", "(Ljava/util/Collection;)V", "clone", "setTransients", "", "rememberReward", "reward", "getShuffledPossibleRewards", "", "triggeringUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isPossibleReward", "", "ruinReward", "unit", "selectNextRuinsReward", "core"})
@SourceDebugExtension(value={"SMAP\nRuinsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuinsManager.kt\ncom/unciv/logic/civilization/managers/RuinsManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,85:1\n1255#2,2:86\n*S KotlinDebug\n*F\n+ 1 RuinsManager.kt\ncom/unciv/logic/civilization/managers/RuinsManager\n*L\n57#1:86,2\n*E\n"})
public final class RuinsManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    private final ArrayList<String> lastChosenRewards;
    public transient Civilization civInfo;
    public transient Collection<RuinReward> validRewards;

    public RuinsManager(@NotNull ArrayList<String> lastChosenRewards) {
        Intrinsics.checkNotNullParameter(lastChosenRewards, "lastChosenRewards");
        this.lastChosenRewards = lastChosenRewards;
    }

    public /* synthetic */ RuinsManager(ArrayList arrayList, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String[] stringArray = new String[]{"", ""};
            arrayList = CollectionsKt.arrayListOf(stringArray);
        }
        this(arrayList);
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    @NotNull
    public final Collection<RuinReward> getValidRewards() {
        Collection<RuinReward> collection = this.validRewards;
        if (collection != null) {
            return collection;
        }
        Intrinsics.throwUninitializedPropertyAccessException("validRewards");
        return null;
    }

    public final void setValidRewards(@NotNull Collection<RuinReward> collection) {
        Intrinsics.checkNotNullParameter(collection, "<set-?>");
        this.validRewards = collection;
    }

    @Readonly
    @NotNull
    public final RuinsManager clone() {
        return new RuinsManager(new ArrayList<String>((Collection)this.lastChosenRewards));
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.setCivInfo(civInfo);
        Collection<RuinReward> collection = civInfo.getGameInfo().getRuleset().getRuinRewards().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        this.setValidRewards(collection);
    }

    private final void rememberReward(String reward) {
        this.lastChosenRewards.set(0, this.lastChosenRewards.get(1));
        this.lastChosenRewards.set(1, reward);
    }

    @Readonly
    private final Iterable<RuinReward> getShuffledPossibleRewards(MapUnit triggeringUnit) {
        List candidates = SequencesKt.toMutableList(SequencesKt.flatMap(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getValidRewards()), arg_0 -> RuinsManager.getShuffledPossibleRewards$lambda$0(this, triggeringUnit, arg_0)), RuinsManager::getShuffledPossibleRewards$lambda$1));
        CollectionsKt.shuffle(candidates, RandomKt.Random(triggeringUnit.getTile().getPosition().toVector2().hashCode()));
        return candidates;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final boolean isPossibleReward(RuinReward ruinReward, MapUnit unit) {
        boolean bl;
        block4: {
            void $this$any$iv;
            if (this.lastChosenRewards.contains(ruinReward.getName())) {
                return false;
            }
            if (ruinReward.isUnavailableBySettings(this.getCivInfo().getGameInfo())) {
                return false;
            }
            GameContext gameContext = new GameContext(this.getCivInfo(), null, unit, unit.getTile(), null, null, null, null, null, null, false, 2034, null);
            if (ruinReward.hasUnique(UniqueType.Unavailable, gameContext)) {
                return false;
            }
            Sequence<Unique> sequence = ruinReward.getMatchingUniques(UniqueType.OnlyAvailable, GameContext.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!(!it.conditionalsApply(gameContext))) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return !bl;
    }

    public final void selectNextRuinsReward(@NotNull MapUnit triggeringUnit) {
        Intrinsics.checkNotNullParameter(triggeringUnit, "triggeringUnit");
        for (RuinReward possibleReward : this.getShuffledPossibleRewards(triggeringUnit)) {
            boolean atLeastOneUniqueHadEffect = false;
            for (Unique unique : possibleReward.getUniqueObjects()) {
                if (!unique.conditionalsApply(triggeringUnit.getCache().getState())) continue;
                boolean uniqueTriggered = false;
                int n = unique.getUniqueMultiplier(triggeringUnit.getCache().getState());
                for (int i = 0; i < n; ++i) {
                    int it = i;
                    boolean bl = false;
                    uniqueTriggered = UniqueTriggerActivation.INSTANCE.triggerUnique(unique, triggeringUnit, possibleReward.getNotification(), "from the ruins") || uniqueTriggered;
                }
                atLeastOneUniqueHadEffect = atLeastOneUniqueHadEffect || uniqueTriggered;
            }
            if (!atLeastOneUniqueHadEffect) continue;
            this.rememberReward(possibleReward.getName());
            break;
        }
    }

    private static final boolean getShuffledPossibleRewards$lambda$0(RuinsManager this$0, MapUnit $triggeringUnit, RuinReward it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.isPossibleReward(it, $triggeringUnit);
    }

    private static final Sequence getShuffledPossibleRewards$lambda$1(RuinReward reward) {
        Intrinsics.checkNotNullParameter(reward, "reward");
        return SequencesKt.take(SequencesKt.generateSequence(() -> RuinsManager.getShuffledPossibleRewards$lambda$1$0(reward)), reward.getWeight());
    }

    private static final RuinReward getShuffledPossibleRewards$lambda$1$0(RuinReward $reward) {
        return $reward;
    }

    public RuinsManager() {
        this(null, 1, null);
    }
}

