/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.trade;

import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.SpyFleeReason;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeOffersList;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/unciv/logic/trade/TradeLogic;", "", "ourCivilization", "Lcom/unciv/logic/civilization/Civilization;", "otherCivilization", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;)V", "getOurCivilization", "()Lcom/unciv/logic/civilization/Civilization;", "getOtherCivilization", "ourAvailableOffers", "Lcom/unciv/logic/trade/TradeOffersList;", "getOurAvailableOffers", "()Lcom/unciv/logic/trade/TradeOffersList;", "setOurAvailableOffers", "(Lcom/unciv/logic/trade/TradeOffersList;)V", "theirAvailableOffers", "getTheirAvailableOffers", "setTheirAvailableOffers", "currentTrade", "Lcom/unciv/logic/trade/Trade;", "getCurrentTrade", "()Lcom/unciv/logic/trade/Trade;", "getAvailableOffers", "civInfo", "otherCiv", "acceptTrade", "", "applyGifts", "", "core"})
@SourceDebugExtension(value={"SMAP\nTradeLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeLogic.kt\ncom/unciv/logic/trade/TradeLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n827#2:274\n855#2,2:275\n774#2:277\n865#2,2:278\n827#2:280\n855#2,2:281\n1761#2,3:283\n827#2:286\n855#2,2:287\n827#2:289\n855#2,2:290\n774#2:292\n865#2,2:293\n1761#2,3:295\n1761#2,3:298\n230#2,2:301\n1869#2,2:303\n1761#2,3:305\n1761#2,3:308\n1761#2,3:311\n1761#2,3:314\n*S KotlinDebug\n*F\n+ 1 TradeLogic.kt\ncom/unciv/logic/trade/TradeLogic\n*L\n61#1:274\n61#1:275,2\n62#1:277\n62#1:278,2\n77#1:280\n77#1:281,2\n226#1:283,3\n240#1:286\n240#1:287,2\n242#1:289\n242#1:290,2\n246#1:292\n246#1:293,2\n261#1:295,3\n263#1:298,3\n143#1:301,2\n148#1:303,2\n182#1:305,3\n183#1:308,3\n185#1:311,3\n186#1:314,3\n*E\n"})
public final class TradeLogic {
    @NotNull
    private final Civilization ourCivilization;
    @NotNull
    private final Civilization otherCivilization;
    @NotNull
    private TradeOffersList ourAvailableOffers;
    @NotNull
    private TradeOffersList theirAvailableOffers;
    @NotNull
    private final Trade currentTrade;

    public TradeLogic(@NotNull Civilization ourCivilization, @NotNull Civilization otherCivilization) {
        Intrinsics.checkNotNullParameter(ourCivilization, "ourCivilization");
        Intrinsics.checkNotNullParameter(otherCivilization, "otherCivilization");
        this.ourCivilization = ourCivilization;
        this.otherCivilization = otherCivilization;
        this.ourAvailableOffers = new TradeOffersList();
        this.theirAvailableOffers = new TradeOffersList();
        this.currentTrade = new Trade();
        TradeOffer embassyOffer = new TradeOffer("Accept Embassy", TradeOfferType.Embassy, 0, this.ourCivilization.getGameInfo().getSpeed(), 4, null);
        if (this.ourCivilization.getDiplomacyFunctions().canEstablishEmbassyWith(this.otherCivilization)) {
            this.theirAvailableOffers.add(embassyOffer);
        }
        if (this.ourCivilization.getDiplomacyFunctions().canOfferEmbassyTo(this.otherCivilization)) {
            this.ourAvailableOffers.add(embassyOffer);
        }
        CollectionsKt.addAll((Collection)this.ourAvailableOffers, this.getAvailableOffers(this.ourCivilization, this.otherCivilization));
        CollectionsKt.addAll((Collection)this.theirAvailableOffers, this.getAvailableOffers(this.otherCivilization, this.ourCivilization));
    }

    @NotNull
    public final Civilization getOurCivilization() {
        return this.ourCivilization;
    }

    @NotNull
    public final Civilization getOtherCivilization() {
        return this.otherCivilization;
    }

    @NotNull
    public final TradeOffersList getOurAvailableOffers() {
        return this.ourAvailableOffers;
    }

    public final void setOurAvailableOffers(@NotNull TradeOffersList tradeOffersList) {
        Intrinsics.checkNotNullParameter(tradeOffersList, "<set-?>");
        this.ourAvailableOffers = tradeOffersList;
    }

    @NotNull
    public final TradeOffersList getTheirAvailableOffers() {
        return this.theirAvailableOffers;
    }

    public final void setTheirAvailableOffers(@NotNull TradeOffersList tradeOffersList) {
        Intrinsics.checkNotNullParameter(tradeOffersList, "<set-?>");
        this.theirAvailableOffers = tradeOffersList;
    }

    @NotNull
    public final Trade getCurrentTrade() {
        return this.currentTrade;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final TradeOffersList getAvailableOffers(Civilization civInfo, Civilization otherCiv) {
        Object thirdCiv;
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        TradeOffersList offers = new TradeOffersList();
        if (civInfo.isCityState() || otherCiv.isCityState()) {
            return offers;
        }
        if (civInfo.isAtWarWith(otherCiv)) {
            offers.add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, civInfo.getGameInfo().getSpeed(), 4, null));
        }
        if (civInfo.getDiplomacyFunctions().hasMutualEmbassyWith(otherCiv)) {
            DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(civInfo);
            Intrinsics.checkNotNull(diplomacyManager);
            if (!diplomacyManager.getHasOpenBorders() && Civilization.hasUnique$default(civInfo, UniqueType.EnablesOpenBorders, null, 2, null) && Civilization.hasUnique$default(otherCiv, UniqueType.EnablesOpenBorders, null, 2, null)) {
                offers.add(new TradeOffer("Open Borders", TradeOfferType.Agreement, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            }
        }
        if (civInfo.getDiplomacyFunctions().canSignResearchAgreementNoCostWith(otherCiv)) {
            offers.add(new TradeOffer("Research Agreement", TradeOfferType.Treaty, civInfo.getDiplomacyFunctions().getResearchAgreementCost(otherCiv), civInfo.getGameInfo().getSpeed()));
        }
        if (civInfo.getDiplomacyFunctions().canSignDefensivePactWith(otherCiv)) {
            offers.add(new TradeOffer("Defensive Pact", TradeOfferType.Treaty, 0, civInfo.getGameInfo().getSpeed(), 4, null));
        }
        Iterable iterable = civInfo.getPerTurnResourcesWithOriginsForTrade();
        boolean $i$f$filterNot = false;
        void var7_10 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
            boolean bl = false;
            if (((ResourceSupplyList.ResourceSupply)it).getResource().getResourceType() == ResourceType.Bonus) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(((ResourceSupplyList.ResourceSupply)it).getOrigin(), "Tradable")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ResourceSupplyList.ResourceSupply entry : (List)destination$iv$iv) {
            TradeOfferType resourceTradeOfferType = entry.getResource().getResourceType() == ResourceType.Luxury ? TradeOfferType.Luxury_Resource : TradeOfferType.Strategic_Resource;
            offers.add(new TradeOffer(entry.getResource().getName(), resourceTradeOfferType, entry.getAmount(), civInfo.getGameInfo().getSpeed()));
        }
        Iterator iterator2 = civInfo.getStockpiledResourcesForTrade().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ResourceSupplyList.ResourceSupply entry;
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            entry = (ResourceSupplyList.ResourceSupply)e;
            offers.add(new TradeOffer(entry.getResource().getName(), TradeOfferType.Stockpiled_Resource, entry.getAmount(), civInfo.getGameInfo().getSpeed()));
        }
        offers.add(new TradeOffer("Gold", TradeOfferType.Gold, civInfo.getGold(), civInfo.getGameInfo().getSpeed()));
        offers.add(new TradeOffer("Gold per turn", TradeOfferType.Gold_Per_Turn, (int)civInfo.getStats().getStatsForNextTurn().getGold(), civInfo.getGameInfo().getSpeed()));
        if (!civInfo.isOneCityChallenger() && !otherCiv.isOneCityChallenger()) {
            $this$filterNot$iv = civInfo.getCities();
            $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                if (((City)it).isCapital() || ((City)it).isInResistance()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (City city : (List)destination$iv$iv) {
                offers.add(new TradeOffer(city.getId(), TradeOfferType.City, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            }
        }
        Sequence<Civilization> otherCivsWeKnow = SequencesKt.filter(civInfo.getKnownCivs(), arg_0 -> TradeLogic.getAvailableOffers$lambda$3(otherCiv, arg_0));
        if (IHasUniques.hasUnique$default(civInfo.getGameInfo().getRuleset().getModOptions(), UniqueType.TradeCivIntroductions, null, 2, null)) {
            Sequence<Civilization> civsWeKnowAndTheyDont = SequencesKt.filter(otherCivsWeKnow, arg_0 -> TradeLogic.getAvailableOffers$lambda$4(otherCiv, arg_0));
            Iterator<Civilization> $i$f$filterNot2 = civsWeKnowAndTheyDont.iterator();
            while ($i$f$filterNot2.hasNext()) {
                thirdCiv = $i$f$filterNot2.next();
                offers.add(new TradeOffer(((Civilization)thirdCiv).getCivID(), TradeOfferType.Introduction, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            }
        }
        if (!IHasUniques.hasUnique$default(civInfo.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null)) {
            Sequence<Civilization> civsWeBothKnow = SequencesKt.filter(otherCivsWeKnow, arg_0 -> TradeLogic.getAvailableOffers$lambda$5(otherCiv, arg_0));
            Sequence<Civilization> civsWeArentAtWarWith = SequencesKt.filter(civsWeBothKnow, arg_0 -> TradeLogic.getAvailableOffers$lambda$6(civInfo, arg_0));
            thirdCiv = civsWeArentAtWarWith.iterator();
            while (thirdCiv.hasNext()) {
                Civilization thirdCiv2 = (Civilization)thirdCiv.next();
                offers.add(new TradeOffer(thirdCiv2.getCivID(), TradeOfferType.WarDeclaration, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            }
        }
        Sequence<Civilization> thirdCivsAtWarTheyKnow = SequencesKt.filter(otherCiv.getKnownCivs(), arg_0 -> TradeLogic.getAvailableOffers$lambda$7(civInfo, arg_0));
        Iterator<Civilization> iterator4 = thirdCivsAtWarTheyKnow.iterator();
        while (iterator4.hasNext()) {
            thirdCiv = iterator4.next();
            int amount = new TradeEvaluation().isPeaceProposalEnabled((Civilization)thirdCiv, civInfo) ? 1 : 0;
            offers.add(new TradeOffer(((Civilization)thirdCiv).getCivID(), TradeOfferType.PeaceProposal, amount, civInfo.getGameInfo().getSpeed()));
        }
        return offers;
    }

    /*
     * WARNING - void declaration
     */
    public final void acceptTrade(boolean applyGifts) {
        boolean bl;
        DiplomacyManager theirDiploManager;
        block24: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            TradeOffer it;
            DiplomacyManager ourDiploManager;
            block23: {
                void $this$filterTo$iv$iv;
                TradeOffer offer;
                TradeOffer it2;
                Iterable $this$filterNotTo$iv$iv;
                Iterable element$iv2;
                DiplomacyManager diplomacyManager;
                DiplomacyManager diplomacyManager2 = this.ourCivilization.getDiplomacyManager(this.otherCivilization);
                Intrinsics.checkNotNull(diplomacyManager2);
                ourDiploManager = diplomacyManager2;
                DiplomacyManager diplomacyManager3 = this.otherCivilization.getDiplomacyManager(this.ourCivilization);
                Intrinsics.checkNotNull(diplomacyManager3);
                theirDiploManager = diplomacyManager3;
                DiplomacyManager $this$acceptTrade_u24lambda_u240 = diplomacyManager = ourDiploManager;
                boolean bl3 = false;
                $this$acceptTrade_u24lambda_u240.getTrades().add(this.currentTrade);
                $this$acceptTrade_u24lambda_u240.updateHasOpenBorders();
                DiplomacyManager $this$acceptTrade_u24lambda_u241 = diplomacyManager = theirDiploManager;
                boolean bl4 = false;
                $this$acceptTrade_u24lambda_u241.getTrades().add(this.currentTrade.reverse());
                $this$acceptTrade_u24lambda_u241.updateHasOpenBorders();
                if (applyGifts) {
                    boolean bl5;
                    block22: {
                        Iterable $this$any$iv2 = this.currentTrade.getOurOffers();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Iterable element$iv2 : $this$any$iv2) {
                                it = (TradeOffer)((Object)element$iv2);
                                boolean bl6 = false;
                                if (!Intrinsics.areEqual(it.getName(), "Peace Treaty")) continue;
                                bl5 = true;
                                break block22;
                            }
                            bl5 = false;
                        }
                    }
                    if (!bl5) {
                        int theirGoldValueOfTrade;
                        int ourGoldValueOfTrade = new TradeEvaluation().getTradeAcceptability(this.currentTrade, this.ourCivilization, this.otherCivilization, false);
                        if (ourGoldValueOfTrade > (theirGoldValueOfTrade = new TradeEvaluation().getTradeAcceptability(this.currentTrade.reverse(), this.otherCivilization, this.ourCivilization, false))) {
                            boolean isPureGift = this.currentTrade.getOurOffers().isEmpty();
                            ourDiploManager.giftGold(ourGoldValueOfTrade - RangesKt.coerceAtLeast(theirGoldValueOfTrade, 0), isPureGift);
                        } else if (theirGoldValueOfTrade > ourGoldValueOfTrade) {
                            boolean isPureGift = this.currentTrade.getTheirOffers().isEmpty();
                            theirDiploManager.giftGold(theirGoldValueOfTrade - RangesKt.coerceAtLeast(ourGoldValueOfTrade, 0), isPureGift);
                        }
                    }
                }
                Iterable $this$filterNot$iv = this.currentTrade.getTheirOffers();
                boolean $i$f$filterNot = false;
                element$iv2 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it2 = (TradeOffer)element$iv$iv;
                    boolean bl7 = false;
                    if (it2.getType() == TradeOfferType.Treaty) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object e : (List)destination$iv$iv) {
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    offer = (TradeOffer)e;
                    TradeLogic.acceptTrade$transferTrade(this, this.otherCivilization, this.ourCivilization, offer);
                }
                $this$filterNot$iv = this.currentTrade.getOurOffers();
                $i$f$filterNot = false;
                $this$filterNotTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it2 = (TradeOffer)element$iv$iv;
                    boolean bl8 = false;
                    if (it2.getType() == TradeOfferType.Treaty) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object e : (List)destination$iv$iv) {
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    offer = (TradeOffer)e;
                    TradeLogic.acceptTrade$transferTrade(this, this.ourCivilization, this.otherCivilization, offer);
                }
                Iterable $this$filter$iv = this.currentTrade.getTheirOffers();
                boolean $i$f$filter = false;
                $this$filterNotTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (TradeOffer)element$iv$iv;
                    boolean bl9 = false;
                    if (!(it2.getType() == TradeOfferType.Treaty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object e : (List)destination$iv$iv) {
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    offer = (TradeOffer)e;
                    TradeLogic.acceptTrade$transferTrade(this, this.otherCivilization, this.ourCivilization, offer);
                }
                $this$any$iv = this.currentTrade.getOurOffers();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Iterable element$iv2 : $this$any$iv) {
                        it = (TradeOffer)((Object)element$iv2);
                        boolean bl10 = false;
                        if (!(it.getType() == TradeOfferType.Embassy)) continue;
                        bl2 = true;
                        break block23;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                TradeLogic.acceptTrade$applyEmbassyOffer(ourDiploManager);
            }
            $this$any$iv = this.currentTrade.getTheirOffers();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Iterable element$iv2 : $this$any$iv) {
                    it = (TradeOffer)((Object)element$iv2);
                    boolean bl11 = false;
                    if (!(it.getType() == TradeOfferType.Embassy)) continue;
                    bl = true;
                    break block24;
                }
                bl = false;
            }
        }
        if (bl) {
            TradeLogic.acceptTrade$applyEmbassyOffer(theirDiploManager);
        }
        this.ourCivilization.getCache().updateCivResources();
        this.ourCivilization.updateStatsForNextTurn();
        this.otherCivilization.getCache().updateCivResources();
        this.otherCivilization.updateStatsForNextTurn();
    }

    public static /* synthetic */ void acceptTrade$default(TradeLogic tradeLogic, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        tradeLogic.acceptTrade(bl);
    }

    private static final boolean getAvailableOffers$lambda$3(Civilization $otherCiv, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, $otherCiv) && it.isMajorCiv() && !it.isDefeated();
    }

    private static final boolean getAvailableOffers$lambda$4(Civilization $otherCiv, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !$otherCiv.knows(it) && !it.isDefeated();
    }

    private static final boolean getAvailableOffers$lambda$5(Civilization $otherCiv, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $otherCiv.knows(it);
    }

    private static final boolean getAvailableOffers$lambda$6(Civilization $civInfo, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        DiplomacyManager diplomacyManager = $civInfo.getDiplomacyManager(it);
        Intrinsics.checkNotNull(diplomacyManager);
        return diplomacyManager.canDeclareWar();
    }

    private static final boolean getAvailableOffers$lambda$7(Civilization $civInfo, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAtWarWith($civInfo) && !it.isDefeated() && !IHasUniques.hasUnique$default(it.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private static final void acceptTrade$transferTrade(TradeLogic this$0, Civilization from, Civilization to, TradeOffer offer) {
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[offer.getType().ordinal()]) {
            case 1: {
                v0 = Civilization.getCapital$default(from, false, 1, null);
                Intrinsics.checkNotNull(v0);
                var4_4 = v0.getCenterTile().getTilesInDistance(2).iterator();
                while (var4_4.hasNext()) {
                    tile = var4_4.next();
                    Tile.setExplored$default(tile, to, true, null, 4, null);
                }
                break;
            }
            case 2: {
                to.addGold(offer.getAmount());
                from.addGold(-offer.getAmount());
                break;
            }
            case 3: {
                TechManager.addTechnology$default(to.getTech(), offer.getName(), false, 2, null);
                break;
            }
            case 4: {
                $this$first$iv = from.getCities();
                $i$f$first = false;
                for (T element$iv : $this$first$iv) {
                    it = (City)element$iv;
                    $i$a$-first-TradeLogic$acceptTrade$transferTrade$city$1 = false;
                    if (!Intrinsics.areEqual(it.getId(), offer.getName())) continue;
                    ** GOTO lbl27
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl27:
                // 1 sources

                city = (City)element$iv;
                city.getEspionage().removeAllPresentSpies(SpyFleeReason.CityBought);
                city.moveToCiv(to);
                $this$first$iv = SequencesKt.toList(city.getCenterTile().getUnits());
                $i$f$forEach = false;
                var7_16 = $this$forEach$iv.iterator();
                while (var7_16.hasNext()) {
                    element$iv = var7_16.next();
                    it = (MapUnit)element$iv;
                    $i$a$-forEach-TradeLogic$acceptTrade$transferTrade$1 = false;
                    it.getMovement().teleportToClosestMoveableTile();
                }
                $this$forEach$iv = city.getTiles().iterator();
                while ($this$forEach$iv.hasNext()) {
                    tile = $this$forEach$iv.next();
                    for (MapUnit unit : SequencesKt.toList(tile.getUnits())) {
                        if (unit.getCiv().getDiplomacyFunctions().canPassThroughTiles(to) || unit.getCache().getCanEnterForeignTerrain()) continue;
                        unit.getMovement().teleportToClosestMoveableTile();
                    }
                }
                to.getCache().updateOurTiles();
                from.getCache().updateOurTiles();
                if (!to.isHuman() || city.getFoundingCivObject() == null || Intrinsics.areEqual(from, city.getFoundingCivObject()) || Intrinsics.areEqual(to, city.getFoundingCivObject())) break;
                to.getPopupAlerts().add(new PopupAlert(AlertType.CityTraded, city.getId()));
                break;
            }
            case 5: {
                if (Intrinsics.areEqual(offer.getName(), "Peace Treaty")) {
                    v1 = to.getDiplomacyManager(from);
                    Intrinsics.checkNotNull(v1);
                    v1.makePeace();
                }
                if (Intrinsics.areEqual(offer.getName(), "Research Agreement")) {
                    to.addGold(-offer.getAmount());
                    from.addGold(-offer.getAmount());
                    v2 = to.getDiplomacyManager(from);
                    Intrinsics.checkNotNull(v2);
                    v2.setFlag(DiplomacyFlags.ResearchAgreement, offer.getDuration());
                    v3 = from.getDiplomacyManager(to);
                    Intrinsics.checkNotNull(v3);
                    v3.setFlag(DiplomacyFlags.ResearchAgreement, offer.getDuration());
                }
                if (!Intrinsics.areEqual(offer.getName(), "Defensive Pact")) break;
                v4 = to.getDiplomacyManager(from);
                Intrinsics.checkNotNull(v4);
                v4.signDefensivePact(offer.getDuration());
                break;
            }
            case 6: {
                DiplomacyFunctions.makeCivilizationsMeet$default(to.getDiplomacyFunctions(), to.getGameInfo().getCivilization(offer.getName()), false, 2, null);
                break;
            }
            case 7: {
                nameOfCivToDeclareWarOn = offer.getName();
                $this$any$iv = this$0.currentTrade.getTheirOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl84
                v5 = false;
                ** GOTO lbl91
lbl84:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeLogic$acceptTrade$transferTrade$warType$1 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), nameOfCivToDeclareWarOn) != false)) continue;
                    v5 = true;
                    ** GOTO lbl91
                }
                v5 = false;
lbl91:
                // 3 sources

                if (!v5) ** GOTO lbl107
                $this$any$iv = this$0.currentTrade.getOurOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl97
                v6 = false;
                ** GOTO lbl104
lbl97:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeLogic$acceptTrade$transferTrade$warType$2 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), nameOfCivToDeclareWarOn) != false)) continue;
                    v6 = true;
                    ** GOTO lbl104
                }
                v6 = false;
lbl104:
                // 3 sources

                if (!v6) ** GOTO lbl107
                v7 = WarType.TeamWar;
                ** GOTO lbl136
lbl107:
                // 2 sources

                $this$any$iv = this$0.currentTrade.getTheirOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl112
                v8 = false;
                ** GOTO lbl119
lbl112:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeLogic$acceptTrade$transferTrade$warType$3 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), nameOfCivToDeclareWarOn) != false && this$0.ourCivilization.isAtWarWith(to.getGameInfo().getCivilization(it.getName())) != false)) continue;
                    v8 = true;
                    ** GOTO lbl119
                }
                v8 = false;
lbl119:
                // 3 sources

                if (v8) ** GOTO lbl-1000
                $this$any$iv = this$0.currentTrade.getOurOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl125
                v9 = false;
                ** GOTO lbl132
lbl125:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeLogic$acceptTrade$transferTrade$warType$4 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), nameOfCivToDeclareWarOn) != false && this$0.otherCivilization.isAtWarWith(to.getGameInfo().getCivilization(it.getName())) != false)) continue;
                    v9 = true;
                    ** GOTO lbl132
                }
                v9 = false;
lbl132:
                // 3 sources

                if (v9) lbl-1000:
                // 2 sources

                {
                    v7 = WarType.JoinWar;
                } else {
                    v7 = WarType.DirectWar;
                }
lbl136:
                // 3 sources

                warType = v7;
                switch (WhenMappings.$EnumSwitchMapping$0[warType.ordinal()]) {
                    case 1: 
                    case 2: {
                        v10 = from.getDiplomacyManager(nameOfCivToDeclareWarOn);
                        Intrinsics.checkNotNull(v10);
                        v10.declareWar(new DeclareWarReason(warType, to));
                        break block0;
                    }
                    case 3: {
                        v11 = from.getDiplomacyManager(nameOfCivToDeclareWarOn);
                        Intrinsics.checkNotNull(v11);
                        v11.declareWar(new DeclareWarReason(warType, null, 2, null));
                        break block0;
                    }
                }
                throw new IllegalStateException("Unhandled WarType: " + (Object)warType + " found within TradeOfferType.WarDeclaration");
            }
            case 8: {
                trade = new Trade();
                peaceOffer = new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, offer.getDuration(), 4, null);
                trade.getOurOffers().add(peaceOffer);
                trade.getTheirOffers().add(peaceOffer);
                thirdCiv = from.getGameInfo().getCivilization(offer.getName());
                v12 = from.getDiplomacyManager(thirdCiv);
                Intrinsics.checkNotNull(v12);
                $this$acceptTrade_u24transferTrade_u24lambda_u248 = var8_21 = (tradePartnerDiplo = v12);
                $i$a$-apply-TradeLogic$acceptTrade$transferTrade$2 = false;
                $this$acceptTrade_u24transferTrade_u24lambda_u248.getTrades().add(trade);
                $this$acceptTrade_u24transferTrade_u24lambda_u248.updateHasOpenBorders();
                v13 = thirdCiv.getDiplomacyManager(from);
                Intrinsics.checkNotNull(v13);
                $this$acceptTrade_u24transferTrade_u24lambda_u249 = var8_21 = v13;
                $i$a$-apply-TradeLogic$acceptTrade$transferTrade$3 = false;
                $this$acceptTrade_u24transferTrade_u24lambda_u249.getTrades().add(trade);
                $this$acceptTrade_u24transferTrade_u24lambda_u249.updateHasOpenBorders();
                tradePartnerDiplo.makePeace();
            }
        }
    }

    private static final void acceptTrade$applyEmbassyOffer(DiplomacyManager diploManager) {
        if (diploManager.hasModifier(DiplomaticModifiers.EstablishedEmbassy)) {
            diploManager.replaceModifier(DiplomaticModifiers.EstablishedEmbassy, DiplomaticModifiers.SharedEmbassies, 3.0f);
            diploManager.otherCivDiplomacy().replaceModifier(DiplomaticModifiers.ReceivedEmbassy, DiplomaticModifiers.SharedEmbassies, 3.0f);
        } else {
            diploManager.addModifier(DiplomaticModifiers.ReceivedEmbassy, 1.0f);
            diploManager.otherCivDiplomacy().addModifier(DiplomaticModifiers.EstablishedEmbassy, 2.0f);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WarType.values().length];
            try {
                nArray[WarType.TeamWar.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.JoinWar.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.DirectWar.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TradeOfferType.values().length];
            try {
                nArray[TradeOfferType.Embassy.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Gold.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Technology.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.City.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Treaty.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Introduction.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.WarDeclaration.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.PeaceProposal.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

