/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.BackwardCompatibility;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.GlobalUniques;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.RulesetFile;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Tutorial;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.nation.Personality;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.unit.UnitNameGroup;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.stats.GameResource;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.SubStat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0007\u0010\u0091\u0001\u001a\u00020\u0000J\u0013\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u00012\u0007\u0010\u0094\u0001\u001a\u00020\u000bJM\u0010\u0095\u0001\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0005\u0012\u0003H\u0096\u00010\u0016j\u000f\u0012\u0004\u0012\u00020\u000b\u0012\u0005\u0012\u0003H\u0096\u0001`\u0018\"\f\b\u0000\u0010\u0096\u0001\u0018\u0001*\u00030\u0097\u00012\u000f\u0010\u0098\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0096\u00010\u0099\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u009a\u0001J\u0011\u0010\u009b\u0001\u001a\u00030\u009c\u00012\u0007\u0010\u009d\u0001\u001a\u00020\u0000J\b\u0010\u009e\u0001\u001a\u00030\u009c\u0001J\u0011\u0010\u009f\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a1\u00010\u00a0\u0001H\u0007J\u0011\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a3\u00010\u00a0\u0001H\u0007J\u0011\u0010\u00a4\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a5\u00010\u00a0\u0001H\u0007J\u0011\u0010\u00a6\u0001\u001a\u00030\u009c\u00012\u0007\u0010\u00a7\u0001\u001a\u00020\u0005J\u0010\u0010\u00a8\u0001\u001a\u00030\u009c\u0001H\u0000\u00a2\u0006\u0003\b\u00a9\u0001J\u0010\u0010\u00aa\u0001\u001a\u00030\u009c\u0001H\u0000\u00a2\u0006\u0003\b\u00ab\u0001J&\u0010\u00ac\u0001\u001a\u00030\u009c\u00012\u0014\u0010\u00ad\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0099\u0001\"\u00020\u000bH\u0007\u00a2\u0006\u0003\u0010\u00ae\u0001J\t\u0010\u00af\u0001\u001a\u00020\u000bH\u0016J\t\u0010\u00b0\u0001\u001a\u00020\u000bH\u0007J\u0014\u0010\u00b1\u0001\u001a\u00030\u00b2\u00012\n\b\u0002\u0010\u00b3\u0001\u001a\u00030\u00b4\u0001R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0011j\b\u0012\u0004\u0012\u00020\u000b`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R-\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0017`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR-\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001c0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001c`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR-\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001f0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001f`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR-\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\"0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\"`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR-\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u001a\u0010'\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R-\u0010-\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020.0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020.`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001aR-\u00100\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002010\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u000201`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001aR-\u00103\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002040\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u000204`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001aR!\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u000b07j\b\u0012\u0004\u0012\u00020\u000b`8\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R-\u0010;\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020<0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020<`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u001aR-\u0010>\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020?0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020?`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001aR-\u0010A\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020B0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020B`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u001aR-\u0010D\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020E0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020E`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u001aR!\u0010G\u001a\u0012\u0012\u0004\u0012\u00020H07j\b\u0012\u0004\u0012\u00020H`8\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010:R-\u0010J\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020K0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020K`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u001aR-\u0010M\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020N0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020N`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u001aR-\u0010P\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020Q0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020Q`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u001aR-\u0010S\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020T0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020T`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u001aR-\u0010V\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020W0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020W`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u001aR-\u0010Y\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020Z0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020Z`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u001aR-\u0010\\\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020]0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020]`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\u001aR-\u0010_\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020`0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020``\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\u001aR6\u0010b\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020c0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020c`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010\u001a\"\u0004\be\u0010fR6\u0010g\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020h0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020h`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010\u001a\"\u0004\bj\u0010fR-\u0010k\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020l0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020l`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010\u001aR-\u0010n\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020o0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020o`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010\u001aR\u001a\u0010q\u001a\u00020rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010t\"\u0004\bu\u0010vR&\u0010w\u001a\r\u0012\t\u0012\u00070W\u00a2\u0006\u0002\by0x8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b|\u0010}\u001a\u0004\bz\u0010{R'\u0010~\u001a\r\u0012\t\u0012\u00070N\u00a2\u0006\u0002\by0x8FX\u0086\u0084\u0002\u00a2\u0006\r\n\u0005\b\u0080\u0001\u0010}\u001a\u0004\b\u007f\u0010{R)\u0010\u0081\u0001\u001a\r\u0012\t\u0012\u00070N\u00a2\u0006\u0002\by0x8FX\u0086\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0083\u0001\u0010}\u001a\u0005\b\u0082\u0001\u0010{R'\u0010\u0084\u0001\u001a\n\u0012\u0005\u0012\u00030\u0086\u00010\u0085\u00018FX\u0086\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0089\u0001\u0010}\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001R!\u0010\u008a\u0001\u001a\u0004\u0018\u00010N8FX\u0086\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u008d\u0001\u0010}\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R!\u0010\u008e\u0001\u001a\u0004\u0018\u00010N8FX\u0086\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0090\u0001\u0010}\u001a\u0006\b\u008f\u0001\u0010\u008c\u0001\u00a8\u0006\u00b5\u0001\u00b2\u0006\u000b\u0010\u00b6\u0001\u001a\u00020\u0000X\u008a\u0084\u0002"}, d2={"Lcom/unciv/models/ruleset/Ruleset;", "", "<init>", "()V", "folderLocation", "Lcom/badlogic/gdx/files/FileHandle;", "getFolderLocation", "()Lcom/badlogic/gdx/files/FileHandle;", "setFolderLocation", "(Lcom/badlogic/gdx/files/FileHandle;)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "mods", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getMods", "()Ljava/util/LinkedHashSet;", "beliefs", "Ljava/util/LinkedHashMap;", "Lcom/unciv/models/ruleset/Belief;", "Lkotlin/collections/LinkedHashMap;", "getBeliefs", "()Ljava/util/LinkedHashMap;", "buildings", "Lcom/unciv/models/ruleset/Building;", "getBuildings", "difficulties", "Lcom/unciv/models/ruleset/nation/Difficulty;", "getDifficulties", "eras", "Lcom/unciv/models/ruleset/tech/Era;", "getEras", "speeds", "Lcom/unciv/models/ruleset/Speed;", "getSpeeds", "globalUniques", "Lcom/unciv/models/ruleset/GlobalUniques;", "getGlobalUniques$core", "()Lcom/unciv/models/ruleset/GlobalUniques;", "setGlobalUniques$core", "(Lcom/unciv/models/ruleset/GlobalUniques;)V", "nations", "Lcom/unciv/models/ruleset/nation/Nation;", "getNations", "policies", "Lcom/unciv/models/ruleset/Policy;", "getPolicies", "policyBranches", "Lcom/unciv/models/ruleset/PolicyBranch;", "getPolicyBranches", "religions", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getReligions", "()Ljava/util/ArrayList;", "ruinRewards", "Lcom/unciv/models/ruleset/RuinReward;", "getRuinRewards", "quests", "Lcom/unciv/models/ruleset/Quest;", "getQuests", "specialists", "Lcom/unciv/models/ruleset/Specialist;", "getSpecialists", "technologies", "Lcom/unciv/models/ruleset/tech/Technology;", "getTechnologies", "techColumns", "Lcom/unciv/models/ruleset/tech/TechColumn;", "getTechColumns", "terrains", "Lcom/unciv/models/ruleset/tile/Terrain;", "getTerrains", "tileImprovements", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "getTileImprovements", "tileResources", "Lcom/unciv/models/ruleset/tile/TileResource;", "getTileResources", "tutorials", "Lcom/unciv/models/ruleset/Tutorial;", "getTutorials", "units", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getUnits", "unitPromotions", "Lcom/unciv/models/ruleset/unit/Promotion;", "getUnitPromotions", "unitNameGroups", "Lcom/unciv/models/ruleset/unit/UnitNameGroup;", "getUnitNameGroups", "unitTypes", "Lcom/unciv/models/ruleset/unit/UnitType;", "getUnitTypes", "victories", "Lcom/unciv/models/ruleset/Victory;", "getVictories", "setVictories", "(Ljava/util/LinkedHashMap;)V", "cityStateTypes", "Lcom/unciv/models/ruleset/nation/CityStateType;", "getCityStateTypes", "setCityStateTypes", "personalities", "Lcom/unciv/models/ruleset/nation/Personality;", "getPersonalities", "events", "Lcom/unciv/models/ruleset/Event;", "getEvents", "modOptions", "Lcom/unciv/models/ruleset/ModOptions;", "getModOptions", "()Lcom/unciv/models/ruleset/ModOptions;", "setModOptions", "(Lcom/unciv/models/ruleset/ModOptions;)V", "greatGeneralUnits", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getGreatGeneralUnits", "()Ljava/util/List;", "greatGeneralUnits$delegate", "Lkotlin/Lazy;", "tileRemovals", "getTileRemovals", "tileRemovals$delegate", "nonRoadTileRemovals", "getNonRoadTileRemovals", "nonRoadTileRemovals$delegate", "allHappinessLevelsThatAffectUniques", "", "", "getAllHappinessLevelsThatAffectUniques", "()Ljava/util/Set;", "allHappinessLevelsThatAffectUniques$delegate", "roadImprovement", "getRoadImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "roadImprovement$delegate", "railroadImprovement", "getRailroadImprovement", "railroadImprovement$delegate", "clone", "getGameResource", "Lcom/unciv/models/stats/GameResource;", "resourceName", "createHashmap", "T", "Lcom/unciv/models/stats/INamed;", "items", "", "([Lcom/unciv/models/stats/INamed;)Ljava/util/LinkedHashMap;", "add", "", "ruleset", "clear", "allRulesetObjects", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/IRulesetObject;", "allUniques", "Lcom/unciv/models/ruleset/unique/Unique;", "allICivilopediaText", "Lcom/unciv/ui/screens/civilopediascreen/ICivilopediaText;", "load", "folderHandle", "updateBuildingCosts", "updateBuildingCosts$core", "updateResourceTransients", "updateResourceTransients$core", "addGlobalUniques", "uniques", "([Ljava/lang/String;)V", "toString", "getSummary", "getErrorList", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "tryFixUnknownUniques", "", "core", "fallbackRuleset"})
@SourceDebugExtension(value={"SMAP\nRuleset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ruleset.kt\ncom/unciv/models/ruleset/Ruleset\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,597:1\n176#1,11:719\n176#1,11:730\n176#1,11:741\n176#1,11:752\n176#1,11:763\n176#1,11:780\n176#1,11:791\n176#1,11:802\n176#1,11:813\n176#1,11:824\n176#1,11:835\n176#1,11:846\n176#1,11:857\n176#1,11:870\n176#1,11:881\n176#1,11:892\n176#1,11:903\n176#1,11:914\n176#1,11:925\n176#1,11:936\n176#1,11:947\n176#1,11:958\n176#1,11:969\n1374#2:598\n1460#2,2:599\n1462#2,3:608\n1869#2,2:611\n1374#2:613\n1460#2,2:614\n1462#2,3:623\n1869#2,2:626\n1374#2:628\n1460#2,2:629\n1462#2,3:638\n1869#2,2:641\n1374#2:643\n1460#2,2:644\n1462#2,3:653\n1869#2,2:656\n1374#2:658\n1460#2,2:659\n1462#2,3:668\n1869#2,2:671\n1374#2:682\n1460#2,2:683\n1462#2,3:692\n1869#2,2:695\n1374#2:697\n1460#2,2:698\n1462#2,3:708\n1869#2,2:711\n1374#2:713\n1460#2,5:714\n1869#2,2:778\n295#2,2:868\n774#2:980\n865#2,2:981\n774#2:983\n865#2,2:984\n774#2:988\n865#2,2:989\n774#2:991\n865#2,2:992\n774#2:994\n865#2:995\n866#2:1000\n536#3:601\n521#3,6:602\n536#3:616\n521#3,6:617\n536#3:631\n521#3,6:632\n536#3:646\n521#3,6:647\n536#3:661\n521#3,6:662\n536#3:673\n521#3,6:674\n536#3:685\n521#3,6:686\n536#3:700\n521#3,2:701\n523#3,4:704\n216#4,2:680\n126#4:774\n153#4,3:775\n1#5:703\n1255#6,2:986\n37#7,2:996\n19985#8,2:998\n*S KotlinDebug\n*F\n+ 1 Ruleset.kt\ncom/unciv/models/ruleset/Ruleset\n*L\n350#1:719,11\n354#1:730,11\n362#1:741,11\n365#1:752,11\n368#1:763,11\n376#1:780,11\n380#1:791,11\n383#1:802,11\n386#1:813,11\n389#1:824,11\n392#1:835,11\n395#1:846,11\n399#1:857,11\n444#1:870,11\n452#1:881,11\n456#1:892,11\n462#1:903,11\n472#1:914,11\n477#1:925,11\n482#1:936,11\n487#1:947,11\n494#1:958,11\n497#1:969,11\n192#1:598\n192#1:599,2\n192#1:608,3\n194#1:611,2\n199#1:613\n199#1:614,2\n199#1:623,3\n201#1:626,2\n210#1:628\n210#1:629,2\n210#1:638,3\n212#1:641,2\n217#1:643\n217#1:644,2\n217#1:653,3\n219#1:656,2\n227#1:658\n227#1:659,2\n227#1:668,3\n229#1:671,2\n251#1:682\n251#1:683,2\n251#1:692,3\n253#1:695,2\n266#1:697\n266#1:698,2\n266#1:708,3\n268#1:711,2\n318#1:713\n318#1:714,5\n372#1:778,2\n424#1:868,2\n525#1:980\n525#1:981,2\n533#1:983\n533#1:984,2\n132#1:988\n132#1:989,2\n135#1:991\n135#1:992,2\n136#1:994\n136#1:995\n136#1:1000\n193#1:601\n193#1:602,6\n200#1:616\n200#1:617,6\n211#1:631\n211#1:632,6\n218#1:646\n218#1:647,6\n228#1:661\n228#1:662,6\n245#1:673\n245#1:674,6\n252#1:685\n252#1:686,6\n267#1:700\n267#1:701,2\n267#1:704,4\n246#1:680,2\n372#1:774\n372#1:775,3\n555#1:986,2\n137#1:996,2\n137#1:998,2\n*E\n"})
public final class Ruleset {
    @Nullable
    private FileHandle folderLocation;
    @NotNull
    private String name = "";
    @NotNull
    private final LinkedHashSet<String> mods = new LinkedHashSet();
    @NotNull
    private final LinkedHashMap<String, Belief> beliefs = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Building> buildings = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Difficulty> difficulties = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Era> eras = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Speed> speeds = new LinkedHashMap();
    @NotNull
    private GlobalUniques globalUniques = new GlobalUniques();
    @NotNull
    private final LinkedHashMap<String, Nation> nations = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Policy> policies = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, PolicyBranch> policyBranches = new LinkedHashMap();
    @NotNull
    private final ArrayList<String> religions = new ArrayList();
    @NotNull
    private final LinkedHashMap<String, RuinReward> ruinRewards = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Quest> quests = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Specialist> specialists = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Technology> technologies = new LinkedHashMap();
    @NotNull
    private final ArrayList<TechColumn> techColumns = new ArrayList();
    @NotNull
    private final LinkedHashMap<String, Terrain> terrains = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, TileImprovement> tileImprovements = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, TileResource> tileResources = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Tutorial> tutorials = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, BaseUnit> units = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Promotion> unitPromotions = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, UnitNameGroup> unitNameGroups = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, UnitType> unitTypes = new LinkedHashMap();
    @NotNull
    private LinkedHashMap<String, Victory> victories = new LinkedHashMap();
    @NotNull
    private LinkedHashMap<String, CityStateType> cityStateTypes = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Personality> personalities = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Event> events = new LinkedHashMap();
    @NotNull
    private ModOptions modOptions = new ModOptions();
    @NotNull
    private final Lazy greatGeneralUnits$delegate = LazyKt.lazy(() -> Ruleset.greatGeneralUnits_delegate$lambda$0(this));
    @NotNull
    private final Lazy tileRemovals$delegate = LazyKt.lazy(() -> Ruleset.tileRemovals_delegate$lambda$0(this));
    @NotNull
    private final Lazy nonRoadTileRemovals$delegate = LazyKt.lazy(() -> Ruleset.nonRoadTileRemovals_delegate$lambda$0(this));
    @NotNull
    private final Lazy allHappinessLevelsThatAffectUniques$delegate = LazyKt.lazy(() -> Ruleset.allHappinessLevelsThatAffectUniques_delegate$lambda$0(this));
    @NotNull
    private final Lazy roadImprovement$delegate = LazyKt.lazy(() -> Ruleset.roadImprovement_delegate$lambda$0(this));
    @NotNull
    private final Lazy railroadImprovement$delegate = LazyKt.lazy(() -> Ruleset.railroadImprovement_delegate$lambda$0(this));

    @Nullable
    public final FileHandle getFolderLocation() {
        return this.folderLocation;
    }

    public final void setFolderLocation(@Nullable FileHandle fileHandle) {
        this.folderLocation = fileHandle;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public final LinkedHashSet<String> getMods() {
        return this.mods;
    }

    @NotNull
    public final LinkedHashMap<String, Belief> getBeliefs() {
        return this.beliefs;
    }

    @NotNull
    public final LinkedHashMap<String, Building> getBuildings() {
        return this.buildings;
    }

    @NotNull
    public final LinkedHashMap<String, Difficulty> getDifficulties() {
        return this.difficulties;
    }

    @NotNull
    public final LinkedHashMap<String, Era> getEras() {
        return this.eras;
    }

    @NotNull
    public final LinkedHashMap<String, Speed> getSpeeds() {
        return this.speeds;
    }

    @NotNull
    public final GlobalUniques getGlobalUniques$core() {
        return this.globalUniques;
    }

    public final void setGlobalUniques$core(@NotNull GlobalUniques globalUniques) {
        Intrinsics.checkNotNullParameter(globalUniques, "<set-?>");
        this.globalUniques = globalUniques;
    }

    @NotNull
    public final LinkedHashMap<String, Nation> getNations() {
        return this.nations;
    }

    @NotNull
    public final LinkedHashMap<String, Policy> getPolicies() {
        return this.policies;
    }

    @NotNull
    public final LinkedHashMap<String, PolicyBranch> getPolicyBranches() {
        return this.policyBranches;
    }

    @NotNull
    public final ArrayList<String> getReligions() {
        return this.religions;
    }

    @NotNull
    public final LinkedHashMap<String, RuinReward> getRuinRewards() {
        return this.ruinRewards;
    }

    @NotNull
    public final LinkedHashMap<String, Quest> getQuests() {
        return this.quests;
    }

    @NotNull
    public final LinkedHashMap<String, Specialist> getSpecialists() {
        return this.specialists;
    }

    @NotNull
    public final LinkedHashMap<String, Technology> getTechnologies() {
        return this.technologies;
    }

    @NotNull
    public final ArrayList<TechColumn> getTechColumns() {
        return this.techColumns;
    }

    @NotNull
    public final LinkedHashMap<String, Terrain> getTerrains() {
        return this.terrains;
    }

    @NotNull
    public final LinkedHashMap<String, TileImprovement> getTileImprovements() {
        return this.tileImprovements;
    }

    @NotNull
    public final LinkedHashMap<String, TileResource> getTileResources() {
        return this.tileResources;
    }

    @NotNull
    public final LinkedHashMap<String, Tutorial> getTutorials() {
        return this.tutorials;
    }

    @NotNull
    public final LinkedHashMap<String, BaseUnit> getUnits() {
        return this.units;
    }

    @NotNull
    public final LinkedHashMap<String, Promotion> getUnitPromotions() {
        return this.unitPromotions;
    }

    @NotNull
    public final LinkedHashMap<String, UnitNameGroup> getUnitNameGroups() {
        return this.unitNameGroups;
    }

    @NotNull
    public final LinkedHashMap<String, UnitType> getUnitTypes() {
        return this.unitTypes;
    }

    @NotNull
    public final LinkedHashMap<String, Victory> getVictories() {
        return this.victories;
    }

    public final void setVictories(@NotNull LinkedHashMap<String, Victory> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.victories = linkedHashMap;
    }

    @NotNull
    public final LinkedHashMap<String, CityStateType> getCityStateTypes() {
        return this.cityStateTypes;
    }

    public final void setCityStateTypes(@NotNull LinkedHashMap<String, CityStateType> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.cityStateTypes = linkedHashMap;
    }

    @NotNull
    public final LinkedHashMap<String, Personality> getPersonalities() {
        return this.personalities;
    }

    @NotNull
    public final LinkedHashMap<String, Event> getEvents() {
        return this.events;
    }

    @NotNull
    public final ModOptions getModOptions() {
        return this.modOptions;
    }

    public final void setModOptions(@NotNull ModOptions modOptions) {
        Intrinsics.checkNotNullParameter(modOptions, "<set-?>");
        this.modOptions = modOptions;
    }

    @NotNull
    public final List<BaseUnit> getGreatGeneralUnits() {
        Lazy lazy = this.greatGeneralUnits$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<TileImprovement> getTileRemovals() {
        Lazy lazy = this.tileRemovals$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<TileImprovement> getNonRoadTileRemovals() {
        Lazy lazy = this.nonRoadTileRemovals$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Set<Integer> getAllHappinessLevelsThatAffectUniques() {
        Lazy lazy = this.allHappinessLevelsThatAffectUniques$delegate;
        return (Set)lazy.getValue();
    }

    @Nullable
    public final TileImprovement getRoadImprovement() {
        Lazy lazy = this.roadImprovement$delegate;
        return (TileImprovement)lazy.getValue();
    }

    @Nullable
    public final TileImprovement getRailroadImprovement() {
        Lazy lazy = this.railroadImprovement$delegate;
        return (TileImprovement)lazy.getValue();
    }

    @NotNull
    public final Ruleset clone() {
        Ruleset newRuleset = new Ruleset();
        newRuleset.add(this);
        newRuleset.name = this.name;
        newRuleset.modOptions.setBaseRuleset(this.modOptions.isBaseRuleset());
        return newRuleset;
    }

    @Nullable
    public final GameResource getGameResource(@NotNull String resourceName) {
        GameResource gameResource;
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        Stat stat = Stat.Companion.safeValueOf(resourceName);
        if (stat != null) {
            gameResource = stat;
        } else {
            SubStat subStat = SubStat.Companion.safeValueOf(resourceName);
            gameResource = subStat != null ? (GameResource)subStat : (GameResource)this.tileResources.get(resourceName);
        }
        return gameResource;
    }

    private final /* synthetic */ <T extends INamed> LinkedHashMap<String, T> createHashmap(T[] items) {
        boolean $i$f$createHashmap = false;
        LinkedHashMap hashMap = new LinkedHashMap(items.length);
        for (T item : items) {
            String string;
            try {
                string = item.getName();
            }
            catch (Exception exception2) {
                StringBuilder stringBuilder = new StringBuilder();
                Intrinsics.reifiedOperationMarker(4, "T");
                throw new Exception(stringBuilder.append(Reflection.getOrCreateKotlinClass(INamed.class).getSimpleName()).append(" is missing a name!").toString());
            }
            String itemName = string;
            ((Map)hashMap).put(itemName, item);
            IRulesetObject iRulesetObject = item instanceof IRulesetObject ? (IRulesetObject)item : null;
            if (iRulesetObject == null) continue;
            iRulesetObject.setOriginRuleset(this.name);
        }
        return hashMap;
    }

    public final void add(@NotNull Ruleset ruleset) {
        Object $this$filterTo$iv$iv;
        Map $this$filterTo$iv$iv2;
        Iterable list$iv$iv;
        Map.Entry it;
        Map.Entry element$iv$iv;
        Iterator iterator2;
        Map $this$filterTo$iv$iv22;
        boolean $i$f$filterTo;
        Map destination$iv$iv;
        boolean $i$f$filter;
        Map $this$filter$iv;
        Object $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.beliefs.putAll((Map<String, Belief>)ruleset.beliefs);
        Iterable $this$flatMap$iv = ruleset.modOptions.getBeliefsToRemove();
        boolean $i$f$flatMap = false;
        Object object = $this$flatMap$iv;
        Collection collection = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator3 = $this$flatMapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object t = iterator3.next();
            String beliefsToRemove = (String)t;
            boolean bl = false;
            $this$filter$iv = this.beliefs;
            $i$f$filter = false;
            Map map2 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv22.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                if (!Belief.matchesFilter$default((Belief)it.getValue(), beliefsToRemove, null, false, 6, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(collection, list$iv$iv);
        }
        Object $this$forEach$iv = (IHasUniques[])CollectionsKt.toSet((List)collection);
        boolean $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            Object t = $this$flatMapTo$iv$iv.next();
            String it2 = (String)t;
            boolean bl = false;
            this.beliefs.remove(it2);
        }
        $this$flatMap$iv = ruleset.modOptions.getBuildingsToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        Collection collection2 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl = $this$flatMapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object t = bl.next();
            String buildingToRemove = (String)t;
            boolean bl3 = false;
            $this$filter$iv = this.buildings;
            $i$f$filter = false;
            $this$filterTo$iv$iv22 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv = iterator2.next();
                boolean bl4 = false;
                if (!Building.matchesFilter$default((Building)it.getValue(), buildingToRemove, null, 2, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(collection2, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)collection2);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            Object t = $this$flatMapTo$iv$iv.next();
            String it3 = (String)t;
            boolean bl5 = false;
            this.buildings.remove(it3);
        }
        this.buildings.putAll((Map<String, Building>)ruleset.buildings);
        this.difficulties.putAll((Map<String, Difficulty>)ruleset.difficulties);
        this.eras.putAll((Map<String, Era>)ruleset.eras);
        this.speeds.putAll((Map<String, Speed>)ruleset.speeds);
        $this$forEach$iv = new IHasUniques[]{ruleset.globalUniques};
        this.globalUniques = GlobalUniques.Companion.combine(this.globalUniques, (IHasUniques[])$this$forEach$iv);
        $this$flatMap$iv = ruleset.modOptions.getNationsToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        Collection collection3 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl5 = $this$flatMapTo$iv$iv.iterator();
        while (bl5.hasNext()) {
            Object t = bl5.next();
            String nationToRemove = (String)t;
            boolean bl6 = false;
            $this$filter$iv = this.nations;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv = iterator2.next();
                boolean bl7 = false;
                if (!Nation.matchesFilter$default((Nation)it.getValue(), nationToRemove, null, false, 6, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(collection3, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)collection3);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            Object t = $this$flatMapTo$iv$iv.next();
            String it4 = (String)t;
            boolean bl8 = false;
            this.nations.remove(it4);
        }
        this.nations.putAll((Map<String, Nation>)ruleset.nations);
        $this$flatMap$iv = ruleset.modOptions.getPolicyBranchesToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        Collection collection4 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl8 = $this$flatMapTo$iv$iv.iterator();
        while (bl8.hasNext()) {
            Object t = bl8.next();
            String policyBranchToRemove = (String)t;
            boolean bl9 = false;
            $this$filter$iv = this.policyBranches;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv = iterator2.next();
                boolean bl10 = false;
                if (!Policy.matchesFilter$default((Policy)it.getValue(), policyBranchToRemove, null, 2, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(collection4, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)collection4);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            Object t = $this$flatMapTo$iv$iv.next();
            String it5 = (String)t;
            boolean bl11 = false;
            this.policyBranches.remove(it5);
        }
        this.policyBranches.putAll((Map<String, PolicyBranch>)ruleset.policyBranches);
        this.policies.putAll((Map<String, Policy>)ruleset.policies);
        $this$flatMap$iv = ruleset.modOptions.getPoliciesToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        Collection collection5 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl11 = $this$flatMapTo$iv$iv.iterator();
        while (bl11.hasNext()) {
            Object t = bl11.next();
            String policyToRemove = (String)t;
            boolean bl12 = false;
            $this$filter$iv = this.policies;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv = iterator2.next();
                boolean bl13 = false;
                if (!Policy.matchesFilter$default((Policy)it.getValue(), policyToRemove, null, 2, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(collection5, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)collection5);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            Object t = $this$flatMapTo$iv$iv.next();
            String it6 = (String)t;
            boolean bl14 = false;
            this.policies.remove(it6);
        }
        Iterator<String> iterator4 = ruleset.modOptions.getPoliciesToRemove().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        $this$forEach$iv = iterator4;
        while ($this$forEach$iv.hasNext()) {
            Object e = $this$forEach$iv.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            String policyToRemove = (String)e;
            for (Object object2 : this.policyBranches.values()) {
                Intrinsics.checkNotNullExpressionValue(object2, "next(...)");
                PolicyBranch policyBranch = (PolicyBranch)object2;
                CollectionsKt.removeAll((List)policyBranch.getPolicies(), arg_0 -> Ruleset.add$lambda$10(policyToRemove, arg_0));
            }
        }
        this.quests.putAll((Map<String, Quest>)ruleset.quests);
        this.religions.addAll((Collection<String>)ruleset.religions);
        this.religions.removeAll((Collection)ruleset.modOptions.getReligionsToRemove());
        Map $this$filter$iv2 = this.nations;
        boolean $i$f$filter2 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv2;
        Map map3 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator bl14 = $this$filterTo$iv$iv.entrySet().iterator();
        while (bl14.hasNext()) {
            Map.Entry entry;
            Map.Entry it7 = entry = bl14.next();
            boolean bl15 = false;
            if (!CollectionsKt.contains((Iterable)ruleset.modOptions.getReligionsToRemove(), ((Nation)it7.getValue()).getFavoredReligion())) continue;
            map3.put(entry.getKey(), entry.getValue());
        }
        $this$forEach$iv = map3;
        $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Map.Entry entry;
            Map.Entry it8 = entry = $this$filterTo$iv$iv.next();
            boolean bl16 = false;
            ((Nation)it8.getValue()).setFavoredReligion(null);
        }
        this.ruinRewards.putAll((Map<String, RuinReward>)ruleset.ruinRewards);
        this.specialists.putAll((Map<String, Specialist>)ruleset.specialists);
        $this$flatMap$iv = ruleset.modOptions.getTechsToRemove();
        $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        Collection collection6 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl16 = $this$flatMapTo$iv$iv.iterator();
        while (bl16.hasNext()) {
            Object t = bl16.next();
            String techToRemove = (String)t;
            boolean bl17 = false;
            $this$filter$iv = this.technologies;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv = iterator2.next();
                boolean bl18 = false;
                if (!Technology.matchesFilter$default((Technology)it.getValue(), techToRemove, null, false, 6, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(collection6, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)collection6);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            Object t = $this$flatMapTo$iv$iv.next();
            String it9 = (String)t;
            boolean bl19 = false;
            this.technologies.remove(it9);
        }
        this.technologies.putAll((Map<String, Technology>)ruleset.technologies);
        this.techColumns.addAll((Collection<TechColumn>)ruleset.techColumns);
        this.terrains.putAll((Map<String, Terrain>)ruleset.terrains);
        this.tileImprovements.putAll((Map<String, TileImprovement>)ruleset.tileImprovements);
        this.tileResources.putAll((Map<String, TileResource>)ruleset.tileResources);
        this.tutorials.putAll((Map<String, Tutorial>)ruleset.tutorials);
        this.unitTypes.putAll((Map<String, UnitType>)ruleset.unitTypes);
        this.victories.putAll((Map<String, Victory>)ruleset.victories);
        this.cityStateTypes.putAll((Map<String, CityStateType>)ruleset.cityStateTypes);
        $this$flatMap$iv = ruleset.modOptions.getUnitsToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        Collection collection7 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl19 = $this$flatMapTo$iv$iv.iterator();
        while (bl19.hasNext()) {
            Object t = bl19.next();
            String unitToRemove = (String)t;
            boolean bl20 = false;
            $this$filter$iv = this.units;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                it = element$iv$iv = iterator2.next();
                boolean bl21 = false;
                Map.Entry $this$add_u24lambda_u2415_u240_u240 = entry = it;
                boolean bl22 = false;
                ((BaseUnit)$this$add_u24lambda_u2415_u240_u240.getValue()).setRuleset(this);
                if (!BaseUnit.matchesFilter$default((BaseUnit)entry.getValue(), unitToRemove, null, false, 6, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(collection7, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)collection7);
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            String it10 = (String)e;
            boolean bl23 = false;
            this.units.remove(it10);
        }
        this.units.putAll((Map<String, BaseUnit>)ruleset.units);
        this.personalities.putAll((Map<String, Personality>)ruleset.personalities);
        this.events.putAll((Map<String, Event>)ruleset.events);
        this.modOptions.getUniques().addAll((Collection<String>)ruleset.modOptions.getUniques());
        this.modOptions.getConstants().merge(ruleset.modOptions.getConstants());
        this.unitPromotions.putAll((Map<String, Promotion>)ruleset.unitPromotions);
        this.unitNameGroups.putAll((Map<String, UnitNameGroup>)ruleset.unitNameGroups);
        CollectionsKt.addAll((Collection)this.mods, (Iterable)ruleset.mods);
    }

    public final void clear() {
        this.beliefs.clear();
        this.buildings.clear();
        this.difficulties.clear();
        this.eras.clear();
        this.speeds.clear();
        this.globalUniques = new GlobalUniques();
        this.mods.clear();
        this.nations.clear();
        this.policies.clear();
        this.policyBranches.clear();
        this.quests.clear();
        this.religions.clear();
        this.ruinRewards.clear();
        this.specialists.clear();
        this.technologies.clear();
        this.techColumns.clear();
        this.terrains.clear();
        this.tileImprovements.clear();
        this.tileResources.clear();
        this.tutorials.clear();
        this.unitPromotions.clear();
        this.unitNameGroups.clear();
        this.units.clear();
        this.unitTypes.clear();
        this.victories.clear();
        this.cityStateTypes.clear();
        this.personalities.clear();
        this.events.clear();
    }

    @Readonly
    @NotNull
    public final Sequence<IRulesetObject> allRulesetObjects() {
        return SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)RulesetFile.getEntries()), arg_0 -> Ruleset.allRulesetObjects$lambda$0(this, arg_0));
    }

    @Readonly
    @NotNull
    public final Sequence<Unique> allUniques() {
        return SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)RulesetFile.getEntries()), arg_0 -> Ruleset.allUniques$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final Sequence<ICivilopediaText> allICivilopediaText() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Sequence<IRulesetObject> sequence = this.allRulesetObjects();
        Collection<Event> collection = this.events.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        Sequence<IRulesetObject> sequence2 = sequence;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Event it = (Event)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getChoices();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return SequencesKt.plus(sequence2, (List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void load(@NotNull FileHandle folderHandle) {
        Object object22;
        FileHandle tutorialsFile;
        FileHandle globalTutorialsFile;
        FileHandle eventsFile;
        FileHandle personalitiesFile;
        FileHandle cityStateTypesFile;
        FileHandle fileHandle;
        FileHandle globalUniquesFile;
        FileHandle fileHandle2;
        FileHandle nationsFile;
        FileHandle fileHandle3;
        FileHandle religionsFile;
        String itemName$iv2;
        FileHandle beliefsFile;
        Object it;
        FileHandle fileHandle4;
        FileHandle specialistsFile;
        FileHandle questsFile;
        FileHandle unitNameGroupsFile;
        FileHandle promotionsFile;
        FileHandle unitsFile;
        Map this_$iv;
        FileHandle unitTypesFile;
        Map this_$iv2;
        INamed[] items$iv;
        INamed[] $this$mapTo$iv$iv;
        FileHandle fileHandle5;
        FileHandle improvementsFile;
        FileHandle resourcesFile;
        Object terrain;
        FileHandle terrainsFile;
        INamed[] items$iv2;
        FileHandle buildingsFile;
        FileHandle techFile;
        Intrinsics.checkNotNullParameter(folderHandle, "folderHandle");
        FileHandle modOptionsFile = Ruleset.load$file(RulesetFile.ModOptions, folderHandle);
        if (modOptionsFile.exists()) {
            try {
                Json json = UncivJsonKt.json();
                Intrinsics.checkNotNull(modOptionsFile);
                this.modOptions = UncivJsonKt.fromJsonFile(json, ModOptions.class, modOptionsFile);
                BackwardCompatibility.INSTANCE.updateDeprecations(this.modOptions);
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Failed to get modOptions from json file", ex);
            }
        }
        if ((techFile = Ruleset.load$file(RulesetFile.Techs, folderHandle)).exists()) {
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(techFile);
            for (TechColumn techColumn : UncivJsonKt.fromJsonFile(json, TechColumn[].class, techFile)) {
                this.techColumns.add(techColumn);
                Iterator<Technology> iterator2 = techColumn.getTechs().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                Iterator<Technology> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Technology technology = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(technology, "next(...)");
                    Technology tech = technology;
                    if (tech.getCost() == 0) {
                        tech.setCost(techColumn.getTechCost());
                    }
                    tech.setColumn(techColumn);
                    tech.setOriginRuleset(this.name);
                    ((Map)this.technologies).put(tech.getName(), tech);
                }
            }
        }
        if ((buildingsFile = Ruleset.load$file(RulesetFile.Buildings, folderHandle)).exists()) {
            Map this_$iv3;
            Map map2 = this.buildings;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(buildingsFile);
            items$iv2 = UncivJsonKt.fromJsonFile(json, Building[].class, buildingsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv2.length);
            for (INamed item$iv : items$iv2) {
                Unit unit;
                String string;
                try {
                    string = item$iv.getName();
                }
                catch (Exception exception2) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Building.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv3 = string;
                ((Map)hashMap$iv).put(itemName$iv3, item$iv);
                IRulesetObject iRulesetObject = item$iv instanceof IRulesetObject ? (IRulesetObject)item$iv : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv3)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv3 = hashMap$iv;
            map2.putAll(this_$iv3);
        }
        if ((terrainsFile = Ruleset.load$file(RulesetFile.Terrains, folderHandle)).exists()) {
            Map this_$iv4;
            Map this_$iv3 = this.terrains;
            items$iv2 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(terrainsFile);
            INamed[] iNamedArray = UncivJsonKt.fromJsonFile(json, Terrain[].class, terrainsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(iNamedArray.length);
            for (INamed item$iv : iNamedArray) {
                Unit unit;
                String exception2;
                try {
                    exception2 = item$iv.getName();
                }
                catch (Exception exception3) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Terrain.class).getSimpleName() + " is missing a name!");
                }
                String string = exception2;
                ((Map)hashMap$iv).put(string, item$iv);
                IRulesetObject iRulesetObject = item$iv instanceof IRulesetObject ? (IRulesetObject)item$iv : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv4)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv4 = hashMap$iv;
            this_$iv3.putAll(this_$iv4);
            for (Object e : this.terrains.values()) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                terrain = (Terrain)e;
                ((RulesetStatsObject)terrain).setOriginRuleset(this.name);
                ((Terrain)terrain).setTransients();
            }
        }
        if ((resourcesFile = Ruleset.load$file(RulesetFile.TileResources, folderHandle)).exists()) {
            terrain = this.tileResources;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(resourcesFile);
            INamed[] items$iv4 = UncivJsonKt.fromJsonFile(json, TileResource[].class, resourcesFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv4.length);
            for (INamed item$iv : items$iv4) {
                Unit unit;
                String exception3;
                try {
                    exception3 = item$iv.getName();
                }
                catch (Exception exception2) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(TileResource.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv5 = exception3;
                ((Map)hashMap$iv).put(itemName$iv5, item$iv);
                IRulesetObject iRulesetObject = item$iv instanceof IRulesetObject ? (IRulesetObject)item$iv : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map2 = hashMap$iv;
            terrain.putAll(map2);
        }
        if ((improvementsFile = Ruleset.load$file(RulesetFile.TileImprovements, folderHandle)).exists()) {
            Map this_$iv6;
            Map map3 = this.tileImprovements;
            INamed[] items$iv4 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(improvementsFile);
            INamed[] items$iv5 = UncivJsonKt.fromJsonFile(json, TileImprovement[].class, improvementsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv5.length);
            for (INamed item$iv : items$iv5) {
                Unit unit;
                String string;
                try {
                    string = item$iv.getName();
                }
                catch (Exception exception5) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(TileImprovement.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv6 = string;
                ((Map)hashMap$iv).put(itemName$iv6, item$iv);
                IRulesetObject iRulesetObject = item$iv instanceof IRulesetObject ? (IRulesetObject)item$iv : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv6)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv6 = hashMap$iv;
            map3.putAll(this_$iv6);
        }
        if ((fileHandle5 = Ruleset.load$file(RulesetFile.Eras, folderHandle)).exists()) {
            Map this_$iv7;
            Map this_$iv6 = this.eras;
            INamed[] items$iv5 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle5);
            INamed[] items$iv6 = UncivJsonKt.fromJsonFile(json, Era[].class, fileHandle5);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv6.length);
            for (INamed iNamed : items$iv6) {
                Unit unit;
                String exception5;
                try {
                    exception5 = iNamed.getName();
                }
                catch (Exception exception6) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Era.class).getSimpleName() + " is missing a name!");
                }
                String string = exception5;
                ((Map)hashMap$iv).put(string, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv7)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv7 = hashMap$iv;
            this_$iv6.putAll(this_$iv7);
        }
        Map $this$map$iv = this.eras;
        boolean $i$f$map = false;
        Map items$iv6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator item$iv = $this$mapTo$iv$iv.entrySet().iterator();
        while (item$iv.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = item$iv.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Era era = (Era)entry.getValue();
            collection.add(era);
        }
        Iterable $this$forEach$iv = CollectionsKt.withIndex((List)destination$iv$iv);
        boolean $i$f$forEach22 = false;
        $this$mapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            IndexedValue element$iv;
            IndexedValue it3 = element$iv = $this$mapTo$iv$iv.next();
            boolean bl = false;
            ((Era)it3.getValue()).setEraNumber(it3.getIndex());
        }
        FileHandle speedsFile = Ruleset.load$file(RulesetFile.Speeds, folderHandle);
        if (speedsFile.exists()) {
            Map $i$f$forEach22 = this.speeds;
            $this$mapTo$iv$iv = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(speedsFile);
            items$iv = UncivJsonKt.fromJsonFile(json, Speed[].class, speedsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv.length);
            for (INamed item$iv2 : items$iv) {
                Unit unit;
                String exception6;
                try {
                    exception6 = item$iv2.getName();
                }
                catch (Exception exception3) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Speed.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv8 = exception6;
                ((Map)hashMap$iv).put(itemName$iv8, item$iv2);
                IRulesetObject iRulesetObject = item$iv2 instanceof IRulesetObject ? (IRulesetObject)item$iv2 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv2)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv2 = hashMap$iv;
            $i$f$forEach22.putAll(this_$iv2);
        }
        if ((unitTypesFile = Ruleset.load$file(RulesetFile.UnitTypes, folderHandle)).exists()) {
            void var16_95;
            this_$iv2 = this.unitTypes;
            items$iv = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(unitTypesFile);
            INamed[] items$iv7 = UncivJsonKt.fromJsonFile(json, UnitType[].class, unitTypesFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv7.length);
            boolean bl = false;
            int item$iv2 = items$iv7.length;
            while (var16_95 < item$iv2) {
                Unit unit;
                String string;
                INamed item$iv3 = items$iv7[var16_95];
                try {
                    string = item$iv3.getName();
                }
                catch (Exception exception8) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(UnitType.class).getSimpleName() + " is missing a name!");
                }
                String string2 = string;
                ((Map)hashMap$iv).put(string2, item$iv3);
                IRulesetObject iRulesetObject = item$iv3 instanceof IRulesetObject ? (IRulesetObject)item$iv3 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv)).name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var16_95;
            }
            this_$iv = hashMap$iv;
            this_$iv2.putAll(this_$iv);
        }
        if ((unitsFile = Ruleset.load$file(RulesetFile.Units, folderHandle)).exists()) {
            Map this_$iv8;
            this_$iv = this.units;
            INamed[] items$iv7 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(unitsFile);
            INamed[] items$iv8 = UncivJsonKt.fromJsonFile(json, BaseUnit[].class, unitsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(items$iv8.length);
            for (INamed iNamed : items$iv8) {
                Unit unit;
                String exception8;
                try {
                    exception8 = iNamed.getName();
                }
                catch (Exception exception4) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(BaseUnit.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv10 = exception8;
                ((Map)linkedHashMap).put(itemName$iv10, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv8)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv8 = linkedHashMap;
            this_$iv.putAll(this_$iv8);
        }
        if ((promotionsFile = Ruleset.load$file(RulesetFile.UnitPromotions, folderHandle)).exists()) {
            Map this_$iv9;
            Map this_$iv8 = this.unitPromotions;
            INamed[] items$iv8 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(promotionsFile);
            INamed[] items$iv9 = UncivJsonKt.fromJsonFile(json, Promotion[].class, promotionsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv9.length);
            for (INamed item$iv4 : items$iv9) {
                Unit unit;
                String string;
                try {
                    string = item$iv4.getName();
                }
                catch (Exception exception10) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Promotion.class).getSimpleName() + " is missing a name!");
                }
                String string3 = string;
                ((Map)hashMap$iv).put(string3, item$iv4);
                IRulesetObject iRulesetObject = item$iv4 instanceof IRulesetObject ? (IRulesetObject)item$iv4 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv9)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv9 = hashMap$iv;
            this_$iv8.putAll(this_$iv9);
        }
        if ((unitNameGroupsFile = Ruleset.load$file(RulesetFile.UnitNameGroup, folderHandle)).exists()) {
            Map this_$iv10;
            void var19_133;
            Map this_$iv9 = this.unitNameGroups;
            INamed[] items$iv9 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(unitNameGroupsFile);
            INamed[] iNamedArray = UncivJsonKt.fromJsonFile(json, UnitNameGroup[].class, unitNameGroupsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(iNamedArray.length);
            boolean bl = false;
            int item$iv4 = iNamedArray.length;
            while (var19_133 < item$iv4) {
                Unit unit;
                String exception10;
                INamed iNamed = iNamedArray[var19_133];
                try {
                    exception10 = iNamed.getName();
                }
                catch (Exception exception5) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(UnitNameGroup.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv12 = exception10;
                ((Map)hashMap$iv).put(itemName$iv12, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv10)).name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var19_133;
            }
            this_$iv10 = hashMap$iv;
            this_$iv9.putAll(this_$iv10);
        }
        if ((questsFile = Ruleset.load$file(RulesetFile.Quests, folderHandle)).exists()) {
            Map this_$iv10 = this.quests;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(questsFile);
            INamed[] items$iv11 = UncivJsonKt.fromJsonFile(json, Quest[].class, questsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(items$iv11.length);
            for (INamed item$iv5 : items$iv11) {
                Unit unit;
                String string;
                try {
                    string = item$iv5.getName();
                }
                catch (Exception exception12) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Quest.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv13 = string;
                ((Map)linkedHashMap).put(itemName$iv13, item$iv5);
                IRulesetObject iRulesetObject = item$iv5 instanceof IRulesetObject ? (IRulesetObject)item$iv5 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map4 = linkedHashMap;
            this_$iv10.putAll(map4);
        }
        if ((specialistsFile = Ruleset.load$file(RulesetFile.Specialists, folderHandle)).exists()) {
            Map this_$iv12;
            void var21_165;
            Map map5 = this.specialists;
            INamed[] items$iv11 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(specialistsFile);
            INamed[] items$iv12 = UncivJsonKt.fromJsonFile(json, Specialist[].class, specialistsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv12.length);
            boolean bl2 = false;
            int item$iv5 = items$iv12.length;
            while (var21_165 < item$iv5) {
                Unit unit;
                String exception12;
                INamed iNamed = items$iv12[var21_165];
                try {
                    exception12 = iNamed.getName();
                }
                catch (Exception exception13) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Specialist.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv14 = exception12;
                ((Map)hashMap$iv).put(itemName$iv14, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv12)).name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var21_165;
            }
            this_$iv12 = hashMap$iv;
            map5.putAll(this_$iv12);
        }
        if ((fileHandle4 = Ruleset.load$file(RulesetFile.Policies, folderHandle)).exists()) {
            Map this_$iv13;
            Map this_$iv12 = this.policyBranches;
            INamed[] items$iv12 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle4);
            INamed[] iNamedArray = UncivJsonKt.fromJsonFile(json, PolicyBranch[].class, fileHandle4);
            boolean $i$f$createHashmap2 = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(iNamedArray.length);
            for (INamed item$iv6 : iNamedArray) {
                Unit unit;
                String exception13;
                try {
                    exception13 = item$iv6.getName();
                }
                catch (Exception exception14) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(PolicyBranch.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv15 = exception13;
                ((Map)linkedHashMap).put(itemName$iv15, item$iv6);
                IRulesetObject iRulesetObject = item$iv6 instanceof IRulesetObject ? (IRulesetObject)item$iv6 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv13)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv13 = linkedHashMap;
            this_$iv12.putAll(this_$iv13);
            for (Object e : this.policyBranches.values()) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                PolicyBranch branch = (PolicyBranch)e;
                branch.setRequires(new ArrayList<String>());
                branch.setBranch(branch);
                for (Victory victory : this.victories.values()) {
                    Intrinsics.checkNotNullExpressionValue(victory, "next(...)");
                    Victory victoryType = victory;
                    if (branch.getPriorities().keySet().contains(victoryType.getName())) continue;
                    ((Map)branch.getPriorities()).put(victoryType.getName(), 0);
                }
                ((Map)this.policies).put(branch.getName(), branch);
                Iterator<Policy> victoryType = branch.getPolicies().iterator();
                Intrinsics.checkNotNullExpressionValue(victoryType, "iterator(...)");
                Iterator<Policy> iterator3 = victoryType;
                while (iterator3.hasNext()) {
                    Policy policy = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(policy, "next(...)");
                    Policy policy2 = policy;
                    policy2.setBranch(branch);
                    policy2.setOriginRuleset(this.name);
                    if (policy2.getRequires() == null) {
                        String[] stringArray = new String[]{branch.getName()};
                        policy2.setRequires(CollectionsKt.arrayListOf(stringArray));
                    }
                    if (!Intrinsics.areEqual(policy2, CollectionsKt.last((List)branch.getPolicies()))) {
                        Object v41;
                        block151: {
                            Collection<Policy> item$iv5 = this.policies.values();
                            Intrinsics.checkNotNullExpressionValue(item$iv5, "<get-values>(...)");
                            Iterable $this$firstOrNull$iv = item$iv5;
                            boolean bl = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (Policy)element$iv;
                                boolean bl3 = false;
                                if (!(Intrinsics.areEqual(((Policy)it).getBranch().getName(), policy2.getBranch().getName()) && ((Policy)it).getColumn() == policy2.getColumn() && ((Policy)it).getRow() == policy2.getRow())) continue;
                                v41 = element$iv;
                                break block151;
                            }
                            v41 = null;
                        }
                        Policy policy3 = v41;
                        if (policy3 != null) {
                            this.policies.remove(policy3.getName());
                        }
                    }
                    ((Map)this.policies).put(policy2.getName(), policy2);
                }
                ((Policy)CollectionsKt.last((List)branch.getPolicies())).setName(branch.getName() + " Complete");
            }
        }
        if ((beliefsFile = Ruleset.load$file(RulesetFile.Beliefs, folderHandle)).exists()) {
            void var23_199;
            Map branch = this.beliefs;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(beliefsFile);
            INamed[] items$iv14 = UncivJsonKt.fromJsonFile(json, Belief[].class, beliefsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv14.length);
            boolean bl4 = false;
            int item$iv6 = items$iv14.length;
            while (var23_199 < item$iv6) {
                Unit unit;
                INamed item$iv7 = items$iv14[var23_199];
                try {
                    it = item$iv7.getName();
                }
                catch (Exception exception15) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Belief.class).getSimpleName() + " is missing a name!");
                }
                itemName$iv2 = it;
                ((Map)hashMap$iv).put(itemName$iv2, item$iv7);
                IRulesetObject iRulesetObject = item$iv7 instanceof IRulesetObject ? (IRulesetObject)item$iv7 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var23_199;
            }
            Map map6 = hashMap$iv;
            branch.putAll(map6);
        }
        if ((religionsFile = Ruleset.load$file(RulesetFile.Religions, folderHandle)).exists()) {
            Collection collection = this.religions;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(religionsFile);
            CollectionsKt.addAll(collection, (Iterable)ArraysKt.toList((Object[])UncivJsonKt.fromJsonFile(json, String[].class, religionsFile)));
        }
        if ((fileHandle3 = Ruleset.load$file(RulesetFile.Ruins, folderHandle)).exists()) {
            Map items$iv14 = this.ruinRewards;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle3);
            INamed[] items$iv15 = UncivJsonKt.fromJsonFile(json, RuinReward[].class, fileHandle3);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv15.length);
            for (INamed item$iv8 : items$iv15) {
                Unit unit;
                try {
                    itemName$iv2 = item$iv8.getName();
                }
                catch (Exception exception16) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(RuinReward.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv16 = itemName$iv2;
                ((Map)hashMap$iv).put(itemName$iv16, item$iv8);
                IRulesetObject iRulesetObject = item$iv8 instanceof IRulesetObject ? (IRulesetObject)item$iv8 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map7 = hashMap$iv;
            items$iv14.putAll(map7);
        }
        if ((nationsFile = Ruleset.load$file(RulesetFile.Nations, folderHandle)).exists()) {
            Map this_$iv16;
            Map map8 = this.nations;
            INamed[] items$iv15 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(nationsFile);
            INamed[] iNamedArray = UncivJsonKt.fromJsonFile(json, Nation[].class, nationsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(iNamedArray.length);
            for (INamed item$iv9 : iNamedArray) {
                Unit unit;
                String exception16;
                try {
                    exception16 = item$iv9.getName();
                }
                catch (Exception exception17) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Nation.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv17 = exception16;
                ((Map)hashMap$iv).put(itemName$iv17, item$iv9);
                IRulesetObject iRulesetObject = item$iv9 instanceof IRulesetObject ? (IRulesetObject)item$iv9 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv16)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv16 = hashMap$iv;
            map8.putAll(this_$iv16);
            for (Nation nation : this.nations.values()) {
                Intrinsics.checkNotNullExpressionValue(nation, "next(...)");
                Nation nation2 = nation;
                nation2.setTransients();
            }
        }
        if ((fileHandle2 = Ruleset.load$file(RulesetFile.Difficulties, folderHandle)).exists()) {
            Map nation2 = this.difficulties;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle2);
            INamed[] items$iv17 = UncivJsonKt.fromJsonFile(json, Difficulty[].class, fileHandle2);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv17.length);
            for (INamed item$iv10 : items$iv17) {
                Unit unit;
                String exception17;
                try {
                    exception17 = item$iv10.getName();
                }
                catch (Exception exception18) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Difficulty.class).getSimpleName() + " is missing a name!");
                }
                String string = exception17;
                ((Map)hashMap$iv).put(string, item$iv10);
                IRulesetObject iRulesetObject = item$iv10 instanceof IRulesetObject ? (IRulesetObject)item$iv10 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map9 = hashMap$iv;
            nation2.putAll(map9);
        }
        if ((globalUniquesFile = Ruleset.load$file(RulesetFile.GlobalUniques, folderHandle)).exists()) {
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(globalUniquesFile);
            this.globalUniques = UncivJsonKt.fromJsonFile(json, GlobalUniques.class, globalUniquesFile);
            this.globalUniques.setOriginRuleset(this.name);
        }
        if ((fileHandle = Ruleset.load$file(RulesetFile.VictoryTypes, folderHandle)).exists()) {
            Map this_$iv18;
            Map items$iv17 = this.victories;
            INamed[] $i$f$createHashmap = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle);
            INamed[] items$iv18 = UncivJsonKt.fromJsonFile(json, Victory[].class, fileHandle);
            boolean $i$f$createHashmap4 = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv18.length);
            for (INamed item$iv11 : items$iv18) {
                Unit unit;
                String string;
                try {
                    string = item$iv11.getName();
                }
                catch (Exception exception19) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Victory.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv18 = string;
                ((Map)hashMap$iv).put(itemName$iv18, item$iv11);
                IRulesetObject iRulesetObject = item$iv11 instanceof IRulesetObject ? (IRulesetObject)item$iv11 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv18)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv18 = hashMap$iv;
            items$iv17.putAll(this_$iv18);
        }
        if ((cityStateTypesFile = Ruleset.load$file(RulesetFile.CityStateTypes, folderHandle)).exists()) {
            Map this_$iv19;
            Map this_$iv18 = this.cityStateTypes;
            INamed[] items$iv18 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(cityStateTypesFile);
            INamed[] items$iv19 = UncivJsonKt.fromJsonFile(json, CityStateType[].class, cityStateTypesFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv19.length);
            for (INamed iNamed : items$iv19) {
                Unit unit;
                String exception19;
                try {
                    exception19 = iNamed.getName();
                }
                catch (Exception exception20) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(CityStateType.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv19 = exception19;
                ((Map)hashMap$iv).put(itemName$iv19, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv19)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv19 = hashMap$iv;
            this_$iv18.putAll(this_$iv19);
        }
        if ((personalitiesFile = Ruleset.load$file(RulesetFile.Personalities, folderHandle)).exists()) {
            Map this_$iv20;
            Map this_$iv19 = this.personalities;
            INamed[] items$iv19 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(personalitiesFile);
            INamed[] items$iv20 = UncivJsonKt.fromJsonFile(json, Personality[].class, personalitiesFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv20.length);
            for (INamed item$iv12 : items$iv20) {
                Unit unit;
                String exception20;
                try {
                    exception20 = item$iv12.getName();
                }
                catch (Exception exception21) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Personality.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv20 = exception20;
                ((Map)hashMap$iv).put(itemName$iv20, item$iv12);
                IRulesetObject iRulesetObject = item$iv12 instanceof IRulesetObject ? (IRulesetObject)item$iv12 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv20)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv20 = hashMap$iv;
            this_$iv19.putAll(this_$iv20);
        }
        if ((eventsFile = Ruleset.load$file(RulesetFile.Events, folderHandle)).exists()) {
            Map this_$iv21;
            void var32_284;
            Map this_$iv20 = this.events;
            INamed[] items$iv20 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(eventsFile);
            INamed[] items$iv21 = UncivJsonKt.fromJsonFile(json, Event[].class, eventsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv21.length);
            boolean bl = false;
            int item$iv12 = items$iv21.length;
            while (var32_284 < item$iv12) {
                Unit unit;
                String exception21;
                INamed item$iv13 = items$iv21[var32_284];
                try {
                    exception21 = item$iv13.getName();
                }
                catch (Exception exception22) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Event.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv21 = exception21;
                ((Map)hashMap$iv).put(itemName$iv21, item$iv13);
                IRulesetObject iRulesetObject = item$iv13 instanceof IRulesetObject ? (IRulesetObject)item$iv13 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv21)).name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var32_284;
            }
            this_$iv21 = hashMap$iv;
            this_$iv20.putAll(this_$iv21);
        }
        if ((globalTutorialsFile = Gdx.files.internal("jsons").child(RulesetFile.Tutorials.getFilename())).exists()) {
            Map this_$iv22;
            Map this_$iv21 = this.tutorials;
            INamed[] items$iv21 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(globalTutorialsFile);
            INamed[] items$iv22 = UncivJsonKt.fromJsonFile(json, Tutorial[].class, globalTutorialsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(items$iv22.length);
            for (INamed item$iv14 : items$iv22) {
                Unit unit;
                String exception22;
                try {
                    exception22 = item$iv14.getName();
                }
                catch (Exception object22) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Tutorial.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv22 = exception22;
                ((Map)linkedHashMap).put(itemName$iv22, item$iv14);
                IRulesetObject iRulesetObject = item$iv14 instanceof IRulesetObject ? (IRulesetObject)item$iv14 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv22)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv22 = linkedHashMap;
            this_$iv21.putAll(this_$iv22);
        }
        if ((tutorialsFile = Ruleset.load$file(RulesetFile.Tutorials, folderHandle)).exists()) {
            Map this_$iv22 = this.tutorials;
            INamed[] items$iv22 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(tutorialsFile);
            INamed[] items$iv23 = UncivJsonKt.fromJsonFile(json, Tutorial[].class, tutorialsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv23.length);
            for (INamed item$iv15 : items$iv23) {
                Unit unit;
                try {
                    object22 = item$iv15.getName();
                }
                catch (Exception exception23) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Tutorial.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv23 = object22;
                ((Map)hashMap$iv).put(itemName$iv23, item$iv15);
                IRulesetObject iRulesetObject = item$iv15 instanceof IRulesetObject ? (IRulesetObject)item$iv15 : null;
                if (iRulesetObject != null) {
                    void this_$iv23;
                    iRulesetObject.setOriginRuleset(this_$iv23.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map10 = hashMap$iv;
            this_$iv22.putAll(map10);
        }
        if (this.modOptions.isBaseRuleset()) {
            Lazy<Ruleset> fallbackRuleset$delegate = LazyKt.lazy(Ruleset::load$lambda$3);
            if (this.unitTypes.isEmpty()) {
                this.unitTypes.putAll((Map<String, UnitType>)Ruleset.load$lambda$4(fallbackRuleset$delegate).unitTypes);
            }
            if (!fileHandle3.exists()) {
                this.ruinRewards.putAll((Map<String, RuinReward>)Ruleset.load$lambda$4(fallbackRuleset$delegate).ruinRewards);
            }
            if (!globalUniquesFile.exists()) {
                this.globalUniques = Ruleset.load$lambda$4(fallbackRuleset$delegate).globalUniques;
            }
            if (this.victories.isEmpty()) {
                this.victories.putAll((Map<String, Victory>)Ruleset.load$lambda$4(fallbackRuleset$delegate).victories);
            }
            if (this.speeds.isEmpty()) {
                this.speeds.putAll((Map<String, Speed>)Ruleset.load$lambda$4(fallbackRuleset$delegate).speeds);
            }
            if (this.difficulties.isEmpty()) {
                this.difficulties.putAll((Map<String, Difficulty>)Ruleset.load$lambda$4(fallbackRuleset$delegate).difficulties);
            }
            if (this.cityStateTypes.isEmpty()) {
                for (CityStateType cityStateType : Ruleset.load$lambda$4(fallbackRuleset$delegate).cityStateTypes.values()) {
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    CityStateType cityStateType2;
                    Intrinsics.checkNotNullExpressionValue(cityStateType, "next(...)");
                    CityStateType cityStateType22 = cityStateType;
                    Map map11 = this.cityStateTypes;
                    String string = cityStateType22.getName();
                    CityStateType $this$load_u24lambda_u245 = cityStateType2 = new CityStateType();
                    boolean bl = false;
                    $this$load_u24lambda_u245.setName(cityStateType22.getName());
                    $this$load_u24lambda_u245.setColor(cityStateType22.getColor());
                    object22 = cityStateType22.getFriendBonusUniques();
                    CityStateType cityStateType3 = $this$load_u24lambda_u245;
                    boolean $i$f$filter = false;
                    void var42_315 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it4 = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (!new UniqueValidator((Ruleset)this).checkUnique(new Unique(it4, null, null, 6, null), false, null, true).isEmpty()) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv2;
                    Collection collection = list2;
                    cityStateType3.setFriendBonusUniques(new ArrayList<String>(collection));
                    $this$filter$iv = cityStateType22.getAllyBonusUniques();
                    cityStateType3 = $this$load_u24lambda_u245;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it2 = (String)element$iv$iv;
                        boolean bl3 = false;
                        if (!new UniqueValidator((Ruleset)this).checkUnique(new Unique(it2, null, null, 6, null), false, null, true).isEmpty()) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    list2 = (List)destination$iv$iv3;
                    Collection collection2 = list2;
                    cityStateType3.setAllyBonusUniques(new ArrayList<String>(collection2));
                    map11.put(string, cityStateType2);
                }
            }
            this.updateResourceTransients$core();
        }
    }

    public final void updateBuildingCosts$core() {
        Iterator<Building> iterator2 = this.buildings.values().iterator();
        while (iterator2.hasNext()) {
            TechColumn column;
            boolean bl;
            Building building;
            block2: {
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                if (building.getCost() != -1) continue;
                Sequence $this$any$iv = IHasUniques.getMatchingUniques$default(building, UniqueType.Unbuildable, null, 2, null);
                boolean $i$f$any = false;
                Iterator iterator3 = $this$any$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv = iterator3.next();
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!it.getModifiers().isEmpty()) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (bl || building.techColumn(this) == null) continue;
            building.setCost(building.isAnyWonder() ? column.getWonderCost() : column.getBuildingCost());
        }
    }

    public final void updateResourceTransients$core() {
        Iterator<TileResource> iterator2 = this.tileResources.values().iterator();
        while (iterator2.hasNext()) {
            TileResource resource;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            resource.setTransients(this);
        }
    }

    @VisibleForTesting
    public final void addGlobalUniques(String ... uniques) {
        Intrinsics.checkNotNullParameter(uniques, "uniques");
        CollectionsKt.addAll((Collection)this.globalUniques.getUniques(), uniques);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String toString() {
        String string;
        if (((CharSequence)this.name).length() > 0) {
            string = this.name;
            return string;
        }
        if (this.mods.size() == 1) {
            Object object = RulesetCache.INSTANCE.get(CollectionsKt.first((Iterable)this.mods));
            Intrinsics.checkNotNull(object);
            if (((Ruleset)object).modOptions.isBaseRuleset()) {
                string = (String)CollectionsKt.first((Iterable)this.mods);
                return string;
            }
        }
        string = "Combined RuleSet (" + this.mods + ')';
        return string;
    }

    @Readonly
    @NotNull
    public final String getSummary() {
        ArrayList stringList = new ArrayList();
        if (this.modOptions.isBaseRuleset()) {
            ((Collection)stringList).add("Base Ruleset");
        }
        if (!((Map)this.technologies).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.technologies.size() + "] Techs");
        }
        if (!((Map)this.nations).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.nations.size() + "] Nations");
        }
        if (!((Map)this.units).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.units.size() + "] Units");
        }
        if (!((Map)this.buildings).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.buildings.size() + "] Buildings");
        }
        if (!((Map)this.tileResources).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.tileResources.size() + "] Resources");
        }
        if (!((Map)this.tileImprovements).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.tileImprovements.size() + "] Improvements");
        }
        if (!((Collection)this.religions).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.religions.size() + "] Religions");
        }
        if (!((Map)this.beliefs).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.beliefs.size() + "] Beliefs");
        }
        return CollectionsKt.joinToString$default(stringList, null, null, null, 0, null, Ruleset::getSummary$lambda$0, 31, null);
    }

    @NotNull
    public final RulesetErrorList getErrorList(boolean tryFixUnknownUniques) {
        return RulesetValidator.Companion.create(this, tryFixUnknownUniques).getErrorList();
    }

    public static /* synthetic */ RulesetErrorList getErrorList$default(Ruleset ruleset, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ruleset.getErrorList(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final List greatGeneralUnits_delegate$lambda$0(Ruleset this$0) {
        void $this$filterTo$iv$iv;
        Collection<BaseUnit> collection = this$0.units.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BaseUnit it = (BaseUnit)element$iv$iv;
            boolean bl = false;
            if (!it.hasUnique(UniqueType.GreatPersonFromCombat, GameContext.Companion.getIgnoreConditionals())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List tileRemovals_delegate$lambda$0(Ruleset this$0) {
        void $this$filterTo$iv$iv;
        Collection<TileImprovement> collection = this$0.tileImprovements.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileImprovement it = (TileImprovement)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default(it.getName(), "Remove ", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List nonRoadTileRemovals_delegate$lambda$0(Ruleset this$0) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this$0.getTileRemovals();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block2: {
                void $this$none$iv;
                TileImprovement rulesetImprovement = (TileImprovement)element$iv$iv;
                boolean bl2 = false;
                RoadStatus[] $this$toTypedArray$iv = (RoadStatus[])RoadStatus.getEntries();
                boolean $i$f$toTypedArray = false;
                RoadStatus[] thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = thisCollection$iv.toArray(new RoadStatus[0]);
                boolean $i$f$none = false;
                for (void element$iv : $this$none$iv) {
                    RoadStatus it = (RoadStatus)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getRemoveAction(), rulesetImprovement.getName())) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Set allHappinessLevelsThatAffectUniques_delegate$lambda$0(Ruleset this$0) {
        return SequencesKt.toSet(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object>(this$0, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ruleset this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        var3_4 = this.this$0.allUniques().iterator();
                        while (var3_4.hasNext()) {
                            unique = var3_4.next();
                            var5_6 = unique.getModifiers().iterator();
lbl10:
                            // 4 sources

                            while (var5_6.hasNext()) {
                                conditional = var5_6.next();
                                if (conditional.getType() == UniqueType.ConditionalWhenBelowAmountStatResource && Intrinsics.areEqual(conditional.getParams().get(1), "Happiness")) {
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var3_4;
                                    this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                                    this.L$3 = var5_6;
                                    this.L$4 = conditional;
                                    this.label = 1;
                                    v0 = $this$sequence.yield(Boxing.boxInt(Integer.parseInt(conditional.getParams().get(0))), this);
                                    if (v0 == var7_3) {
                                        return var7_3;
                                    }
                                }
                                ** GOTO lbl32
                            }
                        }
                        break;
                    }
                    case 1: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator<Unique>)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl32:
                        // 2 sources

                        if (conditional.getType() == UniqueType.ConditionalWhenAboveAmountStatResource && Intrinsics.areEqual(conditional.getParams().get(1), "Happiness")) {
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                            this.L$3 = var5_6;
                            this.L$4 = conditional;
                            this.label = 2;
                            v1 = $this$sequence.yield(Boxing.boxInt(Integer.parseInt(conditional.getParams().get(0))), this);
                            if (v1 == var7_3) {
                                return var7_3;
                            }
                        }
                        ** GOTO lbl50
                    }
                    case 2: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl50:
                        // 2 sources

                        if (conditional.getType() != UniqueType.ConditionalWhenBetweenStatResource || !Intrinsics.areEqual(conditional.getParams().get(2), "Happiness")) ** GOTO lbl85
                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                        this.L$3 = var5_6;
                        this.L$4 = conditional;
                        this.label = 3;
                        v2 = $this$sequence.yield(Boxing.boxInt(Integer.parseInt(conditional.getParams().get(0))), this);
                        if (v2 == var7_3) {
                            return var7_3;
                        }
                        ** GOTO lbl68
                    }
                    case 3: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl68:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                        this.L$3 = var5_6;
                        this.L$4 = conditional;
                        this.label = 4;
                        v3 = $this$sequence.yield(Boxing.boxInt(Integer.parseInt(conditional.getParams().get(1)) + 1), this);
                        if (v3 == var7_3) {
                            return var7_3;
                        }
                        ** GOTO lbl85
                    }
                    case 4: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl85:
                        // 3 sources

                        if (conditional.getType() != UniqueType.ConditionalHappy) ** GOTO lbl10
                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                        this.L$3 = var5_6;
                        this.L$4 = SpillingKt.nullOutSpilledVariable(conditional);
                        this.label = 5;
                        v4 = $this$sequence.yield(Boxing.boxInt(0), this);
                        if (v4 != var7_3) ** GOTO lbl10
                        return var7_3;
                    }
                    case 5: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
                        ** GOTO lbl10
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Integer> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final TileImprovement roadImprovement_delegate$lambda$0(Ruleset this$0) {
        return RoadStatus.Road.improvement(this$0);
    }

    private static final TileImprovement railroadImprovement_delegate$lambda$0(Ruleset this$0) {
        return RoadStatus.Railroad.improvement(this$0);
    }

    private static final boolean add$lambda$10(String $policyToRemove, Policy it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Policy.matchesFilter$default(it, $policyToRemove, null, 2, null);
    }

    private static final Sequence allRulesetObjects$lambda$0(Ruleset this$0, RulesetFile it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getGetRulesetObjects().invoke(this$0);
    }

    private static final Sequence allUniques$lambda$0(Ruleset this$0, RulesetFile it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getGetUniques().invoke(this$0);
    }

    private static final FileHandle load$file(RulesetFile $this$load_u24file, FileHandle $folderHandle) {
        return $folderHandle.child($this$load_u24file.getFilename());
    }

    private static final Ruleset load$lambda$3() {
        return RulesetCache.INSTANCE.getVanillaRuleset();
    }

    private static final Ruleset load$lambda$4(Lazy<Ruleset> $fallbackRuleset$delegate) {
        Lazy<Ruleset> lazy = $fallbackRuleset$delegate;
        return lazy.getValue();
    }

    private static final CharSequence getSummary$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }
}

