/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.objectdescriptions;

import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.unit.UnitMovementType;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.objectdescriptions.BaseUnitDescriptions;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0019\b\u0002\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fJ\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0015\u001a\u00020\u0016*\u0012\u0012\u0004\u0012\u00020\u00120\u0017j\b\u0012\u0004\u0012\u00020\u0012`\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014J2\u0010\u001b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001d0\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007\u00a8\u0006%"}, d2={"Lcom/unciv/ui/objectdescriptions/BaseUnitDescriptions;", "", "<init>", "()V", "getShortDescription", "", "baseUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "uniqueExclusionFilter", "Lkotlin/Function1;", "Lcom/unciv/models/ruleset/unique/Unique;", "", "Lkotlin/ExtensionFunctionType;", "getDescription", "city", "Lcom/unciv/logic/city/City;", "getCivilopediaTextLines", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "addPixelUnitImage", "", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getUnitTypeCivilopediaTextLines", "Lcom/unciv/models/ruleset/unit/UnitType;", "getDifferences", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "originalUnit", "betterUnit", "getUpgradeInfoTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "title", "unitUpgrading", "unitToUpgradeTo", "core"})
@SourceDebugExtension(value={"SMAP\nBaseUnitDescriptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseUnitDescriptions.kt\ncom/unciv/ui/objectdescriptions/BaseUnitDescriptions\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n504#2,7:337\n1869#3,2:344\n1761#3,3:346\n*S KotlinDebug\n*F\n+ 1 BaseUnitDescriptions.kt\ncom/unciv/ui/objectdescriptions/BaseUnitDescriptions\n*L\n152#1:337,7\n182#1:344,2\n218#1:346,3\n*E\n"})
public final class BaseUnitDescriptions {
    @NotNull
    public static final BaseUnitDescriptions INSTANCE = new BaseUnitDescriptions();

    private BaseUnitDescriptions() {
    }

    @NotNull
    public final String getShortDescription(@NotNull BaseUnit baseUnit, @NotNull Function1<? super Unique, Boolean> uniqueExclusionFilter) {
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        Intrinsics.checkNotNullParameter(uniqueExclusionFilter, "uniqueExclusionFilter");
        List infoList = new ArrayList();
        if (baseUnit.getStrength() != 0) {
            ((Collection)infoList).add(TranslationsKt.tr(baseUnit.getStrength()) + '\u2020');
        }
        if (baseUnit.getRangedStrength() != 0) {
            ((Collection)infoList).add(TranslationsKt.tr(baseUnit.getRangedStrength()) + '\u2021');
        }
        if (baseUnit.getMovement() != 2) {
            ((Collection)infoList).add(TranslationsKt.tr(baseUnit.getMovement()) + '\u27a1');
        }
        Iterator<String> iterator2 = baseUnit.getPromotions().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String promotion;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            ((Collection)infoList).add(TranslationsKt.tr$default(promotion, false, false, 3, null));
        }
        if (!Intrinsics.areEqual(baseUnit.getReplacementTextForUniques(), "")) {
            ((Collection)infoList).add(baseUnit.getReplacementTextForUniques());
        } else {
            DescriptionHelpersKt.uniquesToDescription(baseUnit, infoList, uniqueExclusionFilter);
        }
        return CollectionsKt.joinToString$default(infoList, null, null, null, 0, null, null, 63, null);
    }

    public static /* synthetic */ String getShortDescription$default(BaseUnitDescriptions baseUnitDescriptions, BaseUnit baseUnit, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = BaseUnitDescriptions::getShortDescription$lambda$0;
        }
        return baseUnitDescriptions.getShortDescription(baseUnit, function1);
    }

    @NotNull
    public final String getDescription(@NotNull BaseUnit baseUnit, @NotNull City city) {
        int available;
        int amount;
        String resourceName;
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        Intrinsics.checkNotNullParameter(city, "city");
        List lines2 = new ArrayList();
        HashMap<String, Integer> availableResources = city.getCiv().getCivResourcesByName();
        for (Map.Entry entry : ((Map)baseUnit.getResourceRequirementsPerTurn(city.getCiv().getState())).entrySet()) {
            TileResource resource;
            resourceName = (String)entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            Integer n = availableResources.get(resourceName);
            int n2 = available = n != null ? n : 0;
            if (baseUnit.getRuleset().getTileResources().get(resourceName) == null) continue;
            ((Collection)lines2).add(TranslationsKt.tr$default(FormattingExtensionsKt.getConsumesAmountString(resourceName, amount, resource.isStockpiled(), available), false, false, 3, null));
        }
        for (Map.Entry entry : ((Map)baseUnit.getStockpiledResourceRequirements(city.getCiv().getState())).entrySet()) {
            resourceName = (String)entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            available = city.getAvailableResourceAmount(resourceName);
            if (city.getRuleset().getTileResources().get(resourceName) == null) continue;
            ((Collection)lines2).add(TranslationsKt.tr$default(FormattingExtensionsKt.getCostsAmountString(resourceName, amount, available), false, false, 3, null));
        }
        String strengthLine = "";
        if (baseUnit.getStrength() != 0) {
            strengthLine = strengthLine + baseUnit.getStrength() + "\u2020, ";
            if (baseUnit.getRangedStrength() != 0) {
                strengthLine = strengthLine + baseUnit.getRangedStrength() + "\u2021, " + baseUnit.getRange() + "\u2026, ";
            }
        }
        ((Collection)lines2).add(strengthLine + baseUnit.getMovement() + '\u27a1');
        if (!Intrinsics.areEqual(baseUnit.getReplacementTextForUniques(), "")) {
            ((Collection)lines2).add(baseUnit.getReplacementTextForUniques());
        } else {
            DescriptionHelpersKt.uniquesToDescription(baseUnit, lines2, BaseUnitDescriptions::getDescription$lambda$0);
        }
        if (!((Collection)baseUnit.getPromotions()).isEmpty()) {
            String prefix = TranslationsKt.tr$default("Free promotion" + (baseUnit.getPromotions().size() == 1 ? "" : "s") + ':', false, false, 3, null) + ' ';
            ((Collection)lines2).add(CollectionsKt.joinToString$default(baseUnit.getPromotions(), ", ", prefix, null, 0, null, BaseUnitDescriptions::getDescription$lambda$1, 28, null));
        }
        return CollectionsKt.joinToString$default(lines2, "\n", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final List<FormattedLine> getCivilopediaTextLines(@NotNull BaseUnit baseUnit, @NotNull Ruleset ruleset) {
        Iterator<String> $this$filterValues$iv;
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        ArrayList<FormattedLine> textList = new ArrayList<FormattedLine>();
        this.addPixelUnitImage(textList, baseUnit);
        Object object = ruleset.getUnitTypes().get(baseUnit.getUnitType());
        if (object == null || (object = ((UnitType)object).makeLink()) == null) {
            object = "";
        }
        Object unitTypeLink = object;
        ((Collection)textList).add(new FormattedLine("{Unit type}: " + TranslationsKt.tr$default(baseUnit.getUnitType(), false, false, 3, null), (String)unitTypeLink, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        ArrayList stats = new ArrayList();
        if (baseUnit.getStrength() != 0) {
            ((Collection)stats).add("" + baseUnit.getStrength() + '\u2020');
        }
        if (baseUnit.getRangedStrength() != 0) {
            ((Collection)stats).add("" + baseUnit.getRangedStrength() + '\u2021');
            ((Collection)stats).add("" + baseUnit.getRange() + '\u2026');
        }
        if (baseUnit.getMovement() != 0) {
            UnitType unitType = ruleset.getUnitTypes().get(baseUnit.getUnitType());
            if (!(unitType != null ? unitType.isAirUnit() : false)) {
                ((Collection)stats).add("" + baseUnit.getMovement() + '\u27a1');
            }
        }
        if (!((Collection)stats).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(CollectionsKt.joinToString$default(stats, ", ", null, null, 0, null, null, 62, null), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (baseUnit.getCost() > 0) {
            stats.clear();
            ((Collection)stats).add("" + baseUnit.getCost() + '\u2699');
            if (baseUnit.canBePurchasedWithStat(null, Stat.Gold)) {
                ((Collection)stats).add("" + baseUnit.getCivilopediaGoldCost() + '\u00a4');
            }
            ((Collection)textList).add(new FormattedLine(CollectionsKt.joinToString$default(stats, "/", "{Cost}: ", null, 0, null, null, 60, null), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (baseUnit.getInterceptRange() > 0) {
            ((Collection)textList).add(new FormattedLine("Air Intercept Range: [" + baseUnit.getInterceptRange() + ']', null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (((CharSequence)baseUnit.getReplacementTextForUniques()).length() > 0) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine(baseUnit.getReplacementTextForUniques(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        } else {
            DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(baseUnit, textList, null, true, null, 10, null);
        }
        if (baseUnit.getRequiredResource() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            TileResource resource = (TileResource)((Map)ruleset.getTileResources()).get(baseUnit.getRequiredResource());
            Collection collection = textList;
            String string = baseUnit.getRequiredResource();
            Intrinsics.checkNotNull(string);
            TileResource tileResource = resource;
            Intrinsics.checkNotNull(tileResource);
            collection.add(new FormattedLine(FormattingExtensionsKt.getConsumesAmountString$default(string, 1, tileResource.isStockpiled(), 0, 4, null), "Resources/" + baseUnit.getRequiredResource(), null, null, 0.0f, 0, 0, 0, 0.0f, "#F42", false, false, false, false, 15868, null));
        }
        if (baseUnit.getUniqueTo() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Unique to [" + baseUnit.getUniqueTo() + ']', "Nation/" + baseUnit.getUniqueTo(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            if (baseUnit.getReplaces() != null) {
                ((Collection)textList).add(new FormattedLine("Replaces [" + baseUnit.getReplaces() + ']', "Unit/" + baseUnit.getReplaces(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        if (baseUnit.getRequiredTech() != null || baseUnit.getUpgradesTo() != null || baseUnit.getObsoleteTech() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        }
        if (baseUnit.getRequiredTech() != null) {
            ((Collection)textList).add(new FormattedLine("Required tech: [" + baseUnit.getRequiredTech() + ']', "Technology/" + baseUnit.getRequiredTech(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        Map map2 = ruleset.getUnits();
        boolean $i$f$filterValues = false;
        LinkedHashMap object2 = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            BaseUnit it = (BaseUnit)entry$iv.getValue();
            boolean bl = false;
            if (!((Intrinsics.areEqual(it.getUpgradesTo(), baseUnit.getName()) || it.getUpgradesTo() != null && Intrinsics.areEqual(it.getUpgradesTo(), baseUnit.getReplaces())) && (it.getUniqueTo() == null || Intrinsics.areEqual(it.getUniqueTo(), baseUnit.getUniqueTo())))) continue;
            object2.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set canUpgradeFrom = ((Map)object2).keySet();
        if (!((Collection)canUpgradeFrom).isEmpty()) {
            if (canUpgradeFrom.size() == 1) {
                ((Collection)textList).add(new FormattedLine("Can upgrade from [" + (String)CollectionsKt.first(canUpgradeFrom) + ']', "Unit/" + (String)CollectionsKt.first(canUpgradeFrom), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
                ((Collection)textList).add(new FormattedLine("Can upgrade from:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                for (String unitName : CollectionsKt.sorted(canUpgradeFrom)) {
                    Collection collection = textList;
                    String string = "Unit/" + unitName;
                    collection.add(new FormattedLine(unitName, string, null, null, 0.0f, 0, 0, 2, 0.0f, null, false, false, false, false, 16252, null));
                }
                ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            }
        }
        if (baseUnit.getUpgradesTo() != null) {
            ((Collection)textList).add(new FormattedLine("Upgrades to [" + baseUnit.getUpgradesTo() + ']', "Unit/" + baseUnit.getUpgradesTo(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if (baseUnit.getObsoleteTech() != null) {
            ((Collection)textList).add(new FormattedLine("Obsolete with [" + baseUnit.getObsoleteTech() + ']', "Technology/" + baseUnit.getObsoleteTech(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if (!((Collection)baseUnit.getPromotions()).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)baseUnit.getPromotions());
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                IndexedValue indexedValue;
                IndexedValue it = indexedValue = iterator2.next();
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine((baseUnit.getPromotions().size() == 1 ? "{Free promotion:} " : (it.getIndex() == 0 ? "{Free promotions:} " : "")) + '{' + TranslationsKt.tr$default((String)it.getValue(), false, false, 3, null) + '}' + (baseUnit.getPromotions().size() == 1 || it.getIndex() == baseUnit.getPromotions().size() - 1 ? "" : ","), "Promotions/" + (String)it.getValue(), null, null, 0.0f, 0, 0, it.getIndex() == 0 ? 0 : 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        ArrayList seeAlso = new ArrayList();
        for (Map.Entry entry : ((Map)ruleset.getUnits()).entrySet()) {
            String string = (String)entry.getKey();
            BaseUnit unit = (BaseUnit)entry.getValue();
            if (!Intrinsics.areEqual(unit.getReplaces(), baseUnit.getName()) && !baseUnit.getUniques().contains('[' + baseUnit.getName() + ']')) continue;
            ((Collection)seeAlso).add(new FormattedLine(string, "Unit/" + string, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
        }
        if (!((Collection)seeAlso).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{See also}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            CollectionsKt.addAll((Collection)textList, seeAlso);
        }
        return textList;
    }

    private final void addPixelUnitImage(ArrayList<FormattedLine> $this$addPixelUnitImage, BaseUnit baseUnit) {
        boolean bl;
        block6: {
            Iterable $this$any$iv = baseUnit.getCivilopediaText();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FormattedLine it = (FormattedLine)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = ((CharSequence)it.getExtraImage()).length() > 0;
                    if (!bl3) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        GameSettings settings = GUI.INSTANCE.getSettings();
        CharSequence $i$f$any = settings.getUnitSet();
        if ($i$f$any == null || $i$f$any.length() == 0 || settings.getPediaUnitArtSize() < 1.0f) {
            return;
        }
        String imageName = "TileSets/" + settings.getUnitSet() + "/Units/" + baseUnit.getName();
        if (!ImageGetter.INSTANCE.imageExists(imageName)) {
            return;
        }
        $this$addPixelUnitImage.add(new FormattedLine(null, null, null, imageName, settings.getPediaUnitArtSize(), 0, 0, 0, 0.0f, null, false, false, true, false, 12263, null));
        $this$addPixelUnitImage.add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, "GRAY", true, false, false, false, 14847, null));
    }

    @NotNull
    public final List<FormattedLine> getUnitTypeCivilopediaTextLines(@NotNull UnitType $this$getUnitTypeCivilopediaTextLines, @NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter($this$getUnitTypeCivilopediaTextLines, "<this>");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return SequencesKt.toList(StringsKt.startsWith$default($this$getUnitTypeCivilopediaTextLines.getName(), "Domain: ", false, 2, null) ? BaseUnitDescriptions.getUnitTypeCivilopediaTextLines$getDomainLines($this$getUnitTypeCivilopediaTextLines, ruleset) : BaseUnitDescriptions.getUnitTypeCivilopediaTextLines$getUnitTypeLines($this$getUnitTypeCivilopediaTextLines, ruleset));
    }

    @NotNull
    public final Sequence<Pair<String, String>> getDifferences(@NotNull Ruleset ruleset, @NotNull BaseUnit originalUnit, @NotNull BaseUnit betterUnit) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(originalUnit, "originalUnit");
        Intrinsics.checkNotNullParameter(betterUnit, "betterUnit");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Pair<? extends String, ? extends String>>, Continuation<? super Unit>, Object>(betterUnit, originalUnit, ruleset, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BaseUnit $betterUnit;
            final /* synthetic */ BaseUnit $originalUnit;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$betterUnit = $betterUnit;
                this.$originalUnit = $originalUnit;
                this.$ruleset = $ruleset;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block34: {
                    block33: {
                        block32: {
                            var2_2 = (SequenceScope)this.L$0;
                            var15_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure($result);
                                    if (this.$betterUnit.getStrength() != this.$originalUnit.getStrength()) {
                                        this.L$0 = $this$sequence;
                                        this.label = 1;
                                        v0 = $this$sequence.yield(TuplesKt.to("\u2020 {[" + this.$betterUnit.getStrength() + "] vs [" + this.$originalUnit.getStrength() + "]}", null), this);
                                        if (v0 == var15_3) {
                                            return var15_3;
                                        }
                                    }
                                    ** GOTO lbl16
                                }
                                case 1: {
                                    ResultKt.throwOnFailure($result);
                                    v0 = $result;
lbl16:
                                    // 2 sources

                                    if (this.$betterUnit.getRangedStrength() <= 0 || this.$originalUnit.getRangedStrength() != 0) break;
                                    this.L$0 = $this$sequence;
                                    this.label = 2;
                                    v1 = $this$sequence.yield(TuplesKt.to("[Gained] \u2021 [" + this.$betterUnit.getRangedStrength() + "] \u2026 [" + this.$betterUnit.getRange() + ']', null), this);
                                    if (v1 == var15_3) {
                                        return var15_3;
                                    }
                                    ** GOTO lbl59
                                }
                                case 2: {
                                    ResultKt.throwOnFailure($result);
                                    v1 = $result;
                                    ** GOTO lbl59
                                }
                            }
                            if (this.$betterUnit.getRangedStrength() != 0 || this.$originalUnit.getRangedStrength() <= 0) break block32;
                            this.L$0 = $this$sequence;
                            this.label = 3;
                            v2 = $this$sequence.yield(TuplesKt.to("[Lost] \u2021 [" + this.$originalUnit.getRangedStrength() + "] \u2026 [" + this.$originalUnit.getRange() + ']', null), this);
                            if (v2 == var15_3) {
                                return var15_3;
                            }
                            ** GOTO lbl59
                            {
                                case 3: {
                                    ResultKt.throwOnFailure($result);
                                    v2 = $result;
                                    ** GOTO lbl59
                                }
                            }
                        }
                        if (this.$betterUnit.getRangedStrength() != this.$originalUnit.getRangedStrength()) {
                            this.L$0 = $this$sequence;
                            this.label = 4;
                            v3 = $this$sequence.yield(TuplesKt.to("\u2021 {[" + this.$betterUnit.getRangedStrength() + "] vs [" + this.$originalUnit.getRangedStrength() + "]}", null), this);
                            if (v3 == var15_3) {
                                return var15_3;
                            }
                        }
                        ** GOTO lbl49
                        {
                            case 4: {
                                ResultKt.throwOnFailure($result);
                                v3 = $result;
lbl49:
                                // 2 sources

                                if (this.$betterUnit.getRange() != this.$originalUnit.getRange()) {
                                    this.L$0 = $this$sequence;
                                    this.label = 5;
                                    v4 = $this$sequence.yield(TuplesKt.to("\u2026 {[" + this.$betterUnit.getRange() + "] vs [" + this.$originalUnit.getRange() + "]}", null), this);
                                    if (v4 == var15_3) {
                                        return var15_3;
                                    }
                                }
                                ** GOTO lbl59
                            }
                            case 5: {
                                ResultKt.throwOnFailure($result);
                                v4 = $result;
lbl59:
                                // 6 sources

                                if (this.$betterUnit.getMovement() != this.$originalUnit.getMovement()) {
                                    this.L$0 = $this$sequence;
                                    this.label = 6;
                                    v5 = $this$sequence.yield(TuplesKt.to("\u27a1 {[" + this.$betterUnit.getMovement() + "] vs [" + this.$originalUnit.getMovement() + "]}", null), this);
                                    if (v5 == var15_3) {
                                        return var15_3;
                                    }
                                }
                                ** GOTO lbl69
                            }
                            case 6: {
                                ResultKt.throwOnFailure($result);
                                v5 = $result;
lbl69:
                                // 2 sources

                                var3_4 = this.$originalUnit.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).keySet().iterator();
lbl70:
                                // 4 sources

                                while (var3_4.hasNext()) {
                                    Intrinsics.checkNotNullExpressionValue(var3_4.next(), "next(...)");
                                    if (this.$betterUnit.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).containsKey(resource)) continue;
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var3_4;
                                    this.L$2 = SpillingKt.nullOutSpilledVariable(resource);
                                    this.label = 7;
                                    v6 = $this$sequence.yield(TuplesKt.to('[' + resource + "] not required", "Resource/" + resource), this);
                                    if (v6 != var15_3) continue;
                                    return var15_3;
                                }
                                break;
                            }
                            case 7: {
                                resource = (String)this.L$2;
                                var3_4 = (Iterator<String>)this.L$1;
                                ResultKt.throwOnFailure($result);
                                v6 = $result;
                                ** GOTO lbl70
                            }
                        }
                        if (!(((CharSequence)this.$betterUnit.getReplacementTextForUniques()).length() > 0)) break block33;
                        this.L$0 = $this$sequence;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 8;
                        v7 = $this$sequence.yield(TuplesKt.to(this.$betterUnit.getReplacementTextForUniques(), null), this);
                        if (v7 == var15_3) {
                            return var15_3;
                        }
                        break block34;
                        {
                            case 8: {
                                ResultKt.throwOnFailure($result);
                                v7 = $result;
                                break;
                            }
                        }
                    }
                    newAbilityPredicate = (Function1<Unique, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.unciv.models.ruleset.unit.BaseUnit com.unciv.models.ruleset.unique.Unique ), (Lcom/unciv/models/ruleset/unique/Unique;)Ljava/lang/Boolean;)((BaseUnit)this.$originalUnit);
                    $this$filterNot$iv = this.$betterUnit.getUniqueObjects();
                    $i$f$filterNot = false;
                    var7_9 = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        if (newAbilityPredicate.invoke((Unique)element$iv$iv).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    var4_5 = ((List)destination$iv$iv).iterator();
lbl113:
                    // 3 sources

                    while (var4_5.hasNext()) {
                        unique = (Unique)var4_5.next();
                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable(newAbilityPredicate);
                        this.L$2 = var4_5;
                        this.L$3 = SpillingKt.nullOutSpilledVariable(unique);
                        this.label = 9;
                        v8 = $this$sequence.yield(TuplesKt.to(unique.getText(), null), this);
                        if (v8 != var15_3) continue;
                        return var15_3;
                    }
                    {
                        break;
                        case 9: {
                            unique = (Unique)this.L$3;
                            var4_5 = (Iterator<E>)this.L$2;
                            newAbilityPredicate = (Function1<Unique, Boolean>)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v8 = $result;
                            ** GOTO lbl113
                        }
                    }
                }
                lostAbilityPredicate = (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(com.unciv.models.ruleset.unit.BaseUnit com.unciv.models.ruleset.unique.Unique ), (Lcom/unciv/models/ruleset/unique/Unique;)Ljava/lang/Boolean;)((BaseUnit)this.$betterUnit);
                $this$filterNot$iv = this.$originalUnit.getUniqueObjects();
                $i$f$filterNot = false;
                $this$filterNotTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    if (((Boolean)lostAbilityPredicate.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var4_5 = ((List)destination$iv$iv).iterator();
lbl144:
                // 3 sources

                while (var4_5.hasNext()) {
                    unique = (Unique)var4_5.next();
                    this.L$0 = $this$sequence;
                    this.L$1 = SpillingKt.nullOutSpilledVariable(lostAbilityPredicate);
                    this.L$2 = var4_5;
                    this.L$3 = SpillingKt.nullOutSpilledVariable(unique);
                    this.label = 10;
                    v9 = $this$sequence.yield(TuplesKt.to("Lost ability (vs [" + this.$originalUnit.getName() + "]): [" + TranslationsKt.tr$default(unique.getDisplayText(), false, false, 3, null) + ']', null), this);
                    if (v9 != var15_3) continue;
                    return var15_3;
                }
                {
                    break;
                    case 10: {
                        unique = (Unique)this.L$3;
                        var4_5 = (Iterator)this.L$2;
                        lostAbilityPredicate = (Function1)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v9 = $result;
                        ** GOTO lbl144
                    }
                }
                unique = this.$betterUnit.getPromotions();
                $i$f$filterNot = this.$originalUnit;
                $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-filter-BaseUnitDescriptions$getDifferences$1$1 = false;
                    if (!($i$f$filterNot.getPromotions().contains(it) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var4_5 = ((List)destination$iv$iv).iterator();
lbl176:
                // 3 sources

                while (var4_5.hasNext()) {
                    promotionName = (String)var4_5.next();
                    Intrinsics.checkNotNull(this.$ruleset.getUnitPromotions().get(promotionName));
                    effects = CollectionsKt.joinToString$default(DescriptionHelpersKt.uniquesToDescription$default(promotion, null, null, 3, null), null, null, null, 0, null, null, 63, null);
                    this.L$0 = $this$sequence;
                    this.L$1 = SpillingKt.nullOutSpilledVariable(lostAbilityPredicate);
                    this.L$2 = var4_5;
                    this.L$3 = SpillingKt.nullOutSpilledVariable(promotionName);
                    this.L$4 = SpillingKt.nullOutSpilledVariable(promotion);
                    this.L$5 = SpillingKt.nullOutSpilledVariable(effects);
                    this.label = 11;
                    v10 = $this$sequence.yield(TuplesKt.to('{' + promotionName + "} (" + effects + ')', promotion.makeLink()), this);
                    if (v10 != var15_3) continue;
                    return var15_3;
                }
                {
                    break;
                    case 11: {
                        effects = (String)this.L$5;
                        promotion = (Promotion)this.L$4;
                        promotionName = (String)this.L$3;
                        var4_5 = (Iterator)this.L$2;
                        lostAbilityPredicate = (Function1)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v10 = $result;
                        ** GOTO lbl176
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Pair<? extends String, ? extends String>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Pair<String, String>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(BaseUnit $originalUnit, Unique it) {
                return $originalUnit.getUniques().contains(it.getText()) || it.isHiddenToUsers();
            }

            private static final boolean invokeSuspend$lambda$1(BaseUnit $betterUnit, Unique it) {
                return $betterUnit.getUniques().contains(it.getText()) || it.isHiddenToUsers();
            }
        });
    }

    @NotNull
    public final Table getUpgradeInfoTable(@NotNull String title, @NotNull BaseUnit unitUpgrading, @NotNull BaseUnit unitToUpgradeTo) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(unitUpgrading, "unitUpgrading");
        Intrinsics.checkNotNullParameter(unitToUpgradeTo, "unitToUpgradeTo");
        Ruleset ruleset = unitToUpgradeTo.getRuleset();
        String string = unitToUpgradeTo.makeLink();
        Sequence<FormattedLine> info = SequencesKt.plus(SequencesKt.sequenceOf(new FormattedLine(title, null, string, null, 0.0f, 0, 5, 0, 0.0f, "#FDA", false, false, false, false, 15802, null)), SequencesKt.map(this.getDifferences(ruleset, unitUpgrading, unitToUpgradeTo), BaseUnitDescriptions::getUpgradeInfoTable$lambda$0));
        return MarkupRenderer.render$default(MarkupRenderer.INSTANCE, SequencesKt.asIterable(info), 400.0f, 0.0f, null, null, 28, null);
    }

    private static final boolean getShortDescription$lambda$0(Unique unique) {
        Intrinsics.checkNotNullParameter(unique, "<this>");
        return false;
    }

    private static final boolean getDescription$lambda$0(Unique $this$uniquesToDescription) {
        Intrinsics.checkNotNullParameter($this$uniquesToDescription, "$this$uniquesToDescription");
        return $this$uniquesToDescription.getType() == UniqueType.Unbuildable || $this$uniquesToDescription.getType() == UniqueType.ConsumesResources || $this$uniquesToDescription.getType() == UniqueType.CostsResources;
    }

    private static final CharSequence getDescription$lambda$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }

    @Readonly
    private static final Sequence<FormattedLine> getUnitTypeCivilopediaTextLines$getDomainLines(UnitType $this_getUnitTypeCivilopediaTextLines, Ruleset $ruleset) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>($this_getUnitTypeCivilopediaTextLines, $ruleset, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UnitType $this_getUnitTypeCivilopediaTextLines;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$this_getUnitTypeCivilopediaTextLines = $receiver;
                this.$ruleset = $ruleset;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield(new FormattedLine("{Unit types}:", null, null, null, 0.0f, 0, 4, 0, 0.0f, null, false, false, false, false, 16318, null), this);
                        if (v0 == var6_3) {
                            return var6_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        myMovementType = this.$this_getUnitTypeCivilopediaTextLines.getMovementType();
                        var4_5 = this.$ruleset.getUnitTypes().values().iterator();
lbl17:
                        // 4 sources

                        while (var4_5.hasNext()) {
                            Intrinsics.checkNotNullExpressionValue(var4_5.next(), "next(...)");
                            if (unitType.getMovementType() != myMovementType || !unitType.isUsed(this.$ruleset)) continue;
                            this.L$0 = $this$sequence;
                            this.L$1 = myMovementType;
                            this.L$2 = var4_5;
                            this.L$3 = SpillingKt.nullOutSpilledVariable(unitType);
                            this.label = 2;
                            v1 = $this$sequence.yield(new FormattedLine(unitType.getName(), unitType.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null), this);
                            if (v1 != var6_3) continue;
                            return var6_3;
                        }
                        break;
                    }
                    case 2: {
                        unitType = (UnitType)this.L$3;
                        var4_5 = (Iterator<UnitType>)this.L$2;
                        myMovementType = (UnitMovementType)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        ** GOTO lbl17
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super FormattedLine> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final Sequence<FormattedLine> getUnitTypeCivilopediaTextLines$getUnitTypeLines(UnitType $this_getUnitTypeCivilopediaTextLines, Ruleset $ruleset) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>($this_getUnitTypeCivilopediaTextLines, $ruleset, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UnitType $this_getUnitTypeCivilopediaTextLines;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$this_getUnitTypeCivilopediaTextLines = $receiver;
                this.$ruleset = $ruleset;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block24: {
                    var2_2 = (SequenceScope)this.L$0;
                    var14_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            v0 = this.$this_getUnitTypeCivilopediaTextLines.getMovementType();
                            if (v0 == null) break;
                            it = v0;
                            $i$a$-let-BaseUnitDescriptions$getUnitTypeCivilopediaTextLines$getUnitTypeLines$1$1 = 0;
                            switch (getUnitTypeCivilopediaTextLines.getUnitTypeLines.WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                                case 1: {
                                    v1 = "#ffc080";
                                    break;
                                }
                                case 2: {
                                    v1 = "#80d0ff";
                                    break;
                                }
                                case 3: {
                                    v1 = "#e0e0ff";
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            color = v1;
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable(it);
                            this.L$2 = SpillingKt.nullOutSpilledVariable(color);
                            this.I$0 = $i$a$-let-BaseUnitDescriptions$getUnitTypeCivilopediaTextLines$getUnitTypeLines$1$1;
                            this.label = 1;
                            v2 = $this$sequence.yield(new FormattedLine("Domain: [" + it.name() + ']', "UnitType/Domain: [" + it.name() + ']', null, null, 0.0f, 0, 0, 0, 0.0f, color, false, false, false, false, 15868, null), this);
                            if (v2 == var14_3) {
                                return var14_3;
                            }
                            ** GOTO lbl38
                        }
                        case 1: {
                            $i$a$-let-BaseUnitDescriptions$getUnitTypeCivilopediaTextLines$getUnitTypeLines$1$1 = this.I$0;
                            color = (String)this.L$2;
                            it = (UnitMovementType)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl38:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable(it);
                            this.L$2 = SpillingKt.nullOutSpilledVariable(color);
                            this.I$0 = $i$a$-let-BaseUnitDescriptions$getUnitTypeCivilopediaTextLines$getUnitTypeLines$1$1;
                            this.label = 2;
                            v3 = $this$sequence.yield(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, true, false, false, false, 15359, null), this);
                            if (v3 == var14_3) {
                                return var14_3;
                            }
                            break;
                        }
                        case 2: {
                            $i$a$-let-BaseUnitDescriptions$getUnitTypeCivilopediaTextLines$getUnitTypeLines$1$1 = this.I$0;
                            color = (String)this.L$2;
                            it = (UnitMovementType)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
                            break;
                        }
                    }
                    this.L$0 = $this$sequence;
                    this.L$1 = null;
                    this.L$2 = null;
                    this.label = 3;
                    v4 = $this$sequence.yield(new FormattedLine("Units:", null, null, null, 0.0f, 0, 4, 0, 0.0f, null, false, false, false, false, 16318, null), this);
                    if (v4 == var14_3) {
                        return var14_3;
                    }
                    ** GOTO lbl67
                    {
                        case 3: {
                            ResultKt.throwOnFailure($result);
                            v4 = $result;
lbl67:
                            // 2 sources

                            var3_8 = this.$ruleset.getUnits().values().iterator();
lbl68:
                            // 4 sources

                            while (var3_8.hasNext()) {
                                Intrinsics.checkNotNullExpressionValue(var3_8.next(), "next(...)");
                                if (!Intrinsics.areEqual(unit.getUnitType(), this.$this_getUnitTypeCivilopediaTextLines.getName())) continue;
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_8;
                                this.L$2 = SpillingKt.nullOutSpilledVariable(unit);
                                this.label = 4;
                                v5 = $this$sequence.yield(new FormattedLine(unit.getName(), unit.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null), this);
                                if (v5 != var14_3) continue;
                                return var14_3;
                            }
                            break;
                        }
                        case 4: {
                            unit = (BaseUnit)this.L$2;
                            var3_8 = (Iterator<BaseUnit>)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v5 = $result;
                            ** GOTO lbl68
                        }
                    }
                    v6 = this.$ruleset.getUnitPromotions().values();
                    Intrinsics.checkNotNullExpressionValue(v6, "<get-values>(...)");
                    unit = v6;
                    it = this.$this_getUnitTypeCivilopediaTextLines;
                    $i$f$filter = false;
                    var7_11 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Promotion)element$iv$iv;
                        $i$a$-filter-BaseUnitDescriptions$getUnitTypeCivilopediaTextLines$getUnitTypeLines$1$relevantPromotions$1 = false;
                        if (!it.getUnitTypes().contains(it.getName())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    relevantPromotions = (List)destination$iv$iv;
                    if (!(((Collection)relevantPromotions).isEmpty() == false)) break block24;
                    this.L$0 = $this$sequence;
                    this.L$1 = relevantPromotions;
                    this.L$2 = null;
                    this.label = 5;
                    v7 = $this$sequence.yield(new FormattedLine("Promotions", null, null, null, 0.0f, 0, 4, 0, 0.0f, null, false, false, false, false, 16318, null), this);
                    if (v7 == var14_3) {
                        return var14_3;
                    }
                    ** GOTO lbl114
                    {
                        case 5: {
                            relevantPromotions = (List)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v7 = $result;
lbl114:
                            // 2 sources

                            var4_10 = relevantPromotions.iterator();
lbl115:
                            // 3 sources

                            while (var4_10.hasNext()) {
                                promotion = (Promotion)var4_10.next();
                                this.L$0 = $this$sequence;
                                this.L$1 = SpillingKt.nullOutSpilledVariable(relevantPromotions);
                                this.L$2 = var4_10;
                                this.L$3 = SpillingKt.nullOutSpilledVariable(promotion);
                                this.label = 6;
                                v8 = $this$sequence.yield(new FormattedLine(promotion.getName(), promotion.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null), this);
                                if (v8 != var14_3) continue;
                                return var14_3;
                            }
                            break;
                        }
                        case 6: {
                            promotion = (Promotion)this.L$3;
                            var4_10 = (Iterator<E>)this.L$2;
                            relevantPromotions = (List)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v8 = $result;
                            ** GOTO lbl115
                        }
                    }
                }
                this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                this.L$1 = SpillingKt.nullOutSpilledVariable(relevantPromotions);
                this.L$2 = null;
                this.L$3 = null;
                this.label = 7;
                v9 = $this$sequence.yieldAll(DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(this.$this_getUnitTypeCivilopediaTextLines, new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>(null){
                    int label;
                    private /* synthetic */ Object L$0;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        SequenceScope sequenceScope = (SequenceScope)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$uniquesToCivilopediaTextLines;
                                ResultKt.throwOnFailure($result);
                                this.L$0 = SpillingKt.nullOutSpilledVariable($this$uniquesToCivilopediaTextLines);
                                this.label = 1;
                                Object object2 = $this$uniquesToCivilopediaTextLines.yield(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, true, false, false, false, 15359, null), this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure($result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)((Object)function2);
                    }

                    public final Object invoke(SequenceScope<? super FormattedLine> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, false, null, 6, null), (Continuation<? super Unit>)this);
                if (v9 == var14_3) {
                    return var14_3;
                }
                ** GOTO lbl147
                {
                    case 7: {
                        relevantPromotions = (List)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v9 = $result;
lbl147:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super FormattedLine> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final FormattedLine getUpgradeInfoTable$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = (String)it.getFirst();
        String string2 = (String)it.getSecond();
        if (string2 == null) {
            string2 = "";
        }
        return new FormattedLine(string, null, string2, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16378, null);
    }
}

