/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.options.AboutTabKt;
import com.unciv.ui.popups.options.AdvancedTab;
import com.unciv.ui.popups.options.AutomationTab;
import com.unciv.ui.popups.options.DebugTab;
import com.unciv.ui.popups.options.DisplayTab;
import com.unciv.ui.popups.options.GameplayTab;
import com.unciv.ui.popups.options.KeyBindingsTab;
import com.unciv.ui.popups.options.LanguageTab;
import com.unciv.ui.popups.options.ModCheckTab;
import com.unciv.ui.popups.options.MultiplayerTab;
import com.unciv.ui.popups.options.OptionsPopupHelpers;
import com.unciv.ui.popups.options.SoundTab;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\bH\u0016JM\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\b2\b\b\u0002\u0010*\u001a\u00020\b2\b\b\u0002\u0010+\u001a\u00020\b2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0-H\u0000\u00a2\u0006\u0002\b.JK\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\b002\b\b\u0002\u0010*\u001a\u00020\b2\u0014\b\u0002\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0-H\u0000\u00a2\u0006\u0002\b.R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/unciv/ui/popups/options/OptionsPopup;", "Lcom/unciv/ui/popups/Popup;", "Lcom/unciv/ui/popups/options/OptionsPopupHelpers;", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "selectPage", "", "withDebug", "", "onClose", "Lkotlin/Function0;", "", "<init>", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;IZLkotlin/jvm/functions/Function0;)V", "game", "Lcom/unciv/UncivGame;", "getGame", "()Lcom/unciv/UncivGame;", "settings", "Lcom/unciv/models/metadata/GameSettings;", "getSettings", "()Lcom/unciv/models/metadata/GameSettings;", "tabs", "Lcom/unciv/ui/components/widgets/TabbedPager;", "getTabs", "()Lcom/unciv/ui/components/widgets/TabbedPager;", "activePage", "getActivePage", "()I", "rightWidgetMinWidth", "", "getRightWidgetMinWidth", "()F", "tabMinWidth", "setVisible", "visible", "addCheckbox", "table", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "text", "", "initialState", "updateWorld", "newRow", "action", "Lkotlin/Function1;", "addCheckbox$core", "settingsProperty", "Lkotlin/reflect/KMutableProperty0;", "Companion", "core"})
public final class OptionsPopup
extends Popup
implements OptionsPopupHelpers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int selectPage;
    @NotNull
    private final Function0<Unit> onClose;
    @NotNull
    private final UncivGame game;
    @NotNull
    private final GameSettings settings;
    @NotNull
    private final TabbedPager tabs;
    private final float rightWidgetMinWidth;
    private final float tabMinWidth;
    public static final int defaultPage = 2;

    public OptionsPopup(@NotNull BaseScreen screen, int selectPage, boolean withDebug, @NotNull Function0<Unit> onClose) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(screen, "screen");
                Intrinsics.checkNotNullParameter(onClose, "onClose");
                super(screen.getStage(), Popup.Scrollability.None, 0.0f, 4, null);
                this.selectPage = selectPage;
                this.onClose = onClose;
                this.game = screen.getGame();
                this.settings = screen.getGame().getSettings();
                this.setClickBehindToClose(true);
                if (this.settings.addCompletedTutorialTask("Open the options table")) {
                    WorldScreen worldScreen = screen instanceof WorldScreen ? (WorldScreen)screen : null;
                    if (worldScreen != null) {
                        worldScreen.setShouldUpdate(true);
                    }
                }
                this.getInnerTable().pad(0.0f);
                float tabMaxWidth = 0.0f;
                float tabMaxHeight = 0.0f;
                BaseScreen $this$_init__u24lambda_u241 = screen;
                boolean bl = false;
                this.rightWidgetMinWidth = $this$_init__u24lambda_u241.getStage().getWidth() < 600.0f ? 200.0f : 240.0f;
                tabMaxWidth = $this$_init__u24lambda_u241.isPortrait() ? $this$_init__u24lambda_u241.getStage().getWidth() - 10.0f : 0.8f * $this$_init__u24lambda_u241.getStage().getWidth();
                this.tabMinWidth = 0.6f * $this$_init__u24lambda_u241.getStage().getWidth();
                tabMaxHeight = 0.8f * $this$_init__u24lambda_u241.getStage().getHeight();
                Color color = Color.CLEAR;
                Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
                this.tabs = new TabbedPager(this.tabMinWidth, tabMaxWidth, tabMaxHeight, tabMaxHeight, 21, null, null, color, 0.0f, null, null, 8, 1888, null);
                this.add((Actor)this.tabs).pad(0.0f).grow().row();
                TabbedPager.addPage$default(this.tabs, "About", AboutTabKt.aboutTab(), ImageGetter.INSTANCE.getExternalImage("Icons/Unciv128.png"), 24.0f, 0, false, false, null, 0, false, 1008, null);
                TabbedPager.addPage$default(this.tabs, "Display", new DisplayTab(this), ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitPromotionIcons/Scouting", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                TabbedPager.addPage$default(this.tabs, "Gameplay", new GameplayTab(this), ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Options", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                TabbedPager.addPage$default(this.tabs, "Automation", new AutomationTab(this), ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/NationSwap", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                TabbedPager.addPage$default(this.tabs, "Language", new LanguageTab(this), ImageGetter.getImage$default(ImageGetter.INSTANCE, "FlagIcons/" + this.settings.getLanguage(), null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                TabbedPager.addPage$default(this.tabs, "Sound", new SoundTab(this), ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Speaker", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                TabbedPager.addPage$default(this.tabs, "Multiplayer", new MultiplayerTab(this), ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Multiplayer", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                if (GUI.INSTANCE.getKeyboardAvailable()) {
                    TabbedPager.addPage$default(this.tabs, "Keys", new KeyBindingsTab(this, this.tabMinWidth - 40.0f), ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Keyboard", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                }
                TabbedPager.addPage$default(this.tabs, "Advanced", new AdvancedTab(this), ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Settings", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                if (RulesetCache.INSTANCE.size() > BaseRuleset.getEntries().size()) {
                    ModCheckTab content2 = new ModCheckTab(screen);
                    TabbedPager.addPage$default(this.tabs, "Locate mod errors", content2, ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Mods", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
                }
                if (withDebug) break block7;
                Input input2 = Gdx.input;
                Intrinsics.checkNotNullExpressionValue(input2, "input");
                if (!Scene2dExtensionsKt.areSecretKeysPressed(input2)) break block8;
            }
            TabbedPager.addPage$default(this.tabs, "Debug", new DebugTab(this), ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/SecretOptions", null, 2, null), 24.0f, 0, false, false, null, 0, false, 1008, null);
        }
        TabbedPager.decorateHeader$default(this.tabs, Scene2dExtensionsKt.getCloseButton$default(0.0f, 0.0f, null, null, () -> OptionsPopup._init_$lambda$2(screen, this), 15, null), false, false, 6, null);
        this.pack();
        Scene2dExtensionsKt.center((Actor)this, screen.getStage());
    }

    public /* synthetic */ OptionsPopup(BaseScreen baseScreen, int n, boolean bl, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            function0 = OptionsPopup::_init_$lambda$0;
        }
        this(baseScreen, n, bl, function0);
    }

    @NotNull
    public final UncivGame getGame() {
        return this.game;
    }

    @NotNull
    public final GameSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final TabbedPager getTabs() {
        return this.tabs;
    }

    @Override
    public int getActivePage() {
        return this.tabs.getActivePage();
    }

    @Override
    public float getRightWidgetMinWidth() {
        return this.rightWidgetMinWidth;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        if (this.tabs.getActivePage() < 0) {
            TabbedPager.selectPage$default(this.tabs, this.selectPage, false, 2, null);
        }
    }

    public final void addCheckbox$core(@NotNull Table table2, @NotNull String text2, boolean initialState, boolean updateWorld, boolean newRow, @NotNull Function1<? super Boolean, Unit> action2) {
        Intrinsics.checkNotNullParameter(table2, "table");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(action2, "action");
        CheckBox checkbox = Scene2dExtensionsKt.toCheckBox(text2, initialState, arg_0 -> OptionsPopup.addCheckbox$lambda$0(action2, updateWorld, arg_0));
        if (newRow) {
            table2.add((Actor)checkbox).colspan(2).left().row();
        } else {
            table2.add((Actor)checkbox).left();
        }
    }

    public static /* synthetic */ void addCheckbox$core$default(OptionsPopup optionsPopup, Table table2, String string, boolean bl, boolean bl2, boolean bl3, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        optionsPopup.addCheckbox$core(table2, string, bl, bl2, bl3, function1);
    }

    public final void addCheckbox$core(@NotNull Table table2, @NotNull String text2, @NotNull KMutableProperty0<Boolean> settingsProperty, boolean updateWorld, @NotNull Function1<? super Boolean, Unit> action2) {
        Intrinsics.checkNotNullParameter(table2, "table");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(settingsProperty, "settingsProperty");
        Intrinsics.checkNotNullParameter(action2, "action");
        OptionsPopup.addCheckbox$core$default(this, table2, text2, (Boolean)settingsProperty.get(), updateWorld, false, arg_0 -> OptionsPopup.addCheckbox$lambda$2(action2, settingsProperty, arg_0), 16, null);
    }

    public static /* synthetic */ void addCheckbox$core$default(OptionsPopup optionsPopup, Table table2, String string, KMutableProperty0 kMutableProperty0, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function1 = OptionsPopup::addCheckbox$lambda$1;
        }
        optionsPopup.addCheckbox$core(table2, string, kMutableProperty0, bl, function1);
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(BaseScreen $screen, OptionsPopup this$0) {
        $screen.getGame().getMusicController().onChange(null);
        Scene2dExtensionsKt.center((Actor)this$0, $screen.getStage());
        this$0.tabs.selectPage(-1, false);
        this$0.settings.save();
        this$0.onClose.invoke();
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit addCheckbox$lambda$0(Function1 $action, boolean $updateWorld, boolean it) {
        $action.invoke(it);
        WorldScreen worldScreen = GUI.INSTANCE.getWorldScreenIfActive();
        if ($updateWorld && worldScreen != null) {
            worldScreen.setShouldUpdate(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addCheckbox$lambda$1(boolean it) {
        return Unit.INSTANCE;
    }

    private static final Unit addCheckbox$lambda$2(Function1 $action, KMutableProperty0 $settingsProperty, boolean it) {
        $action.invoke(it);
        $settingsProperty.set(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/popups/options/OptionsPopup$Companion;", "", "<init>", "()V", "defaultPage", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

