/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import com.unciv.ui.screens.overviewscreen.GlobalPoliticsDiagramGroup;
import com.unciv.ui.screens.overviewscreen.WonderInfo;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u00012B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0003H\u0003J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\b\u0010'\u001a\u00020\u001bH\u0002J\f\u0010(\u001a\u00020\u0017*\u00020\u0003H\u0003J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0014\u0010.\u001a\u00020\u001b*\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0002J*\u0010/\u001a\u00020\u001b*\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u00020\u00152\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "persistedData", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;)V", "persistableData", "Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "getPersistableData", "()Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "fixedContent", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "civTable", "undefeatedCivs", "", "defeatedCivs", "relevantCivsCount", "", "showDiplomacyGroup", "", "portraitMode", "getFixedContent", "updatePoliticsTable", "", "createGlobalPoliticsHeader", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "createGlobalPoliticsTable", "getCivInfoTable", "civ", "getPoliciesTable", "getWondersOfCivTable", "getCivName", "otherciv", "getPoliticsOfCivTable", "updateDiagram", "hideCityStateCount", "updateCivTable", "columns", "", "getCivMiniTable", "civInfo", "addTitleInfo", "addCivsCategory", "aliveOrDefeated", "civs", "DiplomacyTabPersistableData", "core"})
@SourceDebugExtension(value={"SMAP\nGlobalPoliticsOverviewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,399:1\n1788#2,4:400\n1788#2,4:404\n1761#2,3:408\n774#2:414\n865#2,2:415\n1276#3,3:411\n*S KotlinDebug\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable\n*L\n154#1:400,4\n280#1:404,4\n291#1:408,3\n337#1:414\n337#1:415,2\n328#1:411,3\n*E\n"})
public final class GlobalPoliticsOverviewTable
extends EmpireOverviewTab {
    @NotNull
    private final DiplomacyTabPersistableData persistableData;
    @NotNull
    private final Table fixedContent;
    @NotNull
    private final Table civTable;
    @NotNull
    private List<Civilization> undefeatedCivs;
    @NotNull
    private List<Civilization> defeatedCivs;
    @NotNull
    private String relevantCivsCount;
    private boolean showDiplomacyGroup;
    private boolean portraitMode;

    /*
     * WARNING - void declaration
     */
    public GlobalPoliticsOverviewTable(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen, @Nullable EmpireOverviewTab.EmpireOverviewTabPersistableData persistedData) {
        void $this$civTable_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        DiplomacyTabPersistableData diplomacyTabPersistableData = persistedData instanceof DiplomacyTabPersistableData ? (DiplomacyTabPersistableData)persistedData : null;
        if (diplomacyTabPersistableData == null) {
            diplomacyTabPersistableData = new DiplomacyTabPersistableData(false, false, 3, null);
        }
        this.persistableData = diplomacyTabPersistableData;
        this.fixedContent = new Table();
        Table table3 = table2 = new Table();
        GlobalPoliticsOverviewTable globalPoliticsOverviewTable = this;
        boolean bl = false;
        $this$civTable_u24lambda_u240.defaults().pad(5.0f);
        $this$civTable_u24lambda_u240.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/DiplomacyOverviewTab/CivTable", null, ImageGetter.INSTANCE.getCHARCOAL(), 2, null));
        globalPoliticsOverviewTable.civTable = table2;
        this.undefeatedCivs = CollectionsKt.emptyList();
        this.defeatedCivs = CollectionsKt.emptyList();
        this.relevantCivsCount = "?";
        this.top();
        if (this.getPersistableData().getShowDiagram()) {
            this.updateDiagram();
        } else {
            this.updatePoliticsTable();
        }
    }

    public /* synthetic */ GlobalPoliticsOverviewTable(Civilization civilization, EmpireOverviewScreen empireOverviewScreen, EmpireOverviewTab.EmpireOverviewTabPersistableData empireOverviewTabPersistableData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            empireOverviewTabPersistableData = null;
        }
        this(civilization, empireOverviewScreen, empireOverviewTabPersistableData);
    }

    @Override
    @NotNull
    public DiplomacyTabPersistableData getPersistableData() {
        return this.persistableData;
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.fixedContent;
    }

    private final void updatePoliticsTable() {
        this.getPersistableData().setShowDiagram(false);
        this.createGlobalPoliticsHeader();
        this.createGlobalPoliticsTable();
        Table[] tableArray = new Table[]{this.fixedContent, this};
        Scene2dExtensionsKt.equalizeColumns(tableArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Cell<Image> createGlobalPoliticsHeader() {
        void $this$createGlobalPoliticsHeader_u24lambda_u240_u240;
        Table table2;
        Table $this$createGlobalPoliticsHeader_u24lambda_u240 = this.fixedContent;
        boolean bl = false;
        Actor diagramButton2 = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Show diagram", null, false, 3, null), new Function0<Unit>((Object)this){

            public final void invoke() {
                GlobalPoliticsOverviewTable.access$updateDiagram((GlobalPoliticsOverviewTable)this.receiver);
            }
        });
        $this$createGlobalPoliticsHeader_u24lambda_u240.clear();
        $this$createGlobalPoliticsHeader_u24lambda_u240.add();
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u240, color, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("Civilization Info"));
        Color color2 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u240, color2, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("Social policies"));
        Color color3 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u240, color3, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("Wonders"));
        Color color4 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u240, color4, 0.0f, 2, null);
        Table table3 = table2 = new Table();
        Table table4 = $this$createGlobalPoliticsHeader_u24lambda_u240;
        boolean bl2 = false;
        $this$createGlobalPoliticsHeader_u24lambda_u240_u240.add((Actor)Scene2dExtensionsKt.toLabel("Relations")).padTop(10.0f).row();
        $this$createGlobalPoliticsHeader_u24lambda_u240_u240.add(diagramButton2).pad(10.0f);
        table4.add((Actor)table2);
        Color color5 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color5, "GRAY");
        return Scene2dExtensionsKt.addSeparator$default($this$createGlobalPoliticsHeader_u24lambda_u240, color5, 0, 0.0f, 6, null);
    }

    private final void createGlobalPoliticsTable() {
        this.clear();
        Iterator<Civilization> iterator2 = SequencesKt.plus(SequencesKt.sequenceOf(this.getViewingPlayer()), DiplomacyFunctions.getKnownCivsSorted$default(this.getViewingPlayer().getDiplomacyFunctions(), false, false, 2, null)).iterator();
        while (iterator2.hasNext()) {
            Civilization civ = iterator2.next();
            if (this.getCells().size > 0) {
                Table table2 = this;
                Color color = Color.GRAY;
                Intrinsics.checkNotNullExpressionValue(color, "GRAY");
                Scene2dExtensionsKt.addSeparator$default(table2, color, 0, 0.0f, 6, null);
            }
            this.add((Actor)ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 100.0f)).pad(20.0f);
            Table table3 = this;
            Color color = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table3, color, 0.0f, 2, null);
            this.add((Actor)this.getCivInfoTable(civ)).pad(20.0f);
            Table table4 = this;
            Color color2 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table4, color2, 0.0f, 2, null);
            this.add((Actor)this.getPoliciesTable(civ)).pad(20.0f);
            Table table5 = this;
            Color color3 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table5, color3, 0.0f, 2, null);
            this.add((Actor)this.getWondersOfCivTable(civ)).pad(20.0f);
            Table table6 = this;
            Color color4 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table6, color4, 0.0f, 2, null);
            this.add((Actor)this.getPoliticsOfCivTable(civ)).pad(20.0f);
        }
    }

    private final Table getCivInfoTable(Civilization civ) {
        Table civInfoTable = new Table(this.getSkin());
        String leaderName = civ.getNation().getLeaderName();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel$default(leaderName, null, 30, 0, false, 13, null)).row();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel$default(civ.getCivName(), null, 0, 0, true, 7, null)).row();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel(civ.getTech().getEra().getName())).row();
        return civInfoTable;
    }

    /*
     * WARNING - void declaration
     */
    private final Table getPoliciesTable(Civilization civ) {
        Table policiesTable = new Table(this.getSkin());
        for (PolicyBranch branch : civ.getPolicies().getBranches()) {
            int n;
            void $this$count$iv;
            if (!civ.getPolicies().isAdopted(branch.getName())) continue;
            Iterable iterable = branch.getPolicies();
            int n2 = 1;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl = false;
                    if (!(it.getPolicyBranchType() != Policy.PolicyBranchType.BranchComplete && civ.getPolicies().isAdopted(it.getName())) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n3 = n;
            int count2 = n2 + n3;
            policiesTable.add((Actor)Scene2dExtensionsKt.toLabel('[' + branch.getName() + "]: " + count2)).row();
        }
        return policiesTable;
    }

    private final Table getWondersOfCivTable(Civilization civ) {
        Table wonderTable = new Table(this.getSkin());
        WonderInfo wonderInfo = new WonderInfo();
        for (WonderInfo.WonderInfo wonder : wonderInfo.collectInfo(this.getViewingPlayer())) {
            if (!Intrinsics.areEqual(wonder.getCiv(), civ)) continue;
            Label wonderName = Scene2dExtensionsKt.toLabel(wonder.getName());
            if (wonder.getLocation() != null) {
                ActivationExtensionsKt.onClick(wonderName, () -> GlobalPoliticsOverviewTable.getWondersOfCivTable$lambda$0(wonder));
            }
            wonderTable.add((Actor)wonderName).left().row();
        }
        return wonderTable;
    }

    @Readonly
    private final String getCivName(Civilization otherciv) {
        if (this.getViewingPlayer().knows(otherciv) || Intrinsics.areEqual(otherciv, this.getViewingPlayer())) {
            return otherciv.getCivName();
        }
        return "an unknown civilization";
    }

    private final Table getPoliticsOfCivTable(Civilization civ) {
        Label turnsLeftText;
        Civilization otherCiv;
        Table politicsTable = new Table(this.getSkin());
        if (!this.getViewingPlayer().knows(civ) && !Intrinsics.areEqual(civ, this.getViewingPlayer())) {
            return politicsTable;
        }
        if (civ.isDefeated()) {
            politicsTable.add((Actor)Scene2dExtensionsKt.toLabel("{Defeated} \u2620"));
            return politicsTable;
        }
        Iterator<Civilization> iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            otherCiv = iterator2.next();
            if (!civ.isAtWarWith(otherCiv)) continue;
            String string = "At war with [" + this.getCivName(otherCiv) + ']';
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            ColorMarkupLabel warText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            politicsTable.add((Actor)warText).row();
        }
        politicsTable.row();
        iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            ColorMarkupLabel friendText;
            otherCiv = iterator2.next();
            DiplomacyManager diplomacyManager = civ.getDiplomacyManager(otherCiv);
            boolean bl = diplomacyManager != null ? diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact) : false;
            if (bl) {
                String string = "Defensive pact with [" + this.getCivName(otherCiv) + ']';
                Color color = Color.CYAN;
                Intrinsics.checkNotNullExpressionValue(color, "CYAN");
                friendText = new ColorMarkupLabel(string, color, null, 0, 12, null);
                DiplomacyManager diplomacyManager2 = civ.getDiplomacyManager(otherCiv);
                turnsLeftText = Scene2dExtensionsKt.toLabel(" (" + (diplomacyManager2 != null ? Integer.valueOf(diplomacyManager2.getFlag(DiplomacyFlags.DefensivePact)) : null) + " \u23f3)");
                politicsTable.add((Actor)friendText);
                politicsTable.add((Actor)turnsLeftText).row();
                continue;
            }
            DiplomacyManager diplomacyManager3 = civ.getDiplomacyManager(otherCiv);
            boolean bl2 = diplomacyManager3 != null ? diplomacyManager3.hasFlag(DiplomacyFlags.DeclarationOfFriendship) : false;
            if (!bl2) continue;
            String string = "Friends with [" + this.getCivName(otherCiv) + ']';
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            friendText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            DiplomacyManager diplomacyManager4 = civ.getDiplomacyManager(otherCiv);
            turnsLeftText = Scene2dExtensionsKt.toLabel(" (" + (diplomacyManager4 != null ? Integer.valueOf(diplomacyManager4.getFlag(DiplomacyFlags.DeclarationOfFriendship)) : null) + " \u23f3)");
            politicsTable.add((Actor)friendText);
            politicsTable.add((Actor)turnsLeftText).row();
        }
        politicsTable.row();
        iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            otherCiv = iterator2.next();
            DiplomacyManager diplomacyManager = civ.getDiplomacyManager(otherCiv);
            boolean bl = diplomacyManager != null ? diplomacyManager.hasFlag(DiplomacyFlags.Denunciation) : false;
            if (!bl) continue;
            String string = "Denounced [" + this.getCivName(otherCiv) + ']';
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            ColorMarkupLabel denouncedText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            DiplomacyManager diplomacyManager5 = civ.getDiplomacyManager(otherCiv);
            turnsLeftText = Scene2dExtensionsKt.toLabel("" + '(' + (diplomacyManager5 != null ? Integer.valueOf(diplomacyManager5.getFlag(DiplomacyFlags.Denunciation)) : null) + " \u23f3)");
            politicsTable.add((Actor)denouncedText);
            politicsTable.add((Actor)turnsLeftText).row();
        }
        politicsTable.row();
        for (Civilization cityState : this.getGameInfo().getAliveCityStates()) {
            DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(civ);
            boolean bl = diplomacyManager != null ? diplomacyManager.isRelationshipLevelEQ(RelationshipLevel.Ally) : false;
            if (!bl) continue;
            String string = "Allied with [" + this.getCivName(cityState) + ']';
            Color color = Color.CYAN;
            Intrinsics.checkNotNullExpressionValue(color, "CYAN");
            ColorMarkupLabel alliedText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            politicsTable.add((Actor)alliedText).row();
        }
        return politicsTable;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDiagram() {
        Table table2;
        int n;
        int n2;
        WidgetGroup floatingTable;
        WidgetGroup civTableScroll;
        TextButton toggleCityStatesButton;
        block13: {
            void $this$any$iv;
            Iterable $this$count$iv;
            GlobalPoliticsOverviewTable globalPoliticsOverviewTable;
            String string;
            this.getPersistableData().setShowDiagram(true);
            Actor politicsButton = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Show global politics", null, false, 3, null), () -> GlobalPoliticsOverviewTable.updateDiagram$lambda$0(this));
            TextButton textButton = Scene2dExtensionsKt.toTextButton$default("City-States", null, false, 3, null);
            WidgetGroup $this$updateDiagram_u24lambda_u241 = textButton;
            boolean bl = false;
            ActivationExtensionsKt.onClick($this$updateDiagram_u24lambda_u241, () -> GlobalPoliticsOverviewTable.updateDiagram$lambda$1$0(this));
            toggleCityStatesButton = textButton;
            WidgetGroup $this$updateDiagram_u24lambda_u242 = $this$updateDiagram_u24lambda_u241 = new AutoScrollPane((Actor)this.civTable, null, 2, null);
            boolean bl2 = false;
            ((ScrollPane)$this$updateDiagram_u24lambda_u242).setOverscroll(false, false);
            civTableScroll = $this$updateDiagram_u24lambda_u241;
            $this$updateDiagram_u24lambda_u242 = new Table();
            Object $this$updateDiagram_u24lambda_u243 = $this$updateDiagram_u24lambda_u242;
            boolean bl3 = false;
            ((Table)$this$updateDiagram_u24lambda_u243).add((Actor)toggleCityStatesButton).pad(10.0f).row();
            ((Table)$this$updateDiagram_u24lambda_u243).add(politicsButton).row();
            Actor actor = civTableScroll;
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            ((Table)$this$updateDiagram_u24lambda_u243).add((Actor)Scene2dExtensionsKt.addBorder$default(actor, 2.0f, color, false, 4, null)).pad(10.0f);
            floatingTable = $this$updateDiagram_u24lambda_u242;
            boolean hideCivsCount = this.getViewingPlayer().shouldHideCivCount() || this.getPersistableData().getIncludeCityStates() && this.hideCityStateCount(this.getViewingPlayer());
            GlobalPoliticsOverviewTable globalPoliticsOverviewTable2 = this;
            if (hideCivsCount) {
                string = "?";
            } else {
                int n3;
                $this$updateDiagram_u24lambda_u243 = this.getGameInfo().getCivilizations();
                globalPoliticsOverviewTable = globalPoliticsOverviewTable2;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n3 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        Civilization it = (Civilization)element$iv;
                        boolean bl4 = false;
                        if (!(!it.isSpectator() && !it.isBarbarian() && (this.getPersistableData().getIncludeCityStates() || !it.isCityState())) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n3 = count$iv;
                }
                n2 = n3;
                globalPoliticsOverviewTable2 = globalPoliticsOverviewTable;
                string = TranslationsKt.tr(n2);
            }
            globalPoliticsOverviewTable2.relevantCivsCount = string;
            this.undefeatedCivs = CollectionsKt.plus((Collection)CollectionsKt.listOf(this.getViewingPlayer()), DiplomacyFunctions.getKnownCivsSorted$default(this.getViewingPlayer().getDiplomacyFunctions(), this.getPersistableData().getIncludeCityStates(), false, 2, null));
            this.defeatedCivs = SequencesKt.toList(SequencesKt.filter(this.getViewingPlayer().getDiplomacyFunctions().getKnownCivsSorted(this.getPersistableData().getIncludeCityStates(), true), GlobalPoliticsOverviewTable::updateDiagram$lambda$5));
            this.clear();
            this.fixedContent.clear();
            $this$count$iv = this.undefeatedCivs;
            globalPoliticsOverviewTable = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                n = 0;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl5 = false;
                    if (!(!Intrinsics.areEqual(it, this.getViewingPlayer()))) continue;
                    n = 1;
                    break block13;
                }
                n = 0;
            }
        }
        n2 = n;
        globalPoliticsOverviewTable.showDiplomacyGroup = n2;
        this.updateCivTable(2);
        this.portraitMode = !this.showDiplomacyGroup || this.civTable.getMinWidth() > this.getOverviewScreen().getStage().getWidth() / (float)2 || this.getOverviewScreen().isPortrait();
        Table table3 = table2 = this.portraitMode ? (Table)this : this.fixedContent;
        if (this.showDiplomacyGroup) {
            float diplomacySize = RangesKt.coerceAtMost(this.getOverviewScreen().getStage().getWidth() - (this.portraitMode ? 0.0f : this.civTable.getMinWidth()), this.getOverviewScreen().getCenterAreaHeight$core());
            GlobalPoliticsDiagramGroup diplomacyGroup = new GlobalPoliticsDiagramGroup(this.undefeatedCivs, diplomacySize);
            table2.add((Actor)diplomacyGroup).top();
        }
        if (this.portraitMode) {
            int columns;
            if (this.showDiplomacyGroup) {
                table2.row();
            }
            if ((columns = 2 * MathKt.roundToInt(this.getOverviewScreen().getStage().getWidth() / this.civTable.getMinWidth())) > 2) {
                this.updateCivTable(columns);
                if (this.civTable.getMinWidth() > this.getOverviewScreen().getStage().getWidth()) {
                    this.updateCivTable(columns - 2);
                }
            }
        }
        table2.add((Actor)floatingTable);
        toggleCityStatesButton.setStyle(this.getPersistableData().getIncludeCityStates() ? BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class) : BaseScreen.Companion.getSkin().get("positive", TextButton.TextButtonStyle.class));
        ((AutoScrollPane)civTableScroll).setScrollingDisabled(this.portraitMode, this.portraitMode);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final boolean hideCityStateCount(Civilization $this$hideCityStateCount) {
        void $this$count$iv;
        if (!$this$hideCityStateCount.getGameInfo().getGameParameters().getRandomNumberOfCityStates()) {
            return false;
        }
        Sequence<Civilization> sequence = $this$hideCityStateCount.getKnownCivs();
        int n = 1;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            if (!it.isCityState() || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int n2 = count$iv;
        int knownCivs = n + n2;
        if (knownCivs >= $this$hideCityStateCount.getGameInfo().getGameParameters().getMaxNumberOfCityStates()) {
            return false;
        }
        return !Civilization.hasUnique$default($this$hideCityStateCount, UniqueType.OneTimeRevealEntireMap, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Table updateCivTable(int columns) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Table table2;
        Table $this$updateCivTable_u24lambda_u240 = table2 = this.civTable;
        boolean bl = false;
        $this$updateCivTable_u24lambda_u240.clear();
        this.addTitleInfo($this$updateCivTable_u24lambda_u240, columns);
        Iterable iterable = this.undefeatedCivs;
        String string = "alive";
        int n = columns;
        Table table3 = $this$updateCivTable_u24lambda_u240;
        GlobalPoliticsOverviewTable globalPoliticsOverviewTable = this;
        boolean $i$f$filter = false;
        void var11_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual(it, this.getViewingPlayer()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        globalPoliticsOverviewTable.addCivsCategory(table3, n, string, list2);
        this.addCivsCategory($this$updateCivTable_u24lambda_u240, columns, "defeated", this.defeatedCivs);
        $this$updateCivTable_u24lambda_u240.layout();
        return table2;
    }

    private final Table getCivMiniTable(Civilization civInfo) {
        Table table2 = new Table();
        table2.add((Actor)ImageGetter.INSTANCE.getNationPortrait(civInfo.getNation(), 25.0f)).pad(5.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel$default(civInfo.getCivName(), null, 0, 0, true, 7, null)).left().padRight(10.0f);
        table2.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(table2, () -> GlobalPoliticsOverviewTable.getCivMiniTable$lambda$0(civInfo, this));
        return table2;
    }

    private final void addTitleInfo(Table $this$addTitleInfo, int columns) {
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel('[' + this.relevantCivsCount + "] Civilizations in the game")).colspan(columns).row();
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel("Our Civilization:")).colspan(columns).left().padLeft(10.0f).padTop(10.0f).row();
        $this$addTitleInfo.add((Actor)this.getCivMiniTable(this.getViewingPlayer())).left();
        String scoreText = this.getViewingPlayer().isDefeated() ? "\u2620" : TranslationsKt.tr((int)this.getViewingPlayer().calculateTotalScore());
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel(scoreText)).left().row();
        Integer n = this.getViewingPlayer().getTurnsTillNextDiplomaticVote();
        if (n == null) {
            return;
        }
        int turnsTillNextDiplomaticVote = n;
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel("Turns until the next\ndiplomacy victory vote: [" + turnsTillNextDiplomaticVote + ']')).colspan(columns).row();
    }

    private final void addCivsCategory(Table $this$addCivsCategory, int columns, String aliveOrDefeated, List<Civilization> civs) {
        Scene2dExtensionsKt.addSeparator$default($this$addCivsCategory, null, 0, 0.0f, 7, null);
        int count2 = ((Collection)civs).size();
        $this$addCivsCategory.add((Actor)Scene2dExtensionsKt.toLabel("Known and " + aliveOrDefeated + " ([" + count2 + "])")).pad(5.0f).colspan(columns).row();
        if (count2 == 0) {
            return;
        }
        Scene2dExtensionsKt.addSeparator$default($this$addCivsCategory, null, 0, 0.0f, 7, null);
        Ref.IntRef currentColumn = new Ref.IntRef();
        Ref.BooleanRef lastCivWasMajor = new Ref.BooleanRef();
        for (Civilization civ : civs) {
            if (lastCivWasMajor.element && civ.isCityState()) {
                GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, columns);
            }
            $this$addCivsCategory.add((Actor)this.getCivMiniTable(civ)).left();
            if (civ.isCityState()) {
                GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, 1);
                continue;
            }
            $this$addCivsCategory.add((Actor)Scene2dExtensionsKt.toLabel((int)civ.calculateTotalScore())).left();
            GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, 2);
        }
    }

    private static final Unit getWondersOfCivTable$lambda$0(WonderInfo.WonderInfo $wonder) {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().resetToWorldScreen();
        WorldMapHolder.setCenterPosition$default(worldScreen.getMapHolder(), $wonder.getLocation().getPosition(), false, false, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateDiagram$lambda$0(GlobalPoliticsOverviewTable this$0) {
        this$0.updatePoliticsTable();
        this$0.getOverviewScreen().resizePage(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit updateDiagram$lambda$1$0(GlobalPoliticsOverviewTable this$0) {
        this$0.getPersistableData().setIncludeCityStates(!this$0.getPersistableData().getIncludeCityStates());
        this$0.updateDiagram();
        return Unit.INSTANCE;
    }

    private static final boolean updateDiagram$lambda$5(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isDefeated();
    }

    private static final Unit getCivMiniTable$lambda$0(Civilization $civInfo, GlobalPoliticsOverviewTable this$0) {
        if ($civInfo.isDefeated() || this$0.getViewingPlayer().isSpectator() || Intrinsics.areEqual($civInfo, this$0.getViewingPlayer())) {
            return Unit.INSTANCE;
        }
        UncivGame.Companion.getCurrent().pushScreen(new DiplomacyScreen(this$0.getViewingPlayer(), $civInfo, null, false, 12, null));
        return Unit.INSTANCE;
    }

    private static final void addCivsCategory$advanceCols(Ref.IntRef currentColumn, int $columns, Table $this_addCivsCategory, Ref.BooleanRef lastCivWasMajor, int delta) {
        currentColumn.element += delta;
        if (currentColumn.element >= $columns) {
            $this_addCivsCategory.row();
            currentColumn.element = 0;
        }
        lastCivWasMajor.element = delta == 2;
    }

    public static final /* synthetic */ void access$updateDiagram(GlobalPoliticsOverviewTable $this) {
        $this.updateDiagram();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "showDiagram", "", "includeCityStates", "<init>", "(ZZ)V", "getShowDiagram", "()Z", "setShowDiagram", "(Z)V", "getIncludeCityStates", "setIncludeCityStates", "isEmpty", "core"})
    public static final class DiplomacyTabPersistableData
    extends EmpireOverviewTab.EmpireOverviewTabPersistableData {
        private boolean showDiagram;
        private boolean includeCityStates;

        public DiplomacyTabPersistableData(boolean showDiagram, boolean includeCityStates) {
            this.showDiagram = showDiagram;
            this.includeCityStates = includeCityStates;
        }

        public /* synthetic */ DiplomacyTabPersistableData(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getShowDiagram() {
            return this.showDiagram;
        }

        public final void setShowDiagram(boolean bl) {
            this.showDiagram = bl;
        }

        public final boolean getIncludeCityStates() {
            return this.includeCityStates;
        }

        public final void setIncludeCityStates(boolean bl) {
            this.includeCityStates = bl;
        }

        @Override
        public boolean isEmpty() {
            return !this.showDiagram && !this.includeCityStates;
        }

        public DiplomacyTabPersistableData() {
            this(false, false, 3, null);
        }
    }
}

