/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.worldmap;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UncivSound;
import com.unciv.models.UnitActionType;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.worldscreen.worldmap.OverlayButtonData;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/worldscreen/worldmap/ConnectRoadOverlayButtonData;", "Lcom/unciv/ui/screens/worldscreen/worldmap/OverlayButtonData;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;Lcom/unciv/logic/map/tile/Tile;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "createButton", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "worldMapHolder", "Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "getConnectRoadButton", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "connectRoadToTargetTile", "", "selectedUnit", "targetTile", "core"})
public final class ConnectRoadOverlayButtonData
implements OverlayButtonData {
    @NotNull
    private final MapUnit unit;
    @NotNull
    private final Tile tile;

    public ConnectRoadOverlayButtonData(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.unit = unit;
        this.tile = tile;
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    @Override
    @NotNull
    public Actor createButton(@NotNull WorldMapHolder worldMapHolder) {
        Intrinsics.checkNotNullParameter(worldMapHolder, "worldMapHolder");
        return this.getConnectRoadButton(worldMapHolder);
    }

    /*
     * WARNING - void declaration
     */
    private final Group getConnectRoadButton(WorldMapHolder worldMapHolder) {
        void $this$getConnectRoadButton_u24lambda_u240;
        Portrait portrait;
        Group connectRoadButton = new Group();
        connectRoadButton.setSize(60.0f, 60.0f);
        Portrait portrait2 = portrait = ImageGetter.INSTANCE.getUnitActionPortrait("RoadConnection", 48.0f);
        Group group = connectRoadButton;
        boolean bl = false;
        Scene2dExtensionsKt.center((Actor)$this$getConnectRoadButton_u24lambda_u240, connectRoadButton);
        group.addActor(portrait);
        UnitIconGroup unitIcon = new UnitIconGroup(this.unit, 25.0f);
        unitIcon.setY(60.0f - unitIcon.getHeight());
        connectRoadButton.addActor(unitIcon);
        ActivationExtensionsKt.onActivation(connectRoadButton, UncivSound.Companion.getSilent(), () -> ConnectRoadOverlayButtonData.getConnectRoadButton$lambda$1(this, worldMapHolder));
        ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(connectRoadButton), KeyboardBinding.ConnectRoad, 0, 2, null);
        return connectRoadButton;
    }

    private final void connectRoadToTargetTile(WorldMapHolder worldMapHolder, MapUnit selectedUnit, Tile targetTile) {
        selectedUnit.setAutomatedRoadConnectionDestination(targetTile.getPosition());
        selectedUnit.setAutomatedRoadConnectionPath(null);
        selectedUnit.setAction(UnitActionType.ConnectRoad.getValue());
        selectedUnit.setAutomated(true);
        UnitAutomation.INSTANCE.automateUnitMoves(selectedUnit);
        SoundPlayer.INSTANCE.play(new UncivSound("wagon"));
        worldMapHolder.getWorldScreen$core().setShouldUpdate(true);
        worldMapHolder.removeUnitActionOverlay();
        worldMapHolder.getWorldScreen$core().getBottomUnitTable$core().setSelectedUnitIsConnectingRoad(false);
    }

    private static final Unit getConnectRoadButton$lambda$1(ConnectRoadOverlayButtonData this$0, WorldMapHolder $worldMapHolder) {
        this$0.connectRoadToTargetTile($worldMapHolder, this$0.unit, this$0.tile);
        return Unit.INSTANCE;
    }
}

