/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.CIOReaderKt;
import io.ktor.network.sockets.CIOWriterKt;
import io.ktor.network.sockets.ReadWriteSocket;
import io.ktor.network.sockets.SocketBase;
import io.ktor.network.sockets.SocketOptions;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ReaderJob;
import io.ktor.utils.io.WriterJob;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u000e\b \u0018\u0000*\u000e\b\u0000\u0010\u0003 \u0001*\u00020\u0001*\u00020\u00022\u00020\u00042\u00020\u0005B3\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0010\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0006\u001a\u00028\u00008\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001f\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010!\u001a\u0004\b\"\u0010#R\u0016\u0010\r\u001a\u0004\u0018\u00010\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010$\u00a8\u0006%"}, d2={"Lio/ktor/network/sockets/NIOSocketImpl;", "Ljava/nio/channels/ByteChannel;", "Ljava/nio/channels/SelectableChannel;", "S", "Lio/ktor/network/sockets/ReadWriteSocket;", "Lio/ktor/network/sockets/SocketBase;", "channel", "Lio/ktor/network/selector/SelectorManager;", "selector", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "pool", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "socketOptions", "<init>", "(Ljava/nio/channels/SelectableChannel;Lio/ktor/network/selector/SelectorManager;Lio/ktor/utils/io/pool/ObjectPool;Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;)V", "Lio/ktor/utils/io/ByteChannel;", "Lio/ktor/utils/io/WriterJob;", "attachForReadingImpl", "(Lio/ktor/utils/io/ByteChannel;)Lio/ktor/utils/io/WriterJob;", "Lio/ktor/utils/io/ReaderJob;", "attachForWritingImpl", "(Lio/ktor/utils/io/ByteChannel;)Lio/ktor/utils/io/ReaderJob;", "", "actualClose$ktor_network", "()Ljava/lang/Throwable;", "actualClose", "Ljava/nio/channels/SelectableChannel;", "getChannel", "()Ljava/nio/channels/SelectableChannel;", "Lio/ktor/network/selector/SelectorManager;", "getSelector", "()Lio/ktor/network/selector/SelectorManager;", "Lio/ktor/utils/io/pool/ObjectPool;", "getPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "ktor-network"})
public abstract class NIOSocketImpl<S extends SelectableChannel>
extends SocketBase
implements ReadWriteSocket {
    @NotNull
    private final S channel;
    @NotNull
    private final SelectorManager selector;
    @Nullable
    private final ObjectPool<ByteBuffer> pool;
    @Nullable
    private final SocketOptions.TCPClientSocketOptions socketOptions;

    public NIOSocketImpl(@NotNull S channel2, @NotNull SelectorManager selector, @Nullable ObjectPool<ByteBuffer> pool, @Nullable SocketOptions.TCPClientSocketOptions socketOptions) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        Intrinsics.checkNotNullParameter(selector, "selector");
        super(EmptyCoroutineContext.INSTANCE);
        this.channel = channel2;
        this.selector = selector;
        this.pool = pool;
        this.socketOptions = socketOptions;
    }

    public /* synthetic */ NIOSocketImpl(SelectableChannel selectableChannel, SelectorManager selectorManager, ObjectPool objectPool, SocketOptions.TCPClientSocketOptions tCPClientSocketOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tCPClientSocketOptions = null;
        }
        this(selectableChannel, selectorManager, objectPool, tCPClientSocketOptions);
    }

    @NotNull
    public S getChannel() {
        return this.channel;
    }

    @NotNull
    public final SelectorManager getSelector() {
        return this.selector;
    }

    @Nullable
    public final ObjectPool<ByteBuffer> getPool() {
        return this.pool;
    }

    @Override
    @NotNull
    public final WriterJob attachForReadingImpl(@NotNull ByteChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        return this.pool != null ? CIOReaderKt.attachForReadingImpl(this, channel2, (ReadableByteChannel)this.getChannel(), this, this.selector, this.pool, this.socketOptions) : CIOReaderKt.attachForReadingDirectImpl(this, channel2, (ReadableByteChannel)this.getChannel(), this, this.selector, this.socketOptions);
    }

    @Override
    @NotNull
    public final ReaderJob attachForWritingImpl(@NotNull ByteChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        return CIOWriterKt.attachForWritingDirectImpl(this, channel2, (WritableByteChannel)this.getChannel(), this, this.selector, this.socketOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Throwable actualClose$ktor_network() {
        Throwable throwable;
        try {
            ((Channel)this.getChannel()).close();
            super.close();
            throwable = null;
        }
        catch (Throwable cause) {
            throwable = cause;
        }
        finally {
            this.selector.notifyClosed(this);
        }
        return throwable;
    }
}

