/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.unciv.UncivGame;
import com.unciv.app.desktop.DesktopLogBackend;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameStarter;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.simulation.Simulation;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.skins.SkinCache;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0005H\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J!\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0007\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/unciv/app/desktop/ConsoleLauncher;", "", "<init>", "()V", "main", "", "arg", "", "", "([Ljava/lang/String;)V", "runSimulation", "getMapParameters", "Lcom/unciv/logic/map/MapParameters;", "getGameParameters", "Lcom/unciv/models/metadata/GameParameters;", "civilizations", "Lcom/unciv/models/ruleset/nation/Nation;", "([Lcom/unciv/models/ruleset/nation/Nation;)Lcom/unciv/models/metadata/GameParameters;", "desktop"})
@SourceDebugExtension(value={"SMAP\nConsoleLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleLauncher.kt\ncom/unciv/app/desktop/ConsoleLauncher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class ConsoleLauncher {
    @NotNull
    public static final ConsoleLauncher INSTANCE = new ConsoleLauncher();

    private ConsoleLauncher() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @ExperimentalTime
    public static final void main(@NotNull String[] arg) {
        void $this$main_u24lambda_u240;
        GameSettings gameSettings;
        Intrinsics.checkNotNullParameter(arg, "arg");
        Log.INSTANCE.setBackend(new DesktopLogBackend());
        UncivGame game = new UncivGame(true);
        UncivGame.Companion.setCurrent(game);
        GameSettings gameSettings2 = gameSettings = new GameSettings();
        UncivGame uncivGame = UncivGame.Companion.getCurrent();
        boolean bl = false;
        $this$main_u24lambda_u240.setShowTutorials(false);
        $this$main_u24lambda_u240.setTurnsBetweenAutosaves(10000);
        uncivGame.setSettings(gameSettings);
        RulesetCache.loadRulesets$default(RulesetCache.INSTANCE, true, false, 2, null);
        TileSetCache.INSTANCE.loadTileSetConfigs(true);
        SkinCache.INSTANCE.loadSkinConfigs(true);
        INSTANCE.runSimulation();
    }

    @ExperimentalTime
    private final void runSimulation() {
        Nation[] nationArray;
        Object object = RulesetCache.INSTANCE.get((Object)BaseRuleset.Civ_V_GnK.getFullName());
        Intrinsics.checkNotNull(object);
        Ruleset ruleset = (Ruleset)object;
        Nation[] $this$runSimulation_u24lambda_u240 = nationArray = new Nation();
        boolean bl = false;
        $this$runSimulation_u24lambda_u240.setName("SimulationCiv1");
        Nation[] simulationNation1 = nationArray;
        ((Map)ruleset.getNations()).put("SimulationCiv1", simulationNation1);
        Nation[] $this$runSimulation_u24lambda_u241 = $this$runSimulation_u24lambda_u240 = new Nation();
        boolean bl2 = false;
        $this$runSimulation_u24lambda_u241.setName("SimulationCiv2");
        Nation[] simulationNation2 = $this$runSimulation_u24lambda_u240;
        ((Map)ruleset.getNations()).put("SimulationCiv2", simulationNation2);
        $this$runSimulation_u24lambda_u241 = new Nation[]{simulationNation1, simulationNation2};
        GameParameters gameParameters = this.getGameParameters($this$runSimulation_u24lambda_u241);
        ((Player)CollectionsKt.last((List)gameParameters.getPlayers())).setNationTransient(ruleset);
        MapParameters mapParameters = this.getMapParameters();
        GameSetupInfo gameSetupInfo = new GameSetupInfo(gameParameters, mapParameters);
        GameInfo newGame = GameStarter.INSTANCE.startNewGame(gameSetupInfo);
        newGame.getGameParameters().setVictoryTypes(new ArrayList<String>((Collection)newGame.getRuleset().getVictories().keySet()));
        UncivGame.Companion.getCurrent().setGameInfo(newGame);
        Simulation simulation = new Simulation(newGame, 500, 8, 0, null, 24, null);
        simulation.start();
    }

    private final MapParameters getMapParameters() {
        MapParameters mapParameters;
        MapParameters $this$getMapParameters_u24lambda_u240 = mapParameters = new MapParameters();
        boolean bl = false;
        $this$getMapParameters_u24lambda_u240.setMapSize(MapSize.Companion.getTiny());
        $this$getMapParameters_u24lambda_u240.setNoRuins(true);
        $this$getMapParameters_u24lambda_u240.setNoNaturalWonders(true);
        $this$getMapParameters_u24lambda_u240.setLegendaryStart(true);
        $this$getMapParameters_u24lambda_u240.setStrategicBalance(true);
        $this$getMapParameters_u24lambda_u240.setMirroring("Around Center Tile");
        $this$getMapParameters_u24lambda_u240.setWaterThreshold($this$getMapParameters_u24lambda_u240.getWaterThreshold() - 0.1f);
        return mapParameters;
    }

    /*
     * WARNING - void declaration
     */
    private final GameParameters getGameParameters(Nation ... civilizations) {
        void $this$getGameParameters_u24lambda_u240_u240;
        ArrayList<Player> arrayList;
        GameParameters gameParameters;
        GameParameters $this$getGameParameters_u24lambda_u240 = gameParameters = new GameParameters();
        boolean bl = false;
        $this$getGameParameters_u24lambda_u240.setDifficulty("King");
        $this$getGameParameters_u24lambda_u240.setNumberOfCityStates(0);
        $this$getGameParameters_u24lambda_u240.setSpeed("Quick");
        $this$getGameParameters_u24lambda_u240.setNoBarbarians(true);
        ArrayList<Player> arrayList2 = arrayList = new ArrayList<Player>();
        GameParameters gameParameters2 = $this$getGameParameters_u24lambda_u240;
        boolean bl2 = false;
        for (Nation it : civilizations) {
            $this$getGameParameters_u24lambda_u240_u240.add(new Player(it, null, null, 6, null));
        }
        $this$getGameParameters_u24lambda_u240_u240.add(new Player("Spectator", PlayerType.Human, null, 4, null));
        gameParameters2.setPlayers(arrayList);
        return gameParameters;
    }
}

