/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.map.MapParameters;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010J \u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0002J\u0006\u0010\u0019\u001a\u00020\u0003J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001eJ*\u0010\u001b\u001a\u00020\u00032\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00020 j\b\u0012\u0004\u0012\u00020\u0002`!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0002J\u001c\u0010\u001b\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%JB\u0010&\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020(0'2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00020 j\b\u0012\u0004\u0012\u00020\u0002`!2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010)\u001a\u00020\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lcom/unciv/models/ruleset/RulesetCache;", "Ljava/util/HashMap;", "", "Lcom/unciv/models/ruleset/Ruleset;", "Lkotlin/collections/HashMap;", "<init>", "()V", "uniqueMisspellingThreshold", "", "getUniqueMisspellingThreshold", "()D", "setUniqueMisspellingThreshold", "(D)V", "loadRulesets", "", "consoleMode", "", "noMods", "loadSingleRuleset", "modFolder", "Lcom/badlogic/gdx/files/FileHandle;", "errorLines", "", "reloadSingleRuleset", "modName", "getVanillaRuleset", "getSortedBaseRulesets", "getComplexRuleset", "parameters", "Lcom/unciv/logic/map/MapParameters;", "Lcom/unciv/models/metadata/GameParameters;", "mods", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "optionalBaseRuleset", "baseRuleset", "extensionRulesets", "", "checkCombinedModLinks", "Lkotlin/Pair;", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "tryFixUnknownUniques", "core"})
@SourceDebugExtension(value={"SMAP\nRulesetCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesetCache.kt\ncom/unciv/models/ruleset/RulesetCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,204:1\n1563#2:205\n1634#2,3:206\n774#2:209\n865#2,2:210\n1563#2:212\n1634#2,3:213\n295#2,2:217\n622#3:216\n*S KotlinDebug\n*F\n+ 1 RulesetCache.kt\ncom/unciv/models/ruleset/RulesetCache\n*L\n46#1:205\n46#1:206,3\n113#1:209\n113#1:210,2\n114#1:212\n114#1:213,3\n124#1:217,2\n167#1:216\n*E\n"})
public final class RulesetCache
extends HashMap<String, Ruleset> {
    @NotNull
    public static final RulesetCache INSTANCE = new RulesetCache();
    private static double uniqueMisspellingThreshold = 0.15;

    private RulesetCache() {
    }

    public final double getUniqueMisspellingThreshold() {
        return uniqueMisspellingThreshold;
    }

    public final void setUniqueMisspellingThreshold(double d) {
        uniqueMisspellingThreshold = d;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> loadRulesets(boolean consoleMode, boolean noMods) {
        void $this$mapTo$iv$iv;
        boolean parallel = true;
        long startTimeMs = System.currentTimeMillis();
        ConcurrentHashMap newRulesets = new ConcurrentHashMap();
        Iterable $this$map$iv = BaseRuleset.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = (FileHandle[])new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BaseRuleset baseRuleset = (BaseRuleset)((Object)item$iv$iv);
            FileHandle[] fileHandleArray = destination$iv$iv;
            boolean bl = false;
            fileHandleArray.add(() -> RulesetCache.loadRulesets$lambda$1$0((BaseRuleset)it, newRulesets, consoleMode));
        }
        List builtinRulesetTasks = (List)destination$iv$iv;
        Concurrency.INSTANCE.parallelize(builtinRulesetTasks, parallel);
        this.putAll(newRulesets);
        ArrayList errorLines = new ArrayList();
        if (!noMods) {
            FileHandle[] modsHandles = consoleMode ? new FileHandle("mods").list() : UncivGame.Companion.getCurrent().getFiles().getModsFolder().list();
            ArrayList<Function0<Unit>> modRulesetTasks = new ArrayList<Function0<Unit>>();
            Intrinsics.checkNotNull(modsHandles);
            for (FileHandle modFolder : modsHandles) {
                String string = modFolder.name();
                Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                if (StringsKt.startsWith$default((CharSequence)string, '.', false, 2, null) || !modFolder.isDirectory()) continue;
                modRulesetTasks.add(() -> RulesetCache.loadRulesets$lambda$2(modFolder, errorLines, newRulesets));
            }
            Concurrency.INSTANCE.parallelize((List<? extends Function0<Unit>>)modRulesetTasks, parallel);
            if (Log.shouldLog$default(Log.INSTANCE, null, 1, null)) {
                Iterator iterator2 = errorLines.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                destination$iv$iv = iterator2;
                while (destination$iv$iv.hasNext()) {
                    Object e = destination$iv$iv.next();
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    String line = (String)e;
                    Log.INSTANCE.debug(line, new Object[0]);
                }
            }
        }
        this.clear();
        this.putAll(newRulesets);
        long endTimeMs = System.currentTimeMillis();
        long loadTime = endTimeMs - startTimeMs;
        System.out.println((Object)("Loaded " + this.size() + " rulesets in " + loadTime + "ms"));
        return errorLines;
    }

    public static /* synthetic */ List loadRulesets$default(RulesetCache rulesetCache, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return rulesetCache.loadRulesets(bl, bl2);
    }

    private final Ruleset loadSingleRuleset(FileHandle modFolder, List<String> errorLines) {
        Object var3_3;
        try {
            Ruleset modRuleset = new Ruleset();
            String string = modFolder.name();
            Intrinsics.checkNotNullExpressionValue(string, "name(...)");
            modRuleset.setName(string);
            FileHandle fileHandle = modFolder.child("jsons");
            Intrinsics.checkNotNullExpressionValue(fileHandle, "child(...)");
            modRuleset.load(fileHandle);
            modRuleset.setFolderLocation(modFolder);
            Object[] objectArray = new Object[]{modRuleset.getName()};
            Log.INSTANCE.debug("Mod loaded successfully: %s", objectArray);
        }
        catch (Exception ex) {
            ((Collection)errorLines).add("Exception loading mod '" + modFolder.name() + "':");
            ((Collection)errorLines).add("  " + ex.getLocalizedMessage());
            Collection collection = errorLines;
            Throwable throwable = ex.getCause();
            collection.add("  " + (throwable != null ? throwable.getLocalizedMessage() : null));
            var3_3 = null;
        }
        return var3_3;
    }

    @NotNull
    public final List<String> reloadSingleRuleset(@NotNull String modName) {
        Intrinsics.checkNotNullParameter(modName, "modName");
        FileHandle modFolder = UncivGame.Companion.getCurrent().getFiles().getModsFolder().child(modName);
        if (!modFolder.exists() || !modFolder.isDirectory()) {
            return CollectionsKt.listOf("No such mod");
        }
        ArrayList errorLines = new ArrayList();
        Concurrency.INSTANCE.parallelize(CollectionsKt.listOf(() -> RulesetCache.reloadSingleRuleset$lambda$0(modFolder, errorLines, modName)), true);
        return errorLines;
    }

    @NotNull
    public final Ruleset getVanillaRuleset() {
        Object object = this.get((Object)BaseRuleset.Civ_V_Vanilla.getFullName());
        Intrinsics.checkNotNull(object);
        return ((Ruleset)object).clone();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSortedBaseRulesets() {
        void $this$mapTo$iv$iv;
        Ruleset it;
        Iterable $this$filterTo$iv$iv;
        Collection<Ruleset> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Ruleset)element$iv$iv;
            boolean bl = false;
            if (!it.getModOptions().isBaseRuleset()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Ruleset)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        List<String> baseRulesets = CollectionsKt.distinct((List)destination$iv$iv);
        if (baseRulesets.size() < 2) {
            return baseRulesets;
        }
        Function1[] function1Array = new Function1[]{RulesetCache::getSortedBaseRulesets$lambda$2, RulesetCache::getSortedBaseRulesets$lambda$3};
        return CollectionsKt.sortedWith((Iterable)baseRulesets, ComparisonsKt.compareBy(function1Array));
    }

    @NotNull
    public final Ruleset getComplexRuleset(@NotNull MapParameters parameters) {
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        return this.getComplexRuleset(parameters.getMods(), parameters.getBaseRuleset());
    }

    @NotNull
    public final Ruleset getComplexRuleset(@NotNull GameParameters parameters) {
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        return this.getComplexRuleset(parameters.getMods(), parameters.getBaseRuleset());
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Ruleset getComplexRuleset(@NotNull LinkedHashSet<String> mods, @Nullable String optionalBaseRuleset) {
        Intrinsics.checkNotNullParameter(mods, "mods");
        if (!((Map)this).containsKey(optionalBaseRuleset)) ** GOTO lbl-1000
        v0 = ((Map)this).get(optionalBaseRuleset);
        Intrinsics.checkNotNull(v0);
        if (((Ruleset)v0).getModOptions().isBaseRuleset()) {
            v1 = ((Map)this).get(optionalBaseRuleset);
            Intrinsics.checkNotNull(v1);
            v2 = (Ruleset)v1;
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.getVanillaRuleset();
        }
        baseRuleset = v2;
        loadedMods = SequencesKt.filter(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)mods), (Function1<String, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getComplexRuleset$lambda$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)()), (Function1<String, Ruleset>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getComplexRuleset$lambda$1(java.lang.String ), (Ljava/lang/String;)Lcom/unciv/models/ruleset/Ruleset;)()), (Function1<Ruleset, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getComplexRuleset$lambda$2(com.unciv.models.ruleset.Ruleset ), (Lcom/unciv/models/ruleset/Ruleset;)Ljava/lang/Boolean;)());
        return this.getComplexRuleset(baseRuleset, SequencesKt.asIterable(loadedMods));
    }

    public static /* synthetic */ Ruleset getComplexRuleset$default(RulesetCache rulesetCache, LinkedHashSet linkedHashSet, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return rulesetCache.getComplexRuleset(linkedHashSet, string);
    }

    @NotNull
    public final Ruleset getComplexRuleset(@NotNull Ruleset baseRuleset, @NotNull Iterable<Ruleset> extensionRulesets) {
        Sequence<Ruleset> loadedMods;
        Intrinsics.checkNotNullParameter(baseRuleset, "baseRuleset");
        Intrinsics.checkNotNullParameter(extensionRulesets, "extensionRulesets");
        Ruleset newRuleset = new Ruleset();
        Sequence<Ruleset> $this$sortedByDescending$iv = loadedMods = SequencesKt.plus(CollectionsKt.asSequence(extensionRulesets), baseRuleset);
        boolean $i$f$sortedByDescending = false;
        Iterator<Ruleset> iterator2 = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Ruleset it = (Ruleset)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getModOptions().isBaseRuleset());
                it = (Ruleset)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getModOptions().isBaseRuleset());
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Ruleset mod = iterator2.next();
            if (mod.getModOptions().isBaseRuleset()) {
                newRuleset.getModOptions().setUniques(new ArrayList<String>());
                newRuleset.getModOptions().setBaseRuleset(true);
                newRuleset.getModOptions().setTileset(mod.getModOptions().getTileset());
                newRuleset.getModOptions().setUnitset(mod.getModOptions().getUnitset());
            }
            newRuleset.add(mod);
            ((Collection)newRuleset.getMods()).add(mod.getName());
        }
        newRuleset.updateBuildingCosts$core();
        newRuleset.updateResourceTransients$core();
        return newRuleset;
    }

    @NotNull
    public final Pair<Ruleset, RulesetErrorList> checkCombinedModLinks(@NotNull LinkedHashSet<String> mods, @Nullable String baseRuleset, boolean tryFixUnknownUniques) {
        Pair<Object, RulesetErrorList> pair;
        Intrinsics.checkNotNullParameter(mods, "mods");
        try {
            Ruleset newRuleset = this.getComplexRuleset(mods, baseRuleset);
            newRuleset.getModOptions().setBaseRuleset(true);
            pair = TuplesKt.to(newRuleset, newRuleset.getErrorList(tryFixUnknownUniques));
        }
        catch (UncivShowableException ex) {
            pair = TuplesKt.to(null, RulesetErrorList.Companion.of$default(RulesetErrorList.Companion, ex.getMessage(), RulesetErrorSeverity.Error, null, null, null, 28, null));
        }
        return pair;
    }

    public static /* synthetic */ Pair checkCombinedModLinks$default(RulesetCache rulesetCache, LinkedHashSet linkedHashSet, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return rulesetCache.checkCombinedModLinks(linkedHashSet, string, bl);
    }

    private static final FileHandle loadRulesets$getBuiltinRulesetFileHandle(boolean $consoleMode, BaseRuleset ruleset) {
        FileHandle fileHandle;
        String fileName = "jsons/" + ruleset.getFullName();
        if ($consoleMode) {
            fileHandle = new FileHandle(fileName);
        } else {
            FileHandle fileHandle2 = Gdx.files.internal(fileName);
            fileHandle = fileHandle2;
            Intrinsics.checkNotNullExpressionValue(fileHandle2, "internal(...)");
        }
        return fileHandle;
    }

    private static final void loadRulesets$loadBuiltinRuleset(ConcurrentHashMap<String, Ruleset> newRulesets, boolean $consoleMode, BaseRuleset ruleset) {
        Ruleset ruleset2;
        FileHandle fileHandle = RulesetCache.loadRulesets$getBuiltinRulesetFileHandle($consoleMode, ruleset);
        Map map2 = newRulesets;
        String string = ruleset.getFullName();
        Ruleset $this$loadRulesets_u24loadBuiltinRuleset_u24lambda_u240 = ruleset2 = new Ruleset();
        boolean bl = false;
        $this$loadRulesets_u24loadBuiltinRuleset_u24lambda_u240.setName(ruleset.getFullName());
        $this$loadRulesets_u24loadBuiltinRuleset_u24lambda_u240.load(fileHandle);
        map2.put(string, ruleset2);
    }

    private static final Unit loadRulesets$lambda$1$0(BaseRuleset $it, ConcurrentHashMap $newRulesets, boolean $consoleMode) {
        RulesetCache.loadRulesets$loadBuiltinRuleset($newRulesets, $consoleMode, $it);
        return Unit.INSTANCE;
    }

    private static final Unit loadRulesets$lambda$2(FileHandle $modFolder, ArrayList $errorLines, ConcurrentHashMap $newRulesets) {
        Intrinsics.checkNotNull($modFolder);
        Ruleset modRuleset = INSTANCE.loadSingleRuleset($modFolder, $errorLines);
        if (modRuleset != null) {
            ((Map)$newRulesets).put(modRuleset.getName(), modRuleset);
        }
        return Unit.INSTANCE;
    }

    private static final Unit reloadSingleRuleset$lambda$0(FileHandle $modFolder, ArrayList $errorLines, String $modName) {
        Intrinsics.checkNotNull($modFolder);
        Ruleset newRuleset = INSTANCE.loadSingleRuleset($modFolder, $errorLines);
        if (newRuleset != null) {
            ((Map)INSTANCE).put($modName, newRuleset);
        }
        return Unit.INSTANCE;
    }

    private static final Comparable getSortedBaseRulesets$lambda$2(String ruleset) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            Iterable $this$firstOrNull$iv = BaseRuleset.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BaseRuleset br = (BaseRuleset)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(br.getFullName(), ruleset)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        BaseRuleset baseRuleset = v0;
        return baseRuleset != null ? (Comparable)Integer.valueOf(baseRuleset.ordinal()) : (Comparable)Integer.valueOf(BaseRuleset.getEntries().size());
    }

    private static final Comparable getSortedBaseRulesets$lambda$3(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Comparable)((Object)it);
    }

    private static final boolean getComplexRuleset$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.containsKey((Object)it);
    }

    private static final Ruleset getComplexRuleset$lambda$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object object = INSTANCE.get((Object)it);
        Intrinsics.checkNotNull(object);
        return (Ruleset)object;
    }

    private static final boolean getComplexRuleset$lambda$2(Ruleset it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.getModOptions().isBaseRuleset();
    }
}

