/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class DepthShader
extends DefaultShader {
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;
    public final int numBones;
    private final FloatAttribute alphaTestAttribute;
    private static final Attributes tmpAttributes = new Attributes();

    public static final String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/depth.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static final String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/depth.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static String createPrefix(Renderable renderable, Config config2) {
        String prefix = DefaultShader.createPrefix(renderable, config2);
        if (!config2.depthBufferOnly) {
            prefix = prefix + "#define PackedDepthFlag\n";
        }
        return prefix;
    }

    public DepthShader(Renderable renderable) {
        this(renderable, new Config());
    }

    public DepthShader(Renderable renderable, Config config2) {
        this(renderable, config2, DepthShader.createPrefix(renderable, config2));
    }

    public DepthShader(Renderable renderable, Config config2, String prefix) {
        this(renderable, config2, prefix, config2.vertexShader != null ? config2.vertexShader : DepthShader.getDefaultVertexShader(), config2.fragmentShader != null ? config2.fragmentShader : DepthShader.getDefaultFragmentShader());
    }

    public DepthShader(Renderable renderable, Config config2, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config2, new ShaderProgram(prefix + vertexShader, prefix + fragmentShader));
    }

    public DepthShader(Renderable renderable, Config config2, ShaderProgram shaderProgram) {
        super(renderable, (DefaultShader.Config)config2, shaderProgram);
        Attributes attributes = DepthShader.combineAttributes(renderable);
        if (renderable.bones != null && renderable.bones.length > config2.numBones) {
            throw new GdxRuntimeException("too many bones: " + renderable.bones.length + ", max configured: " + config2.numBones);
        }
        this.numBones = renderable.bones == null ? 0 : config2.numBones;
        int boneWeights = renderable.meshPart.mesh.getVertexAttributes().getBoneWeights();
        if (boneWeights > config2.numBoneWeights) {
            throw new GdxRuntimeException("too many bone weights: " + boneWeights + ", max configured: " + config2.numBoneWeights);
        }
        this.alphaTestAttribute = new FloatAttribute(FloatAttribute.AlphaTest, config2.defaultAlphaTest);
    }

    @Override
    public void begin(Camera camera, RenderContext context) {
        super.begin(camera, context);
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public boolean canRender(Renderable renderable) {
        boolean isBlendedTextureRenderable;
        if (renderable.bones != null) {
            if (renderable.bones.length > this.config.numBones) {
                return false;
            }
            if (renderable.meshPart.mesh.getVertexAttributes().getBoneWeights() > this.config.numBoneWeights) {
                return false;
            }
        }
        Attributes attributes = DepthShader.combineAttributes(renderable);
        boolean isBlendedTextureShader = (this.attributesMask & BlendingAttribute.Type) == BlendingAttribute.Type && (this.attributesMask & TextureAttribute.Diffuse) == TextureAttribute.Diffuse;
        boolean bl = isBlendedTextureRenderable = attributes.has(BlendingAttribute.Type) && attributes.has(TextureAttribute.Diffuse);
        if (isBlendedTextureShader != isBlendedTextureRenderable) {
            return false;
        }
        return renderable.bones != null == this.numBones > 0;
    }

    @Override
    public void render(Renderable renderable, Attributes combinedAttributes) {
        if (combinedAttributes.has(BlendingAttribute.Type)) {
            BlendingAttribute blending = (BlendingAttribute)combinedAttributes.get(BlendingAttribute.Type);
            combinedAttributes.remove(BlendingAttribute.Type);
            boolean hasAlphaTest = combinedAttributes.has(FloatAttribute.AlphaTest);
            if (!hasAlphaTest) {
                combinedAttributes.set((Attribute)this.alphaTestAttribute);
            }
            if (blending.opacity >= ((FloatAttribute)combinedAttributes.get((long)FloatAttribute.AlphaTest)).value) {
                super.render(renderable, combinedAttributes);
            }
            if (!hasAlphaTest) {
                combinedAttributes.remove(FloatAttribute.AlphaTest);
            }
            combinedAttributes.set((Attribute)blending);
        } else {
            super.render(renderable, combinedAttributes);
        }
    }

    private static final Attributes combineAttributes(Renderable renderable) {
        tmpAttributes.clear();
        if (renderable.environment != null) {
            tmpAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            tmpAttributes.set(renderable.material);
        }
        return tmpAttributes;
    }

    public static class Config
    extends DefaultShader.Config {
        public boolean depthBufferOnly = false;
        public float defaultAlphaTest = 0.5f;

        public Config() {
            this.defaultCullFace = 1028;
        }

        public Config(String vertexShader, String fragmentShader) {
            super(vertexShader, fragmentShader);
        }
    }
}

