/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.storage;

import com.badlogic.gdx.utils.Json;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.UncivKtor;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.multiplayer.ServerFeatureSet;
import com.unciv.logic.multiplayer.storage.DropBox;
import com.unciv.logic.multiplayer.storage.FileStorage;
import com.unciv.logic.multiplayer.storage.MultiplayerServer;
import com.unciv.logic.multiplayer.storage.UncivServerFileStorage;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.chat.ChatButton;
import io.ktor.client.HttpClient;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCodeKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0003J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001fH\u0086@\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010#J\u0016\u0010%\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010#R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/unciv/logic/multiplayer/storage/MultiplayerServer;", "", "fileStorageIdentifier", "", "authenticationHeader", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getFileStorageIdentifier", "()Ljava/lang/String;", "featureSet", "Lcom/unciv/logic/multiplayer/ServerFeatureSet;", "getFeatureSet", "setFeatureSet", "", "value", "getServerUrl", "fileStorage", "Lcom/unciv/logic/multiplayer/storage/FileStorage;", "checkServerStatus", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "authenticate", "password", "setPassword", "uploadGame", "gameInfo", "Lcom/unciv/logic/GameInfo;", "withPreview", "(Lcom/unciv/logic/GameInfo;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryUploadGamePreview", "Lcom/unciv/logic/GameInfoPreview;", "(Lcom/unciv/logic/GameInfoPreview;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryDownloadGame", "gameId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadGame", "tryDownloadGamePreview", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerServer.kt\ncom/unciv/logic/multiplayer/storage/MultiplayerServer\n+ 2 builders.kt\nio/ktor/client/request/BuildersKt\n+ 3 builders.kt\nio/ktor/client/request/BuildersKt$get$4\n*L\n1#1,191:1\n547#2,4:192\n359#2:196\n551#2,2:197\n553#2:200\n205#2,2:201\n43#2:203\n549#3:199\n*S KotlinDebug\n*F\n+ 1 MultiplayerServer.kt\ncom/unciv/logic/multiplayer/storage/MultiplayerServer\n*L\n61#1:192,4\n61#1:196\n61#1:197,2\n61#1:200\n61#1:201,2\n61#1:203\n61#1:199\n*E\n"})
public final class MultiplayerServer {
    @Nullable
    private final String fileStorageIdentifier;
    @Nullable
    private Map<String, String> authenticationHeader;
    @NotNull
    private ServerFeatureSet featureSet;

    public MultiplayerServer(@Nullable String fileStorageIdentifier, @Nullable Map<String, String> authenticationHeader) {
        this.fileStorageIdentifier = fileStorageIdentifier;
        this.authenticationHeader = authenticationHeader;
        this.featureSet = new ServerFeatureSet(0, 0, 3, null);
    }

    public /* synthetic */ MultiplayerServer(String string, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        this(string, map2);
    }

    @Nullable
    public final String getFileStorageIdentifier() {
        return this.fileStorageIdentifier;
    }

    @NotNull
    public final ServerFeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public final void setFeatureSet(@NotNull ServerFeatureSet value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!Intrinsics.areEqual(this.featureSet, value)) {
            Object object = UncivGame.Companion.getCurrent().getWorldScreen();
            if (object != null && (object = ((WorldScreen)object).getChatButton$core()) != null) {
                ((ChatButton)object).refreshVisibility();
            }
            this.featureSet = value;
        }
    }

    @NotNull
    public final String getServerUrl() {
        String string = this.fileStorageIdentifier;
        if (string == null) {
            string = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getServer();
        }
        return string;
    }

    @NotNull
    public final FileStorage fileStorage() {
        FileStorage fileStorage;
        Map<String, String> authHeader;
        Map<String, String> map2;
        if (this.authenticationHeader == null) {
            GameSettings.GameSettingsMultiplayer settings = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
            map2 = MapsKt.mapOf(TuplesKt.to("Authorization", settings.getAuthHeader()));
        } else {
            map2 = authHeader = this.authenticationHeader;
        }
        if (Intrinsics.areEqual(this.getServerUrl(), "Dropbox")) {
            fileStorage = DropBox.INSTANCE;
        } else {
            UncivServerFileStorage uncivServerFileStorage;
            UncivServerFileStorage $this$fileStorage_u24lambda_u240 = uncivServerFileStorage = UncivServerFileStorage.INSTANCE;
            boolean bl = false;
            $this$fileStorage_u24lambda_u240.setServerUrl(this.getServerUrl());
            $this$fileStorage_u24lambda_u240.setAuthHeader(authHeader);
            fileStorage = uncivServerFileStorage;
        }
        return fileStorage;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object checkServerStatus(@NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof checkServerStatus.1)) ** GOTO lbl-1000
        var26_2 = $completion;
        if ((var26_2.label & -2147483648) != 0) {
            var26_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                /* synthetic */ Object result;
                final /* synthetic */ MultiplayerServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkServerStatus(this);
                }
            };
        }
        $result = $continuation.result;
        var27_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                server = this.getServerUrl();
                isAliveSuffix = "/isalive";
                var5_7 = UncivKtor.INSTANCE.getClient();
                urlString$iv = server + isAliveSuffix;
                $i$f$get = 0;
                $this$get$iv$iv = $this$get_u24default$iv;
                $i$f$get = 0;
                var11_15 = $this$get$iv$iv;
                $this$get_u24lambda_u244$iv = var12_17 = new HttpRequestBuilder();
                $i$a$-get-BuildersKt$get$5$iv = false;
                HttpRequestKt.url($this$get_u24lambda_u244$iv, urlString$iv);
                var15_21 = $this$get_u24lambda_u244$iv;
                $i$a$-get-BuildersKt$get$4 = false;
                <this> = var15_21;
                $i$f$get = 0;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                $i$f$request = 0;
                $continuation.L$0 = server;
                $continuation.L$1 = isAliveSuffix;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable($this$get_u24default$iv);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable(urlString$iv);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable($this$get$iv$iv);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable($this$get$iv$iv$iv);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable(builder$iv$iv$iv);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable($this$request$iv$iv$iv$iv);
                $continuation.I$0 = $i$f$get;
                $continuation.I$1 = $i$f$get;
                $continuation.I$2 = $i$f$get;
                $continuation.I$3 = $i$f$request;
                $continuation.label = 1;
                v0 = new HttpStatement((HttpRequestBuilder)builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute($continuation);
                if (v0 == var27_4) {
                    return var27_4;
                }
                ** GOTO lbl67
            }
            case 1: {
                $i$f$request = $continuation.I$3;
                $i$f$get = $continuation.I$2;
                $i$f$get = $continuation.I$1;
                $i$f$get = $continuation.I$0;
                $this$request$iv$iv$iv$iv = (HttpClient)$continuation.L$7;
                builder$iv$iv$iv = (HttpRequestBuilder)$continuation.L$6;
                $this$get$iv$iv$iv = (HttpClient)$continuation.L$5;
                $this$get$iv$iv = (HttpClient)$continuation.L$4;
                urlString$iv = (String)$continuation.L$3;
                $this$get_u24default$iv = (HttpClient)$continuation.L$2;
                isAliveSuffix = (String)$continuation.L$1;
                server = (String)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl67:
                // 2 sources

                resp = (HttpResponse)v0;
                if (!HttpStatusCodeKt.isSuccess(resp.getStatus())) break;
                var20_30 = this;
                var23_31 = ServerFeatureSet.class;
                var22_32 = UncivJsonKt.json();
                var21_33 = var20_30;
                $continuation.L$0 = server;
                $continuation.L$1 = isAliveSuffix;
                $continuation.L$2 = resp;
                $continuation.L$3 = var20_30;
                $continuation.L$4 = var21_33;
                $continuation.L$5 = var22_32;
                $continuation.L$6 = var23_31;
                $continuation.L$7 = null;
                $continuation.label = 2;
                v1 = HttpResponseKt.bodyAsText$default(resp, null, $continuation, 1, null);
                ** if (v1 != var27_4) goto lbl87
lbl86:
                // 1 sources

                return var27_4;
lbl87:
                // 1 sources

                ** GOTO lbl100
            }
            case 2: {
                var23_31 = (Class<ServerFeatureSet>)$continuation.L$6;
                var22_32 = (Json)$continuation.L$5;
                var21_33 = (MultiplayerServer)$continuation.L$4;
                var20_30 = (MultiplayerServer)$continuation.L$3;
                resp = (HttpResponse)$continuation.L$2;
                isAliveSuffix = (String)$continuation.L$1;
                server = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v1 = $result;
lbl100:
                    // 2 sources

                    var24_34 = v1;
                    v2 = var21_33;
                    var6_8 = (ServerFeatureSet)var22_32.fromJson(var23_31, (String)var24_34);
                }
                catch (Exception var7_35) {
                    v2 = var20_30;
                    var6_8 = new ServerFeatureSet(0, 0, 3, null);
                }
                $this$get_u24default$iv = var6_8;
                Intrinsics.checkNotNull($this$get_u24default$iv);
                v2.setFeatureSet((ServerFeatureSet)$this$get_u24default$iv);
                multiplayer = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
                if (Intrinsics.areEqual(server, multiplayer.getServer())) {
                    multiplayer.setServer(StringsKt.removeSuffix(HttpResponseKt.getRequest(resp).getUrl().toString(), (CharSequence)isAliveSuffix));
                }
                return Boxing.boxBoolean(true);
            }
        }
        return Boxing.boxBoolean(false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean authenticate(@Nullable String password) {
        if (this.featureSet.getAuthVersion() == 0) {
            return true;
        }
        GameSettings.GameSettingsMultiplayer settings = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
        FileStorage fileStorage = this.fileStorage();
        String string = settings.getUserId();
        String string2 = password;
        if (string2 == null && (string2 = settings.getCurrentServerPassword()) == null) {
            string2 = "";
        }
        boolean success = fileStorage.authenticate(string, string2);
        if (password != null && success) {
            settings.setCurrentServerPassword(password);
        }
        return success;
    }

    public final boolean setPassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter(password, "password");
        if (this.featureSet.getAuthVersion() > 0 && this.fileStorage().setPassword(password)) {
            UncivGame.Companion.getCurrent().getSettings().getMultiplayer().setCurrentServerPassword(password);
            return true;
        }
        return false;
    }

    @Nullable
    public final Object uploadGame(@NotNull GameInfo gameInfo, boolean withPreview, @NotNull Continuation<? super Unit> $completion) {
        String zippedGameInfo = UncivFiles.Companion.gameInfoToString(gameInfo, Boxing.boxBoolean(true), true);
        this.fileStorage().saveFileData(gameInfo.getGameId(), zippedGameInfo);
        if (withPreview) {
            Object object = this.tryUploadGamePreview(gameInfo.asPreview(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object tryUploadGamePreview(@NotNull GameInfoPreview gameInfo, @NotNull Continuation<? super Unit> $completion) {
        String zippedGameInfo = UncivFiles.Companion.gameInfoToString(gameInfo);
        this.fileStorage().saveFileData(gameInfo.getGameId() + "_Preview", zippedGameInfo);
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object tryDownloadGame(@NotNull String gameId, @NotNull Continuation<? super GameInfo> $completion) {
        String zippedGameInfo = this.fileStorage().loadFileData(gameId);
        GameInfo gameInfo = UncivFiles.Companion.gameInfoFromString(zippedGameInfo);
        gameInfo.getGameParameters().setMultiplayerServerUrl(UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getServer());
        return gameInfo;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadGame(@NotNull String gameId, @NotNull Continuation<? super GameInfo> $completion) {
        if (!($completion instanceof downloadGame.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ MultiplayerServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadGame(null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(gameId);
                $continuation.label = 1;
                v0 = this.tryDownloadGame(gameId, $continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                gameId = (String)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                latestGame = (GameInfo)v0;
                latestGame.setUpToDate(true);
                return latestGame;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object tryDownloadGamePreview(@NotNull String gameId, @NotNull Continuation<? super GameInfoPreview> $completion) {
        String zippedGameInfo = this.fileStorage().loadFileData(gameId + "_Preview");
        return UncivFiles.Companion.gameInfoPreviewFromString(zippedGameInfo);
    }

    public MultiplayerServer() {
        this(null, null, 3, null);
    }
}

