/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.UncivShowableException;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.RulesetError;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.translations.TranslationsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0003J7\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J \u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0005H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/unciv/models/ruleset/validation/Suppression;", "", "<init>", "()V", "minimumSelectivity", "", "uniqueDocDescription", "", "parameterDocDescription", "parameterDocExample", "deprecationWarningPattern", "untypedWarningPattern", "isValidFilter", "", "parameterText", "matchesFilter", "error", "Lcom/unciv/models/ruleset/validation/RulesetError;", "filter", "isErrorSuppressed", "globalSuppressionFilters", "", "sourceObject", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "sourceUnique", "Lcom/unciv/models/ruleset/unique/Unique;", "isErrorSuppressed$core", "autoSuppressAllWarnings", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "toModOptions", "Lcom/unciv/models/ruleset/ModOptions;", "hasCommonSubstringLength", "x", "y", "minCommonLength", "core"})
@SourceDebugExtension(value={"SMAP\nSuppression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Suppression.kt\ncom/unciv/models/ruleset/validation/Suppression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1563#2:133\n1634#2,3:134\n1869#2:137\n1869#2,2:138\n1870#2:140\n*S KotlinDebug\n*F\n+ 1 Suppression.kt\ncom/unciv/models/ruleset/validation/Suppression\n*L\n98#1:133\n98#1:134,3\n122#1:137\n124#1:138,2\n122#1:140\n*E\n"})
public final class Suppression {
    @NotNull
    public static final Suppression INSTANCE = new Suppression();
    private static final int minimumSelectivity = 12;
    @NotNull
    public static final String uniqueDocDescription = "Allows suppressing specific validation warnings. Errors, deprecation warnings, or warnings about untyped and non-filtering uniques should be heeded, not suppressed, and are therefore not accepted. Note that this can be used in ModOptions, in the uniques a warning is about, or as modifier on the unique triggering a warning - but you still need to be specific. Even in the modifier case you will need to specify a sufficiently selective portion of the warning text as parameter.";
    @NotNull
    public static final String parameterDocDescription = "Suppresses one specific Ruleset validation warning. This can specify the full text verbatim including correct upper/lower case, or it can be a wildcard case-insensitive simple pattern starting and ending in an asterisk ('*'). If the suppression unique is used within an object or as modifier (not ModOptions), the wildcard symbols can be omitted, as selectivity is better due to the limited scope.";
    @NotNull
    public static final String parameterDocExample = "Tinman is supposed to automatically upgrade at tech Clockwork, and therefore Servos for its upgrade Mecha may not yet be researched! -or- *is supposed to automatically upgrade*";
    @NotNull
    private static final String deprecationWarningPattern = "unique \"~\" is deprecated as of ~, replace with";
    @NotNull
    private static final String untypedWarningPattern = "unique \"~\" not found in Unciv's unique types, and is not used as a filtering unique";

    private Suppression() {
    }

    @Pure
    public final boolean isValidFilter(@NotNull String parameterText) {
        Intrinsics.checkNotNullParameter(parameterText, "parameterText");
        return StringsKt.contains$default((CharSequence)parameterText, '{', false, 2, null) || StringsKt.contains$default((CharSequence)parameterText, '<', false, 2, null) ? false : (this.hasCommonSubstringLength(parameterText, deprecationWarningPattern, 12) ? false : (this.hasCommonSubstringLength(parameterText, untypedWarningPattern, 12) ? false : (StringsKt.startsWith$default((CharSequence)parameterText, '*', false, 2, null) != StringsKt.endsWith$default((CharSequence)parameterText, '*', false, 2, null) ? false : parameterText.length() >= 14)));
    }

    @Pure
    private final boolean matchesFilter(RulesetError error2, String filter2) {
        if (Intrinsics.areEqual(error2.getText(), filter2)) {
            return true;
        }
        if (!StringsKt.endsWith$default((CharSequence)filter2, '*', false, 2, null) || !StringsKt.startsWith$default((CharSequence)filter2, '*', false, 2, null)) {
            return false;
        }
        return StringsKt.contains((CharSequence)error2.getText(), StringsKt.removeSurrounding(filter2, (CharSequence)"*", (CharSequence)"*"), true);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final boolean isErrorSuppressed$core(@NotNull Collection<String> globalSuppressionFilters, @Nullable IHasUniques sourceObject, @Nullable Unique sourceUnique, @NotNull RulesetError error2) {
        Object object;
        Intrinsics.checkNotNullParameter(globalSuppressionFilters, "globalSuppressionFilters");
        Intrinsics.checkNotNullParameter(error2, "error");
        if (error2.getErrorSeverityToReport().compareTo((Enum)RulesetErrorSeverity.Error) >= 0) {
            return false;
        }
        if (sourceObject == null && globalSuppressionFilters.isEmpty()) {
            return false;
        }
        Sequence<Object> suppressions = CollectionsKt.asSequence((Iterable)globalSuppressionFilters);
        if (sourceObject != null) {
            suppressions = SequencesKt.plus(suppressions, SequencesKt.map(sourceObject.getMatchingUniques(UniqueType.SuppressWarnings, GameContext.Companion.getIgnoreConditionals()), Suppression::isErrorSuppressed$lambda$1));
        }
        if (sourceUnique != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = sourceUnique.getModifiers(UniqueType.SuppressWarnings);
            Sequence sequence = suppressions;
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Unique unique = (Unique)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Suppression.isErrorSuppressed$getWildcardFilter((Unique)it));
            }
            suppressions = SequencesKt.plus(sequence, (List)destination$iv$iv);
        }
        object = suppressions.iterator();
        while (object.hasNext()) {
            String filter2 = (String)object.next();
            if (!this.matchesFilter(error2, filter2)) continue;
            return true;
        }
        return false;
    }

    public final void autoSuppressAllWarnings(@NotNull Ruleset ruleset, @NotNull ModOptions toModOptions) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(toModOptions, "toModOptions");
        if (ruleset.getFolderLocation() == null) {
            throw new UncivShowableException("autoSuppressAllWarnings needs Ruleset.folderLocation", null, 2, null);
        }
        Iterator iterator2 = RulesetValidator.Companion.create$default(RulesetValidator.Companion, ruleset, false, 2, null).getErrorList().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            RulesetError error2 = (RulesetError)e;
            if (error2.getErrorSeverityToReport().compareTo((Enum)RulesetErrorSeverity.Error) >= 0) continue;
            Collection collection = toModOptions.getUniques();
            String[] stringArray = new String[]{error2.getText()};
            collection.add(TranslationsKt.fillPlaceholders(UniqueType.SuppressWarnings.getText(), stringArray));
        }
        Json json = UncivJsonKt.json();
        FileHandle fileHandle = ruleset.getFolderLocation();
        Intrinsics.checkNotNull(fileHandle);
        json.toJson((Object)toModOptions, fileHandle.child("jsons/ModOptions.json"));
    }

    @Pure
    private final boolean hasCommonSubstringLength(String x, String y, int minCommonLength) {
        Iterable $this$forEach$iv = RangesKt.until(0, x.length() - minCommonLength);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int xIndex = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(x.substring(xIndex), "substring(...)");
            Iterable $this$forEach$iv2 = RangesKt.until(0, y.length() - minCommonLength);
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                String xSub;
                int element$iv2;
                int yIndex = element$iv2 = ((IntIterator)iterator3).nextInt();
                boolean bl2 = false;
                CharSequence charSequence = xSub;
                String string = y.substring(yIndex);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                if (StringsKt.commonPrefixWith(charSequence, string, true).length() < minCommonLength) continue;
                return true;
            }
        }
        return false;
    }

    @Readonly
    private static final String isErrorSuppressed$getWildcardFilter(Unique unique) {
        String it = unique.getParams().get(0);
        boolean bl = false;
        return StringsKt.startsWith$default((CharSequence)it, '*', false, 2, null) ? it : '*' + it + '*';
    }

    private static final String isErrorSuppressed$lambda$1(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Suppression.isErrorSuppressed$getWildcardFilter(it);
    }
}

