/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.fonts;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.components.MayaCalendar;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.FontFamilyData;
import com.unciv.ui.components.fonts.FontImplementation;
import com.unciv.ui.components.fonts.FontMetricsCommon;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b \n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010 \u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020!X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b/\u0010\u0003R\u0014\u00100\u001a\u00020!X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b1\u0010\u0003R\u0014\u00102\u001a\u00020!X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b3\u0010\u0003R\u0014\u00104\u001a\u00020!X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b5\u0010\u0003R\u0014\u00106\u001a\u00020!X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b7\u0010\u0003R\u000e\u00108\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010A\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00070B\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010D\u00a8\u0006E"}, d2={"Lcom/unciv/ui/components/fonts/Fonts;", "", "<init>", "()V", "ORIGINAL_FONT_SIZE", "", "DEFAULT_FONT_FAMILY", "", "fontImplementation", "Lcom/unciv/ui/components/fonts/FontImplementation;", "getFontImplementation", "()Lcom/unciv/ui/components/fonts/FontImplementation;", "setFontImplementation", "(Lcom/unciv/ui/components/fonts/FontImplementation;)V", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "setFont", "(Lcom/badlogic/gdx/graphics/g2d/BitmapFont;)V", "resetFont", "", "getSystemFonts", "Lkotlin/sequences/Sequence;", "Lcom/unciv/ui/components/fonts/FontFamilyData;", "getDescenderHeight", "fontSize", "", "extractPixmapFromTextureRegion", "Lcom/badlogic/gdx/graphics/Pixmap;", "textureRegion", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "turn", "", "strength", "rangedStrength", "movement", "range", "health", "production", "gold", "food", "science", "culture", "happiness", "faith", "greatArtist", "getGreatArtist$annotations", "greatEngineer", "getGreatEngineer$annotations", "greatGeneral", "getGreatGeneral$annotations", "greatMerchant", "getGreatMerchant$annotations", "greatScientist", "getGreatScientist$annotations", "death", "automate", "infinity", "clock", "star", "status", "sortUpArrow", "sortDownArrow", "rightArrow", "allSymbols", "", "getAllSymbols", "()Ljava/util/Map;", "core"})
public final class Fonts {
    @NotNull
    public static final Fonts INSTANCE = new Fonts();
    public static final float ORIGINAL_FONT_SIZE = 100.0f;
    @NotNull
    public static final String DEFAULT_FONT_FAMILY = "";
    public static FontImplementation fontImplementation;
    public static BitmapFont font;
    public static final char turn = '\u23f3';
    public static final char strength = '\u2020';
    public static final char rangedStrength = '\u2021';
    public static final char movement = '\u27a1';
    public static final char range = '\u2026';
    public static final char health = '\u2661';
    public static final char production = '\u2699';
    public static final char gold = '\u00a4';
    public static final char food = '\u2042';
    public static final char science = '\u237e';
    public static final char culture = '\u266a';
    public static final char happiness = '\u2323';
    public static final char faith = '\u262e';
    public static final char greatArtist = '\u266c';
    public static final char greatEngineer = '\u2692';
    public static final char greatGeneral = '\u26e4';
    public static final char greatMerchant = '\u2696';
    public static final char greatScientist = '\u269b';
    public static final char death = '\u2620';
    public static final char automate = '\u26cf';
    public static final char infinity = '\u221e';
    public static final char clock = '\u231a';
    public static final char star = '\u272f';
    public static final char status = '\u25c9';
    public static final char sortUpArrow = '\uffea';
    public static final char sortDownArrow = '\uffec';
    public static final char rightArrow = '\u2192';
    @NotNull
    private static final Map<Character, String> allSymbols;

    private Fonts() {
    }

    @NotNull
    public final FontImplementation getFontImplementation() {
        FontImplementation fontImplementation = Fonts.fontImplementation;
        if (fontImplementation != null) {
            return fontImplementation;
        }
        Intrinsics.throwUninitializedPropertyAccessException("fontImplementation");
        return null;
    }

    public final void setFontImplementation(@NotNull FontImplementation fontImplementation) {
        Intrinsics.checkNotNullParameter(fontImplementation, "<set-?>");
        Fonts.fontImplementation = fontImplementation;
    }

    @NotNull
    public final BitmapFont getFont() {
        BitmapFont bitmapFont = font;
        if (bitmapFont != null) {
            return bitmapFont;
        }
        Intrinsics.throwUninitializedPropertyAccessException("font");
        return null;
    }

    public final void setFont(@NotNull BitmapFont bitmapFont) {
        Intrinsics.checkNotNullParameter(bitmapFont, "<set-?>");
        font = bitmapFont;
    }

    public final void resetFont() {
        GameSettings settings = GUI.INSTANCE.getSettings();
        this.getFontImplementation().setFontFamily(settings.getFontFamilyData(), settings.getFontSize());
        this.setFont(this.getFontImplementation().getBitmapFont());
        this.getFont().getData().markupEnabled = true;
    }

    @NotNull
    public final Sequence<FontFamilyData> getSystemFonts() {
        Comparator comparator = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        return SequencesKt.sortedWith(this.getFontImplementation().getSystemFonts(), new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                FontFamilyData fontFamilyData = (FontFamilyData)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                FontFamilyData it = (FontFamilyData)b;
                String string = it.getLocalName();
                bl = false;
                String string2 = it.getLocalName();
                return comparator.compare(string, string2);
            }
        });
    }

    public final float getDescenderHeight(int fontSize) {
        FontMetricsCommon $this$getDescenderHeight_u24lambda_u240 = this.getFontImplementation().getMetrics();
        boolean bl = false;
        float ratio = $this$getDescenderHeight_u24lambda_u240.getDescent() / $this$getDescenderHeight_u24lambda_u240.getHeight();
        return ratio * (float)fontSize + 2.25f;
    }

    @NotNull
    public final Pixmap extractPixmapFromTextureRegion(@NotNull TextureRegion textureRegion) {
        Intrinsics.checkNotNullParameter(textureRegion, "textureRegion");
        FontMetricsCommon metrics = this.getFontImplementation().getMetrics();
        int boxHeight = (int)Math.ceil(metrics.getHeight());
        int boxWidth = (int)Math.ceil(metrics.getAscent() * (float)textureRegion.getRegionWidth() / (float)textureRegion.getRegionHeight());
        int drawHeight = (2 * textureRegion.getRegionHeight() * boxWidth + 1) / textureRegion.getRegionWidth() / 2;
        int drawY = (int)Math.ceil(metrics.getLeading() + metrics.getDescent() * 0.5f);
        TextureData textureData = textureRegion.getTexture().getTextureData();
        Intrinsics.checkNotNull(textureData);
        Pixmap textureDataPixmap = Scene2dExtensionsKt.getReadonlyPixmap(textureData);
        Pixmap pixmap = new Pixmap(boxWidth, boxHeight, textureData.getFormat());
        pixmap.drawPixmap(textureDataPixmap, textureRegion.getRegionX(), textureRegion.getRegionY(), textureRegion.getRegionWidth(), textureRegion.getRegionHeight(), 0, drawY, boxWidth, drawHeight);
        return pixmap;
    }

    public static /* synthetic */ void getGreatArtist$annotations() {
    }

    public static /* synthetic */ void getGreatEngineer$annotations() {
    }

    public static /* synthetic */ void getGreatGeneral$annotations() {
    }

    public static /* synthetic */ void getGreatMerchant$annotations() {
    }

    public static /* synthetic */ void getGreatScientist$annotations() {
    }

    @NotNull
    public final Map<Character, String> getAllSymbols() {
        return allSymbols;
    }

    static {
        SpreadBuilder spreadBuilder = new SpreadBuilder(27);
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u23f3'), "EmojiIcons/Turn"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2020'), "StatIcons/Strength"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2021'), "StatIcons/RangedStrength"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2026'), "StatIcons/Range"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u27a1'), "StatIcons/Movement"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2699'), "EmojiIcons/Production"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u00a4'), "EmojiIcons/Gold"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2042'), "EmojiIcons/Food"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u237e'), "EmojiIcons/Science"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u266a'), "EmojiIcons/Culture"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2323'), "EmojiIcons/Happiness"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u262e'), "EmojiIcons/Faith"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u266c'), "EmojiIcons/Great Artist"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2692'), "EmojiIcons/Great Engineer"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u26e4'), "EmojiIcons/Great General"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2696'), "EmojiIcons/Great Merchant"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u269b'), "EmojiIcons/Great Scientist"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2620'), "EmojiIcons/Death"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u26cf'), "EmojiIcons/Automate"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u221e'), "EmojiIcons/Infinity"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u231a'), "EmojiIcons/SortedByTime"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u272f'), "EmojiIcons/Star"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u25c9'), "EmojiIcons/SortedByStatus"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\uffea'), "EmojiIcons/SortedAscending"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\uffec'), "EmojiIcons/SortedDescending"));
        spreadBuilder.add(TuplesKt.to(Character.valueOf('\u2192'), "EmojiIcons/RightArrow"));
        spreadBuilder.addSpread(MayaCalendar.INSTANCE.getAllSymbols());
        allSymbols = MapsKt.mapOf((Pair[])spreadBuilder.toArray(new Pair[spreadBuilder.size()]));
    }
}

