/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.citybutton;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.BorderedTable;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/components/tilegroups/citybutton/DefenceTable;", "Lcom/unciv/ui/components/widgets/BorderedTable;", "city", "Lcom/unciv/logic/city/City;", "selectedCiv", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/civilization/Civilization;)V", "core"})
public final class DefenceTable
extends BorderedTable {
    public DefenceTable(@NotNull City city, @NotNull Civilization selectedCiv) {
        Color color;
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(selectedCiv, "selectedCiv");
        super("WorldScreen/CityButton/DefenceTable", BaseScreen.Companion.getSkinStrings().getRoundedTopEdgeRectangleSmallShape(), BaseScreen.Companion.getSkinStrings().getRoundedTopEdgeRectangleSmallBorderShape());
        this.pad(2.0f, 3.0f, 0.0f, 3.0f);
        this.setBorderSize(4.0f);
        this.setBgColor(ImageGetter.INSTANCE.getCHARCOAL());
        if (Intrinsics.areEqual(city.getCiv(), selectedCiv)) {
            color = Scene2dExtensionsKt.colorFromRGB(255, 237, 200);
        } else if (city.getCiv().isAtWarWith(selectedCiv)) {
            Color color2 = Color.RED;
            color = color2;
            Intrinsics.checkNotNullExpressionValue(color2, "RED");
        } else {
            color = ImageGetter.INSTANCE.getCHARCOAL();
        }
        this.setBgBorderColor(color);
        int cityStrength = ICombatant.getDefendingStrength$default(new CityCombatant(city), null, 1, null);
        Label cityStrengthLabel = Scene2dExtensionsKt.toLabel$default("" + '\u2020' + cityStrength, null, 12, 1, false, 9, null);
        this.add((Actor)cityStrengthLabel).grow().center();
    }
}

