/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u000fH\u0002J(\u0010#\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00132\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020%0\u001aj\b\u0012\u0004\u0012\u00020%`\u001cH\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u0018X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lcom/unciv/ui/screens/overviewscreen/NotificationsOverviewTable;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "persistedData", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;)V", "persistableData", "Lcom/unciv/ui/screens/overviewscreen/NotificationsOverviewTable$NotificationsTabPersistableData;", "getPersistableData", "()Lcom/unciv/ui/screens/overviewscreen/NotificationsOverviewTable$NotificationsTabPersistableData;", "activated", "", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "deactivated", "stageWidth", "", "notificationLog", "Ljava/util/ArrayList;", "Lcom/unciv/logic/civilization/Civilization$NotificationsLog;", "Lkotlin/collections/ArrayList;", "notificationTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "iconSize", "getIconSize", "()F", "generateNotificationTable", "notificationsArrayTable", "notifications", "Lcom/unciv/logic/civilization/Notification;", "NotificationsTabPersistableData", "core"})
@SourceDebugExtension(value={"SMAP\nNotificationsOverviewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/NotificationsOverviewTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n774#2:108\n865#2,2:109\n1#3:111\n*S KotlinDebug\n*F\n+ 1 NotificationsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/NotificationsOverviewTable\n*L\n79#1:108\n79#1:109,2\n*E\n"})
public final class NotificationsOverviewTable
extends EmpireOverviewTab {
    @NotNull
    private final NotificationsTabPersistableData persistableData;
    private final float stageWidth;
    @NotNull
    private final ArrayList<Civilization.NotificationsLog> notificationLog;
    @NotNull
    private final Table notificationTable;
    private final float iconSize;

    public NotificationsOverviewTable(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen, @Nullable EmpireOverviewTab.EmpireOverviewTabPersistableData persistedData) {
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        NotificationsTabPersistableData notificationsTabPersistableData = persistedData instanceof NotificationsTabPersistableData ? (NotificationsTabPersistableData)persistedData : null;
        if (notificationsTabPersistableData == null) {
            notificationsTabPersistableData = new NotificationsTabPersistableData(null, 1, null);
        }
        this.persistableData = notificationsTabPersistableData;
        this.stageWidth = overviewScreen.getStage().getWidth();
        this.notificationLog = viewingPlayer.getNotificationsLog();
        this.notificationTable = new Table(BaseScreen.Companion.getSkin());
        this.iconSize = 20.0f;
        float tablePadding = 30.0f;
        this.defaults().pad(tablePadding).top();
        this.generateNotificationTable();
        this.add((Actor)this.notificationTable);
    }

    public /* synthetic */ NotificationsOverviewTable(Civilization civilization, EmpireOverviewScreen empireOverviewScreen, EmpireOverviewTab.EmpireOverviewTabPersistableData empireOverviewTabPersistableData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            empireOverviewTabPersistableData = null;
        }
        this(civilization, empireOverviewScreen, empireOverviewTabPersistableData);
    }

    @Override
    @NotNull
    public NotificationsTabPersistableData getPersistableData() {
        return this.persistableData;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        if (this.getPersistableData().getScrollY() != null) {
            Float f = this.getPersistableData().getScrollY();
            Intrinsics.checkNotNull(f);
            TabbedPager.setPageScrollY$default(pager, index, f.floatValue(), false, 4, null);
        }
        super.activated(index, caption, pager);
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.getPersistableData().setScrollY(Float.valueOf(pager.getPageScrollY(index)));
    }

    public final float getIconSize() {
        return this.iconSize;
    }

    private final void generateNotificationTable() {
        if (!((Collection)this.getViewingPlayer().getNotifications()).isEmpty()) {
            this.notificationTable.add((Actor)this.notificationsArrayTable("Current", this.getViewingPlayer().getNotifications())).row();
        }
        for (Civilization.NotificationsLog notification : CollectionsKt.asReversedMutable((List)this.notificationLog)) {
            this.notificationTable.add((Actor)this.notificationsArrayTable(TranslationsKt.tr(notification.getTurn()), notification.getNotifications()));
            this.notificationTable.padTop(20.0f).row();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Table notificationsArrayTable(String index, ArrayList<Notification> notifications) {
        void $this$notificationsArrayTable_u24lambda_u240;
        Table turnTable = new Table(BaseScreen.Companion.getSkin());
        Label turnLabel = !Intrinsics.areEqual(index, "Current") ? Scene2dExtensionsKt.toLabel("Turn [" + index + ']') : Scene2dExtensionsKt.toLabel("Current turn");
        Table table2 = new Table();
        Table table3 = table2;
        Table table4 = turnTable;
        boolean bl = false;
        $this$notificationsArrayTable_u24lambda_u240.add((Actor)ImageGetter.INSTANCE.getWhiteDot()).minHeight(2.0f).width(this.stageWidth / (float)4);
        $this$notificationsArrayTable_u24lambda_u240.add((Actor)turnLabel).pad(3.0f);
        $this$notificationsArrayTable_u24lambda_u240.add((Actor)ImageGetter.INSTANCE.getWhiteDot()).minHeight(2.0f).width(this.stageWidth / (float)4);
        table4.add((Actor)table2).row();
        for (Notification.NotificationCategory category : Notification.NotificationCategory.getEntries()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = notifications;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Notification it = (Notification)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getCategory() == category)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List categoryNotifications = (List)destination$iv$iv;
            if (categoryNotifications.isEmpty()) continue;
            if (category != Notification.NotificationCategory.General) {
                turnTable.add((Actor)Scene2dExtensionsKt.toLabel(category.name())).pad(3.0f).row();
            }
            for (Notification notification : categoryNotifications) {
                ColorMarkupLabel colorMarkupLabel;
                Table notificationTable = new Table(BaseScreen.Companion.getSkin());
                ColorMarkupLabel $this$notificationsArrayTable_u24lambda_u242 = colorMarkupLabel = new ColorMarkupLabel(notification.getText(), ImageGetter.INSTANCE.getCHARCOAL(), null, 20, 4, null);
                boolean bl3 = false;
                $this$notificationsArrayTable_u24lambda_u242.setWrap(true);
                ColorMarkupLabel label = colorMarkupLabel;
                notificationTable.add((Actor)label).width(this.stageWidth / (float)2 - this.iconSize * (float)notification.getIcons().size());
                notificationTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/NotificationOverviewTable/Notification", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), null, 4, null));
                notificationTable.setTouchable(Touchable.enabled);
                if (!((Collection)notification.getActions()).isEmpty()) {
                    ActivationExtensionsKt.onClick(notificationTable, () -> NotificationsOverviewTable.notificationsArrayTable$lambda$3(this, notification));
                }
                notification.addNotificationIconsTo(notificationTable, this.getGameInfo().getRuleset(), this.iconSize);
                turnTable.add((Actor)notificationTable).padTop(5.0f);
                turnTable.padTop(20.0f).row();
            }
        }
        turnTable.padTop(20.0f).row();
        return turnTable;
    }

    private static final Unit notificationsArrayTable$lambda$3(NotificationsOverviewTable this$0, Notification $notification) {
        this$0.getOverviewScreen().showOneTimeNotification$core($notification);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/overviewscreen/NotificationsOverviewTable$NotificationsTabPersistableData;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "scrollY", "", "<init>", "(Ljava/lang/Float;)V", "getScrollY", "()Ljava/lang/Float;", "setScrollY", "Ljava/lang/Float;", "core"})
    public static final class NotificationsTabPersistableData
    extends EmpireOverviewTab.EmpireOverviewTabPersistableData {
        @Nullable
        private Float scrollY;

        public NotificationsTabPersistableData(@Nullable Float scrollY) {
            this.scrollY = scrollY;
        }

        public /* synthetic */ NotificationsTabPersistableData(Float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = null;
            }
            this(f);
        }

        @Nullable
        public final Float getScrollY() {
            return this.scrollY;
        }

        public final void setScrollY(@Nullable Float f) {
            this.scrollY = f;
        }

        public NotificationsTabPersistableData() {
            this(null, 1, null);
        }
    }
}

