/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import kotlinx.io.bytestring.unsafe.UnsafeByteStringOperations;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\t\u001a\u0012\u0010\b\u001a\u00020\u0004*\u00020\t2\u0006\u0010\n\u001a\u00020\u0006\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\f\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"write", "", "Lkotlinx/io/Sink;", "byteString", "Lkotlinx/io/bytestring/ByteString;", "startIndex", "", "endIndex", "readByteString", "Lkotlinx/io/Source;", "byteCount", "indexOf", "", "Lkotlinx/io/Buffer;", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nByteStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 Sinks.kt\nkotlinx/io/SinksKt\n+ 4 UnsafeByteStringOperations.kt\nkotlinx/io/bytestring/unsafe/UnsafeByteStringOperations\n+ 5 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 6 Buffer.kt\nkotlinx/io/BufferKt\n*L\n1#1,183:1\n38#2:184\n374#3:185\n375#3,2:216\n42#4:186\n43#4:215\n42#4:218\n43#4:244\n195#5,28:187\n659#6,25:219\n*S KotlinDebug\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n*L\n32#1:184\n37#1:185\n37#1:216,2\n40#1:186\n40#1:215\n144#1:218\n144#1:244\n43#1:187,28\n145#1:219,25\n*E\n"})
public final class ByteStringsKt {
    /*
     * WARNING - void declaration
     */
    public static final void write(@NotNull Sink $this$write, @NotNull ByteString byteString, int startIndex, int endIndex) {
        int written2;
        Intrinsics.checkNotNullParameter($this$write, "<this>");
        Intrinsics.checkNotNullParameter(byteString, "byteString");
        int size$iv = byteString.getSize();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        if (endIndex == startIndex) {
            return;
        }
        Sink $this$writeToInternalBuffer$iv = $this$write;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer buffer = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        int offset = 0;
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] data = byteString.getBackingArrayReference();
        boolean bl2 = false;
        for (offset = startIndex; offset < endIndex; offset += written2) {
            void pos;
            void limit;
            written2 = 0;
            UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
            int minimumCapacity$iv = 1;
            boolean $i$f$writeToTail = false;
            Segment tail$iv = buffer.writableSegment(minimumCapacity$iv);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int n = data$iv.length;
            int n2 = tail$iv.getLimit();
            byte[] segData = data$iv;
            boolean bl3 = false;
            written2 = Math.min(endIndex - offset, (int)(limit - pos));
            ArraysKt.copyInto(data, segData, (int)pos, offset, offset + written2);
            int bytesWritten$iv = written2;
            if (bytesWritten$iv == minimumCapacity$iv) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl4 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!SegmentKt.isEmpty(tail$iv)) continue;
            buffer.recycleTail();
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static /* synthetic */ void write$default(Sink sink, ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteString.getSize();
        }
        ByteStringsKt.write(sink, byteString, n, n2);
    }

    @NotNull
    public static final ByteString readByteString(@NotNull Source $this$readByteString) {
        Intrinsics.checkNotNullParameter($this$readByteString, "<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray($this$readByteString));
    }

    @NotNull
    public static final ByteString readByteString(@NotNull Source $this$readByteString, int byteCount) {
        Intrinsics.checkNotNullParameter($this$readByteString, "<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray($this$readByteString, byteCount));
    }

    public static final long indexOf(@NotNull Source $this$indexOf, @NotNull ByteString byteString, long startIndex) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        Intrinsics.checkNotNullParameter(byteString, "byteString");
        long startIndex2 = Math.max(0L, startIndex);
        if (ByteStringKt.isEmpty(byteString)) {
            $this$indexOf.request(startIndex2);
            return Math.min(startIndex2, $this$indexOf.getBuffer().getSize());
        }
        long offset = startIndex2;
        while ($this$indexOf.request(offset + (long)byteString.getSize())) {
            long idx = ByteStringsKt.indexOf($this$indexOf.getBuffer(), byteString, offset);
            if (idx < 0L) {
                offset = $this$indexOf.getBuffer().getSize() - (long)byteString.getSize() + 1L;
                continue;
            }
            return idx;
        }
        return -1L;
    }

    public static /* synthetic */ long indexOf$default(Source source, ByteString byteString, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return ByteStringsKt.indexOf(source, byteString, l);
    }

    /*
     * WARNING - void declaration
     */
    public static final long indexOf(@NotNull Buffer $this$indexOf, @NotNull ByteString byteString, long startIndex) {
        long nextOffset$iv;
        Segment s$iv;
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        Intrinsics.checkNotNullParameter(byteString, "byteString");
        long startIndex2 = Math.max(0L, Math.min(startIndex, $this$indexOf.getSize()));
        if (ByteStringKt.isEmpty(byteString)) {
            return startIndex2;
        }
        if (startIndex2 > $this$indexOf.getSize() - (long)byteString.getSize()) {
            return -1L;
        }
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] byteStringData = byteString.getBackingArrayReference();
        boolean bl = false;
        Buffer $this$seek$iv = $this$indexOf;
        boolean $i$f$seek = false;
        if ($this$seek$iv.getHead() == null) {
            void o;
            long l = -1L;
            Segment seg = null;
            boolean bl2 = false;
            if (o == -1L) {
                return -1L;
            }
            Segment segment = seg;
            void offset = o;
            do {
                Intrinsics.checkNotNull(segment);
                int startOffset = Math.max((int)(startIndex2 - offset), 0);
                int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
                if (idx != -1) {
                    return (long)(offset + (long)idx);
                }
                int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
                int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
                if (idx1 == -1) continue;
                return (long)(offset + (long)idx1);
            } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
            return -1L;
        }
        if ($this$seek$iv.getSize() - startIndex2 < startIndex2) {
            Segment s$iv2;
            long offset$iv = $this$seek$iv.getSize();
            for (s$iv2 = $this$seek$iv.getTail(); s$iv2 != null && offset$iv > startIndex2 && (offset$iv -= (long)(s$iv2.getLimit() - s$iv2.getPos())) > startIndex2; s$iv2 = s$iv2.getPrev()) {
            }
            long o = offset$iv;
            Segment seg = s$iv2;
            boolean bl3 = false;
            if (o == -1L) {
                return -1L;
            }
            Segment segment = seg;
            long offset = o;
            do {
                Intrinsics.checkNotNull(segment);
                int startOffset = Math.max((int)(startIndex2 - offset), 0);
                int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
                if (idx != -1) {
                    return offset + (long)idx;
                }
                int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
                int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
                if (idx1 == -1) continue;
                return offset + (long)idx1;
            } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
            return -1L;
        }
        long offset$iv = 0L;
        for (s$iv = $this$seek$iv.getHead(); s$iv != null && (nextOffset$iv = offset$iv + (long)(s$iv.getLimit() - s$iv.getPos())) <= startIndex2; s$iv = s$iv.getNext()) {
            offset$iv = nextOffset$iv;
        }
        long o = offset$iv;
        Segment seg = s$iv;
        boolean bl4 = false;
        if (o == -1L) {
            return -1L;
        }
        Segment segment = seg;
        long offset = o;
        do {
            Intrinsics.checkNotNull(segment);
            int startOffset = Math.max((int)(startIndex2 - offset), 0);
            int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
            if (idx != -1) {
                return offset + (long)idx;
            }
            int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
            int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
            if (idx1 == -1) continue;
            return offset + (long)idx1;
        } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
        return -1L;
    }

    public static /* synthetic */ long indexOf$default(Buffer buffer, ByteString byteString, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return ByteStringsKt.indexOf(buffer, byteString, l);
    }
}

