/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.flame;

import com.badlogic.gdx.graphics.g3d.particles.batches.PointSpriteParticleBatch;
import com.badlogic.gdx.tools.flame.BlendFunction;
import com.badlogic.gdx.tools.flame.EditorPanel;
import com.badlogic.gdx.tools.flame.FlameMain;
import com.badlogic.gdx.tools.flame.SortMode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class PointSpriteBatchPanel
extends EditorPanel<PointSpriteParticleBatch> {
    JComboBox sortCombo;
    JComboBox srcBlendFunction;
    JComboBox destBlendFunction;

    public PointSpriteBatchPanel(FlameMain particleEditor3D, PointSpriteParticleBatch renderer) {
        super(particleEditor3D, "Point sprite Batch", "Renderer used to draw point sprite particles.");
        this.initializeComponents(renderer);
        this.setValue(renderer);
    }

    private void initializeComponents(PointSpriteParticleBatch renderer) {
        this.sortCombo = new JComboBox();
        this.sortCombo.setModel(new DefaultComboBoxModel<SortMode>(SortMode.values()));
        this.sortCombo.setSelectedItem((Object)SortMode.find(renderer.getSorter()));
        this.sortCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SortMode mode = (SortMode)((Object)PointSpriteBatchPanel.this.sortCombo.getSelectedItem());
                PointSpriteBatchPanel.this.editor.getPointSpriteBatch().setSorter(mode.sorter);
            }
        });
        this.srcBlendFunction = new JComboBox();
        this.srcBlendFunction.setModel(new DefaultComboBoxModel<BlendFunction>(BlendFunction.values()));
        this.srcBlendFunction.setSelectedItem((Object)BlendFunction.find(renderer.getBlendingAttribute().sourceFunction));
        this.srcBlendFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BlendFunction blend = (BlendFunction)((Object)PointSpriteBatchPanel.this.srcBlendFunction.getSelectedItem());
                PointSpriteBatchPanel.this.editor.getPointSpriteBatch().getBlendingAttribute().sourceFunction = blend.blend;
            }
        });
        this.destBlendFunction = new JComboBox();
        this.destBlendFunction.setModel(new DefaultComboBoxModel<BlendFunction>(BlendFunction.values()));
        this.destBlendFunction.setSelectedItem((Object)BlendFunction.find(renderer.getBlendingAttribute().destFunction));
        this.destBlendFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BlendFunction blend = (BlendFunction)((Object)PointSpriteBatchPanel.this.destBlendFunction.getSelectedItem());
                PointSpriteBatchPanel.this.editor.getPointSpriteBatch().getBlendingAttribute().destFunction = blend.blend;
            }
        });
        int i = 0;
        Insets insets = new Insets(3, 0, 0, 0);
        this.contentPanel.add((Component)new JLabel("Sort"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)this.sortCombo, new GridBagConstraints(1, i++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)new JLabel("Blending Src"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)this.srcBlendFunction, new GridBagConstraints(1, i++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)new JLabel("Blending Dest"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)this.destBlendFunction, new GridBagConstraints(1, i++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
    }
}

