/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.AStar;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.utils.Log;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0007J(\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0007J\u0082\u0001\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u00182\u001e\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0018H\u0003J\u0086\u0001\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u00162 \b\u0002\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u00182 \b\u0002\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0018H\u0007\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/map/MapPathing;", "", "<init>", "()V", "roadPreferredMovementCost", "", "civ", "Lcom/unciv/logic/civilization/Civilization;", "from", "Lcom/unciv/logic/map/tile/Tile;", "to", "isValidRoadPathTile", "", "tile", "getRoadPath", "", "startTile", "endTile", "getPath", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "predicate", "Lkotlin/Function2;", "cost", "Lkotlin/Function3;", "heuristic", "getConnection", "core"})
public final class MapPathing {
    @NotNull
    public static final MapPathing INSTANCE = new MapPathing();

    private MapPathing() {
    }

    @Readonly
    private final float roadPreferredMovementCost(Civilization civ, Tile from, Tile to) {
        if (to.hasRoadConnection(civ, false) || to.hasRailroadConnection(false)) {
            return 0.5f;
        }
        return 1.0f;
    }

    @Readonly
    public final boolean isValidRoadPathTile(@NotNull Civilization civ, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(tile, "tile");
        TileImprovement roadImprovement = tile.getRuleset().getRoadImprovement();
        TileImprovement railRoadImprovement = tile.getRuleset().getRailroadImprovement();
        if (tile.isWater()) {
            return false;
        }
        if (tile.isImpassible()) {
            return false;
        }
        if (!civ.hasExplored(tile)) {
            return false;
        }
        if (!tile.canCivPassThrough(civ)) {
            return false;
        }
        return tile.hasRoadConnection(civ, false) || tile.hasRailroadConnection(false) || roadImprovement != null && tile.getImprovementFunctions().canBuildImprovement(roadImprovement, civ.getState()) || railRoadImprovement != null && tile.getImprovementFunctions().canBuildImprovement(railRoadImprovement, civ.getState());
    }

    @Readonly
    @Nullable
    public final List<Tile> getRoadPath(@NotNull Civilization civ, @NotNull Tile startTile, @NotNull Tile endTile) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(startTile, "startTile");
        Intrinsics.checkNotNullParameter(endTile, "endTile");
        return this.getConnection(civ, startTile, endTile, (Function2<? super Civilization, ? super Tile, Boolean>)new Function2<Civilization, Tile, Boolean>((Object)this){

            public final Boolean invoke(Civilization p0, Tile p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((MapPathing)this.receiver).isValidRoadPathTile(p0, p1);
            }
        }, (Function3<? super Civilization, ? super Tile, ? super Tile, Float>)new Function3<Civilization, Tile, Tile, Float>((Object)this){

            public final Float invoke(Civilization p0, Tile p1, Tile p2) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                return Float.valueOf(MapPathing.access$roadPreferredMovementCost((MapPathing)this.receiver, p0, p1, p2));
            }
        }, MapPathing::getRoadPath$lambda$0);
    }

    @Readonly
    private final List<Tile> getPath(MapUnit unit, Tile startTile, Tile endTile, Function2<? super MapUnit, ? super Tile, Boolean> predicate, Function3<? super MapUnit, ? super Tile, ? super Tile, Float> cost, Function3<? super MapUnit, ? super Tile, ? super Tile, Float> heuristic) {
        AStar astar = new AStar(startTile, arg_0 -> MapPathing.getPath$lambda$0(predicate, unit, arg_0), (arg_0, arg_1) -> MapPathing.getPath$lambda$1(cost, unit, arg_0, arg_1), (arg_0, arg_1) -> MapPathing.getPath$lambda$2(heuristic, unit, arg_0, arg_1));
        while (true) {
            if (astar.hasEnded()) {
                Log.INSTANCE.debug("getPath failed at AStar search size " + astar.size(), new Object[0]);
                return null;
            }
            if (astar.hasReachedTile(endTile)) break;
            astar.nextStep();
        }
        return CollectionsKt.reversed((Iterable)SequencesKt.toList(astar.getPathTo(endTile)));
    }

    @Readonly
    @Nullable
    public final List<Tile> getConnection(@NotNull Civilization civ, @NotNull Tile startTile, @NotNull Tile endTile, @NotNull Function2<? super Civilization, ? super Tile, Boolean> predicate, @NotNull Function3<? super Civilization, ? super Tile, ? super Tile, Float> cost, @NotNull Function3<? super Civilization, ? super Tile, ? super Tile, Float> heuristic) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(startTile, "startTile");
        Intrinsics.checkNotNullParameter(endTile, "endTile");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Intrinsics.checkNotNullParameter(cost, "cost");
        Intrinsics.checkNotNullParameter(heuristic, "heuristic");
        AStar astar = new AStar(startTile, arg_0 -> MapPathing.getConnection$lambda$2(predicate, civ, arg_0), (arg_0, arg_1) -> MapPathing.getConnection$lambda$3(cost, civ, arg_0, arg_1), (arg_0, arg_1) -> MapPathing.getConnection$lambda$4(heuristic, civ, arg_0, arg_1));
        while (true) {
            if (astar.hasEnded()) {
                Log.INSTANCE.debug("getConnection failed at AStar search size " + astar.size(), new Object[0]);
                return null;
            }
            if (astar.hasReachedTile(endTile)) break;
            astar.nextStep();
        }
        return CollectionsKt.reversed((Iterable)SequencesKt.toList(astar.getPathTo(endTile)));
    }

    public static /* synthetic */ List getConnection$default(MapPathing mapPathing, Civilization civilization, Tile tile, Tile tile2, Function2 function2, Function3 function3, Function3 function32, int n, Object object) {
        if ((n & 0x10) != 0) {
            function3 = MapPathing::getConnection$lambda$0;
        }
        if ((n & 0x20) != 0) {
            function32 = MapPathing::getConnection$lambda$1;
        }
        return mapPathing.getConnection(civilization, tile, tile2, function2, function3, function32);
    }

    private static final float getRoadPath$lambda$0(Civilization civilization, Tile tile, Tile tile2) {
        Intrinsics.checkNotNullParameter(civilization, "<unused var>");
        Intrinsics.checkNotNullParameter(tile, "<unused var>");
        Intrinsics.checkNotNullParameter(tile2, "<unused var>");
        return 0.0f;
    }

    private static final boolean getPath$lambda$0(Function2 $predicate, MapUnit $unit, Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return (Boolean)$predicate.invoke($unit, tile);
    }

    private static final float getPath$lambda$1(Function3 $cost, MapUnit $unit, Tile from, Tile to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        return ((Number)$cost.invoke($unit, from, to)).floatValue();
    }

    private static final float getPath$lambda$2(Function3 $heuristic, MapUnit $unit, Tile from, Tile to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        return ((Number)$heuristic.invoke($unit, from, to)).floatValue();
    }

    private static final float getConnection$lambda$0(Civilization civilization, Tile tile, Tile tile2) {
        Intrinsics.checkNotNullParameter(civilization, "<unused var>");
        Intrinsics.checkNotNullParameter(tile, "<unused var>");
        Intrinsics.checkNotNullParameter(tile2, "<unused var>");
        return 1.0f;
    }

    private static final float getConnection$lambda$1(Civilization civilization, Tile from, Tile to) {
        Intrinsics.checkNotNullParameter(civilization, "<unused var>");
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        return from.aerialDistanceTo(to);
    }

    private static final boolean getConnection$lambda$2(Function2 $predicate, Civilization $civ, Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return (Boolean)$predicate.invoke($civ, tile);
    }

    private static final float getConnection$lambda$3(Function3 $cost, Civilization $civ, Tile from, Tile to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        return ((Number)$cost.invoke($civ, from, to)).floatValue();
    }

    private static final float getConnection$lambda$4(Function3 $heuristic, Civilization $civ, Tile from, Tile to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        return ((Number)$heuristic.invoke($civ, from, to)).floatValue();
    }

    public static final /* synthetic */ float access$roadPreferredMovementCost(MapPathing $this, Civilization civ, Tile from, Tile to) {
        return $this.roadPreferredMovementCost(civ, from, to);
    }
}

