/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.citybutton;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ImmutableColor;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.citybutton.CityButton;
import com.unciv.ui.components.widgets.BorderedTable;
import com.unciv.ui.images.IconTextButtonKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.DebugUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/components/tilegroups/citybutton/CityTable;", "Lcom/unciv/ui/components/widgets/BorderedTable;", "city", "Lcom/unciv/logic/city/City;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "forPopup", "", "<init>", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/civilization/Civilization;Z)V", "addCityPopNumber", "", "addCityGrowthBar", "addCityText", "addCityConstruction", "addCivIcon", "core"})
@SourceDebugExtension(value={"SMAP\nCityTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityTable.kt\ncom/unciv/ui/components/tilegroups/citybutton/CityTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public final class CityTable
extends BorderedTable {
    public CityTable(@NotNull City city, @NotNull Civilization viewingCiv, boolean forPopup) {
        Color color;
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        super("WorldScreen/CityButton/IconTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidBorderShape());
        this.setTransform(false);
        this.setTouchable(Touchable.enabled);
        this.pad(0.0f, 4.0f, 0.0f, 4.0f);
        Civilization selectedCiv = GUI.INSTANCE.getSelectedPlayer();
        if (Intrinsics.areEqual(city.getCiv(), selectedCiv)) {
            this.setBorderOnTop(true);
            this.setBorderSize(4.0f);
            Color color2 = Color.valueOf("#E9E9AC");
            Intrinsics.checkNotNullExpressionValue(color2, "valueOf(...)");
            this.setBgBorderColor(color2);
        } else if (city.getCiv().isAtWarWith(selectedCiv)) {
            this.setBorderSize(4.0f);
            Color color3 = Color.valueOf("#E63200");
            Intrinsics.checkNotNullExpressionValue(color3, "valueOf(...)");
            this.setBgBorderColor(color3);
        } else {
            this.setBorderSize(2.0f);
            this.setBgBorderColor(ImageGetter.INSTANCE.getCHARCOAL());
        }
        Color color4 = color = city.getCiv().getNation().getOuterColor().cpy();
        CityTable cityTable = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.a = 0.9f;
        Color color5 = color;
        Intrinsics.checkNotNullExpressionValue(color5, "apply(...)");
        cityTable.setBgColor(color5);
        boolean isShowDetailedInfo = DebugUtils.INSTANCE.getVISIBLE_MAP() || Intrinsics.areEqual(city.getCiv(), selectedCiv) || viewingCiv.isSpectator();
        this.addCityPopNumber(city);
        if (isShowDetailedInfo) {
            this.addCityGrowthBar(city);
        }
        this.addCityText(city, forPopup);
        if (isShowDetailedInfo) {
            this.addCityConstruction(city);
        }
        if (!Intrinsics.areEqual(city.getCiv(), viewingCiv)) {
            this.addCivIcon(city);
        }
    }

    public /* synthetic */ CityTable(City city, Civilization civilization, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(city, civilization, bl);
    }

    private final void addCityPopNumber(City city) {
        ImmutableColor textColor = city.getCiv().getNation().getInnerColor();
        Label popLabel = Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr(city.getPopulation().getPopulation()), textColor, 18, 1, false, 8, null);
        this.add((Actor)popLabel).minWidth(26.0f);
    }

    private final void addCityGrowthBar(City city) {
        Integer turnsToStarvation;
        Integer turnsToGrowth;
        Table table2 = new Table();
        boolean isGrowing = city.isGrowing();
        boolean isStarving = city.isStarving();
        float growthPercentage = CityTable.addCityGrowthBar$calcGrowthPercentage(city, city.getPopulation().getFoodStored());
        float f = isStarving ? 1.0f : growthPercentage;
        Color color = isStarving ? Color.RED : CityButton.Companion.getColorGrowth();
        Intrinsics.checkNotNull(color);
        ImageGetter.ProgressBar growthBar = ImageGetter.INSTANCE.getProgressBarVertical(4.0f, 30.0f, f, color, ImageGetter.INSTANCE.getCHARCOAL(), 1.0f);
        growthBar.getColor().a = 0.8f;
        if (isGrowing) {
            float nextTurnPercentage = CityTable.addCityGrowthBar$calcGrowthPercentage(city, city.foodForNextTurn() + city.getPopulation().getFoodStored());
            Color color2 = CityButton.Companion.getColorGrowth().cpy();
            Intrinsics.checkNotNullExpressionValue(color2, "cpy(...)");
            growthBar.setSemiProgress(Scene2dExtensionsKt.darken(color2, 0.4f), nextTurnPercentage, 1.0f);
        }
        String string = isGrowing ? ((turnsToGrowth = city.getPopulation().getNumTurnsToNewPopulation()) != null && turnsToGrowth < 100 ? TranslationsKt.tr(turnsToGrowth) : "\u221e") : (isStarving ? ((turnsToStarvation = city.getPopulation().getNumTurnsToStarvation()) != null && turnsToStarvation < 100 ? TranslationsKt.tr(turnsToStarvation) : "\u221e") : "-");
        String turnLabelText = string;
        ImmutableColor textColor = city.getCiv().getNation().getInnerColor();
        Label turnLabel = Scene2dExtensionsKt.toLabel$default(turnLabelText, textColor, 13, 0, false, 12, null);
        table2.add((Actor)growthBar).padRight(2.0f);
        table2.add((Actor)turnLabel).expandY().bottom();
        this.add((Actor)table2).minWidth(6.0f).padLeft(2.0f);
    }

    private final void addCityText(City city, boolean forPopup) {
        Religion cityReligion;
        ImmutableColor textColor = city.getCiv().getNation().getInnerColor();
        Table table2 = new Table();
        Actor $this$addCityText_u24lambda_u240 = table2;
        boolean bl = false;
        ((Group)$this$addCityText_u24lambda_u240).setTransform(false);
        Table table3 = table2;
        if (city.isCapital()) {
            Actor actor;
            if (city.getCiv().isCityState()) {
                Actor $this$addCityText_u24lambda_u241 = $this$addCityText_u24lambda_u240 = ImageGetter.INSTANCE.getNationIcon("CityState");
                boolean bl2 = false;
                $this$addCityText_u24lambda_u241.setColor(textColor);
                actor = $this$addCityText_u24lambda_u240;
            } else {
                actor = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Capital", null, 2, null);
            }
            Image capitalIcon = actor;
            table3.add((Actor)capitalIcon).size(20.0f).padRight(5.0f);
        }
        Label cityName = Scene2dExtensionsKt.toLabel$default(city.getName(), textColor, 0, 1, true, 2, null);
        Cell<Actor> cell = table3.add((Actor)cityName).growY().center();
        Intrinsics.checkNotNullExpressionValue(cell, "center(...)");
        IconTextButtonKt.padTopDescent(cell);
        if (!forPopup && (cityReligion = city.getReligion().getMajorityReligion()) != null) {
            Image image;
            Image $this$addCityText_u24lambda_u242 = image = ImageGetter.INSTANCE.getReligionIcon(cityReligion.getIconName());
            boolean bl3 = false;
            $this$addCityText_u24lambda_u242.setColor(textColor);
            Group religionImage = Scene2dExtensionsKt.toGroup(image, 20.0f);
            table3.add((Actor)religionImage).size(20.0f).padLeft(5.0f);
        }
        table3.pack();
        this.add((Actor)table3).minHeight(34.0f).padLeft(10.0f).padRight(10.0f).expandY().center();
    }

    private final void addCityConstruction(City city) {
        String string;
        ImmutableColor textColor = city.getCiv().getNation().getInnerColor();
        CityConstructions cityConstructions = city.getCityConstructions();
        IConstruction cityCurrentConstruction = cityConstructions.getCurrentConstruction();
        Table progressTable = new Table();
        float nextTurnPercentage = 0.0f;
        float percentage = 0.0f;
        Group icon = ((CharSequence)cityConstructions.currentConstructionName()).length() == 0 ? null : ImageGetter.INSTANCE.getConstructionPortrait(cityCurrentConstruction.getName(), 24.0f);
        IConstruction iConstruction = cityCurrentConstruction;
        if (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getIdle())) {
            string = "-";
        } else if (iConstruction instanceof PerpetualConstruction) {
            string = "\u221e";
        } else {
            Intrinsics.checkNotNull(cityCurrentConstruction, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
            INonPerpetualConstruction cfr_ignored_0 = (INonPerpetualConstruction)cityCurrentConstruction;
            int turnsToConstruction = CityConstructions.turnsToConstruction$default(cityConstructions, cityCurrentConstruction.getName(), false, 2, null);
            float workDone = cityConstructions.getWorkDone(cityCurrentConstruction.getName());
            int cost = ((INonPerpetualConstruction)cityCurrentConstruction).getProductionCost(cityConstructions.getCity().getCiv(), cityConstructions.getCity());
            nextTurnPercentage = CityTable.addCityConstruction$getPercentage(cost, workDone + city.getCityStats().getCurrentCityStats().getProduction());
            percentage = CityTable.addCityConstruction$getPercentage(cost, workDone);
            string = turnsToConstruction < 100 ? TranslationsKt.tr(turnsToConstruction) : "-";
        }
        String turns = string;
        ImageGetter.ProgressBar productionBar = ImageGetter.INSTANCE.getProgressBarVertical(4.0f, 30.0f, percentage, CityButton.Companion.getColorConstruction(), ImageGetter.INSTANCE.getCHARCOAL(), 1.0f);
        Color color = CityButton.Companion.getColorConstruction().cpy();
        Intrinsics.checkNotNullExpressionValue(color, "cpy(...)");
        productionBar.setSemiProgress(Scene2dExtensionsKt.darken(color, 0.4f), nextTurnPercentage, 1.0f);
        productionBar.getColor().a = 0.8f;
        progressTable.add((Actor)Scene2dExtensionsKt.toLabel$default(turns, textColor, 13, 0, false, 12, null)).expandY().bottom();
        progressTable.add((Actor)productionBar).padLeft(2.0f);
        this.add((Actor)progressTable).minWidth(6.0f).padRight(2.0f);
        this.add((Actor)icon).minWidth(26.0f);
    }

    private final void addCivIcon(City city) {
        Image icon = city.getCiv().isMajorCiv() ? ImageGetter.INSTANCE.getNationIcon(city.getCiv().getNation().getName()) : ImageGetter.getImage$default(ImageGetter.INSTANCE, "CityStateIcons/" + city.getCiv().getCityStateType().getName(), null, 2, null);
        icon.setColor(city.getCiv().getNation().getInnerColor());
        this.add((Actor)Scene2dExtensionsKt.toGroup(icon, 20.0f)).minWidth(26.0f);
    }

    private static final float addCityGrowthBar$calcGrowthPercentage(City $city, int food) {
        return RangesKt.coerceIn((float)food / (float)$city.getPopulation().getFoodToNextPopulation(), 0.0f, 1.0f);
    }

    private static final float addCityConstruction$getPercentage(int cost, float done) {
        return RangesKt.coerceIn(done / (float)cost, 0.0f, 1.0f);
    }
}

