/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.stats.Stats;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/images/PortraitImprovement;", "Lcom/unciv/ui/images/Portrait;", "name", "", "size", "", "dim", "", "isPillaged", "<init>", "(Ljava/lang/String;FZZ)V", "getCircleImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getColorFromStats", "Lcom/badlogic/gdx/graphics/Color;", "stats", "Lcom/unciv/models/stats/Stats;", "getDefaultInnerBackgroundTint", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "core"})
@SourceDebugExtension(value={"SMAP\nPortrait.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Portrait.kt\ncom/unciv/ui/images/PortraitImprovement\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,314:1\n2275#2,2:315\n1463#2,14:317\n*S KotlinDebug\n*F\n+ 1 Portrait.kt\ncom/unciv/ui/images/PortraitImprovement\n*L\n229#1:315,2\n231#1:317,14\n*E\n"})
public final class PortraitImprovement
extends Portrait {
    public PortraitImprovement(@NotNull String name, float size, boolean dim, boolean isPillaged) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(Portrait.Type.Improvement, name, size, 0.0f, 8, null);
        if (dim) {
            this.getImage().getColor().a = 0.7f;
            this.getBackground().getColor().a = 0.7f;
        }
        if (isPillaged) {
            Image pillagedIcon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Fire", null, 2, null);
            pillagedIcon.setSize(this.getWidth() / (float)2, this.getHeight() / (float)2);
            pillagedIcon.setPosition(this.getWidth(), 0.0f, 20);
            this.addActor(pillagedIcon);
        }
    }

    public /* synthetic */ PortraitImprovement(String string, float f, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(string, f, bl, bl2);
    }

    @Override
    @NotNull
    protected Image getCircleImage() {
        return ImageGetter.getImage$default(ImageGetter.INSTANCE, "ImprovementIcons/Circle", null, 2, null);
    }

    private final Color getColorFromStats(Stats stats) {
        Stats.StatValuePair statValuePair;
        boolean bl;
        Stats.StatValuePair it;
        block7: {
            Sequence<Stats.StatValuePair> $this$none$iv = stats.asSequence();
            boolean $i$f$none = false;
            Iterator<Stats.StatValuePair> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Stats.StatValuePair element$iv;
                it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(it.getValue() > 0.0f)) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (bl) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            return color;
        }
        Sequence<Stats.StatValuePair> $this$maxByOrNull$iv = stats.asSequence();
        boolean $i$f$maxByOrNull = false;
        Iterator<Stats.StatValuePair> iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            statValuePair = null;
        } else {
            Stats.StatValuePair maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                statValuePair = maxElem$iv;
            } else {
                it = maxElem$iv;
                boolean bl3 = false;
                float maxValue$iv = it.getValue();
                do {
                    Stats.StatValuePair e$iv;
                    Stats.StatValuePair it2 = e$iv = iterator$iv.next();
                    $i$a$-maxByOrNull-PortraitImprovement$getColorFromStats$2 = false;
                    float v$iv = it2.getValue();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                statValuePair = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(statValuePair);
        return ((Stats.StatValuePair)statValuePair).getKey().getColor();
    }

    @Override
    @NotNull
    public Color getDefaultInnerBackgroundTint() {
        TileImprovement improvement = ImageGetter.INSTANCE.getRuleset().getTileImprovements().get(this.getImageName());
        if (improvement != null) {
            return this.getColorFromStats(improvement);
        }
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        return color;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }
}

