/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.status;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.UncivGame;
import com.unciv.logic.AlternatingStateManager;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.multiplayer.HasMultiplayerGameName;
import com.unciv.logic.multiplayer.MultiplayerGameNameChanged;
import com.unciv.logic.multiplayer.MultiplayerGamePreview;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateEnded;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateStarted;
import com.unciv.logic.multiplayer.MultiplayerGameUpdated;
import com.unciv.logic.multiplayer.MultiplayerKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.LoadingImage;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.status.MultiplayerStatusPopup;
import com.unciv.ui.screens.worldscreen.status.TurnIndicator;
import com.unciv.utils.Concurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cH\u0002J\u0012\u0010\u001d\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0017H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/MultiplayerStatusButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "Lcom/badlogic/gdx/utils/Disposable;", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "curGame", "Lcom/unciv/logic/multiplayer/MultiplayerGamePreview;", "<init>", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;Lcom/unciv/logic/multiplayer/MultiplayerGamePreview;)V", "curGameName", "", "loadingImage", "Lcom/unciv/ui/components/widgets/LoadingImage;", "turnIndicator", "Lcom/unciv/ui/screens/worldscreen/status/TurnIndicator;", "turnIndicatorCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "gameNamesWithCurrentTurn", "", "events", "Lcom/unciv/logic/event/EventBus$EventReceiver;", "startLoading", "", "stopLoading", "getInitialGamesWithCurrentTurn", "findGamesToBeNotifiedAbout", "games", "", "updateTurnIndicator", "flash", "", "dispose", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerStatusButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerStatusButton.kt\ncom/unciv/ui/screens/worldscreen/status/MultiplayerStatusButton\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n774#2:153\n865#2,2:154\n774#2:156\n865#2,2:157\n1563#2:159\n1634#2,3:160\n*S KotlinDebug\n*F\n+ 1 MultiplayerStatusButton.kt\ncom/unciv/ui/screens/worldscreen/status/MultiplayerStatusButton\n*L\n92#1:153\n92#1:154,2\n93#1:156\n93#1:157,2\n94#1:159\n94#1:160,3\n*E\n"})
public final class MultiplayerStatusButton
extends Button
implements Disposable {
    @Nullable
    private String curGameName;
    @NotNull
    private final LoadingImage loadingImage;
    @NotNull
    private final TurnIndicator turnIndicator;
    @NotNull
    private final Cell<Actor> turnIndicatorCell;
    @NotNull
    private final Set<String> gameNamesWithCurrentTurn;
    @NotNull
    private final EventBus.EventReceiver events;

    public MultiplayerStatusButton(@NotNull BaseScreen screen, @Nullable MultiplayerGamePreview curGame) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        super(BaseScreen.Companion.getSkin());
        MultiplayerGamePreview multiplayerGamePreview = curGame;
        this.curGameName = multiplayerGamePreview != null ? multiplayerGamePreview.getName() : null;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        Color color2 = color;
        this.loadingImage = new LoadingImage(0.0f, new LoadingImage.Style(null, null, color2, 500, null, "OtherIcons/Multiplayer", null, 0.0f, 0.0f, 0.0f, 0.0f, 2003, null), 1, null);
        this.turnIndicator = new TurnIndicator();
        this.gameNamesWithCurrentTurn = this.getInitialGamesWithCurrentTurn();
        this.events = new EventBus.EventReceiver();
        Cell cell = this.add().padTop(10.0f).padBottom(10.0f);
        Intrinsics.checkNotNullExpressionValue(cell, "padBottom(...)");
        this.turnIndicatorCell = cell;
        this.add((Actor)this.loadingImage).pad(5.0f);
        this.updateTurnIndicator(false);
        EventBus.EventReceiver.receive$default(this.events, Reflection.getOrCreateKotlinClass(MultiplayerGameUpdated.class), null, arg_0 -> MultiplayerStatusButton._init_$lambda$0(this, arg_0), 2, null);
        Function1<HasMultiplayerGameName, Boolean> curGameFilter = arg_0 -> MultiplayerStatusButton._init_$lambda$1(this, arg_0);
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameNameChanged.class), curGameFilter, arg_0 -> MultiplayerStatusButton._init_$lambda$2(this, arg_0));
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdateStarted.class), curGameFilter, arg_0 -> MultiplayerStatusButton._init_$lambda$3(this, arg_0));
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdateEnded.class), curGameFilter, arg_0 -> MultiplayerStatusButton._init_$lambda$4(this, arg_0));
        ActivationExtensionsKt.onClick(this, () -> MultiplayerStatusButton._init_$lambda$5(screen));
    }

    private final void startLoading() {
        this.loadingImage.show();
    }

    private final void stopLoading() {
        LoadingImage.hide$default(this.loadingImage, null, 1, null);
    }

    private final Set<String> getInitialGamesWithCurrentTurn() {
        return this.findGamesToBeNotifiedAbout((Iterable<MultiplayerGamePreview>)UncivGame.Companion.getCurrent().getOnlineMultiplayer().getGames());
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> findGamesToBeNotifiedAbout(Iterable<MultiplayerGamePreview> games) {
        void $this$mapTo$iv$iv;
        MultiplayerGamePreview it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = games;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MultiplayerGamePreview)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getName(), this.curGameName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MultiplayerGamePreview)element$iv$iv;
            boolean bl = false;
            GameInfoPreview gameInfoPreview = it.getPreview();
            boolean bl2 = gameInfoPreview != null ? MultiplayerKt.isUsersTurn(gameInfoPreview) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MultiplayerGamePreview)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toMutableSet((List)destination$iv$iv);
    }

    private final void updateTurnIndicator(boolean flash) {
        if (this.gameNamesWithCurrentTurn.isEmpty()) {
            this.turnIndicatorCell.clearActor();
        } else {
            this.turnIndicatorCell.setActor((Actor)this.turnIndicator);
            this.turnIndicator.update(this.gameNamesWithCurrentTurn.size());
        }
        if (flash) {
            AlternatingStateManager.start-QTBD994$default(this.turnIndicator.getFlash(), DurationKt.toDuration(3, DurationUnit.SECONDS), 0L, 2, null);
        }
    }

    static /* synthetic */ void updateTurnIndicator$default(MultiplayerStatusButton multiplayerStatusButton, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        multiplayerStatusButton.updateTurnIndicator(bl);
    }

    @Override
    public void dispose() {
        this.events.stopReceiving();
        this.turnIndicator.dispose();
        this.loadingImage.dispose();
    }

    private static final Unit _init_$lambda$0(MultiplayerStatusButton this$0, MultiplayerGameUpdated it) {
        boolean shouldUpdate;
        Intrinsics.checkNotNullParameter(it, "it");
        boolean bl = shouldUpdate = MultiplayerKt.isUsersTurn(it.getPreview()) ? this$0.gameNamesWithCurrentTurn.add(it.getName()) : this$0.gameNamesWithCurrentTurn.remove(it.getName());
        if (shouldUpdate) {
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                int label;
                final /* synthetic */ MultiplayerStatusButton this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            MultiplayerStatusButton.updateTurnIndicator$default(this.this$0, false, 1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$1(MultiplayerStatusButton this$0, HasMultiplayerGameName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getName(), this$0.curGameName);
    }

    private static final Unit _init_$lambda$2(MultiplayerStatusButton this$0, MultiplayerGameNameChanged it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.curGameName = it.getNewName();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(MultiplayerStatusButton this$0, MultiplayerGameUpdateStarted it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.startLoading();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(MultiplayerStatusButton this$0, MultiplayerGameUpdateEnded it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.stopLoading();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(BaseScreen $screen) {
        Popup.open$default(new MultiplayerStatusPopup($screen), false, 1, null);
        return Unit.INSTANCE;
    }
}

