// SPDX-FileCopyrightText: 2025 Manuel Schneider
// SPDX-License-Identifier: MIT

#pragma once
#include <QString>
#include <albert/export.h>
#include <albert/querycontext.h>
class QueryEngine;
namespace albert
{
class QueryHandler;
class QueryResult;
class QueryResults;
class QueryExecution;
}  // namespace albert

namespace albert::detail
{

/// The query implementation.
class ALBERT_EXPORT Query : public albert::QueryContext
{
public:
    /// Constructs a query.
    Query(UsageScoring usage_scoring,
          std::vector<albert::QueryResult> &&fallbacks,
          QueryHandler &handler,
          QString trigger,
          QString string);

    /// Destructs the query.
    ~Query();

    /// \copydoc albert::Query::isValid
    bool isValid() const override;

    /// \copydoc albert::Query::handler
    QueryHandler &handler() const override;

    /// \copydoc albert::Query::trigger
    QString trigger() const override;

    /// \copydoc albert::Query::query
    QString query() const override;

    /// \copydoc albert::Query::usageScoring
    const UsageScoring &usageScoring() const override;

    /// Returns the execution of this query if running; else nullptr.
    QueryExecution &execution() const;

    /// Stops the query execution.
    void cancel();

    /// Returns the matches.
    QueryResults &matches();

    /// Returns the fallbacks.
    QueryResults &fallbacks();

private:
    class Private;
    std::unique_ptr<Private> d;
};

}  // namespace albert::detail
