# -*- coding: utf-8 -*-
# Copyright (c) 2024 Manuel Schneider

import albert

md_iid = "5.0"
md_version = "3.1.1"
md_name = "Zeal"
md_description = "Search in Zeal docs"
md_license = "MIT"
md_url = "https://github.com/albertlauncher/albert-plugin-python-zeal"
md_authors = ["@ManuelSchneid3r"]
md_bin_dependencies = ['zeal']

def createItem(query: str):
    return albert.StandardItem(
        id=md_name,
        text=md_name,
        subtext=f"Search '{query}' in Zeal",
        icon_factory=lambda: albert.makeThemeIcon("zeal"),
        actions=[albert.Action("zeal", "Search in Zeal",
                               lambda q=query: albert.runDetachedProcess(['zeal', q]))]
    )

class FBH(albert.FallbackHandler):

    def id(self):
        return "zeal_fbh"

    def name(self):
        return md_name

    def description(self):
        return md_description

    def fallbacks(self, s):
        return [createItem(s)] if s else []


class Plugin(albert.PluginInstance, albert.GeneratorQueryHandler):

    def __init__(self):
        albert.PluginInstance.__init__(self)
        albert.GeneratorQueryHandler.__init__(self)
        self.fbh = FBH()

    def defaultTrigger(self):
        return "z "

    def extensions(self):
        return [self, self.fbh]

    def items(self, ctx):
        if query := ctx.query.strip():
            yield [createItem(query)]
