
#[repr(u32)]
#[derive(SettingsSchema, Serialize, Deserialize, Clone, Copy, Debug)]
pub enum OpenvrPropKey {
    TrackingSystemNameString = 1000,
    ModelNumberString = 1001,
    SerialNumberString = 1002,
    RenderModelNameString = 1003,
    WillDriftInYawBool = 1004,
    ManufacturerNameString = 1005,
    TrackingFirmwareVersionString = 1006,
    HardwareRevisionString = 1007,
    AllWirelessDongleDescriptionsString = 1008,
    ConnectedWirelessDongleString = 1009,
    DeviceIsWirelessBool = 1010,
    DeviceIsChargingBool = 1011,
    DeviceBatteryPercentageFloat = 1012,
    FirmwareUpdateAvailableBool = 1014,
    FirmwareManualUpdateBool = 1015,
    FirmwareManualUpdateURLString = 1016,
    HardwareRevisionUint64 = 1017,
    FirmwareVersionUint64 = 1018,
    FPGAVersionUint64 = 1019,
    VRCVersionUint64 = 1020,
    RadioVersionUint64 = 1021,
    DongleVersionUint64 = 1022,
    BlockServerShutdownBool = 1023,
    CanUnifyCoordinateSystemWithHmdBool = 1024,
    ContainsProximitySensorBool = 1025,
    DeviceProvidesBatteryStatusBool = 1026,
    DeviceCanPowerOffBool = 1027,
    FirmwareProgrammingTargetString = 1028,
    DeviceClassInt32 = 1029,
    HasCameraBool = 1030,
    DriverVersionString = 1031,
    FirmwareForceUpdateRequiredBool = 1032,
    ViveSystemButtonFixRequiredBool = 1033,
    ParentDriverUint64 = 1034,
    ResourceRootString = 1035,
    RegisteredDeviceTypeString = 1036,
    InputProfilePathString = 1037,
    NeverTrackedBool = 1038,
    NumCamerasInt32 = 1039,
    CameraFrameLayoutInt32 = 1040,
    CameraStreamFormatInt32 = 1041,
    AdditionalDeviceSettingsPathString = 1042,
    IdentifiableBool = 1043,
    BootloaderVersionUint64 = 1044,
    AdditionalSystemReportDataString = 1045,
    CompositeFirmwareVersionString = 1046,
    FirmwareRemindUpdateBool = 1047,
    PeripheralApplicationVersionUint64 = 1048,
    ManufacturerSerialNumberString = 1049,
    ComputedSerialNumberString = 1050,
    EstimatedDeviceFirstUseTimeInt32 = 1051,
    ReportsTimeSinceVSyncBool = 2000,
    SecondsFromVsyncToPhotonsFloat = 2001,
    DisplayFrequencyFloat = 2002,
    UserIpdMetersFloat = 2003,
    CurrentUniverseIdUint64 = 2004,
    PreviousUniverseIdUint64 = 2005,
    DisplayFirmwareVersionUint64 = 2006,
    IsOnDesktopBool = 2007,
    DisplayMCTypeInt32 = 2008,
    DisplayMCOffsetFloat = 2009,
    DisplayMCScaleFloat = 2010,
    EdidVendorIDInt32 = 2011,
    DisplayMCImageLeftString = 2012,
    DisplayMCImageRightString = 2013,
    DisplayGCBlackClampFloat = 2014,
    EdidProductIDInt32 = 2015,
    DisplayGCTypeInt32 = 2017,
    DisplayGCOffsetFloat = 2018,
    DisplayGCScaleFloat = 2019,
    DisplayGCPrescaleFloat = 2020,
    DisplayGCImageString = 2021,
    LensCenterLeftUFloat = 2022,
    LensCenterLeftVFloat = 2023,
    LensCenterRightUFloat = 2024,
    LensCenterRightVFloat = 2025,
    UserHeadToEyeDepthMetersFloat = 2026,
    CameraFirmwareVersionUint64 = 2027,
    CameraFirmwareDescriptionString = 2028,
    DisplayFPGAVersionUint64 = 2029,
    DisplayBootloaderVersionUint64 = 2030,
    DisplayHardwareVersionUint64 = 2031,
    AudioFirmwareVersionUint64 = 2032,
    CameraCompatibilityModeInt32 = 2033,
    ScreenshotHorizontalFieldOfViewDegreesFloat = 2034,
    ScreenshotVerticalFieldOfViewDegreesFloat = 2035,
    DisplaySuppressedBool = 2036,
    DisplayAllowNightModeBool = 2037,
    DisplayMCImageWidthInt32 = 2038,
    DisplayMCImageHeightInt32 = 2039,
    DisplayMCImageNumChannelsInt32 = 2040,
    SecondsFromPhotonsToVblankFloat = 2042,
    DriverDirectModeSendsVsyncEventsBool = 2043,
    DisplayDebugModeBool = 2044,
    GraphicsAdapterLuidUint64 = 2045,
    DriverProvidedChaperonePathString = 2048,
    ExpectedTrackingReferenceCountInt32 = 2049,
    ExpectedControllerCountInt32 = 2050,
    NamedIconPathControllerLeftDeviceOffString = 2051,
    NamedIconPathControllerRightDeviceOffString = 2052,
    NamedIconPathTrackingReferenceDeviceOffString = 2053,
    DoNotApplyPredictionBool = 2054,
    DistortionMeshResolutionInt32 = 2056,
    DriverIsDrawingControllersBool = 2057,
    DriverRequestsApplicationPauseBool = 2058,
    DriverRequestsReducedRenderingBool = 2059,
    MinimumIpdStepMetersFloat = 2060,
    AudioBridgeFirmwareVersionUint64 = 2061,
    ImageBridgeFirmwareVersionUint64 = 2062,
    ImuFactoryGyroBiasVector3 = 2064,
    ImuFactoryGyroScaleVector3 = 2065,
    ImuFactoryAccelerometerBiasVector3 = 2066,
    ImuFactoryAccelerometerScaleVector3 = 2067,
    ConfigurationIncludesLighthouse20FeaturesBool = 2069,
    AdditionalRadioFeaturesUint64 = 2070,
    ExpectedControllerTypeString = 2074,
    HmdTrackingStyleInt32 = 2075,
    DriverProvidedChaperoneVisibilityBool = 2076,
    HmdColumnCorrectionSettingPrefixString = 2077,
    CameraSupportsCompatibilityModesBool = 2078,
    SupportsRoomViewDepthProjectionBool = 2079,
    DisplaySupportsMultipleFrameratesBool = 2081,
    DisplayColorMultLeftVector3 = 2082,
    DisplayColorMultRightVector3 = 2083,
    DisplaySupportsRuntimeFramerateChangeBool = 2084,
    DisplaySupportsAnalogGainBool = 2085,
    DisplayMinAnalogGainFloat = 2086,
    DisplayMaxAnalogGainFloat = 2087,
    DashboardScaleFloat = 2091,
    IpdUIRangeMinMetersFloat = 2100,
    IpdUIRangeMaxMetersFloat = 2101,
    HmdSupportsHDCP14LegacyCompatBool = 2102,
    HmdSupportsMicMonitoringBool = 2103,
    DriverRequestedMuraCorrectionModeInt32 = 2200,
    DriverRequestedMuraFeatherInnerLeftInt32 = 2201,
    DriverRequestedMuraFeatherInnerRightInt32 = 2202,
    DriverRequestedMuraFeatherInnerTopInt32 = 2203,
    DriverRequestedMuraFeatherInnerBottomInt32 = 2204,
    DriverRequestedMuraFeatherOuterLeftInt32 = 2205,
    DriverRequestedMuraFeatherOuterRightInt32 = 2206,
    DriverRequestedMuraFeatherOuterTopInt32 = 2207,
    DriverRequestedMuraFeatherOuterBottomInt32 = 2208,
    AudioDefaultPlaybackDeviceIdString = 2300,
    AudioDefaultRecordingDeviceIdString = 2301,
    AudioDefaultPlaybackDeviceVolumeFloat = 2302,
    AudioSupportsDualSpeakerAndJackOutputBool = 2303,
    AttachedDeviceIdString = 3000,
    SupportedButtonsUint64 = 3001,
    Axis0TypeInt32 = 3002,
    Axis1TypeInt32 = 3003,
    Axis2TypeInt32 = 3004,
    Axis3TypeInt32 = 3005,
    Axis4TypeInt32 = 3006,
    ControllerRoleHintInt32 = 3007,
    FieldOfViewLeftDegreesFloat = 4000,
    FieldOfViewRightDegreesFloat = 4001,
    FieldOfViewTopDegreesFloat = 4002,
    FieldOfViewBottomDegreesFloat = 4003,
    TrackingRangeMinimumMetersFloat = 4004,
    TrackingRangeMaximumMetersFloat = 4005,
    ModeLabelString = 4006,
    CanWirelessIdentifyBool = 4007,
    NonceInt32 = 4008,
    IconPathNameString = 5000,
    NamedIconPathDeviceOffString = 5001,
    NamedIconPathDeviceSearchingString = 5002,
    NamedIconPathDeviceSearchingAlertString = 5003,
    NamedIconPathDeviceReadyString = 5004,
    NamedIconPathDeviceReadyAlertString = 5005,
    NamedIconPathDeviceNotReadyString = 5006,
    NamedIconPathDeviceStandbyString = 5007,
    NamedIconPathDeviceAlertLowString = 5008,
    NamedIconPathDeviceStandbyAlertString = 5009,
    OverrideContainerUint64 = 5152,
    UserConfigPathString = 6000,
    InstallPathString = 6001,
    HasDisplayComponentBool = 6002,
    HasControllerComponentBool = 6003,
    HasCameraComponentBool = 6004,
    HasDriverDirectModeComponentBool = 6005,
    HasVirtualDisplayComponentBool = 6006,
    HasSpatialAnchorsSupportBool = 6007,
    ControllerTypeString = 7000,
    ControllerHandSelectionPriorityInt32 = 7002,
}

#[expect(clippy::match_same_arms)]
pub fn openvr_prop_key_to_type(key: OpenvrPropKey) -> OpenvrPropType {
    match key {
        OpenvrPropKey::TrackingSystemNameString => OpenvrPropType::String,
        OpenvrPropKey::ModelNumberString => OpenvrPropType::String,
        OpenvrPropKey::SerialNumberString => OpenvrPropType::String,
        OpenvrPropKey::RenderModelNameString => OpenvrPropType::String,
        OpenvrPropKey::WillDriftInYawBool => OpenvrPropType::Bool,
        OpenvrPropKey::ManufacturerNameString => OpenvrPropType::String,
        OpenvrPropKey::TrackingFirmwareVersionString => OpenvrPropType::String,
        OpenvrPropKey::HardwareRevisionString => OpenvrPropType::String,
        OpenvrPropKey::AllWirelessDongleDescriptionsString => OpenvrPropType::String,
        OpenvrPropKey::ConnectedWirelessDongleString => OpenvrPropType::String,
        OpenvrPropKey::DeviceIsWirelessBool => OpenvrPropType::Bool,
        OpenvrPropKey::DeviceIsChargingBool => OpenvrPropType::Bool,
        OpenvrPropKey::DeviceBatteryPercentageFloat => OpenvrPropType::Float,
        OpenvrPropKey::FirmwareUpdateAvailableBool => OpenvrPropType::Bool,
        OpenvrPropKey::FirmwareManualUpdateBool => OpenvrPropType::Bool,
        OpenvrPropKey::FirmwareManualUpdateURLString => OpenvrPropType::String,
        OpenvrPropKey::HardwareRevisionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::FirmwareVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::FPGAVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::VRCVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::RadioVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::DongleVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::BlockServerShutdownBool => OpenvrPropType::Bool,
        OpenvrPropKey::CanUnifyCoordinateSystemWithHmdBool => OpenvrPropType::Bool,
        OpenvrPropKey::ContainsProximitySensorBool => OpenvrPropType::Bool,
        OpenvrPropKey::DeviceProvidesBatteryStatusBool => OpenvrPropType::Bool,
        OpenvrPropKey::DeviceCanPowerOffBool => OpenvrPropType::Bool,
        OpenvrPropKey::FirmwareProgrammingTargetString => OpenvrPropType::String,
        OpenvrPropKey::DeviceClassInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::HasCameraBool => OpenvrPropType::Bool,
        OpenvrPropKey::DriverVersionString => OpenvrPropType::String,
        OpenvrPropKey::FirmwareForceUpdateRequiredBool => OpenvrPropType::Bool,
        OpenvrPropKey::ViveSystemButtonFixRequiredBool => OpenvrPropType::Bool,
        OpenvrPropKey::ParentDriverUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::ResourceRootString => OpenvrPropType::String,
        OpenvrPropKey::RegisteredDeviceTypeString => OpenvrPropType::String,
        OpenvrPropKey::InputProfilePathString => OpenvrPropType::String,
        OpenvrPropKey::NeverTrackedBool => OpenvrPropType::Bool,
        OpenvrPropKey::NumCamerasInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::CameraFrameLayoutInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::CameraStreamFormatInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::AdditionalDeviceSettingsPathString => OpenvrPropType::String,
        OpenvrPropKey::IdentifiableBool => OpenvrPropType::Bool,
        OpenvrPropKey::BootloaderVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::AdditionalSystemReportDataString => OpenvrPropType::String,
        OpenvrPropKey::CompositeFirmwareVersionString => OpenvrPropType::String,
        OpenvrPropKey::FirmwareRemindUpdateBool => OpenvrPropType::Bool,
        OpenvrPropKey::PeripheralApplicationVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::ManufacturerSerialNumberString => OpenvrPropType::String,
        OpenvrPropKey::ComputedSerialNumberString => OpenvrPropType::String,
        OpenvrPropKey::EstimatedDeviceFirstUseTimeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::ReportsTimeSinceVSyncBool => OpenvrPropType::Bool,
        OpenvrPropKey::SecondsFromVsyncToPhotonsFloat => OpenvrPropType::Float,
        OpenvrPropKey::DisplayFrequencyFloat => OpenvrPropType::Float,
        OpenvrPropKey::UserIpdMetersFloat => OpenvrPropType::Float,
        OpenvrPropKey::CurrentUniverseIdUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::PreviousUniverseIdUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::DisplayFirmwareVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::IsOnDesktopBool => OpenvrPropType::Bool,
        OpenvrPropKey::DisplayMCTypeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DisplayMCOffsetFloat => OpenvrPropType::Float,
        OpenvrPropKey::DisplayMCScaleFloat => OpenvrPropType::Float,
        OpenvrPropKey::EdidVendorIDInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DisplayMCImageLeftString => OpenvrPropType::String,
        OpenvrPropKey::DisplayMCImageRightString => OpenvrPropType::String,
        OpenvrPropKey::DisplayGCBlackClampFloat => OpenvrPropType::Float,
        OpenvrPropKey::EdidProductIDInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DisplayGCTypeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DisplayGCOffsetFloat => OpenvrPropType::Float,
        OpenvrPropKey::DisplayGCScaleFloat => OpenvrPropType::Float,
        OpenvrPropKey::DisplayGCPrescaleFloat => OpenvrPropType::Float,
        OpenvrPropKey::DisplayGCImageString => OpenvrPropType::String,
        OpenvrPropKey::LensCenterLeftUFloat => OpenvrPropType::Float,
        OpenvrPropKey::LensCenterLeftVFloat => OpenvrPropType::Float,
        OpenvrPropKey::LensCenterRightUFloat => OpenvrPropType::Float,
        OpenvrPropKey::LensCenterRightVFloat => OpenvrPropType::Float,
        OpenvrPropKey::UserHeadToEyeDepthMetersFloat => OpenvrPropType::Float,
        OpenvrPropKey::CameraFirmwareVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::CameraFirmwareDescriptionString => OpenvrPropType::String,
        OpenvrPropKey::DisplayFPGAVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::DisplayBootloaderVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::DisplayHardwareVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::AudioFirmwareVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::CameraCompatibilityModeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::ScreenshotHorizontalFieldOfViewDegreesFloat => OpenvrPropType::Float,
        OpenvrPropKey::ScreenshotVerticalFieldOfViewDegreesFloat => OpenvrPropType::Float,
        OpenvrPropKey::DisplaySuppressedBool => OpenvrPropType::Bool,
        OpenvrPropKey::DisplayAllowNightModeBool => OpenvrPropType::Bool,
        OpenvrPropKey::DisplayMCImageWidthInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DisplayMCImageHeightInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DisplayMCImageNumChannelsInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::SecondsFromPhotonsToVblankFloat => OpenvrPropType::Float,
        OpenvrPropKey::DriverDirectModeSendsVsyncEventsBool => OpenvrPropType::Bool,
        OpenvrPropKey::DisplayDebugModeBool => OpenvrPropType::Bool,
        OpenvrPropKey::GraphicsAdapterLuidUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::DriverProvidedChaperonePathString => OpenvrPropType::String,
        OpenvrPropKey::ExpectedTrackingReferenceCountInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::ExpectedControllerCountInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::NamedIconPathControllerLeftDeviceOffString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathControllerRightDeviceOffString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathTrackingReferenceDeviceOffString => OpenvrPropType::String,
        OpenvrPropKey::DoNotApplyPredictionBool => OpenvrPropType::Bool,
        OpenvrPropKey::DistortionMeshResolutionInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverIsDrawingControllersBool => OpenvrPropType::Bool,
        OpenvrPropKey::DriverRequestsApplicationPauseBool => OpenvrPropType::Bool,
        OpenvrPropKey::DriverRequestsReducedRenderingBool => OpenvrPropType::Bool,
        OpenvrPropKey::MinimumIpdStepMetersFloat => OpenvrPropType::Float,
        OpenvrPropKey::AudioBridgeFirmwareVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::ImageBridgeFirmwareVersionUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::ImuFactoryGyroBiasVector3 => OpenvrPropType::Vector3,
        OpenvrPropKey::ImuFactoryGyroScaleVector3 => OpenvrPropType::Vector3,
        OpenvrPropKey::ImuFactoryAccelerometerBiasVector3 => OpenvrPropType::Vector3,
        OpenvrPropKey::ImuFactoryAccelerometerScaleVector3 => OpenvrPropType::Vector3,
        OpenvrPropKey::ConfigurationIncludesLighthouse20FeaturesBool => OpenvrPropType::Bool,
        OpenvrPropKey::AdditionalRadioFeaturesUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::ExpectedControllerTypeString => OpenvrPropType::String,
        OpenvrPropKey::HmdTrackingStyleInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverProvidedChaperoneVisibilityBool => OpenvrPropType::Bool,
        OpenvrPropKey::HmdColumnCorrectionSettingPrefixString => OpenvrPropType::String,
        OpenvrPropKey::CameraSupportsCompatibilityModesBool => OpenvrPropType::Bool,
        OpenvrPropKey::SupportsRoomViewDepthProjectionBool => OpenvrPropType::Bool,
        OpenvrPropKey::DisplaySupportsMultipleFrameratesBool => OpenvrPropType::Bool,
        OpenvrPropKey::DisplayColorMultLeftVector3 => OpenvrPropType::Vector3,
        OpenvrPropKey::DisplayColorMultRightVector3 => OpenvrPropType::Vector3,
        OpenvrPropKey::DisplaySupportsRuntimeFramerateChangeBool => OpenvrPropType::Bool,
        OpenvrPropKey::DisplaySupportsAnalogGainBool => OpenvrPropType::Bool,
        OpenvrPropKey::DisplayMinAnalogGainFloat => OpenvrPropType::Float,
        OpenvrPropKey::DisplayMaxAnalogGainFloat => OpenvrPropType::Float,
        OpenvrPropKey::DashboardScaleFloat => OpenvrPropType::Float,
        OpenvrPropKey::IpdUIRangeMinMetersFloat => OpenvrPropType::Float,
        OpenvrPropKey::IpdUIRangeMaxMetersFloat => OpenvrPropType::Float,
        OpenvrPropKey::HmdSupportsHDCP14LegacyCompatBool => OpenvrPropType::Bool,
        OpenvrPropKey::HmdSupportsMicMonitoringBool => OpenvrPropType::Bool,
        OpenvrPropKey::DriverRequestedMuraCorrectionModeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverRequestedMuraFeatherInnerLeftInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverRequestedMuraFeatherInnerRightInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverRequestedMuraFeatherInnerTopInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverRequestedMuraFeatherInnerBottomInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverRequestedMuraFeatherOuterLeftInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverRequestedMuraFeatherOuterRightInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverRequestedMuraFeatherOuterTopInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::DriverRequestedMuraFeatherOuterBottomInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::AudioDefaultPlaybackDeviceIdString => OpenvrPropType::String,
        OpenvrPropKey::AudioDefaultRecordingDeviceIdString => OpenvrPropType::String,
        OpenvrPropKey::AudioDefaultPlaybackDeviceVolumeFloat => OpenvrPropType::Float,
        OpenvrPropKey::AudioSupportsDualSpeakerAndJackOutputBool => OpenvrPropType::Bool,
        OpenvrPropKey::AttachedDeviceIdString => OpenvrPropType::String,
        OpenvrPropKey::SupportedButtonsUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::Axis0TypeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::Axis1TypeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::Axis2TypeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::Axis3TypeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::Axis4TypeInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::ControllerRoleHintInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::FieldOfViewLeftDegreesFloat => OpenvrPropType::Float,
        OpenvrPropKey::FieldOfViewRightDegreesFloat => OpenvrPropType::Float,
        OpenvrPropKey::FieldOfViewTopDegreesFloat => OpenvrPropType::Float,
        OpenvrPropKey::FieldOfViewBottomDegreesFloat => OpenvrPropType::Float,
        OpenvrPropKey::TrackingRangeMinimumMetersFloat => OpenvrPropType::Float,
        OpenvrPropKey::TrackingRangeMaximumMetersFloat => OpenvrPropType::Float,
        OpenvrPropKey::ModeLabelString => OpenvrPropType::String,
        OpenvrPropKey::CanWirelessIdentifyBool => OpenvrPropType::Bool,
        OpenvrPropKey::NonceInt32 => OpenvrPropType::Int32,
        OpenvrPropKey::IconPathNameString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceOffString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceSearchingString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceSearchingAlertString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceReadyString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceReadyAlertString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceNotReadyString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceStandbyString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceAlertLowString => OpenvrPropType::String,
        OpenvrPropKey::NamedIconPathDeviceStandbyAlertString => OpenvrPropType::String,
        OpenvrPropKey::OverrideContainerUint64 => OpenvrPropType::Uint64,
        OpenvrPropKey::UserConfigPathString => OpenvrPropType::String,
        OpenvrPropKey::InstallPathString => OpenvrPropType::String,
        OpenvrPropKey::HasDisplayComponentBool => OpenvrPropType::Bool,
        OpenvrPropKey::HasControllerComponentBool => OpenvrPropType::Bool,
        OpenvrPropKey::HasCameraComponentBool => OpenvrPropType::Bool,
        OpenvrPropKey::HasDriverDirectModeComponentBool => OpenvrPropType::Bool,
        OpenvrPropKey::HasVirtualDisplayComponentBool => OpenvrPropType::Bool,
        OpenvrPropKey::HasSpatialAnchorsSupportBool => OpenvrPropType::Bool,
        OpenvrPropKey::ControllerTypeString => OpenvrPropType::String,
        OpenvrPropKey::ControllerHandSelectionPriorityInt32 => OpenvrPropType::Int32,
    }
}
